#include "gnome_chess.h"

timer* gnomechess_timer_new() {
	timer *tmr;
	
	tmr = malloc(sizeof(timer));
	tmr->sec = 0;
	tmr->handlerid = -1;
	tmr->label = gtk_label_new(_("0:00"));
	return tmr;
}

timer* gnomechess_timer_new_time(int sec) {
	timer *tmr;
	
	tmr =gnomechess_timer_new();
	tmr->sec = sec;
	gnomechess_timer_set(tmr, tmr->sec);
	return tmr;
}

void gnomechess_timer_callback(gpointer data) {
	timer *tmr;

	tmr = (timer *)data;
	tmr->sec--;
	gnomechess_timer_set(tmr, tmr->sec);
}

void gnomechess_timer_set(timer *tmr, int sec) {
	char t[10];
	char s;

	tmr->sec = sec;
	if (tmr->sec < 0)
		s = '-';
	else
		s = ' ';		
	sprintf(t, "%c%d:%.2d", s, abs(tmr->sec/60),abs(tmr->sec%60));
	gtk_label_set_text(GTK_LABEL(tmr->label), t);
}

void gnomechess_timer_start(timer *tmr) {
	if (tmr->handlerid != -1) return;

	tmr->handlerid = gtk_timeout_add(1000, (GtkFunction)gnomechess_timer_callback, tmr);
}

void gnomechess_timer_stop(timer *tmr) {
	if (tmr->handlerid == -1) return;

	gtk_timeout_remove(tmr->handlerid);
	tmr->handlerid = -1;
}

GtkWidget* gnomechess_timer_getview(timer *tmr) {
	return tmr->label;
}

void gnomechess_timer_destroy(timer *tmr) {
	free(tmr);
}