/* window.c generated by valac 0.31.1.19-d5143, the Vala compiler
 * generated from window.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <libgweather/gweather.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define CLOCKS_TYPE_WINDOW (clocks_window_get_type ())
#define CLOCKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_WINDOW, ClocksWindow))
#define CLOCKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_WINDOW, ClocksWindowClass))
#define CLOCKS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_WINDOW))
#define CLOCKS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_WINDOW))
#define CLOCKS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_WINDOW, ClocksWindowClass))

typedef struct _ClocksWindow ClocksWindow;
typedef struct _ClocksWindowClass ClocksWindowClass;
typedef struct _ClocksWindowPrivate ClocksWindowPrivate;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_TYPE_APPLICATION (clocks_application_get_type ())
#define CLOCKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplication))
#define CLOCKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))
#define CLOCKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))

typedef struct _ClocksApplication ClocksApplication;
typedef struct _ClocksApplicationClass ClocksApplicationClass;

#define CLOCKS_WORLD_TYPE_FACE (clocks_world_face_get_type ())
#define CLOCKS_WORLD_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace))
#define CLOCKS_WORLD_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))
#define CLOCKS_WORLD_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))

typedef struct _ClocksWorldFace ClocksWorldFace;
typedef struct _ClocksWorldFaceClass ClocksWorldFaceClass;

#define CLOCKS_STOPWATCH_TYPE_FACE (clocks_stopwatch_face_get_type ())
#define CLOCKS_STOPWATCH_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace))
#define CLOCKS_STOPWATCH_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))
#define CLOCKS_STOPWATCH_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))

typedef struct _ClocksStopwatchFace ClocksStopwatchFace;
typedef struct _ClocksStopwatchFaceClass ClocksStopwatchFaceClass;

#define CLOCKS_TIMER_TYPE_FACE (clocks_timer_face_get_type ())
#define CLOCKS_TIMER_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace))
#define CLOCKS_TIMER_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))
#define CLOCKS_TIMER_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))

typedef struct _ClocksTimerFace ClocksTimerFace;
typedef struct _ClocksTimerFaceClass ClocksTimerFaceClass;
typedef struct _Block2Data Block2Data;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())

#define CLOCKS_ALARM_TYPE_FACE (clocks_alarm_face_get_type ())
#define CLOCKS_ALARM_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace))
#define CLOCKS_ALARM_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFaceClass))
#define CLOCKS_ALARM_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_FACE))
#define CLOCKS_ALARM_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_FACE))
#define CLOCKS_ALARM_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFaceClass))

typedef struct _ClocksAlarmFace ClocksAlarmFace;
typedef struct _ClocksAlarmFaceClass ClocksAlarmFaceClass;

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_STOPWATCH_FACE_TYPE_STATE (clocks_stopwatch_face_state_get_type ())

#define CLOCKS_TIMER_FACE_TYPE_STATE (clocks_timer_face_state_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CLOCKS_HEADER_BAR_TYPE_MODE (clocks_header_bar_mode_get_type ())

struct _ClocksWindow {
	GtkApplicationWindow parent_instance;
	ClocksWindowPrivate * priv;
};

struct _ClocksWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*change_page) (ClocksWindow* self, gint offset);
};

struct _ClocksWindowPrivate {
	ClocksHeaderBar* header_bar;
	GtkStack* stack;
	GtkStackSwitcher* stack_switcher;
	GSettings* settings;
	GtkWidget** panels;
	gint panels_length1;
	gint _panels_size_;
};

struct _Block2Data {
	int _ref_count_;
	ClocksWindow* self;
	ClocksWorldFace* world;
	ClocksStopwatchFace* stopwatch;
	ClocksTimerFace* timer;
	gulong stack_id;
	gulong header_bar_id;
};

typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	void (*update_header_bar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksHeaderBar* (*get_header_bar) (ClocksClock* self);
	void (*set_header_bar) (ClocksClock* self, ClocksHeaderBar* value);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
};

typedef enum  {
	CLOCKS_STOPWATCH_FACE_STATE_RESET,
	CLOCKS_STOPWATCH_FACE_STATE_RUNNING,
	CLOCKS_STOPWATCH_FACE_STATE_STOPPED
} ClocksStopwatchFaceState;

typedef enum  {
	CLOCKS_TIMER_FACE_STATE_STOPPED,
	CLOCKS_TIMER_FACE_STATE_RUNNING,
	CLOCKS_TIMER_FACE_STATE_PAUSED
} ClocksTimerFaceState;

typedef enum  {
	CLOCKS_HEADER_BAR_MODE_NORMAL,
	CLOCKS_HEADER_BAR_MODE_SELECTION,
	CLOCKS_HEADER_BAR_MODE_STANDALONE
} ClocksHeaderBarMode;


static gpointer clocks_window_parent_class = NULL;

GType clocks_window_get_type (void) G_GNUC_CONST;
GType clocks_header_bar_get_type (void) G_GNUC_CONST;
#define CLOCKS_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TYPE_WINDOW, ClocksWindowPrivate))
enum  {
	CLOCKS_WINDOW_DUMMY_PROPERTY
};
static void clocks_window_on_new_activate (ClocksWindow* self);
static void _clocks_window_on_new_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void clocks_window_on_help_activate (ClocksWindow* self);
static void _clocks_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void clocks_window_on_about_activate (ClocksWindow* self);
static void _clocks_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void clocks_window_on_select_all_activate (ClocksWindow* self);
static void _clocks_window_on_select_all_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void clocks_window_on_select_none_activate (ClocksWindow* self);
static void _clocks_window_on_select_none_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GType clocks_application_get_type (void) G_GNUC_CONST;
ClocksWindow* clocks_window_new (ClocksApplication* app);
ClocksWindow* clocks_window_construct (GType object_type, ClocksApplication* app);
GType clocks_world_face_get_type (void) G_GNUC_CONST;
GType clocks_stopwatch_face_get_type (void) G_GNUC_CONST;
GType clocks_timer_face_get_type (void) G_GNUC_CONST;
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda9_ (ClocksWindow* self);
static void ___lambda9__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
#define CLOCKS_N_PANELS 4
GType clocks_panel_id_get_type (void) G_GNUC_CONST;
ClocksWorldFace* clocks_world_face_new (ClocksHeaderBar* header_bar);
ClocksWorldFace* clocks_world_face_construct (GType object_type, ClocksHeaderBar* header_bar);
ClocksAlarmFace* clocks_alarm_face_new (ClocksHeaderBar* header_bar);
ClocksAlarmFace* clocks_alarm_face_construct (GType object_type, ClocksHeaderBar* header_bar);
GType clocks_alarm_face_get_type (void) G_GNUC_CONST;
ClocksStopwatchFace* clocks_stopwatch_face_new (ClocksHeaderBar* header_bar);
ClocksStopwatchFace* clocks_stopwatch_face_construct (GType object_type, ClocksHeaderBar* header_bar);
ClocksTimerFace* clocks_timer_face_new (ClocksHeaderBar* header_bar);
ClocksTimerFace* clocks_timer_face_construct (GType object_type, ClocksHeaderBar* header_bar);
GType clocks_clock_get_type (void) G_GNUC_CONST;
const gchar* clocks_clock_get_label (ClocksClock* self);
static void __lambda49_ (ClocksWindow* self);
static void clocks_window_update_header_bar (ClocksWindow* self);
static void ___lambda49__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda50_ (ClocksWindow* self);
static void ___lambda50__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda51_ (Block2Data* _data2_);
static void ___lambda51__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void __lambda52_ (Block2Data* _data2_, ClocksAlarmFace* w);
void clocks_world_face_reset_view (ClocksWorldFace* self);
static void ___lambda52__clocks_alarm_face_ring (ClocksAlarmFace* _sender, gpointer self);
static void __lambda53_ (Block2Data* _data2_, GParamSpec* w);
GType clocks_stopwatch_face_state_get_type (void) G_GNUC_CONST;
ClocksStopwatchFaceState clocks_stopwatch_face_get_state (ClocksStopwatchFace* self);
static void ___lambda53__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda54_ (Block2Data* _data2_, ClocksTimerFace* w);
static void ___lambda54__clocks_timer_face_ring (ClocksTimerFace* _sender, gpointer self);
static void __lambda55_ (Block2Data* _data2_, GParamSpec* w);
GType clocks_timer_face_state_get_type (void) G_GNUC_CONST;
ClocksTimerFaceState clocks_timer_face_get_state (ClocksTimerFace* self);
static void ___lambda55__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void clocks_clock_activate_new (ClocksClock* self);
void clocks_clock_activate_select_all (ClocksClock* self);
void clocks_clock_activate_select_none (ClocksClock* self);
void clocks_window_show_world (ClocksWindow* self);
void clocks_window_add_world_location (ClocksWindow* self, GWeatherLocation* location);
void clocks_world_face_add_location (ClocksWorldFace* self, GWeatherLocation* location);
static gboolean clocks_window_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean clocks_clock_escape_pressed (ClocksClock* self);
static gboolean clocks_window_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static gboolean clocks_window_real_window_state_event (GtkWidget* base, GdkEventWindowState* event);
void clocks_header_bar_clear (ClocksHeaderBar* self);
ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
void clocks_clock_update_header_bar (ClocksClock* self);
GType clocks_header_bar_mode_get_type (void) G_GNUC_CONST;
ClocksHeaderBarMode clocks_header_bar_get_mode (ClocksHeaderBar* self);
static void clocks_window_real_change_page (ClocksWindow* self, gint offset);
static void clocks_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry CLOCKS_WINDOW_action_entries[5] = {{"new", _clocks_window_on_new_activate_gsimple_action_activate_callback}, {"help", _clocks_window_on_help_activate_gsimple_action_activate_callback}, {"about", _clocks_window_on_about_activate_gsimple_action_activate_callback}, {"select-all", _clocks_window_on_select_all_activate_gsimple_action_activate_callback}, {"select-none", _clocks_window_on_select_none_activate_gsimple_action_activate_callback}};

static void _clocks_window_on_new_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	clocks_window_on_new_activate ((ClocksWindow*) self);
}


static void _clocks_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	clocks_window_on_help_activate ((ClocksWindow*) self);
}


static void _clocks_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	clocks_window_on_about_activate ((ClocksWindow*) self);
}


static void _clocks_window_on_select_all_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	clocks_window_on_select_all_activate ((ClocksWindow*) self);
}


static void _clocks_window_on_select_none_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	clocks_window_on_select_none_activate ((ClocksWindow*) self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ClocksWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->timer);
		_g_object_unref0 (_data2_->stopwatch);
		_g_object_unref0 (_data2_->world);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda9_ (ClocksWindow* self) {
	GSettings* _tmp0_ = NULL;
	_tmp0_ = self->priv->settings;
	g_settings_apply (_tmp0_);
}


static void ___lambda9__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda9_ ((ClocksWindow*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda49_ (ClocksWindow* self) {
	GtkShortcutsWindow* help_overlay = NULL;
	GtkShortcutsWindow* _tmp0_ = NULL;
	GtkShortcutsWindow* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GType _tmp5_ = 0UL;
	const gchar* _tmp6_ = NULL;
	_tmp0_ = gtk_application_window_get_help_overlay ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	help_overlay = _tmp1_;
	_tmp2_ = self->priv->stack;
	_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = G_TYPE_FROM_INSTANCE (_tmp4_);
	_tmp6_ = g_type_name (_tmp5_);
	g_object_set (help_overlay, "view-name", _tmp6_, NULL);
	clocks_window_update_header_bar (self);
	_g_object_unref0 (help_overlay);
}


static void ___lambda49__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda49_ ((ClocksWindow*) self);
}


static void __lambda50_ (ClocksWindow* self) {
	clocks_window_update_header_bar (self);
}


static void ___lambda50__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda50_ ((ClocksWindow*) self);
}


static void __lambda51_ (Block2Data* _data2_) {
	ClocksWindow* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	self = _data2_->self;
	_tmp0_ = self->priv->header_bar;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data2_->header_bar_id);
	_data2_->header_bar_id = (gulong) 0;
	_tmp1_ = self->priv->stack;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data2_->stack_id);
	_data2_->stack_id = (gulong) 0;
}


static void ___lambda51__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda51_ (self);
}


static void __lambda52_ (Block2Data* _data2_, ClocksAlarmFace* w) {
	ClocksWindow* self;
	ClocksWorldFace* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	ClocksAlarmFace* _tmp2_ = NULL;
	self = _data2_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = _data2_->world;
	clocks_world_face_reset_view (_tmp0_);
	_tmp1_ = self->priv->stack;
	_tmp2_ = w;
	gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
}


static void ___lambda52__clocks_alarm_face_ring (ClocksAlarmFace* _sender, gpointer self) {
	__lambda52_ (self, _sender);
}


static void __lambda53_ (Block2Data* _data2_, GParamSpec* w) {
	ClocksWindow* self;
	GtkStack* _tmp0_ = NULL;
	ClocksStopwatchFace* _tmp1_ = NULL;
	ClocksStopwatchFace* _tmp2_ = NULL;
	ClocksStopwatchFaceState _tmp3_ = 0;
	ClocksStopwatchFaceState _tmp4_ = 0;
	GValue _tmp5_ = {0};
	self = _data2_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = _data2_->stopwatch;
	_tmp2_ = _data2_->stopwatch;
	_tmp3_ = clocks_stopwatch_face_get_state (_tmp2_);
	_tmp4_ = _tmp3_;
	g_value_init (&_tmp5_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp5_, _tmp4_ == CLOCKS_STOPWATCH_FACE_STATE_RUNNING);
	gtk_container_child_set_property ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_, "needs-attention", &_tmp5_);
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
}


static void ___lambda53__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda53_ (self, pspec);
}


static void __lambda54_ (Block2Data* _data2_, ClocksTimerFace* w) {
	ClocksWindow* self;
	ClocksWorldFace* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	ClocksTimerFace* _tmp2_ = NULL;
	self = _data2_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = _data2_->world;
	clocks_world_face_reset_view (_tmp0_);
	_tmp1_ = self->priv->stack;
	_tmp2_ = w;
	gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
}


static void ___lambda54__clocks_timer_face_ring (ClocksTimerFace* _sender, gpointer self) {
	__lambda54_ (self, _sender);
}


static void __lambda55_ (Block2Data* _data2_, GParamSpec* w) {
	ClocksWindow* self;
	GtkStack* _tmp0_ = NULL;
	ClocksTimerFace* _tmp1_ = NULL;
	ClocksTimerFace* _tmp2_ = NULL;
	ClocksTimerFaceState _tmp3_ = 0;
	ClocksTimerFaceState _tmp4_ = 0;
	GValue _tmp5_ = {0};
	self = _data2_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = _data2_->timer;
	_tmp2_ = _data2_->timer;
	_tmp3_ = clocks_timer_face_get_state (_tmp2_);
	_tmp4_ = _tmp3_;
	g_value_init (&_tmp5_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp5_, _tmp4_ == CLOCKS_TIMER_FACE_STATE_RUNNING);
	gtk_container_child_set_property ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_, "needs-attention", &_tmp5_);
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
}


static void ___lambda55__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda55_ (self, pspec);
}


ClocksWindow* clocks_window_construct (GType object_type, ClocksApplication* app) {
	ClocksWindow * self = NULL;
	Block2Data* _data2_;
	ClocksApplication* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GdkWindowState window_state = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GdkWindowState _tmp5_ = 0;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GtkWidget** _tmp9_ = NULL;
	GtkWidget** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	ClocksHeaderBar* _tmp11_ = NULL;
	ClocksWorldFace* _tmp12_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkWidget** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	ClocksHeaderBar* _tmp15_ = NULL;
	ClocksAlarmFace* _tmp16_ = NULL;
	GtkWidget* _tmp17_ = NULL;
	GtkWidget** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	ClocksHeaderBar* _tmp19_ = NULL;
	ClocksStopwatchFace* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	GtkWidget** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	ClocksHeaderBar* _tmp23_ = NULL;
	ClocksTimerFace* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	GtkWidget** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	GtkWidget* _tmp27_ = NULL;
	ClocksWorldFace* _tmp28_ = NULL;
	ClocksAlarmFace* alarm = NULL;
	GtkWidget** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GtkWidget* _tmp30_ = NULL;
	ClocksAlarmFace* _tmp31_ = NULL;
	GtkWidget** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	GtkWidget* _tmp33_ = NULL;
	ClocksStopwatchFace* _tmp34_ = NULL;
	GtkWidget** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	GtkWidget* _tmp36_ = NULL;
	ClocksTimerFace* _tmp37_ = NULL;
	GtkWidget** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	GtkStackSwitcher* _tmp48_ = NULL;
	GtkStack* _tmp49_ = NULL;
	GtkStack* _tmp50_ = NULL;
	gulong _tmp51_ = 0UL;
	ClocksHeaderBar* _tmp52_ = NULL;
	gulong _tmp53_ = 0UL;
	GtkStack* _tmp54_ = NULL;
	ClocksAlarmFace* _tmp55_ = NULL;
	ClocksStopwatchFace* _tmp56_ = NULL;
	ClocksTimerFace* _tmp57_ = NULL;
	ClocksTimerFace* _tmp58_ = NULL;
	GtkBindingSet* binding_set = NULL;
	GObjectClass* _tmp59_ = NULL;
	GtkBindingSet* _tmp60_ = NULL;
	GtkStack* _tmp61_ = NULL;
	GtkWidget** _tmp62_ = NULL;
	gint _tmp62__length1 = 0;
	GSettings* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	GtkWidget* _tmp65_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = app;
	self = (ClocksWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	_data2_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, CLOCKS_WINDOW_action_entries, G_N_ELEMENTS (CLOCKS_WINDOW_action_entries), self);
	_tmp1_ = g_settings_new ("org.gnome.clocks.state.window");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_delay (_tmp2_);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) ___lambda9__gtk_widget_destroy, self, 0);
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, "state");
	window_state = (GdkWindowState) _tmp4_;
	_tmp5_ = window_state;
	if ((_tmp5_ & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp6_ = self->priv->settings;
	g_settings_get (_tmp6_, "size", "(ii)", &width, &height);
	_tmp7_ = width;
	_tmp8_ = height;
	gtk_window_resize ((GtkWindow*) self, _tmp7_, _tmp8_);
	_tmp9_ = g_new0 (GtkWidget*, CLOCKS_N_PANELS + 1);
	self->priv->panels = (_vala_array_free (self->priv->panels, self->priv->panels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->panels = _tmp9_;
	self->priv->panels_length1 = CLOCKS_N_PANELS;
	self->priv->_panels_size_ = self->priv->panels_length1;
	_tmp10_ = self->priv->panels;
	_tmp10__length1 = self->priv->panels_length1;
	_tmp11_ = self->priv->header_bar;
	_tmp12_ = clocks_world_face_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (_tmp10_[CLOCKS_PANEL_ID_WORLD]);
	_tmp10_[CLOCKS_PANEL_ID_WORLD] = (GtkWidget*) _tmp12_;
	_tmp13_ = _tmp10_[CLOCKS_PANEL_ID_WORLD];
	_tmp14_ = self->priv->panels;
	_tmp14__length1 = self->priv->panels_length1;
	_tmp15_ = self->priv->header_bar;
	_tmp16_ = clocks_alarm_face_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (_tmp14_[CLOCKS_PANEL_ID_ALARM]);
	_tmp14_[CLOCKS_PANEL_ID_ALARM] = (GtkWidget*) _tmp16_;
	_tmp17_ = _tmp14_[CLOCKS_PANEL_ID_ALARM];
	_tmp18_ = self->priv->panels;
	_tmp18__length1 = self->priv->panels_length1;
	_tmp19_ = self->priv->header_bar;
	_tmp20_ = clocks_stopwatch_face_new (_tmp19_);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (_tmp18_[CLOCKS_PANEL_ID_STOPWATCH]);
	_tmp18_[CLOCKS_PANEL_ID_STOPWATCH] = (GtkWidget*) _tmp20_;
	_tmp21_ = _tmp18_[CLOCKS_PANEL_ID_STOPWATCH];
	_tmp22_ = self->priv->panels;
	_tmp22__length1 = self->priv->panels_length1;
	_tmp23_ = self->priv->header_bar;
	_tmp24_ = clocks_timer_face_new (_tmp23_);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (_tmp22_[CLOCKS_PANEL_ID_TIMER]);
	_tmp22_[CLOCKS_PANEL_ID_TIMER] = (GtkWidget*) _tmp24_;
	_tmp25_ = _tmp22_[CLOCKS_PANEL_ID_TIMER];
	_tmp26_ = self->priv->panels;
	_tmp26__length1 = self->priv->panels_length1;
	_tmp27_ = _tmp26_[CLOCKS_PANEL_ID_WORLD];
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace));
	_data2_->world = _tmp28_;
	_tmp29_ = self->priv->panels;
	_tmp29__length1 = self->priv->panels_length1;
	_tmp30_ = _tmp29_[CLOCKS_PANEL_ID_ALARM];
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace));
	alarm = _tmp31_;
	_tmp32_ = self->priv->panels;
	_tmp32__length1 = self->priv->panels_length1;
	_tmp33_ = _tmp32_[CLOCKS_PANEL_ID_STOPWATCH];
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace));
	_data2_->stopwatch = _tmp34_;
	_tmp35_ = self->priv->panels;
	_tmp35__length1 = self->priv->panels_length1;
	_tmp36_ = _tmp35_[CLOCKS_PANEL_ID_TIMER];
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace));
	_data2_->timer = _tmp37_;
	_tmp38_ = self->priv->panels;
	_tmp38__length1 = self->priv->panels_length1;
	{
		GtkWidget** clock_collection = NULL;
		gint clock_collection_length1 = 0;
		gint _clock_collection_size_ = 0;
		gint clock_it = 0;
		clock_collection = _tmp38_;
		clock_collection_length1 = _tmp38__length1;
		for (clock_it = 0; clock_it < _tmp38__length1; clock_it = clock_it + 1) {
			GtkWidget* _tmp39_ = NULL;
			GtkWidget* clock = NULL;
			_tmp39_ = _g_object_ref0 (clock_collection[clock_it]);
			clock = _tmp39_;
			{
				GtkStack* _tmp40_ = NULL;
				GtkWidget* _tmp41_ = NULL;
				GtkWidget* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				GtkWidget* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				_tmp40_ = self->priv->stack;
				_tmp41_ = clock;
				_tmp42_ = clock;
				_tmp43_ = clocks_clock_get_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, CLOCKS_TYPE_CLOCK, ClocksClock));
				_tmp44_ = _tmp43_;
				_tmp45_ = clock;
				_tmp46_ = clocks_clock_get_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, CLOCKS_TYPE_CLOCK, ClocksClock));
				_tmp47_ = _tmp46_;
				gtk_stack_add_titled (_tmp40_, _tmp41_, _tmp44_, _tmp47_);
				_g_object_unref0 (clock);
			}
		}
	}
	_tmp48_ = self->priv->stack_switcher;
	_tmp49_ = self->priv->stack;
	gtk_stack_switcher_set_stack (_tmp48_, _tmp49_);
	_tmp50_ = self->priv->stack;
	_tmp51_ = g_signal_connect_object ((GObject*) _tmp50_, "notify::visible-child", (GCallback) ___lambda49__g_object_notify, self, 0);
	_data2_->stack_id = _tmp51_;
	_tmp52_ = self->priv->header_bar;
	_tmp53_ = g_signal_connect_object ((GObject*) _tmp52_, "notify::mode", (GCallback) ___lambda50__g_object_notify, self, 0);
	_data2_->header_bar_id = _tmp53_;
	_tmp54_ = self->priv->stack;
	g_signal_connect_data ((GtkWidget*) _tmp54_, "destroy", (GCallback) ___lambda51__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp55_ = alarm;
	g_signal_connect_data (_tmp55_, "ring", (GCallback) ___lambda52__clocks_alarm_face_ring, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp56_ = _data2_->stopwatch;
	g_signal_connect_data ((GObject*) _tmp56_, "notify::state", (GCallback) ___lambda53__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp57_ = _data2_->timer;
	g_signal_connect_data (_tmp57_, "ring", (GCallback) ___lambda54__clocks_timer_face_ring, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp58_ = _data2_->timer;
	g_signal_connect_data ((GObject*) _tmp58_, "notify::state", (GCallback) ___lambda55__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp59_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp60_ = gtk_binding_set_by_class (_tmp59_);
	binding_set = _tmp60_;
	gtk_binding_entry_add_signal (binding_set, (guint) GDK_KEY_Page_Up, GDK_CONTROL_MASK | GDK_MOD1_MASK, "change-page", (guint) 1, G_TYPE_INT, -1, NULL);
	gtk_binding_entry_add_signal (binding_set, (guint) GDK_KEY_Page_Down, GDK_CONTROL_MASK | GDK_MOD1_MASK, "change-page", (guint) 1, G_TYPE_INT, 1, NULL);
	_tmp61_ = self->priv->stack;
	_tmp62_ = self->priv->panels;
	_tmp62__length1 = self->priv->panels_length1;
	_tmp63_ = self->priv->settings;
	_tmp64_ = g_settings_get_enum (_tmp63_, "panel-id");
	_tmp65_ = _tmp62_[_tmp64_];
	gtk_stack_set_visible_child (_tmp61_, _tmp65_);
	clocks_window_update_header_bar (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (alarm);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}


ClocksWindow* clocks_window_new (ClocksApplication* app) {
	return clocks_window_construct (CLOCKS_TYPE_WINDOW, app);
}


static void clocks_window_on_new_activate (ClocksWindow* self) {
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	clocks_clock_activate_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_TYPE_CLOCK, ClocksClock));
}


static void clocks_window_on_select_all_activate (ClocksWindow* self) {
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	clocks_clock_activate_select_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_TYPE_CLOCK, ClocksClock));
}


static void clocks_window_on_select_none_activate (ClocksWindow* self) {
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	clocks_clock_activate_select_none (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_TYPE_CLOCK, ClocksClock));
}


void clocks_window_show_world (ClocksWindow* self) {
	GtkWidget** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GtkWidget* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkWidget** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GtkWidget* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->panels;
	_tmp0__length1 = self->priv->panels_length1;
	_tmp1_ = _tmp0_[CLOCKS_PANEL_ID_WORLD];
	clocks_world_face_reset_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace));
	_tmp2_ = self->priv->stack;
	_tmp3_ = self->priv->panels;
	_tmp3__length1 = self->priv->panels_length1;
	_tmp4_ = _tmp3_[CLOCKS_PANEL_ID_WORLD];
	gtk_stack_set_visible_child (_tmp2_, _tmp4_);
}


void clocks_window_add_world_location (ClocksWindow* self, GWeatherLocation* location) {
	GtkWidget** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GtkWidget* _tmp1_ = NULL;
	GWeatherLocation* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->panels;
	_tmp0__length1 = self->priv->panels_length1;
	_tmp1_ = _tmp0_[CLOCKS_PANEL_ID_WORLD];
	_tmp2_ = location;
	clocks_world_face_add_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace), _tmp2_);
}


static gboolean clocks_window_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	ClocksWindow * self;
	gboolean result = FALSE;
	guint keyval = 0U;
	gboolean handled = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GdkEventKey* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	self = (ClocksWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	handled = FALSE;
	_tmp1_ = event;
	_tmp3_ = gdk_event_get_keyval ((GdkEvent*) _tmp1_, &_tmp2_);
	keyval = _tmp2_;
	if (_tmp3_) {
		guint _tmp4_ = 0U;
		_tmp4_ = keyval;
		_tmp0_ = _tmp4_ == ((guint) GDK_KEY_Escape);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkStack* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = self->priv->stack;
		_tmp6_ = gtk_stack_get_visible_child (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = clocks_clock_escape_pressed (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CLOCKS_TYPE_CLOCK, ClocksClock));
		handled = _tmp8_;
	}
	_tmp9_ = handled;
	if (_tmp9_) {
		result = TRUE;
		return result;
	}
	_tmp10_ = event;
	_tmp11_ = GTK_WIDGET_CLASS (clocks_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), _tmp10_);
	result = _tmp11_;
	return result;
}


static gboolean clocks_window_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ClocksWindow * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventConfigure* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	self = (ClocksWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (_tmp1_) {
		GdkWindow* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp3_ = gdk_window_get_state (_tmp2_);
		_tmp0_ = !((_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint width = 0;
		gint height = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		GSettings* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gtk_window_get_size ((GtkWindow*) self, &_tmp4_, &_tmp5_);
		width = _tmp4_;
		height = _tmp5_;
		_tmp6_ = self->priv->settings;
		_tmp7_ = width;
		_tmp8_ = height;
		g_settings_set (_tmp6_, "size", "(ii)", _tmp7_, _tmp8_);
	}
	_tmp9_ = event;
	_tmp10_ = GTK_WIDGET_CLASS (clocks_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), _tmp9_);
	result = _tmp10_;
	return result;
}


static gboolean clocks_window_real_window_state_event (GtkWidget* base, GdkEventWindowState* event) {
	ClocksWindow * self;
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	GdkEventWindowState* _tmp1_ = NULL;
	GdkWindowState _tmp2_ = 0;
	GdkEventWindowState* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (ClocksWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = event;
	_tmp2_ = _tmp1_->new_window_state;
	g_settings_set_int (_tmp0_, "state", (gint) _tmp2_);
	_tmp3_ = event;
	_tmp4_ = GTK_WIDGET_CLASS (clocks_window_parent_class)->window_state_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), _tmp3_);
	result = _tmp4_;
	return result;
}


static void clocks_window_on_help_activate (ClocksWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GdkScreen* _tmp0_ = NULL;
		guint32 _tmp1_ = 0U;
		_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp1_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp0_, "help:gnome-clocks", _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Failed to show help: %s");
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning (_tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void clocks_window_on_about_activate (ClocksWindow* self) {
	static const char copyright[] = "Copyright \xc2\xa9 2011 Collabora Ltd.\n" "Copyright \xc2\xa9 2012-2013 Collabora Ltd., Seif Lotfy, Emily Gonyer\n" "Eslam Mostafa, Paolo Borelli, Volker Sobek\n";
	static const gchar* authors[] = {"Alex Anthony", "Paolo Borelli", "Allan Day", "Piotr Drąg", "Emily Gonyer", "Evgeny Bobkin", "Maël Lavault", "Seif Lotfy", "William Jon McCann", "Eslam Mostafa", "Bastien Nocera", "Volker Sobek", "Jakub Steiner", NULL};
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Clocks");
	_tmp1_ = _ ("Utilities to help you with the time.");
	_tmp2_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) self, "program-name", _tmp0_, "logo-icon-name", "org.gnome.clocks", "version", VERSION, "comments", _tmp1_, "copyright", copyright, "authors", authors, "license-type", GTK_LICENSE_GPL_2_0, "wrap-license", FALSE, "translator-credits", _tmp2_, NULL, NULL);
}


static void clocks_window_update_header_bar (ClocksWindow* self) {
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksClock* clock = NULL;
	GtkStack* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	ClocksClock* _tmp4_ = NULL;
	ClocksClock* _tmp5_ = NULL;
	ClocksHeaderBar* _tmp12_ = NULL;
	ClocksHeaderBarMode _tmp13_ = 0;
	ClocksHeaderBarMode _tmp14_ = 0;
	ClocksHeaderBar* _tmp17_ = NULL;
	ClocksHeaderBar* _tmp18_ = NULL;
	ClocksHeaderBarMode _tmp19_ = 0;
	ClocksHeaderBarMode _tmp20_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->header_bar;
	clocks_header_bar_clear (_tmp0_);
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_TYPE_CLOCK, ClocksClock));
	clock = _tmp4_;
	_tmp5_ = clock;
	if (_tmp5_ != NULL) {
		GSettings* _tmp6_ = NULL;
		ClocksClock* _tmp7_ = NULL;
		ClocksPanelId _tmp8_ = 0;
		ClocksPanelId _tmp9_ = 0;
		ClocksClock* _tmp10_ = NULL;
		ClocksClock* _tmp11_ = NULL;
		_tmp6_ = self->priv->settings;
		_tmp7_ = clock;
		_tmp8_ = clocks_clock_get_panel_id (_tmp7_);
		_tmp9_ = _tmp8_;
		g_settings_set_enum (_tmp6_, "panel-id", (gint) _tmp9_);
		_tmp10_ = clock;
		clocks_clock_update_header_bar (_tmp10_);
		_tmp11_ = clock;
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp12_ = self->priv->header_bar;
	_tmp13_ = clocks_header_bar_get_mode (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == CLOCKS_HEADER_BAR_MODE_NORMAL) {
		ClocksHeaderBar* _tmp15_ = NULL;
		GtkStackSwitcher* _tmp16_ = NULL;
		_tmp15_ = self->priv->header_bar;
		_tmp16_ = self->priv->stack_switcher;
		gtk_header_bar_set_custom_title ((GtkHeaderBar*) _tmp15_, (GtkWidget*) _tmp16_);
	}
	_tmp17_ = self->priv->header_bar;
	_tmp18_ = self->priv->header_bar;
	_tmp19_ = clocks_header_bar_get_mode (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_header_bar_set_show_close_button ((GtkHeaderBar*) _tmp17_, _tmp20_ != CLOCKS_HEADER_BAR_MODE_SELECTION);
	_g_object_unref0 (clock);
}


static void clocks_window_real_change_page (ClocksWindow* self, gint offset) {
	gint page = 0;
	GtkStack* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_container_child_get ((GtkContainer*) _tmp0_, _tmp3_, "position", &page, NULL);
	_tmp4_ = page;
	_tmp5_ = offset;
	page = _tmp4_ + _tmp5_;
	_tmp7_ = page;
	if (_tmp7_ >= 0) {
		gint _tmp8_ = 0;
		GtkWidget** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp8_ = page;
		_tmp9_ = self->priv->panels;
		_tmp9__length1 = self->priv->panels_length1;
		_tmp6_ = _tmp8_ < _tmp9__length1;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkStack* _tmp10_ = NULL;
		GtkWidget** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp12_ = 0;
		GtkWidget* _tmp13_ = NULL;
		_tmp10_ = self->priv->stack;
		_tmp11_ = self->priv->panels;
		_tmp11__length1 = self->priv->panels_length1;
		_tmp12_ = page;
		_tmp13_ = _tmp11_[_tmp12_];
		gtk_stack_set_visible_child (_tmp10_, _tmp13_);
	} else {
		GtkStack* _tmp14_ = NULL;
		_tmp14_ = self->priv->stack;
		gtk_widget_error_bell ((GtkWidget*) _tmp14_);
	}
}


static void clocks_window_class_init (ClocksWindowClass * klass) {
	gint ClocksWindow_private_offset;
	clocks_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksWindowPrivate));
	((GtkWidgetClass *) klass)->key_press_event = clocks_window_real_key_press_event;
	((GtkWidgetClass *) klass)->configure_event = clocks_window_real_configure_event;
	((GtkWidgetClass *) klass)->window_state_event = clocks_window_real_window_state_event;
	((ClocksWindowClass *) klass)->change_page = clocks_window_real_change_page;
	G_OBJECT_CLASS (klass)->finalize = clocks_window_finalize;
	ClocksWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/window.ui");
	g_signal_new ("change_page", CLOCKS_TYPE_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ClocksWindowClass, change_page), NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_bar", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_switcher", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, stack_switcher));
}


static void clocks_window_instance_init (ClocksWindow * self) {
	self->priv = CLOCKS_WINDOW_GET_PRIVATE (self);
	g_type_ensure (CLOCKS_TYPE_HEADER_BAR);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_window_finalize (GObject* obj) {
	ClocksWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_WINDOW, ClocksWindow);
	_g_object_unref0 (self->priv->header_bar);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->stack_switcher);
	_g_object_unref0 (self->priv->settings);
	self->priv->panels = (_vala_array_free (self->priv->panels, self->priv->panels_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (clocks_window_parent_class)->finalize (obj);
}


GType clocks_window_get_type (void) {
	static volatile gsize clocks_window_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWindow), 0, (GInstanceInitFunc) clocks_window_instance_init, NULL };
		GType clocks_window_type_id;
		clocks_window_type_id = g_type_register_static (gtk_application_window_get_type (), "ClocksWindow", &g_define_type_info, 0);
		g_once_init_leave (&clocks_window_type_id__volatile, clocks_window_type_id);
	}
	return clocks_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



