/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2009-2010 Richard Hughes <richard@hughsie.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#if !defined (__LIBCOLOR_GLIB_H_INSIDE__) && !defined (LIBCOLOR_GLIB_COMPILATION)
#error "Only <libcolor-glib.h> can be included directly."
#endif

#ifndef __GCM_PROFILE_STORE_H
#define __GCM_PROFILE_STORE_H

#include <glib-object.h>

#include "gcm-profile.h"

G_BEGIN_DECLS

#define GCM_TYPE_PROFILE_STORE		(gcm_profile_store_get_type ())
#define GCM_PROFILE_STORE(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), GCM_TYPE_PROFILE_STORE, GcmProfileStore))
#define GCM_PROFILE_STORE_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST((k), GCM_TYPE_PROFILE_STORE, GcmProfileStoreClass))
#define GCM_IS_PROFILE_STORE(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), GCM_TYPE_PROFILE_STORE))
#define GCM_IS_PROFILE_STORE_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), GCM_TYPE_PROFILE_STORE))
#define GCM_PROFILE_STORE_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), GCM_TYPE_PROFILE_STORE, GcmProfileStoreClass))

typedef struct _GcmProfileStorePrivate	GcmProfileStorePrivate;
typedef struct _GcmProfileStore		GcmProfileStore;
typedef struct _GcmProfileStoreClass	GcmProfileStoreClass;

struct _GcmProfileStore
{
	 GObject			 parent;
	 GcmProfileStorePrivate		*priv;
};

struct _GcmProfileStoreClass
{
	GObjectClass	parent_class;
	void		(* added)			(GcmProfile		*profile);
	void		(* removed)			(GcmProfile		*profile);
	void		(* changed)			(void);
	/* padding for future expansion */
	void (*_gcm_reserved1) (void);
	void (*_gcm_reserved2) (void);
	void (*_gcm_reserved3) (void);
	void (*_gcm_reserved4) (void);
	void (*_gcm_reserved5) (void);
};

typedef enum {
	GCM_PROFILE_STORE_SEARCH_ALL		= 0,
	GCM_PROFILE_STORE_SEARCH_SYSTEM		= 1,
	GCM_PROFILE_STORE_SEARCH_VOLUMES	= 2,
	GCM_PROFILE_STORE_SEARCH_USER		= 4,
	GCM_PROFILE_STORE_SEARCH_MACHINE	= 8
} GcmProfileSearchFlags;

GType		 gcm_profile_store_get_type		(void);
GcmProfileStore	*gcm_profile_store_new			(void);

GcmProfile	*gcm_profile_store_get_by_filename	(GcmProfileStore	*profile_store,
							 const gchar		*filename);
GcmProfile	*gcm_profile_store_get_by_checksum	(GcmProfileStore	*profile_store,
							 const gchar		*checksum);
GPtrArray	*gcm_profile_store_get_array		(GcmProfileStore	*profile_store);
gboolean	 gcm_profile_store_search		(GcmProfileStore	*profile_store,
							 GcmProfileSearchFlags	 flags);
gboolean	 gcm_profile_store_search_path		(GcmProfileStore	*profile_store,
							 const gchar		*path);

G_END_DECLS

#endif /* __GCM_PROFILE_STORE_H */

