/* Gnome panel: extern applet functions
 * (C) 1997 the Free Software Foundation
 *
 * Authors:  George Lebl
 *           Federico Mena
 *           Miguel de Icaza
 */

#include <gdk/gdkx.h>
#include <config.h>
#include <string.h>
#include <signal.h>
#include <gnome.h>

#include "panel-include.h"
#include "gnome-panel.h"

#define APPLET_EVENT_MASK (GDK_BUTTON_PRESS_MASK |		\
			   GDK_BUTTON_RELEASE_MASK |		\
			   GDK_POINTER_MOTION_MASK |		\
			   GDK_POINTER_MOTION_HINT_MASK)

extern GSList *panels;

extern GSList *applets;
extern GSList *applets_last;
extern int applet_count;

extern int config_sync_timeout;
extern int applets_to_sync;
extern int panels_to_sync;
extern int need_complete_save;

extern GtkTooltips *panel_tooltips;

extern GlobalConfig global_config;

extern char *panel_cfg_path;
extern char *old_panel_cfg_path;

extern int ss_cur_applet;
extern int ss_done_save;
extern GtkWidget* ss_timeout_dlg;
extern gushort ss_cookie;

/********************* CORBA Stuff *******************/

CORBA_ORB orb = NULL;
CORBA_Environment ev;
PortableServer_POA thepoa;

/***Panel stuff***/
static GNOME_PanelSpot
s_panel_add_applet(POA_GNOME_Panel *servant,
		   GNOME_Applet panel_applet,
		   CORBA_char *goad_id,
		   CORBA_char ** cfgpath,
		   CORBA_char ** globcfgpath,
		   CORBA_unsigned_long* wid,
		   CORBA_Environment *ev);

static GNOME_PanelSpot
s_panel_add_applet_full(POA_GNOME_Panel *servant,
			GNOME_Applet panel_applet,
			CORBA_char *goad_id,
			CORBA_short panel,
			CORBA_short pos,
			CORBA_char ** cfgpath,
			CORBA_char ** globcfgpath,
			CORBA_unsigned_long* wid,
			CORBA_Environment *ev);

static void
s_panel_quit(POA_GNOME_Panel *servant, CORBA_Environment *ev);

static CORBA_boolean
s_panel_get_in_drag(POA_GNOME_Panel *servant, CORBA_Environment *ev);

static GNOME_StatusSpot
s_panel_add_status(POA_GNOME_Panel *servant,
		   CORBA_unsigned_long* wid,
		   CORBA_Environment *ev);

static void
s_panel_notice_config_changes(POA_GNOME_Panel *servant,
			      CORBA_Environment *ev);


/*** PanelSpot stuff ***/

static CORBA_char *
s_panelspot_get_tooltip(POA_GNOME_PanelSpot *servant,
			CORBA_Environment *ev);

static void
s_panelspot_set_tooltip(POA_GNOME_PanelSpot *servant,
			CORBA_char *val,
			CORBA_Environment *ev);

static CORBA_short
s_panelspot_get_parent_panel(POA_GNOME_PanelSpot *servant,
			     CORBA_Environment *ev);

static CORBA_short
s_panelspot_get_spot_pos(POA_GNOME_PanelSpot *servant,
			 CORBA_Environment *ev);

static GNOME_Panel_OrientType
s_panelspot_get_parent_orient(POA_GNOME_PanelSpot *servant,
			      CORBA_Environment *ev);

static GNOME_Panel_SizeType
s_panelspot_get_parent_size(POA_GNOME_PanelSpot *servant,
			    CORBA_Environment *ev);

static CORBA_short
s_panelspot_get_free_space(POA_GNOME_PanelSpot *servant,
			   CORBA_Environment *ev);

static CORBA_boolean
s_panelspot_get_send_position(POA_GNOME_PanelSpot *servant,
			      CORBA_Environment *ev);
static void
s_panelspot_set_send_position(POA_GNOME_PanelSpot *servant,
			      CORBA_boolean,
			      CORBA_Environment *ev);

static CORBA_boolean
s_panelspot_get_send_draw(POA_GNOME_PanelSpot *servant,
			  CORBA_Environment *ev);
static void
s_panelspot_set_send_draw(POA_GNOME_PanelSpot *servant,
			  CORBA_boolean,
			  CORBA_Environment *ev);

static GNOME_Panel_RgbImage *
s_panelspot_get_rgb_background(POA_GNOME_PanelSpot *servant,
			       CORBA_Environment *ev);

static void
s_panelspot_register_us(POA_GNOME_PanelSpot *servant,
		     CORBA_Environment *ev);

static void
s_panelspot_unregister_us(POA_GNOME_PanelSpot *servant,
		       CORBA_Environment *ev);

static void
s_panelspot_abort_load(POA_GNOME_PanelSpot *servant,
		       CORBA_Environment *ev);

static void
s_panelspot_show_menu(POA_GNOME_PanelSpot *servant,
		      CORBA_Environment *ev);

static void
s_panelspot_drag_start(POA_GNOME_PanelSpot *servant,
		       CORBA_Environment *ev);

static void
s_panelspot_drag_stop(POA_GNOME_PanelSpot *servant,
		      CORBA_Environment *ev);

static void
s_panelspot_add_callback(POA_GNOME_PanelSpot *servant,
			 CORBA_char *callback_name,
			 CORBA_char *stock_item,
			 CORBA_char *menuitem_text,
			 CORBA_Environment *ev);

static void
s_panelspot_remove_callback(POA_GNOME_PanelSpot *servant,
			    CORBA_char *callback_name,
			    CORBA_Environment *ev);
static void
s_panelspot_callback_set_sensitive(POA_GNOME_PanelSpot *servant,
				   CORBA_char *callback_name,
				   CORBA_boolean sensitive,
				   CORBA_Environment *ev);

static void
s_panelspot_sync_config(POA_GNOME_PanelSpot *servant,
			CORBA_Environment *ev);

static void
s_panelspot_done_session_save(POA_GNOME_PanelSpot *servant,
			      CORBA_boolean ret,
			      CORBA_unsigned_long cookie,
			      CORBA_Environment *ev);

/*** StatusSpot stuff ***/

static void
s_statusspot_remove(POA_GNOME_StatusSpot *servant,
		    CORBA_Environment *ev);




static PortableServer_ServantBase__epv panel_base_epv = {
  NULL, /* _private */
  NULL, /* finalize */
  NULL, /* use base default_POA function */
};

static POA_GNOME_Panel__epv panel_epv = {
  NULL, /* private data */
  (gpointer)&s_panel_add_applet,
  (gpointer)&s_panel_add_applet_full,
  (gpointer)&s_panel_quit,
  (gpointer)&s_panel_get_in_drag,
  (gpointer)&s_panel_add_status,
  (gpointer)&s_panel_notice_config_changes
};
static POA_GNOME_Panel__vepv panel_vepv = { &panel_base_epv, &panel_epv };
static POA_GNOME_Panel panel_servant = { NULL, &panel_vepv };


static PortableServer_ServantBase__epv panelspot_base_epv = {
  NULL, /* _private */
  NULL, /* finalize */
  NULL, /* use base default_POA function */
};

static POA_GNOME_PanelSpot__epv panelspot_epv = {
  NULL, /* private data */
  (gpointer)&s_panelspot_get_tooltip,
  (gpointer)&s_panelspot_set_tooltip,
  (gpointer)&s_panelspot_get_parent_panel,
  (gpointer)&s_panelspot_get_spot_pos,
  (gpointer)&s_panelspot_get_parent_orient,
  (gpointer)&s_panelspot_get_parent_size,
  (gpointer)&s_panelspot_get_free_space,
  (gpointer)&s_panelspot_get_send_position,
  (gpointer)&s_panelspot_set_send_position,
  (gpointer)&s_panelspot_get_send_draw,
  (gpointer)&s_panelspot_set_send_draw,
  (gpointer)&s_panelspot_get_rgb_background,
  (gpointer)&s_panelspot_register_us,
  (gpointer)&s_panelspot_unregister_us,
  (gpointer)&s_panelspot_abort_load,
  (gpointer)&s_panelspot_show_menu,
  (gpointer)&s_panelspot_drag_start,
  (gpointer)&s_panelspot_drag_stop,
  (gpointer)&s_panelspot_add_callback,
  (gpointer)&s_panelspot_remove_callback,
  (gpointer)&s_panelspot_callback_set_sensitive,
  (gpointer)&s_panelspot_sync_config,
  (gpointer)&s_panelspot_done_session_save
};
static POA_GNOME_PanelSpot__vepv panelspot_vepv = { &panelspot_base_epv, &panelspot_epv };

static PortableServer_ServantBase__epv statusspot_base_epv = {
  NULL, /* _private */
  NULL, /* finalize */
  NULL, /* use base default_POA function */
};

static POA_GNOME_StatusSpot__epv statusspot_epv = {
  NULL, /* private data */
  (gpointer)&s_statusspot_remove
};
static POA_GNOME_StatusSpot__vepv statusspot_vepv = { &statusspot_base_epv, &statusspot_epv };

/********************* NON-CORBA Stuff *******************/

static void
extern_start_new_goad_id(Extern *e)
{
        CORBA_Environment ev;
	CORBA_exception_init(&ev);
	CORBA_Object_release(goad_server_activate_with_id(NULL, e->goad_id, GOAD_ACTIVATE_NEW_ONLY|GOAD_ACTIVATE_ASYNC, NULL),&ev);
	CORBA_exception_free(&ev);
}

void
extern_clean(Extern *ext)
{
	CORBA_Environment ev;
	PortableServer_ObjectId *id;
	CORBA_exception_init(&ev);

	g_free(ext->goad_id);
	g_free(ext->cfg);

	CORBA_Object_release(ext->pspot, &ev);
	CORBA_Object_release(ext->applet, &ev);
	id = PortableServer_POA_servant_to_id(thepoa, ext, &ev);
	PortableServer_POA_deactivate_object(thepoa, id, &ev);
	CORBA_free (id);
	POA_GNOME_PanelSpot__fini((PortableServer_Servant) ext, &ev);
	
	if(ext->send_draw_timeout) {
		gtk_timeout_remove(ext->send_draw_timeout);
		ext->send_draw_timeout = 0;
	}

	g_free(ext);

	CORBA_exception_free(&ev);
}

static void
extern_socket_destroy(GtkWidget *w, gpointer data)
{
	Extern *ext = data;
	gtk_widget_destroy(ext->ebox);
	extern_clean(ext);
}

/*static void
sal(GtkWidget *applet, GtkAllocation *alloc)
{
	printf("SOCKET req:   %dx%d\nSOCKET alloc: %dx%d\n",
	       applet->requisition.width,
	       applet->requisition.height,
	       applet->allocation.width,
	       applet->allocation.height);
}*/


static void
send_position_change(Extern *ext)
{
	/*ingore this until we get an ior*/
	if(ext->applet) {
		int x=0,y=0;
		GtkWidget *wid=ext->ebox;
		
		CORBA_Environment ev;
		CORBA_exception_init(&ev);
		/*go the the toplevel panel widget*/
		for(;;) {
			if(!GTK_WIDGET_NO_WINDOW(wid)) {
				x += wid->allocation.x;
				y += wid->allocation.y;
			}
			if(wid->parent)
				wid = wid->parent;
			else
				break;
		}
		GNOME_Applet_change_position(ext->applet, x, y, &ev);
		if(ev._major)
			panel_clean_applet(ext->info);
		CORBA_exception_free(&ev);
	}
}

static void
ebox_size_allocate(GtkWidget *applet, GtkAllocation *alloc, Extern *ext)
{
	if(ext->send_position)
		send_position_change(ext);
}

static void
socket_size_allocate(GtkWidget *applet, GtkAllocation *alloc)
{
	GtkWidget *plug_widget;
	GtkSocket *socket = GTK_SOCKET(applet);

	/* perhaps an already unnecessary hack to avoid some missed
	   reallocations */
	if (applet->requisition.width > 0 && applet->requisition.height > 0 &&
	    (applet->allocation.width > applet->requisition.width ||
	     applet->allocation.height > applet->requisition.height))
		gtk_widget_queue_resize(applet->parent);

	if (!socket->same_app ||
	    !socket->plug_window)
		return;
    
	gdk_window_get_user_data (socket->plug_window,
				  (gpointer *)&plug_widget);
	if (plug_widget) {
		GtkAllocation child_allocation;
		child_allocation.x = child_allocation.y = 0;
		child_allocation.width = alloc->width;
		child_allocation.height = alloc->height;
		gtk_widget_size_allocate (plug_widget, &child_allocation);
	}
	gdk_window_move_resize (socket->plug_window,
				0, 0, alloc->width, alloc->height);
	if (socket->need_map) {
		gdk_window_show (socket->plug_window);
		socket->need_map = FALSE;
	}
	gdk_flush ();
}

static void
socket_size_request(GtkSocket *socket, GtkRequisition *req)
{
	GtkWidget *plug_widget;

	if (!socket->same_app ||
	    !socket->plug_window)
		return;

	gdk_window_get_user_data (socket->plug_window,
				  (gpointer *)&plug_widget);
	if (plug_widget) {
		GtkRequisition child_requisition;
		gtk_widget_size_request (plug_widget, &child_requisition);

		socket->request_width = child_requisition.width;
		socket->request_height = child_requisition.height;
	}

	req->width = MAX (socket->request_width, 1);
	req->height = MAX (socket->request_height, 1);
}

/*note that type should be APPLET_EXTERN_RESERVED or APPLET_EXTERN_PENDING
  only*/
static CORBA_unsigned_long
reserve_applet_spot (Extern *ext, PanelWidget *panel, int pos,
		     AppletType type)
{
	GtkWidget *socket;

	ext->ebox = gtk_event_box_new();
	gtk_widget_set_events(ext->ebox, (gtk_widget_get_events(ext->ebox) |
					  APPLET_EVENT_MASK) &
			      ~( GDK_POINTER_MOTION_MASK |
				 GDK_POINTER_MOTION_HINT_MASK));
	gtk_signal_connect_after(GTK_OBJECT(ext->ebox),"size_allocate",
				 GTK_SIGNAL_FUNC(ebox_size_allocate),
				 ext);

	socket = gtk_socket_new();

	gtk_signal_connect_after(GTK_OBJECT(socket),"size_request",
				 GTK_SIGNAL_FUNC(socket_size_request),
				 NULL);
	gtk_signal_connect_after(GTK_OBJECT(socket),"size_allocate",
				 GTK_SIGNAL_FUNC(socket_size_allocate),
				 NULL);

	/* here for debugging purposes */
	/*gtk_signal_connect_after(GTK_OBJECT(socket),"size_allocate",
				 GTK_SIGNAL_FUNC(sal),NULL);*/


	g_return_val_if_fail(socket!=NULL,0);

	gtk_container_add(GTK_CONTAINER(ext->ebox), socket);

	gtk_widget_show_all(ext->ebox);
	
	/*we save the obj in the id field of the appletinfo and the 
	  path in the path field */
	ext->info = NULL;
	if(!register_toy(ext->ebox, ext, panel, pos, ext->exactpos, type)) {
		/* the ebox is destroyed in register_toy */
		ext->ebox = NULL;
		g_warning(_("Couldn't add applet"));
		return 0;
	}
	ext->info = applets_last->data;

	gtk_signal_connect(GTK_OBJECT(socket),"destroy",
			   GTK_SIGNAL_FUNC(extern_socket_destroy),
			   ext);
	
	if(!GTK_WIDGET_REALIZED(socket))
		gtk_widget_realize(socket);

	return GDK_WINDOW_XWINDOW(socket->window);
}

void
load_extern_applet(char *goad_id, char *cfgpath, PanelWidget *panel,
		   int pos, gboolean exactpos, gboolean queue)
{
	Extern *ext;
	POA_GNOME_PanelSpot *panelspot_servant;

	if(!cfgpath || !*cfgpath)
		cfgpath = g_strconcat(PANEL_CONFIG_PATH,
				      "Applet_Dummy/",NULL);
	else
		/*we will free this lateer*/
		cfgpath = g_strdup(cfgpath);
	
	ext = g_new0(Extern,1);
	ext->started = FALSE;
	ext->exactpos = exactpos;
	ext->send_position = FALSE;
	ext->send_draw = FALSE;
	ext->orient = -1;

	ext->send_draw_timeout = 0;
	ext->send_draw_queued = FALSE;


	panelspot_servant = (POA_GNOME_PanelSpot *)ext;
	panelspot_servant->_private = NULL;
	panelspot_servant->vepv = &panelspot_vepv;

	POA_GNOME_PanelSpot__init(panelspot_servant, &ev);
	
	CORBA_free(PortableServer_POA_activate_object(thepoa, panelspot_servant, &ev));
	g_return_if_fail(ev._major == CORBA_NO_EXCEPTION);

	ext->pspot = CORBA_OBJECT_NIL; /*will be filled in during add_applet*/
	ext->applet = CORBA_OBJECT_NIL;
	ext->goad_id = g_strdup(goad_id);
	ext->cfg = cfgpath;

	if(reserve_applet_spot (ext, panel, pos, APPLET_EXTERN_PENDING)==0) {
		g_warning(_("Whoops! for some reason we can't add "
			    "to the panel"));
		extern_clean(ext);
		return;
	}

	if(!queue) {
		extern_start_new_goad_id(ext);
		ext->started = TRUE;
	}
}

void
load_queued_externs(void)
{
	GSList *li;
	for(li=applets;li!=NULL;li=g_slist_next(li)) {
		AppletInfo *info = li->data;
		if(info->type == APPLET_EXTERN_PENDING ||
		   info->type == APPLET_EXTERN_RESERVED) {
			Extern *ext = info->data;
			if(!ext->started) {
				extern_start_new_goad_id(ext);
				ext->started = TRUE;
			}
		}
	}
}

/********************* CORBA Stuff *******************/


static GNOME_PanelSpot
s_panel_add_applet(POA_GNOME_Panel *servant,
		   GNOME_Applet panel_applet,
		   CORBA_char *goad_id,
		   CORBA_char ** cfgpath,
		   CORBA_char ** globcfgpath,
		   CORBA_unsigned_long* wid,
		   CORBA_Environment *ev)
{
	return s_panel_add_applet_full(servant,panel_applet,goad_id,0,0,
				       cfgpath,globcfgpath,wid,ev);
}

static GNOME_PanelSpot
s_panel_add_applet_full(POA_GNOME_Panel *servant,
			GNOME_Applet panel_applet,
			CORBA_char *goad_id,
			CORBA_short panel,
			CORBA_short pos,
			CORBA_char ** cfgpath,
			CORBA_char ** globcfgpath,
			CORBA_unsigned_long* wid,
			CORBA_Environment *ev)
{
	GSList *li;
	Extern *ext;
	char *p;
	POA_GNOME_PanelSpot *panelspot_servant;
	GNOME_PanelSpot acc;
	
	for(li=applets;li!=NULL;li=g_slist_next(li)) {
		AppletInfo *info = li->data;
		if(info && info->type == APPLET_EXTERN_PENDING) {
			Extern *ext = info->data;
			g_assert(ext);
			g_assert(ext->info == info);
			if(strcmp(ext->goad_id,goad_id)==0) {
				/*we started this and already reserved a spot
				  for it, including the socket widget*/
				GtkWidget *socket =
					GTK_BIN(info->widget)->child;
				g_return_val_if_fail(GTK_IS_SOCKET(socket),
						     NULL);

				ext->applet = CORBA_Object_duplicate(panel_applet, ev);
				*cfgpath = CORBA_string_dup(ext->cfg);
				g_free(ext->cfg);
				ext->cfg = NULL;
				*globcfgpath = CORBA_string_dup(PANEL_CONFIG_PATH);
				info->type = APPLET_EXTERN_RESERVED;
				*wid=GDK_WINDOW_XWINDOW(socket->window);
#ifdef PANEL_DEBUG
				printf("\nSOCKET XID: %lX\n\n", (long)*wid);
#endif

				panelspot_servant = (POA_GNOME_PanelSpot *)ext;
				acc = PortableServer_POA_servant_to_reference(thepoa, panelspot_servant, ev);
				g_return_val_if_fail(ev->_major == CORBA_NO_EXCEPTION,NULL);
				ext->pspot = CORBA_Object_duplicate(acc, ev);
				g_return_val_if_fail(ev->_major == CORBA_NO_EXCEPTION,NULL);

				return CORBA_Object_duplicate(acc, ev);
			}
		}
	}
	
	/*this is an applet that was started from outside, otherwise we would
	  have already reserved a spot for it*/
	ext = g_new0(Extern,1);
	ext->started = FALSE;
	ext->exactpos = FALSE;
	ext->send_position = FALSE;
	ext->send_draw = FALSE;
	ext->orient = -1;

	panelspot_servant = (POA_GNOME_PanelSpot *)ext;
	panelspot_servant->_private = NULL;
	panelspot_servant->vepv = &panelspot_vepv;

	POA_GNOME_PanelSpot__init(panelspot_servant, ev);
	
	CORBA_free(PortableServer_POA_activate_object(thepoa, panelspot_servant, ev));
	g_return_val_if_fail(ev->_major == CORBA_NO_EXCEPTION,NULL);

	acc = PortableServer_POA_servant_to_reference(thepoa, panelspot_servant, ev);
	g_return_val_if_fail(ev->_major == CORBA_NO_EXCEPTION,NULL);

	ext->pspot = CORBA_Object_duplicate(acc, ev);

	g_return_val_if_fail(ev->_major == CORBA_NO_EXCEPTION,NULL);

	ext->applet = CORBA_Object_duplicate(panel_applet, ev);
	ext->goad_id = g_strdup(goad_id);
	ext->cfg = NULL;

	/*select the nth panel*/
	if(panel)
		li = g_slist_nth(panels,panel);
	else
		li = NULL;
	if(!li)
		li = panels;

	*wid = reserve_applet_spot (ext, li->data, pos,
				      APPLET_EXTERN_RESERVED);
	if(*wid == 0) {
		extern_clean(ext);
		*globcfgpath = NULL;
		*cfgpath = NULL;
		return CORBA_OBJECT_NIL;
	}
	p = g_strconcat(PANEL_CONFIG_PATH,"Applet_Dummy/",NULL);
	*cfgpath = CORBA_string_dup(p);
	g_free(p);
	*globcfgpath = CORBA_string_dup (PANEL_CONFIG_PATH);

	return CORBA_Object_duplicate(acc, ev);
}

static void
s_panel_quit(POA_GNOME_Panel *servant, CORBA_Environment *ev)
{
	panel_quit();
}

static CORBA_boolean
s_panel_get_in_drag(POA_GNOME_Panel *servant, CORBA_Environment *ev)
{
	return panel_applet_in_drag;
}

static GNOME_StatusSpot
s_panel_add_status(POA_GNOME_Panel *servant,
		   CORBA_unsigned_long *wid,
		   CORBA_Environment *ev)
{
	POA_GNOME_StatusSpot *statusspot_servant;
	GNOME_StatusSpot acc;
	StatusSpot *ss;
	
	*wid = 0;
	
	ss = new_status_spot();
	if(!ss)
		return CORBA_OBJECT_NIL;
	
	statusspot_servant = (POA_GNOME_StatusSpot *)ss;
	statusspot_servant->_private = NULL;
	statusspot_servant->vepv = &statusspot_vepv;

	POA_GNOME_StatusSpot__init(statusspot_servant, ev);
	
	CORBA_free(PortableServer_POA_activate_object(thepoa, statusspot_servant, ev));
	g_return_val_if_fail(ev->_major == CORBA_NO_EXCEPTION,NULL);

	acc = PortableServer_POA_servant_to_reference(thepoa, statusspot_servant, ev);
	g_return_val_if_fail(ev->_major == CORBA_NO_EXCEPTION,NULL);

	ss->sspot = CORBA_Object_duplicate(acc, ev);

	g_return_val_if_fail(ev->_major == CORBA_NO_EXCEPTION,NULL);

	*wid = ss->wid;
	return CORBA_Object_duplicate(acc, ev);
}

static void
s_panel_notice_config_changes(POA_GNOME_Panel *servant,
			      CORBA_Environment *ev)
{
	load_up_globals();
}


/*** PanelSpot stuff ***/

static CORBA_char *
s_panelspot_get_tooltip(POA_GNOME_PanelSpot *servant,
			CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;
	GtkTooltipsData *d = gtk_tooltips_data_get(ext->ebox);
	if(!d || !d->tip_text)
		return CORBA_string_dup("");
	else
		return CORBA_string_dup(d->tip_text);
}

static void
s_panelspot_set_tooltip(POA_GNOME_PanelSpot *servant,
			CORBA_char *val,
			CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;
	if(val && *val)
		gtk_tooltips_set_tip (panel_tooltips,ext->ebox,val,NULL);
	else
		gtk_tooltips_set_tip (panel_tooltips,ext->ebox,NULL,NULL);
}

static CORBA_short
s_panelspot_get_parent_panel(POA_GNOME_PanelSpot *servant,
			     CORBA_Environment *ev)
{
	int panel;
	GSList *list;
	gpointer p;
	Extern *ext = (Extern *)servant;

	g_assert(ext);
	g_assert(ext->info);

	p = PANEL_WIDGET(ext->info->widget->parent);

	for(panel=0,list=panels;list!=NULL;list=g_slist_next(list),panel++)
		if(list->data == p)
			return panel;
	return -1;
}

static CORBA_short
s_panelspot_get_spot_pos(POA_GNOME_PanelSpot *servant,
			 CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;
	AppletData *ad;

	g_assert(ext);
	g_assert(ext->info);
	
	ad = gtk_object_get_data(GTK_OBJECT(ext->info->widget),
				 PANEL_APPLET_DATA);
	if(!ad)
		return -1;
	return ad->pos;
}

static GNOME_Panel_OrientType
s_panelspot_get_parent_orient(POA_GNOME_PanelSpot *servant,
			      CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;
	PanelWidget *panel;

	g_assert(ext);
	g_assert(ext->info);

	panel = PANEL_WIDGET(ext->info->widget->parent);

	g_return_val_if_fail(panel != NULL,ORIENT_UP);

	return get_applet_orient(panel);
}

static GNOME_Panel_SizeType
s_panelspot_get_parent_size(POA_GNOME_PanelSpot *servant,
			    CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;
	PanelWidget *panel;

	g_assert(ext);
	g_assert(ext->info);

	panel = PANEL_WIDGET(ext->info->widget->parent);

	g_return_val_if_fail(panel != NULL,SIZE_STANDARD);

	return panel->sz;
}

static CORBA_short
s_panelspot_get_free_space(POA_GNOME_PanelSpot *servant,
			   CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;
	PanelWidget *panel;

	g_assert(ext);
	g_assert(ext->info);

	panel = PANEL_WIDGET(ext->info->widget->parent);
	
	return panel_widget_get_free_space(panel,ext->info->widget);
}

static CORBA_boolean
s_panelspot_get_send_position(POA_GNOME_PanelSpot *servant,
			      CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

	g_assert(ext);
	
	return ext->send_position;
}

static void
s_panelspot_set_send_position(POA_GNOME_PanelSpot *servant,
			      CORBA_boolean enable,
			      CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

	g_assert(ext);
	
	ext->send_position = enable?TRUE:FALSE;
}

static CORBA_boolean
s_panelspot_get_send_draw(POA_GNOME_PanelSpot *servant,
			  CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

	g_assert(ext);
	
	return ext->send_draw;
}

static void
s_panelspot_set_send_draw(POA_GNOME_PanelSpot *servant,
			  CORBA_boolean enable,
			  CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

	g_assert(ext);
	
	ext->send_draw = enable?TRUE:FALSE;
}

static GNOME_Panel_RgbImage *
s_panelspot_get_rgb_background(POA_GNOME_PanelSpot *servant,
			       CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;
	PanelWidget *panel;
	GNOME_Panel_RgbImage *image;
	int w, h, rowstride;
	guchar *rgb;
	int r,g,b;

	g_assert(ext);
	g_assert(ext->info);

	panel = PANEL_WIDGET(ext->info->widget->parent);

	panel_widget_get_applet_rgb_bg(panel, ext->ebox,
				       &rgb,&w,&h,&rowstride,
				       TRUE,&r,&g,&b);

	image = GNOME_Panel_RgbImage__alloc();
	image->width = w;
	image->height = h;
		
	/* if we got an rgb */
	if(rgb) {
		image->data._buffer = CORBA_sequence_CORBA_octet_allocbuf(h*rowstride);
		image->data._length = image->data._maximum = h*rowstride;
		memcpy(image->data._buffer,rgb,sizeof(guchar)*h*rowstride);
		image->rowstride = rowstride;
		image->color_only = FALSE;
	} else { /* we must have gotten a color */
		image->data._buffer = CORBA_sequence_CORBA_octet_allocbuf(3);
		image->data._length = image->data._maximum = 3;
		*(image->data._buffer) = r;
		*(image->data._buffer+1) = g;
		*(image->data._buffer+2) = b;
		image->rowstride = 0;
		image->color_only = TRUE;
	}
	CORBA_sequence_set_release(&image->data, TRUE);

	return image;
}

static void
s_panelspot_register_us(POA_GNOME_PanelSpot *servant,
			CORBA_Environment *ev)
{
	PanelWidget *panel;
	Extern *ext = (Extern *)servant;

	g_assert(ext);
	g_assert(ext->info);
	
#ifdef PANEL_DEBUG
	printf("register ext: %lX\n",(long)ext);
	printf("register ext->info: %lX\n",(long)(ext->info));
#endif

	panel = PANEL_WIDGET(ext->info->widget->parent);
	g_return_if_fail(panel!=NULL);

	/*no longer pending*/
	ext->info->type = APPLET_EXTERN;

	orientation_change(ext->info,panel);
	size_change(ext->info,panel);
	back_change(ext->info,panel);
	if(ext->send_position)
		send_position_change(ext);

	GNOME_Applet_set_tooltips_state(ext->applet,
					global_config.tooltips_enabled, ev);
	if(ev->_major)
		panel_clean_applet(ext->info);
}

static void
s_panelspot_unregister_us(POA_GNOME_PanelSpot *servant,
			  CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;
	panel_clean_applet(ext->info);
}

static void
s_panelspot_abort_load(POA_GNOME_PanelSpot *servant,
		       CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

	g_return_if_fail(ext != NULL);

	g_return_if_fail(ext->info != NULL);
	
	/*only reserved spots can be canceled, if an applet
	  wants to chance a pending applet it needs to first
	  user reserve spot to obtain id and make it EXTERN_RESERVED*/
	if(ext->info->type != APPLET_EXTERN_RESERVED)
		return;

	panel_clean_applet(ext->info);
}

static void
s_panelspot_show_menu(POA_GNOME_PanelSpot *servant,
		      CORBA_Environment *ev)
{
	GtkWidget *panel;
	Extern *ext = (Extern *)servant;
	
#ifdef PANEL_DEBUG
	printf("show menu ext: %lX\n",(long)ext);
	printf("show menu ext->info: %lX\n",(long)(ext->info));
#endif

	g_return_if_fail(ext != NULL);
	g_return_if_fail(ext->info != NULL);

	if (!ext->info->menu)
		create_applet_menu(ext->info);

	panel = get_panel_parent(ext->info->widget);

	BASEP_WIDGET(panel)->autohide_inhibit = TRUE;
	basep_widget_queue_autohide(BASEP_WIDGET(panel));
	
	ext->info->menu_age = 0;
	gtk_menu_popup(GTK_MENU(ext->info->menu), NULL, NULL,
		       global_config.off_panel_popups?applet_menu_position:NULL,
		       ext->info, 3, GDK_CURRENT_TIME);
}


static void
s_panelspot_drag_start(POA_GNOME_PanelSpot *servant,
		       CORBA_Environment *ev)
{
	PanelWidget *panel;
	Extern *ext = (Extern *)servant;

	g_return_if_fail(ext != NULL);
	g_return_if_fail(ext->info != NULL);

	panel = PANEL_WIDGET(ext->info->widget->parent);

	g_return_if_fail(panel!=NULL);

	/*panel_widget_applet_drag_start(panel,info->widget);
	panel_widget_applet_drag_end(panel);*/
	panel_widget_applet_drag_start(panel,ext->info->widget);
}

static void
s_panelspot_drag_stop(POA_GNOME_PanelSpot *servant,
		      CORBA_Environment *ev)
{
	PanelWidget *panel;
	Extern *ext = (Extern *)servant;

	g_return_if_fail(ext != NULL);
	g_return_if_fail(ext->info != NULL);

	panel = PANEL_WIDGET(ext->info->widget->parent);

	g_return_if_fail(panel!=NULL);

	panel_widget_applet_drag_end(panel);
}

static void
s_panelspot_add_callback(POA_GNOME_PanelSpot *servant,
			 CORBA_char *callback_name,
			 CORBA_char *stock_item,
			 CORBA_char *menuitem_text,
			 CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

#ifdef PANEL_DEBUG
	printf("add callback ext: %lX\n",(long)ext);
#endif

	g_return_if_fail(ext != NULL);
	g_return_if_fail(ext->info != NULL);
	applet_add_callback(ext->info, callback_name, stock_item,
			    menuitem_text);
}

static void
s_panelspot_remove_callback(POA_GNOME_PanelSpot *servant,
			    CORBA_char *callback_name,
			    CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

	g_return_if_fail(ext != NULL);
	g_return_if_fail(ext->info != NULL);
	applet_remove_callback(ext->info, callback_name);
}

static void
s_panelspot_callback_set_sensitive(POA_GNOME_PanelSpot *servant,
				   CORBA_char *callback_name,
				   CORBA_boolean sensitive,
				   CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

	g_return_if_fail(ext != NULL);
	g_return_if_fail(ext->info != NULL);
	applet_callback_set_sensitive(ext->info, callback_name, sensitive);
}

static void
s_panelspot_sync_config(POA_GNOME_PanelSpot *servant,
			CORBA_Environment *ev)
{
	Extern *ext = (Extern *)servant;

	g_return_if_fail(ext != NULL);
	g_return_if_fail(ext->info != NULL);
	applets_to_sync = TRUE;
	panel_config_sync();
}

static int
save_next_idle(gpointer data)
{
	save_next_applet();
	return FALSE;
}

static void
s_panelspot_done_session_save(POA_GNOME_PanelSpot *servant,
			      CORBA_boolean ret,
			      CORBA_unsigned_long cookie,
			      CORBA_Environment *ev)
{
	GSList *cur;
	AppletInfo *info;
	char *buf;
	PanelWidget *panel;
	AppletData *ad;
	Extern *ext;
	int panel_num;
	
	/*ignore bad cookies*/
	if(cookie != ss_cookie)
		return;

	/*increment cookie to kill the timeout warning*/
	ss_cookie++;
	
	if(ss_timeout_dlg) {
		gtk_widget_destroy(ss_timeout_dlg);
		ss_timeout_dlg = NULL;
	}

	if(g_slist_length(applets)<=ss_cur_applet) {
		ss_done_save = TRUE;
		return;
	}
	
	cur = g_slist_nth(applets,ss_cur_applet);
	
	if(!cur) {
		ss_done_save = TRUE;
		return;
	}
	
	info = cur->data;

	/*hmm, this came from a different applet?, we are
	  getting seriously confused*/
	if(info->type!=APPLET_EXTERN ||
	   (gpointer)servant!=(gpointer)info->data) {
		applets_to_sync = TRUE; /*we need to redo this yet again*/
		/*save next applet, but from an idle handler, so that
		  this call returns*/
		gtk_idle_add(save_next_idle,NULL);
		return;
	}
	
	ext = info->data;
	
	buf = g_strdup_printf("%sApplet_Config/Applet_%d/", PANEL_CONFIG_PATH, info->applet_id+1);
	gnome_config_push_prefix(buf);
	g_free(buf);

	panel = PANEL_WIDGET(info->widget->parent);
	ad = gtk_object_get_data(GTK_OBJECT(info->widget),PANEL_APPLET_DATA);

	if((panel_num = g_slist_index(panels,panel)) == -1) {
		gnome_config_set_string("id", EMPTY_ID);
		gnome_config_pop_prefix();
		gnome_config_sync();
		/*save next applet, but from an idle handler, so that
		  this call returns*/
		gtk_idle_add(save_next_idle,NULL);
		return;
	}
		
	/*have the applet do it's own session saving*/
	if(ret) {
		gnome_config_set_string("id", EXTERN_ID);
		gnome_config_set_string("goad_id",
					ext->goad_id);
	} else {
		gnome_config_set_string("id", EMPTY_ID);
		gnome_config_pop_prefix();
		gnome_config_sync();
		/*save next applet, but from an idle handler, so that
		  this call returns*/
		gtk_idle_add(save_next_idle,NULL);
		return;
	}
	
	gnome_config_set_int("position", ad->pos);
	gnome_config_set_int("panel", panel_num);
	gnome_config_set_bool("right_stick",
			      panel_widget_is_applet_stuck(panel,
							   info->widget));
	gnome_config_pop_prefix();
	
	gnome_config_sync();
	/*save next applet, but from an idle handler, so that
	  this call returns*/
	gtk_idle_add(save_next_idle,NULL);
}

/*** StatusSpot stuff ***/

static void
s_statusspot_remove(POA_GNOME_StatusSpot *servant,
		    CORBA_Environment *ev)
{
	StatusSpot *ss = (StatusSpot *)servant;
	status_spot_remove(ss, TRUE);
}


void
panel_corba_clean_up(void)
{
  goad_server_unregister(CORBA_OBJECT_NIL, "gnome_panel", "server", &ev);
  CORBA_ORB_shutdown(orb, CORBA_FALSE, &ev);
}

gint
panel_corba_gtk_init(CORBA_ORB panel_orb)
{
  GNOME_Panel acc;
  CORBA_Object old_server;
  gint status;

  CORBA_exception_init(&ev);

  orb = panel_orb;

  POA_GNOME_Panel__init(&panel_servant, &ev);
  g_return_val_if_fail(ev._major == CORBA_NO_EXCEPTION, -1);

  thepoa = (PortableServer_POA)
    CORBA_ORB_resolve_initial_references(orb, "RootPOA", &ev);
  g_return_val_if_fail(ev._major == CORBA_NO_EXCEPTION, -1);

  PortableServer_POAManager_activate(PortableServer_POA__get_the_POAManager(thepoa, &ev), &ev);
  g_return_val_if_fail(ev._major == CORBA_NO_EXCEPTION, -1);

  CORBA_free(PortableServer_POA_activate_object(thepoa,
						&panel_servant, &ev));
  g_return_val_if_fail(ev._major == CORBA_NO_EXCEPTION, -1);

  acc = PortableServer_POA_servant_to_reference(thepoa, &panel_servant, &ev);
  g_return_val_if_fail(ev._major == CORBA_NO_EXCEPTION, -1);

  old_server = goad_server_activate_with_repo_id (NULL, "IDL:GNOME/Panel:1.0", 
						  GOAD_ACTIVATE_EXISTING_ONLY,
						  NULL);

  if(! CORBA_Object_is_nil(old_server, &ev)) {
    CORBA_Object_release(old_server, &ev);
    return -4;
  }

  status = goad_server_register(CORBA_OBJECT_NIL, acc, "gnome_panel", "server", &ev);

  /*
  CORBA_Object_release(acc, &ev);
  */
  g_return_val_if_fail(ev._major == CORBA_NO_EXCEPTION, -1);

  return status;
}

static void
send_draw(Extern *ext)
{
	CORBA_Environment ev;

	CORBA_exception_init(&ev);
	GNOME_Applet_draw(ext->applet, &ev);
	if(ev._major)
		panel_clean_applet(ext->info);
	CORBA_exception_free(&ev);
}

static int
send_draw_timeout(gpointer data)
{
	Extern *ext = data;
	if(ext->send_draw_queued == TRUE) {
		ext->send_draw_queued = FALSE;
		send_draw(ext);
		return TRUE;
	}
	ext->send_draw_timeout = 0;
	return FALSE;
}

void
extern_send_draw(Extern *ext)
{
	if(!ext || !ext->applet || !ext->send_draw)
		return;
	if(!ext->send_draw_timeout) {
		ext->send_draw_queued = FALSE;
		send_draw(ext);
		ext->send_draw_timeout =
			gtk_timeout_add(1000,send_draw_timeout,ext);
	} else 
		ext->send_draw_queued = TRUE;
}
