/*
 * GNOME menu editor revision 2
 * (C)1999
 *
 * Authors: John Ellis <johne@bellatlantic.net>
 *          Nat Friedman <nat@nat.org>
 *
 */

#include "gmenu.h"

/*
 *-----------------------------------------------------------------------------
 * .order file read and write functions
 *-----------------------------------------------------------------------------
 */

GList *get_order_of_dir(gchar *dir)
{
	gchar buf[256];
	GList *list = NULL;
	gchar *order_file = g_strconcat(dir, "/.order", NULL);
	FILE *f;

	f = fopen(order_file,"r");
	if (!f)
		{
		g_free(order_file);
		return NULL;
		}

	while(fgets(buf, 255, f)!=NULL)
		{
		char *buf_ptr;
		buf_ptr = strchr(buf,'\n');
		if (buf_ptr) buf_ptr[0] = '\0';
		if (strlen(buf) > 0) list = g_list_append(list,g_strdup(buf));
		}

	fclose(f);

	g_free(order_file);
	return list;
}

void save_order_of_dir(GtkCTree *ctree, GtkCTreeNode *node, gint is_parent)
{
	GtkCTreeNode *parent;
	GtkCTreeNode *work;
	gchar *order_file;
	Desktop_Data *dd;
	FILE *f;

	if (!node) return;
	if (is_parent)
		{
		dd = gtk_ctree_node_get_row_data(ctree, node);
		if (dd->isfolder)
			parent = node;
		else
			parent = GTK_CTREE_ROW(node)->parent;
		}
	else
		{
		parent = GTK_CTREE_ROW(node)->parent;
		}
	if (!parent) return;

	dd = gtk_ctree_node_get_row_data(ctree, parent);
        order_file = g_concat_dir_and_file(dd->path, "/.order");

	work = GTK_CTREE_ROW(parent)->children;
	if (work)
		{
		f = fopen(order_file, "w");
		if (!f)
			{
			g_print(_("Unable to create file: %s\n"), order_file);
                        g_free(order_file);
                        return;
			}
		while(work)
			{
			dd = gtk_ctree_node_get_row_data(ctree, work);
			fprintf(f, "%s\n", dd->path + g_filename_index(dd->path));
			work = GTK_CTREE_ROW(work)->sibling;
			}
		fclose(f);
		}
	else
		{
		/* the folder is empty, so delete the .order file */
		if (g_file_exists(order_file))
			{
			if (unlink (order_file) < 0)
				g_print(_("unable to remove .order file: %s\n"), order_file);
			}
		}

	g_free(order_file);
}

