#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))

#include <src/RecordingsStore.h>
#include <gee/hashmap.h>
#include <gee/map.h>
#include <time.h>
#include "src/ChangeType.h"
#include "src/Utils.h"




struct _DVBRecordingsStorePrivate {
	GStaticRecMutex __lock_recordings;
	GeeHashMap* recordings;
	GStaticRecMutex __lock_last_id;
	guint32 last_id;
};

#define DVB_RECORDINGS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStorePrivate))
enum  {
	DVB_RECORDINGS_STORE_DUMMY_PROPERTY
};
static DVBRecordingsStore* dvb_recordings_store_instance;
static void _dvb_recordings_store_on_recording_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1);
static char* dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id);
static char* dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id);
static char* dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id);
static guint* dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, int* result_length1);
static gint64 dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id);
static gint64 dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id);
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id);
static gboolean dvb_recordings_store_delete_recording_by_location (DVBRecordingsStore* self, const char* location);
static void dvb_recordings_store_on_recording_file_changed (DVBRecordingsStore* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event);
static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_recordings_store_parent_class = NULL;
static DVBIDBusRecordingsStoreIface* dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = NULL;
static void dvb_recordings_store_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



DVBRecordingsStore* dvb_recordings_store_get_instance (void) {
	/* TODO make thread-safe*/
	if (dvb_recordings_store_instance == NULL) {
		DVBRecordingsStore* _tmp0;
		_tmp0 = NULL;
		dvb_recordings_store_instance = (_tmp0 = dvb_recordings_store_new (), (dvb_recordings_store_instance == NULL ? NULL : (dvb_recordings_store_instance = (g_object_unref (dvb_recordings_store_instance), NULL))), _tmp0);
	}
	return dvb_recordings_store_instance;
}


void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id) {
	g_return_if_fail (DVB_IS_RECORDINGS_STORE (self));
	g_static_rec_mutex_lock (&self->priv->__lock_last_id);
	{
		if (new_last_id > self->priv->last_id) {
			self->priv->last_id = new_last_id;
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_last_id);
}


static void _dvb_recordings_store_on_recording_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	dvb_recordings_store_on_recording_file_changed (self, _sender, file, other_file, event_type);
}


gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec) {
	GError * inner_error;
	guint32 id;
	g_return_val_if_fail (DVB_IS_RECORDINGS_STORE (self), FALSE);
	g_return_val_if_fail (DVB_IS_RECORDING (rec), FALSE);
	inner_error = NULL;
	id = dvb_recording_get_Id (rec);
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (id))) {
			g_critical ("RecordingsStore.vala:39: Recording with id %u already available", ((guint) (id)));
			return FALSE;
		}
		{
			GFileMonitor* _tmp1;
			GFileMonitor* monitor;
			_tmp1 = NULL;
			monitor = (_tmp1 = g_file_monitor_file (dvb_recording_get_Location (rec), 0, NULL, &inner_error), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
			if (inner_error != NULL) {
				goto __catch25_g_error;
			}
			g_signal_connect_object (monitor, "changed", ((GCallback) (_dvb_recordings_store_on_recording_file_changed_g_file_monitor_changed)), self, 0);
			(monitor == NULL ? NULL : (monitor = (g_object_unref (monitor), NULL)));
		}
		goto __finally25;
		__catch25_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_warning (e->message);
				(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
			}
		}
		__finally25:
		;
		gee_map_set (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (id), rec);
		g_signal_emit_by_name (G_OBJECT (DVB_ID_BUS_RECORDINGS_STORE (self)), "changed", id, ((guint) (DVB_CHANGE_TYPE_ADDED)));
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	return TRUE;
}


guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self) {
	guint32 val;
	g_return_val_if_fail (DVB_IS_RECORDINGS_STORE (self), 0U);
	val = 0U;
	g_static_rec_mutex_lock (&self->priv->__lock_last_id);
	{
		val = ((self->priv->last_id = self->priv->last_id + 1));
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_last_id);
	return val;
}


/**
         * @returns: A list of ids for all recordings
         */
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1) {
	DVBRecordingsStore * self;
	gint ids_length1;
	guint32* ids;
	guint32* _tmp2;
	self = DVB_RECORDINGS_STORE (base);
	ids = (ids_length1 = 0, NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		guint32* _tmp1;
		gint _tmp0;
		gint i;
		_tmp1 = NULL;
		ids = (_tmp1 = g_new0 (guint32, (_tmp0 = gee_map_get_size (GEE_MAP (self->priv->recordings)))), (ids = (g_free (ids), NULL)), ids_length1 = _tmp0, _tmp1);
		i = 0;
		{
			GeeSet* key_collection;
			GeeIterator* key_it;
			key_collection = gee_map_get_keys (GEE_MAP (self->priv->recordings));
			key_it = gee_iterable_iterator (GEE_ITERABLE (key_collection));
			while (gee_iterator_next (key_it)) {
				guint32 key;
				key = GPOINTER_TO_INT (gee_iterator_get (key_it));
				{
					ids[i] = key;
					i++;
				}
			}
			(key_it == NULL ? NULL : (key_it = (g_object_unref (key_it), NULL)));
			(key_collection == NULL ? NULL : (key_collection = (g_object_unref (key_collection), NULL)));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	_tmp2 = NULL;
	return (_tmp2 = ids, (*result_length1) = ids_length1, _tmp2);
}


/**
         * @rec_id: The id of the recording
         * @returns: The location of the recording on the filesystem
         */
static char* dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id) {
	DVBRecordingsStore * self;
	char* val;
	self = DVB_RECORDINGS_STORE (base);
	val = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))) {
			char* _tmp1;
			DVBRecording* _tmp0;
			_tmp1 = NULL;
			_tmp0 = NULL;
			val = (_tmp1 = g_file_get_path (dvb_recording_get_Location ((_tmp0 = ((DVBRecording*) (gee_map_get (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))))))), (val = (g_free (val), NULL)), _tmp1);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	return val;
}


/**
         * @rec_id: The id of the recording
         * @returns: The name of the recording (e.g. the name of
         * a TV show)
         */
static char* dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id) {
	DVBRecordingsStore * self;
	char* val;
	self = DVB_RECORDINGS_STORE (base);
	val = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))) {
			char* _tmp2;
			const char* _tmp1;
			DVBRecording* _tmp0;
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp0 = NULL;
			val = (_tmp2 = (_tmp1 = dvb_recording_get_Name ((_tmp0 = ((DVBRecording*) (gee_map_get (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id)))))), (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (val = (g_free (val), NULL)), _tmp2);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	return val;
}


/**
         * @rec_id: The id of the recording
         * @returns: A short text describing the recorded item
         * (e.g. the description from EPG)
         */
static char* dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id) {
	DVBRecordingsStore * self;
	char* val;
	self = DVB_RECORDINGS_STORE (base);
	val = g_strdup ("");
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))) {
			char* _tmp2;
			const char* _tmp1;
			DVBRecording* _tmp0;
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp0 = NULL;
			val = (_tmp2 = (_tmp1 = dvb_recording_get_Description ((_tmp0 = ((DVBRecording*) (gee_map_get (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id)))))), (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (val = (g_free (val), NULL)), _tmp2);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	return val;
}


/**
         * @rec_id: The id of the recording
         * @returns: The starting time of the recording
         */
static guint* dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, int* result_length1) {
	DVBRecordingsStore * self;
	gint val_length1;
	guint* val;
	guint* _tmp5;
	self = DVB_RECORDINGS_STORE (base);
	val = (val_length1 = 0, NULL);
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))) {
			guint* _tmp2;
			gint _tmp1;
			DVBRecording* _tmp0;
			_tmp2 = NULL;
			_tmp0 = NULL;
			val = (_tmp2 = dvb_recording_get_start ((_tmp0 = ((DVBRecording*) (gee_map_get (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))))), &_tmp1), (val = (g_free (val), NULL)), val_length1 = _tmp1, _tmp2);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		} else {
			guint* _tmp4;
			guint* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			val = (_tmp4 = (_tmp3 = g_new0 (guint, 0), _tmp3), (val = (g_free (val), NULL)), val_length1 = 0, _tmp4);
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	_tmp5 = NULL;
	return (_tmp5 = val, (*result_length1) = val_length1, _tmp5);
}


/**
         * @rec_id: The id of the recording
         * @returns: Start time as UNIX timestamp
         */
static gint64 dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id) {
	DVBRecordingsStore * self;
	gint64 val;
	self = DVB_RECORDINGS_STORE (base);
	val = ((gint64) (-1));
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))) {
			struct tm _tmp2 = {0};
			DVBRecording* _tmp0;
			struct tm _tmp1 = {0};
			_tmp0 = NULL;
			val = ((gint64) (mktime ((_tmp2 = (dvb_recording_get_StartTime ((_tmp0 = ((DVBRecording*) (gee_map_get (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))))), &_tmp1), _tmp1), &_tmp2))));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	return val;
}


/**
         * @rec_id: The id of the recording
         * @returns: The length of the recording in seconds
         * or -1 if no recording with the given id exists
         */
static gint64 dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id) {
	DVBRecordingsStore * self;
	gint64 val;
	self = DVB_RECORDINGS_STORE (base);
	val = ((gint64) (-1));
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (gee_map_contains (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))) {
			DVBRecording* _tmp0;
			_tmp0 = NULL;
			val = dvb_recording_get_Length ((_tmp0 = ((DVBRecording*) (gee_map_get (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))))));
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	return val;
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success, FALSE otherwises
         *
         * Delete the recording. This deletes all files in the directory
         * created by the Recorder
         */
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id) {
	DVBRecordingsStore * self;
	GError * inner_error;
	gboolean val;
	self = DVB_RECORDINGS_STORE (base);
	inner_error = NULL;
	val = FALSE;
	g_static_rec_mutex_lock (&self->priv->__lock_recordings);
	{
		if (!gee_map_contains (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))) {
			val = FALSE;
		} else {
			DVBRecording* rec;
			g_debug ("RecordingsStore.vala:191: Deleting recording %u", ((guint) (rec_id)));
			rec = ((DVBRecording*) (gee_map_get (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id))));
			{
				GFile* _tmp0;
				_tmp0 = NULL;
				dvb_utils_delete_dir_recursively ((_tmp0 = g_file_get_parent (dvb_recording_get_Location (rec))), &inner_error);
				if (inner_error != NULL) {
					goto __catch26_g_error;
				}
				(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
				gee_map_remove (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id));
				val = TRUE;
			}
			goto __finally26;
			__catch26_g_error:
			{
				GError * e;
				e = inner_error;
				inner_error = NULL;
				{
					g_critical (e->message);
					val = FALSE;
					(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
				}
			}
			__finally26:
			;
			g_signal_emit_by_name (G_OBJECT (DVB_ID_BUS_RECORDINGS_STORE (self)), "changed", rec_id, ((guint) (DVB_CHANGE_TYPE_DELETED)));
			(rec == NULL ? NULL : (rec = (g_object_unref (rec), NULL)));
		}
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
	return val;
}


/**
         * @recordingsbasedir: The directory to search
         *
         * Searches recursively in the given directory
         * for "info.rec" files, restores a new Recording
         * from that file and adds it to itsself.
         */
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir) {
	GError * inner_error;
	char* attrs;
	GFileInfo* info;
	GFileEnumerator* files;
	g_return_if_fail (DVB_IS_RECORDINGS_STORE (self));
	g_return_if_fail (G_IS_FILE (recordingsbasedir));
	inner_error = NULL;
	if (!g_file_query_exists (recordingsbasedir, NULL)) {
		char* _tmp0;
		_tmp0 = NULL;
		g_debug ("RecordingsStore.vala:217: Directory %s does not exist", (_tmp0 = g_file_get_path (recordingsbasedir)));
		_tmp0 = (g_free (_tmp0), NULL);
		return;
	}
	attrs = g_strdup_printf ("%s,%s,%s", G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_ATTRIBUTE_STANDARD_NAME);
	info = NULL;
	{
		GFileInfo* _tmp1;
		_tmp1 = NULL;
		info = (_tmp1 = g_file_query_info (recordingsbasedir, attrs, 0, NULL, &inner_error), (info == NULL ? NULL : (info = (g_object_unref (info), NULL))), _tmp1);
		if (inner_error != NULL) {
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
			attrs = (g_free (attrs), NULL);
			(info == NULL ? NULL : (info = (g_object_unref (info), NULL)));
			return;
		}
	}
	__finally27:
	;
	if (g_file_info_get_file_type (info) != G_FILE_TYPE_DIRECTORY) {
		char* _tmp2;
		_tmp2 = NULL;
		g_critical ("RecordingsStore.vala:232: %s is not a directory", (_tmp2 = g_file_get_path (recordingsbasedir)));
		_tmp2 = (g_free (_tmp2), NULL);
		attrs = (g_free (attrs), NULL);
		(info == NULL ? NULL : (info = (g_object_unref (info), NULL)));
		return;
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		char* _tmp3;
		_tmp3 = NULL;
		g_critical ("RecordingsStore.vala:237: Cannot read %s", (_tmp3 = g_file_get_path (recordingsbasedir)));
		_tmp3 = (g_free (_tmp3), NULL);
		attrs = (g_free (attrs), NULL);
		(info == NULL ? NULL : (info = (g_object_unref (info), NULL)));
		return;
	}
	files = NULL;
	{
		GFileEnumerator* _tmp4;
		_tmp4 = NULL;
		files = (_tmp4 = g_file_enumerate_children (recordingsbasedir, attrs, 0, NULL, &inner_error), (files == NULL ? NULL : (files = (g_object_unref (files), NULL))), _tmp4);
		if (inner_error != NULL) {
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
			attrs = (g_free (attrs), NULL);
			(info == NULL ? NULL : (info = (g_object_unref (info), NULL)));
			(files == NULL ? NULL : (files = (g_object_unref (files), NULL)));
			return;
		}
	}
	__finally28:
	;
	{
		GFileInfo* childinfo;
		GFileInfo* _tmp5;
		childinfo = NULL;
		_tmp5 = NULL;
		while ((childinfo = (_tmp5 = g_file_enumerator_next_file (files, NULL, &inner_error), (childinfo == NULL ? NULL : (childinfo = (g_object_unref (childinfo), NULL))), _tmp5)) != NULL) {
			guint32 type;
			GFile* child;
			guint32 _tmp8;
			type = ((guint32) (g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE)));
			child = g_file_get_child (recordingsbasedir, g_file_info_get_name (childinfo));
			_tmp8 = type;
			if (_tmp8 == G_FILE_TYPE_DIRECTORY)
			do {
				dvb_recordings_store_restore_from_dir (self, child);
				break;
			} while (0); else if (_tmp8 == G_FILE_TYPE_REGULAR)
			do {
				if (_vala_strcmp0 (g_file_info_get_name (childinfo), "info.rec") == 0) {
					DVBRecording* rec;
					rec = NULL;
					{
						DVBRecording* _tmp6;
						_tmp6 = NULL;
						rec = (_tmp6 = dvb_recording_deserialize (child, &inner_error), (rec == NULL ? NULL : (rec = (g_object_unref (rec), NULL))), _tmp6);
						if (inner_error != NULL) {
							goto __catch31_g_error;
						}
					}
					goto __finally31;
					__catch31_g_error:
					{
						GError * e;
						e = inner_error;
						inner_error = NULL;
						{
							g_critical (e->message);
							(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
						}
					}
					__finally31:
					;
					if (rec != NULL) {
						char* _tmp7;
						_tmp7 = NULL;
						g_debug ("RecordingsStore.vala:273: Restored recording from %s", (_tmp7 = g_file_get_path (child)));
						_tmp7 = (g_free (_tmp7), NULL);
						g_static_rec_mutex_lock (&self->priv->__lock_recordings);
						{
							dvb_recordings_store_add (self, rec);
						}
						g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
						g_static_rec_mutex_lock (&self->priv->__lock_last_id);
						{
							if (dvb_recording_get_Id (rec) > self->priv->last_id) {
								self->priv->last_id = dvb_recording_get_Id (rec);
							}
						}
						g_static_rec_mutex_unlock (&self->priv->__lock_last_id);
					}
					(rec == NULL ? NULL : (rec = (g_object_unref (rec), NULL)));
				}
				break;
			} while (0);
			(child == NULL ? NULL : (child = (g_object_unref (child), NULL)));
		}
		(childinfo == NULL ? NULL : (childinfo = (g_object_unref (childinfo), NULL)));
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally29:
	{
		{
			g_file_enumerator_close (files, NULL, &inner_error);
			if (inner_error != NULL) {
				goto __catch32_g_error;
			}
		}
		goto __finally32;
		__catch32_g_error:
		{
			GError * e;
			e = inner_error;
			inner_error = NULL;
			{
				g_critical (e->message);
				(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
			}
		}
		__finally32:
		;
	}
	attrs = (g_free (attrs), NULL);
	(info == NULL ? NULL : (info = (g_object_unref (info), NULL)));
	(files == NULL ? NULL : (files = (g_object_unref (files), NULL)));
}


/**
         * @location: Path to the .ts file of the recording
         * @returns: TRUE on success
         *
         * Delete a recording by the path of the recording
         */
static gboolean dvb_recordings_store_delete_recording_by_location (DVBRecordingsStore* self, const char* location) {
	guint32 rec_id;
	g_return_val_if_fail (DVB_IS_RECORDINGS_STORE (self), FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	rec_id = ((guint32) (0));
	{
		GeeSet* id_collection;
		GeeIterator* id_it;
		id_collection = gee_map_get_keys (GEE_MAP (self->priv->recordings));
		id_it = gee_iterable_iterator (GEE_ITERABLE (id_collection));
		while (gee_iterator_next (id_it)) {
			guint32 id;
			id = GPOINTER_TO_INT (gee_iterator_get (id_it));
			{
				DVBRecording* rec;
				char* _tmp0;
				gboolean _tmp1;
				rec = ((DVBRecording*) (gee_map_get (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (id))));
				_tmp0 = NULL;
				if ((_tmp1 = _vala_strcmp0 ((_tmp0 = g_file_get_path (dvb_recording_get_Location (rec))), location) == 0, (_tmp0 = (g_free (_tmp0), NULL)), _tmp1)) {
					rec_id = id;
					(rec == NULL ? NULL : (rec = (g_object_unref (rec), NULL)));
					break;
				}
				(rec == NULL ? NULL : (rec = (g_object_unref (rec), NULL)));
			}
		}
		(id_it == NULL ? NULL : (id_it = (g_object_unref (id_it), NULL)));
		(id_collection == NULL ? NULL : (id_collection = (g_object_unref (id_collection), NULL)));
	}
	if (rec_id != 0) {
		g_debug ("RecordingsStore.vala:316: Deleting recording %u", ((guint) (rec_id)));
		gee_map_remove (GEE_MAP (self->priv->recordings), GINT_TO_POINTER (rec_id));
		g_signal_emit_by_name (G_OBJECT (DVB_ID_BUS_RECORDINGS_STORE (self)), "changed", rec_id, ((guint) (DVB_CHANGE_TYPE_DELETED)));
		return TRUE;
	}
	return FALSE;
}


static void dvb_recordings_store_on_recording_file_changed (DVBRecordingsStore* self, GFileMonitor* monitor, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	g_return_if_fail (DVB_IS_RECORDINGS_STORE (self));
	g_return_if_fail (G_IS_FILE_MONITOR (monitor));
	g_return_if_fail (G_IS_FILE (file));
	g_return_if_fail (other_file == NULL || G_IS_FILE (other_file));
	if (event == G_FILE_MONITOR_EVENT_DELETED) {
		char* location;
		location = g_file_get_path (file);
		g_debug ("RecordingsStore.vala:329: %s has been deleted", location);
		dvb_recordings_store_delete_recording_by_location (self, location);
		g_file_monitor_cancel (monitor);
		location = (g_free (location), NULL);
	}
}


/**
     * This class manages the recordings off all devices
     */
DVBRecordingsStore* dvb_recordings_store_construct (GType object_type) {
	DVBRecordingsStore * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBRecordingsStore* dvb_recordings_store_new (void) {
	return dvb_recordings_store_construct (DVB_TYPE_RECORDINGS_STORE);
}


static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBRecordingsStoreClass * klass;
	GObjectClass * parent_class;
	DVBRecordingsStore * self;
	klass = DVB_RECORDINGS_STORE_CLASS (g_type_class_peek (DVB_TYPE_RECORDINGS_STORE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDINGS_STORE (obj);
	{
		GeeHashMap* _tmp0;
		_tmp0 = NULL;
		self->priv->recordings = (_tmp0 = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_hash, g_direct_equal, g_direct_equal), (self->priv->recordings == NULL ? NULL : (self->priv->recordings = (g_object_unref (self->priv->recordings), NULL))), _tmp0);
		self->priv->last_id = ((guint32) (0));
	}
	return obj;
}


static void dvb_recordings_store_class_init (DVBRecordingsStoreClass * klass) {
	dvb_recordings_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingsStorePrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_recordings_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recordings_store_finalize;
}


static void dvb_recordings_store_dvb_id_bus_recordings_store_interface_init (DVBIDBusRecordingsStoreIface * iface) {
	dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetRecordings = dvb_recordings_store_real_GetRecordings;
	iface->GetLocation = dvb_recordings_store_real_GetLocation;
	iface->GetName = dvb_recordings_store_real_GetName;
	iface->GetDescription = dvb_recordings_store_real_GetDescription;
	iface->GetStartTime = dvb_recordings_store_real_GetStartTime;
	iface->GetStartTimestamp = dvb_recordings_store_real_GetStartTimestamp;
	iface->GetLength = dvb_recordings_store_real_GetLength;
	iface->Delete = dvb_recordings_store_real_Delete;
}


static void dvb_recordings_store_instance_init (DVBRecordingsStore * self) {
	self->priv = DVB_RECORDINGS_STORE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_recordings);
	g_static_rec_mutex_init (&self->priv->__lock_last_id);
}


static void dvb_recordings_store_finalize (GObject* obj) {
	DVBRecordingsStore * self;
	self = DVB_RECORDINGS_STORE (obj);
	g_static_rec_mutex_free (&self->priv->__lock_recordings);
	(self->priv->recordings == NULL ? NULL : (self->priv->recordings = (g_object_unref (self->priv->recordings), NULL)));
	g_static_rec_mutex_free (&self->priv->__lock_last_id);
	G_OBJECT_CLASS (dvb_recordings_store_parent_class)->finalize (obj);
}


GType dvb_recordings_store_get_type (void) {
	static GType dvb_recordings_store_type_id = 0;
	if (dvb_recordings_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recordings_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecordingsStore), 0, (GInstanceInitFunc) dvb_recordings_store_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recordings_store_info = { (GInterfaceInitFunc) dvb_recordings_store_dvb_id_bus_recordings_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_recordings_store_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecordingsStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recordings_store_type_id, DVB_TYPE_ID_BUS_RECORDINGS_STORE, &dvb_id_bus_recordings_store_info);
	}
	return dvb_recordings_store_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




