
#include <src/IDBusChannelList.h>

typedef DBusGProxy DVBIDBusChannelListDBusProxy;
typedef DBusGProxyClass DVBIDBusChannelListDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_channel_list_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_channel_list_introspect (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_property_get (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_property_set (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_property_get_all (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_channel_list_changed (GObject* _sender, guint channel_id, guint type, DBusConnection* _connection);
static guint* dvb_id_bus_channel_list_dbus_proxy_GetChannels (DVBIDBusChannelList* self, int* result_length1);
static guint* dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1);
static guint* dvb_id_bus_channel_list_dbus_proxy_GetTVChannels (DVBIDBusChannelList* self, int* result_length1);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelName (DVBIDBusChannelList* self, guint channel_id);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id);
static gboolean dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelURL (DVBIDBusChannelList* self, guint channel_id);
static void dvb_id_bus_channel_list_dbus_proxy_interface_init (DVBIDBusChannelListIface* iface);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _dvb_id_bus_channel_list_dbus_path_vtable = {_dvb_id_bus_channel_list_dbus_unregister, dvb_id_bus_channel_list_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_channel_list_dbus_vtable = {dvb_id_bus_channel_list_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @returns: List of channel IDs aka SIDs of all channels
         */
guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannels (self, result_length1);
}


/**
         * @returns: List of channel IDs aka SIDs of radio channels
         */
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetRadioChannels (self, result_length1);
}


/**
         * @returns: List of channel IDs aka SIDs of TV channels
         */
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetTVChannels (self, result_length1);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of channel if channel with id exists
         * otherwise an empty string
         */
char* dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelName (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of network the channel belongs to
         * if the channel with id exists, otherwise an empty
         * string
         */
char* dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelNetwork (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: Whether the channel is a radio channel or not
         */
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->IsRadioChannel (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: URL to watch the channel
         */
char* dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelURL (self, channel_id);
}


void _dvb_id_bus_channel_list_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_introspect (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.ChannelList\">\n  <method name=\"GetChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRadioChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTVChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelNetwork\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRadioChannel\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelURL\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"channel_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_property_get (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	return NULL;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_property_set (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	return NULL;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_property_get_all (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp4;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp4);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp4);
	if (strcmp (interface_name, "org.gnome.DVB.ChannelList") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	DBusMessageIter _tmp5;
	int _tmp6;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp5);
	for (_tmp6 = 0; _tmp6 < result_length1; _tmp6++) {
		dbus_uint32_t _tmp7;
		_tmp7 = result[_tmp6];
		dbus_message_iter_append_basic (&_tmp5, DBUS_TYPE_UINT32, &_tmp7);
	}
	dbus_message_iter_close_container (&iter, &_tmp5);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	DBusMessageIter _tmp8;
	int _tmp9;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetRadioChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp8);
	for (_tmp9 = 0; _tmp9 < result_length1; _tmp9++) {
		dbus_uint32_t _tmp10;
		_tmp10 = result[_tmp9];
		dbus_message_iter_append_basic (&_tmp8, DBUS_TYPE_UINT32, &_tmp10);
	}
	dbus_message_iter_close_container (&iter, &_tmp8);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	DBusMessageIter _tmp11;
	int _tmp12;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetTVChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp11);
	for (_tmp12 = 0; _tmp12 < result_length1; _tmp12++) {
		dbus_uint32_t _tmp13;
		_tmp13 = result[_tmp12];
		dbus_message_iter_append_basic (&_tmp11, DBUS_TYPE_UINT32, &_tmp13);
	}
	dbus_message_iter_close_container (&iter, &_tmp11);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp14;
	char* result;
	DBusMessage* reply;
	const char* _tmp15;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp14);
	dbus_message_iter_next (&iter);
	channel_id = _tmp14;
	result = dvb_id_bus_channel_list_GetChannelName (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp15 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp15);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp16;
	char* result;
	DBusMessage* reply;
	const char* _tmp17;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp16);
	dbus_message_iter_next (&iter);
	channel_id = _tmp16;
	result = dvb_id_bus_channel_list_GetChannelNetwork (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp17 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp17);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp18;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp19;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp18);
	dbus_message_iter_next (&iter);
	channel_id = _tmp18;
	result = dvb_id_bus_channel_list_IsRadioChannel (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp19 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp19);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp20;
	char* result;
	DBusMessage* reply;
	const char* _tmp21;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp20);
	dbus_message_iter_next (&iter);
	channel_id = _tmp20;
	result = dvb_id_bus_channel_list_GetChannelURL (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp21 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp21);
	return reply;
}


DBusHandlerResult dvb_id_bus_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_channel_list_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		reply = _dbus_dvb_id_bus_channel_list_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Set")) {
		reply = _dbus_dvb_id_bus_channel_list_property_set (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_channel_list_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetRadioChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetRadioChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetTVChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetTVChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelName")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelNetwork")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelNetwork (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "IsRadioChannel")) {
		reply = _dbus_dvb_id_bus_channel_list_IsRadioChannel (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelURL")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelURL (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_channel_list_changed (GObject* _sender, guint channel_id, guint type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp22;
	dbus_uint32_t _tmp23;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.ChannelList", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp22 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp22);
	_tmp23 = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp23);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_channel_list_dbus_path_vtable, object);
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_channel_list_changed, connection);
}


static void dvb_id_bus_channel_list_base_init (DVBIDBusChannelListIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", DVB_TYPE_ID_BUS_CHANNEL_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_CHANNEL_LIST, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_channel_list_dbus_vtable));
	}
}


GType dvb_id_bus_channel_list_get_type (void) {
	static GType dvb_id_bus_channel_list_type_id = 0;
	if (dvb_id_bus_channel_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusChannelListIface), (GBaseInitFunc) dvb_id_bus_channel_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_channel_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusChannelList", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_channel_list_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_channel_list_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusChannelListDBusProxy, dvb_id_bus_channel_list_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_CHANNEL_LIST, dvb_id_bus_channel_list_dbus_proxy_interface_init));
DVBIDBusChannelList* dvb_id_bus_channel_list_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	return g_object_new (dvb_id_bus_channel_list_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.ChannelList", NULL);
}


static void dvb_id_bus_channel_list_dbus_proxy_class_init (DVBIDBusChannelListDBusProxyClass* klass) {
}


static void dvb_id_bus_channel_list_dbus_proxy_init (DVBIDBusChannelListDBusProxy* self) {
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp24;
	int _tmp24_length;
	int _tmp24_size;
	int _tmp24_length1;
	DBusMessageIter _tmp25;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp24 = NULL;
	_tmp24_length = 0;
	_tmp24_size = 0;
	_tmp24_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp25);
	for (; dbus_message_iter_get_arg_type (&_tmp25); _tmp24_length1++) {
		dbus_uint32_t _tmp26;
		if (_tmp24_size == _tmp24_length) {
			_tmp24_size = (_tmp24_size > 0) ? (2 * _tmp24_size) : 4;
			_tmp24 = g_renew (guint, _tmp24, _tmp24_size);
		}
		dbus_message_iter_get_basic (&_tmp25, &_tmp26);
		dbus_message_iter_next (&_tmp25);
		_tmp24[_tmp24_length++] = _tmp26;
	}
	_result_length1 = _tmp24_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp24;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp27;
	int _tmp27_length;
	int _tmp27_size;
	int _tmp27_length1;
	DBusMessageIter _tmp28;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetRadioChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp27 = NULL;
	_tmp27_length = 0;
	_tmp27_size = 0;
	_tmp27_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp28);
	for (; dbus_message_iter_get_arg_type (&_tmp28); _tmp27_length1++) {
		dbus_uint32_t _tmp29;
		if (_tmp27_size == _tmp27_length) {
			_tmp27_size = (_tmp27_size > 0) ? (2 * _tmp27_size) : 4;
			_tmp27 = g_renew (guint, _tmp27, _tmp27_size);
		}
		dbus_message_iter_get_basic (&_tmp28, &_tmp29);
		dbus_message_iter_next (&_tmp28);
		_tmp27[_tmp27_length++] = _tmp29;
	}
	_result_length1 = _tmp27_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp27;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetTVChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp30;
	int _tmp30_length;
	int _tmp30_size;
	int _tmp30_length1;
	DBusMessageIter _tmp31;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetTVChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp30 = NULL;
	_tmp30_length = 0;
	_tmp30_size = 0;
	_tmp30_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp31);
	for (; dbus_message_iter_get_arg_type (&_tmp31); _tmp30_length1++) {
		dbus_uint32_t _tmp32;
		if (_tmp30_size == _tmp30_length) {
			_tmp30_size = (_tmp30_size > 0) ? (2 * _tmp30_size) : 4;
			_tmp30 = g_renew (guint, _tmp30, _tmp30_size);
		}
		dbus_message_iter_get_basic (&_tmp31, &_tmp32);
		dbus_message_iter_next (&_tmp31);
		_tmp30[_tmp30_length++] = _tmp32;
	}
	_result_length1 = _tmp30_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp30;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelName (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp33;
	char* _result;
	const char* _tmp34;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp33 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp33);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp34);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp34);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp35;
	char* _result;
	const char* _tmp36;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelNetwork");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp35 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp35);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp36);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp36);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp37;
	gboolean _result;
	dbus_bool_t _tmp38;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "IsRadioChannel");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp37 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp37);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp38);
	dbus_message_iter_next (&_iter);
	_result = _tmp38;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelURL (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp39;
	char* _result;
	const char* _tmp40;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelURL");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp39 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp39);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp40);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp40);
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_channel_list_dbus_proxy_interface_init (DVBIDBusChannelListIface* iface) {
	iface->GetChannels = dvb_id_bus_channel_list_dbus_proxy_GetChannels;
	iface->GetRadioChannels = dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels;
	iface->GetTVChannels = dvb_id_bus_channel_list_dbus_proxy_GetTVChannels;
	iface->GetChannelName = dvb_id_bus_channel_list_dbus_proxy_GetChannelName;
	iface->GetChannelNetwork = dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork;
	iface->IsRadioChannel = dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel;
	iface->GetChannelURL = dvb_id_bus_channel_list_dbus_proxy_GetChannelURL;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	vtable->register_object (connection, path, object);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



