/* Event.c generated by valac, the Vala compiler
 * generated from Event.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gobject/gvaluecollector.h>


#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_dvb_event_audio_component_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_dvb_event_audio_component_unref (var), NULL)))
#define __g_slist_free_dvb_event_video_component_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_dvb_event_video_component_unref (var), NULL)))
#define __g_slist_free_dvb_event_teletext_component_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_dvb_event_teletext_component_unref (var), NULL)))
typedef struct _DVBEventAudioComponentPrivate DVBEventAudioComponentPrivate;
typedef struct _DVBEventParamSpecAudioComponent DVBEventParamSpecAudioComponent;
typedef struct _DVBEventVideoComponentPrivate DVBEventVideoComponentPrivate;
typedef struct _DVBEventParamSpecVideoComponent DVBEventParamSpecVideoComponent;
typedef struct _DVBEventTeletextComponentPrivate DVBEventTeletextComponentPrivate;
typedef struct _DVBEventParamSpecTeletextComponent DVBEventParamSpecTeletextComponent;
typedef struct _DVBParamSpecEvent DVBParamSpecEvent;

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	char* name;
	char* description;
	char* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

struct _DVBEventAudioComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventAudioComponentPrivate * priv;
	char* type;
};

struct _DVBEventAudioComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventAudioComponent *self);
};

struct _DVBEventParamSpecAudioComponent {
	GParamSpec parent_instance;
};

struct _DVBEventVideoComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventVideoComponentPrivate * priv;
	gboolean high_definition;
	char* aspect_ratio;
	gint frequency;
};

struct _DVBEventVideoComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventVideoComponent *self);
};

struct _DVBEventParamSpecVideoComponent {
	GParamSpec parent_instance;
};

struct _DVBEventTeletextComponent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventTeletextComponentPrivate * priv;
	char* type;
};

struct _DVBEventTeletextComponentClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEventTeletextComponent *self);
};

struct _DVBEventParamSpecTeletextComponent {
	GParamSpec parent_instance;
};

struct _DVBParamSpecEvent {
	GParamSpec parent_instance;
};


static gpointer dvb_event_audio_component_parent_class = NULL;
static gpointer dvb_event_video_component_parent_class = NULL;
static gpointer dvb_event_teletext_component_parent_class = NULL;
static gpointer dvb_event_parent_class = NULL;

gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void);
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void);
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void);
enum  {
	DVB_EVENT_DUMMY_PROPERTY
};
static void _g_slist_free_dvb_event_audio_component_unref (GSList* self);
static void _g_slist_free_dvb_event_video_component_unref (GSList* self);
static void _g_slist_free_dvb_event_teletext_component_unref (GSList* self);
#define DVB_EVENT_RUNNING_STATUS_UNDEFINED ((guint) 0)
#define DVB_EVENT_RUNNING_STATUS_NOT_RUNNING ((guint) 1)
#define DVB_EVENT_RUNNING_STATUS_STARTS_SOON ((guint) 2)
#define DVB_EVENT_RUNNING_STATUS_PAUSING ((guint) 3)
#define DVB_EVENT_RUNNING_STATUS_RUNNING ((guint) 4)
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
gboolean dvb_event_has_expired (DVBEvent* self);
void dvb_event_get_utc_start_time (DVBEvent* self, struct tm* result);
gboolean dvb_event_is_running (DVBEvent* self);
char* dvb_event_to_string (DVBEvent* self);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
gint dvb_event_compare (DVBEvent* event1, DVBEvent* event2);
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2);
guint dvb_event_hash (DVBEvent* event);
enum  {
	DVB_EVENT_AUDIO_COMPONENT_DUMMY_PROPERTY
};
DVBEventAudioComponent* dvb_event_audio_component_new (void);
DVBEventAudioComponent* dvb_event_audio_component_construct (GType object_type);
static void dvb_event_audio_component_finalize (DVBEventAudioComponent* obj);
enum  {
	DVB_EVENT_VIDEO_COMPONENT_DUMMY_PROPERTY
};
DVBEventVideoComponent* dvb_event_video_component_new (void);
DVBEventVideoComponent* dvb_event_video_component_construct (GType object_type);
static void dvb_event_video_component_finalize (DVBEventVideoComponent* obj);
enum  {
	DVB_EVENT_TELETEXT_COMPONENT_DUMMY_PROPERTY
};
DVBEventTeletextComponent* dvb_event_teletext_component_new (void);
DVBEventTeletextComponent* dvb_event_teletext_component_construct (GType object_type);
static void dvb_event_teletext_component_finalize (DVBEventTeletextComponent* obj);
static void dvb_event_finalize (DVBEvent* obj);



static void _g_slist_free_dvb_event_audio_component_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) dvb_event_audio_component_unref, NULL);
	g_slist_free (self);
}


static void _g_slist_free_dvb_event_video_component_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) dvb_event_video_component_unref, NULL);
	g_slist_free (self);
}


static void _g_slist_free_dvb_event_teletext_component_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) dvb_event_teletext_component_unref, NULL);
	g_slist_free (self);
}


DVBEvent* dvb_event_construct (GType object_type) {
	DVBEvent* self;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	self = (DVBEvent*) g_type_create_instance (object_type);
	self->audio_components = (_tmp0_ = NULL, __g_slist_free_dvb_event_audio_component_unref0 (self->audio_components), _tmp0_);
	self->video_components = (_tmp1_ = NULL, __g_slist_free_dvb_event_video_component_unref0 (self->video_components), _tmp1_);
	self->teletext_components = (_tmp2_ = NULL, __g_slist_free_dvb_event_teletext_component_unref0 (self->teletext_components), _tmp2_);
	self->year = (guint) 0;
	self->month = (guint) 0;
	self->hour = (guint) 0;
	self->day = (guint) 0;
	self->minute = (guint) 0;
	self->second = (guint) 0;
	self->duration = (guint) 0;
	self->running_status = DVB_EVENT_RUNNING_STATUS_UNDEFINED;
	return self;
}


DVBEvent* dvb_event_new (void) {
	return dvb_event_construct (DVB_TYPE_EVENT);
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	gmtime_r (&time, &_result_);
	*result = _result_;
	return;
}


gboolean dvb_event_has_expired (DVBEvent* self) {
	gboolean result = FALSE;
	struct tm _tmp0_ = {0};
	struct tm current_utc;
	time_t current_time;
	time_t end_timestamp;
	g_return_val_if_fail (self != NULL, FALSE);
	current_utc = (g_time_gm (time (NULL), &_tmp0_), _tmp0_);
	current_utc.tm_isdst = -1;
	current_time = mktime (&current_utc);
	end_timestamp = dvb_event_get_end_timestamp (self);
	result = end_timestamp < current_time;
	return result;
}


gboolean dvb_event_is_running (DVBEvent* self) {
	gboolean result = FALSE;
	struct tm _tmp0_ = {0};
	struct tm time_now;
	struct tm _tmp1_ = {0};
	struct tm time_start;
	time_t timestamp_now;
	time_t timestamp_start;
	g_return_val_if_fail (self != NULL, FALSE);
	time_now = (g_time_gm (time (NULL), &_tmp0_), _tmp0_);
	time_start = (dvb_event_get_utc_start_time (self, &_tmp1_), _tmp1_);
	timestamp_now = timegm (&time_now);
	timestamp_start = timegm (&time_start);
	if ((timestamp_now - timestamp_start) >= 0) {
		result = !dvb_event_has_expired (self);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


char* dvb_event_to_string (DVBEvent* self) {
	char* result = NULL;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* text;
	g_return_val_if_fail (self != NULL, NULL);
	text = (_tmp2_ = g_strconcat (_tmp0_ = g_strdup_printf ("ID: %u\nDate: %04u-%02u-%02u %02u:%02u:%02u\n", self->id, self->year, self->month, self->day, self->hour, self->minute, self->second), _tmp1_ = g_strdup_printf ("Duration: %u\nName: %s\nDescription: %s\n", self->duration, self->name, self->description), NULL), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				char* _tmp5_;
				char* _tmp4_;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				if (!(i < g_slist_length (self->audio_components))) {
					break;
				}
				text = (_tmp5_ = g_strconcat (text, _tmp4_ = g_strdup_printf ("%s ", ((DVBEventAudioComponent*) g_slist_nth_data (self->audio_components, (guint) i))->type), NULL), _g_free0 (text), _tmp5_);
				_g_free0 (_tmp4_);
			}
		}
	}
	result = text;
	return result;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result) {
	struct tm _tmp0_ = {0};
	struct tm utc_time;
	time_t utc_timestamp;
	struct tm _tmp1_ = {0};
	struct tm local_time;
	g_return_if_fail (self != NULL);
	utc_time = (dvb_event_get_utc_start_time (self, &_tmp0_), _tmp0_);
	utc_timestamp = timegm (&utc_time);
	local_time = (g_time_local (utc_timestamp, &_tmp1_), _tmp1_);
	*result = local_time;
	return;
}


void dvb_event_get_utc_start_time (DVBEvent* self, struct tm* result) {
	struct tm _tmp0_ = {0};
	struct tm utc_time;
	g_return_if_fail (self != NULL);
	utc_time = (dvb_utils_create_utc_time ((gint) self->year, (gint) self->month, (gint) self->day, (gint) self->hour, (gint) self->minute, (gint) self->second, &_tmp0_), _tmp0_);
	*result = utc_time;
	return;
}


time_t dvb_event_get_end_timestamp (DVBEvent* self) {
	time_t result;
	struct tm _tmp0_ = {0};
	struct tm end_time;
	time_t before;
	time_t after;
	end_time = (dvb_utils_create_utc_time ((gint) self->year, (gint) self->month, (gint) self->day, (gint) self->hour, (gint) self->minute, (gint) self->second, &_tmp0_), _tmp0_);
	before = mktime (&end_time);
	end_time.tm_sec = end_time.tm_sec + ((gint) self->duration);
	after = mktime (&end_time);
	g_assert ((after - before) == self->duration);
	result = after;
	return result;
}


gint dvb_event_compare (DVBEvent* event1, DVBEvent* event2) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	time_t event1_time;
	time_t event2_time;
	if (event1 == NULL) {
		_tmp0_ = event2 == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (event1 == NULL) {
			_tmp1_ = event2 != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = +1;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (event1 != NULL) {
				_tmp2_ = event2 == NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = -1;
				return result;
			}
		}
	}
	event1_time = dvb_event_get_end_timestamp (event1);
	event2_time = dvb_event_get_end_timestamp (event2);
	if (event1_time < event2_time) {
		result = -1;
		return result;
	} else {
		if (event1_time > event2_time) {
			result = +1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (event1 == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event2 == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = event1->id == event2->id;
	return result;
}


guint dvb_event_hash (DVBEvent* event) {
	guint result = 0U;
	result = event->id;
	return result;
}


DVBEventAudioComponent* dvb_event_audio_component_construct (GType object_type) {
	DVBEventAudioComponent* self;
	self = (DVBEventAudioComponent*) g_type_create_instance (object_type);
	return self;
}


DVBEventAudioComponent* dvb_event_audio_component_new (void) {
	return dvb_event_audio_component_construct (DVB_EVENT_TYPE_AUDIO_COMPONENT);
}


static void dvb_event_value_audio_component_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_event_value_audio_component_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_audio_component_unref (value->data[0].v_pointer);
	}
}


static void dvb_event_value_audio_component_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_audio_component_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_event_value_audio_component_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_event_value_audio_component_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEventAudioComponent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_audio_component_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_event_value_audio_component_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEventAudioComponent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_audio_component_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBEventParamSpecAudioComponent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_EVENT_TYPE_AUDIO_COMPONENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_event_value_get_audio_component (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_AUDIO_COMPONENT), NULL);
	return value->data[0].v_pointer;
}


void dvb_event_value_set_audio_component (GValue* value, gpointer v_object) {
	DVBEventAudioComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_AUDIO_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_AUDIO_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_audio_component_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_audio_component_unref (old);
	}
}


void dvb_event_value_take_audio_component (GValue* value, gpointer v_object) {
	DVBEventAudioComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_AUDIO_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_AUDIO_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_audio_component_unref (old);
	}
}


static void dvb_event_audio_component_class_init (DVBEventAudioComponentClass * klass) {
	dvb_event_audio_component_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_AUDIO_COMPONENT_CLASS (klass)->finalize = dvb_event_audio_component_finalize;
}


static void dvb_event_audio_component_instance_init (DVBEventAudioComponent * self) {
	self->ref_count = 1;
}


static void dvb_event_audio_component_finalize (DVBEventAudioComponent* obj) {
	DVBEventAudioComponent * self;
	self = DVB_EVENT_AUDIO_COMPONENT (obj);
	_g_free0 (self->type);
}


GType dvb_event_audio_component_get_type (void) {
	static volatile gsize dvb_event_audio_component_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_audio_component_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_event_value_audio_component_init, dvb_event_value_audio_component_free_value, dvb_event_value_audio_component_copy_value, dvb_event_value_audio_component_peek_pointer, "p", dvb_event_value_audio_component_collect_value, "p", dvb_event_value_audio_component_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventAudioComponentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_audio_component_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventAudioComponent), 0, (GInstanceInitFunc) dvb_event_audio_component_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_event_audio_component_type_id;
		dvb_event_audio_component_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEventAudioComponent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_event_audio_component_type_id__volatile, dvb_event_audio_component_type_id);
	}
	return dvb_event_audio_component_type_id__volatile;
}


gpointer dvb_event_audio_component_ref (gpointer instance) {
	DVBEventAudioComponent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_event_audio_component_unref (gpointer instance) {
	DVBEventAudioComponent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_AUDIO_COMPONENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


DVBEventVideoComponent* dvb_event_video_component_construct (GType object_type) {
	DVBEventVideoComponent* self;
	self = (DVBEventVideoComponent*) g_type_create_instance (object_type);
	return self;
}


DVBEventVideoComponent* dvb_event_video_component_new (void) {
	return dvb_event_video_component_construct (DVB_EVENT_TYPE_VIDEO_COMPONENT);
}


static void dvb_event_value_video_component_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_event_value_video_component_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_video_component_unref (value->data[0].v_pointer);
	}
}


static void dvb_event_value_video_component_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_video_component_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_event_value_video_component_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_event_value_video_component_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEventVideoComponent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_video_component_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_event_value_video_component_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEventVideoComponent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_video_component_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBEventParamSpecVideoComponent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_EVENT_TYPE_VIDEO_COMPONENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_event_value_get_video_component (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_VIDEO_COMPONENT), NULL);
	return value->data[0].v_pointer;
}


void dvb_event_value_set_video_component (GValue* value, gpointer v_object) {
	DVBEventVideoComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_VIDEO_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_VIDEO_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_video_component_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_video_component_unref (old);
	}
}


void dvb_event_value_take_video_component (GValue* value, gpointer v_object) {
	DVBEventVideoComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_VIDEO_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_VIDEO_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_video_component_unref (old);
	}
}


static void dvb_event_video_component_class_init (DVBEventVideoComponentClass * klass) {
	dvb_event_video_component_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_VIDEO_COMPONENT_CLASS (klass)->finalize = dvb_event_video_component_finalize;
}


static void dvb_event_video_component_instance_init (DVBEventVideoComponent * self) {
	self->ref_count = 1;
}


static void dvb_event_video_component_finalize (DVBEventVideoComponent* obj) {
	DVBEventVideoComponent * self;
	self = DVB_EVENT_VIDEO_COMPONENT (obj);
	_g_free0 (self->aspect_ratio);
}


GType dvb_event_video_component_get_type (void) {
	static volatile gsize dvb_event_video_component_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_video_component_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_event_value_video_component_init, dvb_event_value_video_component_free_value, dvb_event_value_video_component_copy_value, dvb_event_value_video_component_peek_pointer, "p", dvb_event_value_video_component_collect_value, "p", dvb_event_value_video_component_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventVideoComponentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_video_component_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventVideoComponent), 0, (GInstanceInitFunc) dvb_event_video_component_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_event_video_component_type_id;
		dvb_event_video_component_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEventVideoComponent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_event_video_component_type_id__volatile, dvb_event_video_component_type_id);
	}
	return dvb_event_video_component_type_id__volatile;
}


gpointer dvb_event_video_component_ref (gpointer instance) {
	DVBEventVideoComponent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_event_video_component_unref (gpointer instance) {
	DVBEventVideoComponent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_VIDEO_COMPONENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


DVBEventTeletextComponent* dvb_event_teletext_component_construct (GType object_type) {
	DVBEventTeletextComponent* self;
	self = (DVBEventTeletextComponent*) g_type_create_instance (object_type);
	return self;
}


DVBEventTeletextComponent* dvb_event_teletext_component_new (void) {
	return dvb_event_teletext_component_construct (DVB_EVENT_TYPE_TELETEXT_COMPONENT);
}


static void dvb_event_value_teletext_component_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_event_value_teletext_component_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_teletext_component_unref (value->data[0].v_pointer);
	}
}


static void dvb_event_value_teletext_component_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_teletext_component_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_event_value_teletext_component_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_event_value_teletext_component_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEventTeletextComponent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_teletext_component_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_event_value_teletext_component_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEventTeletextComponent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_teletext_component_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBEventParamSpecTeletextComponent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_EVENT_TYPE_TELETEXT_COMPONENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_event_value_get_teletext_component (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_TELETEXT_COMPONENT), NULL);
	return value->data[0].v_pointer;
}


void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object) {
	DVBEventTeletextComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_TELETEXT_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_TELETEXT_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_teletext_component_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_teletext_component_unref (old);
	}
}


void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object) {
	DVBEventTeletextComponent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_EVENT_TYPE_TELETEXT_COMPONENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_EVENT_TYPE_TELETEXT_COMPONENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_teletext_component_unref (old);
	}
}


static void dvb_event_teletext_component_class_init (DVBEventTeletextComponentClass * klass) {
	dvb_event_teletext_component_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_TELETEXT_COMPONENT_CLASS (klass)->finalize = dvb_event_teletext_component_finalize;
}


static void dvb_event_teletext_component_instance_init (DVBEventTeletextComponent * self) {
	self->ref_count = 1;
}


static void dvb_event_teletext_component_finalize (DVBEventTeletextComponent* obj) {
	DVBEventTeletextComponent * self;
	self = DVB_EVENT_TELETEXT_COMPONENT (obj);
	_g_free0 (self->type);
}


GType dvb_event_teletext_component_get_type (void) {
	static volatile gsize dvb_event_teletext_component_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_teletext_component_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_event_value_teletext_component_init, dvb_event_value_teletext_component_free_value, dvb_event_value_teletext_component_copy_value, dvb_event_value_teletext_component_peek_pointer, "p", dvb_event_value_teletext_component_collect_value, "p", dvb_event_value_teletext_component_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventTeletextComponentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_teletext_component_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventTeletextComponent), 0, (GInstanceInitFunc) dvb_event_teletext_component_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_event_teletext_component_type_id;
		dvb_event_teletext_component_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEventTeletextComponent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_event_teletext_component_type_id__volatile, dvb_event_teletext_component_type_id);
	}
	return dvb_event_teletext_component_type_id__volatile;
}


gpointer dvb_event_teletext_component_ref (gpointer instance) {
	DVBEventTeletextComponent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_event_teletext_component_unref (gpointer instance) {
	DVBEventTeletextComponent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void dvb_value_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_value_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_event_unref (value->data[0].v_pointer);
	}
}


static void dvb_value_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_value_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_value_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBEvent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_value_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBEvent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBParamSpecEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_TYPE_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer dvb_value_get_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_TYPE_EVENT), NULL);
	return value->data[0].v_pointer;
}


void dvb_value_set_event (GValue* value, gpointer v_object) {
	DVBEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_unref (old);
	}
}


void dvb_value_take_event (GValue* value, gpointer v_object) {
	DVBEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_event_unref (old);
	}
}


static void dvb_event_class_init (DVBEventClass * klass) {
	dvb_event_parent_class = g_type_class_peek_parent (klass);
	DVB_EVENT_CLASS (klass)->finalize = dvb_event_finalize;
}


static void dvb_event_instance_init (DVBEvent * self) {
	self->ref_count = 1;
}


static void dvb_event_finalize (DVBEvent* obj) {
	DVBEvent * self;
	self = DVB_EVENT (obj);
	_g_free0 (self->name);
	_g_free0 (self->description);
	_g_free0 (self->extended_description);
	__g_slist_free_dvb_event_audio_component_unref0 (self->audio_components);
	__g_slist_free_dvb_event_video_component_unref0 (self->video_components);
	__g_slist_free_dvb_event_teletext_component_unref0 (self->teletext_components);
}


GType dvb_event_get_type (void) {
	static volatile gsize dvb_event_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_value_event_init, dvb_value_event_free_value, dvb_value_event_copy_value, dvb_value_event_peek_pointer, "p", dvb_value_event_collect_value, "p", dvb_value_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEvent), 0, (GInstanceInitFunc) dvb_event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_event_type_id;
		dvb_event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBEvent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_event_type_id__volatile, dvb_event_type_id);
	}
	return dvb_event_type_id__volatile;
}


gpointer dvb_event_ref (gpointer instance) {
	DVBEvent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void dvb_event_unref (gpointer instance) {
	DVBEvent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




