/* Utils.c generated by valac 0.9.7, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>

#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))



#define DVB_UTILS_NAME_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_NAME
#define DVB_UTILS_READ_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ
const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const char* name, gint* evalue);
const char* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
void dvb_utils_mkdirs (GFile* directory, GError** error);
static void _g_slist_free_g_object_unref (GSList* self);
char* dvb_utils_remove_nonalphanums (const char* text);
time_t dvb_utils_difftime (struct tm* t1, struct tm* t2);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
gboolean dvb_utils_is_readable_file (GFile* file);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
DBusGConnection* dvb_utils_get_dbus_connection (void);



inline const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val) {
	const char* result = NULL;
	GEnumClass* eclass;
	GEnumValue* eval;
	eclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value (eclass, val);
	if (eval == NULL) {
		g_critical ("Utils.vala:32: Enum has no value %d", val);
		result = NULL;
		_g_type_class_unref0 (eclass);
		return result;
	} else {
		result = eval->value_nick;
		_g_type_class_unref0 (eclass);
		return result;
	}
	_g_type_class_unref0 (eclass);
}


inline gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const char* name, gint* evalue) {
	gboolean result = FALSE;
	GEnumClass* enumclass;
	GEnumValue* eval;
	g_return_val_if_fail (name != NULL, FALSE);
	enumclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value_by_name (enumclass, name);
	if (eval == NULL) {
		g_critical ("Utils.vala:44: Enum has no member named %s", name);
		result = FALSE;
		_g_type_class_unref0 (enumclass);
		return result;
	} else {
		*evalue = eval->value;
		result = TRUE;
		_g_type_class_unref0 (enumclass);
		return result;
	}
	_g_type_class_unref0 (enumclass);
}


inline const char* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val) {
	const char* result = NULL;
	GEnumClass* enumclass;
	GEnumValue* eval;
	enumclass = (GEnumClass*) g_type_class_ref (enumtype);
	eval = g_enum_get_value (enumclass, val);
	if (eval == NULL) {
		g_critical ("Utils.vala:57: Enum has no value %d", val);
		result = NULL;
		_g_type_class_unref0 (enumclass);
		return result;
	} else {
		result = eval->value_name;
		_g_type_class_unref0 (enumclass);
		return result;
	}
	_g_type_class_unref0 (enumclass);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


void dvb_utils_mkdirs (GFile* directory, GError** error) {
	GSList* create_dirs;
	GFile* current_dir;
	GError * _inner_error_ = NULL;
	g_return_if_fail (directory != NULL);
	create_dirs = NULL;
	current_dir = _g_object_ref0 (directory);
	while (TRUE) {
		GFile* _tmp0_;
		if (!(current_dir != NULL)) {
			break;
		}
		if (g_file_query_exists (current_dir, NULL)) {
			break;
		}
		create_dirs = g_slist_prepend (create_dirs, _g_object_ref0 (current_dir));
		current_dir = (_tmp0_ = g_file_get_parent (current_dir), _g_object_unref0 (current_dir), _tmp0_);
	}
	{
		GSList* dir_collection;
		GSList* dir_it;
		dir_collection = create_dirs;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			GFile* dir;
			dir = _g_object_ref0 ((GFile*) dir_it->data);
			{
				char* _tmp1_;
				g_debug ("Utils.vala:75: Creating %s", _tmp1_ = g_file_get_path (dir));
				_g_free0 (_tmp1_);
				g_file_make_directory (dir, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dir);
					_g_object_unref0 (current_dir);
					__g_slist_free_g_object_unref0 (create_dirs);
					return;
				}
				_g_object_unref0 (dir);
			}
		}
	}
	_g_object_unref0 (current_dir);
	__g_slist_free_g_object_unref0 (create_dirs);
}


char* dvb_utils_remove_nonalphanums (const char* text) {
	char* result = NULL;
	GRegex* regex;
	char* new_text;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	regex = NULL;
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		_tmp0_ = g_regex_new ("[^-_\\.a-zA-Z0-9]", 0, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch185_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		regex = (_tmp1_ = _tmp0_, _g_regex_unref0 (regex), _tmp1_);
	}
	goto __finally185;
	__catch185_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Utils.vala:85: RegexError: %s", e->message);
			result = g_strdup (text);
			_g_error_free0 (e);
			_g_regex_unref0 (regex);
			return result;
		}
	}
	__finally185:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	new_text = NULL;
	{
		char* _tmp2_;
		char* _tmp3_;
		_tmp2_ = g_regex_replace_literal (regex, text, (gssize) (-1), 0, "_", 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch186_g_regex_error;
			}
			_g_free0 (new_text);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		new_text = (_tmp3_ = _tmp2_, _g_free0 (new_text), _tmp3_);
	}
	goto __finally186;
	__catch186_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Utils.vala:93: RegexError: %s", e->message);
			result = g_strdup (text);
			_g_error_free0 (e);
			_g_free0 (new_text);
			_g_regex_unref0 (regex);
			return result;
		}
	}
	__finally186:
	if (_inner_error_ != NULL) {
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_text;
	_g_regex_unref0 (regex);
	return result;
}


/**
     * @returns: Difference in seconds
     */
inline time_t dvb_utils_difftime (struct tm* t1, struct tm* t2) {
	time_t result;
	time_t ts1;
	time_t ts2;
	time_t diff;
	ts1 = mktime (t1);
	ts2 = mktime (t2);
	diff = ts1 - ts2;
	if (diff < 0) {
		result = (-1) * diff;
		return result;
	} else {
		result = diff;
		return result;
	}
}


/**
     * Creates Time of local time
     */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	localtime_r (&time, &_result_);
	*result = _result_;
	return;
}


inline void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	struct tm _tmp0_ = {0};
	struct tm t;
	g_assert ((((((year >= 1900) && (month >= 1)) && (day >= 1)) && (hour >= 0)) && (minute >= 0)) && (second >= 0));
	t = (g_time_local (time (NULL), &_tmp0_), _tmp0_);
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	*result = t;
	return;
}


/**
     * Creates Time of UTC time
     */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	gmtime_r (&time, &_result_);
	*result = _result_;
	return;
}


inline void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	struct tm _tmp0_ = {0};
	struct tm t;
	g_assert ((((((year >= 1900) && (month >= 1)) && (day >= 1)) && (hour >= 0)) && (minute >= 0)) && (second >= 0));
	t = (g_time_gm (time (NULL), &_tmp0_), _tmp0_);
	t.tm_year = year - 1900;
	t.tm_mon = month - 1;
	t.tm_mday = day;
	t.tm_hour = hour;
	t.tm_min = minute;
	t.tm_sec = second;
	t.tm_isdst = -1;
	*result = t;
	return;
}


gboolean dvb_utils_is_readable_file (GFile* file) {
	gboolean result = FALSE;
	GFileInfo* info;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	info = NULL;
	{
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
		_tmp0_ = g_file_query_info (file, DVB_UTILS_READ_ATTRS, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch187_g_error;
		}
		info = (_tmp1_ = _tmp0_, _g_object_unref0 (info), _tmp1_);
	}
	goto __finally187;
	__catch187_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Utils.vala:162: Could not retrieve attributes: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (info);
			return result;
		}
	}
	__finally187:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (g_file_info_get_file_type (info) != G_FILE_TYPE_REGULAR) {
		char* _tmp2_;
		g_critical ("Utils.vala:167: %s is not a regular file", _tmp2_ = g_file_get_path (file));
		_g_free0 (_tmp2_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	if (!g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
		char* _tmp3_;
		g_critical ("Utils.vala:172: Cannot read %s", _tmp3_ = g_file_get_path (file));
		_g_free0 (_tmp3_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (info);
	return result;
}


void dvb_utils_delete_dir_recursively (GFile* dir, GError** error) {
	GFileEnumerator* files;
	GFileEnumerator* _tmp0_;
	GFileEnumerator* _tmp1_;
	GFileInfo* childinfo;
	char* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dir != NULL);
	files = NULL;
	_tmp0_ = g_file_enumerate_children (dir, DVB_UTILS_NAME_ATTRS, 0, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (files);
		return;
	}
	files = (_tmp1_ = _tmp0_, _g_object_unref0 (files), _tmp1_);
	if (files == NULL) {
		_g_object_unref0 (files);
		return;
	}
	childinfo = NULL;
	while (TRUE) {
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		guint32 type;
		GFile* child;
		_tmp2_ = g_file_enumerator_next_file (files, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (childinfo);
			_g_object_unref0 (files);
			return;
		}
		if (!((childinfo = (_tmp3_ = _tmp2_, _g_object_unref0 (childinfo), _tmp3_)) != NULL)) {
			break;
		}
		type = g_file_info_get_attribute_uint32 (childinfo, G_FILE_ATTRIBUTE_STANDARD_TYPE);
		child = g_file_get_child (dir, g_file_info_get_name (childinfo));
		switch (type) {
			case G_FILE_TYPE_DIRECTORY:
			{
				dvb_utils_delete_dir_recursively (child, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_object_unref0 (childinfo);
					_g_object_unref0 (files);
					return;
				}
				break;
			}
			case G_FILE_TYPE_REGULAR:
			{
				char* _tmp4_;
				g_debug ("Utils.vala:197: Deleting file %s", _tmp4_ = g_file_get_path (child));
				_g_free0 (_tmp4_);
				g_file_delete (child, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_object_unref0 (childinfo);
					_g_object_unref0 (files);
					return;
				}
				break;
			}
		}
		_g_object_unref0 (child);
	}
	g_debug ("Utils.vala:203: Deleting directory %s", _tmp5_ = g_file_get_path (dir));
	_g_free0 (_tmp5_);
	g_file_delete (dir, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (childinfo);
		_g_object_unref0 (files);
		return;
	}
	_g_object_unref0 (childinfo);
	_g_object_unref0 (files);
}


inline DBusGConnection* dvb_utils_get_dbus_connection (void) {
	DBusGConnection* result = NULL;
	DBusGConnection* conn;
	GError * _inner_error_ = NULL;
	conn = NULL;
	{
		DBusGConnection* _tmp0_;
		DBusGConnection* _tmp1_;
		_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch188_g_error;
		}
		conn = (_tmp1_ = _tmp0_, _dbus_g_connection_unref0 (conn), _tmp1_);
	}
	goto __finally188;
	__catch188_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Utils.vala:212: Could not get D-Bus session bus: %s", e->message);
			result = NULL;
			_g_error_free0 (e);
			_dbus_g_connection_unref0 (conn);
			return result;
		}
	}
	__finally188:
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (conn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = conn;
	return result;
}




