/* SqliteEPGStore.c generated by valac 0.10.0, the Vala compiler
 * generated from SqliteEPGStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include <stdio.h>


#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBdatabasesqliteSqliteDatabasePrivate DVBdatabasesqliteSqliteDatabasePrivate;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE (dvb_database_sqlite_sqlite_epg_store_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStore))
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStoreClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE))
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStoreClass))

typedef struct _DVBdatabasesqliteSqliteEPGStore DVBdatabasesqliteSqliteEPGStore;
typedef struct _DVBdatabasesqliteSqliteEPGStoreClass DVBdatabasesqliteSqliteEPGStoreClass;
typedef struct _DVBdatabasesqliteSqliteEPGStorePrivate DVBdatabasesqliteSqliteEPGStorePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
#define __g_slist_free_dvb_event_audio_component_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_dvb_event_audio_component_unref (var), NULL)))
#define __g_slist_free_dvb_event_video_component_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_dvb_event_video_component_unref (var), NULL)))
#define __g_slist_free_dvb_event_teletext_component_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_dvb_event_teletext_component_unref (var), NULL)))

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabasesqliteSqliteDatabase {
	GObject parent_instance;
	DVBdatabasesqliteSqliteDatabasePrivate * priv;
	sqlite3* db;
};

struct _DVBdatabasesqliteSqliteDatabaseClass {
	GObjectClass parent_class;
	void (*create) (DVBdatabasesqliteSqliteDatabase* self, GError** error);
	void (*upgrade) (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
	void (*on_open) (DVBdatabasesqliteSqliteDatabase* self);
};

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBdatabasesqliteSqliteEPGStore {
	DVBdatabasesqliteSqliteDatabase parent_instance;
	DVBdatabasesqliteSqliteEPGStorePrivate * priv;
};

struct _DVBdatabasesqliteSqliteEPGStoreClass {
	DVBdatabasesqliteSqliteDatabaseClass parent_class;
};

struct _DVBdatabasesqliteSqliteEPGStorePrivate {
	sqlite3_stmt* to_julian_statement;
	sqlite3_stmt* insert_event_statement;
	sqlite3_stmt* update_event_statement;
	sqlite3_stmt* delete_event_statement;
	sqlite3_stmt* has_event_statement;
	sqlite3_stmt* select_event_statement;
	sqlite3_stmt* delete_events_group;
	sqlite3_stmt* delete_expired_events;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	char* name;
	char* description;
	char* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_database_sqlite_sqlite_epg_store_parent_class = NULL;
static DVBdatabaseEPGStoreIface* dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_parent_iface = NULL;

GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
GType dvb_database_sqlite_sqlite_epg_store_get_type (void) G_GNUC_CONST;
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStorePrivate))
enum  {
	DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DUMMY_PROPERTY
};
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_VERSION 2
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CREATE_EVENTS_TABLE_STATEMENT "CREATE TABLE events (group_id INTEGER,\n" \
"            sid INTEGER,\n" \
"            event_id INTEGER,\n" \
"            starttime JULIAN,\n" \
"            duration INTEGER,\n" \
"            running_status INTEGER(2),\n" \
"            free_ca_mode INTEGER(1),\n" \
"            name VARCHAR(255),\n" \
"            description VARCHAR(255),\n" \
"            extended_description TEXT,\n" \
"            PRIMARY KEY (group_id, sid, event_id))"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_INSERT_EVENT_SQL "INSERT INTO events VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENT_STATEMENT "DELETE FROM events WHERE group_id=? AND sid=? AND event_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_ALL_EVENTS_STATEMENT "SELECT event_id, datetime(starttime),\n" \
"            duration, running_status, free_ca_mode, name,\n" \
"            description, extended_description\n" \
"            FROM events WHERE group_id='%u' AND sid='%u'"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_MINIMAL_EVENTS_STATEMENT "SELECT event_id, datetime(starttime),\n" \
"            duration FROM events WHERE group_id='%u' AND sid='%u'\n" \
"            ORDER BY starttime ASC"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_HAS_EVENT_STATEMENT "SELECT 1 FROM events WHERE group_id=? AND sid=? AND event_id=? LIMIT 1"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_UPDATE_EVENT_SQL "UPDATE events SET starttime=?, duration=?, running_status=?,\n" \
"            free_ca_mode=?, name=?, description=?,\n" \
"            extended_description=? WHERE group_id=? AND sid=? AND even" \
"t_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_TO_JULIAN_SQL "SELECT julianday(?)"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_EVENT_SQL "SELECT event_id, datetime(starttime),\n" \
"            duration, running_status, free_ca_mode, name,\n" \
"            description, extended_description\n" \
"            FROM events WHERE group_id=? AND sid=? AND event_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENTS_GROUP "DELETE FROM events WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EXPIRED_EVENTS "DELETE FROM events WHERE starttime <= julianday(?, 'unixepoch')\n" \
"        AND sid=? AND group_id=?"
DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_new (void);
DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_construct (GType object_type);
DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version);
static void dvb_database_sqlite_sqlite_epg_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base);
static void dvb_database_sqlite_sqlite_epg_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error);
void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const char* sql, GError** error);
static void dvb_database_sqlite_sqlite_epg_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
char* dvb_database_sqlite_utils_escape (const char* text);
static double dvb_database_sqlite_sqlite_epg_store_to_julian (DVBdatabasesqliteSqliteEPGStore* self, guint year, guint month, guint day, guint hour, guint minute, guint second, GError** error);
gboolean dvb_database_epg_store_contains_event (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const char* errmsg, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error_reset (DVBdatabasesqliteSqliteDatabase* self, sqlite3_stmt* stmnt, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_real_get_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_contains_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
static GeeList* dvb_database_sqlite_sqlite_epg_store_real_get_events (DVBdatabaseEPGStore* base, guint channel_sid, guint group_id, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_minimal_event (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group (DVBdatabaseEPGStore* base, guint group_id, GError** error);
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
char* dvb_database_sqlite_utils_unescape (const char* text);
static void _g_slist_free_dvb_event_audio_component_unref (GSList* self);
static void _g_slist_free_dvb_event_video_component_unref (GSList* self);
static void _g_slist_free_dvb_event_teletext_component_unref (GSList* self);
static void dvb_database_sqlite_sqlite_epg_store_finalize (GObject* obj);



DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_construct (GType object_type) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GFile* cache_dir;
	GFile* our_cache;
	GFile* database_file;
	cache_dir = g_file_new_for_path (g_get_user_cache_dir ());
	our_cache = g_file_get_child (cache_dir, "gnome-dvb-daemon");
	database_file = g_file_get_child (our_cache, "eventsdb.sqlite3");
	self = (DVBdatabasesqliteSqliteEPGStore*) dvb_database_sqlite_sqlite_database_construct (object_type, database_file, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_VERSION);
	_g_object_unref0 (database_file);
	_g_object_unref0 (our_cache);
	_g_object_unref0 (cache_dir);
	return self;
}


DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_new (void) {
	return dvb_database_sqlite_sqlite_epg_store_construct (DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE);
}


static void dvb_database_sqlite_sqlite_epg_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base) {
	DVBdatabasesqliteSqliteEPGStore * self;
	sqlite3_stmt* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_;
	sqlite3_stmt* _tmp6_ = NULL;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	sqlite3_stmt* _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	sqlite3_stmt* _tmp11_;
	sqlite3_stmt* _tmp12_ = NULL;
	sqlite3_stmt* _tmp13_;
	sqlite3_stmt* _tmp14_ = NULL;
	sqlite3_stmt* _tmp15_;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_TO_JULIAN_SQL, -1, &_tmp0_, NULL);
	self->priv->to_julian_statement = (_tmp1_ = _tmp0_, _sqlite3_finalize0 (self->priv->to_julian_statement), _tmp1_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_INSERT_EVENT_SQL, -1, &_tmp2_, NULL);
	self->priv->insert_event_statement = (_tmp3_ = _tmp2_, _sqlite3_finalize0 (self->priv->insert_event_statement), _tmp3_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_UPDATE_EVENT_SQL, -1, &_tmp4_, NULL);
	self->priv->update_event_statement = (_tmp5_ = _tmp4_, _sqlite3_finalize0 (self->priv->update_event_statement), _tmp5_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENT_STATEMENT, -1, &_tmp6_, NULL);
	self->priv->delete_event_statement = (_tmp7_ = _tmp6_, _sqlite3_finalize0 (self->priv->delete_event_statement), _tmp7_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_HAS_EVENT_STATEMENT, -1, &_tmp8_, NULL);
	self->priv->has_event_statement = (_tmp9_ = _tmp8_, _sqlite3_finalize0 (self->priv->has_event_statement), _tmp9_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_EVENT_SQL, -1, &_tmp10_, NULL);
	self->priv->select_event_statement = (_tmp11_ = _tmp10_, _sqlite3_finalize0 (self->priv->select_event_statement), _tmp11_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENTS_GROUP, -1, &_tmp12_, NULL);
	self->priv->delete_events_group = (_tmp13_ = _tmp12_, _sqlite3_finalize0 (self->priv->delete_events_group), _tmp13_);
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EXPIRED_EVENTS, -1, &_tmp14_, NULL);
	self->priv->delete_expired_events = (_tmp15_ = _tmp14_, _sqlite3_finalize0 (self->priv->delete_expired_events), _tmp15_);
}


static void dvb_database_sqlite_sqlite_epg_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CREATE_EVENTS_TABLE_STATEMENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, "PRAGMA synchronous=OFF", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_database_sqlite_sqlite_epg_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	if (old_version == 1) {
		dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, "PRAGMA synchronous=OFF", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint free_ca_mode;
	char* name;
	char* desc;
	char* ext_desc;
	double julian_start;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->free_ca_mode) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	free_ca_mode = _tmp0_;
	name = dvb_database_sqlite_utils_escape (event->name);
	desc = dvb_database_sqlite_utils_escape (event->description);
	ext_desc = dvb_database_sqlite_utils_escape (event->extended_description);
	julian_start = dvb_database_sqlite_sqlite_epg_store_to_julian (self, event->year, event->month, event->day, event->hour, event->minute, event->second, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return FALSE;
		} else {
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (julian_start <= 0) {
		result = FALSE;
		_g_free0 (ext_desc);
		_g_free0 (desc);
		_g_free0 (name);
		return result;
	}
	_tmp1_ = dvb_database_epg_store_contains_event ((DVBdatabaseEPGStore*) self, event, channel_sid, group_id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return FALSE;
		} else {
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		if (sqlite3_bind_double (self->priv->update_event_statement, 1, julian_start) != SQLITE_OK) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = sqlite3_bind_int (self->priv->update_event_statement, 2, (gint) event->duration) != SQLITE_OK;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = sqlite3_bind_int (self->priv->update_event_statement, 3, (gint) event->running_status) != SQLITE_OK;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = sqlite3_bind_int (self->priv->update_event_statement, 4, free_ca_mode) != SQLITE_OK;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = sqlite3_bind_text (self->priv->update_event_statement, 5, g_strdup (name), -1, g_free) != SQLITE_OK;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = sqlite3_bind_text (self->priv->update_event_statement, 6, g_strdup (desc), -1, g_free) != SQLITE_OK;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = sqlite3_bind_text (self->priv->update_event_statement, 7, g_strdup (ext_desc), -1, g_free) != SQLITE_OK;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = sqlite3_bind_int (self->priv->update_event_statement, 8, (gint) group_id) != SQLITE_OK;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = sqlite3_bind_int (self->priv->update_event_statement, 9, (gint) channel_sid) != SQLITE_OK;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = sqlite3_bind_int (self->priv->update_event_statement, 10, (gint) event->id) != SQLITE_OK;
		}
		if (_tmp2_) {
			dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		if (sqlite3_step (self->priv->update_event_statement) != SQLITE_DONE) {
			dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->update_event_statement, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		sqlite3_reset (self->priv->update_event_statement);
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		if (sqlite3_bind_int (self->priv->insert_event_statement, 1, (gint) group_id) != SQLITE_OK) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = sqlite3_bind_int (self->priv->insert_event_statement, 2, (gint) channel_sid) != SQLITE_OK;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			_tmp18_ = sqlite3_bind_int (self->priv->insert_event_statement, 3, (gint) event->id) != SQLITE_OK;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = sqlite3_bind_double (self->priv->insert_event_statement, 4, julian_start) != SQLITE_OK;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = sqlite3_bind_int (self->priv->insert_event_statement, 5, (gint) event->duration) != SQLITE_OK;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			_tmp15_ = sqlite3_bind_int (self->priv->insert_event_statement, 6, (gint) event->running_status) != SQLITE_OK;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = sqlite3_bind_int (self->priv->insert_event_statement, 7, free_ca_mode) != SQLITE_OK;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = sqlite3_bind_text (self->priv->insert_event_statement, 8, g_strdup (name), -1, g_free) != SQLITE_OK;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = sqlite3_bind_text (self->priv->insert_event_statement, 9, g_strdup (desc), -1, g_free) != SQLITE_OK;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = sqlite3_bind_text (self->priv->insert_event_statement, 10, g_strdup (ext_desc), -1, g_free) != SQLITE_OK;
		}
		if (_tmp11_) {
			dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		if (sqlite3_step (self->priv->insert_event_statement) != SQLITE_DONE) {
			dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->insert_event_statement, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		sqlite3_reset (self->priv->insert_event_statement);
	}
	result = TRUE;
	_g_free0 (ext_desc);
	_g_free0 (desc);
	_g_free0 (name);
	return result;
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_real_get_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	DVBEvent* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint rc;
	gboolean _tmp2_ = FALSE;
	DVBEvent* event;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	if (sqlite3_bind_int (self->priv->select_event_statement, 1, (gint) group_id) != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_int (self->priv->select_event_statement, 2, (gint) channel_sid) != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->select_event_statement, 3, (gint) event_id) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = NULL;
		return result;
	}
	rc = sqlite3_step (self->priv->select_event_statement);
	if (rc != SQLITE_ROW) {
		_tmp2_ = rc != SQLITE_DONE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->select_event_statement, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = NULL;
		return result;
	}
	event = NULL;
	if (rc != SQLITE_DONE) {
		DVBEvent* _tmp3_;
		event = (_tmp3_ = dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (self, self->priv->select_event_statement), _dvb_event_unref0 (event), _tmp3_);
	}
	sqlite3_reset (self->priv->select_event_statement);
	result = event;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	if (sqlite3_bind_int (self->priv->delete_event_statement, 1, (gint) group_id) != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_int (self->priv->delete_event_statement, 2, (gint) channel_sid) != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->delete_event_statement, 3, (gint) event_id) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->delete_event_statement) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->delete_event_statement, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	sqlite3_reset (self->priv->delete_event_statement);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	time_t timestamp;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	timestamp = dvb_event_get_end_timestamp (event);
	if (sqlite3_bind_int64 (self->priv->delete_expired_events, 1, (gint64) timestamp) != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_int (self->priv->delete_expired_events, 2, (gint) channel_sid) != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->delete_expired_events, 3, (gint) group_id) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->delete_expired_events) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->delete_expired_events, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	sqlite3_reset (self->priv->delete_expired_events);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_contains_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint c;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (sqlite3_bind_int (self->priv->has_event_statement, 1, (gint) group_id) != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = sqlite3_bind_int (self->priv->has_event_statement, 2, (gint) channel_sid) != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = sqlite3_bind_int (self->priv->has_event_statement, 3, (gint) event->id) != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	c = 0;
	while (TRUE) {
		if (!(sqlite3_step (self->priv->has_event_statement) == SQLITE_ROW)) {
			break;
		}
		c = sqlite3_column_int (self->priv->has_event_statement, 0);
	}
	sqlite3_reset (self->priv->has_event_statement);
	result = c > 0;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_epg_store_real_get_events (DVBdatabaseEPGStore* base, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GeeList* result = NULL;
	GeeList* events;
	char* statement_str;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_;
	sqlite3_stmt* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	events = (GeeList*) gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	if (((DVBdatabasesqliteSqliteDatabase*) self)->db == NULL) {
		result = events;
		return result;
	}
	statement_str = g_strdup_printf (DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_MINIMAL_EVENTS_STATEMENT, group_id, channel_sid);
	statement = NULL;
	if ((_tmp1_ = sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, statement_str, -1, &_tmp0_, NULL), statement = (_tmp2_ = _tmp0_, _sqlite3_finalize0 (statement), _tmp2_), _tmp1_) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (statement);
				_g_free0 (statement_str);
				_g_object_unref0 (events);
				return NULL;
			} else {
				_sqlite3_finalize0 (statement);
				_g_free0 (statement_str);
				_g_object_unref0 (events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = events;
		_sqlite3_finalize0 (statement);
		_g_free0 (statement_str);
		return result;
	}
	while (TRUE) {
		DVBEvent* event;
		if (!(sqlite3_step (statement) == SQLITE_ROW)) {
			break;
		}
		event = dvb_database_sqlite_sqlite_epg_store_create_minimal_event (self, statement);
		gee_collection_add ((GeeCollection*) events, event);
		_dvb_event_unref0 (event);
	}
	result = events;
	_sqlite3_finalize0 (statement);
	_g_free0 (statement_str);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group (DVBdatabaseEPGStore* base, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	if (sqlite3_bind_int (self->priv->delete_events_group, 1, (gint) group_id) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	if (sqlite3_step (self->priv->delete_events_group) != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->delete_events_group, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	sqlite3_reset (self->priv->delete_events_group);
	result = TRUE;
	return result;
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_minimal_event (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement) {
	DVBEvent* result = NULL;
	DVBEvent* event;
	const char* starttime;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	event = dvb_event_new ();
	event->id = (guint) sqlite3_column_int (statement, 0);
	starttime = sqlite3_column_text (statement, 1);
	sscanf (starttime, "%04u-%02u-%02u %02u:%02u:%02u", &event->year, &event->month, &event->day, &event->hour, &event->minute, &event->second);
	event->duration = (guint) sqlite3_column_int (statement, 2);
	result = event;
	return result;
}


static void _g_slist_free_dvb_event_audio_component_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) dvb_event_audio_component_unref, NULL);
	g_slist_free (self);
}


static void _g_slist_free_dvb_event_video_component_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) dvb_event_video_component_unref, NULL);
	g_slist_free (self);
}


static void _g_slist_free_dvb_event_teletext_component_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) dvb_event_teletext_component_unref, NULL);
	g_slist_free (self);
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement) {
	DVBEvent* result = NULL;
	DVBEvent* event;
	const char* starttime;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	GSList* _tmp3_;
	GSList* _tmp4_;
	GSList* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	event = dvb_event_new ();
	event->id = (guint) sqlite3_column_int (statement, 0);
	starttime = sqlite3_column_text (statement, 1);
	sscanf (starttime, "%04u-%02u-%02u %02u:%02u:%02u", &event->year, &event->month, &event->day, &event->hour, &event->minute, &event->second);
	event->duration = (guint) sqlite3_column_int (statement, 2);
	event->running_status = (guint) sqlite3_column_int (statement, 3);
	event->free_ca_mode = sqlite3_column_int (statement, 4) == 1;
	event->name = (_tmp0_ = dvb_database_sqlite_utils_unescape (sqlite3_column_text (statement, 5)), _g_free0 (event->name), _tmp0_);
	event->description = (_tmp1_ = dvb_database_sqlite_utils_unescape (sqlite3_column_text (statement, 6)), _g_free0 (event->description), _tmp1_);
	event->extended_description = (_tmp2_ = dvb_database_sqlite_utils_unescape (sqlite3_column_text (statement, 7)), _g_free0 (event->extended_description), _tmp2_);
	event->audio_components = (_tmp3_ = NULL, __g_slist_free_dvb_event_audio_component_unref0 (event->audio_components), _tmp3_);
	event->video_components = (_tmp4_ = NULL, __g_slist_free_dvb_event_video_component_unref0 (event->video_components), _tmp4_);
	event->teletext_components = (_tmp5_ = NULL, __g_slist_free_dvb_event_teletext_component_unref0 (event->teletext_components), _tmp5_);
	result = event;
	return result;
}


static double dvb_database_sqlite_sqlite_epg_store_to_julian (DVBdatabasesqliteSqliteEPGStore* self, guint year, guint month, guint day, guint hour, guint minute, guint second, GError** error) {
	double result = 0.0;
	char* datetime_str;
	double val;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0);
	datetime_str = g_strdup_printf ("%04u-%02u-%02u %02u:%02u:%02u", year, month, day, hour, minute, second);
	if (sqlite3_bind_text (self->priv->to_julian_statement, 1, g_strdup (datetime_str), -1, g_free) != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (datetime_str);
				return 0.0;
			} else {
				_g_free0 (datetime_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0.0;
			}
		}
		result = (double) 0;
		_g_free0 (datetime_str);
		return result;
	}
	if (sqlite3_step (self->priv->to_julian_statement) != SQLITE_ROW) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (datetime_str);
				return 0.0;
			} else {
				_g_free0 (datetime_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0.0;
			}
		}
		result = (double) 0;
		_g_free0 (datetime_str);
		return result;
	}
	val = sqlite3_column_double (self->priv->to_julian_statement, 0);
	sqlite3_reset (self->priv->to_julian_statement);
	result = val;
	_g_free0 (datetime_str);
	return result;
}


static void dvb_database_sqlite_sqlite_epg_store_class_init (DVBdatabasesqliteSqliteEPGStoreClass * klass) {
	dvb_database_sqlite_sqlite_epg_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBdatabasesqliteSqliteEPGStorePrivate));
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->on_open = dvb_database_sqlite_sqlite_epg_store_real_on_open;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->create = dvb_database_sqlite_sqlite_epg_store_real_create;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->upgrade = dvb_database_sqlite_sqlite_epg_store_real_upgrade;
	G_OBJECT_CLASS (klass)->finalize = dvb_database_sqlite_sqlite_epg_store_finalize;
}


static void dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_interface_init (DVBdatabaseEPGStoreIface * iface) {
	dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_or_update_event = dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event;
	iface->get_event = dvb_database_sqlite_sqlite_epg_store_real_get_event;
	iface->remove_event = dvb_database_sqlite_sqlite_epg_store_real_remove_event;
	iface->remove_events_older_than = dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than;
	iface->contains_event = dvb_database_sqlite_sqlite_epg_store_real_contains_event;
	iface->get_events = dvb_database_sqlite_sqlite_epg_store_real_get_events;
	iface->remove_events_of_group = dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group;
}


static void dvb_database_sqlite_sqlite_epg_store_instance_init (DVBdatabasesqliteSqliteEPGStore * self) {
	self->priv = DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_PRIVATE (self);
}


static void dvb_database_sqlite_sqlite_epg_store_finalize (GObject* obj) {
	DVBdatabasesqliteSqliteEPGStore * self;
	self = DVB_DATABASE_SQLITE_SQLITE_EPG_STORE (obj);
	_sqlite3_finalize0 (self->priv->to_julian_statement);
	_sqlite3_finalize0 (self->priv->insert_event_statement);
	_sqlite3_finalize0 (self->priv->update_event_statement);
	_sqlite3_finalize0 (self->priv->delete_event_statement);
	_sqlite3_finalize0 (self->priv->has_event_statement);
	_sqlite3_finalize0 (self->priv->select_event_statement);
	_sqlite3_finalize0 (self->priv->delete_events_group);
	_sqlite3_finalize0 (self->priv->delete_expired_events);
	G_OBJECT_CLASS (dvb_database_sqlite_sqlite_epg_store_parent_class)->finalize (obj);
}


GType dvb_database_sqlite_sqlite_epg_store_get_type (void) {
	static volatile gsize dvb_database_sqlite_sqlite_epg_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_database_sqlite_sqlite_epg_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBdatabasesqliteSqliteEPGStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_database_sqlite_sqlite_epg_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBdatabasesqliteSqliteEPGStore), 0, (GInstanceInitFunc) dvb_database_sqlite_sqlite_epg_store_instance_init, NULL };
		static const GInterfaceInfo dvb_database_epg_store_info = { (GInterfaceInitFunc) dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_database_sqlite_sqlite_epg_store_type_id;
		dvb_database_sqlite_sqlite_epg_store_type_id = g_type_register_static (DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, "DVBdatabasesqliteSqliteEPGStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_database_sqlite_sqlite_epg_store_type_id, DVB_DATABASE_TYPE_EPG_STORE, &dvb_database_epg_store_info);
		g_once_init_leave (&dvb_database_sqlite_sqlite_epg_store_type_id__volatile, dvb_database_sqlite_sqlite_epg_store_type_id);
	}
	return dvb_database_sqlite_sqlite_epg_store_type_id__volatile;
}




