/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/rtsp/MediaMapping.h>
#include "src/rtsp/MediaFactory.h"




enum  {
	DVB_MEDIA_MAPPING_DUMMY_PROPERTY
};
static GstRTSPMediaFactory* dvb_media_mapping_factory_instance = NULL;
static GstRTSPMediaFactory* dvb_media_mapping_real_find_media (GstRTSPMediaMapping* base, GstRTSPUrl* url);
static gpointer dvb_media_mapping_parent_class = NULL;
static void dvb_media_mapping_finalize (GObject* obj);



static GstRTSPMediaFactory* dvb_media_mapping_real_find_media (GstRTSPMediaMapping* base, GstRTSPUrl* url) {
	DVBMediaMapping * self;
	GstRTSPMediaFactory* _tmp0;
	self = (DVBMediaMapping*) base;
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = dvb_media_mapping_factory_instance, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
}


DVBMediaMapping* dvb_media_mapping_construct (GType object_type) {
	DVBMediaMapping * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBMediaMapping* dvb_media_mapping_new (void) {
	return dvb_media_mapping_construct (DVB_TYPE_MEDIA_MAPPING);
}


static void dvb_media_mapping_class_init (DVBMediaMappingClass * klass) {
	dvb_media_mapping_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dvb_media_mapping_finalize;
	GST_RTSP_MEDIA_MAPPING_CLASS (klass)->find_media = dvb_media_mapping_real_find_media;
	dvb_media_mapping_factory_instance = (GstRTSPMediaFactory*) dvb_media_factory_new ();
}


static void dvb_media_mapping_instance_init (DVBMediaMapping * self) {
}


static void dvb_media_mapping_finalize (GObject* obj) {
	DVBMediaMapping * self;
	self = DVB_MEDIA_MAPPING (obj);
	G_OBJECT_CLASS (dvb_media_mapping_parent_class)->finalize (obj);
}


GType dvb_media_mapping_get_type (void) {
	static GType dvb_media_mapping_type_id = 0;
	if (dvb_media_mapping_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaMappingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_mapping_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaMapping), 0, (GInstanceInitFunc) dvb_media_mapping_instance_init, NULL };
		dvb_media_mapping_type_id = g_type_register_static (GST_TYPE_RTSP_MEDIA_MAPPING, "DVBMediaMapping", &g_define_type_info, 0);
	}
	return dvb_media_mapping_type_id;
}




