/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/ChangeType.h>








GType dvb_change_type_get_type (void) {
	static GType dvb_change_type_type_id = 0;
	if (G_UNLIKELY (dvb_change_type_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_CHANGE_TYPE_ADDED, "DVB_CHANGE_TYPE_ADDED", "added"}, {DVB_CHANGE_TYPE_DELETED, "DVB_CHANGE_TYPE_DELETED", "deleted"}, {DVB_CHANGE_TYPE_UPDATED, "DVB_CHANGE_TYPE_UPDATED", "updated"}, {0, NULL, NULL}};
		dvb_change_type_type_id = g_enum_register_static ("DVBChangeType", values);
	}
	return dvb_change_type_type_id;
}




