/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/rtsp/MediaFactory.h>
#include "src/Manager.h"
#include "src/DeviceGroup.h"
#include "src/EPGScanner.h"
#include "src/Device.h"
#include "src/ChannelList.h"
#include "src/Channel.h"




struct _DVBMediaFactoryPrivate {
	char* sid;
	GstBin* dvbrtpbin;
};

#define DVB_MEDIA_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryPrivate))
enum  {
	DVB_MEDIA_FACTORY_DUMMY_PROPERTY
};
static void _dvb_media_factory_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static GstElement* dvb_media_factory_real_get_element (GstRTSPMediaFactory* base, GstRTSPUrl* url);
static void dvb_media_factory_on_dvbbasebin_pad_added (DVBMediaFactory* self, GstElement* elem, GstPad* pad);
static char* dvb_media_factory_real_gen_key (GstRTSPMediaFactory* base, GstRTSPUrl* url);
static GObject * dvb_media_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_media_factory_parent_class = NULL;
static void dvb_media_factory_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _dvb_media_factory_on_dvbbasebin_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	dvb_media_factory_on_dvbbasebin_pad_added (self, _sender, pad);
}


static GstElement* dvb_media_factory_real_get_element (GstRTSPMediaFactory* base, GstRTSPUrl* url) {
	DVBMediaFactory * self;
	guint sidnr;
	guint grpnr;
	char** _tmp1;
	gint path_elements_size;
	gint path_elements_length1;
	char** _tmp0;
	char** path_elements;
	gint i;
	char* elem;
	char* _tmp3;
	const char* _tmp2;
	DVBManager* _tmp4;
	DVBManager* manager;
	DVBDeviceGroup* devgrp;
	DVBEPGScanner* _tmp6;
	DVBEPGScanner* epgscanner;
	DVBDevice* free_dev;
	DVBChannel* channel;
	char* _tmp9;
	GstElement* dvbbasebin;
	GstElement* payload;
	GstBin* _tmp12;
	GstElement* _tmp13;
	GstElement* _tmp14;
	GstElement* _tmp15;
	GstElement* _tmp16;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (url != NULL, NULL);
	sidnr = (guint) 0;
	grpnr = (guint) 0;
	_tmp1 = NULL;
	_tmp0 = NULL;
	path_elements = (_tmp1 = _tmp0 = g_strsplit (url->abspath, "/", 0), path_elements_length1 = _vala_array_length (_tmp0), path_elements_size = path_elements_length1, _tmp1);
	i = 0;
	elem = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	while ((elem = (_tmp3 = (_tmp2 = path_elements[i], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), elem = (g_free (elem), NULL), _tmp3)) != NULL) {
		if (i == 1) {
			grpnr = (guint) atoi (elem);
		} else {
			if (i == 2) {
				sidnr = (guint) atoi (elem);
			}
		}
		i++;
	}
	_tmp4 = NULL;
	manager = (_tmp4 = dvb_manager_get_instance (), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4));
	devgrp = dvb_manager_get_device_group_if_exists (manager, grpnr);
	if (devgrp == NULL) {
		GstElement* _tmp5;
		g_warning ("MediaFactory.vala:54: Unknown group %u", grpnr);
		_tmp5 = NULL;
		return (_tmp5 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), _tmp5);
	}
	/* Stop EPG scanner*/
	_tmp6 = NULL;
	epgscanner = (_tmp6 = dvb_device_group_get_epgscanner (devgrp), (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6));
	if (epgscanner != NULL) {
		dvb_epg_scanner_stop (epgscanner);
	}
	free_dev = dvb_device_group_get_next_free_device (devgrp);
	if (free_dev == NULL) {
		GstElement* _tmp7;
		g_warning ("MediaFactory.vala:64: All devices of group %u are currently busy", grpnr);
		_tmp7 = NULL;
		return (_tmp7 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (epgscanner == NULL) ? NULL : (epgscanner = (g_object_unref (epgscanner), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), _tmp7);
	}
	channel = dvb_channel_list_get_channel (dvb_device_get_Channels (free_dev), sidnr);
	if (channel == NULL) {
		GstElement* _tmp8;
		g_warning ("MediaFactory.vala:70: No channel %u in group %u", sidnr, grpnr);
		_tmp8 = NULL;
		return (_tmp8 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (epgscanner == NULL) ? NULL : (epgscanner = (g_object_unref (epgscanner), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), _tmp8);
	}
	_tmp9 = NULL;
	self->priv->sid = (_tmp9 = g_strdup_printf ("%u", sidnr), self->priv->sid = (g_free (self->priv->sid), NULL), _tmp9);
	dvbbasebin = gst_element_factory_make ("dvbbasebin", "dvbbasebin");
	if (dvbbasebin == NULL) {
		GstElement* _tmp10;
		g_critical ("MediaFactory.vala:79: Could not create dvbbasebin element");
		_tmp10 = NULL;
		return (_tmp10 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (epgscanner == NULL) ? NULL : (epgscanner = (g_object_unref (epgscanner), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), (dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL)), _tmp10);
	}
	g_signal_connect_object (dvbbasebin, "pad-added", (GCallback) _dvb_media_factory_on_dvbbasebin_pad_added_gst_element_pad_added, self, 0);
	dvb_channel_setup_dvb_source (channel, dvbbasebin);
	payload = gst_element_factory_make ("rtpmp2tpay", "pay0");
	if (payload == NULL) {
		GstElement* _tmp11;
		g_critical ("MediaFactory.vala:88: Could not create rtpmp2tpay element");
		_tmp11 = NULL;
		return (_tmp11 = NULL, path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (epgscanner == NULL) ? NULL : (epgscanner = (g_object_unref (epgscanner), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), (dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL)), (payload == NULL) ? NULL : (payload = (gst_object_unref (payload), NULL)), _tmp11);
	}
	_tmp12 = NULL;
	self->priv->dvbrtpbin = (_tmp12 = (GstBin*) gst_bin_new ("dvbrtpbin"), (self->priv->dvbrtpbin == NULL) ? NULL : (self->priv->dvbrtpbin = (gst_object_unref (self->priv->dvbrtpbin), NULL)), _tmp12);
	_tmp13 = NULL;
	gst_bin_add (self->priv->dvbrtpbin, (_tmp13 = dvbbasebin, (_tmp13 == NULL) ? NULL : gst_object_ref (_tmp13)));
	_tmp14 = NULL;
	gst_bin_add (self->priv->dvbrtpbin, (_tmp14 = payload, (_tmp14 == NULL) ? NULL : gst_object_ref (_tmp14)));
	g_object_set ((GObject*) dvbbasebin, "program-numbers", self->priv->sid, NULL);
	g_object_set ((GObject*) dvbbasebin, "adapter", dvb_device_get_Adapter (free_dev), NULL);
	g_object_set ((GObject*) dvbbasebin, "frontend", dvb_device_get_Frontend (free_dev), NULL);
	_tmp15 = NULL;
	_tmp16 = NULL;
	return (_tmp16 = (_tmp15 = (GstElement*) self->priv->dvbrtpbin, (_tmp15 == NULL) ? NULL : gst_object_ref (_tmp15)), path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL), elem = (g_free (elem), NULL), (manager == NULL) ? NULL : (manager = (g_object_unref (manager), NULL)), (devgrp == NULL) ? NULL : (devgrp = (g_object_unref (devgrp), NULL)), (epgscanner == NULL) ? NULL : (epgscanner = (g_object_unref (epgscanner), NULL)), (free_dev == NULL) ? NULL : (free_dev = (g_object_unref (free_dev), NULL)), (channel == NULL) ? NULL : (channel = (g_object_unref (channel), NULL)), (dvbbasebin == NULL) ? NULL : (dvbbasebin = (gst_object_unref (dvbbasebin), NULL)), (payload == NULL) ? NULL : (payload = (gst_object_unref (payload), NULL)), _tmp16);
}


static void dvb_media_factory_on_dvbbasebin_pad_added (DVBMediaFactory* self, GstElement* elem, GstPad* pad) {
	char* _tmp0;
	char* program;
	char* _tmp1;
	gboolean _tmp2;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elem != NULL);
	g_return_if_fail (pad != NULL);
	_tmp0 = NULL;
	g_debug ("MediaFactory.vala:104: Pad %s added", _tmp0 = gst_object_get_name ((GstObject*) pad));
	_tmp0 = (g_free (_tmp0), NULL);
	program = g_strdup_printf ("program_%s", self->priv->sid);
	_tmp1 = NULL;
	if ((_tmp2 = _vala_strcmp0 (_tmp1 = gst_object_get_name ((GstObject*) pad), program) == 0, _tmp1 = (g_free (_tmp1), NULL), _tmp2)) {
		char* sink_name;
		GstElement* sink;
		char* _tmp3;
		sink_name = g_strdup ("pay0");
		sink = gst_bin_get_by_name (GST_BIN (self->priv->dvbrtpbin), sink_name);
		if (sink == NULL) {
			g_critical ("MediaFactory.vala:112: No element with name %s", sink_name);
		} else {
			GstPad* sinkpad;
			GstPadLinkReturn rc;
			/* Link dvbbasebin and rtpmp2tpay*/
			sinkpad = gst_element_get_static_pad (sink, "sink");
			rc = gst_pad_link (pad, sinkpad);
			if (rc != GST_PAD_LINK_OK) {
				g_critical ("MediaFactory.vala:119: Could not link pads");
			}
			g_debug ("MediaFactory.vala:121: Src pad %s linked with sink pad %s", program, sink_name);
			(sinkpad == NULL) ? NULL : (sinkpad = (gst_object_unref (sinkpad), NULL));
		}
		_tmp3 = NULL;
		self->priv->sid = (_tmp3 = NULL, self->priv->sid = (g_free (self->priv->sid), NULL), _tmp3);
		sink_name = (g_free (sink_name), NULL);
		(sink == NULL) ? NULL : (sink = (gst_object_unref (sink), NULL));
	}
	program = (g_free (program), NULL);
}


static char* dvb_media_factory_real_gen_key (GstRTSPMediaFactory* base, GstRTSPUrl* url) {
	DVBMediaFactory * self;
	const char* _tmp0;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0 = NULL;
	return (_tmp0 = url->abspath, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
}


DVBMediaFactory* dvb_media_factory_construct (GType object_type) {
	DVBMediaFactory * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBMediaFactory* dvb_media_factory_new (void) {
	return dvb_media_factory_construct (DVB_TYPE_MEDIA_FACTORY);
}


static GObject * dvb_media_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBMediaFactoryClass * klass;
	GObjectClass * parent_class;
	DVBMediaFactory * self;
	klass = DVB_MEDIA_FACTORY_CLASS (g_type_class_peek (DVB_TYPE_MEDIA_FACTORY));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_FACTORY (obj);
	{
		gst_rtsp_media_factory_set_shared ((GstRTSPMediaFactory*) self, TRUE);
	}
	return obj;
}


static void dvb_media_factory_class_init (DVBMediaFactoryClass * klass) {
	dvb_media_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaFactoryPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_media_factory_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_factory_finalize;
	GST_RTSP_MEDIA_FACTORY_CLASS (klass)->get_element = dvb_media_factory_real_get_element;
	GST_RTSP_MEDIA_FACTORY_CLASS (klass)->gen_key = dvb_media_factory_real_gen_key;
}


static void dvb_media_factory_instance_init (DVBMediaFactory * self) {
	self->priv = DVB_MEDIA_FACTORY_GET_PRIVATE (self);
}


static void dvb_media_factory_finalize (GObject* obj) {
	DVBMediaFactory * self;
	self = DVB_MEDIA_FACTORY (obj);
	self->priv->sid = (g_free (self->priv->sid), NULL);
	(self->priv->dvbrtpbin == NULL) ? NULL : (self->priv->dvbrtpbin = (gst_object_unref (self->priv->dvbrtpbin), NULL));
	G_OBJECT_CLASS (dvb_media_factory_parent_class)->finalize (obj);
}


GType dvb_media_factory_get_type (void) {
	static GType dvb_media_factory_type_id = 0;
	if (dvb_media_factory_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaFactory), 0, (GInstanceInitFunc) dvb_media_factory_instance_init, NULL };
		dvb_media_factory_type_id = g_type_register_static (GST_TYPE_RTSP_MEDIA_FACTORY, "DVBMediaFactory", &g_define_type_info, 0);
	}
	return dvb_media_factory_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




