/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;
typedef struct _DVBScannedItemPrivate DVBScannedItemPrivate;

#define DVB_TYPE_SCANNED_SATTELITE_ITEM (dvb_scanned_sattelite_item_get_type ())
#define DVB_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItem))
#define DVB_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))
#define DVB_IS_SCANNED_SATTELITE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_IS_SCANNED_SATTELITE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_SATTELITE_ITEM))
#define DVB_SCANNED_SATTELITE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemClass))

typedef struct _DVBScannedSatteliteItem DVBScannedSatteliteItem;
typedef struct _DVBScannedSatteliteItemClass DVBScannedSatteliteItemClass;
typedef struct _DVBScannedSatteliteItemPrivate DVBScannedSatteliteItemPrivate;

/**
     * This class represents a frequency and possibly other parameters
     * that are necessary to mark a frequency as scanned
     */
struct _DVBScannedItem {
	GObject parent_instance;
	DVBScannedItemPrivate * priv;
};

struct _DVBScannedItemClass {
	GObjectClass parent_class;
};

struct _DVBScannedItemPrivate {
	guint _Frequency;
};

struct _DVBScannedSatteliteItem {
	DVBScannedItem parent_instance;
	DVBScannedSatteliteItemPrivate * priv;
};

struct _DVBScannedSatteliteItemClass {
	DVBScannedItemClass parent_class;
};

struct _DVBScannedSatteliteItemPrivate {
	char* _Polarization;
};


static gpointer dvb_scanned_item_parent_class = NULL;
static gpointer dvb_scanned_sattelite_item_parent_class = NULL;

GType dvb_scanned_item_get_type (void);
#define DVB_SCANNED_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNED_ITEM, DVBScannedItemPrivate))
enum  {
	DVB_SCANNED_ITEM_DUMMY_PROPERTY,
	DVB_SCANNED_ITEM_FREQUENCY
};
#define DVB_SCANNED_ITEM_PRIME 31
static void dvb_scanned_item_set_Frequency (DVBScannedItem* self, guint value);
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
GType dvb_scanned_sattelite_item_get_type (void);
guint dvb_scanned_item_get_Frequency (DVBScannedItem* self);
const char* dvb_scanned_sattelite_item_get_Polarization (DVBScannedSatteliteItem* self);
guint dvb_scanned_item_hash (DVBScannedItem* o);
gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2);
static void dvb_scanned_item_finalize (GObject* obj);
static void dvb_scanned_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_scanned_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define DVB_SCANNED_SATTELITE_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNED_SATTELITE_ITEM, DVBScannedSatteliteItemPrivate))
enum  {
	DVB_SCANNED_SATTELITE_ITEM_DUMMY_PROPERTY,
	DVB_SCANNED_SATTELITE_ITEM_POLARIZATION
};
static void dvb_scanned_sattelite_item_set_Polarization (DVBScannedSatteliteItem* self, const char* value);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const char* polarization);
DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const char* polarization);
static void dvb_scanned_sattelite_item_finalize (GObject* obj);
static void dvb_scanned_sattelite_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_scanned_sattelite_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency) {
	GParameter * __params;
	GParameter * __params_it;
	DVBScannedItem * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Frequency";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, frequency);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBScannedItem* dvb_scanned_item_new (guint frequency) {
	return dvb_scanned_item_construct (DVB_TYPE_SCANNED_ITEM, frequency);
}


guint dvb_scanned_item_hash (DVBScannedItem* o) {
	guint result;
	guint hashval;
	hashval = 0U;
	/* Most specific class first*/
	if (DVB_IS_SCANNED_SATTELITE_ITEM (o)) {
		hashval = ((2 * DVB_SCANNED_ITEM_PRIME) + (DVB_SCANNED_ITEM_PRIME * o->priv->_Frequency)) + g_str_hash (dvb_scanned_sattelite_item_get_Polarization (DVB_SCANNED_SATTELITE_ITEM (o)));
	} else {
		if (DVB_IS_SCANNED_ITEM (o)) {
			hashval = o->priv->_Frequency;
		} else {
			hashval = (guint) 0;
		}
	}
	result = hashval;
	return result;
}


gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2) {
	gboolean result;
	gboolean _tmp0_;
	_tmp0_ = FALSE;
	if (o1 == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = o2 == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (_vala_strcmp0 (g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) o1)), g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) o2))) != 0) {
		result = FALSE;
		return result;
	}
	if (DVB_IS_SCANNED_SATTELITE_ITEM (o1)) {
		DVBScannedSatteliteItem* _tmp1_;
		DVBScannedSatteliteItem* item1;
		DVBScannedSatteliteItem* _tmp2_;
		DVBScannedSatteliteItem* item2;
		gboolean _tmp3_;
		_tmp1_ = NULL;
		item1 = (_tmp1_ = DVB_SCANNED_SATTELITE_ITEM (o1), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
		_tmp2_ = NULL;
		item2 = (_tmp2_ = DVB_SCANNED_SATTELITE_ITEM (o2), (_tmp2_ == NULL) ? NULL : g_object_ref (_tmp2_));
		_tmp3_ = FALSE;
		if (DVB_SCANNED_ITEM (item1)->priv->_Frequency == DVB_SCANNED_ITEM (item2)->priv->_Frequency) {
			_tmp3_ = _vala_strcmp0 (dvb_scanned_sattelite_item_get_Polarization (item1), dvb_scanned_sattelite_item_get_Polarization (item2)) == 0;
		} else {
			_tmp3_ = FALSE;
		}
		result = _tmp3_;
		(item1 == NULL) ? NULL : (item1 = (g_object_unref (item1), NULL));
		(item2 == NULL) ? NULL : (item2 = (g_object_unref (item2), NULL));
		return result;
	} else {
		if (DVB_IS_SCANNED_ITEM (o1)) {
			DVBScannedItem* _tmp4_;
			DVBScannedItem* item1;
			DVBScannedItem* _tmp5_;
			DVBScannedItem* item2;
			_tmp4_ = NULL;
			item1 = (_tmp4_ = DVB_SCANNED_ITEM (o1), (_tmp4_ == NULL) ? NULL : g_object_ref (_tmp4_));
			_tmp5_ = NULL;
			item2 = (_tmp5_ = DVB_SCANNED_ITEM (o2), (_tmp5_ == NULL) ? NULL : g_object_ref (_tmp5_));
			result = item1->priv->_Frequency == item2->priv->_Frequency;
			(item1 == NULL) ? NULL : (item1 = (g_object_unref (item1), NULL));
			(item2 == NULL) ? NULL : (item2 = (g_object_unref (item2), NULL));
			return result;
		} else {
			g_critical ("ScannedItem.vala:68: Don't comparing ScannedItem instances");
			result = FALSE;
			return result;
		}
	}
}


guint dvb_scanned_item_get_Frequency (DVBScannedItem* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Frequency;
	return result;
}


static void dvb_scanned_item_set_Frequency (DVBScannedItem* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Frequency = value;
	g_object_notify ((GObject *) self, "Frequency");
}


static void dvb_scanned_item_class_init (DVBScannedItemClass * klass) {
	dvb_scanned_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannedItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_scanned_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_scanned_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanned_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNED_ITEM_FREQUENCY, g_param_spec_uint ("Frequency", "Frequency", "Frequency", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_scanned_item_instance_init (DVBScannedItem * self) {
	self->priv = DVB_SCANNED_ITEM_GET_PRIVATE (self);
}


static void dvb_scanned_item_finalize (GObject* obj) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (obj);
	G_OBJECT_CLASS (dvb_scanned_item_parent_class)->finalize (obj);
}


GType dvb_scanned_item_get_type (void) {
	static GType dvb_scanned_item_type_id = 0;
	if (dvb_scanned_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannedItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanned_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScannedItem), 0, (GInstanceInitFunc) dvb_scanned_item_instance_init, NULL };
		dvb_scanned_item_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBScannedItem", &g_define_type_info, 0);
	}
	return dvb_scanned_item_type_id;
}


static void dvb_scanned_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScannedItem * self;
	gpointer boxed;
	self = DVB_SCANNED_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_ITEM_FREQUENCY:
		g_value_set_uint (value, dvb_scanned_item_get_Frequency (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_scanned_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScannedItem * self;
	self = DVB_SCANNED_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_ITEM_FREQUENCY:
		dvb_scanned_item_set_Frequency (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBScannedSatteliteItem* dvb_scanned_sattelite_item_construct (GType object_type, guint frequency, const char* polarization) {
	GParameter * __params;
	GParameter * __params_it;
	DVBScannedSatteliteItem * self;
	g_return_val_if_fail (polarization != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "Frequency";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, frequency);
	__params_it++;
	__params_it->name = "Polarization";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, polarization);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBScannedSatteliteItem* dvb_scanned_sattelite_item_new (guint frequency, const char* polarization) {
	return dvb_scanned_sattelite_item_construct (DVB_TYPE_SCANNED_SATTELITE_ITEM, frequency, polarization);
}


const char* dvb_scanned_sattelite_item_get_Polarization (DVBScannedSatteliteItem* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Polarization;
	return result;
}


static void dvb_scanned_sattelite_item_set_Polarization (DVBScannedSatteliteItem* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_Polarization = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_Polarization = (g_free (self->priv->_Polarization), NULL), _tmp1_);
	g_object_notify ((GObject *) self, "Polarization");
}


static void dvb_scanned_sattelite_item_class_init (DVBScannedSatteliteItemClass * klass) {
	dvb_scanned_sattelite_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannedSatteliteItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_scanned_sattelite_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_scanned_sattelite_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanned_sattelite_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNED_SATTELITE_ITEM_POLARIZATION, g_param_spec_string ("Polarization", "Polarization", "Polarization", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_scanned_sattelite_item_instance_init (DVBScannedSatteliteItem * self) {
	self->priv = DVB_SCANNED_SATTELITE_ITEM_GET_PRIVATE (self);
}


static void dvb_scanned_sattelite_item_finalize (GObject* obj) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (obj);
	self->priv->_Polarization = (g_free (self->priv->_Polarization), NULL);
	G_OBJECT_CLASS (dvb_scanned_sattelite_item_parent_class)->finalize (obj);
}


GType dvb_scanned_sattelite_item_get_type (void) {
	static GType dvb_scanned_sattelite_item_type_id = 0;
	if (dvb_scanned_sattelite_item_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannedSatteliteItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanned_sattelite_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScannedSatteliteItem), 0, (GInstanceInitFunc) dvb_scanned_sattelite_item_instance_init, NULL };
		dvb_scanned_sattelite_item_type_id = g_type_register_static (DVB_TYPE_SCANNED_ITEM, "DVBScannedSatteliteItem", &g_define_type_info, 0);
	}
	return dvb_scanned_sattelite_item_type_id;
}


static void dvb_scanned_sattelite_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScannedSatteliteItem * self;
	gpointer boxed;
	self = DVB_SCANNED_SATTELITE_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_SATTELITE_ITEM_POLARIZATION:
		g_value_set_string (value, dvb_scanned_sattelite_item_get_Polarization (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_scanned_sattelite_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScannedSatteliteItem * self;
	self = DVB_SCANNED_SATTELITE_ITEM (object);
	switch (property_id) {
		case DVB_SCANNED_SATTELITE_ITEM_POLARIZATION:
		dvb_scanned_sattelite_item_set_Polarization (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




