/* Recorder.c generated by valac 0.12.0, the Vala compiler
 * generated from Recorder.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <time.h>
#include <gst/gst.h>


#define DVB_TYPE_ID_BUS_RECORDER (dvb_id_bus_recorder_get_type ())
#define DVB_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorder))
#define DVB_IS_ID_BUS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDER))
#define DVB_ID_BUS_RECORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDER, DVBIDBusRecorderIface))

typedef struct _DVBIDBusRecorder DVBIDBusRecorder;
typedef struct _DVBIDBusRecorderIface DVBIDBusRecorderIface;

#define DVB_TYPE_ID_BUS_RECORDER_PROXY (dvb_id_bus_recorder_proxy_get_type ())

#define DVB_TYPE_TIMER_INFO (dvb_timer_info_get_type ())
typedef struct _DVBTimerInfo DVBTimerInfo;

#define DVB_TYPE_OVERLAP_TYPE (dvb_overlap_type_get_type ())

#define DVB_TYPE_RECORDER (dvb_recorder_get_type ())
#define DVB_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDER, DVBRecorder))
#define DVB_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDER, DVBRecorderClass))
#define DVB_IS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDER))
#define DVB_IS_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDER))
#define DVB_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDER, DVBRecorderClass))

typedef struct _DVBRecorder DVBRecorder;
typedef struct _DVBRecorderClass DVBRecorderClass;
typedef struct _DVBRecorderPrivate DVBRecorderPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANGE_TYPE (dvb_change_type_get_type ())

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))

struct _DVBTimerInfo {
	guint32 id;
	guint duration;
	gboolean active;
	gchar* channel_name;
	gchar* title;
};

typedef enum  {
	DVB_OVERLAP_TYPE_UNKNOWN,
	DVB_OVERLAP_TYPE_NONE,
	DVB_OVERLAP_TYPE_PARTIAL,
	DVB_OVERLAP_TYPE_COMPLETE
} DVBOverlapType;

struct _DVBIDBusRecorderIface {
	GTypeInterface parent_iface;
	gboolean (*AddTimer) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerWithMargin) (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
	gboolean (*AddTimerForEPGEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
	gboolean (*DeleteTimer) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	guint32* (*GetTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
	gboolean (*SetStartTime) (DVBIDBusRecorder* self, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
	gboolean (*GetEndTime) (DVBIDBusRecorder* self, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
	gboolean (*GetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint* duration, GError** error);
	gboolean (*SetDuration) (DVBIDBusRecorder* self, guint32 timer_id, guint duration, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecorder* self, guint32 timer_id, gchar** name, GError** error);
	gboolean (*GetTitle) (DVBIDBusRecorder* self, guint32 timer_id, gchar** title, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecorder* self, guint32 timer_id, DVBTimerInfo* info, GError** error);
	guint32* (*GetActiveTimers) (DVBIDBusRecorder* self, int* result_length1, GError** error);
	gboolean (*IsTimerActive) (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
	gboolean (*HasTimer) (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
	DVBOverlapType (*HasTimerForEvent) (DVBIDBusRecorder* self, guint event_id, guint channel_sid, GError** error);
};

struct _DVBRecorder {
	GObject parent_instance;
	DVBRecorderPrivate * priv;
};

struct _DVBRecorderClass {
	GObjectClass parent_class;
};

struct _DVBRecorderPrivate {
	DVBDeviceGroup* _DeviceGroup;
	GeeSet* active_timers;
	gboolean have_check_timers_timeout;
	guint check_timers_event_id;
	GeeHashMap* timers;
	GStaticRecMutex __lock_timers;
	GeeMap* recordings;
	GStaticRecMutex __lock_recordings;
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
};

typedef enum  {
	DVB_CHANGE_TYPE_ADDED = 0,
	DVB_CHANGE_TYPE_DELETED = 1,
	DVB_CHANGE_TYPE_UPDATED = 2
} DVBChangeType;

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);

static gpointer dvb_recorder_parent_class = NULL;
static DVBLoggingLogger* dvb_recorder_log;
static DVBLoggingLogger* dvb_recorder_log = NULL;
static DVBIDBusRecorderIface* dvb_recorder_dvb_id_bus_recorder_parent_iface = NULL;
static GeeIterableIface* dvb_recorder_gee_iterable_parent_iface = NULL;

GType dvb_id_bus_recorder_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_recorder_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_timer_info_get_type (void) G_GNUC_CONST;
DVBTimerInfo* dvb_timer_info_dup (const DVBTimerInfo* self);
void dvb_timer_info_free (DVBTimerInfo* self);
void dvb_timer_info_copy (const DVBTimerInfo* self, DVBTimerInfo* dest);
void dvb_timer_info_destroy (DVBTimerInfo* self);
GType dvb_overlap_type_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_recorder_get_type (void) G_GNUC_CONST;
GType dvb_recorder_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_RECORDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDER, DVBRecorderPrivate))
enum  {
	DVB_RECORDER_DUMMY_PROPERTY,
	DVB_RECORDER_DEVICE_GROUP,
	DVB_RECORDER_COUNT,
	DVB_RECORDER_ELEMENT_TYPE
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_RECORDER_CHECK_TIMERS_INTERVAL 5
#define DVB_RECORDER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE
DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev);
DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev);
static GeeIterator* dvb_recorder_real_iterator (GeeIterable* base);
static gboolean dvb_recorder_real_AddTimer (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
DVBTimer* dvb_recorder_create_timer (DVBRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id);
static gboolean dvb_recorder_real_AddTimerWithMargin (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
GType dvb_settings_get_type (void) G_GNUC_CONST;
DVBSettings* dvb_factory_get_settings (void);
gint dvb_settings_get_timers_margin_start (DVBSettings* self);
gint dvb_settings_get_timers_margin_end (DVBSettings* self);
guint dvb_timer_get_Duration (DVBTimer* self);
void dvb_timer_set_Duration (DVBTimer* self, guint value);
void dvb_timer_add_to_start_time (DVBTimer* self, gint minutes);
gboolean dvb_timer_has_expired (DVBTimer* self);
gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2);
DVBDeviceGroup* dvb_recorder_get_DeviceGroup (DVBRecorder* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gchar* dvb_timer_to_string (DVBTimer* self);
guint32 dvb_timer_get_Id (DVBTimer* self);
GQuark dvb_database_sql_error_quark (void);
GType dvb_database_timers_store_get_type (void) G_GNUC_CONST;
DVBdatabaseTimersStore* dvb_factory_get_timers_store (void);
gboolean dvb_database_timers_store_add_timer_to_device_group (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_change_type_get_type (void) G_GNUC_CONST;
static gboolean dvb_recorder_check_timers (DVBRecorder* self);
static gboolean _dvb_recorder_check_timers_gsource_func (gpointer self);
static gboolean dvb_recorder_real_AddTimerForEPGEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, guint32* timer_id, GError** error);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
DVBdatabaseEPGStore* dvb_factory_get_epg_store (void);
DVBEvent* dvb_database_epg_store_get_event (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
gboolean dvb_id_bus_recorder_AddTimerWithMargin (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
static gboolean dvb_recorder_real_DeleteTimer (DVBIDBusRecorder* base, guint32 timer_id, GError** error);
gboolean dvb_recorder_delete_timer (DVBRecorder* self, guint32 timer_id);
gboolean dvb_recorder_is_timer_active (DVBRecorder* self, guint32 timer_id);
void dvb_recorder_stop_recording (DVBRecorder* self, DVBTimer* timer);
gboolean dvb_database_timers_store_remove_timer_from_device_group (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
static guint32* dvb_recorder_real_GetTimers (DVBIDBusRecorder* base, int* result_length1, GError** error);
static gboolean dvb_recorder_real_GetStartTime (DVBIDBusRecorder* base, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
static gboolean dvb_recorder_real_SetStartTime (DVBIDBusRecorder* base, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error);
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, GError** error);
void dvb_timer_set_start_time (DVBTimer* self, gint year, gint month, gint day, gint hour, gint minute);
static gboolean dvb_recorder_real_GetEndTime (DVBIDBusRecorder* base, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error);
guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1);
static gboolean dvb_recorder_real_GetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint* duration, GError** error);
static gboolean dvb_recorder_real_SetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint duration, GError** error);
static gboolean dvb_recorder_real_GetChannelName (DVBIDBusRecorder* base, guint32 timer_id, gchar** name, GError** error);
GType dvb_channel_get_type (void) G_GNUC_CONST;
DVBChannel* dvb_timer_get_Channel (DVBTimer* self);
const gchar* dvb_channel_get_Name (DVBChannel* self);
static gboolean dvb_recorder_real_GetTitle (DVBIDBusRecorder* base, guint32 timer_id, gchar** title, GError** error);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id);
guint dvb_timer_get_EventID (DVBTimer* self);
static gboolean dvb_recorder_real_GetAllInformations (DVBIDBusRecorder* base, guint32 timer_id, DVBTimerInfo* info, GError** error);
static guint32* dvb_recorder_real_GetActiveTimers (DVBIDBusRecorder* base, int* result_length1, GError** error);
static gboolean dvb_recorder_real_IsTimerActive (DVBIDBusRecorder* base, guint32 timer_id, GError** error);
static gboolean dvb_recorder_real_HasTimer (DVBIDBusRecorder* base, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error);
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static DVBOverlapType dvb_recorder_real_HasTimerForEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, GError** error);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
void dvb_recorder_stop (DVBRecorder* self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
void dvb_recorder_start_recording (DVBRecorder* self, DVBTimer* timer);
static GFile* dvb_recorder_create_recording_dirs (DVBRecorder* self, DVBChannel* channel, guint* start, int start_length1);
void dvb_timer_set_sink (DVBTimer* self, GstElement* value);
GType dvb_channel_factory_get_type (void) G_GNUC_CONST;
DVBChannelFactory* dvb_device_group_get_channel_factory (DVBDeviceGroup* self);
GType dvb_player_thread_get_type (void) G_GNUC_CONST;
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
static void dvb_recorder_on_eit_structure (DVBRecorder* self, DVBPlayerThread* player, const GstStructure* structure);
static void _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure (DVBPlayerThread* _sender, const GstStructure* structure, gpointer self);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
void dvb_recording_set_ChannelSid (DVBRecording* self, guint value);
void dvb_recording_set_ChannelName (DVBRecording* self, const gchar* value);
void dvb_timer_get_start_time_time (DVBTimer* self, struct tm* result);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
void dvb_recording_set_Name (DVBRecording* self, const gchar* value);
void dvb_recording_set_Description (DVBRecording* self, const gchar* value);
guint32 dvb_recording_get_Id (DVBRecording* self);
gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec);
time_t dvb_utils_difftime (struct tm* t1, struct tm* t2);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
const gchar* dvb_recording_get_ChannelName (DVBRecording* self);
gint64 dvb_recording_get_Length (DVBRecording* self);
void dvb_recording_save_to_disk (DVBRecording* self);
GstElement* dvb_timer_get_sink (DVBTimer* self);
void dvb_recording_monitor_recording (DVBRecording* self);
gchar* dvb_utils_remove_nonalphanums (const gchar* text);
GFile* dvb_device_group_get_RecordingsDirectory (DVBDeviceGroup* self);
void dvb_utils_mkdirs (GFile* directory, GError** error);
gboolean dvb_timer_is_end_due (DVBTimer* self);
gboolean dvb_timer_is_start_due (DVBTimer* self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
const gchar* dvb_recording_get_Name (DVBRecording* self);
guint dvb_recording_get_ChannelSid (DVBRecording* self);
DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self);
static void dvb_recorder_set_DeviceGroup (DVBRecorder* self, DVBDeviceGroup* value);
guint dvb_recorder_get_count (DVBRecorder* self);
static GObject * dvb_recorder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir);
static void dvb_recorder_finalize (GObject* obj);
static void _vala_dvb_recorder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_recorder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev) {
	DVBRecorder * self = NULL;
	g_return_val_if_fail (dev != NULL, NULL);
	self = (DVBRecorder*) g_object_new (object_type, "DeviceGroup", dev, NULL);
	return self;
}


DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev) {
	return dvb_recorder_construct (DVB_TYPE_RECORDER, dev);
}


static GeeIterator* dvb_recorder_real_iterator (GeeIterable* base) {
	DVBRecorder * self;
	GeeIterator* result = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* _tmp3_;
	self = (DVBRecorder*) base;
	_tmp0_ = gee_map_get_values ((GeeMap*) self->priv->timers);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


/**
         * @channel: Channel number
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @timer_id: The new timer's id on success, or 0 if timer couldn't
         * be created
         * @returns: TRUE on success
         * 
         * Add a new timer
         */
static gboolean dvb_recorder_real_AddTimer (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	guint32 _timer_id = 0U;
	gboolean result = FALSE;
	DVBTimer* _tmp0_ = NULL;
	DVBTimer* new_timer;
	self = (DVBRecorder*) base;
	_tmp0_ = dvb_recorder_create_timer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	new_timer = _tmp0_;
	if (new_timer == NULL) {
		_timer_id = (guint32) 0;
		result = FALSE;
		_g_object_unref0 (new_timer);
		if (timer_id) {
			*timer_id = _timer_id;
		}
		return result;
	} else {
		guint32 _tmp1_;
		gboolean _tmp2_;
		_tmp2_ = dvb_recorder_add_timer (self, new_timer, &_tmp1_);
		_timer_id = _tmp1_;
		result = _tmp2_;
		_g_object_unref0 (new_timer);
		if (timer_id) {
			*timer_id = _timer_id;
		}
		return result;
	}
	_g_object_unref0 (new_timer);
	if (timer_id) {
		*timer_id = _timer_id;
	}
}


/**
         * Works the same way as AddTimer() but adds a margin before and
         * after the timer.
         *
         * If the timer with added margins conflicts with a scheduled
         * recording the margins are removed and adding the timer will
         * be tried again.
         */
static gboolean dvb_recorder_real_AddTimerWithMargin (DVBIDBusRecorder* base, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	guint32 _timer_id = 0U;
	gboolean result = FALSE;
	DVBTimer* _tmp0_ = NULL;
	DVBTimer* new_timer;
	DVBSettings* _tmp1_ = NULL;
	DVBSettings* settings;
	gint _tmp2_;
	gint start_margin;
	gint _tmp3_;
	guint end_margin;
	guint _tmp4_;
	gboolean ret;
	guint32 _tmp5_;
	gboolean _tmp6_;
	self = (DVBRecorder*) base;
	_tmp0_ = dvb_recorder_create_timer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	new_timer = _tmp0_;
	if (new_timer == NULL) {
		_timer_id = (guint32) 0;
		result = FALSE;
		_g_object_unref0 (new_timer);
		if (timer_id) {
			*timer_id = _timer_id;
		}
		return result;
	}
	_tmp1_ = dvb_factory_get_settings ();
	settings = _tmp1_;
	_tmp2_ = dvb_settings_get_timers_margin_start (settings);
	start_margin = (-1) * _tmp2_;
	_tmp3_ = dvb_settings_get_timers_margin_end (settings);
	end_margin = (guint) (2 * _tmp3_);
	_tmp4_ = dvb_timer_get_Duration (new_timer);
	dvb_timer_set_Duration (new_timer, _tmp4_ + end_margin);
	dvb_timer_add_to_start_time (new_timer, start_margin);
	ret = TRUE;
	_tmp6_ = dvb_recorder_add_timer (self, new_timer, &_tmp5_);
	_timer_id = _tmp5_;
	if (!_tmp6_) {
		guint _tmp7_;
		guint32 _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = dvb_timer_get_Duration (new_timer);
		dvb_timer_set_Duration (new_timer, _tmp7_ - end_margin);
		dvb_timer_add_to_start_time (new_timer, (-1) * start_margin);
		_tmp9_ = dvb_recorder_add_timer (self, new_timer, &_tmp8_);
		_timer_id = _tmp8_;
		ret = _tmp9_;
	}
	result = ret;
	_g_object_unref0 (settings);
	_g_object_unref0 (new_timer);
	if (timer_id) {
		*timer_id = _timer_id;
	}
	return result;
}


static gboolean _dvb_recorder_check_timers_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_recorder_check_timers (self);
	return result;
}


gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id) {
	guint32 _timer_id = 0U;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_timer != NULL, FALSE);
	_tmp0_ = dvb_timer_has_expired (new_timer);
	if (_tmp0_) {
		result = FALSE;
		if (timer_id) {
			*timer_id = _timer_id;
		}
		return result;
	}
	ret = FALSE;
	{
		gboolean has_conflict;
		gint conflict_count;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		has_conflict = FALSE;
		conflict_count = 0;
		{
			GeeSet* _tmp1_ = NULL;
			GeeSet* _tmp2_;
			GeeIterator* _tmp3_ = NULL;
			GeeIterator* _tmp4_;
			GeeIterator* _key_it;
			_tmp1_ = gee_map_get_keys ((GeeMap*) self->priv->timers);
			_tmp2_ = _tmp1_;
			_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp2_);
			_key_it = _tmp4_;
			while (TRUE) {
				gboolean _tmp5_;
				gpointer _tmp6_ = NULL;
				guint32 key;
				gpointer _tmp7_ = NULL;
				DVBTimer* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp5_ = gee_iterator_next (_key_it);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = gee_iterator_get (_key_it);
				key = GPOINTER_TO_UINT (_tmp6_);
				_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key));
				_tmp8_ = (DVBTimer*) _tmp7_;
				_tmp9_ = dvb_timer_conflicts_with (_tmp8_, new_timer);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				if (_tmp10_) {
					gint _tmp11_;
					conflict_count++;
					_tmp11_ = dvb_device_group_get_size (self->priv->_DeviceGroup);
					if (conflict_count >= _tmp11_) {
						gpointer _tmp12_ = NULL;
						DVBTimer* _tmp13_;
						gchar* _tmp14_ = NULL;
						gchar* _tmp15_;
						_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key));
						_tmp13_ = (DVBTimer*) _tmp12_;
						_tmp14_ = dvb_timer_to_string (_tmp13_);
						_tmp15_ = _tmp14_;
						dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:156: Timer is conflicting with another timer: %s", _tmp15_);
						_g_free0 (_tmp15_);
						_g_object_unref0 (_tmp13_);
						has_conflict = TRUE;
						break;
					}
				}
			}
			_g_object_unref0 (_key_it);
		}
		if (!has_conflict) {
			guint32 _tmp16_;
			DVBdatabaseTimersStore* _tmp17_ = NULL;
			DVBdatabaseTimersStore* _tmp18_;
			guint32 _tmp19_;
			gboolean _tmp20_ = FALSE;
			gint _tmp21_;
			guint32 _tmp23_;
			_tmp16_ = dvb_timer_get_Id (new_timer);
			gee_abstract_map_set ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (_tmp16_), new_timer);
			_tmp17_ = dvb_factory_get_timers_store ();
			_tmp18_ = _tmp17_;
			dvb_database_timers_store_add_timer_to_device_group (_tmp18_, new_timer, self->priv->_DeviceGroup, &_inner_error_);
			_g_object_unref0 (_tmp18_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch104_dvb_database_sql_error;
				}
				g_static_rec_mutex_unlock (&self->priv->__lock_timers);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			goto __finally104;
			__catch104_dvb_database_sql_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:170: %s", e->message);
				_g_error_free0 (e);
			}
			__finally104:
			if (_inner_error_ != NULL) {
				g_static_rec_mutex_unlock (&self->priv->__lock_timers);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp19_ = dvb_timer_get_Id (new_timer);
			g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", _tmp19_, (guint) DVB_CHANGE_TYPE_ADDED);
			_tmp21_ = gee_map_get_size ((GeeMap*) self->priv->timers);
			if (_tmp21_ == 1) {
				_tmp20_ = !self->priv->have_check_timers_timeout;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				guint _tmp22_;
				dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:175: Creating new check timers");
				_tmp22_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) DVB_RECORDER_CHECK_TIMERS_INTERVAL, _dvb_recorder_check_timers_gsource_func, g_object_ref (self), g_object_unref);
				self->priv->check_timers_event_id = _tmp22_;
				self->priv->have_check_timers_timeout = TRUE;
			}
			_tmp23_ = dvb_timer_get_Id (new_timer);
			_timer_id = _tmp23_;
			ret = TRUE;
		}
		__finally103:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	if (timer_id) {
		*timer_id = _timer_id;
	}
	return result;
}


/**
         * @event_id: id of the EPG event
         * @channel_sid: SID of channel
         * @timer_id: The new timer's id on success, or 0 if timer couldn't
         * be created
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_AddTimerForEPGEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, guint32* timer_id, GError** error) {
	DVBRecorder * self;
	guint32 _timer_id = 0U;
	gboolean result = FALSE;
	DVBdatabaseEPGStore* _tmp0_ = NULL;
	DVBdatabaseEPGStore* epgstore;
	DVBEvent* event;
	guint _tmp1_;
	DVBEvent* _tmp2_ = NULL;
	DVBEvent* _tmp3_;
	struct tm _tmp4_ = {0};
	struct tm _tmp5_ = {0};
	struct tm start;
	guint32 _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	_tmp0_ = dvb_factory_get_epg_store ();
	epgstore = _tmp0_;
	event = NULL;
	_tmp1_ = dvb_device_group_get_Id (self->priv->_DeviceGroup);
	_tmp2_ = dvb_database_epg_store_get_event (epgstore, event_id, channel_sid, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch105_dvb_database_sql_error;
		}
		_dvb_event_unref0 (event);
		_g_object_unref0 (epgstore);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_dvb_event_unref0 (event);
	event = _tmp3_;
	goto __finally105;
	__catch105_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:204: %s", e->message);
		_g_error_free0 (e);
	}
	__finally105:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			return FALSE;
		} else {
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (event == NULL) {
		dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:207: Could not find event with id %u", event_id);
		_timer_id = (guint32) 0;
		result = FALSE;
		_dvb_event_unref0 (event);
		_g_object_unref0 (epgstore);
		if (timer_id) {
			*timer_id = _timer_id;
		}
		return result;
	}
	dvb_event_get_local_start_time (event, &_tmp4_);
	_tmp5_ = _tmp4_;
	start = _tmp5_;
	_tmp7_ = dvb_id_bus_recorder_AddTimerWithMargin ((DVBIDBusRecorder*) self, channel_sid, start.tm_year + 1900, start.tm_mon + 1, start.tm_mday, start.tm_hour, start.tm_min, event->duration / 60, &_tmp6_, &_inner_error_);
	_timer_id = _tmp6_;
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			return FALSE;
		} else {
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp8_;
	_dvb_event_unref0 (event);
	_g_object_unref0 (epgstore);
	if (timer_id) {
		*timer_id = _timer_id;
	}
	return result;
}


/**
         * @timer_id: The id of the timer you want to delete
         * @returns: TRUE on success
         *
         * Delete timer. If the id belongs to the currently
         * active timer recording is aborted.
         */
static gboolean dvb_recorder_real_DeleteTimer (DVBIDBusRecorder* base, guint32 timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (DVBRecorder*) base;
	_tmp0_ = dvb_recorder_delete_timer (self, timer_id);
	result = _tmp0_;
	return result;
}


gboolean dvb_recorder_delete_timer (DVBRecorder* self, guint32 timer_id) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		if (_tmp0_) {
			gboolean _tmp1_;
			DVBdatabaseTimersStore* _tmp3_ = NULL;
			DVBdatabaseTimersStore* _tmp4_;
			_tmp1_ = dvb_recorder_is_timer_active (self, timer_id);
			if (_tmp1_) {
				gpointer _tmp2_ = NULL;
				DVBTimer* timer;
				_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				timer = (DVBTimer*) _tmp2_;
				dvb_recorder_stop_recording (self, timer);
				_g_object_unref0 (timer);
			}
			gee_abstract_map_unset ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id), NULL);
			_tmp3_ = dvb_factory_get_timers_store ();
			_tmp4_ = _tmp3_;
			dvb_database_timers_store_remove_timer_from_device_group (_tmp4_, (guint) timer_id, self->priv->_DeviceGroup, &_inner_error_);
			_g_object_unref0 (_tmp4_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch107_dvb_database_sql_error;
				}
				g_static_rec_mutex_unlock (&self->priv->__lock_timers);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			goto __finally107;
			__catch107_dvb_database_sql_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:244: %s", e->message);
				_g_error_free0 (e);
			}
			__finally107:
			if (_inner_error_ != NULL) {
				g_static_rec_mutex_unlock (&self->priv->__lock_timers);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_DELETED);
			val = TRUE;
		} else {
			val = FALSE;
		}
		__finally106:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


/**
         * dvb_recorder_GetTimers
         * @returns: A list of all timer ids
         */
static guint32* dvb_recorder_real_GetTimers (DVBIDBusRecorder* base, int* result_length1, GError** error) {
	DVBRecorder * self;
	guint32* result = NULL;
	guint32* timer_arr = NULL;
	gint timer_arr_length1 = 0;
	gint _timer_arr_size_ = 0;
	guint32* _tmp11_;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		gint _tmp0_;
		guint32* _tmp1_ = NULL;
		gint i;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->timers);
		_tmp1_ = g_new0 (guint32, _tmp0_);
		timer_arr = (g_free (timer_arr), NULL);
		timer_arr = _tmp1_;
		timer_arr_length1 = _tmp0_;
		_timer_arr_size_ = _tmp0_;
		i = 0;
		{
			GeeSet* _tmp2_ = NULL;
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_ = NULL;
			GeeIterator* _tmp5_;
			GeeIterator* _key_it;
			_tmp2_ = gee_map_get_keys ((GeeMap*) self->priv->timers);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_key_it = _tmp5_;
			while (TRUE) {
				gboolean _tmp6_;
				gpointer _tmp7_ = NULL;
				guint32 key;
				gpointer _tmp8_ = NULL;
				DVBTimer* _tmp9_;
				guint32 _tmp10_;
				_tmp6_ = gee_iterator_next (_key_it);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = gee_iterator_get (_key_it);
				key = GPOINTER_TO_UINT (_tmp7_);
				_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key));
				_tmp9_ = (DVBTimer*) _tmp8_;
				_tmp10_ = dvb_timer_get_Id (_tmp9_);
				timer_arr[i] = _tmp10_;
				_g_object_unref0 (_tmp9_);
				i++;
			}
			_g_object_unref0 (_key_it);
		}
		__finally108:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				timer_arr = (g_free (timer_arr), NULL);
				return NULL;
			} else {
				timer_arr = (g_free (timer_arr), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp11_ = timer_arr;
	*result_length1 = timer_arr_length1;
	result = _tmp11_;
	return result;
}


/**
         * @timer_id: Timer's id
         * @start_time: An array of length 5, where index 0 = year, 1 = month,
         * 2 = day, 3 = hour and 4 = minute.
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetStartTime (DVBIDBusRecorder* base, guint32 timer_id, guint32** start_time, int* start_time_length1, GError** error) {
	DVBRecorder * self;
	guint32* _start_time = NULL;
	int _start_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBTimer* _tmp2_;
			gint _tmp3_;
			guint* _tmp4_ = NULL;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			_tmp2_ = (DVBTimer*) _tmp1_;
			_tmp4_ = dvb_timer_get_start_time (_tmp2_, &_tmp3_);
			_start_time = (g_free (_start_time), NULL);
			_start_time = _tmp4_;
			_start_time_length1 = _tmp3_;
			_g_object_unref0 (_tmp2_);
			ret = TRUE;
		} else {
			guint* _tmp5_ = NULL;
			_tmp5_ = g_new0 (guint, 0);
			_start_time = (g_free (_start_time), NULL);
			_start_time = _tmp5_;
			_start_time_length1 = 0;
			ret = FALSE;
		}
		__finally109:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (start_time) {
		*start_time = _start_time;
	} else {
		_start_time = (g_free (_start_time), NULL);
	}
	if (start_time_length1) {
		*start_time_length1 = _start_time_length1;
	}
	return result;
}


/**
          * @timer_id: The new timer's id on success, or 0 if timer couldn't
          * @start_year: The year when the recording should start
          * @start_month: The month when recording should start
          * @start_day: The day when recording should start
          * @start_hour: The hour when recording should start
          * @start_minute: The minute when recording should start
          * @duration: How long the channel should be recorded (in minutes)
          * @returns: TRUE on success
          */
static gboolean dvb_recorder_real_SetStartTime (DVBIDBusRecorder* base, guint32 timer_id, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		if (_tmp0_) {
			gboolean _tmp1_;
			gboolean _tmp2_;
			_tmp1_ = dvb_id_bus_recorder_IsTimerActive ((DVBIDBusRecorder*) self, timer_id, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __finally110;
			}
			if (_tmp2_) {
				g_warning ("Recorder.vala:314: Cannot change start time of already active timer");
			} else {
				gpointer _tmp3_ = NULL;
				DVBTimer* timer;
				_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				timer = (DVBTimer*) _tmp3_;
				dvb_timer_set_start_time (timer, start_year, start_month, start_day, start_hour, start_minute);
				ret = TRUE;
				_g_object_unref0 (timer);
			}
		}
		__finally110:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (ret) {
		g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_UPDATED);
	}
	result = ret;
	return result;
}


/**
         * @timer_id: Timer's id
         * @end_time: Same as dvb_recorder_GetStartTime()
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetEndTime (DVBIDBusRecorder* base, guint32 timer_id, guint** end_time, int* end_time_length1, GError** error) {
	DVBRecorder * self;
	guint* _end_time = NULL;
	int _end_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBTimer* _tmp2_;
			gint _tmp3_;
			guint* _tmp4_ = NULL;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			_tmp2_ = (DVBTimer*) _tmp1_;
			_tmp4_ = dvb_timer_get_end_time (_tmp2_, &_tmp3_);
			_end_time = (g_free (_end_time), NULL);
			_end_time = _tmp4_;
			_end_time_length1 = _tmp3_;
			_g_object_unref0 (_tmp2_);
			ret = TRUE;
		} else {
			guint* _tmp5_ = NULL;
			_tmp5_ = g_new0 (guint, 0);
			_end_time = (g_free (_end_time), NULL);
			_end_time = _tmp5_;
			_end_time_length1 = 0;
			ret = FALSE;
		}
		__finally111:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (end_time) {
		*end_time = _end_time;
	} else {
		_end_time = (g_free (_end_time), NULL);
	}
	if (end_time_length1) {
		*end_time_length1 = _end_time_length1;
	}
	return result;
}


/**
         * @timer_id: Timer's id
         * @duration: Duration in seconds or 0 if there's no timer with
         * the given id
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint* duration, GError** error) {
	DVBRecorder * self;
	guint _duration = 0U;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBTimer* _tmp2_;
			guint _tmp3_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			_tmp2_ = (DVBTimer*) _tmp1_;
			_tmp3_ = dvb_timer_get_Duration (_tmp2_);
			_duration = _tmp3_;
			_g_object_unref0 (_tmp2_);
			ret = TRUE;
		}
		__finally112:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (duration) {
		*duration = _duration;
	}
	return result;
}


/**
         * @timer_id: Timer's id
         * @duration: Duration in minutes
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_SetDuration (DVBIDBusRecorder* base, guint32 timer_id, guint duration, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		ret = _tmp0_;
		if (ret) {
			gpointer _tmp1_ = NULL;
			DVBTimer* timer;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			timer = (DVBTimer*) _tmp1_;
			dvb_timer_set_Duration (timer, duration);
			_g_object_unref0 (timer);
		}
		__finally113:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (ret) {
		g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_UPDATED);
	}
	result = ret;
	return result;
}


/**
         * @timer_id: Timer's id
         * @name: The name of the channel the timer belongs to or an
         * empty string when a timer with the given id doesn't exist
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetChannelName (DVBIDBusRecorder* base, guint32 timer_id, gchar** name, GError** error) {
	DVBRecorder * self;
	gchar* _name = NULL;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBTimer* t;
			DVBChannel* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			t = (DVBTimer*) _tmp1_;
			_tmp2_ = dvb_timer_get_Channel (t);
			_tmp3_ = dvb_channel_get_Name (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (_name);
			_name = _tmp4_;
			ret = TRUE;
			_g_object_unref0 (t);
		} else {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			_g_free0 (_name);
			_name = _tmp5_;
			ret = FALSE;
		}
		__finally114:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (name) {
		*name = _name;
	} else {
		_g_free0 (_name);
	}
	return result;
}


/**
         * @timer_id: Timer's id
         * @title: The name of the show the timer belongs to or an
         * empty string if the timer doesn't exist or has no information
         * about the title of the show
         * @returns: TRUE on success
         */
static gboolean dvb_recorder_real_GetTitle (DVBIDBusRecorder* base, guint32 timer_id, gchar** title, GError** error) {
	DVBRecorder * self;
	gchar* _title = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBTimer* t;
			DVBChannel* _tmp2_ = NULL;
			DVBSchedule* _tmp3_ = NULL;
			guint _tmp4_;
			DVBEvent* _tmp5_ = NULL;
			DVBEvent* event;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			t = (DVBTimer*) _tmp1_;
			_tmp2_ = dvb_timer_get_Channel (t);
			_tmp3_ = dvb_channel_get_Schedule (_tmp2_);
			_tmp4_ = dvb_timer_get_EventID (t);
			_tmp5_ = dvb_schedule_get_event (_tmp3_, _tmp4_);
			event = _tmp5_;
			if (event == NULL) {
				_tmp6_ = "";
			} else {
				_tmp6_ = event->name;
			}
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (_title);
			_title = _tmp7_;
			ret = TRUE;
			_dvb_event_unref0 (event);
			_g_object_unref0 (t);
		}
		__finally115:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("");
		_g_free0 (_title);
		_title = _tmp8_;
	}
	result = ret;
	if (title) {
		*title = _title;
	} else {
		_g_free0 (_title);
	}
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean dvb_recorder_real_GetAllInformations (DVBIDBusRecorder* base, guint32 timer_id, DVBTimerInfo* info, GError** error) {
	DVBRecorder * self;
	DVBTimerInfo _info = {0};
	gboolean result = FALSE;
	DVBTimerInfo _tmp0_ = {0};
	DVBTimerInfo _tmp1_ = {0};
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	memset (&_tmp0_, 0, sizeof (DVBTimerInfo));
	_tmp1_ = _tmp0_;
	dvb_timer_info_destroy (&_info);
	_info = _tmp1_;
	{
		gboolean _tmp2_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
		if (_tmp2_) {
			gpointer _tmp3_ = NULL;
			DVBTimer* t;
			guint _tmp4_;
			gboolean _tmp5_;
			DVBChannel* _tmp6_ = NULL;
			DVBChannel* _tmp7_;
			DVBChannel* chan;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			DVBSchedule* _tmp10_ = NULL;
			guint _tmp11_;
			DVBEvent* _tmp12_ = NULL;
			DVBEvent* event;
			_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			t = (DVBTimer*) _tmp3_;
			_info.id = timer_id;
			_tmp4_ = dvb_timer_get_Duration (t);
			_info.duration = _tmp4_;
			_tmp5_ = gee_collection_contains ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (timer_id));
			_info.active = _tmp5_;
			_tmp6_ = dvb_timer_get_Channel (t);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			chan = _tmp7_;
			_tmp8_ = dvb_channel_get_Name (chan);
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (_info.channel_name);
			_info.channel_name = _tmp9_;
			_tmp10_ = dvb_channel_get_Schedule (chan);
			_tmp11_ = dvb_timer_get_EventID (t);
			_tmp12_ = dvb_schedule_get_event (_tmp10_, _tmp11_);
			event = _tmp12_;
			if (event != NULL) {
				gchar* _tmp13_;
				_tmp13_ = g_strdup (event->name);
				_g_free0 (_info.title);
				_info.title = _tmp13_;
			} else {
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("");
				_g_free0 (_info.title);
				_info.title = _tmp14_;
			}
			ret = TRUE;
			_dvb_event_unref0 (event);
			_g_object_unref0 (chan);
			_g_object_unref0 (t);
		} else {
			gchar* _tmp15_;
			gchar* _tmp16_;
			_info.id = (guint32) 0;
			_info.duration = (guint) 0;
			_info.active = FALSE;
			_tmp15_ = g_strdup ("");
			_g_free0 (_info.channel_name);
			_info.channel_name = _tmp15_;
			_tmp16_ = g_strdup ("");
			_g_free0 (_info.title);
			_info.title = _tmp16_;
			ret = FALSE;
		}
		__finally116:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (info) {
		*info = _info;
	} else {
		dvb_timer_info_destroy (&_info);
	}
	return result;
}


/**
         * @returns: The currently active timers
         */
static guint32* dvb_recorder_real_GetActiveTimers (DVBIDBusRecorder* base, int* result_length1, GError** error) {
	DVBRecorder * self;
	guint32* result = NULL;
	gint _tmp0_;
	guint32* _tmp1_ = NULL;
	guint32* val;
	gint val_length1;
	gint _val_size_;
	gint i;
	guint32* _tmp7_;
	self = (DVBRecorder*) base;
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->active_timers);
	_tmp1_ = g_new0 (guint32, _tmp0_);
	val = _tmp1_;
	val_length1 = _tmp0_;
	_val_size_ = _tmp0_;
	i = 0;
	{
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _timer_id_it;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) self->priv->active_timers);
		_timer_id_it = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_;
			gpointer _tmp4_ = NULL;
			guint32 timer_id;
			gpointer _tmp5_ = NULL;
			DVBTimer* timer;
			guint32 _tmp6_;
			_tmp3_ = gee_iterator_next (_timer_id_it);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = gee_iterator_get (_timer_id_it);
			timer_id = GPOINTER_TO_UINT (_tmp4_);
			_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
			timer = (DVBTimer*) _tmp5_;
			_tmp6_ = dvb_timer_get_Id (timer);
			val[i] = _tmp6_;
			i++;
			_g_object_unref0 (timer);
		}
		_g_object_unref0 (_timer_id_it);
	}
	_tmp7_ = val;
	*result_length1 = val_length1;
	result = _tmp7_;
	return result;
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE if timer is currently active
         */
static gboolean dvb_recorder_real_IsTimerActive (DVBIDBusRecorder* base, guint32 timer_id, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (DVBRecorder*) base;
	_tmp0_ = dvb_recorder_is_timer_active (self, timer_id);
	result = _tmp0_;
	return result;
}


gboolean dvb_recorder_is_timer_active (DVBRecorder* self, guint32 timer_id) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_collection_contains ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (timer_id));
	result = _tmp0_;
	return result;
}


/**
         * @returns: TRUE if a timer is already scheduled in the given
         * period of time
         */
static gboolean dvb_recorder_real_HasTimer (DVBIDBusRecorder* base, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, GError** error) {
	DVBRecorder * self;
	gboolean result = FALSE;
	gboolean val;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	val = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _key_it;
			_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->timers);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_);
			_key_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				guint32 key;
				gpointer _tmp6_ = NULL;
				DVBTimer* _tmp7_;
				DVBOverlapType _tmp8_;
				DVBOverlapType _tmp9_;
				DVBOverlapType overlap;
				gboolean _tmp10_ = FALSE;
				_tmp4_ = gee_iterator_next (_key_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_key_it);
				key = GPOINTER_TO_UINT (_tmp5_);
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key));
				_tmp7_ = (DVBTimer*) _tmp6_;
				_tmp8_ = dvb_timer_get_overlap_local (_tmp7_, start_year, start_month, start_day, start_hour, start_minute, duration);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp7_);
				overlap = _tmp9_;
				if (overlap == DVB_OVERLAP_TYPE_PARTIAL) {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = overlap == DVB_OVERLAP_TYPE_COMPLETE;
				}
				if (_tmp10_) {
					val = TRUE;
					break;
				}
			}
			_g_object_unref0 (_key_it);
		}
		__finally117:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = val;
	return result;
}


static DVBOverlapType dvb_recorder_real_HasTimerForEvent (DVBIDBusRecorder* base, guint event_id, guint channel_sid, GError** error) {
	DVBRecorder * self;
	DVBOverlapType result = 0;
	DVBdatabaseEPGStore* _tmp0_ = NULL;
	DVBdatabaseEPGStore* epgstore;
	DVBEvent* event;
	guint _tmp1_;
	DVBEvent* _tmp2_ = NULL;
	DVBEvent* _tmp3_;
	DVBOverlapType val;
	GError * _inner_error_ = NULL;
	self = (DVBRecorder*) base;
	_tmp0_ = dvb_factory_get_epg_store ();
	epgstore = _tmp0_;
	event = NULL;
	_tmp1_ = dvb_device_group_get_Id (self->priv->_DeviceGroup);
	_tmp2_ = dvb_database_epg_store_get_event (epgstore, event_id, channel_sid, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch118_dvb_database_sql_error;
		}
		_dvb_event_unref0 (event);
		_g_object_unref0 (epgstore);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_dvb_event_unref0 (event);
	event = _tmp3_;
	goto __finally118;
	__catch118_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:537: %s", e->message);
		_g_error_free0 (e);
	}
	__finally118:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			return 0;
		} else {
			_dvb_event_unref0 (event);
			_g_object_unref0 (epgstore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (event == NULL) {
		dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:540: Could not find event with id %u", event_id);
		result = DVB_OVERLAP_TYPE_UNKNOWN;
		_dvb_event_unref0 (event);
		_g_object_unref0 (epgstore);
		return result;
	}
	val = DVB_OVERLAP_TYPE_NONE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeSet* _tmp4_ = NULL;
			GeeSet* _tmp5_;
			GeeIterator* _tmp6_ = NULL;
			GeeIterator* _tmp7_;
			GeeIterator* _key_it;
			_tmp4_ = gee_map_get_keys ((GeeMap*) self->priv->timers);
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_key_it = _tmp7_;
			while (TRUE) {
				gboolean _tmp8_;
				gpointer _tmp9_ = NULL;
				guint32 key;
				gpointer _tmp10_ = NULL;
				DVBTimer* timer;
				DVBChannel* _tmp11_ = NULL;
				guint _tmp12_;
				_tmp8_ = gee_iterator_next (_key_it);
				if (!_tmp8_) {
					break;
				}
				_tmp9_ = gee_iterator_get (_key_it);
				key = GPOINTER_TO_UINT (_tmp9_);
				_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key));
				timer = (DVBTimer*) _tmp10_;
				_tmp11_ = dvb_timer_get_Channel (timer);
				_tmp12_ = dvb_channel_get_Sid (_tmp11_);
				if (_tmp12_ == channel_sid) {
					DVBOverlapType _tmp13_;
					DVBOverlapType overlap;
					gboolean _tmp14_ = FALSE;
					_tmp13_ = dvb_timer_get_overlap_utc (timer, event->year, event->month, event->day, event->hour, event->minute, event->duration / 60);
					overlap = _tmp13_;
					if (overlap == DVB_OVERLAP_TYPE_PARTIAL) {
						_tmp14_ = TRUE;
					} else {
						_tmp14_ = overlap == DVB_OVERLAP_TYPE_COMPLETE;
					}
					if (_tmp14_) {
						val = overlap;
						_g_object_unref0 (timer);
						break;
					}
				}
				_g_object_unref0 (timer);
			}
			_g_object_unref0 (_key_it);
		}
		__finally119:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_dvb_event_unref0 (event);
				_g_object_unref0 (epgstore);
				return 0;
			} else {
				_dvb_event_unref0 (event);
				_g_object_unref0 (epgstore);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = val;
	_dvb_event_unref0 (event);
	_g_object_unref0 (epgstore);
	return result;
}


void dvb_recorder_stop (DVBRecorder* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->check_timers_event_id > 0) {
		g_source_remove (self->priv->check_timers_event_id);
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeIterator* _tmp0_ = NULL;
			GeeIterator* _timer_id_it;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->priv->active_timers);
			_timer_id_it = _tmp0_;
			while (TRUE) {
				gboolean _tmp1_;
				gpointer _tmp2_ = NULL;
				guint32 timer_id;
				gpointer _tmp3_ = NULL;
				DVBTimer* timer;
				_tmp1_ = gee_iterator_next (_timer_id_it);
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = gee_iterator_get (_timer_id_it);
				timer_id = GPOINTER_TO_UINT (_tmp2_);
				_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				timer = (DVBTimer*) _tmp3_;
				dvb_recorder_stop_recording (self, timer);
				_g_object_unref0 (timer);
			}
			_g_object_unref0 (_timer_id_it);
		}
		__finally120:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBTimer* dvb_recorder_create_timer (DVBRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	DVBTimer* result = NULL;
	DVBChannelList* _tmp0_ = NULL;
	DVBChannelList* _tmp1_;
	DVBChannelList* channels;
	gboolean _tmp2_;
	DVBRecordingsStore* _tmp4_ = NULL;
	guint32 _tmp5_;
	guint32 timer_id;
	DVBChannelList* _tmp6_ = NULL;
	DVBChannel* _tmp7_ = NULL;
	DVBChannel* _tmp8_;
	DVBTimer* _tmp9_ = NULL;
	DVBTimer* _tmp10_;
	DVBTimer* new_timer;
	g_return_val_if_fail (self != NULL, NULL);
	dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:580: Creating new timer: channel: %u, start: %04d-%02d-%" \
"02d %02d:%02d, duration: %u", channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	_tmp0_ = dvb_device_group_get_Channels (self->priv->_DeviceGroup);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	channels = _tmp1_;
	_tmp2_ = dvb_channel_list_contains (channels, channel);
	if (!_tmp2_) {
		guint _tmp3_;
		_tmp3_ = dvb_device_group_get_Id (self->priv->_DeviceGroup);
		g_warning ("Recorder.vala:586: No channel %u for device group %u", channel, _tmp3_);
		result = NULL;
		_g_object_unref0 (channels);
		return result;
	}
	_tmp4_ = dvb_recordings_store_get_instance ();
	_tmp5_ = dvb_recordings_store_get_next_id (_tmp4_);
	timer_id = _tmp5_;
	_tmp6_ = dvb_device_group_get_Channels (self->priv->_DeviceGroup);
	_tmp7_ = dvb_channel_list_get_channel (_tmp6_, channel);
	_tmp8_ = _tmp7_;
	_tmp9_ = dvb_timer_new (timer_id, _tmp8_, start_year, start_month, start_day, start_hour, start_minute, duration);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	new_timer = _tmp10_;
	result = new_timer;
	_g_object_unref0 (channels);
	return result;
}


/**
         * Start recording of specified timer
         */
static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static void _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure (DVBPlayerThread* _sender, const GstStructure* structure, gpointer self) {
	dvb_recorder_on_eit_structure (self, _sender, structure);
}


void dvb_recorder_start_recording (DVBRecorder* self, DVBTimer* timer) {
	DVBChannel* _tmp0_ = NULL;
	DVBChannel* _tmp1_;
	DVBChannel* channel;
	gint _tmp2_;
	guint* _tmp3_ = NULL;
	guint* _tmp4_;
	gint _tmp4__length1;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_;
	GFile* location;
	GstElement* _tmp7_ = NULL;
	GstElement* filesink;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	DVBChannelFactory* _tmp10_ = NULL;
	DVBChannelFactory* _tmp11_;
	DVBChannelFactory* channel_factory;
	GstElement* _tmp12_;
	DVBPlayerThread* _tmp13_ = NULL;
	DVBPlayerThread* player;
	guint32 _tmp32_;
	guint32 _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	_tmp0_ = dvb_timer_get_Channel (timer);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	channel = _tmp1_;
	_tmp3_ = dvb_timer_get_start_time (timer, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = dvb_recorder_create_recording_dirs (self, channel, _tmp4_, _tmp2_);
	_tmp6_ = _tmp5_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	location = _tmp6_;
	if (location == NULL) {
		_g_object_unref0 (location);
		_g_object_unref0 (channel);
		return;
	}
	_tmp7_ = gst_element_factory_make ("filesink", NULL);
	filesink = _tmp7_;
	if (filesink == NULL) {
		dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:612: Could not create filesink element");
		_gst_object_unref0 (filesink);
		_g_object_unref0 (location);
		_g_object_unref0 (channel);
		return;
	}
	_tmp8_ = g_file_get_path (location);
	_tmp9_ = _tmp8_;
	g_object_set ((GObject*) filesink, "location", _tmp9_, NULL);
	_g_free0 (_tmp9_);
	dvb_timer_set_sink (timer, filesink);
	_tmp10_ = dvb_device_group_get_channel_factory (self->priv->_DeviceGroup);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	channel_factory = _tmp11_;
	_tmp12_ = _gst_object_ref0 (filesink);
	_tmp13_ = dvb_channel_factory_watch_channel (channel_factory, channel, _tmp12_, TRUE, NULL, NULL);
	player = _tmp13_;
	if (player != NULL) {
		GstElement* _tmp14_ = NULL;
		GstElement* _tmp15_;
		GstStateChangeReturn _tmp16_;
		GstStateChangeReturn _tmp17_;
		GstStateChangeReturn ret;
		DVBRecording* _tmp18_ = NULL;
		DVBRecording* recording;
		guint32 _tmp19_;
		guint _tmp20_;
		const gchar* _tmp21_ = NULL;
		struct tm _tmp22_ = {0};
		struct tm _tmp23_ = {0};
		guint _tmp24_;
		DVBRecordingsStore* _tmp31_ = NULL;
		dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:622: Setting pipeline to playing");
		_tmp14_ = dvb_player_thread_get_pipeline (player);
		_tmp15_ = _tmp14_;
		_tmp16_ = gst_element_set_state (_tmp15_, GST_STATE_PLAYING);
		_tmp17_ = _tmp16_;
		_gst_object_unref0 (_tmp15_);
		ret = _tmp17_;
		if (ret == GST_STATE_CHANGE_FAILURE) {
			dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:626: Failed setting pipeline to playing");
			dvb_channel_factory_stop_channel (channel_factory, channel, filesink);
			_g_object_unref0 (player);
			_g_object_unref0 (channel_factory);
			_gst_object_unref0 (filesink);
			_g_object_unref0 (location);
			_g_object_unref0 (channel);
			return;
		}
		g_signal_connect_object (player, "eit-structure", (GCallback) _dvb_recorder_on_eit_structure_dvb_player_thread_eit_structure, self, 0);
		_tmp18_ = dvb_recording_new ();
		recording = _tmp18_;
		_tmp19_ = dvb_timer_get_Id (timer);
		dvb_recording_set_Id (recording, _tmp19_);
		_tmp20_ = dvb_channel_get_Sid (channel);
		dvb_recording_set_ChannelSid (recording, _tmp20_);
		_tmp21_ = dvb_channel_get_Name (channel);
		dvb_recording_set_ChannelName (recording, _tmp21_);
		dvb_timer_get_start_time_time (timer, &_tmp22_);
		_tmp23_ = _tmp22_;
		dvb_recording_set_StartTime (recording, &_tmp23_);
		dvb_recording_set_Location (recording, location);
		dvb_recording_set_Name (recording, NULL);
		dvb_recording_set_Description (recording, NULL);
		_tmp24_ = dvb_timer_get_EventID (timer);
		if (_tmp24_ != 0) {
			DVBSchedule* _tmp25_ = NULL;
			guint _tmp26_;
			DVBEvent* _tmp27_ = NULL;
			DVBEvent* event;
			_tmp25_ = dvb_channel_get_Schedule (channel);
			_tmp26_ = dvb_timer_get_EventID (timer);
			_tmp27_ = dvb_schedule_get_event (_tmp25_, _tmp26_);
			event = _tmp27_;
			if (event != NULL) {
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:647: Transfering event information from timer");
				dvb_recording_set_Name (recording, event->name);
				_tmp28_ = g_strdup_printf ("%s\n%s", event->description, event->extended_description);
				_tmp29_ = _tmp28_;
				dvb_recording_set_Description (recording, _tmp29_);
				_g_free0 (_tmp29_);
			}
			_dvb_event_unref0 (event);
		}
		{
			guint32 _tmp30_;
			g_static_rec_mutex_lock (&self->priv->__lock_recordings);
			_tmp30_ = dvb_recording_get_Id (recording);
			gee_map_set (self->priv->recordings, GUINT_TO_POINTER ((guint) _tmp30_), recording);
			__finally121:
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (recording);
				_g_object_unref0 (player);
				_g_object_unref0 (channel_factory);
				_gst_object_unref0 (filesink);
				_g_object_unref0 (location);
				_g_object_unref0 (channel);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp31_ = dvb_recordings_store_get_instance ();
		dvb_recordings_store_add (_tmp31_, recording);
		_g_object_unref0 (recording);
	}
	_tmp32_ = dvb_timer_get_Id (timer);
	gee_collection_add ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (_tmp32_));
	_tmp33_ = dvb_timer_get_Id (timer);
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "recording-started", _tmp33_);
	_g_object_unref0 (player);
	_g_object_unref0 (channel_factory);
	_gst_object_unref0 (filesink);
	_g_object_unref0 (location);
	_g_object_unref0 (channel);
}


/**
         * Stop recording of specified timer
         */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


void dvb_recorder_stop_recording (DVBRecorder* self, DVBTimer* timer) {
	DVBRecording* rec = NULL;
	guint32 _tmp14_;
	guint32 timer_id;
	guint32 _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	{
		guint32 _tmp0_;
		gpointer _tmp1_ = NULL;
		time_t _tmp2_;
		struct tm _tmp3_ = {0};
		struct tm _tmp4_ = {0};
		struct tm _tmp5_ = {0};
		time_t _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint64 _tmp8_;
		DVBChannelFactory* _tmp9_ = NULL;
		DVBChannelFactory* _tmp10_;
		DVBChannelFactory* channel_factory;
		DVBChannel* _tmp11_ = NULL;
		GstElement* _tmp12_ = NULL;
		guint32 _tmp13_;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		_tmp0_ = dvb_timer_get_Id (timer);
		_tmp1_ = gee_map_get (self->priv->recordings, GUINT_TO_POINTER ((guint) _tmp0_));
		_g_object_unref0 (rec);
		rec = (DVBRecording*) _tmp1_;
		_tmp2_ = time (NULL);
		g_time_local (_tmp2_, &_tmp3_);
		_tmp4_ = _tmp3_;
		dvb_recording_get_StartTime (rec, &_tmp5_);
		_tmp6_ = dvb_utils_difftime (&_tmp4_, &_tmp5_);
		dvb_recording_set_Length (rec, (gint64) _tmp6_);
		_tmp7_ = dvb_recording_get_ChannelName (rec);
		_tmp8_ = dvb_recording_get_Length (rec);
		dvb_logging_logger_debug (dvb_recorder_log, "Recording of channel %s stopped after %" G_GINT64_FORMAT " seconds", _tmp7_, _tmp8_);
		dvb_recording_save_to_disk (rec);
		_tmp9_ = dvb_device_group_get_channel_factory (self->priv->_DeviceGroup);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		channel_factory = _tmp10_;
		_tmp11_ = dvb_timer_get_Channel (timer);
		_tmp12_ = dvb_timer_get_sink (timer);
		dvb_channel_factory_stop_channel (channel_factory, _tmp11_, _tmp12_);
		_tmp13_ = dvb_timer_get_Id (timer);
		gee_map_unset (self->priv->recordings, GUINT_TO_POINTER ((guint) _tmp13_), NULL);
		_g_object_unref0 (channel_factory);
		__finally122:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (rec);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = dvb_timer_get_Id (timer);
	timer_id = _tmp14_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		gee_collection_remove ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (timer_id));
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id), NULL);
		__finally123:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (rec);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_recording_monitor_recording (rec);
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "changed", timer_id, (guint) DVB_CHANGE_TYPE_DELETED);
	_tmp15_ = dvb_recording_get_Id (rec);
	g_signal_emit_by_name ((DVBIDBusRecorder*) self, "recording-finished", _tmp15_);
	_g_object_unref0 (rec);
}


/**
         * @returns: File on success, NULL otherwise
         * 
         * Create directories and set location of recording
         */
static GFile* dvb_recorder_create_recording_dirs (DVBRecorder* self, DVBChannel* channel, guint* start, int start_length1) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* channel_name;
	gchar* _tmp2_ = NULL;
	gchar* time;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_;
	GFile* dir;
	gboolean _tmp8_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp11_ = NULL;
	GFileInfo* _tmp12_;
	guint32 _tmp13_;
	gboolean _tmp16_;
	GFile* _tmp19_ = NULL;
	GFile* recording;
	gboolean _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	_tmp0_ = dvb_channel_get_Name (channel);
	_tmp1_ = dvb_utils_remove_nonalphanums (_tmp0_);
	channel_name = _tmp1_;
	_tmp2_ = g_strdup_printf ("%u-%u-%u_%u-%u", start[0], start[1], start[2], start[3], start[4]);
	time = _tmp2_;
	_tmp3_ = dvb_device_group_get_RecordingsDirectory (self->priv->_DeviceGroup);
	_tmp4_ = g_file_get_child (_tmp3_, channel_name);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_child (_tmp5_, time);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	dir = _tmp7_;
	_tmp8_ = g_file_query_exists (dir, NULL);
	if (!_tmp8_) {
		dvb_utils_mkdirs (dir, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch124_g_error;
		}
		goto __finally124;
		__catch124_g_error:
		{
			GError * e;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = g_file_get_path (dir);
			_tmp10_ = _tmp9_;
			dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:717: Could not create directory %s: %s", _tmp10_, e->message);
			_g_free0 (_tmp10_);
			result = NULL;
			_g_error_free0 (e);
			_g_object_unref0 (dir);
			_g_free0 (time);
			_g_free0 (channel_name);
			return result;
		}
		__finally124:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dir);
			_g_free0 (time);
			_g_free0 (channel_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = g_file_query_info (dir, DVB_RECORDER_ATTRIBUTES, 0, NULL, &_inner_error_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		goto __catch125_g_error;
	}
	_g_object_unref0 (info);
	info = _tmp12_;
	goto __finally125;
	__catch125_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:727: Could not retrieve attributes: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		return result;
	}
	__finally125:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp13_ = g_file_info_get_attribute_uint32 (info, G_FILE_ATTRIBUTE_STANDARD_TYPE);
	if (_tmp13_ != G_FILE_TYPE_DIRECTORY) {
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp14_ = g_file_get_path (dir);
		_tmp15_ = _tmp14_;
		dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:733: %s is not a directory", _tmp15_);
		_g_free0 (_tmp15_);
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		return result;
	}
	_tmp16_ = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
	if (!_tmp16_) {
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		_tmp17_ = g_file_get_path (dir);
		_tmp18_ = _tmp17_;
		dvb_logging_logger_error (dvb_recorder_log, "Recorder.vala:738: Cannot write to %s", _tmp18_);
		_g_free0 (_tmp18_);
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		return result;
	}
	_tmp19_ = g_file_get_child (dir, "001.mpeg");
	recording = _tmp19_;
	_tmp20_ = g_file_query_exists (recording, NULL);
	if (_tmp20_) {
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp21_ = g_file_get_path (recording);
		_tmp22_ = _tmp21_;
		g_warning ("Recorder.vala:744: Recording %s already exists", _tmp22_);
		_g_free0 (_tmp22_);
		result = NULL;
		_g_object_unref0 (recording);
		_g_object_unref0 (info);
		_g_object_unref0 (dir);
		_g_free0 (time);
		_g_free0 (channel_name);
		return result;
	}
	result = recording;
	_g_object_unref0 (info);
	_g_object_unref0 (dir);
	_g_free0 (time);
	_g_free0 (channel_name);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static gboolean dvb_recorder_check_timers (DVBRecorder* self) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GSList* ended_recordings;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:751: Checking timers");
	ended_recordings = NULL;
	{
		GSList* deleteable_items;
		gboolean _tmp29_ = FALSE;
		gint _tmp30_;
		g_static_rec_mutex_lock (&self->priv->__lock_timers);
		{
			GeeIterator* _tmp0_ = NULL;
			GeeIterator* _timer_id_it;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->priv->active_timers);
			_timer_id_it = _tmp0_;
			while (TRUE) {
				gboolean _tmp1_;
				gpointer _tmp2_ = NULL;
				guint32 timer_id;
				gpointer _tmp3_ = NULL;
				DVBTimer* timer;
				gboolean _tmp4_;
				_tmp1_ = gee_iterator_next (_timer_id_it);
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = gee_iterator_get (_timer_id_it);
				timer_id = GPOINTER_TO_UINT (_tmp2_);
				_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (timer_id));
				timer = (DVBTimer*) _tmp3_;
				_tmp4_ = dvb_timer_is_end_due (timer);
				if (_tmp4_) {
					DVBTimer* _tmp5_;
					_tmp5_ = _g_object_ref0 (timer);
					ended_recordings = g_slist_prepend (ended_recordings, _tmp5_);
				}
				_g_object_unref0 (timer);
			}
			_g_object_unref0 (_timer_id_it);
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					guint _tmp7_;
					gconstpointer _tmp8_ = NULL;
					DVBTimer* _tmp9_;
					DVBTimer* timer;
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					_tmp7_ = g_slist_length (ended_recordings);
					if (!(i < _tmp7_)) {
						break;
					}
					_tmp8_ = g_slist_nth_data (ended_recordings, (guint) i);
					_tmp9_ = _g_object_ref0 ((DVBTimer*) _tmp8_);
					timer = _tmp9_;
					dvb_recorder_stop_recording (self, timer);
					_g_object_unref0 (timer);
				}
			}
		}
		deleteable_items = NULL;
		{
			GeeSet* _tmp10_ = NULL;
			GeeSet* _tmp11_;
			GeeIterator* _tmp12_ = NULL;
			GeeIterator* _tmp13_;
			GeeIterator* _key_it;
			_tmp10_ = gee_map_get_keys ((GeeMap*) self->priv->timers);
			_tmp11_ = _tmp10_;
			_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp11_);
			_key_it = _tmp13_;
			while (TRUE) {
				gboolean _tmp14_;
				gpointer _tmp15_ = NULL;
				guint32 key;
				gpointer _tmp16_ = NULL;
				DVBTimer* timer;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_;
				_tmp14_ = gee_iterator_next (_key_it);
				if (!_tmp14_) {
					break;
				}
				_tmp15_ = gee_iterator_get (_key_it);
				key = GPOINTER_TO_UINT (_tmp15_);
				_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->timers, GUINT_TO_POINTER (key));
				timer = (DVBTimer*) _tmp16_;
				_tmp17_ = dvb_timer_to_string (timer);
				_tmp18_ = _tmp17_;
				dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:777: Checking timer: %s", _tmp18_);
				_g_free0 (_tmp18_);
				_tmp20_ = dvb_timer_is_start_due (timer);
				if (_tmp20_) {
					guint32 _tmp21_;
					gboolean _tmp22_;
					_tmp21_ = dvb_timer_get_Id (timer);
					_tmp22_ = gee_collection_contains ((GeeCollection*) self->priv->active_timers, GUINT_TO_POINTER (_tmp21_));
					_tmp19_ = !_tmp22_;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					dvb_recorder_start_recording (self, timer);
				} else {
					gboolean _tmp23_;
					_tmp23_ = dvb_timer_has_expired (timer);
					if (_tmp23_) {
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_;
						_tmp24_ = dvb_timer_to_string (timer);
						_tmp25_ = _tmp24_;
						dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:785: Removing expired timer: %s", _tmp25_);
						_g_free0 (_tmp25_);
						deleteable_items = g_slist_prepend (deleteable_items, GUINT_TO_POINTER (key));
					}
				}
				_g_object_unref0 (timer);
			}
			_g_object_unref0 (_key_it);
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp26_;
				_tmp26_ = TRUE;
				while (TRUE) {
					guint _tmp27_;
					gconstpointer _tmp28_ = NULL;
					if (!_tmp26_) {
						i++;
					}
					_tmp26_ = FALSE;
					_tmp27_ = g_slist_length (deleteable_items);
					if (!(i < _tmp27_)) {
						break;
					}
					_tmp28_ = g_slist_nth_data (deleteable_items, (guint) i);
					dvb_recorder_delete_timer (self, GPOINTER_TO_UINT (_tmp28_));
				}
			}
		}
		_tmp30_ = gee_map_get_size ((GeeMap*) self->priv->timers);
		if (_tmp30_ == 0) {
			gint _tmp31_;
			_tmp31_ = gee_collection_get_size ((GeeCollection*) self->priv->active_timers);
			_tmp29_ = _tmp31_ == 0;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:797: No timers left and no recording in progress");
			self->priv->have_check_timers_timeout = FALSE;
			self->priv->check_timers_event_id = (guint) 0;
			val = FALSE;
		} else {
			gint _tmp32_;
			gint _tmp33_;
			_tmp32_ = gee_map_get_size ((GeeMap*) self->priv->timers);
			_tmp33_ = gee_collection_get_size ((GeeCollection*) self->priv->active_timers);
			dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:803: %d timers and %d active recordings left", _tmp32_, _tmp33_);
			val = TRUE;
		}
		_g_slist_free0 (deleteable_items);
		__finally126:
		g_static_rec_mutex_unlock (&self->priv->__lock_timers);
		if (_inner_error_ != NULL) {
			__g_slist_free__g_object_unref0_0 (ended_recordings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	__g_slist_free__g_object_unref0_0 (ended_recordings);
	return result;
}


static void dvb_recorder_on_eit_structure (DVBRecorder* self, DVBPlayerThread* player, const GstStructure* structure) {
	guint sid = 0U;
	guint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (structure != NULL);
	gst_structure_get_uint (structure, "service-id", &_tmp0_);
	sid = _tmp0_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeCollection* _tmp1_ = NULL;
			GeeCollection* _tmp2_;
			GeeIterator* _tmp3_ = NULL;
			GeeIterator* _tmp4_;
			GeeIterator* _rec_it;
			_tmp1_ = gee_map_get_values (self->priv->recordings);
			_tmp2_ = _tmp1_;
			_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp2_);
			_rec_it = _tmp4_;
			while (TRUE) {
				gboolean _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* rec;
				gboolean _tmp7_ = FALSE;
				const gchar* _tmp8_ = NULL;
				_tmp5_ = gee_iterator_next (_rec_it);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = gee_iterator_get (_rec_it);
				rec = (DVBRecording*) _tmp6_;
				_tmp8_ = dvb_recording_get_Name (rec);
				if (_tmp8_ == NULL) {
					guint _tmp9_;
					_tmp9_ = dvb_recording_get_ChannelSid (rec);
					_tmp7_ = sid == _tmp9_;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					DVBChannelList* _tmp10_ = NULL;
					DVBChannel* _tmp11_ = NULL;
					DVBChannel* chan;
					DVBSchedule* _tmp12_ = NULL;
					DVBSchedule* _tmp13_;
					DVBSchedule* sched;
					DVBEvent* _tmp14_ = NULL;
					DVBEvent* event;
					_tmp10_ = dvb_device_group_get_Channels (self->priv->_DeviceGroup);
					_tmp11_ = dvb_channel_list_get_channel (_tmp10_, sid);
					chan = _tmp11_;
					_tmp12_ = dvb_channel_get_Schedule (chan);
					_tmp13_ = _g_object_ref0 (_tmp12_);
					sched = _tmp13_;
					_tmp14_ = dvb_schedule_get_running_event (sched);
					event = _tmp14_;
					if (event != NULL) {
						gchar* _tmp15_ = NULL;
						gchar* _tmp16_;
						dvb_logging_logger_debug (dvb_recorder_log, "Recorder.vala:825: Found running event for active recording");
						dvb_recording_set_Name (rec, event->name);
						_tmp15_ = g_strdup_printf ("%s\n%s", event->description, event->extended_description);
						_tmp16_ = _tmp15_;
						dvb_recording_set_Description (rec, _tmp16_);
						_g_free0 (_tmp16_);
					}
					_dvb_event_unref0 (event);
					_g_object_unref0 (sched);
					_g_object_unref0 (chan);
				}
				_g_object_unref0 (rec);
			}
			_g_object_unref0 (_rec_it);
		}
		__finally127:
		g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBDeviceGroup* dvb_recorder_get_DeviceGroup (DVBRecorder* self) {
	DVBDeviceGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_DeviceGroup;
	return result;
}


static void dvb_recorder_set_DeviceGroup (DVBRecorder* self, DVBDeviceGroup* value) {
	g_return_if_fail (self != NULL);
	self->priv->_DeviceGroup = value;
	g_object_notify ((GObject *) self, "DeviceGroup");
}


guint dvb_recorder_get_count (DVBRecorder* self) {
	guint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gee_map_get_size (self->priv->recordings);
	result = (guint) _tmp0_;
	return result;
}


static GType dvb_recorder_real_get_element_type (GeeIterable* base) {
	GType result;
	DVBRecorder* self;
	self = (DVBRecorder*) base;
	result = DVB_TYPE_TIMER;
	return result;
}


static GObject * dvb_recorder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBRecorder * self;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	DVBRecordingsStore* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_recorder_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDER (obj);
	_tmp0_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->active_timers);
	self->priv->active_timers = (GeeSet*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_TIMER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->timers);
	self->priv->timers = _tmp1_;
	self->priv->have_check_timers_timeout = FALSE;
	_tmp2_ = dvb_recordings_store_get_instance ();
	_tmp3_ = dvb_device_group_get_RecordingsDirectory (self->priv->_DeviceGroup);
	dvb_recordings_store_restore_from_dir (_tmp2_, _tmp3_);
	_tmp4_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->recordings);
	self->priv->recordings = (GeeMap*) _tmp4_;
	self->priv->check_timers_event_id = (guint) 0;
	return obj;
}


static void dvb_recorder_class_init (DVBRecorderClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_recorder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecorderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_recorder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_recorder_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_recorder_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recorder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDER_DEVICE_GROUP, g_param_spec_object ("DeviceGroup", "DeviceGroup", "DeviceGroup", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDER_COUNT, g_param_spec_uint ("count", "count", "count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_RECORDER_ELEMENT_TYPE, "element-type");
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_recorder_log = _tmp1_;
}


static void dvb_recorder_dvb_id_bus_recorder_interface_init (DVBIDBusRecorderIface * iface) {
	dvb_recorder_dvb_id_bus_recorder_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddTimer = (gboolean (*)(DVBIDBusRecorder* ,guint ,gint ,gint ,gint ,gint ,gint ,guint ,guint32* ,GError**)) dvb_recorder_real_AddTimer;
	iface->AddTimerWithMargin = (gboolean (*)(DVBIDBusRecorder* ,guint ,gint ,gint ,gint ,gint ,gint ,guint ,guint32* ,GError**)) dvb_recorder_real_AddTimerWithMargin;
	iface->AddTimerForEPGEvent = (gboolean (*)(DVBIDBusRecorder* ,guint ,guint ,guint32* ,GError**)) dvb_recorder_real_AddTimerForEPGEvent;
	iface->DeleteTimer = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,GError**)) dvb_recorder_real_DeleteTimer;
	iface->GetTimers = (guint32* (*)(DVBIDBusRecorder* ,int* ,GError**)) dvb_recorder_real_GetTimers;
	iface->GetStartTime = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,guint32** ,int* ,GError**)) dvb_recorder_real_GetStartTime;
	iface->SetStartTime = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,gint ,gint ,gint ,gint ,gint ,GError**)) dvb_recorder_real_SetStartTime;
	iface->GetEndTime = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,guint** ,int* ,GError**)) dvb_recorder_real_GetEndTime;
	iface->GetDuration = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,guint* ,GError**)) dvb_recorder_real_GetDuration;
	iface->SetDuration = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,guint ,GError**)) dvb_recorder_real_SetDuration;
	iface->GetChannelName = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,gchar** ,GError**)) dvb_recorder_real_GetChannelName;
	iface->GetTitle = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,gchar** ,GError**)) dvb_recorder_real_GetTitle;
	iface->GetAllInformations = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,DVBTimerInfo* ,GError**)) dvb_recorder_real_GetAllInformations;
	iface->GetActiveTimers = (guint32* (*)(DVBIDBusRecorder* ,int* ,GError**)) dvb_recorder_real_GetActiveTimers;
	iface->IsTimerActive = (gboolean (*)(DVBIDBusRecorder* ,guint32 ,GError**)) dvb_recorder_real_IsTimerActive;
	iface->HasTimer = (gboolean (*)(DVBIDBusRecorder* ,guint ,guint ,guint ,guint ,guint ,guint ,GError**)) dvb_recorder_real_HasTimer;
	iface->HasTimerForEvent = (DVBOverlapType (*)(DVBIDBusRecorder* ,guint ,guint ,GError**)) dvb_recorder_real_HasTimerForEvent;
}


static void dvb_recorder_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_recorder_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) dvb_recorder_real_iterator;
	iface->get_element_type = dvb_recorder_real_get_element_type;
}


static void dvb_recorder_instance_init (DVBRecorder * self) {
	self->priv = DVB_RECORDER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_timers);
	g_static_rec_mutex_init (&self->priv->__lock_recordings);
}


static void dvb_recorder_finalize (GObject* obj) {
	DVBRecorder * self;
	self = DVB_RECORDER (obj);
	_g_object_unref0 (self->priv->active_timers);
	g_static_rec_mutex_free (&self->priv->__lock_timers);
	_g_object_unref0 (self->priv->timers);
	g_static_rec_mutex_free (&self->priv->__lock_recordings);
	_g_object_unref0 (self->priv->recordings);
	G_OBJECT_CLASS (dvb_recorder_parent_class)->finalize (obj);
}


/**
     * This class is responsible for managing upcoming recordings and
     * already recorded items for a single group of devices
     */
GType dvb_recorder_get_type (void) {
	static volatile gsize dvb_recorder_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recorder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecorder), 0, (GInstanceInitFunc) dvb_recorder_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recorder_info = { (GInterfaceInitFunc) dvb_recorder_dvb_id_bus_recorder_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_recorder_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_recorder_type_id;
		dvb_recorder_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecorder", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recorder_type_id, DVB_TYPE_ID_BUS_RECORDER, &dvb_id_bus_recorder_info);
		g_type_add_interface_static (dvb_recorder_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_once_init_leave (&dvb_recorder_type_id__volatile, dvb_recorder_type_id);
	}
	return dvb_recorder_type_id__volatile;
}


static void _vala_dvb_recorder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecorder * self;
	self = DVB_RECORDER (object);
	switch (property_id) {
		case DVB_RECORDER_DEVICE_GROUP:
		g_value_set_object (value, dvb_recorder_get_DeviceGroup (self));
		break;
		case DVB_RECORDER_COUNT:
		g_value_set_uint (value, dvb_recorder_get_count (self));
		break;
		case DVB_RECORDER_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_recorder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecorder * self;
	self = DVB_RECORDER (object);
	switch (property_id) {
		case DVB_RECORDER_DEVICE_GROUP:
		dvb_recorder_set_DeviceGroup (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



