/* SqliteEPGStore.c generated by valac 0.12.0, the Vala compiler
 * generated from SqliteEPGStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include <stdio.h>


#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBdatabasesqliteSqliteDatabasePrivate DVBdatabasesqliteSqliteDatabasePrivate;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE (dvb_database_sqlite_sqlite_epg_store_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStore))
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStoreClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE))
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStoreClass))

typedef struct _DVBdatabasesqliteSqliteEPGStore DVBdatabasesqliteSqliteEPGStore;
typedef struct _DVBdatabasesqliteSqliteEPGStoreClass DVBdatabasesqliteSqliteEPGStoreClass;
typedef struct _DVBdatabasesqliteSqliteEPGStorePrivate DVBdatabasesqliteSqliteEPGStorePrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
#define __g_slist_free__dvb_event_audio_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_audio_component_unref0_ (var), NULL)))
#define __g_slist_free__dvb_event_video_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_video_component_unref0_ (var), NULL)))
#define __g_slist_free__dvb_event_teletext_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_teletext_component_unref0_ (var), NULL)))

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabasesqliteSqliteDatabase {
	GObject parent_instance;
	DVBdatabasesqliteSqliteDatabasePrivate * priv;
	sqlite3* db;
};

struct _DVBdatabasesqliteSqliteDatabaseClass {
	GObjectClass parent_class;
	void (*create) (DVBdatabasesqliteSqliteDatabase* self, GError** error);
	void (*upgrade) (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
	void (*on_open) (DVBdatabasesqliteSqliteDatabase* self);
};

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBdatabasesqliteSqliteEPGStore {
	DVBdatabasesqliteSqliteDatabase parent_instance;
	DVBdatabasesqliteSqliteEPGStorePrivate * priv;
};

struct _DVBdatabasesqliteSqliteEPGStoreClass {
	DVBdatabasesqliteSqliteDatabaseClass parent_class;
};

struct _DVBdatabasesqliteSqliteEPGStorePrivate {
	sqlite3_stmt* to_julian_statement;
	sqlite3_stmt* insert_event_statement;
	sqlite3_stmt* update_event_statement;
	sqlite3_stmt* delete_event_statement;
	sqlite3_stmt* has_event_statement;
	sqlite3_stmt* select_event_statement;
	sqlite3_stmt* delete_events_group;
	sqlite3_stmt* delete_expired_events;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_database_sqlite_sqlite_epg_store_parent_class = NULL;
static DVBLoggingLogger* dvb_database_sqlite_sqlite_epg_store_log;
static DVBLoggingLogger* dvb_database_sqlite_sqlite_epg_store_log = NULL;
static DVBdatabaseEPGStoreIface* dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_parent_iface = NULL;

GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
GType dvb_database_sqlite_sqlite_epg_store_get_type (void) G_GNUC_CONST;
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStorePrivate))
enum  {
	DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_VERSION 2
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CREATE_EVENTS_TABLE_STATEMENT "CREATE TABLE events (group_id INTEGER,\n" \
"            sid INTEGER,\n" \
"            event_id INTEGER,\n" \
"            starttime JULIAN,\n" \
"            duration INTEGER,\n" \
"            running_status INTEGER(2),\n" \
"            free_ca_mode INTEGER(1),\n" \
"            name VARCHAR(255),\n" \
"            description VARCHAR(255),\n" \
"            extended_description TEXT,\n" \
"            PRIMARY KEY (group_id, sid, event_id))"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_INSERT_EVENT_SQL "INSERT INTO events VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENT_STATEMENT "DELETE FROM events WHERE group_id=? AND sid=? AND event_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_ALL_EVENTS_STATEMENT "SELECT event_id, datetime(starttime),\n" \
"            duration, running_status, free_ca_mode, name,\n" \
"            description, extended_description\n" \
"            FROM events WHERE group_id='%u' AND sid='%u'"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_MINIMAL_EVENTS_STATEMENT "SELECT event_id, datetime(starttime),\n" \
"            duration FROM events WHERE group_id='%u' AND sid='%u'\n" \
"            ORDER BY starttime ASC"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_HAS_EVENT_STATEMENT "SELECT 1 FROM events WHERE group_id=? AND sid=? AND event_id=? LIMIT 1"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_UPDATE_EVENT_SQL "UPDATE events SET starttime=?, duration=?, running_status=?,\n" \
"            free_ca_mode=?, name=?, description=?,\n" \
"            extended_description=? WHERE group_id=? AND sid=? AND even" \
"t_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_TO_JULIAN_SQL "SELECT julianday(?)"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_EVENT_SQL "SELECT event_id, datetime(starttime),\n" \
"            duration, running_status, free_ca_mode, name,\n" \
"            description, extended_description\n" \
"            FROM events WHERE group_id=? AND sid=? AND event_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENTS_GROUP "DELETE FROM events WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EXPIRED_EVENTS "DELETE FROM events WHERE starttime <= julianday(?, 'unixepoch')\n" \
"        AND sid=? AND group_id=?"
DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_new (void);
DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_construct (GType object_type);
DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version);
static void dvb_database_sqlite_sqlite_epg_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base);
static void dvb_database_sqlite_sqlite_epg_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error);
void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error);
static void dvb_database_sqlite_sqlite_epg_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
gchar* dvb_database_sqlite_utils_escape (const gchar* text);
static gdouble dvb_database_sqlite_sqlite_epg_store_to_julian (DVBdatabasesqliteSqliteEPGStore* self, guint year, guint month, guint day, guint hour, guint minute, guint second, GError** error);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_database_epg_store_contains_event (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const gchar* errmsg, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error_reset (DVBdatabasesqliteSqliteDatabase* self, sqlite3_stmt* stmnt, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_real_get_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_contains_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
static GeeList* dvb_database_sqlite_sqlite_epg_store_real_get_events (DVBdatabaseEPGStore* base, guint channel_sid, guint group_id, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_minimal_event (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group (DVBdatabaseEPGStore* base, guint group_id, GError** error);
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
gchar* dvb_database_sqlite_utils_unescape (const gchar* text);
static void _dvb_event_audio_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_audio_component_unref0_ (GSList* self);
static void _dvb_event_video_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_video_component_unref0_ (GSList* self);
static void _dvb_event_teletext_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_teletext_component_unref0_ (GSList* self);
static void dvb_database_sqlite_sqlite_epg_store_finalize (GObject* obj);


DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_construct (GType object_type) {
	DVBdatabasesqliteSqliteEPGStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* cache_dir;
	GFile* _tmp2_ = NULL;
	GFile* our_cache;
	GFile* _tmp3_ = NULL;
	GFile* database_file;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	cache_dir = _tmp1_;
	_tmp2_ = g_file_get_child (cache_dir, "gnome-dvb-daemon");
	our_cache = _tmp2_;
	_tmp3_ = g_file_get_child (our_cache, "eventsdb.sqlite3");
	database_file = _tmp3_;
	self = (DVBdatabasesqliteSqliteEPGStore*) dvb_database_sqlite_sqlite_database_construct (object_type, database_file, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_VERSION);
	_g_object_unref0 (database_file);
	_g_object_unref0 (our_cache);
	_g_object_unref0 (cache_dir);
	return self;
}


DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_new (void) {
	return dvb_database_sqlite_sqlite_epg_store_construct (DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE);
}


static void dvb_database_sqlite_sqlite_epg_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base) {
	DVBdatabasesqliteSqliteEPGStore * self;
	sqlite3_stmt* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	sqlite3_stmt* _tmp6_ = NULL;
	sqlite3_stmt* _tmp7_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_TO_JULIAN_SQL, -1, &_tmp0_, NULL);
	_sqlite3_finalize0 (self->priv->to_julian_statement);
	self->priv->to_julian_statement = _tmp0_;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_INSERT_EVENT_SQL, -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (self->priv->insert_event_statement);
	self->priv->insert_event_statement = _tmp1_;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_UPDATE_EVENT_SQL, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (self->priv->update_event_statement);
	self->priv->update_event_statement = _tmp2_;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENT_STATEMENT, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (self->priv->delete_event_statement);
	self->priv->delete_event_statement = _tmp3_;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_HAS_EVENT_STATEMENT, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (self->priv->has_event_statement);
	self->priv->has_event_statement = _tmp4_;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_EVENT_SQL, -1, &_tmp5_, NULL);
	_sqlite3_finalize0 (self->priv->select_event_statement);
	self->priv->select_event_statement = _tmp5_;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENTS_GROUP, -1, &_tmp6_, NULL);
	_sqlite3_finalize0 (self->priv->delete_events_group);
	self->priv->delete_events_group = _tmp6_;
	sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EXPIRED_EVENTS, -1, &_tmp7_, NULL);
	_sqlite3_finalize0 (self->priv->delete_expired_events);
	self->priv->delete_expired_events = _tmp7_;
}


static void dvb_database_sqlite_sqlite_epg_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CREATE_EVENTS_TABLE_STATEMENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, "PRAGMA synchronous=OFF", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_database_sqlite_sqlite_epg_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	if (old_version == 1) {
		dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, "PRAGMA synchronous=OFF", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint free_ca_mode;
	gchar* _tmp1_ = NULL;
	gchar* name;
	gchar* _tmp2_ = NULL;
	gchar* desc;
	gchar* _tmp3_ = NULL;
	gchar* ext_desc;
	gdouble _tmp4_;
	gdouble julian_start;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->free_ca_mode) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	free_ca_mode = _tmp0_;
	_tmp1_ = dvb_database_sqlite_utils_escape (event->name);
	name = _tmp1_;
	_tmp2_ = dvb_database_sqlite_utils_escape (event->description);
	desc = _tmp2_;
	_tmp3_ = dvb_database_sqlite_utils_escape (event->extended_description);
	ext_desc = _tmp3_;
	_tmp4_ = dvb_database_sqlite_sqlite_epg_store_to_julian (self, event->year, event->month, event->day, event->hour, event->minute, event->second, &_inner_error_);
	julian_start = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return FALSE;
		} else {
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (julian_start <= 0) {
		dvb_logging_logger_warning (dvb_database_sqlite_sqlite_epg_store_log, "SqliteEPGStore.vala:150: Failed to convert start time");
		result = FALSE;
		_g_free0 (ext_desc);
		_g_free0 (desc);
		_g_free0 (name);
		return result;
	}
	_tmp5_ = dvb_database_epg_store_contains_event ((DVBdatabaseEPGStore*) self, event, channel_sid, group_id, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return FALSE;
		} else {
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp6_) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gint _tmp16_;
		gint _tmp29_;
		_tmp16_ = sqlite3_bind_double (self->priv->update_event_statement, 1, julian_start);
		if (_tmp16_ != SQLITE_OK) {
			_tmp15_ = TRUE;
		} else {
			gint _tmp17_;
			_tmp17_ = sqlite3_bind_int (self->priv->update_event_statement, 2, (gint) event->duration);
			_tmp15_ = _tmp17_ != SQLITE_OK;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gint _tmp18_;
			_tmp18_ = sqlite3_bind_int (self->priv->update_event_statement, 3, (gint) event->running_status);
			_tmp14_ = _tmp18_ != SQLITE_OK;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			gint _tmp19_;
			_tmp19_ = sqlite3_bind_int (self->priv->update_event_statement, 4, free_ca_mode);
			_tmp13_ = _tmp19_ != SQLITE_OK;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gchar* _tmp20_;
			gint _tmp21_;
			_tmp20_ = g_strdup (name);
			_tmp21_ = sqlite3_bind_text (self->priv->update_event_statement, 5, _tmp20_, -1, g_free);
			_tmp12_ = _tmp21_ != SQLITE_OK;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			gchar* _tmp22_;
			gint _tmp23_;
			_tmp22_ = g_strdup (desc);
			_tmp23_ = sqlite3_bind_text (self->priv->update_event_statement, 6, _tmp22_, -1, g_free);
			_tmp11_ = _tmp23_ != SQLITE_OK;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gchar* _tmp24_;
			gint _tmp25_;
			_tmp24_ = g_strdup (ext_desc);
			_tmp25_ = sqlite3_bind_text (self->priv->update_event_statement, 7, _tmp24_, -1, g_free);
			_tmp10_ = _tmp25_ != SQLITE_OK;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			gint _tmp26_;
			_tmp26_ = sqlite3_bind_int (self->priv->update_event_statement, 8, (gint) group_id);
			_tmp9_ = _tmp26_ != SQLITE_OK;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			gint _tmp27_;
			_tmp27_ = sqlite3_bind_int (self->priv->update_event_statement, 9, (gint) channel_sid);
			_tmp8_ = _tmp27_ != SQLITE_OK;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			gint _tmp28_;
			_tmp28_ = sqlite3_bind_int (self->priv->update_event_statement, 10, (gint) event->id);
			_tmp7_ = _tmp28_ != SQLITE_OK;
		}
		if (_tmp7_) {
			dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		_tmp29_ = sqlite3_step (self->priv->update_event_statement);
		if (_tmp29_ != SQLITE_DONE) {
			dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->update_event_statement, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		sqlite3_reset (self->priv->update_event_statement);
	} else {
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gint _tmp39_;
		gint _tmp52_;
		_tmp39_ = sqlite3_bind_int (self->priv->insert_event_statement, 1, (gint) group_id);
		if (_tmp39_ != SQLITE_OK) {
			_tmp38_ = TRUE;
		} else {
			gint _tmp40_;
			_tmp40_ = sqlite3_bind_int (self->priv->insert_event_statement, 2, (gint) channel_sid);
			_tmp38_ = _tmp40_ != SQLITE_OK;
		}
		if (_tmp38_) {
			_tmp37_ = TRUE;
		} else {
			gint _tmp41_;
			_tmp41_ = sqlite3_bind_int (self->priv->insert_event_statement, 3, (gint) event->id);
			_tmp37_ = _tmp41_ != SQLITE_OK;
		}
		if (_tmp37_) {
			_tmp36_ = TRUE;
		} else {
			gint _tmp42_;
			_tmp42_ = sqlite3_bind_double (self->priv->insert_event_statement, 4, julian_start);
			_tmp36_ = _tmp42_ != SQLITE_OK;
		}
		if (_tmp36_) {
			_tmp35_ = TRUE;
		} else {
			gint _tmp43_;
			_tmp43_ = sqlite3_bind_int (self->priv->insert_event_statement, 5, (gint) event->duration);
			_tmp35_ = _tmp43_ != SQLITE_OK;
		}
		if (_tmp35_) {
			_tmp34_ = TRUE;
		} else {
			gint _tmp44_;
			_tmp44_ = sqlite3_bind_int (self->priv->insert_event_statement, 6, (gint) event->running_status);
			_tmp34_ = _tmp44_ != SQLITE_OK;
		}
		if (_tmp34_) {
			_tmp33_ = TRUE;
		} else {
			gint _tmp45_;
			_tmp45_ = sqlite3_bind_int (self->priv->insert_event_statement, 7, free_ca_mode);
			_tmp33_ = _tmp45_ != SQLITE_OK;
		}
		if (_tmp33_) {
			_tmp32_ = TRUE;
		} else {
			gchar* _tmp46_;
			gint _tmp47_;
			_tmp46_ = g_strdup (name);
			_tmp47_ = sqlite3_bind_text (self->priv->insert_event_statement, 8, _tmp46_, -1, g_free);
			_tmp32_ = _tmp47_ != SQLITE_OK;
		}
		if (_tmp32_) {
			_tmp31_ = TRUE;
		} else {
			gchar* _tmp48_;
			gint _tmp49_;
			_tmp48_ = g_strdup (desc);
			_tmp49_ = sqlite3_bind_text (self->priv->insert_event_statement, 9, _tmp48_, -1, g_free);
			_tmp31_ = _tmp49_ != SQLITE_OK;
		}
		if (_tmp31_) {
			_tmp30_ = TRUE;
		} else {
			gchar* _tmp50_;
			gint _tmp51_;
			_tmp50_ = g_strdup (ext_desc);
			_tmp51_ = sqlite3_bind_text (self->priv->insert_event_statement, 10, _tmp50_, -1, g_free);
			_tmp30_ = _tmp51_ != SQLITE_OK;
		}
		if (_tmp30_) {
			dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		_tmp52_ = sqlite3_step (self->priv->insert_event_statement);
		if (_tmp52_ != SQLITE_DONE) {
			dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->insert_event_statement, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		sqlite3_reset (self->priv->insert_event_statement);
	}
	result = TRUE;
	_g_free0 (ext_desc);
	_g_free0 (desc);
	_g_free0 (name);
	return result;
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_real_get_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	DVBEvent* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp5_;
	gint rc;
	gboolean _tmp6_ = FALSE;
	DVBEvent* event;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp2_ = sqlite3_bind_int (self->priv->select_event_statement, 1, (gint) group_id);
	if (_tmp2_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp3_;
		_tmp3_ = sqlite3_bind_int (self->priv->select_event_statement, 2, (gint) channel_sid);
		_tmp1_ = _tmp3_ != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = sqlite3_bind_int (self->priv->select_event_statement, 3, (gint) event_id);
		_tmp0_ = _tmp4_ != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = NULL;
		return result;
	}
	_tmp5_ = sqlite3_step (self->priv->select_event_statement);
	rc = _tmp5_;
	if (rc != SQLITE_ROW) {
		_tmp6_ = rc != SQLITE_DONE;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->select_event_statement, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = NULL;
		return result;
	}
	event = NULL;
	if (rc != SQLITE_DONE) {
		DVBEvent* _tmp7_ = NULL;
		_tmp7_ = dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (self, self->priv->select_event_statement);
		_dvb_event_unref0 (event);
		event = _tmp7_;
	}
	sqlite3_reset (self->priv->select_event_statement);
	result = event;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp2_ = sqlite3_bind_int (self->priv->delete_event_statement, 1, (gint) group_id);
	if (_tmp2_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp3_;
		_tmp3_ = sqlite3_bind_int (self->priv->delete_event_statement, 2, (gint) channel_sid);
		_tmp1_ = _tmp3_ != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = sqlite3_bind_int (self->priv->delete_event_statement, 3, (gint) event_id);
		_tmp0_ = _tmp4_ != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp5_ = sqlite3_step (self->priv->delete_event_statement);
	if (_tmp5_ != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->delete_event_statement, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	sqlite3_reset (self->priv->delete_event_statement);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	time_t _tmp0_;
	time_t timestamp;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = dvb_event_get_end_timestamp (event);
	timestamp = _tmp0_;
	_tmp3_ = sqlite3_bind_int64 (self->priv->delete_expired_events, 1, (gint64) timestamp);
	if (_tmp3_ != SQLITE_OK) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = sqlite3_bind_int (self->priv->delete_expired_events, 2, (gint) channel_sid);
		_tmp2_ = _tmp4_ != SQLITE_OK;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp5_;
		_tmp5_ = sqlite3_bind_int (self->priv->delete_expired_events, 3, (gint) group_id);
		_tmp1_ = _tmp5_ != SQLITE_OK;
	}
	if (_tmp1_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp6_ = sqlite3_step (self->priv->delete_expired_events);
	if (_tmp6_ != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->delete_expired_events, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	sqlite3_reset (self->priv->delete_expired_events);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_contains_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint c;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = sqlite3_bind_int (self->priv->has_event_statement, 1, (gint) group_id);
	if (_tmp2_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp3_;
		_tmp3_ = sqlite3_bind_int (self->priv->has_event_statement, 2, (gint) channel_sid);
		_tmp1_ = _tmp3_ != SQLITE_OK;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = sqlite3_bind_int (self->priv->has_event_statement, 3, (gint) event->id);
		_tmp0_ = _tmp4_ != SQLITE_OK;
	}
	if (_tmp0_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	c = 0;
	while (TRUE) {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = sqlite3_step (self->priv->has_event_statement);
		if (!(_tmp5_ == SQLITE_ROW)) {
			break;
		}
		_tmp6_ = sqlite3_column_int (self->priv->has_event_statement, 0);
		c = _tmp6_;
	}
	sqlite3_reset (self->priv->has_event_statement);
	result = c > 0;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_epg_store_real_get_events (DVBdatabaseEPGStore* base, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* events;
	gchar* _tmp1_ = NULL;
	gchar* statement_str;
	sqlite3_stmt* statement = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp0_ = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	events = (GeeList*) _tmp0_;
	if (((DVBdatabasesqliteSqliteDatabase*) self)->db == NULL) {
		dvb_logging_logger_warning (dvb_database_sqlite_sqlite_epg_store_log, "SqliteEPGStore.vala:295: DB not initialized");
		result = events;
		return result;
	}
	_tmp1_ = g_strdup_printf (DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_MINIMAL_EVENTS_STATEMENT, group_id, channel_sid);
	statement_str = _tmp1_;
	_tmp3_ = sqlite3_prepare (((DVBdatabasesqliteSqliteDatabase*) self)->db, statement_str, -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp2_;
	if (_tmp3_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (statement);
				_g_free0 (statement_str);
				_g_object_unref0 (events);
				return NULL;
			} else {
				_sqlite3_finalize0 (statement);
				_g_free0 (statement_str);
				_g_object_unref0 (events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = events;
		_sqlite3_finalize0 (statement);
		_g_free0 (statement_str);
		return result;
	}
	while (TRUE) {
		gint _tmp4_;
		DVBEvent* _tmp5_ = NULL;
		DVBEvent* event;
		_tmp4_ = sqlite3_step (statement);
		if (!(_tmp4_ == SQLITE_ROW)) {
			break;
		}
		_tmp5_ = dvb_database_sqlite_sqlite_epg_store_create_minimal_event (self, statement);
		event = _tmp5_;
		gee_collection_add ((GeeCollection*) events, event);
		_dvb_event_unref0 (event);
	}
	result = events;
	_sqlite3_finalize0 (statement);
	_g_free0 (statement_str);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group (DVBdatabaseEPGStore* base, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp0_ = sqlite3_bind_int (self->priv->delete_events_group, 1, (gint) group_id);
	if (_tmp0_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp1_ = sqlite3_step (self->priv->delete_events_group);
	if (_tmp1_ != SQLITE_DONE) {
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, self->priv->delete_events_group, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	sqlite3_reset (self->priv->delete_events_group);
	result = TRUE;
	return result;
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_minimal_event (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement) {
	DVBEvent* result = NULL;
	DVBEvent* _tmp0_ = NULL;
	DVBEvent* event;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* starttime;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = dvb_event_new ();
	event = _tmp0_;
	_tmp1_ = sqlite3_column_int (statement, 0);
	event->id = (guint) _tmp1_;
	_tmp2_ = sqlite3_column_text (statement, 1);
	starttime = _tmp2_;
	sscanf (starttime, "%04u-%02u-%02u %02u:%02u:%02u", &event->year, &event->month, &event->day, &event->hour, &event->minute, &event->second);
	_tmp3_ = sqlite3_column_int (statement, 2);
	event->duration = (guint) _tmp3_;
	result = event;
	return result;
}


static void _dvb_event_audio_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_audio_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_audio_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_audio_component_unref0_, NULL);
	g_slist_free (self);
}


static void _dvb_event_video_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_video_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_video_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_video_component_unref0_, NULL);
	g_slist_free (self);
}


static void _dvb_event_teletext_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_teletext_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_teletext_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_teletext_component_unref0_, NULL);
	g_slist_free (self);
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement) {
	DVBEvent* result = NULL;
	DVBEvent* _tmp0_ = NULL;
	DVBEvent* event;
	gint _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* starttime;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = dvb_event_new ();
	event = _tmp0_;
	_tmp1_ = sqlite3_column_int (statement, 0);
	event->id = (guint) _tmp1_;
	_tmp2_ = sqlite3_column_text (statement, 1);
	starttime = _tmp2_;
	sscanf (starttime, "%04u-%02u-%02u %02u:%02u:%02u", &event->year, &event->month, &event->day, &event->hour, &event->minute, &event->second);
	_tmp3_ = sqlite3_column_int (statement, 2);
	event->duration = (guint) _tmp3_;
	_tmp4_ = sqlite3_column_int (statement, 3);
	event->running_status = (guint) _tmp4_;
	_tmp5_ = sqlite3_column_int (statement, 4);
	event->free_ca_mode = _tmp5_ == 1;
	_tmp6_ = sqlite3_column_text (statement, 5);
	_tmp7_ = dvb_database_sqlite_utils_unescape (_tmp6_);
	_g_free0 (event->name);
	event->name = _tmp7_;
	_tmp8_ = sqlite3_column_text (statement, 6);
	_tmp9_ = dvb_database_sqlite_utils_unescape (_tmp8_);
	_g_free0 (event->description);
	event->description = _tmp9_;
	_tmp10_ = sqlite3_column_text (statement, 7);
	_tmp11_ = dvb_database_sqlite_utils_unescape (_tmp10_);
	_g_free0 (event->extended_description);
	event->extended_description = _tmp11_;
	__g_slist_free__dvb_event_audio_component_unref0_0 (event->audio_components);
	event->audio_components = NULL;
	__g_slist_free__dvb_event_video_component_unref0_0 (event->video_components);
	event->video_components = NULL;
	__g_slist_free__dvb_event_teletext_component_unref0_0 (event->teletext_components);
	event->teletext_components = NULL;
	result = event;
	return result;
}


static gdouble dvb_database_sqlite_sqlite_epg_store_to_julian (DVBdatabasesqliteSqliteEPGStore* self, guint year, guint month, guint day, guint hour, guint minute, guint second, GError** error) {
	gdouble result = 0.0;
	gchar* _tmp0_ = NULL;
	gchar* datetime_str;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	gdouble val;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = g_strdup_printf ("%04u-%02u-%02u %02u:%02u:%02u", year, month, day, hour, minute, second);
	datetime_str = _tmp0_;
	_tmp1_ = g_strdup (datetime_str);
	_tmp2_ = sqlite3_bind_text (self->priv->to_julian_statement, 1, _tmp1_, -1, g_free);
	if (_tmp2_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (datetime_str);
				return 0.0;
			} else {
				_g_free0 (datetime_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0.0;
			}
		}
		result = (gdouble) 0;
		_g_free0 (datetime_str);
		return result;
	}
	_tmp3_ = sqlite3_step (self->priv->to_julian_statement);
	if (_tmp3_ != SQLITE_ROW) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (datetime_str);
				return 0.0;
			} else {
				_g_free0 (datetime_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0.0;
			}
		}
		result = (gdouble) 0;
		_g_free0 (datetime_str);
		return result;
	}
	_tmp4_ = sqlite3_column_double (self->priv->to_julian_statement, 0);
	val = _tmp4_;
	sqlite3_reset (self->priv->to_julian_statement);
	result = val;
	_g_free0 (datetime_str);
	return result;
}


static void dvb_database_sqlite_sqlite_epg_store_class_init (DVBdatabasesqliteSqliteEPGStoreClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_database_sqlite_sqlite_epg_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBdatabasesqliteSqliteEPGStorePrivate));
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->on_open = dvb_database_sqlite_sqlite_epg_store_real_on_open;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->create = dvb_database_sqlite_sqlite_epg_store_real_create;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->upgrade = dvb_database_sqlite_sqlite_epg_store_real_upgrade;
	G_OBJECT_CLASS (klass)->finalize = dvb_database_sqlite_sqlite_epg_store_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_database_sqlite_sqlite_epg_store_log = _tmp1_;
}


static void dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_interface_init (DVBdatabaseEPGStoreIface * iface) {
	dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_or_update_event = (gboolean (*)(DVBdatabaseEPGStore* ,DVBEvent* ,guint ,guint ,GError**)) dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event;
	iface->get_event = (DVBEvent* (*)(DVBdatabaseEPGStore* ,guint ,guint ,guint ,GError**)) dvb_database_sqlite_sqlite_epg_store_real_get_event;
	iface->remove_event = (gboolean (*)(DVBdatabaseEPGStore* ,guint ,guint ,guint ,GError**)) dvb_database_sqlite_sqlite_epg_store_real_remove_event;
	iface->remove_events_older_than = (gboolean (*)(DVBdatabaseEPGStore* ,DVBEvent* ,guint ,guint ,GError**)) dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than;
	iface->contains_event = (gboolean (*)(DVBdatabaseEPGStore* ,DVBEvent* ,guint ,guint ,GError**)) dvb_database_sqlite_sqlite_epg_store_real_contains_event;
	iface->get_events = (GeeList* (*)(DVBdatabaseEPGStore* ,guint ,guint ,GError**)) dvb_database_sqlite_sqlite_epg_store_real_get_events;
	iface->remove_events_of_group = (gboolean (*)(DVBdatabaseEPGStore* ,guint ,GError**)) dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group;
}


static void dvb_database_sqlite_sqlite_epg_store_instance_init (DVBdatabasesqliteSqliteEPGStore * self) {
	self->priv = DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_PRIVATE (self);
}


static void dvb_database_sqlite_sqlite_epg_store_finalize (GObject* obj) {
	DVBdatabasesqliteSqliteEPGStore * self;
	self = DVB_DATABASE_SQLITE_SQLITE_EPG_STORE (obj);
	_sqlite3_finalize0 (self->priv->to_julian_statement);
	_sqlite3_finalize0 (self->priv->insert_event_statement);
	_sqlite3_finalize0 (self->priv->update_event_statement);
	_sqlite3_finalize0 (self->priv->delete_event_statement);
	_sqlite3_finalize0 (self->priv->has_event_statement);
	_sqlite3_finalize0 (self->priv->select_event_statement);
	_sqlite3_finalize0 (self->priv->delete_events_group);
	_sqlite3_finalize0 (self->priv->delete_expired_events);
	G_OBJECT_CLASS (dvb_database_sqlite_sqlite_epg_store_parent_class)->finalize (obj);
}


GType dvb_database_sqlite_sqlite_epg_store_get_type (void) {
	static volatile gsize dvb_database_sqlite_sqlite_epg_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_database_sqlite_sqlite_epg_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBdatabasesqliteSqliteEPGStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_database_sqlite_sqlite_epg_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBdatabasesqliteSqliteEPGStore), 0, (GInstanceInitFunc) dvb_database_sqlite_sqlite_epg_store_instance_init, NULL };
		static const GInterfaceInfo dvb_database_epg_store_info = { (GInterfaceInitFunc) dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_database_sqlite_sqlite_epg_store_type_id;
		dvb_database_sqlite_sqlite_epg_store_type_id = g_type_register_static (DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, "DVBdatabasesqliteSqliteEPGStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_database_sqlite_sqlite_epg_store_type_id, DVB_DATABASE_TYPE_EPG_STORE, &dvb_database_epg_store_info);
		g_once_init_leave (&dvb_database_sqlite_sqlite_epg_store_type_id__volatile, dvb_database_sqlite_sqlite_epg_store_type_id);
	}
	return dvb_database_sqlite_sqlite_epg_store_type_id__volatile;
}



