/* Timer.c generated by valac 0.14.0, the Vala compiler
 * generated from Timer.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;
typedef struct _DVBTimerPrivate DVBTimerPrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_OVERLAP_TYPE (dvb_overlap_type_get_type ())

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

struct _DVBTimer {
	GObject parent_instance;
	DVBTimerPrivate * priv;
};

struct _DVBTimerClass {
	GObjectClass parent_class;
};

struct _DVBTimerPrivate {
	guint32 _Id;
	DVBChannel* _Channel;
	guint _Duration;
	GstElement* _sink;
	guint _EventID;
	struct tm starttime;
};

typedef enum  {
	DVB_OVERLAP_TYPE_UNKNOWN,
	DVB_OVERLAP_TYPE_NONE,
	DVB_OVERLAP_TYPE_PARTIAL,
	DVB_OVERLAP_TYPE_COMPLETE
} DVBOverlapType;

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_timer_parent_class = NULL;

GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
#define DVB_TIMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_TIMER, DVBTimerPrivate))
enum  {
	DVB_TIMER_DUMMY_PROPERTY,
	DVB_TIMER_ID,
	DVB_TIMER_CHANNEL,
	DVB_TIMER_DURATION,
	DVB_TIMER_SINK,
	DVB_TIMER_EVENT_ID
};
DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration);
void dvb_timer_set_EventID (DVBTimer* self, guint value);
void dvb_timer_set_Duration (DVBTimer* self, guint value);
void dvb_timer_set_start_time (DVBTimer* self, gint year, gint month, gint day, gint hour, gint minute);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
static void dvb_timer_update_epg_event (DVBTimer* self);
gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2);
static time_t dvb_timer_get_start_time_timestamp (DVBTimer* self);
DVBChannel* dvb_timer_get_Channel (DVBTimer* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
static time_t dvb_timer_get_end_time_timestamp (DVBTimer* self);
GType dvb_overlap_type_get_type (void) G_GNUC_CONST;
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
static DVBOverlapType dvb_timer_get_overlap (time_t this_start, time_t this_end, time_t other_start, time_t other_end);
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
void dvb_timer_add_to_start_time (DVBTimer* self, gint minutes);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
void dvb_timer_get_start_time_time (DVBTimer* self, struct tm* result);
guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1);
gboolean dvb_timer_is_start_due (DVBTimer* self);
gboolean dvb_timer_has_expired (DVBTimer* self);
gboolean dvb_timer_is_end_due (DVBTimer* self);
gchar* dvb_timer_to_string (DVBTimer* self);
guint dvb_channel_get_Sid (DVBChannel* self);
guint dvb_timer_get_Duration (DVBTimer* self);
GType dvb_schedule_get_type (void) G_GNUC_CONST;
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
guint32 dvb_timer_get_Id (DVBTimer* self);
static void dvb_timer_set_Id (DVBTimer* self, guint32 value);
static void dvb_timer_set_Channel (DVBTimer* self, DVBChannel* value);
GstElement* dvb_timer_get_sink (DVBTimer* self);
void dvb_timer_set_sink (DVBTimer* self, GstElement* value);
guint dvb_timer_get_EventID (DVBTimer* self);
static void dvb_timer_finalize (GObject* obj);
static void _vala_dvb_timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBTimer* dvb_timer_construct (GType object_type, guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration) {
	DVBTimer * self = NULL;
	guint32 _tmp0_;
	DVBChannel* _tmp1_;
	guint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (channel != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = channel;
	self = (DVBTimer*) g_object_new (object_type, "Id", _tmp0_, "Channel", _tmp1_, NULL);
	dvb_timer_set_EventID (self, (guint) 0);
	_tmp2_ = duration;
	dvb_timer_set_Duration (self, _tmp2_);
	_tmp3_ = year;
	_tmp4_ = month;
	_tmp5_ = day;
	_tmp6_ = hour;
	_tmp7_ = minute;
	dvb_timer_set_start_time (self, _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
	return self;
}


DVBTimer* dvb_timer_new (guint32 id, DVBChannel* channel, gint year, gint month, gint day, gint hour, gint minute, guint duration) {
	return dvb_timer_construct (DVB_TYPE_TIMER, id, channel, year, month, day, hour, minute, duration);
}


void dvb_timer_set_start_time (DVBTimer* self, gint year, gint month, gint day, gint hour, gint minute) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	struct tm _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = year;
	_tmp1_ = month;
	_tmp2_ = day;
	_tmp3_ = hour;
	_tmp4_ = minute;
	dvb_utils_create_time (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, 0, &_tmp5_);
	self->priv->starttime = _tmp5_;
	dvb_timer_update_epg_event (self);
}


/**
         * Whether the timer conflicts with the other one
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2) {
	gboolean result = FALSE;
	time_t _tmp0_ = 0;
	time_t this_start;
	DVBTimer* _tmp1_;
	time_t _tmp2_ = 0;
	time_t other_start;
	DVBChannel* _tmp3_;
	DVBChannel* _tmp4_;
	DVBChannel* t1_c;
	DVBTimer* _tmp5_;
	DVBChannel* _tmp6_;
	DVBChannel* _tmp7_;
	DVBChannel* t2_c;
	DVBChannel* _tmp8_;
	DVBChannel* _tmp9_;
	gboolean _tmp10_ = FALSE;
	time_t _tmp11_;
	time_t _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t2 != NULL, FALSE);
	_tmp0_ = dvb_timer_get_start_time_timestamp (self);
	this_start = _tmp0_;
	_tmp1_ = t2;
	_tmp2_ = dvb_timer_get_start_time_timestamp (_tmp1_);
	other_start = _tmp2_;
	_tmp3_ = self->priv->_Channel;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	t1_c = _tmp4_;
	_tmp5_ = t2;
	_tmp6_ = _tmp5_->priv->_Channel;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	t2_c = _tmp7_;
	_tmp8_ = t1_c;
	_tmp9_ = t2_c;
	_tmp10_ = dvb_channel_on_same_transport_stream (_tmp8_, _tmp9_);
	if (_tmp10_) {
		result = FALSE;
		_g_object_unref0 (t2_c);
		_g_object_unref0 (t1_c);
		return result;
	}
	_tmp11_ = this_start;
	_tmp12_ = other_start;
	if (_tmp11_ <= _tmp12_) {
		time_t _tmp13_ = 0;
		time_t this_end;
		time_t _tmp14_;
		time_t _tmp15_;
		_tmp13_ = dvb_timer_get_end_time_timestamp (self);
		this_end = _tmp13_;
		_tmp14_ = this_end;
		_tmp15_ = other_start;
		result = _tmp14_ > _tmp15_;
		_g_object_unref0 (t2_c);
		_g_object_unref0 (t1_c);
		return result;
	} else {
		DVBTimer* _tmp16_;
		time_t _tmp17_ = 0;
		time_t other_end;
		time_t _tmp18_;
		time_t _tmp19_;
		_tmp16_ = t2;
		_tmp17_ = dvb_timer_get_end_time_timestamp (_tmp16_);
		other_end = _tmp17_;
		_tmp18_ = other_end;
		_tmp19_ = this_start;
		result = _tmp18_ > _tmp19_;
		_g_object_unref0 (t2_c);
		_g_object_unref0 (t1_c);
		return result;
	}
	_g_object_unref0 (t2_c);
	_g_object_unref0 (t1_c);
}


/**
         * @duration: in minutes
         * @returns: The overlap between the timer and the given time range.
         * The timer is the reference, i.e. if the time range is completely
         * contained in the timer OverlapType.COMPLETE is returned.
         *
         * The given time range must be in local time.
         */
DVBOverlapType dvb_timer_get_overlap_local (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	DVBOverlapType result = 0;
	time_t _tmp0_ = 0;
	time_t this_start;
	time_t _tmp1_ = 0;
	time_t this_end;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	struct tm _tmp7_ = {0};
	struct tm other_time;
	time_t _tmp8_ = 0;
	time_t other_start;
	gint _tmp9_;
	guint _tmp10_;
	time_t _tmp11_ = 0;
	time_t other_end;
	DVBOverlapType _tmp12_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = dvb_timer_get_start_time_timestamp (self);
	this_start = _tmp0_;
	_tmp1_ = dvb_timer_get_end_time_timestamp (self);
	this_end = _tmp1_;
	_tmp2_ = start_year;
	_tmp3_ = start_month;
	_tmp4_ = start_day;
	_tmp5_ = start_hour;
	_tmp6_ = start_minute;
	dvb_utils_create_time ((gint) _tmp2_, (gint) _tmp3_, (gint) _tmp4_, (gint) _tmp5_, (gint) _tmp6_, 0, &_tmp7_);
	other_time = _tmp7_;
	_tmp8_ = mktime (&other_time);
	other_start = _tmp8_;
	_tmp9_ = other_time.tm_min;
	_tmp10_ = duration;
	other_time.tm_min = _tmp9_ + ((gint) _tmp10_);
	_tmp11_ = mktime (&other_time);
	other_end = _tmp11_;
	_tmp12_ = dvb_timer_get_overlap (this_start, this_end, other_start, other_end);
	result = _tmp12_;
	return result;
}


/**
         * Same as get_overlap_local but the given time range is UTC time.
         */
DVBOverlapType dvb_timer_get_overlap_utc (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	DVBOverlapType result = 0;
	time_t _tmp0_ = 0;
	time_t this_start;
	time_t _tmp1_ = 0;
	time_t this_end;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	struct tm _tmp7_ = {0};
	struct tm other_time;
	struct tm _tmp8_;
	time_t _tmp9_ = 0;
	time_t other_start;
	gint _tmp10_;
	guint _tmp11_;
	struct tm _tmp12_;
	time_t _tmp13_ = 0;
	time_t other_end;
	DVBOverlapType _tmp14_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = dvb_timer_get_start_time_timestamp (self);
	this_start = _tmp0_;
	_tmp1_ = dvb_timer_get_end_time_timestamp (self);
	this_end = _tmp1_;
	_tmp2_ = start_year;
	_tmp3_ = start_month;
	_tmp4_ = start_day;
	_tmp5_ = start_hour;
	_tmp6_ = start_minute;
	dvb_utils_create_time ((gint) _tmp2_, (gint) _tmp3_, (gint) _tmp4_, (gint) _tmp5_, (gint) _tmp6_, 0, &_tmp7_);
	other_time = _tmp7_;
	_tmp8_ = other_time;
	_tmp9_ = timegm (&_tmp8_);
	other_start = _tmp9_;
	_tmp10_ = other_time.tm_min;
	_tmp11_ = duration;
	other_time.tm_min = _tmp10_ + ((gint) _tmp11_);
	_tmp12_ = other_time;
	_tmp13_ = timegm (&_tmp12_);
	other_end = _tmp13_;
	_tmp14_ = dvb_timer_get_overlap (this_start, this_end, other_start, other_end);
	result = _tmp14_;
	return result;
}


static DVBOverlapType dvb_timer_get_overlap (time_t this_start, time_t this_end, time_t other_start, time_t other_end) {
	DVBOverlapType result = 0;
	time_t _tmp0_;
	time_t _tmp1_;
	_tmp0_ = this_start;
	_tmp1_ = other_start;
	if (_tmp0_ <= _tmp1_) {
		time_t _tmp2_;
		time_t _tmp3_;
		_tmp2_ = this_end;
		_tmp3_ = other_start;
		if (_tmp2_ <= _tmp3_) {
			result = DVB_OVERLAP_TYPE_NONE;
			return result;
		} else {
			time_t _tmp4_;
			time_t _tmp5_;
			_tmp4_ = this_end;
			_tmp5_ = other_end;
			if (_tmp4_ >= _tmp5_) {
				result = DVB_OVERLAP_TYPE_COMPLETE;
				return result;
			} else {
				result = DVB_OVERLAP_TYPE_PARTIAL;
				return result;
			}
		}
	} else {
		time_t _tmp6_;
		time_t _tmp7_;
		_tmp6_ = this_end;
		_tmp7_ = other_end;
		if (_tmp6_ <= _tmp7_) {
			result = DVB_OVERLAP_TYPE_PARTIAL;
			return result;
		} else {
			time_t _tmp8_;
			time_t _tmp9_;
			_tmp8_ = this_start;
			_tmp9_ = other_end;
			if (_tmp8_ < _tmp9_) {
				result = DVB_OVERLAP_TYPE_PARTIAL;
				return result;
			} else {
				result = DVB_OVERLAP_TYPE_NONE;
				return result;
			}
		}
	}
}


/**
         * Add the specified amount of minutes to the starting time
         */
void dvb_timer_add_to_start_time (DVBTimer* self, gint minutes) {
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->starttime.tm_min;
	_tmp1_ = minutes;
	self->priv->starttime.tm_min = _tmp0_ + _tmp1_;
	mktime (&self->priv->starttime);
}


guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1) {
	guint* result = NULL;
	struct tm _tmp0_;
	gint _tmp1_;
	struct tm _tmp2_;
	gint _tmp3_;
	struct tm _tmp4_;
	gint _tmp5_;
	struct tm _tmp6_;
	gint _tmp7_;
	struct tm _tmp8_;
	gint _tmp9_;
	guint* _tmp10_ = NULL;
	guint* start;
	gint start_length1;
	gint _start_size_;
	guint* _tmp11_;
	gint _tmp11__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->starttime;
	_tmp1_ = _tmp0_.tm_year;
	_tmp2_ = self->priv->starttime;
	_tmp3_ = _tmp2_.tm_mon;
	_tmp4_ = self->priv->starttime;
	_tmp5_ = _tmp4_.tm_mday;
	_tmp6_ = self->priv->starttime;
	_tmp7_ = _tmp6_.tm_hour;
	_tmp8_ = self->priv->starttime;
	_tmp9_ = _tmp8_.tm_min;
	_tmp10_ = g_new0 (guint, 5);
	_tmp10_[0] = (guint) (_tmp1_ + 1900);
	_tmp10_[1] = (guint) (_tmp3_ + 1);
	_tmp10_[2] = (guint) _tmp5_;
	_tmp10_[3] = (guint) _tmp7_;
	_tmp10_[4] = (guint) _tmp9_;
	start = _tmp10_;
	start_length1 = 5;
	_start_size_ = start_length1;
	_tmp11_ = start;
	_tmp11__length1 = start_length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	return result;
}


void dvb_timer_get_start_time_time (DVBTimer* self, struct tm* result) {
	struct tm _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->starttime;
	*result = _tmp0_;
	return;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1) {
	guint* result = NULL;
	time_t _tmp0_ = 0;
	struct tm _tmp1_ = {0};
	struct tm l;
	struct tm _tmp2_;
	gint _tmp3_;
	struct tm _tmp4_;
	gint _tmp5_;
	struct tm _tmp6_;
	gint _tmp7_;
	struct tm _tmp8_;
	gint _tmp9_;
	struct tm _tmp10_;
	gint _tmp11_;
	guint* _tmp12_ = NULL;
	guint* _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_timer_get_end_time_timestamp (self);
	g_time_local (_tmp0_, &_tmp1_);
	l = _tmp1_;
	_tmp2_ = l;
	_tmp3_ = _tmp2_.tm_year;
	_tmp4_ = l;
	_tmp5_ = _tmp4_.tm_mon;
	_tmp6_ = l;
	_tmp7_ = _tmp6_.tm_mday;
	_tmp8_ = l;
	_tmp9_ = _tmp8_.tm_hour;
	_tmp10_ = l;
	_tmp11_ = _tmp10_.tm_min;
	_tmp12_ = g_new0 (guint, 5);
	_tmp12_[0] = (guint) (_tmp3_ + 1900);
	_tmp12_[1] = (guint) (_tmp5_ + 1);
	_tmp12_[2] = (guint) _tmp7_;
	_tmp12_[3] = (guint) _tmp9_;
	_tmp12_[4] = (guint) _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 5;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	return result;
}


/**
         * Whether the start time of the timer is after the current local time
         * and the timer hasn't expired, yet.
         */
gboolean dvb_timer_is_start_due (DVBTimer* self) {
	gboolean result = FALSE;
	time_t _tmp0_;
	time_t localtime;
	gboolean _tmp1_ = FALSE;
	time_t _tmp2_;
	time_t _tmp3_ = 0;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = time (NULL);
	localtime = _tmp0_;
	_tmp2_ = localtime;
	_tmp3_ = mktime (&self->priv->starttime);
	if ((_tmp2_ - _tmp3_) >= ((time_t) 0)) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = dvb_timer_has_expired (self);
		_tmp1_ = !_tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	result = _tmp5_;
	return result;
}


/**
         * Whether the end time of the timer equals the current local time
         */
gboolean dvb_timer_is_end_due (DVBTimer* self) {
	gboolean result = FALSE;
	time_t _tmp0_;
	struct tm _tmp1_ = {0};
	struct tm localtime;
	time_t _tmp2_ = 0;
	struct tm _tmp3_ = {0};
	struct tm endtime;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	struct tm _tmp8_;
	gint _tmp9_;
	struct tm _tmp10_;
	gint _tmp11_;
	gboolean _tmp16_;
	gboolean _tmp21_;
	gboolean _tmp26_;
	gboolean _tmp31_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = time (NULL);
	g_time_local (_tmp0_, &_tmp1_);
	localtime = _tmp1_;
	_tmp2_ = dvb_timer_get_end_time_timestamp (self);
	g_time_local (_tmp2_, &_tmp3_);
	endtime = _tmp3_;
	_tmp8_ = endtime;
	_tmp9_ = _tmp8_.tm_year;
	_tmp10_ = localtime;
	_tmp11_ = _tmp10_.tm_year;
	if (_tmp9_ == _tmp11_) {
		struct tm _tmp12_;
		gint _tmp13_;
		struct tm _tmp14_;
		gint _tmp15_;
		_tmp12_ = endtime;
		_tmp13_ = _tmp12_.tm_mon;
		_tmp14_ = localtime;
		_tmp15_ = _tmp14_.tm_mon;
		_tmp7_ = _tmp13_ == _tmp15_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp16_ = _tmp7_;
	if (_tmp16_) {
		struct tm _tmp17_;
		gint _tmp18_;
		struct tm _tmp19_;
		gint _tmp20_;
		_tmp17_ = endtime;
		_tmp18_ = _tmp17_.tm_mday;
		_tmp19_ = localtime;
		_tmp20_ = _tmp19_.tm_mday;
		_tmp6_ = _tmp18_ == _tmp20_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp21_ = _tmp6_;
	if (_tmp21_) {
		struct tm _tmp22_;
		gint _tmp23_;
		struct tm _tmp24_;
		gint _tmp25_;
		_tmp22_ = endtime;
		_tmp23_ = _tmp22_.tm_hour;
		_tmp24_ = localtime;
		_tmp25_ = _tmp24_.tm_hour;
		_tmp5_ = _tmp23_ == _tmp25_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp26_ = _tmp5_;
	if (_tmp26_) {
		struct tm _tmp27_;
		gint _tmp28_;
		struct tm _tmp29_;
		gint _tmp30_;
		_tmp27_ = endtime;
		_tmp28_ = _tmp27_.tm_min;
		_tmp29_ = localtime;
		_tmp30_ = _tmp29_.tm_min;
		_tmp4_ = _tmp28_ == _tmp30_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp31_ = _tmp4_;
	result = _tmp31_;
	return result;
}


/**
         * Whether the timer ends in the past
         */
gboolean dvb_timer_has_expired (DVBTimer* self) {
	gboolean result = FALSE;
	time_t _tmp0_;
	time_t current_time;
	time_t _tmp1_ = 0;
	time_t end_time;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = time (NULL);
	current_time = _tmp0_;
	_tmp1_ = dvb_timer_get_end_time_timestamp (self);
	end_time = _tmp1_;
	result = end_time < current_time;
	return result;
}


gchar* dvb_timer_to_string (DVBTimer* self) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	guint* _tmp1_ = NULL;
	guint* start;
	gint start_length1;
	gint _start_size_;
	DVBChannel* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = dvb_timer_get_start_time (self, &_tmp0_);
	start = _tmp1_;
	start_length1 = _tmp0_;
	_start_size_ = start_length1;
	_tmp2_ = self->priv->_Channel;
	_tmp3_ = dvb_channel_get_Sid (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = start[0];
	_tmp6_ = start[1];
	_tmp7_ = start[2];
	_tmp8_ = start[3];
	_tmp9_ = start[4];
	_tmp10_ = self->priv->_Duration;
	_tmp11_ = g_strdup_printf ("channel: %u, start: %04u-%02u-%02u %02u:%02u, duration: %u", _tmp4_, _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
	result = _tmp11_;
	start = (g_free (start), NULL);
	return result;
}


/**
         * Check if we can find an EPG event belonging to this recording
         */
static void dvb_timer_update_epg_event (DVBTimer* self) {
	DVBChannel* _tmp0_;
	DVBSchedule* _tmp1_;
	DVBSchedule* _tmp2_;
	DVBSchedule* _tmp3_;
	DVBSchedule* schedule;
	DVBSchedule* _tmp4_;
	struct tm _tmp5_ = {0};
	guint _tmp6_;
	DVBEvent* _tmp7_ = NULL;
	DVBEvent* event;
	DVBEvent* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_Channel;
	_tmp1_ = dvb_channel_get_Schedule (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	schedule = _tmp3_;
	_tmp4_ = schedule;
	dvb_timer_get_start_time_time (self, &_tmp5_);
	_tmp6_ = self->priv->_Duration;
	_tmp7_ = dvb_schedule_get_event_around (_tmp4_, &_tmp5_, _tmp6_);
	event = _tmp7_;
	_tmp8_ = event;
	if (_tmp8_ == NULL) {
		dvb_timer_set_EventID (self, (guint) 0);
	} else {
		DVBEvent* _tmp9_;
		guint _tmp10_;
		_tmp9_ = event;
		_tmp10_ = _tmp9_->id;
		dvb_timer_set_EventID (self, _tmp10_);
	}
	_dvb_event_unref0 (event);
	_g_object_unref0 (schedule);
}


static time_t dvb_timer_get_end_time_timestamp (DVBTimer* self) {
	time_t result = 0;
	struct tm _tmp0_;
	gint _tmp1_;
	struct tm _tmp2_;
	gint _tmp3_;
	struct tm _tmp4_;
	gint _tmp5_;
	struct tm _tmp6_;
	gint _tmp7_;
	struct tm _tmp8_;
	gint _tmp9_;
	struct tm _tmp10_ = {0};
	struct tm t;
	gint _tmp11_;
	guint _tmp12_;
	time_t _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->starttime;
	_tmp1_ = _tmp0_.tm_year;
	_tmp2_ = self->priv->starttime;
	_tmp3_ = _tmp2_.tm_mon;
	_tmp4_ = self->priv->starttime;
	_tmp5_ = _tmp4_.tm_mday;
	_tmp6_ = self->priv->starttime;
	_tmp7_ = _tmp6_.tm_hour;
	_tmp8_ = self->priv->starttime;
	_tmp9_ = _tmp8_.tm_min;
	dvb_utils_create_time (_tmp1_ + 1900, _tmp3_ + 1, _tmp5_, _tmp7_, _tmp9_, 0, &_tmp10_);
	t = _tmp10_;
	_tmp11_ = t.tm_min;
	_tmp12_ = self->priv->_Duration;
	t.tm_min = _tmp11_ + ((gint) _tmp12_);
	_tmp13_ = mktime (&t);
	result = _tmp13_;
	return result;
}


static time_t dvb_timer_get_start_time_timestamp (DVBTimer* self) {
	time_t result = 0;
	struct tm _tmp0_ = {0};
	struct tm t;
	time_t _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	dvb_timer_get_start_time_time (self, &_tmp0_);
	t = _tmp0_;
	_tmp1_ = mktime (&t);
	result = _tmp1_;
	return result;
}


guint32 dvb_timer_get_Id (DVBTimer* self) {
	guint32 result;
	guint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Id;
	result = _tmp0_;
	return result;
}


static void dvb_timer_set_Id (DVBTimer* self, guint32 value) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Id = _tmp0_;
	g_object_notify ((GObject *) self, "Id");
}


DVBChannel* dvb_timer_get_Channel (DVBTimer* self) {
	DVBChannel* result;
	DVBChannel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Channel;
	result = _tmp0_;
	return result;
}


static void dvb_timer_set_Channel (DVBTimer* self, DVBChannel* value) {
	DVBChannel* _tmp0_;
	DVBChannel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_Channel);
	self->priv->_Channel = _tmp1_;
	g_object_notify ((GObject *) self, "Channel");
}


guint dvb_timer_get_Duration (DVBTimer* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Duration;
	result = _tmp0_;
	return result;
}


void dvb_timer_set_Duration (DVBTimer* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Duration = _tmp0_;
	g_object_notify ((GObject *) self, "Duration");
}


GstElement* dvb_timer_get_sink (DVBTimer* self) {
	GstElement* result;
	GstElement* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sink;
	result = _tmp0_;
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


void dvb_timer_set_sink (DVBTimer* self, GstElement* value) {
	GstElement* _tmp0_;
	GstElement* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _gst_object_ref0 (_tmp0_);
	_gst_object_unref0 (self->priv->_sink);
	self->priv->_sink = _tmp1_;
	g_object_notify ((GObject *) self, "sink");
}


guint dvb_timer_get_EventID (DVBTimer* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_EventID;
	result = _tmp0_;
	return result;
}


void dvb_timer_set_EventID (DVBTimer* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_EventID = _tmp0_;
	g_object_notify ((GObject *) self, "EventID");
}


static void dvb_timer_class_init (DVBTimerClass * klass) {
	dvb_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBTimerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_timer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_CHANNEL, g_param_spec_object ("Channel", "Channel", "Channel", DVB_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_DURATION, g_param_spec_uint ("Duration", "Duration", "Duration", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_SINK, g_param_spec_object ("sink", "sink", "sink", GST_TYPE_ELEMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TIMER_EVENT_ID, g_param_spec_uint ("EventID", "EventID", "EventID", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_timer_instance_init (DVBTimer * self) {
	self->priv = DVB_TIMER_GET_PRIVATE (self);
}


static void dvb_timer_finalize (GObject* obj) {
	DVBTimer * self;
	self = DVB_TIMER (obj);
	_g_object_unref0 (self->priv->_Channel);
	_gst_object_unref0 (self->priv->_sink);
	G_OBJECT_CLASS (dvb_timer_parent_class)->finalize (obj);
}


/**
     * This class represents an event that should be recorded
     */
GType dvb_timer_get_type (void) {
	static volatile gsize dvb_timer_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_timer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTimer), 0, (GInstanceInitFunc) dvb_timer_instance_init, NULL };
		GType dvb_timer_type_id;
		dvb_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBTimer", &g_define_type_info, 0);
		g_once_init_leave (&dvb_timer_type_id__volatile, dvb_timer_type_id);
	}
	return dvb_timer_type_id__volatile;
}


static void _vala_dvb_timer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBTimer * self;
	self = DVB_TIMER (object);
	switch (property_id) {
		case DVB_TIMER_ID:
		g_value_set_uint (value, dvb_timer_get_Id (self));
		break;
		case DVB_TIMER_CHANNEL:
		g_value_set_object (value, dvb_timer_get_Channel (self));
		break;
		case DVB_TIMER_DURATION:
		g_value_set_uint (value, dvb_timer_get_Duration (self));
		break;
		case DVB_TIMER_SINK:
		g_value_set_object (value, dvb_timer_get_sink (self));
		break;
		case DVB_TIMER_EVENT_ID:
		g_value_set_uint (value, dvb_timer_get_EventID (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_timer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBTimer * self;
	self = DVB_TIMER (object);
	switch (property_id) {
		case DVB_TIMER_ID:
		dvb_timer_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_CHANNEL:
		dvb_timer_set_Channel (self, g_value_get_object (value));
		break;
		case DVB_TIMER_DURATION:
		dvb_timer_set_Duration (self, g_value_get_uint (value));
		break;
		case DVB_TIMER_SINK:
		dvb_timer_set_sink (self, g_value_get_object (value));
		break;
		case DVB_TIMER_EVENT_ID:
		dvb_timer_set_EventID (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



