/* RecordingsStore.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from RecordingsStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <time.h>


#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;

#define DVB_TYPE_ID_BUS_RECORDINGS_STORE_PROXY (dvb_id_bus_recordings_store_proxy_get_type ())

#define DVB_TYPE_RECORDING_INFO (dvb_recording_info_get_type ())
typedef struct _DVBRecordingInfo DVBRecordingInfo;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;
typedef struct _DVBRecordingsStorePrivate DVBRecordingsStorePrivate;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_CHANGE_TYPE (dvb_change_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_IO_TYPE_RECORDING_READER (dvb_io_recording_reader_get_type ())
#define DVB_IO_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader))
#define DVB_IO_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))
#define DVB_IO_IS_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_IS_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_RECORDING_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))

typedef struct _DVBioRecordingReader DVBioRecordingReader;
typedef struct _DVBioRecordingReaderClass DVBioRecordingReaderClass;

struct _DVBRecordingInfo {
	guint32 id;
	gchar* name;
	gchar* description;
	gint64 length;
	gint64 start_timestamp;
	gchar* channel;
	gchar* location;
};

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
	gboolean (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error);
	gboolean (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
	gboolean (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
};

struct _DVBRecordingsStore {
	GObject parent_instance;
	DVBRecordingsStorePrivate * priv;
};

struct _DVBRecordingsStoreClass {
	GObjectClass parent_class;
};

struct _DVBRecordingsStorePrivate {
	GeeHashMap* recordings;
	GStaticRecMutex __lock_recordings;
	guint32 last_id;
};

typedef enum  {
	DVB_CHANGE_TYPE_ADDED = 0,
	DVB_CHANGE_TYPE_DELETED = 1,
	DVB_CHANGE_TYPE_UPDATED = 2
} DVBChangeType;


static gpointer dvb_recordings_store_parent_class = NULL;
static DVBLoggingLogger* dvb_recordings_store_log;
static DVBLoggingLogger* dvb_recordings_store_log = NULL;
static DVBRecordingsStore* dvb_recordings_store_instance;
static DVBRecordingsStore* dvb_recordings_store_instance = NULL;
static GRecMutex dvb_recordings_store_instance_mutex;
static GRecMutex dvb_recordings_store_instance_mutex = {0};
static DVBIDBusRecordingsStoreIface* dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = NULL;

GType dvb_id_bus_recordings_store_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_recordings_store_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_recording_info_get_type (void) G_GNUC_CONST;
DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self);
void dvb_recording_info_free (DVBRecordingInfo* self);
void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest);
void dvb_recording_info_destroy (DVBRecordingInfo* self);
GType dvb_id_bus_recordings_store_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_RECORDINGS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStorePrivate))
enum  {
	DVB_RECORDINGS_STORE_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
DVBRecordingsStore* dvb_recordings_store_new (void);
DVBRecordingsStore* dvb_recordings_store_construct (GType object_type);
void dvb_recordings_store_shutdown (void);
void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id);
gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec);
guint32 dvb_recording_get_Id (DVBRecording* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_change_type_get_type (void) G_GNUC_CONST;
gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec);
void dvb_recording_monitor_recording (DVBRecording* self);
void dvb_recordings_store_remove (DVBRecordingsStore* self, DVBRecording* rec);
guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self);
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1, GError** error);
static gboolean dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** location, GError** error);
GFile* dvb_recording_get_Location (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** name, GError** error);
const gchar* dvb_recording_get_Name (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** description, GError** error);
const gchar* dvb_recording_get_Description (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
static gboolean dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* timestamp, GError** error);
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
static gboolean dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* length, GError** error);
gint64 dvb_recording_get_Length (DVBRecording* self);
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id, GError** error);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
static gboolean dvb_recordings_store_real_GetChannelName (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** name, GError** error);
const gchar* dvb_recording_get_ChannelName (DVBRecording* self);
static gboolean dvb_recordings_store_real_GetAllInformations (DVBIDBusRecordingsStore* base, guint32 rec_id, DVBRecordingInfo* info, GError** error);
void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir);
DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore);
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore);
GType dvb_io_recording_reader_get_type (void) G_GNUC_CONST;
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self);
static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_recordings_store_finalize (GObject* obj);


DVBRecordingsStore* dvb_recordings_store_get_instance (void) {
	DVBRecordingsStore* result = NULL;
	DVBRecordingsStore* _tmp0_;
	DVBRecordingsStore* _tmp2_;
	g_rec_mutex_lock (&dvb_recordings_store_instance_mutex);
	_tmp0_ = dvb_recordings_store_instance;
	if (_tmp0_ == NULL) {
		DVBRecordingsStore* _tmp1_;
		_tmp1_ = dvb_recordings_store_new ();
		_g_object_unref0 (dvb_recordings_store_instance);
		dvb_recordings_store_instance = _tmp1_;
	}
	g_rec_mutex_unlock (&dvb_recordings_store_instance_mutex);
	_tmp2_ = dvb_recordings_store_instance;
	result = _tmp2_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_recordings_store_shutdown (void) {
	DVBRecordingsStore* _tmp0_;
	DVBRecordingsStore* _tmp1_;
	DVBRecordingsStore* rs;
	DVBRecordingsStore* _tmp2_;
	g_rec_mutex_lock (&dvb_recordings_store_instance_mutex);
	_tmp0_ = dvb_recordings_store_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	rs = _tmp1_;
	_tmp2_ = rs;
	if (_tmp2_ != NULL) {
		DVBRecordingsStore* _tmp3_;
		GeeHashMap* _tmp4_;
		_tmp3_ = rs;
		_tmp4_ = _tmp3_->priv->recordings;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp4_);
		_g_object_unref0 (dvb_recordings_store_instance);
		dvb_recordings_store_instance = NULL;
	}
	g_rec_mutex_unlock (&dvb_recordings_store_instance_mutex);
	_g_object_unref0 (rs);
}


void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			guint32 _tmp1_;
			guint32 _tmp2_;
			_tmp1_ = new_last_id;
			_tmp2_ = self->priv->last_id;
			if (_tmp1_ > _tmp2_) {
				guint32 _tmp3_;
				_tmp3_ = new_last_id;
				self->priv->last_id = _tmp3_;
			}
		}
		__finally135:
		{
			GeeHashMap* _tmp4_;
			_tmp4_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean dvb_recordings_store_add (DVBRecordingsStore* self, DVBRecording* rec) {
	gboolean result = FALSE;
	DVBRecording* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	guint32 id;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (rec != NULL, FALSE);
	_tmp0_ = rec;
	_tmp1_ = dvb_recording_get_Id (_tmp0_);
	_tmp2_ = _tmp1_;
	id = _tmp2_;
	{
		GeeHashMap* _tmp3_;
		_tmp3_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp4_;
			guint32 _tmp5_;
			gboolean _tmp6_ = FALSE;
			DVBRecording* _tmp10_;
			guint32 _tmp11_;
			guint32 _tmp12_;
			guint32 _tmp13_;
			GeeHashMap* _tmp17_;
			guint32 _tmp18_;
			DVBRecording* _tmp19_;
			guint32 _tmp20_;
			_tmp4_ = self->priv->recordings;
			_tmp5_ = id;
			_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
			if (_tmp6_) {
				DVBLoggingLogger* _tmp7_;
				guint32 _tmp8_;
				_tmp7_ = dvb_recordings_store_log;
				_tmp8_ = id;
				dvb_logging_logger_error (_tmp7_, "RecordingsStore.vala:73: Recording with id %u already available", (guint) _tmp8_);
				result = FALSE;
				{
					GeeHashMap* _tmp9_;
					_tmp9_ = self->priv->recordings;
					g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
				}
				return result;
			}
			_tmp10_ = rec;
			_tmp11_ = dvb_recording_get_Id (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->last_id;
			if (_tmp12_ > _tmp13_) {
				DVBRecording* _tmp14_;
				guint32 _tmp15_;
				guint32 _tmp16_;
				_tmp14_ = rec;
				_tmp15_ = dvb_recording_get_Id (_tmp14_);
				_tmp16_ = _tmp15_;
				self->priv->last_id = _tmp16_;
			}
			_tmp17_ = self->priv->recordings;
			_tmp18_ = id;
			_tmp19_ = rec;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, GUINT_TO_POINTER (_tmp18_), _tmp19_);
			_tmp20_ = id;
			g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", _tmp20_, (guint) DVB_CHANGE_TYPE_ADDED);
		}
		__finally136:
		{
			GeeHashMap* _tmp21_;
			_tmp21_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	return result;
}


gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec) {
	gboolean result = FALSE;
	DVBRecording* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (rec != NULL, FALSE);
	_tmp0_ = rec;
	_tmp1_ = dvb_recordings_store_add (self, _tmp0_);
	if (_tmp1_) {
		DVBRecording* _tmp2_;
		_tmp2_ = rec;
		dvb_recording_monitor_recording (_tmp2_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


void dvb_recordings_store_remove (DVBRecordingsStore* self, DVBRecording* rec) {
	DVBRecording* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	guint32 rec_id;
	GeeHashMap* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rec != NULL);
	_tmp0_ = rec;
	_tmp1_ = dvb_recording_get_Id (_tmp0_);
	_tmp2_ = _tmp1_;
	rec_id = _tmp2_;
	_tmp3_ = self->priv->recordings;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, GUINT_TO_POINTER (rec_id), NULL);
	g_signal_emit_by_name ((DVBIDBusRecordingsStore*) self, "changed", rec_id, (guint) DVB_CHANGE_TYPE_DELETED);
}


guint32 dvb_recordings_store_get_next_id (DVBRecordingsStore* self) {
	guint32 result = 0U;
	guint32 val = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			guint32 _tmp1_;
			guint32 _tmp2_;
			_tmp1_ = self->priv->last_id;
			self->priv->last_id = _tmp1_ + 1;
			_tmp2_ = self->priv->last_id;
			val = _tmp2_;
		}
		__finally137:
		{
			GeeHashMap* _tmp3_;
			_tmp3_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	result = val;
	return result;
}


/**
         * @returns: A list of ids for all recordings
         */
static guint32* dvb_recordings_store_real_GetRecordings (DVBIDBusRecordingsStore* base, int* result_length1, GError** error) {
	DVBRecordingsStore * self;
	guint32* result = NULL;
	guint32* ids = NULL;
	gint ids_length1 = 0;
	gint _ids_size_ = 0;
	guint32* _tmp21_;
	gint _tmp21__length1;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			guint32* _tmp4_ = NULL;
			gint i;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = gee_abstract_map_get_size ((GeeMap*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_new0 (guint32, _tmp3_);
			ids = (g_free (ids), NULL);
			ids = _tmp4_;
			ids_length1 = _tmp3_;
			_ids_size_ = ids_length1;
			i = 0;
			{
				GeeHashMap* _tmp5_;
				GeeSet* _tmp6_;
				GeeSet* _tmp7_;
				GeeSet* _tmp8_;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_;
				GeeIterator* _key_it;
				_tmp5_ = self->priv->recordings;
				_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_key_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_;
					gboolean _tmp12_ = FALSE;
					GeeIterator* _tmp13_;
					gpointer _tmp14_ = NULL;
					guint32 key;
					guint32* _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					guint32 _tmp17_;
					guint32 _tmp18_;
					gint _tmp19_;
					_tmp11_ = _key_it;
					_tmp12_ = gee_iterator_next (_tmp11_);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = _key_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					key = GPOINTER_TO_UINT (_tmp14_);
					_tmp15_ = ids;
					_tmp15__length1 = ids_length1;
					_tmp16_ = i;
					_tmp17_ = key;
					_tmp15_[_tmp16_] = _tmp17_;
					_tmp18_ = _tmp15_[_tmp16_];
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally138:
		{
			GeeHashMap* _tmp20_;
			_tmp20_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp21_ = ids;
	_tmp21__length1 = ids_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @location: The location of the recording on the filesystem
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetLocation (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** location, GError** error) {
	DVBRecordingsStore * self;
	gchar* _vala_location = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint32 _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* _tmp7_;
				GFile* _tmp8_;
				GFile* _tmp9_;
				gchar* _tmp10_ = NULL;
				_tmp4_ = self->priv->recordings;
				_tmp5_ = rec_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				_tmp7_ = (DVBRecording*) _tmp6_;
				_tmp8_ = dvb_recording_get_Location (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_file_get_uri (_tmp9_);
				_g_free0 (_vala_location);
				_vala_location = _tmp10_;
				_g_object_unref0 (_tmp7_);
				ret = TRUE;
			} else {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("");
				_g_free0 (_vala_location);
				_vala_location = _tmp11_;
			}
		}
		__finally139:
		{
			GeeHashMap* _tmp12_;
			_tmp12_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (location) {
		*location = _vala_location;
	} else {
		_g_free0 (_vala_location);
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @name: The name of the recording (e.g. the name of
         * a TV show)
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetName (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** name, GError** error) {
	DVBRecordingsStore * self;
	gchar* _vala_name = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint32 _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* val;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp4_ = self->priv->recordings;
				_tmp5_ = rec_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				_tmp7_ = (DVBRecording*) _tmp6_;
				_tmp8_ = dvb_recording_get_Name (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup (_tmp9_);
				_tmp11_ = _tmp10_;
				_g_object_unref0 (_tmp7_);
				val = _tmp11_;
				_tmp13_ = val;
				if (_tmp13_ == NULL) {
					_tmp12_ = "";
				} else {
					const gchar* _tmp14_;
					_tmp14_ = val;
					_tmp12_ = _tmp14_;
				}
				_tmp15_ = _tmp12_;
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_vala_name);
				_vala_name = _tmp16_;
				ret = TRUE;
				_g_free0 (val);
			} else {
				gchar* _tmp17_;
				_tmp17_ = g_strdup ("");
				_g_free0 (_vala_name);
				_vala_name = _tmp17_;
			}
		}
		__finally140:
		{
			GeeHashMap* _tmp18_;
			_tmp18_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @description: A short text describing the recorded item
         * (e.g. the description from EPG)
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetDescription (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** description, GError** error) {
	DVBRecordingsStore * self;
	gchar* _vala_description = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint32 _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* val;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp4_ = self->priv->recordings;
				_tmp5_ = rec_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				_tmp7_ = (DVBRecording*) _tmp6_;
				_tmp8_ = dvb_recording_get_Description (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup (_tmp9_);
				_tmp11_ = _tmp10_;
				_g_object_unref0 (_tmp7_);
				val = _tmp11_;
				_tmp13_ = val;
				if (_tmp13_ == NULL) {
					_tmp12_ = "";
				} else {
					const gchar* _tmp14_;
					_tmp14_ = val;
					_tmp12_ = _tmp14_;
				}
				_tmp15_ = _tmp12_;
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_vala_description);
				_vala_description = _tmp16_;
				ret = TRUE;
				_g_free0 (val);
			} else {
				gchar* _tmp17_;
				_tmp17_ = g_strdup ("");
				_g_free0 (_vala_description);
				_vala_description = _tmp17_;
			}
		}
		__finally141:
		{
			GeeHashMap* _tmp18_;
			_tmp18_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (description) {
		*description = _vala_description;
	} else {
		_g_free0 (_vala_description);
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @start_time: The starting time of the recording
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetStartTime (DVBIDBusRecordingsStore* base, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error) {
	DVBRecordingsStore * self;
	guint* _vala_start_time = NULL;
	int _vala_start_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint32 _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* _tmp7_;
				gint _tmp8_ = 0;
				guint* _tmp9_ = NULL;
				_tmp4_ = self->priv->recordings;
				_tmp5_ = rec_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				_tmp7_ = (DVBRecording*) _tmp6_;
				_tmp9_ = dvb_recording_get_start (_tmp7_, &_tmp8_);
				_vala_start_time = (g_free (_vala_start_time), NULL);
				_vala_start_time = _tmp9_;
				_vala_start_time_length1 = _tmp8_;
				_g_object_unref0 (_tmp7_);
				ret = TRUE;
			} else {
				guint* _tmp10_ = NULL;
				_tmp10_ = g_new0 (guint, 0);
				_vala_start_time = (g_free (_vala_start_time), NULL);
				_vala_start_time = _tmp10_;
				_vala_start_time_length1 = 0;
				ret = FALSE;
			}
		}
		__finally142:
		{
			GeeHashMap* _tmp11_;
			_tmp11_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (start_time) {
		*start_time = _vala_start_time;
	} else {
		_vala_start_time = (g_free (_vala_start_time), NULL);
	}
	if (start_time_length1) {
		*start_time_length1 = _vala_start_time_length1;
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @timestamp: Start time as UNIX timestamp
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetStartTimestamp (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* timestamp, GError** error) {
	DVBRecordingsStore * self;
	gint64 _vala_timestamp = 0LL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint32 _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* _tmp7_;
				struct tm _tmp8_;
				struct tm _tmp9_;
				time_t _tmp10_ = 0;
				_tmp4_ = self->priv->recordings;
				_tmp5_ = rec_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				_tmp7_ = (DVBRecording*) _tmp6_;
				dvb_recording_get_StartTime (_tmp7_, &_tmp8_);
				_tmp9_ = _tmp8_;
				_tmp10_ = mktime (&_tmp9_);
				_vala_timestamp = (gint64) _tmp10_;
				_g_object_unref0 (_tmp7_);
				ret = TRUE;
			} else {
				_vala_timestamp = (gint64) 0;
			}
		}
		__finally143:
		{
			GeeHashMap* _tmp11_;
			_tmp11_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (timestamp) {
		*timestamp = _vala_timestamp;
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @length: The length of the recording in seconds
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetLength (DVBIDBusRecordingsStore* base, guint32 rec_id, gint64* length, GError** error) {
	DVBRecordingsStore * self;
	gint64 _vala_length = 0LL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint32 _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* _tmp7_;
				gint64 _tmp8_;
				gint64 _tmp9_;
				_tmp4_ = self->priv->recordings;
				_tmp5_ = rec_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				_tmp7_ = (DVBRecording*) _tmp6_;
				_tmp8_ = dvb_recording_get_Length (_tmp7_);
				_tmp9_ = _tmp8_;
				_vala_length = _tmp9_;
				_g_object_unref0 (_tmp7_);
				ret = TRUE;
			} else {
				_vala_length = (gint64) 0;
			}
		}
		__finally144:
		{
			GeeHashMap* _tmp10_;
			_tmp10_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (length) {
		*length = _vala_length;
	}
	return result;
}


/**
         * @rec_id: The id of the recording
         * @returns: TRUE on success, FALSE otherwises
         *
         * Delete the recording. This deletes all files in the directory
         * created by the Recorder
         */
static gboolean dvb_recordings_store_real_Delete (DVBIDBusRecordingsStore* base, guint32 rec_id, GError** error) {
	DVBRecordingsStore * self;
	gboolean result = FALSE;
	gboolean val;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	val = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (!_tmp3_) {
				val = FALSE;
			} else {
				DVBLoggingLogger* _tmp4_;
				guint32 _tmp5_;
				GeeHashMap* _tmp6_;
				guint32 _tmp7_;
				gpointer _tmp8_ = NULL;
				DVBRecording* rec;
				DVBRecording* _tmp18_;
				_tmp4_ = dvb_recordings_store_log;
				_tmp5_ = rec_id;
				dvb_logging_logger_debug (_tmp4_, "RecordingsStore.vala:258: Deleting recording %u", (guint) _tmp5_);
				_tmp6_ = self->priv->recordings;
				_tmp7_ = rec_id;
				_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, GUINT_TO_POINTER (_tmp7_));
				rec = (DVBRecording*) _tmp8_;
				{
					DVBRecording* _tmp9_;
					GFile* _tmp10_;
					GFile* _tmp11_;
					GFile* _tmp12_ = NULL;
					GFile* _tmp13_;
					_tmp9_ = rec;
					_tmp10_ = dvb_recording_get_Location (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_file_get_parent (_tmp11_);
					_tmp13_ = _tmp12_;
					dvb_utils_delete_dir_recursively (_tmp13_, &_inner_error_);
					_g_object_unref0 (_tmp13_);
					if (_inner_error_ != NULL) {
						goto __catch146_g_error;
					}
					val = TRUE;
				}
				goto __finally146;
				__catch146_g_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp14_;
					GError* _tmp15_;
					const gchar* _tmp16_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp14_ = dvb_recordings_store_log;
					_tmp15_ = e;
					_tmp16_ = _tmp15_->message;
					dvb_logging_logger_error (_tmp14_, "RecordingsStore.vala:264: Could not delete recording: %s", _tmp16_);
					val = FALSE;
					_g_error_free0 (e);
				}
				__finally146:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (rec);
					_g_object_unref0 (rec);
					{
						GeeHashMap* _tmp17_;
						_tmp17_ = self->priv->recordings;
						g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				_tmp18_ = rec;
				dvb_recordings_store_remove (self, _tmp18_);
				_g_object_unref0 (rec);
			}
		}
		__finally145:
		{
			GeeHashMap* _tmp19_;
			_tmp19_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = val;
	return result;
}


/**
         * @rec_id: The id of the recording
         * @name: The channel's name or an empty string if
         * rec_id doesn't exist
         * @returns: TRUE on success
         */
static gboolean dvb_recordings_store_real_GetChannelName (DVBIDBusRecordingsStore* base, guint32 rec_id, gchar** name, GError** error) {
	DVBRecordingsStore * self;
	gchar* _vala_name = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	ret = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint32 _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* rec;
				DVBRecording* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp4_ = self->priv->recordings;
				_tmp5_ = rec_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				rec = (DVBRecording*) _tmp6_;
				_tmp7_ = rec;
				_tmp8_ = dvb_recording_get_ChannelName (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (_vala_name);
				_vala_name = _tmp10_;
				ret = TRUE;
				_g_object_unref0 (rec);
			} else {
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("");
				_g_free0 (_vala_name);
				_vala_name = _tmp11_;
			}
		}
		__finally147:
		{
			GeeHashMap* _tmp12_;
			_tmp12_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	return result;
}


static gboolean dvb_recordings_store_real_GetAllInformations (DVBIDBusRecordingsStore* base, guint32 rec_id, DVBRecordingInfo* info, GError** error) {
	DVBRecordingsStore * self;
	DVBRecordingInfo _vala_info = {0};
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBRecordingsStore*) base;
	dvb_recording_info_destroy (&_vala_info);
	memset (&_vala_info, 0, sizeof (DVBRecordingInfo));
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->recordings;
		g_static_rec_mutex_lock (&self->priv->__lock_recordings);
		{
			GeeHashMap* _tmp1_;
			guint32 _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->recordings;
			_tmp2_ = rec_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, GUINT_TO_POINTER (_tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_;
				guint32 _tmp5_;
				gpointer _tmp6_ = NULL;
				DVBRecording* rec;
				DVBRecording* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* name;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				guint32 _tmp16_;
				DVBRecording* _tmp17_;
				gint64 _tmp18_;
				gint64 _tmp19_;
				const gchar* _tmp20_ = NULL;
				DVBRecording* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				DVBRecording* _tmp29_;
				GFile* _tmp30_;
				GFile* _tmp31_;
				gchar* _tmp32_ = NULL;
				DVBRecording* _tmp33_;
				struct tm _tmp34_;
				struct tm _tmp35_;
				time_t _tmp36_ = 0;
				DVBRecording* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp4_ = self->priv->recordings;
				_tmp5_ = rec_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, GUINT_TO_POINTER (_tmp5_));
				rec = (DVBRecording*) _tmp6_;
				_tmp7_ = rec;
				_tmp8_ = dvb_recording_get_Name (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup (_tmp9_);
				name = _tmp10_;
				_tmp12_ = name;
				if (_tmp12_ == NULL) {
					_tmp11_ = "";
				} else {
					const gchar* _tmp13_;
					_tmp13_ = name;
					_tmp11_ = _tmp13_;
				}
				_tmp14_ = _tmp11_;
				_tmp15_ = g_strdup (_tmp14_);
				_g_free0 (_vala_info.name);
				_vala_info.name = _tmp15_;
				_tmp16_ = rec_id;
				_vala_info.id = _tmp16_;
				_tmp17_ = rec;
				_tmp18_ = dvb_recording_get_Length (_tmp17_);
				_tmp19_ = _tmp18_;
				_vala_info.length = _tmp19_;
				_tmp21_ = rec;
				_tmp22_ = dvb_recording_get_Description (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_ == NULL) {
					_tmp20_ = "";
				} else {
					DVBRecording* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					_tmp24_ = rec;
					_tmp25_ = dvb_recording_get_Description (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp20_ = _tmp26_;
				}
				_tmp27_ = _tmp20_;
				_tmp28_ = g_strdup (_tmp27_);
				_g_free0 (_vala_info.description);
				_vala_info.description = _tmp28_;
				_tmp29_ = rec;
				_tmp30_ = dvb_recording_get_Location (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_file_get_path (_tmp31_);
				_g_free0 (_vala_info.location);
				_vala_info.location = _tmp32_;
				_tmp33_ = rec;
				dvb_recording_get_StartTime (_tmp33_, &_tmp34_);
				_tmp35_ = _tmp34_;
				_tmp36_ = mktime (&_tmp35_);
				_vala_info.start_timestamp = (gint64) _tmp36_;
				_tmp37_ = rec;
				_tmp38_ = dvb_recording_get_ChannelName (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strdup (_tmp39_);
				_g_free0 (_vala_info.channel);
				_vala_info.channel = _tmp40_;
				ret = TRUE;
				_g_free0 (name);
				_g_object_unref0 (rec);
			} else {
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp41_ = g_strdup ("");
				_g_free0 (_vala_info.name);
				_vala_info.name = _tmp41_;
				_vala_info.id = (guint32) 0;
				_vala_info.length = (gint64) 0;
				_tmp42_ = g_strdup ("");
				_g_free0 (_vala_info.description);
				_vala_info.description = _tmp42_;
				_tmp43_ = g_strdup ("");
				_g_free0 (_vala_info.location);
				_vala_info.location = _tmp43_;
				_vala_info.start_timestamp = (gint64) 0;
				_tmp44_ = g_strdup ("");
				_g_free0 (_vala_info.channel);
				_vala_info.channel = _tmp44_;
				ret = FALSE;
			}
		}
		__finally148:
		{
			GeeHashMap* _tmp45_;
			_tmp45_ = self->priv->recordings;
			g_static_rec_mutex_unlock (&self->priv->__lock_recordings);
		}
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (info) {
		*info = _vala_info;
	} else {
		dvb_recording_info_destroy (&_vala_info);
	}
	return result;
}


void dvb_recordings_store_restore_from_dir (DVBRecordingsStore* self, GFile* recordingsbasedir) {
	GFile* _tmp0_;
	DVBioRecordingReader* _tmp1_;
	DVBioRecordingReader* reader;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recordingsbasedir != NULL);
	_tmp0_ = recordingsbasedir;
	_tmp1_ = dvb_io_recording_reader_new (_tmp0_, self);
	reader = _tmp1_;
	dvb_io_recording_reader_load_into (reader);
	_g_object_unref0 (reader);
}


DVBRecordingsStore* dvb_recordings_store_construct (GType object_type) {
	DVBRecordingsStore * self = NULL;
	self = (DVBRecordingsStore*) g_object_new (object_type, NULL);
	return self;
}


DVBRecordingsStore* dvb_recordings_store_new (void) {
	return dvb_recordings_store_construct (DVB_TYPE_RECORDINGS_STORE);
}


static GObject * dvb_recordings_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBRecordingsStore * self;
	GeeHashMap* _tmp0_;
	parent_class = G_OBJECT_CLASS (dvb_recordings_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_RECORDINGS_STORE (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_RECORDING, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->recordings);
	self->priv->recordings = _tmp0_;
	self->priv->last_id = (guint32) 0;
	return obj;
}


static void dvb_recordings_store_class_init (DVBRecordingsStoreClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	GRecMutex _tmp2_ = {0};
	dvb_recordings_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingsStorePrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_recordings_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_recordings_store_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_recordings_store_log = _tmp1_;
	g_rec_mutex_init (&_tmp2_);
	dvb_recordings_store_instance_mutex = _tmp2_;
}


static void dvb_recordings_store_dvb_id_bus_recordings_store_interface_init (DVBIDBusRecordingsStoreIface * iface) {
	dvb_recordings_store_dvb_id_bus_recordings_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetRecordings = (guint32* (*)(DVBIDBusRecordingsStore*, int*, GError**)) dvb_recordings_store_real_GetRecordings;
	iface->GetLocation = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, gchar**, GError**)) dvb_recordings_store_real_GetLocation;
	iface->GetName = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, gchar**, GError**)) dvb_recordings_store_real_GetName;
	iface->GetDescription = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, gchar**, GError**)) dvb_recordings_store_real_GetDescription;
	iface->GetStartTime = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, guint**, int*, GError**)) dvb_recordings_store_real_GetStartTime;
	iface->GetStartTimestamp = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, gint64*, GError**)) dvb_recordings_store_real_GetStartTimestamp;
	iface->GetLength = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, gint64*, GError**)) dvb_recordings_store_real_GetLength;
	iface->Delete = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, GError**)) dvb_recordings_store_real_Delete;
	iface->GetChannelName = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, gchar**, GError**)) dvb_recordings_store_real_GetChannelName;
	iface->GetAllInformations = (gboolean (*)(DVBIDBusRecordingsStore*, guint32, DVBRecordingInfo*, GError**)) dvb_recordings_store_real_GetAllInformations;
}


static void dvb_recordings_store_instance_init (DVBRecordingsStore * self) {
	self->priv = DVB_RECORDINGS_STORE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_recordings);
}


static void dvb_recordings_store_finalize (GObject* obj) {
	DVBRecordingsStore * self;
	self = DVB_RECORDINGS_STORE (obj);
	g_static_rec_mutex_free (&self->priv->__lock_recordings);
	_g_object_unref0 (self->priv->recordings);
	G_OBJECT_CLASS (dvb_recordings_store_parent_class)->finalize (obj);
}


/**
     * This class manages the recordings off all devices
     */
GType dvb_recordings_store_get_type (void) {
	static volatile gsize dvb_recordings_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_recordings_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recordings_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecordingsStore), 0, (GInstanceInitFunc) dvb_recordings_store_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_recordings_store_info = { (GInterfaceInitFunc) dvb_recordings_store_dvb_id_bus_recordings_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_recordings_store_type_id;
		dvb_recordings_store_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecordingsStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_recordings_store_type_id, DVB_TYPE_ID_BUS_RECORDINGS_STORE, &dvb_id_bus_recordings_store_info);
		g_once_init_leave (&dvb_recordings_store_type_id__volatile, dvb_recordings_store_type_id);
	}
	return dvb_recordings_store_type_id__volatile;
}



