/*
 * file-selector.h: implementation of GNOME::FileSelector
 *
 * Authors:
 *    Jacob Berkman  <jacob@ximian.com>
 *    Miguel de Icaza  <miguel@ximian.com>
 *
 * Copyright 2000, 2001 Ximian, Inc.
 */

#ifndef _FILE_SELECTOR_H_
#define _FILE_SELECTOR_H_

#include <bonobo/bonobo-xobject.h>
#include <bonobo/bonobo-property-bag.h>
#include <gtk/gtkwidget.h>

#include "GNOME_FileSelector.h"

#define FILE_SELECTOR_TYPE        (file_selector_get_type ())
#define FILE_SELECTOR(o)          (GTK_CHECK_CAST ((o), FILE_SELECTOR_TYPE, FileSelector))
#define FILE_SELECTOR_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), FILE_SELECTOR_TYPE, FileSelectorClass))
#define IS_FILE_SELECTOR(o)       (GTK_CHECK_TYPE ((o), FILE_SELECTOR_TYPE))
#define IS_FILE_SELECTOR_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), FILE_SELECTOR_TYPE))

typedef struct _FileSelctorPrivate FileSelectorPrivate;

typedef struct {
	BonoboXObject        parent;

	FileSelectorPrivate *priv;
} FileSelector;

typedef struct {
	BonoboXObjectClass           parent_class;
	POA_GNOME_FileSelector__epv epv;
} FileSelectorClass;

GtkType       file_selector_get_type (void);

#endif

