/* chess-engine.c generated by valac 0.11.7, the Vala compiler
 * generated from chess-engine.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
	gchar* binary;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessEnginePrivate {
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	gboolean _ready;
};


static gpointer chess_engine_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE, ChessEnginePrivate))
enum  {
	CHESS_ENGINE_DUMMY_PROPERTY,
	CHESS_ENGINE_READY
};
void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1);
static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1);
gboolean chess_engine_start (ChessEngine* self);
static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void chess_engine_start_game (ChessEngine* self);
static void chess_engine_real_start_game (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
static void chess_engine_real_undo (ChessEngine* self);
void chess_engine_stop (ChessEngine* self);
void chess_engine_write (ChessEngine* self, gchar* data, int data_length1);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
ChessEngine* chess_engine_new (void);
ChessEngine* chess_engine_construct (GType object_type);
gboolean chess_engine_get_ready (ChessEngine* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_finalize (GObject* obj);
static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1) {
	g_return_if_fail (self != NULL);
}


void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1) {
	CHESS_ENGINE_GET_CLASS (self)->process_input (self, data, data_length1);
}


static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = chess_engine_read_cb (self, source, condition);
	return result;
}


gboolean chess_engine_start (ChessEngine* self) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	gint stdout_fd = 0;
	GPid _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GIOChannel* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup (self->binary);
	_tmp1_ = g_new0 (gchar*, 2 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp1_[1] = NULL;
	argv = _tmp1_;
	argv_length1 = 2;
	_argv_size_ = 2;
	g_spawn_async_with_pipes (NULL, argv, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
	self->priv->pid = _tmp2_;
	self->priv->stdin_fd = _tmp3_;
	stdout_fd = _tmp4_;
	self->priv->stderr_fd = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch9_g_spawn_error;
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	goto __finally9;
	__catch9_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Failed to execute chess engine: %s\n", e->message);
		result = FALSE;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = g_io_channel_unix_new (stdout_fd);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	self->priv->stdout_channel = _tmp6_;
	g_io_channel_set_flags (self->priv->stdout_channel, G_IO_FLAG_NONBLOCK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
			goto __catch10_g_io_channel_error;
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	goto __finally10;
	__catch10_g_io_channel_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Failed to set input from chess engine to non-blocking: %s", e->message);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	g_io_add_watch (self->priv->stdout_channel, G_IO_IN, _chess_engine_read_cb_gio_func, self);
	g_signal_emit_by_name (self, "starting");
	result = TRUE;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void chess_engine_real_start_game (ChessEngine* self) {
	g_return_if_fail (self != NULL);
}


void chess_engine_start_game (ChessEngine* self) {
	CHESS_ENGINE_GET_CLASS (self)->start_game (self);
}


static void chess_engine_real_request_move (ChessEngine* self) {
	g_return_if_fail (self != NULL);
}


void chess_engine_request_move (ChessEngine* self) {
	CHESS_ENGINE_GET_CLASS (self)->request_move (self);
}


static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
}


void chess_engine_report_move (ChessEngine* self, ChessMove* move) {
	CHESS_ENGINE_GET_CLASS (self)->report_move (self, move);
}


static void chess_engine_real_undo (ChessEngine* self) {
	g_return_if_fail (self != NULL);
}


void chess_engine_undo (ChessEngine* self) {
	CHESS_ENGINE_GET_CLASS (self)->undo (self);
}


void chess_engine_stop (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "stopped");
}


static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp0_ = NULL;
	gsize _tmp1_;
	GIOStatus _tmp2_;
	GIOStatus _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_new0 (gchar, 1024);
	buf = (g_free (buf), NULL);
	buf = _tmp0_;
	buf_length1 = 1024;
	_buf_size_ = 1024;
	_tmp2_ = g_io_channel_read_chars (source, buf, buf_length1, &_tmp1_, &_inner_error_);
	n_read = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_CONVERT_ERROR) {
			goto __catch11_g_convert_error;
		}
		if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
			goto __catch11_g_io_channel_error;
		}
		buf = (g_free (buf), NULL);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	status = _tmp3_;
	goto __finally11;
	__catch11_g_convert_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	goto __finally11;
	__catch11_g_io_channel_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		buf = (g_free (buf), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	if (status == G_IO_STATUS_EOF) {
		fprintf (stdout, "EOF\n");
		result = FALSE;
		buf = (g_free (buf), NULL);
		return result;
	}
	if (status == G_IO_STATUS_NORMAL) {
		gint _tmp4_;
		_tmp4_ = (gint) n_read;
		buf = g_renew (gchar, buf, (gint) n_read);
		(_tmp4_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp4_ - buf_length1)) : NULL;
		buf_length1 = _tmp4_;
		_buf_size_ = _tmp4_;
		chess_engine_process_input (self, buf, buf_length1);
	}
	result = TRUE;
	buf = (g_free (buf), NULL);
	return result;
}


void chess_engine_write (ChessEngine* self, gchar* data, int data_length1) {
	gsize offset;
	gsize n_written = 0UL;
	g_return_if_fail (self != NULL);
	offset = (gsize) 0;
	while (TRUE) {
		gint _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* d;
		gint d_length1;
		gint _d_size_;
		gssize _tmp3_;
		if (!(offset < data_length1)) {
			break;
		}
		_tmp1_ = g_new0 (gchar, _tmp0_ = data_length1 - offset);
		d = _tmp1_;
		d_length1 = _tmp0_;
		_d_size_ = _tmp0_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					if (!_tmp2_) {
						i++;
					}
					_tmp2_ = FALSE;
					if (!(i < (data_length1 - offset))) {
						break;
					}
					d[i] = data[offset + i];
				}
			}
		}
		_tmp3_ = write (self->priv->stdin_fd, d, (gsize) d_length1);
		n_written = (gsize) _tmp3_;
		if (n_written < 0) {
			d = (g_free (d), NULL);
			return;
		}
		offset = offset + n_written;
		d = (g_free (d), NULL);
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = g_new0 (gchar, _tmp0_ + 1);
	_result_ = _tmp1_;
	_result__length1 = _tmp0_ + 1;
	__result__size_ = _tmp0_ + 1;
	_result__length1--;
	_tmp2_ = strlen (self);
	memcpy (_result_, self, (gsize) _tmp2_);
	_tmp3_ = _result_;
	*result_length1 = _result__length1;
	result = _tmp3_;
	return result;
}


void chess_engine_write_line (ChessEngine* self, const gchar* line) {
	gchar* _tmp0_;
	gchar* l;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* d;
	gint d_length1;
	gint _d_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = g_strconcat (line, "\n", NULL);
	l = _tmp0_;
	g_debug ("chess-engine.vala:146: Writing line to engine: '%s'", line);
	_tmp2_ = string_to_utf8 (l, &_tmp1_);
	d = _tmp2_;
	d_length1 = _tmp1_;
	_d_size_ = _tmp1_;
	if (d != NULL) {
		chess_engine_write (self, d, d_length1);
	}
	d = (g_free (d), NULL);
	_g_free0 (l);
}


ChessEngine* chess_engine_construct (GType object_type) {
	ChessEngine * self = NULL;
	self = (ChessEngine*) g_object_new (object_type, NULL);
	return self;
}


ChessEngine* chess_engine_new (void) {
	return chess_engine_construct (TYPE_CHESS_ENGINE);
}


gboolean chess_engine_get_ready (ChessEngine* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ready;
	return result;
}


void chess_engine_set_ready (ChessEngine* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ready = value;
	g_signal_emit_by_name (self, "ready-changed");
	g_object_notify ((GObject *) self, "ready");
}


static void chess_engine_class_init (ChessEngineClass * klass) {
	chess_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEnginePrivate));
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_real_process_input;
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_real_start_game;
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_real_request_move;
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_real_report_move;
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_real_undo;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_engine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_engine_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_ENGINE_READY, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("ready_changed", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("stopped", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_engine_instance_init (ChessEngine * self) {
	self->priv = CHESS_ENGINE_GET_PRIVATE (self);
	self->priv->_ready = FALSE;
}


static void chess_engine_finalize (GObject* obj) {
	ChessEngine * self;
	self = CHESS_ENGINE (obj);
	_g_free0 (self->binary);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
}


GType chess_engine_get_type (void) {
	static volatile gsize chess_engine_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
		GType chess_engine_type_id;
		chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_type_id__volatile, chess_engine_type_id);
	}
	return chess_engine_type_id__volatile;
}


static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = CHESS_ENGINE (object);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		g_value_set_boolean (value, chess_engine_get_ready (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = CHESS_ENGINE (object);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		chess_engine_set_ready (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



