/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2003      Martyn Russell <ginxd@btopenworld.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* 
 * $RCSfile: gj_history.h,v $
 *
 * $Author: mr $
 * $Date: 2004/04/17 17:22:26 $
 * 
 * $Revision: 1.2 $
 *
 */

#ifdef __cplusplus
extern "C" {
#if 0
}
#endif
#endif

#ifndef __gj_history_h
#define __gj_history_h

#include "gj_typedefs.h"


/* item */
GjHistory gj_history_new (GjRosterItem ri);
gboolean gj_history_free (GjHistory hist);

/* find */
GjHistory gj_history_find (gint id);

/* 
 * member functions
 */

/* sets */
gboolean gj_history_set_filename (GjHistory hist, const gchar *filename);

/* gets */
gint gj_history_get_ri_id (GjHistory hist);
const gchar *gj_history_get_filename (GjHistory hist);
GIOChannel *gj_history_get_channel (GjHistory hist);

const gchar *gj_history_get_url (GjHistory hist);

/* 
 * functions used by chat windows 
 */
gboolean gj_history_start (GjHistory hist);

gboolean gj_history_write_sent_by_ri_id (gint ri_id, 
					const gchar *date, 
					const gchar *subject, 
					const gchar *message);
gboolean gj_history_write_sent (GjHistory hist, 
			       const gchar *date, 
			       const gchar *subject, 
			       const gchar *message);
gboolean gj_history_write_received_by_ri_id (gint ri_id, 
					    const gchar *date, 
					    const gchar *subject, 
					    const gchar *message);
gboolean gj_history_write_received (GjHistory hist, 
				   const gchar *date, 
				   const gchar *subject,
				   const gchar *message);


#endif

#ifdef __cplusplus
}
#endif
