# Infrared Remote Control Properties for GNOME
# Copyright (C) 2008 Fluendo Embedded S.L. (www.fluendo.com)
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
'''
Update services.
'''

import gobject, logging, threading, urllib

from gettext import gettext as _
from md5     import md5

__all__ = (
    'retrieve_tarball',
)

def retrieve_tarball(tarball_uri,
                     checksum_uri=None,
                     progress_callback=None,
                     finished_callback=None,
                     failure_callback=logging.error):

    def download_thread():
        def on_download_progress(n_blocks, block_size, file_size):
            if progress_callback:
                offset = min(n_blocks * block_size, file_size)
                gobject.idle_add(lambda: progress_callback(offset, file_size, action) and False)
                from time import sleep; sleep(0.025)

        action = data=_('Downloading checksum list...')
        filename, headers = urllib.urlretrieve(checksum_uri,
                                               reporthook=on_download_progress)

        if 'text/plain' != headers['content-type']:
            failure_callback(_('Cannot download checksum list.'))
            return

        checksums = open(filename).readlines()
        checksums = dict([(l[34:].rstrip(), l[:32]) for l in checksums])

        expected_checksum = checksums.get(basename)

        if not expected_checksum:
            failure_callback(_('Checksum of %s not found in checksum list.') % basename)
            return

        action = data=_('Downloading file archive...')
        filename, headers = urllib.urlretrieve(tarball_uri,
                                               reporthook=on_download_progress)

        tarball_checksum = md5(open(filename).read()).hexdigest()

        if tarball_checksum != expected_checksum:
            failure_callback(_('Checksum for %s doesn\'t match expected checksum.') % basename)
            return

        if finished_callback:
            gobject.idle_add(lambda: finished_callback(filename, headers) and False)

    if not checksum_uri:
        slash = tarball_uri.rindex('/')
        basename = tarball_uri[slash + 1:]
        baseuri = tarball_uri[:slash + 1]
        dot = basename.index('.')

        checksum_uri = baseuri + basename[:dot] + '.md5sum'

    threading.Thread(target=download_thread).start()


