#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <gnome.h>
#include "lokkit.h"

int write_firewall(int policy, int ether, int ether1, int *ports, int dhcp)
{

	int i;
	FILE *fw=fopen(fwscript, "w");
	int num;
	struct in_addr *p;
	char buffer[128];
	
	if(fw==NULL)
		return -1;
	
	fprintf(fw, "#!/bin/sh\n");
	fprintf(fw, "PATH=/sbin:$PATH\n");
	
	fprintf(fw, "ipchains -F input\n");	
	
	for(i=0;i<8;i++)
	{
		if(ports[i])
			fprintf(fw, "ipchains -A input -s 0/0 -d 0/0 %d -p tcp -y -j ACCEPT\n",
				ports[i]);
	}

	if(dhcp)
	{
		fprintf(fw,"ipchains -A input -s 0/0 67:68 -d 0/0 67:68 -p udp -i eth0 -j ACCEPT\n");
		fprintf(fw,"ipchains -A input -s 0/0 67:68 -d 0/0 67:68 -p udp -i eth1 -j ACCEPT\n");
	}
	
	fprintf(fw, "ipchains -A input -s 0/0 -d 0/0 -i lo -j ACCEPT\n");
	
	if(ether==0)
		fprintf(fw, "ipchains -A input -s 0/0 -d 0/0 -i eth0 -j ACCEPT\n");
	if(ether1==0)
		fprintf(fw, "ipchains -A input -s 0/0 -d 0/0 -i eth1 -j ACCEPT\n");

	if(policy==0)
	{
		p=parse_resolv(&num);
		for(i=0;i<num;i++)
		{
			fprintf(fw, "ipchains -A input -s %s 53 -d 0/0 -p udp -j ACCEPT\n",
				inet_ntoa(p[i]));
		}
		fprintf(fw, "ipchains -A input -s 0/0 -d 0/0 -p tcp -y -j DENY\n");
		fprintf(fw, "ipchains -A input -s 0/0 -d 0/0 -p udp -j DENY\n");
	}
	else
	{
		fprintf(fw, "ipchains -A input -p tcp -s 0/0 -d 0/0 0:1023 -y -j DENY\n");
		fprintf(fw, "ipchains -A input -p tcp -s 0/0 -d 0/0 2049 -y -j DENY\n");
		fprintf(fw, "ipchains -A input -p udp -s 0/0 -d 0/0 0:1023 -j DENY\n");
		fprintf(fw, "ipchains -A input -p udp -s 0/0 -d 0/0 2049 -j DENY\n");
		fprintf(fw, "ipchains -A input -p tcp -s 0/0 -d 0/0 6000:6009 -y -j DENY\n");
		fprintf(fw, "ipchains -A input -p tcp -s 0/0 -d 0/0 7100 -y -j DENY\n");
	}
	fclose(fw);
	sprintf(buffer, "/bin/sh %s", fwscript);
	system(buffer);
	return 0;
}


void flush_firewall(void)
{
	unlink(fwscript);
	system("/sbin/ipchains -F input");
}

