/* nibbles-view.c generated by valac 0.31.1.7-38346, the Vala compiler
 * generated from nibbles-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <clutter-gtk/clutter-gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <canberra-gtk.h>
#include <canberra.h>


#define TYPE_WORM_ACTOR (worm_actor_get_type ())
#define WORM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_ACTOR, WormActor))
#define WORM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_ACTOR, WormActorClass))
#define IS_WORM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_ACTOR))
#define IS_WORM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_ACTOR))
#define WORM_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_ACTOR, WormActorClass))

typedef struct _WormActor WormActor;
typedef struct _WormActorClass WormActorClass;
typedef struct _WormActorPrivate WormActorPrivate;

#define TYPE_BONUS_TEXTURE (bonus_texture_get_type ())
#define BONUS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS_TEXTURE, BonusTexture))
#define BONUS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS_TEXTURE, BonusTextureClass))
#define IS_BONUS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS_TEXTURE))
#define IS_BONUS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS_TEXTURE))
#define BONUS_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS_TEXTURE, BonusTextureClass))

typedef struct _BonusTexture BonusTexture;
typedef struct _BonusTextureClass BonusTextureClass;
typedef struct _BonusTexturePrivate BonusTexturePrivate;

#define TYPE_WARP_TEXTURE (warp_texture_get_type ())
#define WARP_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_TEXTURE, WarpTexture))
#define WARP_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_TEXTURE, WarpTextureClass))
#define IS_WARP_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_TEXTURE))
#define IS_WARP_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_TEXTURE))
#define WARP_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_TEXTURE, WarpTextureClass))

typedef struct _WarpTexture WarpTexture;
typedef struct _WarpTextureClass WarpTextureClass;
typedef struct _WarpTexturePrivate WarpTexturePrivate;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
typedef struct _WarpManagerPrivate WarpManagerPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _BoniPrivate BoniPrivate;
typedef struct _BonusPrivate BonusPrivate;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
typedef struct _WarpPrivate WarpPrivate;

struct _WormActor {
	ClutterActor parent_instance;
	WormActorPrivate * priv;
};

struct _WormActorClass {
	ClutterActorClass parent_class;
};

struct _BonusTexture {
	GtkClutterTexture parent_instance;
	BonusTexturePrivate * priv;
};

struct _BonusTextureClass {
	GtkClutterTextureClass parent_class;
};

struct _WarpTexture {
	GtkClutterTexture parent_instance;
	WarpTexturePrivate * priv;
};

struct _WarpTextureClass {
	GtkClutterTextureClass parent_class;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _NibblesViewPrivate {
	GdkPixbuf* wall_pixmaps[11];
	GdkPixbuf* worm_pixmaps[6];
	GdkPixbuf* boni_pixmaps[9];
	ClutterStage* stage;
	ClutterActor* level;
	ClutterActor* _name_labels;
	GeeHashMap* worm_actors;
	GeeHashMap* bonus_actors;
	GeeHashMap* warp_actors;
	NibblesGame* _game;
};

struct _WarpManager {
	GObject parent_instance;
	WarpManagerPrivate * priv;
	GeeLinkedList* warps;
};

struct _WarpManagerClass {
	GObjectClass parent_class;
};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Block6Data {
	int _ref_count_;
	NibblesView* self;
	Worm* worm;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block7Data {
	int _ref_count_;
	NibblesView* self;
	Worm* worm;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_CUT,
	BONUS_TYPE_SWITCH,
	BONUS_TYPE_WARP
} BonusType;

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};


static gpointer worm_actor_parent_class = NULL;
static gpointer bonus_texture_parent_class = NULL;
static gpointer warp_texture_parent_class = NULL;
static gpointer nibbles_view_parent_class = NULL;
extern gchar** nibbles_view_color_lookup;
extern gint nibbles_view_color_lookup_length1;
gchar** nibbles_view_color_lookup = NULL;
gint nibbles_view_color_lookup_length1 = 0;

GType worm_actor_get_type (void) G_GNUC_CONST;
enum  {
	WORM_ACTOR_DUMMY_PROPERTY
};
static void worm_actor_real_show (ClutterActor* base);
#define NIBBLES_GAME_GAMEDELAY 35
static void worm_actor_real_hide (ClutterActor* base);
WormActor* worm_actor_new (void);
WormActor* worm_actor_construct (GType object_type);
GType bonus_texture_get_type (void) G_GNUC_CONST;
enum  {
	BONUS_TEXTURE_DUMMY_PROPERTY
};
#define BONUS_TEXTURE_SIZE_MULTIPLIER ((gfloat) 2)
static void bonus_texture_real_show (ClutterActor* base);
void bonus_texture_set_size (BonusTexture* self, gfloat width, gfloat height);
BonusTexture* bonus_texture_new (void);
BonusTexture* bonus_texture_construct (GType object_type);
GType warp_texture_get_type (void) G_GNUC_CONST;
enum  {
	WARP_TEXTURE_DUMMY_PROPERTY
};
#define WARP_TEXTURE_SIZE_MULTIPLIER ((gfloat) 2)
static void warp_texture_real_show (ClutterActor* base);
static void warp_texture_real_hide (ClutterActor* base);
void warp_texture_set_size (WarpTexture* self, gfloat width, gfloat height);
WarpTexture* warp_texture_new (void);
WarpTexture* warp_texture_construct (GType object_type);
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType worm_get_type (void) G_GNUC_CONST;
GType bonus_get_type (void) G_GNUC_CONST;
GType warp_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES_VIEW, NibblesViewPrivate))
enum  {
	NIBBLES_VIEW_DUMMY_PROPERTY,
	NIBBLES_VIEW_NAME_LABELS,
	NIBBLES_VIEW_GAME
};
#define NIBBLES_VIEW_NUM_COLORS 6
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type, NibblesGame* game);
void nibbles_view_set_game (NibblesView* self, NibblesGame* value);
#define NIBBLES_GAME_MINIMUM_TILE_SIZE 7
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
static void nibbles_view_load_pixmap (NibblesView* self);
void nibbles_view_new_level (NibblesView* self, gint level);
NibblesGame* nibbles_view_get_game (NibblesView* self);
GType boni_get_type (void) G_GNUC_CONST;
Boni* nibbles_game_get_boni (NibblesGame* self);
void boni_reset (Boni* self, gint numworms);
gint nibbles_game_get_numworms (NibblesGame* self);
GType warp_manager_get_type (void) G_GNUC_CONST;
WarpManager* nibbles_game_get_warp_manager (NibblesGame* self);
#define NIBBLES_GAME_EMPTYCHAR 'a'
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
GType worm_direction_get_type (void) G_GNUC_CONST;
void worm_set_start (Worm* self, gint xhead, gint yhead, WormDirection direction);
static void nibbles_view_load_level (NibblesView* self);
gint nibbles_game_get_tile_size (NibblesGame* self);
void warp_manager_add_warp (WarpManager* self, gint* board, int board_length1, int board_length2, gint x, gint y, gint wx, gint wy);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self, const gchar* pixmap, gint xsize, gint ysize);
void nibbles_view_connect_worm_signals (NibblesView* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void nibbles_view_worm_added_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_added_cb_worm_added (Worm* _sender, gpointer self);
static void nibbles_view_worm_finish_added_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_finish_added_cb_worm_finish_added (Worm* _sender, gpointer self);
static void nibbles_view_worm_moved_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_moved_cb_worm_moved (Worm* _sender, gpointer self);
static void nibbles_view_worm_rescaled_cb (NibblesView* self, Worm* worm, gint tile_size);
static void _nibbles_view_worm_rescaled_cb_worm_rescaled (Worm* _sender, gint tile_size, gpointer self);
static void nibbles_view_worm_died_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_died_cb_worm_died (Worm* _sender, gpointer self);
static void nibbles_view_worm_tail_reduced_cb (NibblesView* self, Worm* worm, gint erase_size);
static void _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced (Worm* _sender, gint erase_size, gpointer self);
static void nibbles_view_worm_reversed_cb (NibblesView* self, Worm* worm);
static void _nibbles_view_worm_reversed_cb_worm_reversed (Worm* _sender, gpointer self);
static void ____lambda5_ (Block6Data* _data6_);
gboolean worm_get_is_materialized (Worm* self);
static void _____lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void nibbles_view_board_rescale (NibblesView* self, gint tile_size);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
gint worm_get_id (Worm* self);
gint worm_get_length (Worm* self);
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GeeLinkedList* worm_get_list (Worm* self);
void worm_get_head (Worm* self, Position* result);
static void nibbles_view_animate_end_game_cb (NibblesView* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_view_set_name_labels (NibblesView* self, ClutterActor* value);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
gchar* nibbles_view_colorval_name (gint colorval);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
void worm_dematerialize (Worm* self, gint* board, int board_length1, int board_length2, gint rounds);
static gboolean __lambda4_ (Block7Data* _data7_);
static gboolean ___lambda4__gsource_func (gpointer self);
static void nibbles_view_play_sound (NibblesView* self, const gchar* name);
static void nibbles_view_bonus_added_cb (NibblesView* self);
GType bonus_type_get_type (void) G_GNUC_CONST;
static void nibbles_view_bonus_removed_cb (NibblesView* self, Bonus* bonus);
static void nibbles_view_bonus_applied_cb (NibblesView* self, Bonus* bonus, Worm* worm);
void nibbles_view_boni_rescale (NibblesView* self, gint tile_size);
static void nibbles_view_warp_added_cb (NibblesView* self, Warp* warp);
void nibbles_view_warps_rescale (NibblesView* self, gint tile_size);
gint nibbles_view_colorval_from_name (const gchar* name);
static void _nibbles_view_bonus_added_cb_boni_bonus_added (Boni* _sender, gpointer self);
static void _nibbles_view_bonus_removed_cb_boni_bonus_removed (Boni* _sender, Bonus* bonus, gpointer self);
static void _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied (NibblesGame* _sender, Bonus* bonus, Worm* worm, gpointer self);
static void _nibbles_view_warp_added_cb_warp_manager_warp_added (WarpManager* _sender, Warp* warp, gpointer self);
static void _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game (NibblesGame* _sender, gpointer self);
static void nibbles_view_finalize (GObject* obj);
static void _vala_nibbles_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_nibbles_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void worm_actor_real_show (ClutterActor* base) {
	WormActor * self;
	self = (WormActor*) base;
	CLUTTER_ACTOR_CLASS (worm_actor_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_CIRC);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 26));
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


static void worm_actor_real_hide (ClutterActor* base) {
	WormActor * self;
	self = (WormActor*) base;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 0.4f, (gdouble) 0.4f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


WormActor* worm_actor_construct (GType object_type) {
	WormActor * self = NULL;
	self = (WormActor*) g_object_new (object_type, NULL);
	return self;
}


WormActor* worm_actor_new (void) {
	return worm_actor_construct (TYPE_WORM_ACTOR);
}


static void worm_actor_class_init (WormActorClass * klass) {
	worm_actor_parent_class = g_type_class_peek_parent (klass);
	((ClutterActorClass *) klass)->show = worm_actor_real_show;
	((ClutterActorClass *) klass)->hide = worm_actor_real_hide;
}


static void worm_actor_instance_init (WormActor * self) {
}


GType worm_actor_get_type (void) {
	static volatile gsize worm_actor_type_id__volatile = 0;
	if (g_once_init_enter (&worm_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WormActor), 0, (GInstanceInitFunc) worm_actor_instance_init, NULL };
		GType worm_actor_type_id;
		worm_actor_type_id = g_type_register_static (clutter_actor_get_type (), "WormActor", &g_define_type_info, 0);
		g_once_init_leave (&worm_actor_type_id__volatile, worm_actor_type_id);
	}
	return worm_actor_type_id__volatile;
}


static void bonus_texture_real_show (ClutterActor* base) {
	BonusTexture * self;
	self = (BonusTexture*) base;
	CLUTTER_ACTOR_CLASS (bonus_texture_parent_class)->show ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BOUNCE);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


void bonus_texture_set_size (BonusTexture* self, gfloat width, gfloat height) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	g_return_if_fail (self != NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	clutter_actor_set_size ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture), BONUS_TEXTURE_SIZE_MULTIPLIER * _tmp0_, BONUS_TEXTURE_SIZE_MULTIPLIER * _tmp1_);
}


BonusTexture* bonus_texture_construct (GType object_type) {
	BonusTexture * self = NULL;
	self = (BonusTexture*) g_object_new (object_type, NULL);
	return self;
}


BonusTexture* bonus_texture_new (void) {
	return bonus_texture_construct (TYPE_BONUS_TEXTURE);
}


static void bonus_texture_class_init (BonusTextureClass * klass) {
	bonus_texture_parent_class = g_type_class_peek_parent (klass);
	((ClutterActorClass *) klass)->show = bonus_texture_real_show;
}


static void bonus_texture_instance_init (BonusTexture * self) {
}


GType bonus_texture_get_type (void) {
	static volatile gsize bonus_texture_type_id__volatile = 0;
	if (g_once_init_enter (&bonus_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BonusTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bonus_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BonusTexture), 0, (GInstanceInitFunc) bonus_texture_instance_init, NULL };
		GType bonus_texture_type_id;
		bonus_texture_type_id = g_type_register_static (gtk_clutter_texture_get_type (), "BonusTexture", &g_define_type_info, 0);
		g_once_init_leave (&bonus_texture_type_id__volatile, bonus_texture_type_id);
	}
	return bonus_texture_type_id__volatile;
}


static void warp_texture_real_show (ClutterActor* base) {
	WarpTexture * self;
	self = (WarpTexture*) base;
	CLUTTER_ACTOR_CLASS (warp_texture_parent_class)->show ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_CIRC);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


static void warp_texture_real_hide (ClutterActor* base) {
	WarpTexture * self;
	self = (WarpTexture*) base;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 0.4f, (gdouble) 0.4f);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}


void warp_texture_set_size (WarpTexture* self, gfloat width, gfloat height) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
	g_return_if_fail (self != NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	clutter_actor_set_size ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture), WARP_TEXTURE_SIZE_MULTIPLIER * _tmp0_, WARP_TEXTURE_SIZE_MULTIPLIER * _tmp1_);
}


WarpTexture* warp_texture_construct (GType object_type) {
	WarpTexture * self = NULL;
	self = (WarpTexture*) g_object_new (object_type, NULL);
	return self;
}


WarpTexture* warp_texture_new (void) {
	return warp_texture_construct (TYPE_WARP_TEXTURE);
}


static void warp_texture_class_init (WarpTextureClass * klass) {
	warp_texture_parent_class = g_type_class_peek_parent (klass);
	((ClutterActorClass *) klass)->show = warp_texture_real_show;
	((ClutterActorClass *) klass)->hide = warp_texture_real_hide;
}


static void warp_texture_instance_init (WarpTexture * self) {
}


GType warp_texture_get_type (void) {
	static volatile gsize warp_texture_type_id__volatile = 0;
	if (g_once_init_enter (&warp_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WarpTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpTexture), 0, (GInstanceInitFunc) warp_texture_instance_init, NULL };
		GType warp_texture_type_id;
		warp_texture_type_id = g_type_register_static (gtk_clutter_texture_get_type (), "WarpTexture", &g_define_type_info, 0);
		g_once_init_leave (&warp_texture_type_id__volatile, warp_texture_type_id);
	}
	return warp_texture_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NibblesView* nibbles_view_construct (GType object_type, NibblesGame* game) {
	NibblesView * self = NULL;
	NibblesGame* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterStage* _tmp2_ = NULL;
	ClutterColor stage_color = {0};
	ClutterColor _tmp3_ = {0};
	ClutterStage* _tmp4_ = NULL;
	ClutterColor _tmp5_ = {0};
	GeeHashMap* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	g_return_val_if_fail (game != NULL, NULL);
	self = (NibblesView*) g_object_new (object_type, NULL);
	_tmp0_ = game;
	nibbles_view_set_game (self, _tmp0_);
	_tmp1_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, clutter_stage_get_type (), ClutterStage));
	_g_object_unref0 (self->priv->stage);
	self->priv->stage = _tmp2_;
	_tmp3_.red = (guint8) 0x00;
	_tmp3_.green = (guint8) 0x00;
	_tmp3_.blue = (guint8) 0x00;
	_tmp3_.alpha = (guint8) 0xff;
	stage_color = _tmp3_;
	_tmp4_ = self->priv->stage;
	_tmp5_ = stage_color;
	clutter_actor_set_background_color ((ClutterActor*) _tmp4_, &_tmp5_);
	gtk_widget_set_size_request ((GtkWidget*) self, NIBBLES_GAME_MINIMUM_TILE_SIZE * NIBBLES_GAME_WIDTH, NIBBLES_GAME_MINIMUM_TILE_SIZE * NIBBLES_GAME_HEIGHT);
	_tmp6_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WORM_ACTOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->worm_actors);
	self->priv->worm_actors = _tmp6_;
	_tmp7_ = gee_hash_map_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_BONUS_TEXTURE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->bonus_actors);
	self->priv->bonus_actors = _tmp7_;
	_tmp8_ = gee_hash_map_new (TYPE_WARP, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WARP_TEXTURE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->warp_actors);
	self->priv->warp_actors = _tmp8_;
	nibbles_view_load_pixmap (self);
	return self;
}


NibblesView* nibbles_view_new (NibblesGame* game) {
	return nibbles_view_construct (TYPE_NIBBLES_VIEW, game);
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GString* _tmp2_ = NULL;
		gint _tmp4_ = 0;
		GString* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_ = NULL;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = ret;
		_tmp9_ = ((GString*) _tmp8_)->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


void nibbles_view_new_level (NibblesView* self, gint level) {
	gchar* level_name = NULL;
	gchar* filename = NULL;
	gchar* tmpboard = NULL;
	gint count = 0;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FILE* file = NULL;
	const gchar* _tmp4_ = NULL;
	FILE* _tmp5_ = NULL;
	FILE* _tmp6_ = NULL;
	GeeHashMap* _tmp19_ = NULL;
	GeeHashMap* _tmp31_ = NULL;
	GeeHashMap* _tmp43_ = NULL;
	NibblesGame* _tmp44_ = NULL;
	NibblesGame* _tmp45_ = NULL;
	Boni* _tmp46_ = NULL;
	Boni* _tmp47_ = NULL;
	NibblesGame* _tmp48_ = NULL;
	NibblesGame* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	NibblesGame* _tmp52_ = NULL;
	NibblesGame* _tmp53_ = NULL;
	WarpManager* _tmp54_ = NULL;
	WarpManager* _tmp55_ = NULL;
	GeeLinkedList* _tmp56_ = NULL;
	g_return_if_fail (self != NULL);
	count = 0;
	_tmp0_ = level;
	_tmp1_ = g_strdup_printf ("level%03d.gnl", _tmp0_);
	_g_free0 (level_name);
	level_name = _tmp1_;
	_tmp2_ = level_name;
	_tmp3_ = g_build_filename (PKGDATADIR, "levels", _tmp2_, NULL, NULL);
	_g_free0 (filename);
	filename = _tmp3_;
	_tmp4_ = filename;
	_tmp5_ = g_fopen (_tmp4_, "r");
	_fclose0 (file);
	file = _tmp5_;
	_tmp6_ = file;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = filename;
		g_error ("nibbles-view.vala:198: Nibbles couldn't find pixmap file: %s", _tmp7_);
	}
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
		GeeCollection* _tmp10_ = NULL;
		GeeCollection* _tmp11_ = NULL;
		GeeIterator* _tmp12_ = NULL;
		GeeIterator* _tmp13_ = NULL;
		_tmp8_ = self->priv->worm_actors;
		_tmp9_ = gee_abstract_map_get_values ((GeeMap*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_actor_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			WormActor* actor = NULL;
			GeeIterator* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			WormActor* _tmp18_ = NULL;
			_tmp14_ = _actor_it;
			_tmp15_ = gee_iterator_next (_tmp14_);
			if (!_tmp15_) {
				break;
			}
			_tmp16_ = _actor_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			actor = (WormActor*) _tmp17_;
			_tmp18_ = actor;
			clutter_actor_destroy ((ClutterActor*) _tmp18_);
			_g_object_unref0 (actor);
		}
		_g_object_unref0 (_actor_it);
	}
	_tmp19_ = self->priv->worm_actors;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp19_);
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp20_ = NULL;
		GeeCollection* _tmp21_ = NULL;
		GeeCollection* _tmp22_ = NULL;
		GeeCollection* _tmp23_ = NULL;
		GeeIterator* _tmp24_ = NULL;
		GeeIterator* _tmp25_ = NULL;
		_tmp20_ = self->priv->bonus_actors;
		_tmp21_ = gee_abstract_map_get_values ((GeeMap*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_actor_it = _tmp25_;
		while (TRUE) {
			GeeIterator* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			BonusTexture* actor = NULL;
			GeeIterator* _tmp28_ = NULL;
			gpointer _tmp29_ = NULL;
			BonusTexture* _tmp30_ = NULL;
			_tmp26_ = _actor_it;
			_tmp27_ = gee_iterator_next (_tmp26_);
			if (!_tmp27_) {
				break;
			}
			_tmp28_ = _actor_it;
			_tmp29_ = gee_iterator_get (_tmp28_);
			actor = (BonusTexture*) _tmp29_;
			_tmp30_ = actor;
			clutter_actor_destroy ((ClutterActor*) _tmp30_);
			_g_object_unref0 (actor);
		}
		_g_object_unref0 (_actor_it);
	}
	_tmp31_ = self->priv->bonus_actors;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp31_);
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp32_ = NULL;
		GeeCollection* _tmp33_ = NULL;
		GeeCollection* _tmp34_ = NULL;
		GeeCollection* _tmp35_ = NULL;
		GeeIterator* _tmp36_ = NULL;
		GeeIterator* _tmp37_ = NULL;
		_tmp32_ = self->priv->warp_actors;
		_tmp33_ = gee_abstract_map_get_values ((GeeMap*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_;
		_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
		_tmp37_ = _tmp36_;
		_g_object_unref0 (_tmp35_);
		_actor_it = _tmp37_;
		while (TRUE) {
			GeeIterator* _tmp38_ = NULL;
			gboolean _tmp39_ = FALSE;
			WarpTexture* actor = NULL;
			GeeIterator* _tmp40_ = NULL;
			gpointer _tmp41_ = NULL;
			WarpTexture* _tmp42_ = NULL;
			_tmp38_ = _actor_it;
			_tmp39_ = gee_iterator_next (_tmp38_);
			if (!_tmp39_) {
				break;
			}
			_tmp40_ = _actor_it;
			_tmp41_ = gee_iterator_get (_tmp40_);
			actor = (WarpTexture*) _tmp41_;
			_tmp42_ = actor;
			clutter_actor_destroy ((ClutterActor*) _tmp42_);
			_g_object_unref0 (actor);
		}
		_g_object_unref0 (_actor_it);
	}
	_tmp43_ = self->priv->warp_actors;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp43_);
	_tmp44_ = nibbles_view_get_game (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = nibbles_game_get_boni (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = nibbles_view_get_game (self);
	_tmp49_ = _tmp48_;
	_tmp50_ = nibbles_game_get_numworms (_tmp49_);
	_tmp51_ = _tmp50_;
	boni_reset (_tmp47_, _tmp51_);
	_tmp52_ = nibbles_view_get_game (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = nibbles_game_get_warp_manager (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _tmp55_->warps;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp56_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp57_ = FALSE;
			_tmp57_ = TRUE;
			while (TRUE) {
				gint _tmp59_ = 0;
				FILE* _tmp60_ = NULL;
				gchar* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				if (!_tmp57_) {
					gint _tmp58_ = 0;
					_tmp58_ = i;
					i = _tmp58_ + 1;
				}
				_tmp57_ = FALSE;
				_tmp59_ = i;
				if (!(_tmp59_ < NIBBLES_GAME_HEIGHT)) {
					break;
				}
				_tmp60_ = file;
				_tmp61_ = g_file_stream_read_line (_tmp60_);
				_g_free0 (tmpboard);
				tmpboard = _tmp61_;
				_tmp62_ = tmpboard;
				if (_tmp62_ == NULL) {
					const gchar* _tmp63_ = NULL;
					_tmp63_ = filename;
					g_error ("nibbles-view.vala:218: Level file appears to be damaged: %s", _tmp63_);
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp64_ = FALSE;
						_tmp64_ = TRUE;
						while (TRUE) {
							gint _tmp66_ = 0;
							NibblesGame* _tmp67_ = NULL;
							NibblesGame* _tmp68_ = NULL;
							gint* _tmp69_ = NULL;
							gint _tmp69__length1 = 0;
							gint _tmp69__length2 = 0;
							gint _tmp70_ = 0;
							gint _tmp71_ = 0;
							const gchar* _tmp72_ = NULL;
							gint _tmp73_ = 0;
							gchar _tmp74_ = '\0';
							gint _tmp75_ = 0;
							NibblesGame* _tmp76_ = NULL;
							NibblesGame* _tmp77_ = NULL;
							gint* _tmp78_ = NULL;
							gint _tmp78__length1 = 0;
							gint _tmp78__length2 = 0;
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							gint _tmp81_ = 0;
							if (!_tmp64_) {
								gint _tmp65_ = 0;
								_tmp65_ = j;
								j = _tmp65_ + 1;
							}
							_tmp64_ = FALSE;
							_tmp66_ = j;
							if (!(_tmp66_ < NIBBLES_GAME_WIDTH)) {
								break;
							}
							_tmp67_ = nibbles_view_get_game (self);
							_tmp68_ = _tmp67_;
							_tmp69_ = _tmp68_->board;
							_tmp69__length1 = _tmp68_->board_length1;
							_tmp69__length2 = _tmp68_->board_length2;
							_tmp70_ = j;
							_tmp71_ = i;
							_tmp72_ = tmpboard;
							_tmp73_ = j;
							_tmp74_ = string_get (_tmp72_, (glong) _tmp73_);
							_tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_] = (gint) _tmp74_;
							_tmp75_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
							_tmp76_ = nibbles_view_get_game (self);
							_tmp77_ = _tmp76_;
							_tmp78_ = _tmp77_->board;
							_tmp78__length1 = _tmp77_->board_length1;
							_tmp78__length2 = _tmp77_->board_length2;
							_tmp79_ = j;
							_tmp80_ = i;
							_tmp81_ = _tmp78_[(_tmp79_ * _tmp78__length2) + _tmp80_];
							switch (_tmp81_) {
								case 'm':
								{
									NibblesGame* _tmp82_ = NULL;
									NibblesGame* _tmp83_ = NULL;
									gint* _tmp84_ = NULL;
									gint _tmp84__length1 = 0;
									gint _tmp84__length2 = 0;
									gint _tmp85_ = 0;
									gint _tmp86_ = 0;
									gint _tmp87_ = 0;
									gint _tmp88_ = 0;
									NibblesGame* _tmp89_ = NULL;
									NibblesGame* _tmp90_ = NULL;
									gint _tmp91_ = 0;
									gint _tmp92_ = 0;
									_tmp82_ = nibbles_view_get_game (self);
									_tmp83_ = _tmp82_;
									_tmp84_ = _tmp83_->board;
									_tmp84__length1 = _tmp83_->board_length1;
									_tmp84__length2 = _tmp83_->board_length2;
									_tmp85_ = j;
									_tmp86_ = i;
									_tmp84_[(_tmp85_ * _tmp84__length2) + _tmp86_] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp87_ = _tmp84_[(_tmp85_ * _tmp84__length2) + _tmp86_];
									_tmp88_ = count;
									_tmp89_ = nibbles_view_get_game (self);
									_tmp90_ = _tmp89_;
									_tmp91_ = nibbles_game_get_numworms (_tmp90_);
									_tmp92_ = _tmp91_;
									if (_tmp88_ < _tmp92_) {
										NibblesGame* _tmp93_ = NULL;
										NibblesGame* _tmp94_ = NULL;
										GeeLinkedList* _tmp95_ = NULL;
										GeeLinkedList* _tmp96_ = NULL;
										gint _tmp97_ = 0;
										gpointer _tmp98_ = NULL;
										Worm* _tmp99_ = NULL;
										gint _tmp100_ = 0;
										gint _tmp101_ = 0;
										WormActor* actors = NULL;
										WormActor* _tmp102_ = NULL;
										ClutterStage* _tmp103_ = NULL;
										WormActor* _tmp104_ = NULL;
										GeeHashMap* _tmp105_ = NULL;
										NibblesGame* _tmp106_ = NULL;
										NibblesGame* _tmp107_ = NULL;
										GeeLinkedList* _tmp108_ = NULL;
										GeeLinkedList* _tmp109_ = NULL;
										gint _tmp110_ = 0;
										gpointer _tmp111_ = NULL;
										Worm* _tmp112_ = NULL;
										WormActor* _tmp113_ = NULL;
										gint _tmp114_ = 0;
										_tmp93_ = nibbles_view_get_game (self);
										_tmp94_ = _tmp93_;
										_tmp95_ = nibbles_game_get_worms (_tmp94_);
										_tmp96_ = _tmp95_;
										_tmp97_ = count;
										_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp96_, _tmp97_);
										_tmp99_ = (Worm*) _tmp98_;
										_tmp100_ = j;
										_tmp101_ = i;
										worm_set_start (_tmp99_, _tmp100_, _tmp101_, WORM_DIRECTION_UP);
										_g_object_unref0 (_tmp99_);
										_tmp102_ = worm_actor_new ();
										g_object_ref_sink (_tmp102_);
										actors = _tmp102_;
										_tmp103_ = self->priv->stage;
										_tmp104_ = actors;
										clutter_actor_add_child ((ClutterActor*) _tmp103_, (ClutterActor*) _tmp104_);
										_tmp105_ = self->priv->worm_actors;
										_tmp106_ = nibbles_view_get_game (self);
										_tmp107_ = _tmp106_;
										_tmp108_ = nibbles_game_get_worms (_tmp107_);
										_tmp109_ = _tmp108_;
										_tmp110_ = count;
										_tmp111_ = gee_abstract_list_get ((GeeAbstractList*) _tmp109_, _tmp110_);
										_tmp112_ = (Worm*) _tmp111_;
										_tmp113_ = actors;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp105_, _tmp112_, _tmp113_);
										_g_object_unref0 (_tmp112_);
										_tmp114_ = count;
										count = _tmp114_ + 1;
										_g_object_unref0 (actors);
									}
									break;
								}
								case 'n':
								{
									NibblesGame* _tmp115_ = NULL;
									NibblesGame* _tmp116_ = NULL;
									gint* _tmp117_ = NULL;
									gint _tmp117__length1 = 0;
									gint _tmp117__length2 = 0;
									gint _tmp118_ = 0;
									gint _tmp119_ = 0;
									gint _tmp120_ = 0;
									gint _tmp121_ = 0;
									NibblesGame* _tmp122_ = NULL;
									NibblesGame* _tmp123_ = NULL;
									gint _tmp124_ = 0;
									gint _tmp125_ = 0;
									_tmp115_ = nibbles_view_get_game (self);
									_tmp116_ = _tmp115_;
									_tmp117_ = _tmp116_->board;
									_tmp117__length1 = _tmp116_->board_length1;
									_tmp117__length2 = _tmp116_->board_length2;
									_tmp118_ = j;
									_tmp119_ = i;
									_tmp117_[(_tmp118_ * _tmp117__length2) + _tmp119_] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp120_ = _tmp117_[(_tmp118_ * _tmp117__length2) + _tmp119_];
									_tmp121_ = count;
									_tmp122_ = nibbles_view_get_game (self);
									_tmp123_ = _tmp122_;
									_tmp124_ = nibbles_game_get_numworms (_tmp123_);
									_tmp125_ = _tmp124_;
									if (_tmp121_ < _tmp125_) {
										NibblesGame* _tmp126_ = NULL;
										NibblesGame* _tmp127_ = NULL;
										GeeLinkedList* _tmp128_ = NULL;
										GeeLinkedList* _tmp129_ = NULL;
										gint _tmp130_ = 0;
										gpointer _tmp131_ = NULL;
										Worm* _tmp132_ = NULL;
										gint _tmp133_ = 0;
										gint _tmp134_ = 0;
										WormActor* actors = NULL;
										WormActor* _tmp135_ = NULL;
										ClutterStage* _tmp136_ = NULL;
										WormActor* _tmp137_ = NULL;
										GeeHashMap* _tmp138_ = NULL;
										NibblesGame* _tmp139_ = NULL;
										NibblesGame* _tmp140_ = NULL;
										GeeLinkedList* _tmp141_ = NULL;
										GeeLinkedList* _tmp142_ = NULL;
										gint _tmp143_ = 0;
										gpointer _tmp144_ = NULL;
										Worm* _tmp145_ = NULL;
										WormActor* _tmp146_ = NULL;
										gint _tmp147_ = 0;
										_tmp126_ = nibbles_view_get_game (self);
										_tmp127_ = _tmp126_;
										_tmp128_ = nibbles_game_get_worms (_tmp127_);
										_tmp129_ = _tmp128_;
										_tmp130_ = count;
										_tmp131_ = gee_abstract_list_get ((GeeAbstractList*) _tmp129_, _tmp130_);
										_tmp132_ = (Worm*) _tmp131_;
										_tmp133_ = j;
										_tmp134_ = i;
										worm_set_start (_tmp132_, _tmp133_, _tmp134_, WORM_DIRECTION_LEFT);
										_g_object_unref0 (_tmp132_);
										_tmp135_ = worm_actor_new ();
										g_object_ref_sink (_tmp135_);
										actors = _tmp135_;
										_tmp136_ = self->priv->stage;
										_tmp137_ = actors;
										clutter_actor_add_child ((ClutterActor*) _tmp136_, (ClutterActor*) _tmp137_);
										_tmp138_ = self->priv->worm_actors;
										_tmp139_ = nibbles_view_get_game (self);
										_tmp140_ = _tmp139_;
										_tmp141_ = nibbles_game_get_worms (_tmp140_);
										_tmp142_ = _tmp141_;
										_tmp143_ = count;
										_tmp144_ = gee_abstract_list_get ((GeeAbstractList*) _tmp142_, _tmp143_);
										_tmp145_ = (Worm*) _tmp144_;
										_tmp146_ = actors;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp138_, _tmp145_, _tmp146_);
										_g_object_unref0 (_tmp145_);
										_tmp147_ = count;
										count = _tmp147_ + 1;
										_g_object_unref0 (actors);
									}
									break;
								}
								case 'o':
								{
									NibblesGame* _tmp148_ = NULL;
									NibblesGame* _tmp149_ = NULL;
									gint* _tmp150_ = NULL;
									gint _tmp150__length1 = 0;
									gint _tmp150__length2 = 0;
									gint _tmp151_ = 0;
									gint _tmp152_ = 0;
									gint _tmp153_ = 0;
									gint _tmp154_ = 0;
									NibblesGame* _tmp155_ = NULL;
									NibblesGame* _tmp156_ = NULL;
									gint _tmp157_ = 0;
									gint _tmp158_ = 0;
									_tmp148_ = nibbles_view_get_game (self);
									_tmp149_ = _tmp148_;
									_tmp150_ = _tmp149_->board;
									_tmp150__length1 = _tmp149_->board_length1;
									_tmp150__length2 = _tmp149_->board_length2;
									_tmp151_ = j;
									_tmp152_ = i;
									_tmp150_[(_tmp151_ * _tmp150__length2) + _tmp152_] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp153_ = _tmp150_[(_tmp151_ * _tmp150__length2) + _tmp152_];
									_tmp154_ = count;
									_tmp155_ = nibbles_view_get_game (self);
									_tmp156_ = _tmp155_;
									_tmp157_ = nibbles_game_get_numworms (_tmp156_);
									_tmp158_ = _tmp157_;
									if (_tmp154_ < _tmp158_) {
										NibblesGame* _tmp159_ = NULL;
										NibblesGame* _tmp160_ = NULL;
										GeeLinkedList* _tmp161_ = NULL;
										GeeLinkedList* _tmp162_ = NULL;
										gint _tmp163_ = 0;
										gpointer _tmp164_ = NULL;
										Worm* _tmp165_ = NULL;
										gint _tmp166_ = 0;
										gint _tmp167_ = 0;
										WormActor* actors = NULL;
										WormActor* _tmp168_ = NULL;
										ClutterStage* _tmp169_ = NULL;
										WormActor* _tmp170_ = NULL;
										GeeHashMap* _tmp171_ = NULL;
										NibblesGame* _tmp172_ = NULL;
										NibblesGame* _tmp173_ = NULL;
										GeeLinkedList* _tmp174_ = NULL;
										GeeLinkedList* _tmp175_ = NULL;
										gint _tmp176_ = 0;
										gpointer _tmp177_ = NULL;
										Worm* _tmp178_ = NULL;
										WormActor* _tmp179_ = NULL;
										gint _tmp180_ = 0;
										_tmp159_ = nibbles_view_get_game (self);
										_tmp160_ = _tmp159_;
										_tmp161_ = nibbles_game_get_worms (_tmp160_);
										_tmp162_ = _tmp161_;
										_tmp163_ = count;
										_tmp164_ = gee_abstract_list_get ((GeeAbstractList*) _tmp162_, _tmp163_);
										_tmp165_ = (Worm*) _tmp164_;
										_tmp166_ = j;
										_tmp167_ = i;
										worm_set_start (_tmp165_, _tmp166_, _tmp167_, WORM_DIRECTION_DOWN);
										_g_object_unref0 (_tmp165_);
										_tmp168_ = worm_actor_new ();
										g_object_ref_sink (_tmp168_);
										actors = _tmp168_;
										_tmp169_ = self->priv->stage;
										_tmp170_ = actors;
										clutter_actor_add_child ((ClutterActor*) _tmp169_, (ClutterActor*) _tmp170_);
										_tmp171_ = self->priv->worm_actors;
										_tmp172_ = nibbles_view_get_game (self);
										_tmp173_ = _tmp172_;
										_tmp174_ = nibbles_game_get_worms (_tmp173_);
										_tmp175_ = _tmp174_;
										_tmp176_ = count;
										_tmp177_ = gee_abstract_list_get ((GeeAbstractList*) _tmp175_, _tmp176_);
										_tmp178_ = (Worm*) _tmp177_;
										_tmp179_ = actors;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp171_, _tmp178_, _tmp179_);
										_g_object_unref0 (_tmp178_);
										_tmp180_ = count;
										count = _tmp180_ + 1;
										_g_object_unref0 (actors);
									}
									break;
								}
								case 'p':
								{
									NibblesGame* _tmp181_ = NULL;
									NibblesGame* _tmp182_ = NULL;
									gint* _tmp183_ = NULL;
									gint _tmp183__length1 = 0;
									gint _tmp183__length2 = 0;
									gint _tmp184_ = 0;
									gint _tmp185_ = 0;
									gint _tmp186_ = 0;
									gint _tmp187_ = 0;
									NibblesGame* _tmp188_ = NULL;
									NibblesGame* _tmp189_ = NULL;
									gint _tmp190_ = 0;
									gint _tmp191_ = 0;
									_tmp181_ = nibbles_view_get_game (self);
									_tmp182_ = _tmp181_;
									_tmp183_ = _tmp182_->board;
									_tmp183__length1 = _tmp182_->board_length1;
									_tmp183__length2 = _tmp182_->board_length2;
									_tmp184_ = j;
									_tmp185_ = i;
									_tmp183_[(_tmp184_ * _tmp183__length2) + _tmp185_] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp186_ = _tmp183_[(_tmp184_ * _tmp183__length2) + _tmp185_];
									_tmp187_ = count;
									_tmp188_ = nibbles_view_get_game (self);
									_tmp189_ = _tmp188_;
									_tmp190_ = nibbles_game_get_numworms (_tmp189_);
									_tmp191_ = _tmp190_;
									if (_tmp187_ < _tmp191_) {
										NibblesGame* _tmp192_ = NULL;
										NibblesGame* _tmp193_ = NULL;
										GeeLinkedList* _tmp194_ = NULL;
										GeeLinkedList* _tmp195_ = NULL;
										gint _tmp196_ = 0;
										gpointer _tmp197_ = NULL;
										Worm* _tmp198_ = NULL;
										gint _tmp199_ = 0;
										gint _tmp200_ = 0;
										WormActor* actors = NULL;
										WormActor* _tmp201_ = NULL;
										ClutterStage* _tmp202_ = NULL;
										WormActor* _tmp203_ = NULL;
										GeeHashMap* _tmp204_ = NULL;
										NibblesGame* _tmp205_ = NULL;
										NibblesGame* _tmp206_ = NULL;
										GeeLinkedList* _tmp207_ = NULL;
										GeeLinkedList* _tmp208_ = NULL;
										gint _tmp209_ = 0;
										gpointer _tmp210_ = NULL;
										Worm* _tmp211_ = NULL;
										WormActor* _tmp212_ = NULL;
										gint _tmp213_ = 0;
										_tmp192_ = nibbles_view_get_game (self);
										_tmp193_ = _tmp192_;
										_tmp194_ = nibbles_game_get_worms (_tmp193_);
										_tmp195_ = _tmp194_;
										_tmp196_ = count;
										_tmp197_ = gee_abstract_list_get ((GeeAbstractList*) _tmp195_, _tmp196_);
										_tmp198_ = (Worm*) _tmp197_;
										_tmp199_ = j;
										_tmp200_ = i;
										worm_set_start (_tmp198_, _tmp199_, _tmp200_, WORM_DIRECTION_RIGHT);
										_g_object_unref0 (_tmp198_);
										_tmp201_ = worm_actor_new ();
										g_object_ref_sink (_tmp201_);
										actors = _tmp201_;
										_tmp202_ = self->priv->stage;
										_tmp203_ = actors;
										clutter_actor_add_child ((ClutterActor*) _tmp202_, (ClutterActor*) _tmp203_);
										_tmp204_ = self->priv->worm_actors;
										_tmp205_ = nibbles_view_get_game (self);
										_tmp206_ = _tmp205_;
										_tmp207_ = nibbles_game_get_worms (_tmp206_);
										_tmp208_ = _tmp207_;
										_tmp209_ = count;
										_tmp210_ = gee_abstract_list_get ((GeeAbstractList*) _tmp208_, _tmp209_);
										_tmp211_ = (Worm*) _tmp210_;
										_tmp212_ = actors;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp204_, _tmp211_, _tmp212_);
										_g_object_unref0 (_tmp211_);
										_tmp213_ = count;
										count = _tmp213_ + 1;
										_g_object_unref0 (actors);
									}
									break;
								}
								default:
								{
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	nibbles_view_load_level (self);
	_fclose0 (file);
	_g_free0 (tmpboard);
	_g_free0 (filename);
	_g_free0 (level_name);
}


static void nibbles_view_load_level (NibblesView* self) {
	gint x_pos = 0;
	gint y_pos = 0;
	GtkClutterTexture* tmp = NULL;
	gboolean is_wall = FALSE;
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterStage* _tmp112_ = NULL;
	ClutterActor* _tmp113_ = NULL;
	ClutterActor* _tmp114_ = NULL;
	ClutterActor* _tmp115_ = NULL;
	ClutterActor* _tmp116_ = NULL;
	ClutterActor* _tmp117_ = NULL;
	ClutterActor* _tmp118_ = NULL;
	ClutterActor* _tmp119_ = NULL;
	ClutterActor* _tmp120_ = NULL;
	ClutterActor* _tmp121_ = NULL;
	ClutterActor* _tmp122_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tmp = NULL;
	is_wall = TRUE;
	_tmp0_ = self->priv->level;
	if (_tmp0_ != NULL) {
		ClutterActor* _tmp1_ = NULL;
		ClutterStage* _tmp2_ = NULL;
		ClutterActor* _tmp3_ = NULL;
		_tmp1_ = self->priv->level;
		clutter_actor_remove_all_children (_tmp1_);
		_tmp2_ = self->priv->stage;
		_tmp3_ = self->priv->level;
		clutter_actor_remove_child ((ClutterActor*) _tmp2_, _tmp3_);
	}
	_tmp4_ = clutter_actor_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->level);
	self->priv->level = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				NibblesGame* _tmp9_ = NULL;
				NibblesGame* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < NIBBLES_GAME_HEIGHT)) {
					break;
				}
				_tmp8_ = i;
				_tmp9_ = nibbles_view_get_game (self);
				_tmp10_ = _tmp9_;
				_tmp11_ = nibbles_game_get_tile_size (_tmp10_);
				_tmp12_ = _tmp11_;
				y_pos = _tmp8_ * _tmp12_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gint _tmp15_ = 0;
							gboolean _tmp92_ = FALSE;
							if (!_tmp13_) {
								gint _tmp14_ = 0;
								_tmp14_ = j;
								j = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp15_ = j;
							if (!(_tmp15_ < NIBBLES_GAME_WIDTH)) {
								break;
							}
							is_wall = TRUE;
							{
								NibblesGame* _tmp16_ = NULL;
								NibblesGame* _tmp17_ = NULL;
								gint* _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								gint _tmp18__length2 = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								_tmp16_ = nibbles_view_get_game (self);
								_tmp17_ = _tmp16_;
								_tmp18_ = _tmp17_->board;
								_tmp18__length1 = _tmp17_->board_length1;
								_tmp18__length2 = _tmp17_->board_length2;
								_tmp19_ = j;
								_tmp20_ = i;
								_tmp21_ = _tmp18_[(_tmp19_ * _tmp18__length2) + _tmp20_];
								switch (_tmp21_) {
									case 'a':
									{
										is_wall = FALSE;
										break;
									}
									case 'b':
									{
										GtkClutterTexture* _tmp22_ = NULL;
										GtkClutterTexture* _tmp23_ = NULL;
										GdkPixbuf* _tmp24_ = NULL;
										_tmp22_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp22_);
										_g_object_unref0 (tmp);
										tmp = _tmp22_;
										_tmp23_ = tmp;
										_tmp24_ = self->priv->wall_pixmaps[0];
										gtk_clutter_texture_set_from_pixbuf (_tmp23_, _tmp24_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'c':
									{
										GtkClutterTexture* _tmp25_ = NULL;
										GtkClutterTexture* _tmp26_ = NULL;
										GdkPixbuf* _tmp27_ = NULL;
										_tmp25_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp25_);
										_g_object_unref0 (tmp);
										tmp = _tmp25_;
										_tmp26_ = tmp;
										_tmp27_ = self->priv->wall_pixmaps[1];
										gtk_clutter_texture_set_from_pixbuf (_tmp26_, _tmp27_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'd':
									{
										GtkClutterTexture* _tmp28_ = NULL;
										GtkClutterTexture* _tmp29_ = NULL;
										GdkPixbuf* _tmp30_ = NULL;
										_tmp28_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp28_);
										_g_object_unref0 (tmp);
										tmp = _tmp28_;
										_tmp29_ = tmp;
										_tmp30_ = self->priv->wall_pixmaps[2];
										gtk_clutter_texture_set_from_pixbuf (_tmp29_, _tmp30_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'e':
									{
										GtkClutterTexture* _tmp31_ = NULL;
										GtkClutterTexture* _tmp32_ = NULL;
										GdkPixbuf* _tmp33_ = NULL;
										_tmp31_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp31_);
										_g_object_unref0 (tmp);
										tmp = _tmp31_;
										_tmp32_ = tmp;
										_tmp33_ = self->priv->wall_pixmaps[3];
										gtk_clutter_texture_set_from_pixbuf (_tmp32_, _tmp33_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'f':
									{
										GtkClutterTexture* _tmp34_ = NULL;
										GtkClutterTexture* _tmp35_ = NULL;
										GdkPixbuf* _tmp36_ = NULL;
										_tmp34_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp34_);
										_g_object_unref0 (tmp);
										tmp = _tmp34_;
										_tmp35_ = tmp;
										_tmp36_ = self->priv->wall_pixmaps[4];
										gtk_clutter_texture_set_from_pixbuf (_tmp35_, _tmp36_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'g':
									{
										GtkClutterTexture* _tmp37_ = NULL;
										GtkClutterTexture* _tmp38_ = NULL;
										GdkPixbuf* _tmp39_ = NULL;
										_tmp37_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp37_);
										_g_object_unref0 (tmp);
										tmp = _tmp37_;
										_tmp38_ = tmp;
										_tmp39_ = self->priv->wall_pixmaps[5];
										gtk_clutter_texture_set_from_pixbuf (_tmp38_, _tmp39_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'h':
									{
										GtkClutterTexture* _tmp40_ = NULL;
										GtkClutterTexture* _tmp41_ = NULL;
										GdkPixbuf* _tmp42_ = NULL;
										_tmp40_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp40_);
										_g_object_unref0 (tmp);
										tmp = _tmp40_;
										_tmp41_ = tmp;
										_tmp42_ = self->priv->wall_pixmaps[6];
										gtk_clutter_texture_set_from_pixbuf (_tmp41_, _tmp42_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'i':
									{
										GtkClutterTexture* _tmp43_ = NULL;
										GtkClutterTexture* _tmp44_ = NULL;
										GdkPixbuf* _tmp45_ = NULL;
										_tmp43_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp43_);
										_g_object_unref0 (tmp);
										tmp = _tmp43_;
										_tmp44_ = tmp;
										_tmp45_ = self->priv->wall_pixmaps[7];
										gtk_clutter_texture_set_from_pixbuf (_tmp44_, _tmp45_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'j':
									{
										GtkClutterTexture* _tmp46_ = NULL;
										GtkClutterTexture* _tmp47_ = NULL;
										GdkPixbuf* _tmp48_ = NULL;
										_tmp46_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp46_);
										_g_object_unref0 (tmp);
										tmp = _tmp46_;
										_tmp47_ = tmp;
										_tmp48_ = self->priv->wall_pixmaps[8];
										gtk_clutter_texture_set_from_pixbuf (_tmp47_, _tmp48_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'k':
									{
										GtkClutterTexture* _tmp49_ = NULL;
										GtkClutterTexture* _tmp50_ = NULL;
										GdkPixbuf* _tmp51_ = NULL;
										_tmp49_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp49_);
										_g_object_unref0 (tmp);
										tmp = _tmp49_;
										_tmp50_ = tmp;
										_tmp51_ = self->priv->wall_pixmaps[9];
										gtk_clutter_texture_set_from_pixbuf (_tmp50_, _tmp51_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'l':
									{
										GtkClutterTexture* _tmp52_ = NULL;
										GtkClutterTexture* _tmp53_ = NULL;
										GdkPixbuf* _tmp54_ = NULL;
										_tmp52_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
										g_object_ref_sink (_tmp52_);
										_g_object_unref0 (tmp);
										tmp = _tmp52_;
										_tmp53_ = tmp;
										_tmp54_ = self->priv->wall_pixmaps[10];
										gtk_clutter_texture_set_from_pixbuf (_tmp53_, _tmp54_, &_inner_error_);
										if (G_UNLIKELY (_inner_error_ != NULL)) {
											goto __catch2_g_error;
										}
										break;
									}
									case 'Q':
									case 'R':
									case 'S':
									case 'T':
									case 'U':
									case 'V':
									case 'W':
									case 'X':
									case 'Y':
									case 'Z':
									{
										NibblesGame* _tmp55_ = NULL;
										NibblesGame* _tmp56_ = NULL;
										WarpManager* _tmp57_ = NULL;
										WarpManager* _tmp58_ = NULL;
										NibblesGame* _tmp59_ = NULL;
										NibblesGame* _tmp60_ = NULL;
										gint* _tmp61_ = NULL;
										gint _tmp61__length1 = 0;
										gint _tmp61__length2 = 0;
										gint _tmp62_ = 0;
										gint _tmp63_ = 0;
										NibblesGame* _tmp64_ = NULL;
										NibblesGame* _tmp65_ = NULL;
										gint* _tmp66_ = NULL;
										gint _tmp66__length1 = 0;
										gint _tmp66__length2 = 0;
										gint _tmp67_ = 0;
										gint _tmp68_ = 0;
										gint _tmp69_ = 0;
										is_wall = FALSE;
										_tmp55_ = nibbles_view_get_game (self);
										_tmp56_ = _tmp55_;
										_tmp57_ = nibbles_game_get_warp_manager (_tmp56_);
										_tmp58_ = _tmp57_;
										_tmp59_ = nibbles_view_get_game (self);
										_tmp60_ = _tmp59_;
										_tmp61_ = _tmp60_->board;
										_tmp61__length1 = _tmp60_->board_length1;
										_tmp61__length2 = _tmp60_->board_length2;
										_tmp62_ = j;
										_tmp63_ = i;
										_tmp64_ = nibbles_view_get_game (self);
										_tmp65_ = _tmp64_;
										_tmp66_ = _tmp65_->board;
										_tmp66__length1 = _tmp65_->board_length1;
										_tmp66__length2 = _tmp65_->board_length2;
										_tmp67_ = j;
										_tmp68_ = i;
										_tmp69_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
										warp_manager_add_warp (_tmp58_, _tmp61_, _tmp61__length1, _tmp61__length2, _tmp62_ - 1, _tmp63_ - 1, -_tmp69_, 0);
										break;
									}
									case 'r':
									case 's':
									case 't':
									case 'u':
									case 'v':
									case 'w':
									case 'x':
									case 'y':
									case 'z':
									{
										NibblesGame* _tmp70_ = NULL;
										NibblesGame* _tmp71_ = NULL;
										WarpManager* _tmp72_ = NULL;
										WarpManager* _tmp73_ = NULL;
										NibblesGame* _tmp74_ = NULL;
										NibblesGame* _tmp75_ = NULL;
										gint* _tmp76_ = NULL;
										gint _tmp76__length1 = 0;
										gint _tmp76__length2 = 0;
										NibblesGame* _tmp77_ = NULL;
										NibblesGame* _tmp78_ = NULL;
										gint* _tmp79_ = NULL;
										gint _tmp79__length1 = 0;
										gint _tmp79__length2 = 0;
										gint _tmp80_ = 0;
										gint _tmp81_ = 0;
										gint _tmp82_ = 0;
										gint _tmp83_ = 0;
										gint _tmp84_ = 0;
										NibblesGame* _tmp85_ = NULL;
										NibblesGame* _tmp86_ = NULL;
										gint* _tmp87_ = NULL;
										gint _tmp87__length1 = 0;
										gint _tmp87__length2 = 0;
										gint _tmp88_ = 0;
										gint _tmp89_ = 0;
										gint _tmp90_ = 0;
										is_wall = FALSE;
										_tmp70_ = nibbles_view_get_game (self);
										_tmp71_ = _tmp70_;
										_tmp72_ = nibbles_game_get_warp_manager (_tmp71_);
										_tmp73_ = _tmp72_;
										_tmp74_ = nibbles_view_get_game (self);
										_tmp75_ = _tmp74_;
										_tmp76_ = _tmp75_->board;
										_tmp76__length1 = _tmp75_->board_length1;
										_tmp76__length2 = _tmp75_->board_length2;
										_tmp77_ = nibbles_view_get_game (self);
										_tmp78_ = _tmp77_;
										_tmp79_ = _tmp78_->board;
										_tmp79__length1 = _tmp78_->board_length1;
										_tmp79__length2 = _tmp78_->board_length2;
										_tmp80_ = j;
										_tmp81_ = i;
										_tmp82_ = _tmp79_[(_tmp80_ * _tmp79__length2) + _tmp81_];
										_tmp83_ = j;
										_tmp84_ = i;
										warp_manager_add_warp (_tmp73_, _tmp76_, _tmp76__length1, _tmp76__length2, -((_tmp82_ - 'a') + 'A'), 0, _tmp83_, _tmp84_);
										_tmp85_ = nibbles_view_get_game (self);
										_tmp86_ = _tmp85_;
										_tmp87_ = _tmp86_->board;
										_tmp87__length1 = _tmp86_->board_length1;
										_tmp87__length2 = _tmp86_->board_length2;
										_tmp88_ = j;
										_tmp89_ = i;
										_tmp87_[(_tmp88_ * _tmp87__length2) + _tmp89_] = (gint) NIBBLES_GAME_EMPTYCHAR;
										_tmp90_ = _tmp87_[(_tmp88_ * _tmp87__length2) + _tmp89_];
										break;
									}
									default:
									{
										is_wall = FALSE;
										break;
									}
								}
							}
							goto __finally2;
							__catch2_g_error:
							{
								GError* e = NULL;
								const gchar* _tmp91_ = NULL;
								e = _inner_error_;
								_inner_error_ = NULL;
								_tmp91_ = e->message;
								g_error ("nibbles-view.vala:387: Error loading level: %s", _tmp91_);
								_g_error_free0 (e);
							}
							__finally2:
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								_g_object_unref0 (tmp);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp92_ = is_wall;
							if (_tmp92_) {
								gint _tmp93_ = 0;
								NibblesGame* _tmp94_ = NULL;
								NibblesGame* _tmp95_ = NULL;
								gint _tmp96_ = 0;
								gint _tmp97_ = 0;
								GtkClutterTexture* _tmp98_ = NULL;
								NibblesGame* _tmp99_ = NULL;
								NibblesGame* _tmp100_ = NULL;
								gint _tmp101_ = 0;
								gint _tmp102_ = 0;
								NibblesGame* _tmp103_ = NULL;
								NibblesGame* _tmp104_ = NULL;
								gint _tmp105_ = 0;
								gint _tmp106_ = 0;
								GtkClutterTexture* _tmp107_ = NULL;
								gint _tmp108_ = 0;
								gint _tmp109_ = 0;
								ClutterActor* _tmp110_ = NULL;
								GtkClutterTexture* _tmp111_ = NULL;
								_tmp93_ = j;
								_tmp94_ = nibbles_view_get_game (self);
								_tmp95_ = _tmp94_;
								_tmp96_ = nibbles_game_get_tile_size (_tmp95_);
								_tmp97_ = _tmp96_;
								x_pos = _tmp93_ * _tmp97_;
								_tmp98_ = tmp;
								_tmp99_ = nibbles_view_get_game (self);
								_tmp100_ = _tmp99_;
								_tmp101_ = nibbles_game_get_tile_size (_tmp100_);
								_tmp102_ = _tmp101_;
								_tmp103_ = nibbles_view_get_game (self);
								_tmp104_ = _tmp103_;
								_tmp105_ = nibbles_game_get_tile_size (_tmp104_);
								_tmp106_ = _tmp105_;
								clutter_actor_set_size ((ClutterActor*) _tmp98_, (gfloat) _tmp102_, (gfloat) _tmp106_);
								_tmp107_ = tmp;
								_tmp108_ = x_pos;
								_tmp109_ = y_pos;
								clutter_actor_set_position ((ClutterActor*) _tmp107_, (gfloat) _tmp108_, (gfloat) _tmp109_);
								_tmp110_ = self->priv->level;
								_tmp111_ = tmp;
								clutter_actor_add_child (_tmp110_, (ClutterActor*) _tmp111_);
							}
						}
					}
				}
			}
		}
	}
	_tmp112_ = self->priv->stage;
	_tmp113_ = self->priv->level;
	clutter_actor_add_child ((ClutterActor*) _tmp112_, _tmp113_);
	_tmp114_ = self->priv->level;
	clutter_actor_set_opacity (_tmp114_, (guint8) 0);
	_tmp115_ = self->priv->level;
	clutter_actor_set_scale (_tmp115_, 0.2, 0.2);
	_tmp116_ = self->priv->level;
	clutter_actor_save_easing_state (_tmp116_);
	_tmp117_ = self->priv->level;
	clutter_actor_set_easing_mode (_tmp117_, CLUTTER_EASE_OUT_BOUNCE);
	_tmp118_ = self->priv->level;
	clutter_actor_set_easing_duration (_tmp118_, (guint) (NIBBLES_GAME_GAMEDELAY * NIBBLES_GAME_GAMEDELAY));
	_tmp119_ = self->priv->level;
	clutter_actor_set_scale (_tmp119_, 1.0, 1.0);
	_tmp120_ = self->priv->level;
	clutter_actor_set_pivot_point (_tmp120_, 0.5f, 0.5f);
	_tmp121_ = self->priv->level;
	clutter_actor_set_opacity (_tmp121_, (guint8) 0xff);
	_tmp122_ = self->priv->level;
	clutter_actor_restore_easing_state (_tmp122_);
	_g_object_unref0 (tmp);
}


GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self, const gchar* pixmap, gint xsize, gint ysize) {
	GdkPixbuf* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GdkPixbuf* image = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixmap != NULL, NULL);
	_tmp0_ = pixmap;
	_tmp1_ = g_build_filename (PKGDATADIR, "pixmaps", _tmp0_, NULL, NULL);
	filename = _tmp1_;
	if (filename == NULL) {
		g_error ("nibbles-view.vala:422: Nibbles couldn't find pixmap file: %s", filename);
	}
	image = NULL;
	{
		GdkPixbuf* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GdkPixbuf* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
		_tmp3_ = xsize;
		_tmp4_ = ysize;
		_tmp5_ = gdk_pixbuf_new_from_file_at_scale (filename, _tmp3_, _tmp4_, TRUE, &_inner_error_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp6_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (image);
		image = _tmp6_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("nibbles-view.vala:431: Failed to load pixmap file: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (image);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = image;
	_g_free0 (filename);
	return result;
}


static void nibbles_view_load_pixmap (NibblesView* self) {
	gchar** bonus_files = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint bonus_files_length1 = 0;
	gint _bonus_files_size_ = 0;
	gchar** small_files = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint small_files_length1 = 0;
	gint _small_files_size_ = 0;
	gchar** worm_files = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gint worm_files_length1 = 0;
	gint _worm_files_size_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("bonus1.svg");
	_tmp1_ = g_strdup ("bonus2.svg");
	_tmp2_ = g_strdup ("bonus3.svg");
	_tmp3_ = g_strdup ("life.svg");
	_tmp4_ = g_strdup ("diamond.svg");
	_tmp5_ = g_strdup ("bonus4.svg");
	_tmp6_ = g_strdup ("bonus5.svg");
	_tmp7_ = g_strdup ("questionmark.svg");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	bonus_files = _tmp8_;
	bonus_files_length1 = 8;
	_bonus_files_size_ = bonus_files_length1;
	_tmp9_ = g_strdup ("wall-straight-up.svg");
	_tmp10_ = g_strdup ("wall-straight-side.svg");
	_tmp11_ = g_strdup ("wall-corner-bottom-left.svg");
	_tmp12_ = g_strdup ("wall-corner-bottom-right.svg");
	_tmp13_ = g_strdup ("wall-corner-top-left.svg");
	_tmp14_ = g_strdup ("wall-corner-top-right.svg");
	_tmp15_ = g_strdup ("wall-tee-up.svg");
	_tmp16_ = g_strdup ("wall-tee-right.svg");
	_tmp17_ = g_strdup ("wall-tee-left.svg");
	_tmp18_ = g_strdup ("wall-tee-down.svg");
	_tmp19_ = g_strdup ("wall-cross.svg");
	_tmp20_ = g_new0 (gchar*, 11 + 1);
	_tmp20_[0] = _tmp9_;
	_tmp20_[1] = _tmp10_;
	_tmp20_[2] = _tmp11_;
	_tmp20_[3] = _tmp12_;
	_tmp20_[4] = _tmp13_;
	_tmp20_[5] = _tmp14_;
	_tmp20_[6] = _tmp15_;
	_tmp20_[7] = _tmp16_;
	_tmp20_[8] = _tmp17_;
	_tmp20_[9] = _tmp18_;
	_tmp20_[10] = _tmp19_;
	small_files = _tmp20_;
	small_files_length1 = 11;
	_small_files_size_ = small_files_length1;
	_tmp21_ = g_strdup ("snake-red.svg");
	_tmp22_ = g_strdup ("snake-green.svg");
	_tmp23_ = g_strdup ("snake-blue.svg");
	_tmp24_ = g_strdup ("snake-yellow.svg");
	_tmp25_ = g_strdup ("snake-cyan.svg");
	_tmp26_ = g_strdup ("snake-magenta.svg");
	_tmp27_ = g_new0 (gchar*, 6 + 1);
	_tmp27_[0] = _tmp21_;
	_tmp27_[1] = _tmp22_;
	_tmp27_[2] = _tmp23_;
	_tmp27_[3] = _tmp24_;
	_tmp27_[4] = _tmp25_;
	_tmp27_[5] = _tmp26_;
	worm_files = _tmp27_;
	worm_files_length1 = 6;
	_worm_files_size_ = worm_files_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
				const gchar* _tmp34_ = NULL;
				NibblesGame* _tmp35_ = NULL;
				NibblesGame* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				NibblesGame* _tmp39_ = NULL;
				NibblesGame* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				GdkPixbuf* _tmp43_ = NULL;
				GdkPixbuf* _tmp44_ = NULL;
				if (!_tmp28_) {
					gint _tmp29_ = 0;
					_tmp29_ = i;
					i = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp30_ = i;
				if (!(_tmp30_ < 8)) {
					break;
				}
				_tmp31_ = i;
				_tmp32_ = bonus_files;
				_tmp32__length1 = bonus_files_length1;
				_tmp33_ = i;
				_tmp34_ = _tmp32_[_tmp33_];
				_tmp35_ = nibbles_view_get_game (self);
				_tmp36_ = _tmp35_;
				_tmp37_ = nibbles_game_get_tile_size (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = nibbles_view_get_game (self);
				_tmp40_ = _tmp39_;
				_tmp41_ = nibbles_game_get_tile_size (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = nibbles_view_load_pixmap_file (self, _tmp34_, 2 * _tmp38_, 2 * _tmp42_);
				_g_object_unref0 (self->priv->boni_pixmaps[_tmp31_]);
				self->priv->boni_pixmaps[_tmp31_] = _tmp43_;
				_tmp44_ = self->priv->boni_pixmaps[_tmp31_];
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp45_ = FALSE;
			_tmp45_ = TRUE;
			while (TRUE) {
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				gint _tmp50_ = 0;
				const gchar* _tmp51_ = NULL;
				NibblesGame* _tmp52_ = NULL;
				NibblesGame* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gint _tmp55_ = 0;
				NibblesGame* _tmp56_ = NULL;
				NibblesGame* _tmp57_ = NULL;
				gint _tmp58_ = 0;
				gint _tmp59_ = 0;
				GdkPixbuf* _tmp60_ = NULL;
				GdkPixbuf* _tmp61_ = NULL;
				if (!_tmp45_) {
					gint _tmp46_ = 0;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp45_ = FALSE;
				_tmp47_ = i;
				if (!(_tmp47_ < 11)) {
					break;
				}
				_tmp48_ = i;
				_tmp49_ = small_files;
				_tmp49__length1 = small_files_length1;
				_tmp50_ = i;
				_tmp51_ = _tmp49_[_tmp50_];
				_tmp52_ = nibbles_view_get_game (self);
				_tmp53_ = _tmp52_;
				_tmp54_ = nibbles_game_get_tile_size (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = nibbles_view_get_game (self);
				_tmp57_ = _tmp56_;
				_tmp58_ = nibbles_game_get_tile_size (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = nibbles_view_load_pixmap_file (self, _tmp51_, 2 * _tmp55_, 2 * _tmp59_);
				_g_object_unref0 (self->priv->wall_pixmaps[_tmp48_]);
				self->priv->wall_pixmaps[_tmp48_] = _tmp60_;
				_tmp61_ = self->priv->wall_pixmaps[_tmp48_];
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp62_ = FALSE;
			_tmp62_ = TRUE;
			while (TRUE) {
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				gchar** _tmp66_ = NULL;
				gint _tmp66__length1 = 0;
				gint _tmp67_ = 0;
				const gchar* _tmp68_ = NULL;
				NibblesGame* _tmp69_ = NULL;
				NibblesGame* _tmp70_ = NULL;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				NibblesGame* _tmp73_ = NULL;
				NibblesGame* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				GdkPixbuf* _tmp77_ = NULL;
				GdkPixbuf* _tmp78_ = NULL;
				if (!_tmp62_) {
					gint _tmp63_ = 0;
					_tmp63_ = i;
					i = _tmp63_ + 1;
				}
				_tmp62_ = FALSE;
				_tmp64_ = i;
				if (!(_tmp64_ < 6)) {
					break;
				}
				_tmp65_ = i;
				_tmp66_ = worm_files;
				_tmp66__length1 = worm_files_length1;
				_tmp67_ = i;
				_tmp68_ = _tmp66_[_tmp67_];
				_tmp69_ = nibbles_view_get_game (self);
				_tmp70_ = _tmp69_;
				_tmp71_ = nibbles_game_get_tile_size (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = nibbles_view_get_game (self);
				_tmp74_ = _tmp73_;
				_tmp75_ = nibbles_game_get_tile_size (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = nibbles_view_load_pixmap_file (self, _tmp68_, _tmp72_, _tmp76_);
				_g_object_unref0 (self->priv->worm_pixmaps[_tmp65_]);
				self->priv->worm_pixmaps[_tmp65_] = _tmp77_;
				_tmp78_ = self->priv->worm_pixmaps[_tmp65_];
			}
		}
	}
	worm_files = (_vala_array_free (worm_files, worm_files_length1, (GDestroyNotify) g_free), NULL);
	small_files = (_vala_array_free (small_files, small_files_length1, (GDestroyNotify) g_free), NULL);
	bonus_files = (_vala_array_free (bonus_files, bonus_files_length1, (GDestroyNotify) g_free), NULL);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NibblesView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->worm);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _nibbles_view_worm_added_cb_worm_added (Worm* _sender, gpointer self) {
	nibbles_view_worm_added_cb ((NibblesView*) self, _sender);
}


static void _nibbles_view_worm_finish_added_cb_worm_finish_added (Worm* _sender, gpointer self) {
	nibbles_view_worm_finish_added_cb ((NibblesView*) self, _sender);
}


static void _nibbles_view_worm_moved_cb_worm_moved (Worm* _sender, gpointer self) {
	nibbles_view_worm_moved_cb ((NibblesView*) self, _sender);
}


static void _nibbles_view_worm_rescaled_cb_worm_rescaled (Worm* _sender, gint tile_size, gpointer self) {
	nibbles_view_worm_rescaled_cb ((NibblesView*) self, _sender, tile_size);
}


static void _nibbles_view_worm_died_cb_worm_died (Worm* _sender, gpointer self) {
	nibbles_view_worm_died_cb ((NibblesView*) self, _sender);
}


static void _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced (Worm* _sender, gint erase_size, gpointer self) {
	nibbles_view_worm_tail_reduced_cb ((NibblesView*) self, _sender, erase_size);
}


static void _nibbles_view_worm_reversed_cb_worm_reversed (Worm* _sender, gpointer self) {
	nibbles_view_worm_reversed_cb ((NibblesView*) self, _sender);
}


static void ____lambda5_ (Block6Data* _data6_) {
	NibblesView* self;
	guint8 opacity = 0U;
	gint _tmp0_ = 0;
	Worm* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	WormActor* actors = NULL;
	GeeHashMap* _tmp4_ = NULL;
	Worm* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	self = _data6_->self;
	_tmp1_ = _data6_->worm;
	_tmp2_ = worm_get_is_materialized (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 0xff;
	} else {
		_tmp0_ = 0x50;
	}
	opacity = (guint8) _tmp0_;
	_tmp4_ = self->priv->worm_actors;
	_tmp5_ = _data6_->worm;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
	actors = (WormActor*) _tmp6_;
	clutter_actor_save_easing_state ((ClutterActor*) actors);
	clutter_actor_set_easing_duration ((ClutterActor*) actors, (guint) (NIBBLES_GAME_GAMEDELAY * 10));
	clutter_actor_set_opacity ((ClutterActor*) actors, opacity);
	clutter_actor_restore_easing_state ((ClutterActor*) actors);
	_g_object_unref0 (actors);
}


static void _____lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	____lambda5_ (self);
}


void nibbles_view_connect_worm_signals (NibblesView* self) {
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp0_ = NULL;
		NibblesGame* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _worm_index = 0;
		_tmp0_ = nibbles_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nibbles_game_get_worms (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_worm_list = _tmp4_;
		_tmp5_ = _worm_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_worm_size = _tmp7_;
		_worm_index = -1;
		while (TRUE) {
			Block6Data* _data6_;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			Worm* _tmp14_ = NULL;
			Worm* _tmp15_ = NULL;
			Worm* _tmp16_ = NULL;
			Worm* _tmp17_ = NULL;
			Worm* _tmp18_ = NULL;
			Worm* _tmp19_ = NULL;
			Worm* _tmp20_ = NULL;
			Worm* _tmp21_ = NULL;
			_data6_ = g_slice_new0 (Block6Data);
			_data6_->_ref_count_ = 1;
			_data6_->self = g_object_ref (self);
			_tmp8_ = _worm_index;
			_worm_index = _tmp8_ + 1;
			_tmp9_ = _worm_index;
			_tmp10_ = _worm_size;
			if (!(_tmp9_ < _tmp10_)) {
				block6_data_unref (_data6_);
				_data6_ = NULL;
				break;
			}
			_tmp11_ = _worm_list;
			_tmp12_ = _worm_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			_data6_->worm = (Worm*) _tmp13_;
			_tmp14_ = _data6_->worm;
			g_signal_connect_object (_tmp14_, "added", (GCallback) _nibbles_view_worm_added_cb_worm_added, self, 0);
			_tmp15_ = _data6_->worm;
			g_signal_connect_object (_tmp15_, "finish-added", (GCallback) _nibbles_view_worm_finish_added_cb_worm_finish_added, self, 0);
			_tmp16_ = _data6_->worm;
			g_signal_connect_object (_tmp16_, "moved", (GCallback) _nibbles_view_worm_moved_cb_worm_moved, self, 0);
			_tmp17_ = _data6_->worm;
			g_signal_connect_object (_tmp17_, "rescaled", (GCallback) _nibbles_view_worm_rescaled_cb_worm_rescaled, self, 0);
			_tmp18_ = _data6_->worm;
			g_signal_connect_object (_tmp18_, "died", (GCallback) _nibbles_view_worm_died_cb_worm_died, self, 0);
			_tmp19_ = _data6_->worm;
			g_signal_connect_object (_tmp19_, "tail-reduced", (GCallback) _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced, self, 0);
			_tmp20_ = _data6_->worm;
			g_signal_connect_object (_tmp20_, "reversed", (GCallback) _nibbles_view_worm_reversed_cb_worm_reversed, self, 0);
			_tmp21_ = _data6_->worm;
			g_signal_connect_data ((GObject*) _tmp21_, "notify::is-materialized", (GCallback) _____lambda5__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
			block6_data_unref (_data6_);
			_data6_ = NULL;
		}
		_g_object_unref0 (_worm_list);
	}
}


void nibbles_view_board_rescale (NibblesView* self, gint tile_size) {
	gint board_width = 0;
	gint board_height = 0;
	gfloat x_pos = 0.0F;
	gfloat y_pos = 0.0F;
	ClutterActor* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ClutterActor* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	ClutterActor* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->level;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = tile_size;
	board_width = NIBBLES_GAME_WIDTH * _tmp1_;
	_tmp2_ = tile_size;
	board_height = NIBBLES_GAME_HEIGHT * _tmp2_;
	_tmp3_ = self->priv->level;
	_tmp4_ = clutter_actor_get_children (_tmp3_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor = NULL;
			actor = (ClutterActor*) actor_it->data;
			{
				ClutterActor* _tmp5_ = NULL;
				gfloat _tmp6_ = 0.0F;
				gfloat _tmp7_ = 0.0F;
				ClutterActor* _tmp8_ = NULL;
				gfloat _tmp9_ = 0.0F;
				NibblesGame* _tmp10_ = NULL;
				NibblesGame* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gfloat _tmp15_ = 0.0F;
				NibblesGame* _tmp16_ = NULL;
				NibblesGame* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				ClutterActor* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				_tmp5_ = actor;
				clutter_actor_get_position (_tmp5_, &_tmp6_, &_tmp7_);
				x_pos = _tmp6_;
				y_pos = _tmp7_;
				_tmp8_ = actor;
				_tmp9_ = x_pos;
				_tmp10_ = nibbles_view_get_game (self);
				_tmp11_ = _tmp10_;
				_tmp12_ = nibbles_game_get_tile_size (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = tile_size;
				_tmp15_ = y_pos;
				_tmp16_ = nibbles_view_get_game (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = nibbles_game_get_tile_size (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = tile_size;
				clutter_actor_set_position (_tmp8_, (_tmp9_ / _tmp13_) * _tmp14_, (_tmp15_ / _tmp19_) * _tmp20_);
				_tmp21_ = actor;
				_tmp22_ = tile_size;
				_tmp23_ = tile_size;
				clutter_actor_set_size (_tmp21_, (gfloat) _tmp22_, (gfloat) _tmp23_);
			}
		}
		_g_list_free0 (actor_collection);
	}
	_tmp24_ = self->priv->_name_labels;
	g_object_get (_tmp24_, "visible", &_tmp25_, NULL);
	_tmp26_ = _tmp25_;
	if (!_tmp26_) {
		return;
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp27_ = NULL;
		NibblesGame* _tmp28_ = NULL;
		GeeLinkedList* _tmp29_ = NULL;
		GeeLinkedList* _tmp30_ = NULL;
		GeeLinkedList* _tmp31_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _worm_index = 0;
		_tmp27_ = nibbles_view_get_game (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = nibbles_game_get_worms (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _g_object_ref0 (_tmp30_);
		_worm_list = _tmp31_;
		_tmp32_ = _worm_list;
		_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_worm_size = _tmp34_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gpointer _tmp40_ = NULL;
			ClutterActor* actor = NULL;
			ClutterActor* _tmp41_ = NULL;
			Worm* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			ClutterActor* _tmp45_ = NULL;
			ClutterActor* _tmp46_ = NULL;
			gint middle = 0;
			Worm* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gboolean _tmp50_ = FALSE;
			Worm* _tmp51_ = NULL;
			WormDirection _tmp52_ = 0;
			_tmp35_ = _worm_index;
			_worm_index = _tmp35_ + 1;
			_tmp36_ = _worm_index;
			_tmp37_ = _worm_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _worm_list;
			_tmp39_ = _worm_index;
			_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _tmp39_);
			worm = (Worm*) _tmp40_;
			_tmp41_ = self->priv->_name_labels;
			_tmp42_ = worm;
			_tmp43_ = worm_get_id (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = clutter_actor_get_child_at_index (_tmp41_, _tmp44_);
			_tmp46_ = _g_object_ref0 (_tmp45_);
			actor = _tmp46_;
			_tmp47_ = worm;
			_tmp48_ = worm_get_length (_tmp47_);
			_tmp49_ = _tmp48_;
			middle = _tmp49_ / 2;
			_tmp51_ = worm;
			_tmp52_ = _tmp51_->direction;
			if (_tmp52_ == WORM_DIRECTION_UP) {
				_tmp50_ = TRUE;
			} else {
				Worm* _tmp53_ = NULL;
				WormDirection _tmp54_ = 0;
				_tmp53_ = worm;
				_tmp54_ = _tmp53_->direction;
				_tmp50_ = _tmp54_ == WORM_DIRECTION_DOWN;
			}
			if (_tmp50_) {
				ClutterActor* _tmp55_ = NULL;
				Worm* _tmp56_ = NULL;
				GeeLinkedList* _tmp57_ = NULL;
				GeeLinkedList* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gpointer _tmp60_ = NULL;
				Position* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				gint _tmp63_ = 0;
				ClutterActor* _tmp64_ = NULL;
				gfloat _tmp65_ = 0.0F;
				gfloat _tmp66_ = 0.0F;
				gint _tmp67_ = 0;
				ClutterActor* _tmp68_ = NULL;
				Worm* _tmp69_ = NULL;
				GeeLinkedList* _tmp70_ = NULL;
				GeeLinkedList* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				gpointer _tmp73_ = NULL;
				Position* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				_tmp55_ = actor;
				_tmp56_ = worm;
				_tmp57_ = worm_get_list (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = middle;
				_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _tmp59_);
				_tmp61_ = (Position*) _tmp60_;
				_tmp62_ = (*_tmp61_).x;
				_tmp63_ = tile_size;
				_tmp64_ = actor;
				_tmp65_ = clutter_actor_get_width (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = tile_size;
				clutter_actor_set_x (_tmp55_, ((_tmp62_ * _tmp63_) - (_tmp66_ / 2)) + (_tmp67_ / 2));
				_position_free0 (_tmp61_);
				_tmp68_ = actor;
				_tmp69_ = worm;
				_tmp70_ = worm_get_list (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = middle;
				_tmp73_ = gee_abstract_list_get ((GeeAbstractList*) _tmp71_, _tmp72_);
				_tmp74_ = (Position*) _tmp73_;
				_tmp75_ = (*_tmp74_).y;
				_tmp76_ = tile_size;
				_tmp77_ = tile_size;
				clutter_actor_set_y (_tmp68_, (gfloat) ((_tmp75_ * _tmp76_) - (5 * _tmp77_)));
				_position_free0 (_tmp74_);
			} else {
				gboolean _tmp78_ = FALSE;
				Worm* _tmp79_ = NULL;
				WormDirection _tmp80_ = 0;
				_tmp79_ = worm;
				_tmp80_ = _tmp79_->direction;
				if (_tmp80_ == WORM_DIRECTION_LEFT) {
					_tmp78_ = TRUE;
				} else {
					Worm* _tmp81_ = NULL;
					WormDirection _tmp82_ = 0;
					_tmp81_ = worm;
					_tmp82_ = _tmp81_->direction;
					_tmp78_ = _tmp82_ == WORM_DIRECTION_RIGHT;
				}
				if (_tmp78_) {
					ClutterActor* _tmp83_ = NULL;
					Worm* _tmp84_ = NULL;
					GeeLinkedList* _tmp85_ = NULL;
					GeeLinkedList* _tmp86_ = NULL;
					gint _tmp87_ = 0;
					gpointer _tmp88_ = NULL;
					Position* _tmp89_ = NULL;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					ClutterActor* _tmp92_ = NULL;
					gfloat _tmp93_ = 0.0F;
					gfloat _tmp94_ = 0.0F;
					gint _tmp95_ = 0;
					ClutterActor* _tmp96_ = NULL;
					Worm* _tmp97_ = NULL;
					Position _tmp98_ = {0};
					Position _tmp99_ = {0};
					gint _tmp100_ = 0;
					gint _tmp101_ = 0;
					gint _tmp102_ = 0;
					_tmp83_ = actor;
					_tmp84_ = worm;
					_tmp85_ = worm_get_list (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp87_ = middle;
					_tmp88_ = gee_abstract_list_get ((GeeAbstractList*) _tmp86_, _tmp87_);
					_tmp89_ = (Position*) _tmp88_;
					_tmp90_ = (*_tmp89_).x;
					_tmp91_ = tile_size;
					_tmp92_ = actor;
					_tmp93_ = clutter_actor_get_width (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = tile_size;
					clutter_actor_set_x (_tmp83_, ((_tmp90_ * _tmp91_) - (_tmp94_ / 2)) + (_tmp95_ / 2));
					_position_free0 (_tmp89_);
					_tmp96_ = actor;
					_tmp97_ = worm;
					worm_get_head (_tmp97_, &_tmp98_);
					_tmp99_ = _tmp98_;
					_tmp100_ = _tmp99_.y;
					_tmp101_ = tile_size;
					_tmp102_ = tile_size;
					clutter_actor_set_y (_tmp96_, (gfloat) ((_tmp100_ * _tmp101_) - (3 * _tmp102_)));
				}
			}
			_g_object_unref0 (actor);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
}


static void nibbles_view_animate_end_game_cb (NibblesView* self) {
	ClutterActor* _tmp37_ = NULL;
	ClutterActor* _tmp38_ = NULL;
	ClutterActor* _tmp39_ = NULL;
	ClutterActor* _tmp40_ = NULL;
	ClutterActor* _tmp41_ = NULL;
	ClutterActor* _tmp42_ = NULL;
	ClutterActor* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp0_ = NULL;
		NibblesGame* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		GeeLinkedList* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _worm_index = 0;
		_tmp0_ = nibbles_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nibbles_game_get_worms (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_worm_list = _tmp4_;
		_tmp5_ = _worm_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_worm_size = _tmp7_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			GeeHashMap* _tmp14_ = NULL;
			Worm* _tmp15_ = NULL;
			gpointer _tmp16_ = NULL;
			WormActor* _tmp17_ = NULL;
			_tmp8_ = _worm_index;
			_worm_index = _tmp8_ + 1;
			_tmp9_ = _worm_index;
			_tmp10_ = _worm_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _worm_list;
			_tmp12_ = _worm_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			worm = (Worm*) _tmp13_;
			_tmp14_ = self->priv->worm_actors;
			_tmp15_ = worm;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
			_tmp17_ = (WormActor*) _tmp16_;
			clutter_actor_hide ((ClutterActor*) _tmp17_);
			_g_object_unref0 (_tmp17_);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	{
		GeeLinkedList* _warp_list = NULL;
		NibblesGame* _tmp18_ = NULL;
		NibblesGame* _tmp19_ = NULL;
		WarpManager* _tmp20_ = NULL;
		WarpManager* _tmp21_ = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		GeeLinkedList* _tmp23_ = NULL;
		gint _warp_size = 0;
		GeeLinkedList* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _warp_index = 0;
		_tmp18_ = nibbles_view_get_game (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = nibbles_game_get_warp_manager (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_->warps;
		_tmp23_ = _g_object_ref0 (_tmp22_);
		_warp_list = _tmp23_;
		_tmp24_ = _warp_list;
		_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_warp_size = _tmp26_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			Warp* warp = NULL;
			GeeLinkedList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gpointer _tmp32_ = NULL;
			GeeHashMap* _tmp33_ = NULL;
			Warp* _tmp34_ = NULL;
			gpointer _tmp35_ = NULL;
			WarpTexture* _tmp36_ = NULL;
			_tmp27_ = _warp_index;
			_warp_index = _tmp27_ + 1;
			_tmp28_ = _warp_index;
			_tmp29_ = _warp_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _warp_list;
			_tmp31_ = _warp_index;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
			warp = (Warp*) _tmp32_;
			_tmp33_ = self->priv->warp_actors;
			_tmp34_ = warp;
			_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
			_tmp36_ = (WarpTexture*) _tmp35_;
			clutter_actor_hide ((ClutterActor*) _tmp36_);
			_g_object_unref0 (_tmp36_);
			_g_object_unref0 (warp);
		}
		_g_object_unref0 (_warp_list);
	}
	_tmp37_ = self->priv->level;
	clutter_actor_save_easing_state (_tmp37_);
	_tmp38_ = self->priv->level;
	clutter_actor_set_easing_mode (_tmp38_, CLUTTER_EASE_IN_QUAD);
	_tmp39_ = self->priv->level;
	clutter_actor_set_easing_duration (_tmp39_, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
	_tmp40_ = self->priv->level;
	clutter_actor_set_scale (_tmp40_, (gdouble) 0.4f, (gdouble) 0.4f);
	_tmp41_ = self->priv->level;
	clutter_actor_set_pivot_point (_tmp41_, 0.5f, 0.5f);
	_tmp42_ = self->priv->level;
	clutter_actor_set_opacity (_tmp42_, (guint8) 0);
	_tmp43_ = self->priv->level;
	clutter_actor_restore_easing_state (_tmp43_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void nibbles_view_create_name_labels (NibblesView* self) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	ClutterActor* _tmp124_ = NULL;
	ClutterActor* _tmp125_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	nibbles_view_set_name_labels (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp2_ = NULL;
		NibblesGame* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		GeeLinkedList* _tmp6_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _worm_index = 0;
		_tmp2_ = nibbles_view_get_game (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = nibbles_game_get_worms (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_worm_list = _tmp6_;
		_tmp7_ = _worm_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_worm_size = _tmp9_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			gint color = 0;
			NibblesGame* _tmp16_ = NULL;
			NibblesGame* _tmp17_ = NULL;
			GeeHashMap* _tmp18_ = NULL;
			GeeHashMap* _tmp19_ = NULL;
			Worm* _tmp20_ = NULL;
			gpointer _tmp21_ = NULL;
			WormProperties* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gchar* player_id = NULL;
			const gchar* _tmp25_ = NULL;
			Worm* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gchar* _tmp29_ = NULL;
			ClutterText* label = NULL;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			ClutterText* _tmp34_ = NULL;
			ClutterText* _tmp35_ = NULL;
			ClutterText* _tmp36_ = NULL;
			ClutterText* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			ClutterColor _tmp41_ = {0};
			gint middle = 0;
			Worm* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gboolean _tmp45_ = FALSE;
			Worm* _tmp46_ = NULL;
			WormDirection _tmp47_ = 0;
			ClutterActor* _tmp122_ = NULL;
			ClutterText* _tmp123_ = NULL;
			_tmp10_ = _worm_index;
			_worm_index = _tmp10_ + 1;
			_tmp11_ = _worm_index;
			_tmp12_ = _worm_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _worm_list;
			_tmp14_ = _worm_index;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
			worm = (Worm*) _tmp15_;
			_tmp16_ = nibbles_view_get_game (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = nibbles_game_get_worm_props (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = worm;
			_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
			_tmp22_ = (WormProperties*) _tmp21_;
			_tmp23_ = (*_tmp22_).color;
			_tmp24_ = _tmp23_;
			_worm_properties_free0 (_tmp22_);
			color = _tmp24_;
			_tmp25_ = _ ("Player %d");
			_tmp26_ = worm;
			_tmp27_ = worm_get_id (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup_printf (_tmp25_, _tmp28_ + 1);
			player_id = _tmp29_;
			_tmp30_ = player_id;
			_tmp31_ = string_to_string (_tmp30_);
			_tmp32_ = g_strconcat ("<b>", _tmp31_, "</b>", NULL);
			_tmp33_ = _tmp32_;
			_tmp34_ = (ClutterText*) clutter_text_new_with_text ("Monospace 10", _tmp33_);
			g_object_ref_sink (_tmp34_);
			_tmp35_ = _tmp34_;
			_g_free0 (_tmp33_);
			label = _tmp35_;
			_tmp36_ = label;
			clutter_text_set_use_markup (_tmp36_, TRUE);
			_tmp37_ = label;
			_tmp38_ = color;
			_tmp39_ = nibbles_view_colorval_name (_tmp38_);
			_tmp40_ = _tmp39_;
			clutter_color_from_string (&_tmp41_, _tmp40_);
			clutter_text_set_color (_tmp37_, &_tmp41_);
			_g_free0 (_tmp40_);
			_tmp42_ = worm;
			_tmp43_ = worm_get_length (_tmp42_);
			_tmp44_ = _tmp43_;
			middle = _tmp44_ / 2;
			_tmp46_ = worm;
			_tmp47_ = _tmp46_->direction;
			if (_tmp47_ == WORM_DIRECTION_UP) {
				_tmp45_ = TRUE;
			} else {
				Worm* _tmp48_ = NULL;
				WormDirection _tmp49_ = 0;
				_tmp48_ = worm;
				_tmp49_ = _tmp48_->direction;
				_tmp45_ = _tmp49_ == WORM_DIRECTION_DOWN;
			}
			if (_tmp45_) {
				ClutterText* _tmp50_ = NULL;
				Worm* _tmp51_ = NULL;
				GeeLinkedList* _tmp52_ = NULL;
				GeeLinkedList* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gpointer _tmp55_ = NULL;
				Position* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				NibblesGame* _tmp58_ = NULL;
				NibblesGame* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				ClutterText* _tmp62_ = NULL;
				gfloat _tmp63_ = 0.0F;
				gfloat _tmp64_ = 0.0F;
				NibblesGame* _tmp65_ = NULL;
				NibblesGame* _tmp66_ = NULL;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				ClutterText* _tmp69_ = NULL;
				Worm* _tmp70_ = NULL;
				GeeLinkedList* _tmp71_ = NULL;
				GeeLinkedList* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				gpointer _tmp74_ = NULL;
				Position* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				NibblesGame* _tmp77_ = NULL;
				NibblesGame* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				NibblesGame* _tmp81_ = NULL;
				NibblesGame* _tmp82_ = NULL;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				_tmp50_ = label;
				_tmp51_ = worm;
				_tmp52_ = worm_get_list (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = middle;
				_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _tmp54_);
				_tmp56_ = (Position*) _tmp55_;
				_tmp57_ = (*_tmp56_).x;
				_tmp58_ = nibbles_view_get_game (self);
				_tmp59_ = _tmp58_;
				_tmp60_ = nibbles_game_get_tile_size (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = label;
				_tmp63_ = clutter_actor_get_width ((ClutterActor*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = nibbles_view_get_game (self);
				_tmp66_ = _tmp65_;
				_tmp67_ = nibbles_game_get_tile_size (_tmp66_);
				_tmp68_ = _tmp67_;
				clutter_actor_set_x ((ClutterActor*) _tmp50_, ((_tmp57_ * _tmp61_) - (_tmp64_ / 2)) + (_tmp68_ / 2));
				_position_free0 (_tmp56_);
				_tmp69_ = label;
				_tmp70_ = worm;
				_tmp71_ = worm_get_list (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = middle;
				_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, _tmp73_);
				_tmp75_ = (Position*) _tmp74_;
				_tmp76_ = (*_tmp75_).y;
				_tmp77_ = nibbles_view_get_game (self);
				_tmp78_ = _tmp77_;
				_tmp79_ = nibbles_game_get_tile_size (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = nibbles_view_get_game (self);
				_tmp82_ = _tmp81_;
				_tmp83_ = nibbles_game_get_tile_size (_tmp82_);
				_tmp84_ = _tmp83_;
				clutter_actor_set_y ((ClutterActor*) _tmp69_, (gfloat) ((_tmp76_ * _tmp80_) - (5 * _tmp84_)));
				_position_free0 (_tmp75_);
			} else {
				gboolean _tmp85_ = FALSE;
				Worm* _tmp86_ = NULL;
				WormDirection _tmp87_ = 0;
				_tmp86_ = worm;
				_tmp87_ = _tmp86_->direction;
				if (_tmp87_ == WORM_DIRECTION_LEFT) {
					_tmp85_ = TRUE;
				} else {
					Worm* _tmp88_ = NULL;
					WormDirection _tmp89_ = 0;
					_tmp88_ = worm;
					_tmp89_ = _tmp88_->direction;
					_tmp85_ = _tmp89_ == WORM_DIRECTION_RIGHT;
				}
				if (_tmp85_) {
					ClutterText* _tmp90_ = NULL;
					Worm* _tmp91_ = NULL;
					GeeLinkedList* _tmp92_ = NULL;
					GeeLinkedList* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					gpointer _tmp95_ = NULL;
					Position* _tmp96_ = NULL;
					gint _tmp97_ = 0;
					NibblesGame* _tmp98_ = NULL;
					NibblesGame* _tmp99_ = NULL;
					gint _tmp100_ = 0;
					gint _tmp101_ = 0;
					ClutterText* _tmp102_ = NULL;
					gfloat _tmp103_ = 0.0F;
					gfloat _tmp104_ = 0.0F;
					NibblesGame* _tmp105_ = NULL;
					NibblesGame* _tmp106_ = NULL;
					gint _tmp107_ = 0;
					gint _tmp108_ = 0;
					ClutterText* _tmp109_ = NULL;
					Worm* _tmp110_ = NULL;
					Position _tmp111_ = {0};
					Position _tmp112_ = {0};
					gint _tmp113_ = 0;
					NibblesGame* _tmp114_ = NULL;
					NibblesGame* _tmp115_ = NULL;
					gint _tmp116_ = 0;
					gint _tmp117_ = 0;
					NibblesGame* _tmp118_ = NULL;
					NibblesGame* _tmp119_ = NULL;
					gint _tmp120_ = 0;
					gint _tmp121_ = 0;
					_tmp90_ = label;
					_tmp91_ = worm;
					_tmp92_ = worm_get_list (_tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = middle;
					_tmp95_ = gee_abstract_list_get ((GeeAbstractList*) _tmp93_, _tmp94_);
					_tmp96_ = (Position*) _tmp95_;
					_tmp97_ = (*_tmp96_).x;
					_tmp98_ = nibbles_view_get_game (self);
					_tmp99_ = _tmp98_;
					_tmp100_ = nibbles_game_get_tile_size (_tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = label;
					_tmp103_ = clutter_actor_get_width ((ClutterActor*) _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = nibbles_view_get_game (self);
					_tmp106_ = _tmp105_;
					_tmp107_ = nibbles_game_get_tile_size (_tmp106_);
					_tmp108_ = _tmp107_;
					clutter_actor_set_x ((ClutterActor*) _tmp90_, ((_tmp97_ * _tmp101_) - (_tmp104_ / 2)) + (_tmp108_ / 2));
					_position_free0 (_tmp96_);
					_tmp109_ = label;
					_tmp110_ = worm;
					worm_get_head (_tmp110_, &_tmp111_);
					_tmp112_ = _tmp111_;
					_tmp113_ = _tmp112_.y;
					_tmp114_ = nibbles_view_get_game (self);
					_tmp115_ = _tmp114_;
					_tmp116_ = nibbles_game_get_tile_size (_tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = nibbles_view_get_game (self);
					_tmp119_ = _tmp118_;
					_tmp120_ = nibbles_game_get_tile_size (_tmp119_);
					_tmp121_ = _tmp120_;
					clutter_actor_set_y ((ClutterActor*) _tmp109_, (gfloat) ((_tmp113_ * _tmp117_) - (3 * _tmp121_)));
				}
			}
			_tmp122_ = self->priv->_name_labels;
			_tmp123_ = label;
			clutter_container_add ((ClutterContainer*) _tmp122_, (ClutterActor*) _tmp123_, NULL);
			_g_object_unref0 (label);
			_g_free0 (player_id);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp124_ = self->priv->level;
	_tmp125_ = self->priv->_name_labels;
	clutter_actor_add_child (_tmp124_, _tmp125_);
}


static void nibbles_view_worm_added_cb (NibblesView* self, Worm* worm) {
	GtkClutterTexture* actor = NULL;
	GtkClutterTexture* _tmp0_ = NULL;
	NibblesGame* _tmp12_ = NULL;
	NibblesGame* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	NibblesGame* _tmp16_ = NULL;
	NibblesGame* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Worm* _tmp20_ = NULL;
	GeeLinkedList* _tmp21_ = NULL;
	GeeLinkedList* _tmp22_ = NULL;
	gpointer _tmp23_ = NULL;
	Position* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	NibblesGame* _tmp26_ = NULL;
	NibblesGame* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	Worm* _tmp30_ = NULL;
	GeeLinkedList* _tmp31_ = NULL;
	GeeLinkedList* _tmp32_ = NULL;
	gpointer _tmp33_ = NULL;
	Position* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	NibblesGame* _tmp36_ = NULL;
	NibblesGame* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	WormActor* actors = NULL;
	GeeHashMap* _tmp40_ = NULL;
	Worm* _tmp41_ = NULL;
	gpointer _tmp42_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
	g_object_ref_sink (_tmp0_);
	actor = _tmp0_;
	{
		NibblesGame* _tmp1_ = NULL;
		NibblesGame* _tmp2_ = NULL;
		GeeHashMap* _tmp3_ = NULL;
		GeeHashMap* _tmp4_ = NULL;
		Worm* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		WormProperties* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		GdkPixbuf* _tmp9_ = NULL;
		_tmp1_ = nibbles_view_get_game (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = nibbles_game_get_worm_props (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = worm;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		_tmp7_ = (WormProperties*) _tmp6_;
		_tmp8_ = (*_tmp7_).color;
		_tmp9_ = self->priv->worm_pixmaps[_tmp8_];
		gtk_clutter_texture_set_from_pixbuf (actor, _tmp9_, &_inner_error_);
		_worm_properties_free0 (_tmp7_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch4_clutter_texture_error;
			}
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e->message;
		g_error ("nibbles-view.vala:620: Nibbles failed to set texture: %s", _tmp10_);
		_g_error_free0 (e);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e->message;
		g_error ("nibbles-view.vala:624: Nibbles failed to set texture: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (actor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = nibbles_view_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = nibbles_game_get_tile_size (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = nibbles_view_get_game (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = nibbles_game_get_tile_size (_tmp17_);
	_tmp19_ = _tmp18_;
	clutter_actor_set_size ((ClutterActor*) actor, (gfloat) _tmp15_, (gfloat) _tmp19_);
	_tmp20_ = worm;
	_tmp21_ = worm_get_list (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gee_linked_list_first (_tmp22_);
	_tmp24_ = (Position*) _tmp23_;
	_tmp25_ = (*_tmp24_).x;
	_tmp26_ = nibbles_view_get_game (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = nibbles_game_get_tile_size (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = worm;
	_tmp31_ = worm_get_list (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = gee_linked_list_first (_tmp32_);
	_tmp34_ = (Position*) _tmp33_;
	_tmp35_ = (*_tmp34_).y;
	_tmp36_ = nibbles_view_get_game (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = nibbles_game_get_tile_size (_tmp37_);
	_tmp39_ = _tmp38_;
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp25_ * _tmp29_), (gfloat) (_tmp35_ * _tmp39_));
	_position_free0 (_tmp34_);
	_position_free0 (_tmp24_);
	_tmp40_ = self->priv->worm_actors;
	_tmp41_ = worm;
	_tmp42_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp40_, _tmp41_);
	actors = (WormActor*) _tmp42_;
	clutter_actor_add_child ((ClutterActor*) actors, (ClutterActor*) actor);
	_g_object_unref0 (actors);
	_g_object_unref0 (actor);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		NibblesView* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->worm);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static gboolean __lambda4_ (Block7Data* _data7_) {
	NibblesView* self;
	gboolean result = FALSE;
	Worm* _tmp0_ = NULL;
	self = _data7_->self;
	_tmp0_ = _data7_->worm;
	_tmp0_->is_stopped = FALSE;
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
	return result;
}


static void nibbles_view_worm_finish_added_cb (NibblesView* self, Worm* worm) {
	Block7Data* _data7_;
	Worm* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	WormActor* actors = NULL;
	GeeHashMap* _tmp2_ = NULL;
	Worm* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	Worm* _tmp5_ = NULL;
	NibblesGame* _tmp6_ = NULL;
	NibblesGame* _tmp7_ = NULL;
	gint* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = worm;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data7_->worm);
	_data7_->worm = _tmp1_;
	_tmp2_ = self->priv->worm_actors;
	_tmp3_ = _data7_->worm;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
	actors = (WormActor*) _tmp4_;
	clutter_actor_set_opacity ((ClutterActor*) actors, (guint8) 0);
	clutter_actor_set_scale ((ClutterActor*) actors, 3.0, 3.0);
	clutter_actor_save_easing_state ((ClutterActor*) actors);
	clutter_actor_set_easing_mode ((ClutterActor*) actors, CLUTTER_EASE_OUT);
	clutter_actor_set_easing_duration ((ClutterActor*) actors, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
	clutter_actor_set_scale ((ClutterActor*) actors, 1.0, 1.0);
	clutter_actor_set_pivot_point ((ClutterActor*) actors, 0.5f, 0.5f);
	clutter_actor_set_opacity ((ClutterActor*) actors, (guint8) 0xff);
	clutter_actor_restore_easing_state ((ClutterActor*) actors);
	_tmp5_ = _data7_->worm;
	_tmp6_ = nibbles_view_get_game (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->board;
	_tmp8__length1 = _tmp7_->board_length1;
	_tmp8__length2 = _tmp7_->board_length2;
	worm_dematerialize (_tmp5_, _tmp8_, _tmp8__length1, _tmp8__length2, 3);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_GAMEDELAY * 27), ___lambda4__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	_g_object_unref0 (actors);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void nibbles_view_worm_moved_cb (NibblesView* self, Worm* worm) {
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	ClutterActor* tail_actor = NULL;
	ClutterActor* _tmp3_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	Worm* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->worm_actors;
	_tmp1_ = worm;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	actors = (WormActor*) _tmp2_;
	_tmp3_ = clutter_actor_get_first_child ((ClutterActor*) actors);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	tail_actor = _tmp5_;
	clutter_actor_remove_child ((ClutterActor*) actors, tail_actor);
	_tmp6_ = worm;
	nibbles_view_worm_added_cb (self, _tmp6_);
	_g_object_unref0 (tail_actor);
	_g_object_unref0 (actors);
}


static void nibbles_view_worm_rescaled_cb (NibblesView* self, Worm* worm, gint tile_size) {
	gfloat x_pos = 0.0F;
	gfloat y_pos = 0.0F;
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	WormActor* _tmp3_ = NULL;
	WormActor* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->worm_actors;
	_tmp1_ = worm;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	actors = (WormActor*) _tmp2_;
	_tmp3_ = actors;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (actors);
		return;
	}
	_tmp4_ = actors;
	_tmp5_ = clutter_actor_get_children ((ClutterActor*) _tmp4_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp5_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor = NULL;
			actor = (ClutterActor*) actor_it->data;
			{
				ClutterActor* _tmp6_ = NULL;
				gfloat _tmp7_ = 0.0F;
				gfloat _tmp8_ = 0.0F;
				ClutterActor* _tmp9_ = NULL;
				gfloat _tmp10_ = 0.0F;
				NibblesGame* _tmp11_ = NULL;
				NibblesGame* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gfloat _tmp16_ = 0.0F;
				NibblesGame* _tmp17_ = NULL;
				NibblesGame* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				ClutterActor* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				_tmp6_ = actor;
				clutter_actor_get_position (_tmp6_, &_tmp7_, &_tmp8_);
				x_pos = _tmp7_;
				y_pos = _tmp8_;
				_tmp9_ = actor;
				_tmp10_ = x_pos;
				_tmp11_ = nibbles_view_get_game (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = tile_size;
				_tmp16_ = y_pos;
				_tmp17_ = nibbles_view_get_game (self);
				_tmp18_ = _tmp17_;
				_tmp19_ = nibbles_game_get_tile_size (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = tile_size;
				clutter_actor_set_position (_tmp9_, (_tmp10_ / _tmp14_) * _tmp15_, (_tmp16_ / _tmp20_) * _tmp21_);
				_tmp22_ = actor;
				_tmp23_ = tile_size;
				_tmp24_ = tile_size;
				clutter_actor_set_size (_tmp22_, (gfloat) _tmp23_, (gfloat) _tmp24_);
			}
		}
		_g_list_free0 (actor_collection);
	}
	_g_object_unref0 (actors);
}


static void nibbles_view_worm_died_cb (NibblesView* self, Worm* worm) {
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* group = NULL;
	ClutterActor* _tmp0_ = NULL;
	WormActor* actors = NULL;
	GeeHashMap* _tmp1_ = NULL;
	Worm* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	WormActor* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	WormActor* _tmp38_ = NULL;
	ClutterActor* _tmp39_ = NULL;
	ClutterActor* _tmp40_ = NULL;
	ClutterActor* _tmp41_ = NULL;
	ClutterActor* _tmp42_ = NULL;
	ClutterActor* _tmp43_ = NULL;
	ClutterActor* _tmp44_ = NULL;
	ClutterActor* _tmp45_ = NULL;
	ClutterActor* _tmp46_ = NULL;
	ClutterActor* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	_tmp1_ = self->priv->worm_actors;
	_tmp2_ = worm;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	actors = (WormActor*) _tmp3_;
	_tmp4_ = actors;
	_tmp5_ = clutter_actor_get_children ((ClutterActor*) _tmp4_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp5_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor = NULL;
			actor = (ClutterActor*) actor_it->data;
			{
				GtkClutterTexture* texture = NULL;
				GtkClutterTexture* _tmp6_ = NULL;
				gint color = 0;
				NibblesGame* _tmp7_ = NULL;
				NibblesGame* _tmp8_ = NULL;
				GeeHashMap* _tmp9_ = NULL;
				GeeHashMap* _tmp10_ = NULL;
				Worm* _tmp11_ = NULL;
				gpointer _tmp12_ = NULL;
				WormProperties* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				ClutterActor* _tmp21_ = NULL;
				gfloat _tmp22_ = 0.0F;
				gfloat _tmp23_ = 0.0F;
				GtkClutterTexture* _tmp24_ = NULL;
				gfloat _tmp25_ = 0.0F;
				gfloat _tmp26_ = 0.0F;
				GtkClutterTexture* _tmp27_ = NULL;
				NibblesGame* _tmp28_ = NULL;
				NibblesGame* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				NibblesGame* _tmp32_ = NULL;
				NibblesGame* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				ClutterActor* _tmp36_ = NULL;
				GtkClutterTexture* _tmp37_ = NULL;
				_tmp6_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
				g_object_ref_sink (_tmp6_);
				texture = _tmp6_;
				_tmp7_ = nibbles_view_get_game (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = nibbles_game_get_worm_props (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = worm;
				_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
				_tmp13_ = (WormProperties*) _tmp12_;
				_tmp14_ = (*_tmp13_).color;
				_tmp15_ = _tmp14_;
				_worm_properties_free0 (_tmp13_);
				color = _tmp15_;
				{
					GtkClutterTexture* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					GdkPixbuf* _tmp18_ = NULL;
					_tmp16_ = texture;
					_tmp17_ = color;
					_tmp18_ = self->priv->worm_pixmaps[_tmp17_];
					gtk_clutter_texture_set_from_pixbuf (_tmp16_, _tmp18_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch5_clutter_texture_error;
						}
						goto __catch5_g_error;
					}
				}
				goto __finally5;
				__catch5_clutter_texture_error:
				{
					GError* e = NULL;
					const gchar* _tmp19_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp19_ = e->message;
					g_error ("nibbles-view.vala:696: Nibbles failed to set texture: %s", _tmp19_);
					_g_error_free0 (e);
				}
				goto __finally5;
				__catch5_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp20_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp20_ = e->message;
					g_error ("nibbles-view.vala:700: Nibbles failed to set texture: %s", _tmp20_);
					_g_error_free0 (e);
				}
				__finally5:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (texture);
					_g_list_free0 (actor_collection);
					_g_object_unref0 (actors);
					_g_object_unref0 (group);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp21_ = actor;
				clutter_actor_get_position (_tmp21_, &_tmp22_, &_tmp23_);
				x = _tmp22_;
				y = _tmp23_;
				_tmp24_ = texture;
				_tmp25_ = x;
				_tmp26_ = y;
				clutter_actor_set_position ((ClutterActor*) _tmp24_, _tmp25_, _tmp26_);
				_tmp27_ = texture;
				_tmp28_ = nibbles_view_get_game (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = nibbles_game_get_tile_size (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = nibbles_view_get_game (self);
				_tmp33_ = _tmp32_;
				_tmp34_ = nibbles_game_get_tile_size (_tmp33_);
				_tmp35_ = _tmp34_;
				clutter_actor_set_size ((ClutterActor*) _tmp27_, (gfloat) _tmp31_, (gfloat) _tmp35_);
				_tmp36_ = group;
				_tmp37_ = texture;
				clutter_actor_add_child (_tmp36_, (ClutterActor*) _tmp37_);
				_g_object_unref0 (texture);
			}
		}
		_g_list_free0 (actor_collection);
	}
	_tmp38_ = actors;
	clutter_actor_remove_all_children ((ClutterActor*) _tmp38_);
	_tmp39_ = self->priv->level;
	_tmp40_ = group;
	clutter_actor_add_child (_tmp39_, _tmp40_);
	_tmp41_ = group;
	clutter_actor_save_easing_state (_tmp41_);
	_tmp42_ = group;
	clutter_actor_set_easing_mode (_tmp42_, CLUTTER_EASE_OUT_QUAD);
	_tmp43_ = group;
	clutter_actor_set_easing_duration (_tmp43_, (guint) (NIBBLES_GAME_GAMEDELAY * 9));
	_tmp44_ = group;
	clutter_actor_set_scale (_tmp44_, (gdouble) 2.0f, (gdouble) 2.0f);
	_tmp45_ = group;
	clutter_actor_set_pivot_point (_tmp45_, 0.5f, 0.5f);
	_tmp46_ = group;
	clutter_actor_set_opacity (_tmp46_, (guint8) 0);
	_tmp47_ = group;
	clutter_actor_restore_easing_state (_tmp47_);
	nibbles_view_play_sound (self, "crash");
	_g_object_unref0 (actors);
	_g_object_unref0 (group);
}


static void nibbles_view_worm_tail_reduced_cb (NibblesView* self, Worm* worm, gint erase_size) {
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* group = NULL;
	ClutterActor* _tmp0_ = NULL;
	WormActor* worm_actors = NULL;
	GeeHashMap* _tmp1_ = NULL;
	Worm* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	gint color = 0;
	NibblesGame* _tmp4_ = NULL;
	NibblesGame* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	Worm* _tmp8_ = NULL;
	gpointer _tmp9_ = NULL;
	WormProperties* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	ClutterActor* _tmp46_ = NULL;
	ClutterActor* _tmp47_ = NULL;
	ClutterActor* _tmp48_ = NULL;
	ClutterActor* _tmp49_ = NULL;
	ClutterActor* _tmp50_ = NULL;
	ClutterActor* _tmp51_ = NULL;
	ClutterActor* _tmp52_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	_tmp1_ = self->priv->worm_actors;
	_tmp2_ = worm;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	worm_actors = (WormActor*) _tmp3_;
	_tmp4_ = nibbles_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = nibbles_game_get_worm_props (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = worm;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
	_tmp10_ = (WormProperties*) _tmp9_;
	_tmp11_ = (*_tmp10_).color;
	_tmp12_ = _tmp11_;
	_worm_properties_free0 (_tmp10_);
	color = _tmp12_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				GtkClutterTexture* texture = NULL;
				GtkClutterTexture* _tmp17_ = NULL;
				WormActor* _tmp23_ = NULL;
				ClutterActor* _tmp24_ = NULL;
				ClutterActor* _tmp25_ = NULL;
				gfloat _tmp26_ = 0.0F;
				gfloat _tmp27_ = 0.0F;
				WormActor* _tmp28_ = NULL;
				WormActor* _tmp29_ = NULL;
				ClutterActor* _tmp30_ = NULL;
				ClutterActor* _tmp31_ = NULL;
				GtkClutterTexture* _tmp32_ = NULL;
				gfloat _tmp33_ = 0.0F;
				gfloat _tmp34_ = 0.0F;
				GtkClutterTexture* _tmp35_ = NULL;
				NibblesGame* _tmp36_ = NULL;
				NibblesGame* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				NibblesGame* _tmp40_ = NULL;
				NibblesGame* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				ClutterActor* _tmp44_ = NULL;
				GtkClutterTexture* _tmp45_ = NULL;
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = i;
				_tmp16_ = erase_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
				g_object_ref_sink (_tmp17_);
				texture = _tmp17_;
				{
					GtkClutterTexture* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					GdkPixbuf* _tmp20_ = NULL;
					_tmp18_ = texture;
					_tmp19_ = color;
					_tmp20_ = self->priv->worm_pixmaps[_tmp19_];
					gtk_clutter_texture_set_from_pixbuf (_tmp18_, _tmp20_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch6_clutter_texture_error;
						}
						goto __catch6_g_error;
					}
				}
				goto __finally6;
				__catch6_clutter_texture_error:
				{
					GError* e = NULL;
					const gchar* _tmp21_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp21_ = e->message;
					g_error ("nibbles-view.vala:740: Nibbles failed to set texture: %s", _tmp21_);
					_g_error_free0 (e);
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp22_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp22_ = e->message;
					g_error ("nibbles-view.vala:744: Nibbles failed to set texture: %s", _tmp22_);
					_g_error_free0 (e);
				}
				__finally6:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (texture);
					_g_object_unref0 (worm_actors);
					_g_object_unref0 (group);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp23_ = worm_actors;
				_tmp24_ = clutter_actor_get_first_child ((ClutterActor*) _tmp23_);
				_tmp25_ = _tmp24_;
				clutter_actor_get_position (_tmp25_, &_tmp26_, &_tmp27_);
				x = _tmp26_;
				y = _tmp27_;
				_tmp28_ = worm_actors;
				_tmp29_ = worm_actors;
				_tmp30_ = clutter_actor_get_first_child ((ClutterActor*) _tmp29_);
				_tmp31_ = _tmp30_;
				clutter_actor_remove_child ((ClutterActor*) _tmp28_, _tmp31_);
				_tmp32_ = texture;
				_tmp33_ = x;
				_tmp34_ = y;
				clutter_actor_set_position ((ClutterActor*) _tmp32_, _tmp33_, _tmp34_);
				_tmp35_ = texture;
				_tmp36_ = nibbles_view_get_game (self);
				_tmp37_ = _tmp36_;
				_tmp38_ = nibbles_game_get_tile_size (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = nibbles_view_get_game (self);
				_tmp41_ = _tmp40_;
				_tmp42_ = nibbles_game_get_tile_size (_tmp41_);
				_tmp43_ = _tmp42_;
				clutter_actor_set_size ((ClutterActor*) _tmp35_, (gfloat) _tmp39_, (gfloat) _tmp43_);
				_tmp44_ = group;
				_tmp45_ = texture;
				clutter_actor_add_child (_tmp44_, (ClutterActor*) _tmp45_);
				_g_object_unref0 (texture);
			}
		}
	}
	_tmp46_ = self->priv->level;
	_tmp47_ = group;
	clutter_actor_add_child (_tmp46_, _tmp47_);
	_tmp48_ = group;
	clutter_actor_save_easing_state (_tmp48_);
	_tmp49_ = group;
	clutter_actor_set_easing_mode (_tmp49_, CLUTTER_EASE_OUT_EXPO);
	_tmp50_ = group;
	clutter_actor_set_easing_duration (_tmp50_, (guint) (NIBBLES_GAME_GAMEDELAY * 25));
	_tmp51_ = group;
	clutter_actor_set_opacity (_tmp51_, (guint8) 0);
	_tmp52_ = group;
	clutter_actor_restore_easing_state (_tmp52_);
	_g_object_unref0 (worm_actors);
	_g_object_unref0 (group);
}


static void nibbles_view_worm_reversed_cb (NibblesView* self, Worm* worm) {
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	gint count = 0;
	WormActor* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->worm_actors;
	_tmp1_ = worm;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	actors = (WormActor*) _tmp2_;
	count = 0;
	_tmp3_ = actors;
	_tmp4_ = clutter_actor_get_children ((ClutterActor*) _tmp3_);
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor = NULL;
			actor = (ClutterActor*) actor_it->data;
			{
				ClutterActor* _tmp5_ = NULL;
				Worm* _tmp6_ = NULL;
				GeeLinkedList* _tmp7_ = NULL;
				GeeLinkedList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gpointer _tmp10_ = NULL;
				Position* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				NibblesGame* _tmp13_ = NULL;
				NibblesGame* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				Worm* _tmp17_ = NULL;
				GeeLinkedList* _tmp18_ = NULL;
				GeeLinkedList* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gpointer _tmp21_ = NULL;
				Position* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				NibblesGame* _tmp24_ = NULL;
				NibblesGame* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				_tmp5_ = actor;
				_tmp6_ = worm;
				_tmp7_ = worm_get_list (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = count;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
				_tmp11_ = (Position*) _tmp10_;
				_tmp12_ = (*_tmp11_).x;
				_tmp13_ = nibbles_view_get_game (self);
				_tmp14_ = _tmp13_;
				_tmp15_ = nibbles_game_get_tile_size (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = worm;
				_tmp18_ = worm_get_list (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = count;
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
				_tmp22_ = (Position*) _tmp21_;
				_tmp23_ = (*_tmp22_).y;
				_tmp24_ = nibbles_view_get_game (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = nibbles_game_get_tile_size (_tmp25_);
				_tmp27_ = _tmp26_;
				clutter_actor_set_position (_tmp5_, (gfloat) (_tmp12_ * _tmp16_), (gfloat) (_tmp23_ * _tmp27_));
				_position_free0 (_tmp22_);
				_position_free0 (_tmp11_);
				_tmp28_ = count;
				count = _tmp28_ + 1;
			}
		}
		_g_list_free0 (actor_collection);
	}
	_g_object_unref0 (actors);
}


static void nibbles_view_bonus_added_cb (NibblesView* self) {
	Bonus* bonus = NULL;
	NibblesGame* _tmp0_ = NULL;
	NibblesGame* _tmp1_ = NULL;
	Boni* _tmp2_ = NULL;
	Boni* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	BonusTexture* actor = NULL;
	BonusTexture* _tmp6_ = NULL;
	NibblesGame* _tmp11_ = NULL;
	NibblesGame* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	NibblesGame* _tmp15_ = NULL;
	NibblesGame* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	NibblesGame* _tmp20_ = NULL;
	NibblesGame* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	NibblesGame* _tmp25_ = NULL;
	NibblesGame* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	ClutterActor* _tmp29_ = NULL;
	BonusType _tmp30_ = 0;
	GeeHashMap* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = nibbles_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = nibbles_game_get_boni (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->bonuses;
	_tmp5_ = gee_linked_list_last (_tmp4_);
	bonus = (Bonus*) _tmp5_;
	_tmp6_ = bonus_texture_new ();
	g_object_ref_sink (_tmp6_);
	actor = _tmp6_;
	{
		BonusType _tmp7_ = 0;
		GdkPixbuf* _tmp8_ = NULL;
		_tmp7_ = bonus->type;
		_tmp8_ = self->priv->boni_pixmaps[_tmp7_];
		gtk_clutter_texture_set_from_pixbuf ((GtkClutterTexture*) actor, _tmp8_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch7_clutter_texture_error;
			}
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e->message;
		g_error ("nibbles-view.vala:790: Nibbles failed to set texture: %s", _tmp9_);
		_g_error_free0 (e);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e->message;
		g_error ("nibbles-view.vala:794: Nibbles failed to set texture: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (actor);
		_g_object_unref0 (bonus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = nibbles_view_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = nibbles_view_get_game (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = nibbles_game_get_tile_size (_tmp16_);
	_tmp18_ = _tmp17_;
	bonus_texture_set_size (actor, (gfloat) _tmp14_, (gfloat) _tmp18_);
	_tmp19_ = bonus->x;
	_tmp20_ = nibbles_view_get_game (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = nibbles_game_get_tile_size (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = bonus->y;
	_tmp25_ = nibbles_view_get_game (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = nibbles_game_get_tile_size (_tmp26_);
	_tmp28_ = _tmp27_;
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp19_ * _tmp23_), (gfloat) (_tmp24_ * _tmp28_));
	_tmp29_ = self->priv->level;
	clutter_actor_add_child (_tmp29_, (ClutterActor*) actor);
	_tmp30_ = bonus->type;
	if (_tmp30_ != BONUS_TYPE_REGULAR) {
		nibbles_view_play_sound (self, "appear");
	}
	_tmp31_ = self->priv->bonus_actors;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, bonus, actor);
	_g_object_unref0 (actor);
	_g_object_unref0 (bonus);
}


static void nibbles_view_bonus_removed_cb (NibblesView* self, Bonus* bonus) {
	BonusTexture* bonus_actor = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Bonus* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	Bonus* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	_tmp0_ = self->priv->bonus_actors;
	_tmp1_ = bonus;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	bonus_actor = (BonusTexture*) _tmp2_;
	_tmp3_ = self->priv->bonus_actors;
	_tmp4_ = bonus;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, _tmp4_, NULL);
	clutter_actor_hide ((ClutterActor*) bonus_actor);
	_tmp5_ = self->priv->level;
	clutter_actor_remove_child (_tmp5_, (ClutterActor*) bonus_actor);
	_g_object_unref0 (bonus_actor);
}


static void nibbles_view_bonus_applied_cb (NibblesView* self, Bonus* bonus, Worm* worm) {
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	ClutterActor* actor = NULL;
	WormActor* _tmp3_ = NULL;
	ClutterActor* _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	ClutterActor* _tmp6_ = NULL;
	ClutterActor* _tmp7_ = NULL;
	ClutterActor* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	ClutterActor* _tmp11_ = NULL;
	ClutterActor* _tmp12_ = NULL;
	Bonus* _tmp13_ = NULL;
	BonusType _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->worm_actors;
	_tmp1_ = worm;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	actors = (WormActor*) _tmp2_;
	_tmp3_ = actors;
	_tmp4_ = clutter_actor_get_last_child ((ClutterActor*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	actor = _tmp6_;
	_tmp7_ = actor;
	clutter_actor_save_easing_state (_tmp7_);
	_tmp8_ = actor;
	clutter_actor_set_easing_mode (_tmp8_, CLUTTER_EASE_OUT_QUINT);
	_tmp9_ = actor;
	clutter_actor_set_easing_duration (_tmp9_, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
	_tmp10_ = actor;
	clutter_actor_set_scale (_tmp10_, (gdouble) 1.45f, (gdouble) 1.45f);
	_tmp11_ = actor;
	clutter_actor_set_pivot_point (_tmp11_, 0.5f, 0.5f);
	_tmp12_ = actor;
	clutter_actor_restore_easing_state (_tmp12_);
	_tmp13_ = bonus;
	_tmp14_ = _tmp13_->type;
	switch (_tmp14_) {
		case BONUS_TYPE_REGULAR:
		{
			nibbles_view_play_sound (self, "gobble");
			break;
		}
		case BONUS_TYPE_DOUBLE:
		{
			nibbles_view_play_sound (self, "bonus");
			break;
		}
		case BONUS_TYPE_HALF:
		{
			nibbles_view_play_sound (self, "bonus");
			break;
		}
		case BONUS_TYPE_LIFE:
		{
			nibbles_view_play_sound (self, "life");
			break;
		}
		case BONUS_TYPE_REVERSE:
		{
			nibbles_view_play_sound (self, "reverse");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_g_object_unref0 (actor);
	_g_object_unref0 (actors);
}


void nibbles_view_boni_rescale (NibblesView* self, gint tile_size) {
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _bonus_list = NULL;
		NibblesGame* _tmp0_ = NULL;
		NibblesGame* _tmp1_ = NULL;
		Boni* _tmp2_ = NULL;
		Boni* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _bonus_index = 0;
		_tmp0_ = nibbles_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nibbles_game_get_boni (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->bonuses;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_bonus_list = _tmp5_;
		_tmp6_ = _bonus_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_bonus_size = _tmp8_;
		_bonus_index = -1;
		while (TRUE) {
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			BonusTexture* actor = NULL;
			GeeHashMap* _tmp15_ = NULL;
			Bonus* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			BonusTexture* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp9_ = _bonus_index;
			_bonus_index = _tmp9_ + 1;
			_tmp10_ = _bonus_index;
			_tmp11_ = _bonus_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _bonus_list;
			_tmp13_ = _bonus_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			bonus = (Bonus*) _tmp14_;
			_tmp15_ = self->priv->bonus_actors;
			_tmp16_ = bonus;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
			actor = (BonusTexture*) _tmp17_;
			_tmp18_ = actor;
			_tmp19_ = tile_size;
			_tmp20_ = tile_size;
			bonus_texture_set_size (_tmp18_, (gfloat) _tmp19_, (gfloat) _tmp20_);
			_g_object_unref0 (actor);
			_g_object_unref0 (bonus);
		}
		_g_object_unref0 (_bonus_list);
	}
}


static void nibbles_view_warp_added_cb (NibblesView* self, Warp* warp) {
	WarpTexture* actor = NULL;
	WarpTexture* _tmp0_ = NULL;
	NibblesGame* _tmp4_ = NULL;
	NibblesGame* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	NibblesGame* _tmp8_ = NULL;
	NibblesGame* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Warp* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	NibblesGame* _tmp14_ = NULL;
	NibblesGame* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Warp* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	NibblesGame* _tmp20_ = NULL;
	NibblesGame* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	ClutterActor* _tmp24_ = NULL;
	GeeHashMap* _tmp25_ = NULL;
	Warp* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (warp != NULL);
	_tmp0_ = warp_texture_new ();
	g_object_ref_sink (_tmp0_);
	actor = _tmp0_;
	{
		GdkPixbuf* _tmp1_ = NULL;
		_tmp1_ = self->priv->boni_pixmaps[BONUS_TYPE_WARP];
		gtk_clutter_texture_set_from_pixbuf ((GtkClutterTexture*) actor, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch8_clutter_texture_error;
			}
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e->message;
		g_error ("nibbles-view.vala:871: Nibbles failed to set texture: %s", _tmp2_);
		_g_error_free0 (e);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		g_error ("nibbles-view.vala:875: Nibbles failed to set texture: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (actor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = nibbles_view_get_game (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = nibbles_game_get_tile_size (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = nibbles_view_get_game (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = nibbles_game_get_tile_size (_tmp9_);
	_tmp11_ = _tmp10_;
	warp_texture_set_size (actor, (gfloat) _tmp7_, (gfloat) _tmp11_);
	_tmp12_ = warp;
	_tmp13_ = _tmp12_->x;
	_tmp14_ = nibbles_view_get_game (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = nibbles_game_get_tile_size (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = warp;
	_tmp19_ = _tmp18_->y;
	_tmp20_ = nibbles_view_get_game (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = nibbles_game_get_tile_size (_tmp21_);
	_tmp23_ = _tmp22_;
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (_tmp13_ * _tmp17_), (gfloat) (_tmp19_ * _tmp23_));
	_tmp24_ = self->priv->level;
	clutter_actor_add_child (_tmp24_, (ClutterActor*) actor);
	_tmp25_ = self->priv->warp_actors;
	_tmp26_ = warp;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp26_, actor);
	_g_object_unref0 (actor);
}


void nibbles_view_warps_rescale (NibblesView* self, gint tile_size) {
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _warp_list = NULL;
		NibblesGame* _tmp0_ = NULL;
		NibblesGame* _tmp1_ = NULL;
		WarpManager* _tmp2_ = NULL;
		WarpManager* _tmp3_ = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _warp_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _warp_index = 0;
		_tmp0_ = nibbles_view_get_game (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nibbles_game_get_warp_manager (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->warps;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_warp_list = _tmp5_;
		_tmp6_ = _warp_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_warp_size = _tmp8_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			Warp* warp = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			WarpTexture* actor = NULL;
			GeeHashMap* _tmp15_ = NULL;
			Warp* _tmp16_ = NULL;
			gpointer _tmp17_ = NULL;
			WarpTexture* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp9_ = _warp_index;
			_warp_index = _tmp9_ + 1;
			_tmp10_ = _warp_index;
			_tmp11_ = _warp_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _warp_list;
			_tmp13_ = _warp_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			warp = (Warp*) _tmp14_;
			_tmp15_ = self->priv->warp_actors;
			_tmp16_ = warp;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
			actor = (WarpTexture*) _tmp17_;
			_tmp18_ = actor;
			_tmp19_ = tile_size;
			_tmp20_ = tile_size;
			warp_texture_set_size (_tmp18_, (gfloat) _tmp19_, (gfloat) _tmp20_);
			_g_object_unref0 (actor);
			_g_object_unref0 (warp);
		}
		_g_object_unref0 (_warp_list);
	}
}


static void nibbles_view_play_sound (NibblesView* self, const gchar* name) {
	gboolean _tmp0_ = FALSE;
	gchar* filename = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->is_muted;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat (_tmp2_, ".ogg", NULL);
	filename = _tmp3_;
	_tmp4_ = filename;
	_tmp5_ = g_build_filename (SOUND_DIRECTORY, _tmp4_, NULL, NULL);
	path = _tmp5_;
	_tmp6_ = name;
	_tmp7_ = path;
	ca_gtk_play_for_widget ((GtkWidget*) self, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp6_, CA_PROP_MEDIA_FILENAME, _tmp7_, NULL);
	_g_free0 (path);
	_g_free0 (filename);
}


gint nibbles_view_colorval_from_name (const gchar* name) {
	gint result = 0;
	g_return_val_if_fail (name != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp4_ = 0;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < NIBBLES_VIEW_NUM_COLORS)) {
					break;
				}
				_tmp3_ = nibbles_view_color_lookup;
				_tmp3__length1 = nibbles_view_color_lookup_length1;
				_tmp4_ = i;
				_tmp5_ = _tmp3_[_tmp4_];
				_tmp6_ = name;
				if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
					result = i;
					return result;
				}
			}
		}
	}
	result = 0;
	return result;
}


gchar* nibbles_view_colorval_name (gint colorval) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = nibbles_view_color_lookup;
	_tmp0__length1 = nibbles_view_color_lookup_length1;
	_tmp1_ = colorval;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


ClutterActor* nibbles_view_get_name_labels (NibblesView* self) {
	ClutterActor* result;
	ClutterActor* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name_labels;
	result = _tmp0_;
	return result;
}


static void nibbles_view_set_name_labels (NibblesView* self, ClutterActor* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_name_labels);
	self->priv->_name_labels = _tmp1_;
	g_object_notify ((GObject *) self, "name-labels");
}


NibblesGame* nibbles_view_get_game (NibblesView* self) {
	NibblesGame* result;
	NibblesGame* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void _nibbles_view_bonus_added_cb_boni_bonus_added (Boni* _sender, gpointer self) {
	nibbles_view_bonus_added_cb ((NibblesView*) self);
}


static void _nibbles_view_bonus_removed_cb_boni_bonus_removed (Boni* _sender, Bonus* bonus, gpointer self) {
	nibbles_view_bonus_removed_cb ((NibblesView*) self, bonus);
}


static void _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied (NibblesGame* _sender, Bonus* bonus, Worm* worm, gpointer self) {
	nibbles_view_bonus_applied_cb ((NibblesView*) self, bonus, worm);
}


static void _nibbles_view_warp_added_cb_warp_manager_warp_added (WarpManager* _sender, Warp* warp, gpointer self) {
	nibbles_view_warp_added_cb ((NibblesView*) self, warp);
}


static void _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game (NibblesGame* _sender, gpointer self) {
	nibbles_view_animate_end_game_cb ((NibblesView*) self);
}


void nibbles_view_set_game (NibblesView* self, NibblesGame* value) {
	NibblesGame* _tmp0_ = NULL;
	NibblesGame* _tmp2_ = NULL;
	NibblesGame* _tmp3_ = NULL;
	NibblesGame* _tmp4_ = NULL;
	Boni* _tmp5_ = NULL;
	Boni* _tmp6_ = NULL;
	NibblesGame* _tmp7_ = NULL;
	Boni* _tmp8_ = NULL;
	Boni* _tmp9_ = NULL;
	NibblesGame* _tmp10_ = NULL;
	NibblesGame* _tmp11_ = NULL;
	WarpManager* _tmp12_ = NULL;
	WarpManager* _tmp13_ = NULL;
	NibblesGame* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		NibblesGame* _tmp1_ = NULL;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp3_;
	_tmp4_ = self->priv->_game;
	_tmp5_ = nibbles_game_get_boni (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_connect_object (_tmp6_, "bonus-added", (GCallback) _nibbles_view_bonus_added_cb_boni_bonus_added, self, 0);
	_tmp7_ = self->priv->_game;
	_tmp8_ = nibbles_game_get_boni (_tmp7_);
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "bonus-removed", (GCallback) _nibbles_view_bonus_removed_cb_boni_bonus_removed, self, 0);
	_tmp10_ = self->priv->_game;
	g_signal_connect_object (_tmp10_, "bonus-applied", (GCallback) _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied, self, 0);
	_tmp11_ = self->priv->_game;
	_tmp12_ = nibbles_game_get_warp_manager (_tmp11_);
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "warp-added", (GCallback) _nibbles_view_warp_added_cb_warp_manager_warp_added, self, 0);
	_tmp14_ = self->priv->_game;
	g_signal_connect_object (_tmp14_, "animate-end-game", (GCallback) _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game, self, 0);
	g_object_notify ((GObject *) self, "game");
}


static void nibbles_view_class_init (NibblesViewClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	nibbles_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NibblesViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = nibbles_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_VIEW_NAME_LABELS, g_param_spec_object ("name-labels", "name-labels", "name-labels", clutter_actor_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_NIBBLES_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_strdup ("red");
	_tmp1_ = g_strdup ("green");
	_tmp2_ = g_strdup ("blue");
	_tmp3_ = g_strdup ("yellow");
	_tmp4_ = g_strdup ("cyan");
	_tmp5_ = g_strdup ("purple");
	_tmp6_ = g_new0 (gchar*, 6 + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	nibbles_view_color_lookup = _tmp6_;
	nibbles_view_color_lookup_length1 = 6;
}


static void nibbles_view_instance_init (NibblesView * self) {
	self->priv = NIBBLES_VIEW_GET_PRIVATE (self);
}


static void nibbles_view_finalize (GObject* obj) {
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_VIEW, NibblesView);
	_vala_array_destroy (self->priv->wall_pixmaps, 11, (GDestroyNotify) g_object_unref);
	_vala_array_destroy (self->priv->worm_pixmaps, 6, (GDestroyNotify) g_object_unref);
	_vala_array_destroy (self->priv->boni_pixmaps, 9, (GDestroyNotify) g_object_unref);
	_g_object_unref0 (self->priv->stage);
	_g_object_unref0 (self->priv->level);
	_g_object_unref0 (self->priv->_name_labels);
	_g_object_unref0 (self->priv->worm_actors);
	_g_object_unref0 (self->priv->bonus_actors);
	_g_object_unref0 (self->priv->warp_actors);
	_g_object_unref0 (self->priv->_game);
	G_OBJECT_CLASS (nibbles_view_parent_class)->finalize (obj);
}


GType nibbles_view_get_type (void) {
	static volatile gsize nibbles_view_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesView), 0, (GInstanceInitFunc) nibbles_view_instance_init, NULL };
		GType nibbles_view_type_id;
		nibbles_view_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "NibblesView", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_view_type_id__volatile, nibbles_view_type_id);
	}
	return nibbles_view_type_id__volatile;
}


static void _vala_nibbles_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_VIEW, NibblesView);
	switch (property_id) {
		case NIBBLES_VIEW_NAME_LABELS:
		g_value_set_object (value, nibbles_view_get_name_labels (self));
		break;
		case NIBBLES_VIEW_GAME:
		g_value_set_object (value, nibbles_view_get_game (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_nibbles_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_VIEW, NibblesView);
	switch (property_id) {
		case NIBBLES_VIEW_NAME_LABELS:
		nibbles_view_set_name_labels (self, g_value_get_object (value));
		break;
		case NIBBLES_VIEW_GAME:
		nibbles_view_set_game (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



