/* preferences-dialog.c generated by valac 0.44.6, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Gabriel Ivascu <ivascu.gabriel59@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkApplicationWindow* window;
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkNotebook* notebook;
	GtkRadioButton* beginner_radio_button;
	GtkRadioButton* slow_radio_button;
	GtkRadioButton* medium_radio_button;
	GtkRadioButton* fast_radio_button;
	GtkCheckButton* sound_check_button;
	GtkCheckButton* fakes_check_button;
	GtkListStore* list_store_1;
	GtkListStore* list_store_2;
	GtkListStore* list_store_3;
	GtkListStore* list_store_4;
	GtkTreeView* tree_view_1;
	GtkTreeView* tree_view_2;
	GtkTreeView* tree_view_3;
	GtkTreeView* tree_view_4;
	GtkComboBoxText* combo_box_1;
	GtkComboBoxText* combo_box_2;
	GtkComboBoxText* combo_box_3;
	GtkComboBoxText* combo_box_4;
	GeeArrayList* radio_buttons;
	GeeArrayList* list_stores;
	GeeArrayList* tree_views;
	GeeArrayList* combo_boxes;
};

static gint PreferencesDialog_private_offset;
static gpointer preferences_dialog_parent_class = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
PreferencesDialog* preferences_dialog_new (GtkApplicationWindow* window,
                                           GSettings* settings,
                                           GeeArrayList* worm_settings);
PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GtkApplicationWindow* window,
                                                 GSettings* settings,
                                                 GeeArrayList* worm_settings);
static void __lambda4_ (PreferencesDialog* self);
static void ___lambda4__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
#define NIBBLES_GAME_MAX_SPEED 4
static void preferences_dialog_radio_button_toggled_cb (PreferencesDialog* self,
                                                 GtkToggleButton* button);
static void _preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                            gpointer self);
static void preferences_dialog_sound_toggled_cb (PreferencesDialog* self);
static void _preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
static void preferences_dialog_fakes_toggles_cb (PreferencesDialog* self);
static void _preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
static void preferences_dialog_accel_edited_cb (PreferencesDialog* self,
                                         GtkCellRendererAccel* cell,
                                         const gchar* path_string,
                                         guint keyval,
                                         GdkModifierType mask,
                                         guint hardware_keycode);
static void _preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender,
                                                                               const gchar* path_string,
                                                                               guint accel_key,
                                                                               GdkModifierType accel_mods,
                                                                               guint hardware_keycode,
                                                                               gpointer self);
static void preferences_dialog_accel_cleared_cb (PreferencesDialog* self,
                                          GtkCellRendererAccel* cell,
                                          const gchar* path_string);
static void _preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender,
                                                                                 const gchar* path_string,
                                                                                 gpointer self);
#define NIBBLES_VIEW_NUM_COLORS 6
gchar* nibbles_view_colorval_name (gint colorval);
static void preferences_dialog_combo_box_changed_cb (PreferencesDialog* self,
                                              GtkComboBox* combo_box);
static void _preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
#define NIBBLES_GAME_MAX_HUMANS 4
#define NIBBLES_GAME_MAX_WORMS 6
static void preferences_dialog_finalize (GObject * obj);

static inline gpointer
preferences_dialog_get_instance_private (PreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PreferencesDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 75 "preferences-dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 156 "preferences-dialog.c"
}

static void
__lambda4_ (PreferencesDialog* self)
{
#line 80 "preferences-dialog.vala"
	gtk_widget_destroy ((GtkWidget*) self);
#line 164 "preferences-dialog.c"
}

static void
___lambda4__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
#line 79 "preferences-dialog.vala"
	__lambda4_ ((PreferencesDialog*) self);
#line 174 "preferences-dialog.c"
}

static void
_preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self)
{
#line 96 "preferences-dialog.vala"
	preferences_dialog_radio_button_toggled_cb ((PreferencesDialog*) self, _sender);
#line 183 "preferences-dialog.c"
}

static void
_preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
#line 101 "preferences-dialog.vala"
	preferences_dialog_sound_toggled_cb ((PreferencesDialog*) self);
#line 192 "preferences-dialog.c"
}

static void
_preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
#line 105 "preferences-dialog.vala"
	preferences_dialog_fakes_toggles_cb ((PreferencesDialog*) self);
#line 201 "preferences-dialog.c"
}

static void
_preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender,
                                                                          const gchar* path_string,
                                                                          guint accel_key,
                                                                          GdkModifierType accel_mods,
                                                                          guint hardware_keycode,
                                                                          gpointer self)
{
#line 145 "preferences-dialog.vala"
	preferences_dialog_accel_edited_cb ((PreferencesDialog*) self, _sender, path_string, accel_key, accel_mods, hardware_keycode);
#line 214 "preferences-dialog.c"
}

static void
_preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender,
                                                                            const gchar* path_string,
                                                                            gpointer self)
{
#line 146 "preferences-dialog.vala"
	preferences_dialog_accel_cleared_cb ((PreferencesDialog*) self, _sender, path_string);
#line 224 "preferences-dialog.c"
}

static void
_preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self)
{
#line 167 "preferences-dialog.vala"
	preferences_dialog_combo_box_changed_cb ((PreferencesDialog*) self, _sender);
#line 233 "preferences-dialog.c"
}

PreferencesDialog*
preferences_dialog_construct (GType object_type,
                              GtkApplicationWindow* window,
                              GSettings* settings,
                              GeeArrayList* worm_settings)
{
	PreferencesDialog * self = NULL;
	GSettings* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GtkRadioButton* _tmp5_;
	GeeArrayList* _tmp6_;
	GtkRadioButton* _tmp7_;
	GeeArrayList* _tmp8_;
	GtkRadioButton* _tmp9_;
	GeeArrayList* _tmp10_;
	GtkRadioButton* _tmp11_;
	GtkCheckButton* _tmp23_;
	GtkCheckButton* _tmp24_;
	GtkCheckButton* _tmp25_;
	GtkCheckButton* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	GtkTreeView* _tmp29_;
	GeeArrayList* _tmp30_;
	GtkTreeView* _tmp31_;
	GeeArrayList* _tmp32_;
	GtkTreeView* _tmp33_;
	GeeArrayList* _tmp34_;
	GtkTreeView* _tmp35_;
	GeeArrayList* _tmp36_;
	GeeArrayList* _tmp37_;
	GtkListStore* _tmp38_;
	GeeArrayList* _tmp39_;
	GtkListStore* _tmp40_;
	GeeArrayList* _tmp41_;
	GtkListStore* _tmp42_;
	GeeArrayList* _tmp43_;
	GtkListStore* _tmp44_;
	GeeArrayList* _tmp91_;
	GeeArrayList* _tmp92_;
	GtkComboBoxText* _tmp93_;
	GeeArrayList* _tmp94_;
	GtkComboBoxText* _tmp95_;
	GeeArrayList* _tmp96_;
	GtkComboBoxText* _tmp97_;
	GeeArrayList* _tmp98_;
	GtkComboBoxText* _tmp99_;
#line 71 "preferences-dialog.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 71 "preferences-dialog.vala"
	g_return_val_if_fail (settings != NULL, NULL);
#line 71 "preferences-dialog.vala"
	g_return_val_if_fail (worm_settings != NULL, NULL);
#line 73 "preferences-dialog.vala"
	self = (PreferencesDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
#line 75 "preferences-dialog.vala"
	_tmp0_ = _g_object_ref0 (settings);
#line 75 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->settings);
#line 75 "preferences-dialog.vala"
	self->priv->settings = _tmp0_;
#line 76 "preferences-dialog.vala"
	_tmp1_ = _g_object_ref0 (worm_settings);
#line 76 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 76 "preferences-dialog.vala"
	self->priv->worm_settings = _tmp1_;
#line 77 "preferences-dialog.vala"
	_tmp2_ = _g_object_ref0 (window);
#line 77 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->window);
#line 77 "preferences-dialog.vala"
	self->priv->window = _tmp2_;
#line 79 "preferences-dialog.vala"
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda4__gtk_dialog_response, self, 0);
#line 83 "preferences-dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) window);
#line 86 "preferences-dialog.vala"
	_tmp3_ = gee_array_list_new (gtk_radio_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 86 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->radio_buttons);
#line 86 "preferences-dialog.vala"
	self->priv->radio_buttons = _tmp3_;
#line 87 "preferences-dialog.vala"
	_tmp4_ = self->priv->radio_buttons;
#line 87 "preferences-dialog.vala"
	_tmp5_ = self->priv->beginner_radio_button;
#line 87 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
#line 88 "preferences-dialog.vala"
	_tmp6_ = self->priv->radio_buttons;
#line 88 "preferences-dialog.vala"
	_tmp7_ = self->priv->slow_radio_button;
#line 88 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
#line 89 "preferences-dialog.vala"
	_tmp8_ = self->priv->radio_buttons;
#line 89 "preferences-dialog.vala"
	_tmp9_ = self->priv->medium_radio_button;
#line 89 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
#line 90 "preferences-dialog.vala"
	_tmp10_ = self->priv->radio_buttons;
#line 90 "preferences-dialog.vala"
	_tmp11_ = self->priv->fast_radio_button;
#line 90 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
#line 346 "preferences-dialog.c"
	{
		GeeArrayList* _radio_button_list = NULL;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _radio_button_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _radio_button_index = 0;
#line 92 "preferences-dialog.vala"
		_tmp12_ = self->priv->radio_buttons;
#line 92 "preferences-dialog.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 92 "preferences-dialog.vala"
		_radio_button_list = _tmp13_;
#line 92 "preferences-dialog.vala"
		_tmp14_ = _radio_button_list;
#line 92 "preferences-dialog.vala"
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
#line 92 "preferences-dialog.vala"
		_tmp16_ = _tmp15_;
#line 92 "preferences-dialog.vala"
		_radio_button_size = _tmp16_;
#line 92 "preferences-dialog.vala"
		_radio_button_index = -1;
#line 92 "preferences-dialog.vala"
		while (TRUE) {
#line 374 "preferences-dialog.c"
			GtkRadioButton* radio_button = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			gint speed = 0;
			GeeArrayList* _tmp19_;
			GtkRadioButton* _tmp20_;
			GtkRadioButton* _tmp21_;
			GtkRadioButton* _tmp22_;
#line 92 "preferences-dialog.vala"
			_radio_button_index = _radio_button_index + 1;
#line 92 "preferences-dialog.vala"
			if (!(_radio_button_index < _radio_button_size)) {
#line 92 "preferences-dialog.vala"
				break;
#line 389 "preferences-dialog.c"
			}
#line 92 "preferences-dialog.vala"
			_tmp17_ = _radio_button_list;
#line 92 "preferences-dialog.vala"
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _radio_button_index);
#line 92 "preferences-dialog.vala"
			radio_button = (GtkRadioButton*) _tmp18_;
#line 94 "preferences-dialog.vala"
			_tmp19_ = self->priv->radio_buttons;
#line 94 "preferences-dialog.vala"
			_tmp20_ = radio_button;
#line 94 "preferences-dialog.vala"
			speed = NIBBLES_GAME_MAX_SPEED - gee_abstract_list_index_of ((GeeAbstractList*) _tmp19_, _tmp20_);
#line 95 "preferences-dialog.vala"
			_tmp21_ = radio_button;
#line 95 "preferences-dialog.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp21_, speed == g_settings_get_int (settings, "speed"));
#line 96 "preferences-dialog.vala"
			_tmp22_ = radio_button;
#line 96 "preferences-dialog.vala"
			g_signal_connect_object ((GtkToggleButton*) _tmp22_, "toggled", (GCallback) _preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled, self, 0);
#line 92 "preferences-dialog.vala"
			_g_object_unref0 (radio_button);
#line 413 "preferences-dialog.c"
		}
#line 92 "preferences-dialog.vala"
		_g_object_unref0 (_radio_button_list);
#line 417 "preferences-dialog.c"
	}
#line 100 "preferences-dialog.vala"
	_tmp23_ = self->priv->sound_check_button;
#line 100 "preferences-dialog.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp23_, g_settings_get_boolean (settings, "sound"));
#line 101 "preferences-dialog.vala"
	_tmp24_ = self->priv->sound_check_button;
#line 101 "preferences-dialog.vala"
	g_signal_connect_object ((GtkToggleButton*) _tmp24_, "toggled", (GCallback) _preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled, self, 0);
#line 104 "preferences-dialog.vala"
	_tmp25_ = self->priv->fakes_check_button;
#line 104 "preferences-dialog.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp25_, g_settings_get_boolean (settings, "fakes"));
#line 105 "preferences-dialog.vala"
	_tmp26_ = self->priv->fakes_check_button;
#line 105 "preferences-dialog.vala"
	g_signal_connect_object ((GtkToggleButton*) _tmp26_, "toggled", (GCallback) _preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled, self, 0);
#line 108 "preferences-dialog.vala"
	_tmp27_ = gee_array_list_new (gtk_tree_view_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 108 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_views);
#line 108 "preferences-dialog.vala"
	self->priv->tree_views = _tmp27_;
#line 109 "preferences-dialog.vala"
	_tmp28_ = self->priv->tree_views;
#line 109 "preferences-dialog.vala"
	_tmp29_ = self->priv->tree_view_1;
#line 109 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
#line 110 "preferences-dialog.vala"
	_tmp30_ = self->priv->tree_views;
#line 110 "preferences-dialog.vala"
	_tmp31_ = self->priv->tree_view_2;
#line 110 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
#line 111 "preferences-dialog.vala"
	_tmp32_ = self->priv->tree_views;
#line 111 "preferences-dialog.vala"
	_tmp33_ = self->priv->tree_view_3;
#line 111 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
#line 112 "preferences-dialog.vala"
	_tmp34_ = self->priv->tree_views;
#line 112 "preferences-dialog.vala"
	_tmp35_ = self->priv->tree_view_4;
#line 112 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
#line 114 "preferences-dialog.vala"
	_tmp36_ = gee_array_list_new (gtk_list_store_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 114 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_stores);
#line 114 "preferences-dialog.vala"
	self->priv->list_stores = _tmp36_;
#line 115 "preferences-dialog.vala"
	_tmp37_ = self->priv->list_stores;
#line 115 "preferences-dialog.vala"
	_tmp38_ = self->priv->list_store_1;
#line 115 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp38_);
#line 116 "preferences-dialog.vala"
	_tmp39_ = self->priv->list_stores;
#line 116 "preferences-dialog.vala"
	_tmp40_ = self->priv->list_store_2;
#line 116 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
#line 117 "preferences-dialog.vala"
	_tmp41_ = self->priv->list_stores;
#line 117 "preferences-dialog.vala"
	_tmp42_ = self->priv->list_store_3;
#line 117 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
#line 118 "preferences-dialog.vala"
	_tmp43_ = self->priv->list_stores;
#line 118 "preferences-dialog.vala"
	_tmp44_ = self->priv->list_store_4;
#line 118 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, _tmp44_);
#line 495 "preferences-dialog.c"
	{
		GeeArrayList* _list_store_list = NULL;
		GeeArrayList* _tmp45_;
		GeeArrayList* _tmp46_;
		gint _list_store_size = 0;
		GeeArrayList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _list_store_index = 0;
#line 120 "preferences-dialog.vala"
		_tmp45_ = self->priv->list_stores;
#line 120 "preferences-dialog.vala"
		_tmp46_ = _g_object_ref0 (_tmp45_);
#line 120 "preferences-dialog.vala"
		_list_store_list = _tmp46_;
#line 120 "preferences-dialog.vala"
		_tmp47_ = _list_store_list;
#line 120 "preferences-dialog.vala"
		_tmp48_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp47_);
#line 120 "preferences-dialog.vala"
		_tmp49_ = _tmp48_;
#line 120 "preferences-dialog.vala"
		_list_store_size = _tmp49_;
#line 120 "preferences-dialog.vala"
		_list_store_index = -1;
#line 120 "preferences-dialog.vala"
		while (TRUE) {
#line 523 "preferences-dialog.c"
			GtkListStore* list_store = NULL;
			GeeArrayList* _tmp50_;
			gpointer _tmp51_;
			gint id = 0;
			GeeArrayList* _tmp52_;
			GtkListStore* _tmp53_;
			GtkTreeView* tree_view = NULL;
			GeeArrayList* _tmp54_;
			gpointer _tmp55_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp56_;
			GtkTreeIter _tmp57_ = {0};
			gint keyval = 0;
			gpointer _tmp58_;
			GSettings* _tmp59_;
			gint _tmp60_;
			GtkListStore* _tmp61_;
			GtkTreeIter _tmp62_;
			GtkListStore* _tmp63_;
			GtkTreeIter _tmp64_ = {0};
			gpointer _tmp65_;
			GSettings* _tmp66_;
			GtkListStore* _tmp67_;
			GtkTreeIter _tmp68_;
			GtkListStore* _tmp69_;
			GtkTreeIter _tmp70_ = {0};
			gpointer _tmp71_;
			GSettings* _tmp72_;
			GtkListStore* _tmp73_;
			GtkTreeIter _tmp74_;
			GtkListStore* _tmp75_;
			GtkTreeIter _tmp76_ = {0};
			gpointer _tmp77_;
			GSettings* _tmp78_;
			GtkListStore* _tmp79_;
			GtkTreeIter _tmp80_;
			GtkCellRendererText* label_renderer = NULL;
			GtkCellRendererText* _tmp81_;
			GtkTreeView* _tmp82_;
			GtkCellRendererText* _tmp83_;
			GtkCellRendererAccel* key_renderer = NULL;
			GtkCellRendererAccel* _tmp84_;
			GtkCellRendererAccel* _tmp85_;
			GtkCellRendererAccel* _tmp86_;
			GtkCellRendererAccel* _tmp87_;
			GtkCellRendererAccel* _tmp88_;
			GtkTreeView* _tmp89_;
			GtkCellRendererAccel* _tmp90_;
#line 120 "preferences-dialog.vala"
			_list_store_index = _list_store_index + 1;
#line 120 "preferences-dialog.vala"
			if (!(_list_store_index < _list_store_size)) {
#line 120 "preferences-dialog.vala"
				break;
#line 578 "preferences-dialog.c"
			}
#line 120 "preferences-dialog.vala"
			_tmp50_ = _list_store_list;
#line 120 "preferences-dialog.vala"
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _list_store_index);
#line 120 "preferences-dialog.vala"
			list_store = (GtkListStore*) _tmp51_;
#line 122 "preferences-dialog.vala"
			_tmp52_ = self->priv->list_stores;
#line 122 "preferences-dialog.vala"
			_tmp53_ = list_store;
#line 122 "preferences-dialog.vala"
			id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp52_, _tmp53_);
#line 123 "preferences-dialog.vala"
			_tmp54_ = self->priv->tree_views;
#line 123 "preferences-dialog.vala"
			_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, id);
#line 123 "preferences-dialog.vala"
			tree_view = (GtkTreeView*) _tmp55_;
#line 126 "preferences-dialog.vala"
			_tmp56_ = list_store;
#line 126 "preferences-dialog.vala"
			gtk_list_store_append (_tmp56_, &_tmp57_);
#line 126 "preferences-dialog.vala"
			iter = _tmp57_;
#line 127 "preferences-dialog.vala"
			_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, id);
#line 127 "preferences-dialog.vala"
			_tmp59_ = (GSettings*) _tmp58_;
#line 127 "preferences-dialog.vala"
			_tmp60_ = g_settings_get_int (_tmp59_, "key-up");
#line 127 "preferences-dialog.vala"
			_g_object_unref0 (_tmp59_);
#line 127 "preferences-dialog.vala"
			keyval = _tmp60_;
#line 128 "preferences-dialog.vala"
			_tmp61_ = list_store;
#line 128 "preferences-dialog.vala"
			_tmp62_ = iter;
#line 128 "preferences-dialog.vala"
			gtk_list_store_set (_tmp61_, &_tmp62_, 0, "key-up", 1, _ ("Move up"), 2, keyval, -1);
#line 129 "preferences-dialog.vala"
			_tmp63_ = list_store;
#line 129 "preferences-dialog.vala"
			gtk_list_store_append (_tmp63_, &_tmp64_);
#line 129 "preferences-dialog.vala"
			iter = _tmp64_;
#line 130 "preferences-dialog.vala"
			_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, id);
#line 130 "preferences-dialog.vala"
			_tmp66_ = (GSettings*) _tmp65_;
#line 130 "preferences-dialog.vala"
			keyval = g_settings_get_int (_tmp66_, "key-down");
#line 130 "preferences-dialog.vala"
			_g_object_unref0 (_tmp66_);
#line 131 "preferences-dialog.vala"
			_tmp67_ = list_store;
#line 131 "preferences-dialog.vala"
			_tmp68_ = iter;
#line 131 "preferences-dialog.vala"
			gtk_list_store_set (_tmp67_, &_tmp68_, 0, "key-down", 1, _ ("Move down"), 2, keyval, -1);
#line 132 "preferences-dialog.vala"
			_tmp69_ = list_store;
#line 132 "preferences-dialog.vala"
			gtk_list_store_append (_tmp69_, &_tmp70_);
#line 132 "preferences-dialog.vala"
			iter = _tmp70_;
#line 133 "preferences-dialog.vala"
			_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, id);
#line 133 "preferences-dialog.vala"
			_tmp72_ = (GSettings*) _tmp71_;
#line 133 "preferences-dialog.vala"
			keyval = g_settings_get_int (_tmp72_, "key-left");
#line 133 "preferences-dialog.vala"
			_g_object_unref0 (_tmp72_);
#line 134 "preferences-dialog.vala"
			_tmp73_ = list_store;
#line 134 "preferences-dialog.vala"
			_tmp74_ = iter;
#line 134 "preferences-dialog.vala"
			gtk_list_store_set (_tmp73_, &_tmp74_, 0, "key-left", 1, _ ("Move left"), 2, keyval, -1);
#line 135 "preferences-dialog.vala"
			_tmp75_ = list_store;
#line 135 "preferences-dialog.vala"
			gtk_list_store_append (_tmp75_, &_tmp76_);
#line 135 "preferences-dialog.vala"
			iter = _tmp76_;
#line 136 "preferences-dialog.vala"
			_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, id);
#line 136 "preferences-dialog.vala"
			_tmp78_ = (GSettings*) _tmp77_;
#line 136 "preferences-dialog.vala"
			keyval = g_settings_get_int (_tmp78_, "key-right");
#line 136 "preferences-dialog.vala"
			_g_object_unref0 (_tmp78_);
#line 137 "preferences-dialog.vala"
			_tmp79_ = list_store;
#line 137 "preferences-dialog.vala"
			_tmp80_ = iter;
#line 137 "preferences-dialog.vala"
			gtk_list_store_set (_tmp79_, &_tmp80_, 0, "key-right", 1, _ ("Move right"), 2, keyval, -1);
#line 139 "preferences-dialog.vala"
			_tmp81_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 139 "preferences-dialog.vala"
			g_object_ref_sink (_tmp81_);
#line 139 "preferences-dialog.vala"
			label_renderer = _tmp81_;
#line 140 "preferences-dialog.vala"
			_tmp82_ = tree_view;
#line 140 "preferences-dialog.vala"
			_tmp83_ = label_renderer;
#line 140 "preferences-dialog.vala"
			gtk_tree_view_insert_column_with_attributes (_tmp82_, -1, _ ("Action"), (GtkCellRenderer*) _tmp83_, "text", 1, NULL);
#line 142 "preferences-dialog.vala"
			_tmp84_ = (GtkCellRendererAccel*) gtk_cell_renderer_accel_new ();
#line 142 "preferences-dialog.vala"
			g_object_ref_sink (_tmp84_);
#line 142 "preferences-dialog.vala"
			key_renderer = _tmp84_;
#line 143 "preferences-dialog.vala"
			_tmp85_ = key_renderer;
#line 143 "preferences-dialog.vala"
			g_object_set ((GtkCellRendererText*) _tmp85_, "editable", TRUE, NULL);
#line 144 "preferences-dialog.vala"
			_tmp86_ = key_renderer;
#line 144 "preferences-dialog.vala"
			g_object_set (_tmp86_, "accel-mode", GTK_CELL_RENDERER_ACCEL_MODE_OTHER, NULL);
#line 145 "preferences-dialog.vala"
			_tmp87_ = key_renderer;
#line 145 "preferences-dialog.vala"
			g_signal_connect_object (_tmp87_, "accel-edited", (GCallback) _preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited, self, 0);
#line 146 "preferences-dialog.vala"
			_tmp88_ = key_renderer;
#line 146 "preferences-dialog.vala"
			g_signal_connect_object (_tmp88_, "accel-cleared", (GCallback) _preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared, self, 0);
#line 147 "preferences-dialog.vala"
			_tmp89_ = tree_view;
#line 147 "preferences-dialog.vala"
			_tmp90_ = key_renderer;
#line 147 "preferences-dialog.vala"
			gtk_tree_view_insert_column_with_attributes (_tmp89_, -1, _ ("Key"), (GtkCellRenderer*) _tmp90_, "accel-key", 2, NULL);
#line 120 "preferences-dialog.vala"
			_g_object_unref0 (key_renderer);
#line 120 "preferences-dialog.vala"
			_g_object_unref0 (label_renderer);
#line 120 "preferences-dialog.vala"
			_g_object_unref0 (tree_view);
#line 120 "preferences-dialog.vala"
			_g_object_unref0 (list_store);
#line 728 "preferences-dialog.c"
		}
#line 120 "preferences-dialog.vala"
		_g_object_unref0 (_list_store_list);
#line 732 "preferences-dialog.c"
	}
#line 152 "preferences-dialog.vala"
	_tmp91_ = gee_array_list_new (gtk_combo_box_text_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 152 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_boxes);
#line 152 "preferences-dialog.vala"
	self->priv->combo_boxes = _tmp91_;
#line 153 "preferences-dialog.vala"
	_tmp92_ = self->priv->combo_boxes;
#line 153 "preferences-dialog.vala"
	_tmp93_ = self->priv->combo_box_1;
#line 153 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp92_, _tmp93_);
#line 154 "preferences-dialog.vala"
	_tmp94_ = self->priv->combo_boxes;
#line 154 "preferences-dialog.vala"
	_tmp95_ = self->priv->combo_box_2;
#line 154 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp94_, _tmp95_);
#line 155 "preferences-dialog.vala"
	_tmp96_ = self->priv->combo_boxes;
#line 155 "preferences-dialog.vala"
	_tmp97_ = self->priv->combo_box_3;
#line 155 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp96_, _tmp97_);
#line 156 "preferences-dialog.vala"
	_tmp98_ = self->priv->combo_boxes;
#line 156 "preferences-dialog.vala"
	_tmp99_ = self->priv->combo_box_4;
#line 156 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, _tmp99_);
#line 764 "preferences-dialog.c"
	{
		GeeArrayList* _combo_box_list = NULL;
		GeeArrayList* _tmp100_;
		GeeArrayList* _tmp101_;
		gint _combo_box_size = 0;
		GeeArrayList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _combo_box_index = 0;
#line 158 "preferences-dialog.vala"
		_tmp100_ = self->priv->combo_boxes;
#line 158 "preferences-dialog.vala"
		_tmp101_ = _g_object_ref0 (_tmp100_);
#line 158 "preferences-dialog.vala"
		_combo_box_list = _tmp101_;
#line 158 "preferences-dialog.vala"
		_tmp102_ = _combo_box_list;
#line 158 "preferences-dialog.vala"
		_tmp103_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp102_);
#line 158 "preferences-dialog.vala"
		_tmp104_ = _tmp103_;
#line 158 "preferences-dialog.vala"
		_combo_box_size = _tmp104_;
#line 158 "preferences-dialog.vala"
		_combo_box_index = -1;
#line 158 "preferences-dialog.vala"
		while (TRUE) {
#line 792 "preferences-dialog.c"
			GtkComboBoxText* combo_box = NULL;
			GeeArrayList* _tmp105_;
			gpointer _tmp106_;
			gint id = 0;
			GeeArrayList* _tmp112_;
			GtkComboBoxText* _tmp113_;
			gint color = 0;
			gpointer _tmp114_;
			GSettings* _tmp115_;
			gint _tmp116_;
			GtkComboBoxText* _tmp117_;
			GtkComboBoxText* _tmp118_;
#line 158 "preferences-dialog.vala"
			_combo_box_index = _combo_box_index + 1;
#line 158 "preferences-dialog.vala"
			if (!(_combo_box_index < _combo_box_size)) {
#line 158 "preferences-dialog.vala"
				break;
#line 811 "preferences-dialog.c"
			}
#line 158 "preferences-dialog.vala"
			_tmp105_ = _combo_box_list;
#line 158 "preferences-dialog.vala"
			_tmp106_ = gee_abstract_list_get ((GeeAbstractList*) _tmp105_, _combo_box_index);
#line 158 "preferences-dialog.vala"
			combo_box = (GtkComboBoxText*) _tmp106_;
#line 819 "preferences-dialog.c"
			{
				gint i = 0;
#line 160 "preferences-dialog.vala"
				i = 0;
#line 824 "preferences-dialog.c"
				{
					gboolean _tmp107_ = FALSE;
#line 160 "preferences-dialog.vala"
					_tmp107_ = TRUE;
#line 160 "preferences-dialog.vala"
					while (TRUE) {
#line 831 "preferences-dialog.c"
						GtkComboBoxText* _tmp109_;
						gchar* _tmp110_;
						gchar* _tmp111_;
#line 160 "preferences-dialog.vala"
						if (!_tmp107_) {
#line 837 "preferences-dialog.c"
							gint _tmp108_;
#line 160 "preferences-dialog.vala"
							_tmp108_ = i;
#line 160 "preferences-dialog.vala"
							i = _tmp108_ + 1;
#line 843 "preferences-dialog.c"
						}
#line 160 "preferences-dialog.vala"
						_tmp107_ = FALSE;
#line 160 "preferences-dialog.vala"
						if (!(i < NIBBLES_VIEW_NUM_COLORS)) {
#line 160 "preferences-dialog.vala"
							break;
#line 851 "preferences-dialog.c"
						}
#line 161 "preferences-dialog.vala"
						_tmp109_ = combo_box;
#line 161 "preferences-dialog.vala"
						_tmp110_ = nibbles_view_colorval_name (i);
#line 161 "preferences-dialog.vala"
						_tmp111_ = _tmp110_;
#line 161 "preferences-dialog.vala"
						gtk_combo_box_text_append_text (_tmp109_, _tmp111_);
#line 161 "preferences-dialog.vala"
						_g_free0 (_tmp111_);
#line 863 "preferences-dialog.c"
					}
				}
			}
#line 163 "preferences-dialog.vala"
			_tmp112_ = self->priv->combo_boxes;
#line 163 "preferences-dialog.vala"
			_tmp113_ = combo_box;
#line 163 "preferences-dialog.vala"
			id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp112_, _tmp113_);
#line 165 "preferences-dialog.vala"
			_tmp114_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, id);
#line 165 "preferences-dialog.vala"
			_tmp115_ = (GSettings*) _tmp114_;
#line 165 "preferences-dialog.vala"
			_tmp116_ = g_settings_get_enum (_tmp115_, "color");
#line 165 "preferences-dialog.vala"
			_g_object_unref0 (_tmp115_);
#line 165 "preferences-dialog.vala"
			color = _tmp116_;
#line 166 "preferences-dialog.vala"
			_tmp117_ = combo_box;
#line 166 "preferences-dialog.vala"
			gtk_combo_box_set_active ((GtkComboBox*) _tmp117_, color);
#line 167 "preferences-dialog.vala"
			_tmp118_ = combo_box;
#line 167 "preferences-dialog.vala"
			g_signal_connect_object ((GtkComboBox*) _tmp118_, "changed", (GCallback) _preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed, self, 0);
#line 158 "preferences-dialog.vala"
			_g_object_unref0 (combo_box);
#line 893 "preferences-dialog.c"
		}
#line 158 "preferences-dialog.vala"
		_g_object_unref0 (_combo_box_list);
#line 897 "preferences-dialog.c"
	}
#line 71 "preferences-dialog.vala"
	return self;
#line 901 "preferences-dialog.c"
}

PreferencesDialog*
preferences_dialog_new (GtkApplicationWindow* window,
                        GSettings* settings,
                        GeeArrayList* worm_settings)
{
#line 71 "preferences-dialog.vala"
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG, window, settings, worm_settings);
#line 911 "preferences-dialog.c"
}

static void
preferences_dialog_radio_button_toggled_cb (PreferencesDialog* self,
                                            GtkToggleButton* button)
{
#line 171 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 171 "preferences-dialog.vala"
	g_return_if_fail (button != NULL);
#line 173 "preferences-dialog.vala"
	if (gtk_toggle_button_get_active (button)) {
#line 924 "preferences-dialog.c"
		gint speed = 0;
		GeeArrayList* _tmp0_;
		GSettings* _tmp1_;
#line 175 "preferences-dialog.vala"
		_tmp0_ = self->priv->radio_buttons;
#line 175 "preferences-dialog.vala"
		speed = NIBBLES_GAME_MAX_SPEED - gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (button, gtk_radio_button_get_type (), GtkRadioButton));
#line 176 "preferences-dialog.vala"
		_tmp1_ = self->priv->settings;
#line 176 "preferences-dialog.vala"
		g_settings_set_int (_tmp1_, "speed", speed);
#line 936 "preferences-dialog.c"
	}
}

static void
preferences_dialog_sound_toggled_cb (PreferencesDialog* self)
{
	gboolean play_sound = FALSE;
	GtkCheckButton* _tmp0_;
	GSettings* _tmp1_;
#line 180 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 182 "preferences-dialog.vala"
	_tmp0_ = self->priv->sound_check_button;
#line 182 "preferences-dialog.vala"
	play_sound = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
#line 183 "preferences-dialog.vala"
	_tmp1_ = self->priv->settings;
#line 183 "preferences-dialog.vala"
	g_settings_set_boolean (_tmp1_, "sound", play_sound);
#line 956 "preferences-dialog.c"
}

static void
preferences_dialog_fakes_toggles_cb (PreferencesDialog* self)
{
	gboolean has_fakes = FALSE;
	GtkCheckButton* _tmp0_;
	GSettings* _tmp1_;
#line 186 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 188 "preferences-dialog.vala"
	_tmp0_ = self->priv->fakes_check_button;
#line 188 "preferences-dialog.vala"
	has_fakes = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
#line 189 "preferences-dialog.vala"
	_tmp1_ = self->priv->settings;
#line 189 "preferences-dialog.vala"
	g_settings_set_boolean (_tmp1_, "fakes", has_fakes);
#line 975 "preferences-dialog.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 197 "preferences-dialog.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 983 "preferences-dialog.c"
}

static void
preferences_dialog_accel_edited_cb (PreferencesDialog* self,
                                    GtkCellRendererAccel* cell,
                                    const gchar* path_string,
                                    guint keyval,
                                    GdkModifierType mask,
                                    guint hardware_keycode)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	gint id = 0;
	GtkNotebook* _tmp2_;
	GtkListStore* list_store = NULL;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	GtkTreeIter it = {0};
	GtkListStore* _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	gboolean _tmp8_;
	gchar* key = NULL;
	GtkListStore* _tmp9_;
	GtkTreeIter _tmp10_;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	GeeArrayList* _tmp13_;
	gpointer _tmp14_;
	GSettings* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	gboolean valid = FALSE;
#line 192 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 192 "preferences-dialog.vala"
	g_return_if_fail (cell != NULL);
#line 192 "preferences-dialog.vala"
	g_return_if_fail (path_string != NULL);
#line 195 "preferences-dialog.vala"
	_tmp0_ = gtk_tree_path_new_from_string (path_string);
#line 195 "preferences-dialog.vala"
	path = _tmp0_;
#line 196 "preferences-dialog.vala"
	_tmp1_ = path;
#line 196 "preferences-dialog.vala"
	if (_tmp1_ == NULL) {
#line 197 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 197 "preferences-dialog.vala"
		return;
#line 1036 "preferences-dialog.c"
	}
#line 199 "preferences-dialog.vala"
	_tmp2_ = self->priv->notebook;
#line 199 "preferences-dialog.vala"
	id = gtk_notebook_get_current_page (_tmp2_) - 1;
#line 200 "preferences-dialog.vala"
	_tmp3_ = self->priv->list_stores;
#line 200 "preferences-dialog.vala"
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, id);
#line 200 "preferences-dialog.vala"
	list_store = (GtkListStore*) _tmp4_;
#line 203 "preferences-dialog.vala"
	_tmp5_ = list_store;
#line 203 "preferences-dialog.vala"
	_tmp6_ = path;
#line 203 "preferences-dialog.vala"
	_tmp8_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp5_, &_tmp7_, _tmp6_);
#line 203 "preferences-dialog.vala"
	it = _tmp7_;
#line 203 "preferences-dialog.vala"
	if (!_tmp8_) {
#line 204 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 204 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 204 "preferences-dialog.vala"
		return;
#line 1064 "preferences-dialog.c"
	}
#line 206 "preferences-dialog.vala"
	key = NULL;
#line 207 "preferences-dialog.vala"
	_tmp9_ = list_store;
#line 207 "preferences-dialog.vala"
	_tmp10_ = it;
#line 207 "preferences-dialog.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp9_, &_tmp10_, 0, &_tmp11_, -1);
#line 207 "preferences-dialog.vala"
	_g_free0 (key);
#line 207 "preferences-dialog.vala"
	key = _tmp11_;
#line 208 "preferences-dialog.vala"
	_tmp12_ = key;
#line 208 "preferences-dialog.vala"
	if (_tmp12_ == NULL) {
#line 209 "preferences-dialog.vala"
		_g_free0 (key);
#line 209 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 209 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 209 "preferences-dialog.vala"
		return;
#line 1090 "preferences-dialog.c"
	}
#line 211 "preferences-dialog.vala"
	_tmp13_ = self->priv->worm_settings;
#line 211 "preferences-dialog.vala"
	_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, id);
#line 211 "preferences-dialog.vala"
	_tmp15_ = (GSettings*) _tmp14_;
#line 211 "preferences-dialog.vala"
	_tmp16_ = key;
#line 211 "preferences-dialog.vala"
	_tmp17_ = ((guint) g_settings_get_int (_tmp15_, _tmp16_)) == keyval;
#line 211 "preferences-dialog.vala"
	_g_object_unref0 (_tmp15_);
#line 211 "preferences-dialog.vala"
	if (_tmp17_) {
#line 212 "preferences-dialog.vala"
		_g_free0 (key);
#line 212 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 212 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 212 "preferences-dialog.vala"
		return;
#line 1114 "preferences-dialog.c"
	}
#line 215 "preferences-dialog.vala"
	valid = TRUE;
#line 1118 "preferences-dialog.c"
	{
		gint i = 0;
#line 216 "preferences-dialog.vala"
		i = 0;
#line 1123 "preferences-dialog.c"
		{
			gboolean _tmp18_ = FALSE;
#line 216 "preferences-dialog.vala"
			_tmp18_ = TRUE;
#line 216 "preferences-dialog.vala"
			while (TRUE) {
#line 1130 "preferences-dialog.c"
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				GeeArrayList* _tmp23_;
				gpointer _tmp24_;
				GSettings* _tmp25_;
				gboolean _tmp26_;
#line 216 "preferences-dialog.vala"
				if (!_tmp18_) {
#line 1140 "preferences-dialog.c"
					gint _tmp19_;
#line 216 "preferences-dialog.vala"
					_tmp19_ = i;
#line 216 "preferences-dialog.vala"
					i = _tmp19_ + 1;
#line 1146 "preferences-dialog.c"
				}
#line 216 "preferences-dialog.vala"
				_tmp18_ = FALSE;
#line 216 "preferences-dialog.vala"
				if (!(i < NIBBLES_GAME_MAX_HUMANS)) {
#line 216 "preferences-dialog.vala"
					break;
#line 1154 "preferences-dialog.c"
				}
#line 218 "preferences-dialog.vala"
				_tmp23_ = self->priv->worm_settings;
#line 218 "preferences-dialog.vala"
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, i);
#line 218 "preferences-dialog.vala"
				_tmp25_ = (GSettings*) _tmp24_;
#line 218 "preferences-dialog.vala"
				_tmp26_ = ((guint) g_settings_get_int (_tmp25_, "key-up")) == keyval;
#line 218 "preferences-dialog.vala"
				_g_object_unref0 (_tmp25_);
#line 218 "preferences-dialog.vala"
				if (_tmp26_) {
#line 218 "preferences-dialog.vala"
					_tmp22_ = TRUE;
#line 1170 "preferences-dialog.c"
				} else {
					GeeArrayList* _tmp27_;
					gpointer _tmp28_;
					GSettings* _tmp29_;
#line 219 "preferences-dialog.vala"
					_tmp27_ = self->priv->worm_settings;
#line 219 "preferences-dialog.vala"
					_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, i);
#line 219 "preferences-dialog.vala"
					_tmp29_ = (GSettings*) _tmp28_;
#line 219 "preferences-dialog.vala"
					_tmp22_ = ((guint) g_settings_get_int (_tmp29_, "key-down")) == keyval;
#line 219 "preferences-dialog.vala"
					_g_object_unref0 (_tmp29_);
#line 1185 "preferences-dialog.c"
				}
#line 218 "preferences-dialog.vala"
				if (_tmp22_) {
#line 218 "preferences-dialog.vala"
					_tmp21_ = TRUE;
#line 1191 "preferences-dialog.c"
				} else {
					GeeArrayList* _tmp30_;
					gpointer _tmp31_;
					GSettings* _tmp32_;
#line 220 "preferences-dialog.vala"
					_tmp30_ = self->priv->worm_settings;
#line 220 "preferences-dialog.vala"
					_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, i);
#line 220 "preferences-dialog.vala"
					_tmp32_ = (GSettings*) _tmp31_;
#line 220 "preferences-dialog.vala"
					_tmp21_ = ((guint) g_settings_get_int (_tmp32_, "key-left")) == keyval;
#line 220 "preferences-dialog.vala"
					_g_object_unref0 (_tmp32_);
#line 1206 "preferences-dialog.c"
				}
#line 218 "preferences-dialog.vala"
				if (_tmp21_) {
#line 218 "preferences-dialog.vala"
					_tmp20_ = TRUE;
#line 1212 "preferences-dialog.c"
				} else {
					GeeArrayList* _tmp33_;
					gpointer _tmp34_;
					GSettings* _tmp35_;
#line 221 "preferences-dialog.vala"
					_tmp33_ = self->priv->worm_settings;
#line 221 "preferences-dialog.vala"
					_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, i);
#line 221 "preferences-dialog.vala"
					_tmp35_ = (GSettings*) _tmp34_;
#line 221 "preferences-dialog.vala"
					_tmp20_ = ((guint) g_settings_get_int (_tmp35_, "key-right")) == keyval;
#line 221 "preferences-dialog.vala"
					_g_object_unref0 (_tmp35_);
#line 1227 "preferences-dialog.c"
				}
#line 218 "preferences-dialog.vala"
				if (_tmp20_) {
#line 1231 "preferences-dialog.c"
					GtkMessageDialog* dialog = NULL;
					GtkApplicationWindow* _tmp36_;
					GtkMessageDialog* _tmp37_;
					GtkMessageDialog* _tmp38_;
					GtkMessageDialog* _tmp39_;
#line 223 "preferences-dialog.vala"
					valid = FALSE;
#line 225 "preferences-dialog.vala"
					_tmp36_ = self->priv->window;
#line 225 "preferences-dialog.vala"
					_tmp37_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp36_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK, "%s", _ ("The key you selected is already assigned!"));
#line 225 "preferences-dialog.vala"
					g_object_ref_sink (_tmp37_);
#line 225 "preferences-dialog.vala"
					dialog = _tmp37_;
#line 232 "preferences-dialog.vala"
					_tmp38_ = dialog;
#line 232 "preferences-dialog.vala"
					gtk_dialog_run ((GtkDialog*) _tmp38_);
#line 233 "preferences-dialog.vala"
					_tmp39_ = dialog;
#line 233 "preferences-dialog.vala"
					gtk_widget_destroy ((GtkWidget*) _tmp39_);
#line 234 "preferences-dialog.vala"
					_g_object_unref0 (dialog);
#line 234 "preferences-dialog.vala"
					break;
#line 1259 "preferences-dialog.c"
				}
			}
		}
	}
#line 238 "preferences-dialog.vala"
	if (valid) {
#line 1266 "preferences-dialog.c"
		GtkListStore* _tmp40_;
		GtkTreeIter _tmp41_;
		GeeArrayList* _tmp42_;
		gpointer _tmp43_;
		GSettings* _tmp44_;
		const gchar* _tmp45_;
#line 240 "preferences-dialog.vala"
		_tmp40_ = list_store;
#line 240 "preferences-dialog.vala"
		_tmp41_ = it;
#line 240 "preferences-dialog.vala"
		gtk_list_store_set (_tmp40_, &_tmp41_, 2, keyval, -1);
#line 241 "preferences-dialog.vala"
		_tmp42_ = self->priv->worm_settings;
#line 241 "preferences-dialog.vala"
		_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, id);
#line 241 "preferences-dialog.vala"
		_tmp44_ = (GSettings*) _tmp43_;
#line 241 "preferences-dialog.vala"
		_tmp45_ = key;
#line 241 "preferences-dialog.vala"
		g_settings_set_int (_tmp44_, _tmp45_, (gint) keyval);
#line 241 "preferences-dialog.vala"
		_g_object_unref0 (_tmp44_);
#line 1291 "preferences-dialog.c"
	}
#line 192 "preferences-dialog.vala"
	_g_free0 (key);
#line 192 "preferences-dialog.vala"
	_g_object_unref0 (list_store);
#line 192 "preferences-dialog.vala"
	__vala_GtkTreePath_free0 (path);
#line 1299 "preferences-dialog.c"
}

static void
preferences_dialog_accel_cleared_cb (PreferencesDialog* self,
                                     GtkCellRendererAccel* cell,
                                     const gchar* path_string)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	gint id = 0;
	GtkNotebook* _tmp2_;
	GtkListStore* list_store = NULL;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	GtkTreeIter it = {0};
	GtkListStore* _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	gboolean _tmp8_;
	gchar* key = NULL;
	GtkListStore* _tmp9_;
	GtkTreeIter _tmp10_;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	GtkListStore* _tmp13_;
	GtkTreeIter _tmp14_;
	GeeArrayList* _tmp15_;
	gpointer _tmp16_;
	GSettings* _tmp17_;
	const gchar* _tmp18_;
#line 245 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 245 "preferences-dialog.vala"
	g_return_if_fail (cell != NULL);
#line 245 "preferences-dialog.vala"
	g_return_if_fail (path_string != NULL);
#line 247 "preferences-dialog.vala"
	_tmp0_ = gtk_tree_path_new_from_string (path_string);
#line 247 "preferences-dialog.vala"
	path = _tmp0_;
#line 248 "preferences-dialog.vala"
	_tmp1_ = path;
#line 248 "preferences-dialog.vala"
	if (_tmp1_ == NULL) {
#line 249 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 249 "preferences-dialog.vala"
		return;
#line 1349 "preferences-dialog.c"
	}
#line 251 "preferences-dialog.vala"
	_tmp2_ = self->priv->notebook;
#line 251 "preferences-dialog.vala"
	id = gtk_notebook_get_current_page (_tmp2_) - 1;
#line 252 "preferences-dialog.vala"
	_tmp3_ = self->priv->list_stores;
#line 252 "preferences-dialog.vala"
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, id);
#line 252 "preferences-dialog.vala"
	list_store = (GtkListStore*) _tmp4_;
#line 255 "preferences-dialog.vala"
	_tmp5_ = list_store;
#line 255 "preferences-dialog.vala"
	_tmp6_ = path;
#line 255 "preferences-dialog.vala"
	_tmp8_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp5_, &_tmp7_, _tmp6_);
#line 255 "preferences-dialog.vala"
	it = _tmp7_;
#line 255 "preferences-dialog.vala"
	if (!_tmp8_) {
#line 256 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 256 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 256 "preferences-dialog.vala"
		return;
#line 1377 "preferences-dialog.c"
	}
#line 258 "preferences-dialog.vala"
	key = NULL;
#line 259 "preferences-dialog.vala"
	_tmp9_ = list_store;
#line 259 "preferences-dialog.vala"
	_tmp10_ = it;
#line 259 "preferences-dialog.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp9_, &_tmp10_, 0, &_tmp11_, -1);
#line 259 "preferences-dialog.vala"
	_g_free0 (key);
#line 259 "preferences-dialog.vala"
	key = _tmp11_;
#line 260 "preferences-dialog.vala"
	_tmp12_ = key;
#line 260 "preferences-dialog.vala"
	if (_tmp12_ == NULL) {
#line 261 "preferences-dialog.vala"
		_g_free0 (key);
#line 261 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 261 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 261 "preferences-dialog.vala"
		return;
#line 1403 "preferences-dialog.c"
	}
#line 263 "preferences-dialog.vala"
	_tmp13_ = list_store;
#line 263 "preferences-dialog.vala"
	_tmp14_ = it;
#line 263 "preferences-dialog.vala"
	gtk_list_store_set (_tmp13_, &_tmp14_, 2, 0, -1);
#line 264 "preferences-dialog.vala"
	_tmp15_ = self->priv->worm_settings;
#line 264 "preferences-dialog.vala"
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, id);
#line 264 "preferences-dialog.vala"
	_tmp17_ = (GSettings*) _tmp16_;
#line 264 "preferences-dialog.vala"
	_tmp18_ = key;
#line 264 "preferences-dialog.vala"
	g_settings_set_int (_tmp17_, _tmp18_, 0);
#line 264 "preferences-dialog.vala"
	_g_object_unref0 (_tmp17_);
#line 245 "preferences-dialog.vala"
	_g_free0 (key);
#line 245 "preferences-dialog.vala"
	_g_object_unref0 (list_store);
#line 245 "preferences-dialog.vala"
	__vala_GtkTreePath_free0 (path);
#line 1429 "preferences-dialog.c"
}

static void
preferences_dialog_combo_box_changed_cb (PreferencesDialog* self,
                                         GtkComboBox* combo_box)
{
	gint id = 0;
	GeeArrayList* _tmp0_;
	gint color_new = 0;
	gint color_old = 0;
	GeeArrayList* _tmp1_;
	gpointer _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp24_;
	gpointer _tmp25_;
	GSettings* _tmp26_;
#line 267 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 267 "preferences-dialog.vala"
	g_return_if_fail (combo_box != NULL);
#line 269 "preferences-dialog.vala"
	_tmp0_ = self->priv->combo_boxes;
#line 269 "preferences-dialog.vala"
	id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (combo_box, gtk_combo_box_text_get_type (), GtkComboBoxText));
#line 270 "preferences-dialog.vala"
	color_new = gtk_combo_box_get_active (combo_box);
#line 271 "preferences-dialog.vala"
	_tmp1_ = self->priv->worm_settings;
#line 271 "preferences-dialog.vala"
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, id);
#line 271 "preferences-dialog.vala"
	_tmp3_ = (GSettings*) _tmp2_;
#line 271 "preferences-dialog.vala"
	_tmp4_ = g_settings_get_enum (_tmp3_, "color");
#line 271 "preferences-dialog.vala"
	_g_object_unref0 (_tmp3_);
#line 271 "preferences-dialog.vala"
	color_old = _tmp4_;
#line 273 "preferences-dialog.vala"
	if (color_new == color_old) {
#line 274 "preferences-dialog.vala"
		return;
#line 1473 "preferences-dialog.c"
	}
	{
		gint i = 0;
#line 277 "preferences-dialog.vala"
		i = 0;
#line 1479 "preferences-dialog.c"
		{
			gboolean _tmp5_ = FALSE;
#line 277 "preferences-dialog.vala"
			_tmp5_ = TRUE;
#line 277 "preferences-dialog.vala"
			while (TRUE) {
#line 1486 "preferences-dialog.c"
				gboolean _tmp7_ = FALSE;
#line 277 "preferences-dialog.vala"
				if (!_tmp5_) {
#line 1490 "preferences-dialog.c"
					gint _tmp6_;
#line 277 "preferences-dialog.vala"
					_tmp6_ = i;
#line 277 "preferences-dialog.vala"
					i = _tmp6_ + 1;
#line 1496 "preferences-dialog.c"
				}
#line 277 "preferences-dialog.vala"
				_tmp5_ = FALSE;
#line 277 "preferences-dialog.vala"
				if (!(i < NIBBLES_GAME_MAX_WORMS)) {
#line 277 "preferences-dialog.vala"
					break;
#line 1504 "preferences-dialog.c"
				}
#line 279 "preferences-dialog.vala"
				if (i != id) {
#line 1508 "preferences-dialog.c"
					GeeArrayList* _tmp8_;
					gpointer _tmp9_;
					GSettings* _tmp10_;
#line 279 "preferences-dialog.vala"
					_tmp8_ = self->priv->worm_settings;
#line 279 "preferences-dialog.vala"
					_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, i);
#line 279 "preferences-dialog.vala"
					_tmp10_ = (GSettings*) _tmp9_;
#line 279 "preferences-dialog.vala"
					_tmp7_ = g_settings_get_enum (_tmp10_, "color") == color_new;
#line 279 "preferences-dialog.vala"
					_g_object_unref0 (_tmp10_);
#line 1522 "preferences-dialog.c"
				} else {
#line 279 "preferences-dialog.vala"
					_tmp7_ = FALSE;
#line 1526 "preferences-dialog.c"
				}
#line 279 "preferences-dialog.vala"
				if (_tmp7_) {
#line 1530 "preferences-dialog.c"
					GeeArrayList* _tmp11_;
					gpointer _tmp12_;
					GSettings* _tmp13_;
#line 281 "preferences-dialog.vala"
					_tmp11_ = self->priv->worm_settings;
#line 281 "preferences-dialog.vala"
					_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, i);
#line 281 "preferences-dialog.vala"
					_tmp13_ = (GSettings*) _tmp12_;
#line 281 "preferences-dialog.vala"
					g_settings_set_enum (_tmp13_, "color", color_old);
#line 281 "preferences-dialog.vala"
					_g_object_unref0 (_tmp13_);
#line 284 "preferences-dialog.vala"
					if (i < NIBBLES_GAME_MAX_HUMANS) {
#line 1546 "preferences-dialog.c"
						{
							GeeArrayList* _cbox_list = NULL;
							GeeArrayList* _tmp14_;
							GeeArrayList* _tmp15_;
							gint _cbox_size = 0;
							GeeArrayList* _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							gint _cbox_index = 0;
#line 286 "preferences-dialog.vala"
							_tmp14_ = self->priv->combo_boxes;
#line 286 "preferences-dialog.vala"
							_tmp15_ = _g_object_ref0 (_tmp14_);
#line 286 "preferences-dialog.vala"
							_cbox_list = _tmp15_;
#line 286 "preferences-dialog.vala"
							_tmp16_ = _cbox_list;
#line 286 "preferences-dialog.vala"
							_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
#line 286 "preferences-dialog.vala"
							_tmp18_ = _tmp17_;
#line 286 "preferences-dialog.vala"
							_cbox_size = _tmp18_;
#line 286 "preferences-dialog.vala"
							_cbox_index = -1;
#line 286 "preferences-dialog.vala"
							while (TRUE) {
#line 1574 "preferences-dialog.c"
								GtkComboBoxText* cbox = NULL;
								GeeArrayList* _tmp19_;
								gpointer _tmp20_;
								gint index = 0;
								GeeArrayList* _tmp21_;
								GtkComboBoxText* _tmp22_;
#line 286 "preferences-dialog.vala"
								_cbox_index = _cbox_index + 1;
#line 286 "preferences-dialog.vala"
								if (!(_cbox_index < _cbox_size)) {
#line 286 "preferences-dialog.vala"
									break;
#line 1587 "preferences-dialog.c"
								}
#line 286 "preferences-dialog.vala"
								_tmp19_ = _cbox_list;
#line 286 "preferences-dialog.vala"
								_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _cbox_index);
#line 286 "preferences-dialog.vala"
								cbox = (GtkComboBoxText*) _tmp20_;
#line 288 "preferences-dialog.vala"
								_tmp21_ = self->priv->combo_boxes;
#line 288 "preferences-dialog.vala"
								_tmp22_ = cbox;
#line 288 "preferences-dialog.vala"
								index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp21_, _tmp22_);
#line 289 "preferences-dialog.vala"
								if (index == i) {
#line 1603 "preferences-dialog.c"
									GtkComboBoxText* _tmp23_;
#line 291 "preferences-dialog.vala"
									_tmp23_ = cbox;
#line 291 "preferences-dialog.vala"
									gtk_combo_box_set_active ((GtkComboBox*) _tmp23_, color_old);
#line 292 "preferences-dialog.vala"
									_g_object_unref0 (cbox);
#line 292 "preferences-dialog.vala"
									break;
#line 1613 "preferences-dialog.c"
								}
#line 286 "preferences-dialog.vala"
								_g_object_unref0 (cbox);
#line 1617 "preferences-dialog.c"
							}
#line 286 "preferences-dialog.vala"
							_g_object_unref0 (_cbox_list);
#line 1621 "preferences-dialog.c"
						}
					}
#line 297 "preferences-dialog.vala"
					break;
#line 1626 "preferences-dialog.c"
				}
			}
		}
	}
#line 301 "preferences-dialog.vala"
	_tmp24_ = self->priv->worm_settings;
#line 301 "preferences-dialog.vala"
	_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, id);
#line 301 "preferences-dialog.vala"
	_tmp26_ = (GSettings*) _tmp25_;
#line 301 "preferences-dialog.vala"
	g_settings_set_enum (_tmp26_, "color", color_new);
#line 301 "preferences-dialog.vala"
	_g_object_unref0 (_tmp26_);
#line 1641 "preferences-dialog.c"
}

static void
preferences_dialog_class_init (PreferencesDialogClass * klass,
                               gpointer klass_data)
{
#line 20 "preferences-dialog.vala"
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
#line 20 "preferences-dialog.vala"
	g_type_class_adjust_private_offset (klass, &PreferencesDialog_private_offset);
#line 20 "preferences-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
#line 20 "preferences-dialog.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/preferences-dialog.ui");
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notebook", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, notebook));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "beginner_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, beginner_radio_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "slow_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, slow_radio_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "medium_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, medium_radio_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fast_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, fast_radio_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sound_check_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, sound_check_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fakes_check_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, fakes_check_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_1));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_2));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_3));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_4));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_1));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_2));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_3));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_4));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_1));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_2));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_3));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_4));
#line 1694 "preferences-dialog.c"
}

static void
preferences_dialog_instance_init (PreferencesDialog * self,
                                  gpointer klass)
{
#line 20 "preferences-dialog.vala"
	self->priv = preferences_dialog_get_instance_private (self);
#line 20 "preferences-dialog.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 1705 "preferences-dialog.c"
}

static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
#line 20 "preferences-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
#line 22 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->window);
#line 24 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->settings);
#line 25 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 28 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->notebook);
#line 30 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->beginner_radio_button);
#line 32 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->slow_radio_button);
#line 34 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->medium_radio_button);
#line 36 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->fast_radio_button);
#line 38 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->sound_check_button);
#line 40 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->fakes_check_button);
#line 42 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_store_1);
#line 44 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_store_2);
#line 46 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_store_3);
#line 48 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_store_4);
#line 50 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_view_1);
#line 52 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_view_2);
#line 54 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_view_3);
#line 56 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_view_4);
#line 58 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_box_1);
#line 60 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_box_2);
#line 62 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_box_3);
#line 64 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_box_4);
#line 66 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->radio_buttons);
#line 67 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_stores);
#line 68 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_views);
#line 69 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_boxes);
#line 20 "preferences-dialog.vala"
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
#line 1768 "preferences-dialog.c"
}

GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
		PreferencesDialog_private_offset = g_type_add_instance_private (preferences_dialog_type_id, sizeof (PreferencesDialogPrivate));
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}

