/* worm.c generated by valac 0.44.6, the Vala compiler
 * generated from worm.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <gee.h>

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;
typedef struct _WormPrivate WormPrivate;
enum  {
	WORM_0_PROPERTY,
	WORM_STARTING_POSITION_PROPERTY,
	WORM_ID_PROPERTY,
	WORM_IS_MATERIALIZED_PROPERTY,
	WORM_LIVES_PROPERTY,
	WORM_SCORE_PROPERTY,
	WORM_LENGTH_PROPERTY,
	WORM_HEAD_PROPERTY,
	WORM_LIST_PROPERTY,
	WORM_NUM_PROPERTIES
};
static GParamSpec* worm_properties[WORM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
typedef struct _WarpPrivate WarpPrivate;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
enum  {
	WORM_ADDED_SIGNAL,
	WORM_FINISH_ADDED_SIGNAL,
	WORM_MOVED_SIGNAL,
	WORM_RESCALED_SIGNAL,
	WORM_DIED_SIGNAL,
	WORM_TAIL_REDUCED_SIGNAL,
	WORM_REVERSED_SIGNAL,
	WORM_BONUS_FOUND_SIGNAL,
	WORM_WARP_FOUND_SIGNAL,
	WORM_NUM_SIGNALS
};
static guint worm_signals[WORM_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _WormPrivate {
	Position _starting_position;
	gint _id;
	gboolean _is_materialized;
	gint rounds_dematerialized;
	gint _lives;
	gint _score;
	GeeArrayQueue* key_queue;
	GeeLinkedList* _list;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};

static gint Worm_private_offset;
static gpointer worm_parent_class = NULL;
static guint* worm_deadend_board;
static gint worm_deadend_board_length1;
static gint worm_deadend_board_length2;
static guint* worm_deadend_board = NULL;
static gint worm_deadend_board_length1 = 0;
static gint worm_deadend_board_length2 = 0;
static guint worm_deadend_runnumber;
static guint worm_deadend_runnumber = (guint) 0;

GType worm_direction_get_type (void) G_GNUC_CONST;
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GType worm_get_type (void) G_GNUC_CONST;
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define WORM_STARTING_LENGTH 5
#define WORM_STARTING_LIVES 6
#define WORM_MAX_LIVES 12
#define WORM_GROW_FACTOR 4
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type,
                      gint id);
static void worm_set_id (Worm* self,
                  gint value);
void worm_set_lives (Worm* self,
                     gint value);
void worm_set_score (Worm* self,
                     gint value);
static void worm_set_list (Worm* self,
                    GeeLinkedList* value);
void worm_set_start (Worm* self,
                     gint xhead,
                     gint yhead,
                     WormDirection direction);
GeeLinkedList* worm_get_list (Worm* self);
static void worm_set_starting_position (Worm* self,
                                 Position * value);
void worm_get_starting_position (Worm* self,
                                 Position * result);
void worm_move (Worm* self,
                gint* board,
                gint board_length1,
                gint board_length2);
void worm_get_head (Worm* self,
                    Position * result);
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_EMPTYCHAR 'a'
gboolean worm_get_is_materialized (Worm* self);
#define NIBBLES_GAME_WORMCHAR 'w'
gint worm_get_id (Worm* self);
void worm_dequeue_keypress (Worm* self);
static void worm_materialize (Worm* self,
                       gint* board,
                       gint board_length1,
                       gint board_length2);
void worm_reduce_tail (Worm* self,
                       gint* board,
                       gint board_length1,
                       gint board_length2,
                       gint erase_size);
void worm_reverse (Worm* self,
                   gint* board,
                   gint board_length1,
                   gint board_length2);
GType warp_get_type (void) G_GNUC_CONST;
void worm_warp (Worm* self,
                Warp* warp);
static void worm_set_head (Worm* self,
                    Position * value);
gboolean worm_can_move_to (Worm* self,
                           gint* board,
                           gint board_length1,
                           gint board_length2,
                           gint numworms);
static void worm_position_move (Worm* self,
                         Position* result);
gboolean worm_will_collide_with_head (Worm* self,
                                      Worm* other_worm);
static gboolean _position_equal (const Position * s1,
                          const Position * s2);
void worm_spawn (Worm* self,
                 gint* board,
                 gint board_length1,
                 gint board_length2);
static void worm_set_is_materialized (Worm* self,
                               gboolean value);
void worm_dematerialize (Worm* self,
                         gint* board,
                         gint board_length1,
                         gint board_length2,
                         gint rounds);
void worm_add_life (Worm* self);
gint worm_get_lives (Worm* self);
static void worm_lose_life (Worm* self);
void worm_reset (Worm* self,
                 gint* board,
                 gint board_length1,
                 gint board_length2);
static void worm_direction_set (Worm* self,
                         WormDirection dir);
void worm_queue_keypress (Worm* self,
                          WormDirection dir);
static guint worm_upper_key (Worm* self,
                      guint keyval);
void worm_handle_direction (Worm* self,
                            WormDirection dir);
gboolean worm_handle_keypress (Worm* self,
                               guint keyval,
                               GeeHashMap* worm_props);
static gint worm_ai_deadend (gint* board,
                      gint board_length1,
                      gint board_length2,
                      gint numworms,
                      gint x,
                      gint y,
                      gint length_left);
static gint worm_ai_deadend_after (gint* board,
                            gint board_length1,
                            gint board_length2,
                            GeeLinkedList* worms,
                            gint numworms,
                            gint x,
                            gint y,
                            gint dir,
                            gint length);
static gboolean worm_ai_too_close (Worm* self,
                            GeeLinkedList* worms,
                            gint numworms);
static gboolean worm_ai_wander (gint* board,
                         gint board_length1,
                         gint board_length2,
                         gint numworms,
                         gint x,
                         gint y,
                         gint dir,
                         gint ox,
                         gint oy);
GType bonus_type_get_type (void) G_GNUC_CONST;
void worm_ai_move (Worm* self,
                   gint* board,
                   gint board_length1,
                   gint board_length2,
                   gint numworms,
                   GeeLinkedList* worms);
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
gint worm_get_length (Worm* self);
gint worm_get_score (Worm* self);
void worm_set_length (Worm* self,
                      gint value);
static void worm_finalize (GObject * obj);
static void _vala_worm_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_worm_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);

GType
worm_direction_get_type (void)
{
	static volatile gsize worm_direction_type_id__volatile = 0;
	if (g_once_init_enter (&worm_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{WORM_DIRECTION_NONE, "WORM_DIRECTION_NONE", "none"}, {WORM_DIRECTION_RIGHT, "WORM_DIRECTION_RIGHT", "right"}, {WORM_DIRECTION_DOWN, "WORM_DIRECTION_DOWN", "down"}, {WORM_DIRECTION_LEFT, "WORM_DIRECTION_LEFT", "left"}, {WORM_DIRECTION_UP, "WORM_DIRECTION_UP", "up"}, {0, NULL, NULL}};
		GType worm_direction_type_id;
		worm_direction_type_id = g_enum_register_static ("WormDirection", values);
		g_once_init_leave (&worm_direction_type_id__volatile, worm_direction_type_id);
	}
	return worm_direction_type_id__volatile;
}

Position*
position_dup (const Position* self)
{
	Position* dup;
#line 31 "worm.vala"
	dup = g_new0 (Position, 1);
#line 31 "worm.vala"
	memcpy (dup, self, sizeof (Position));
#line 31 "worm.vala"
	return dup;
#line 351 "worm.c"
}

void
position_free (Position* self)
{
#line 31 "worm.vala"
	g_free (self);
#line 359 "worm.c"
}

GType
position_get_type (void)
{
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		GType position_type_id;
		position_type_id = g_boxed_type_register_static ("Position", (GBoxedCopyFunc) position_dup, (GBoxedFreeFunc) position_free);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}

WormProperties*
worm_properties_dup (const WormProperties* self)
{
	WormProperties* dup;
#line 37 "worm.vala"
	dup = g_new0 (WormProperties, 1);
#line 37 "worm.vala"
	memcpy (dup, self, sizeof (WormProperties));
#line 37 "worm.vala"
	return dup;
#line 384 "worm.c"
}

void
worm_properties_free (WormProperties* self)
{
#line 37 "worm.vala"
	g_free (self);
#line 392 "worm.c"
}

GType
worm_properties_get_type (void)
{
	static volatile gsize worm_properties_type_id__volatile = 0;
	if (g_once_init_enter (&worm_properties_type_id__volatile)) {
		GType worm_properties_type_id;
		worm_properties_type_id = g_boxed_type_register_static ("WormProperties", (GBoxedCopyFunc) worm_properties_dup, (GBoxedFreeFunc) worm_properties_free);
		g_once_init_leave (&worm_properties_type_id__volatile, worm_properties_type_id);
	}
	return worm_properties_type_id__volatile;
}

static inline gpointer
worm_get_instance_private (Worm* self)
{
	return G_STRUCT_MEMBER_P (self, Worm_private_offset);
}

Worm*
worm_construct (GType object_type,
                gint id)
{
	Worm * self = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeArrayQueue* _tmp2_;
#line 106 "worm.vala"
	self = (Worm*) g_object_new (object_type, NULL);
#line 108 "worm.vala"
	worm_set_id (self, id);
#line 109 "worm.vala"
	worm_set_lives (self, WORM_STARTING_LIVES);
#line 110 "worm.vala"
	worm_set_score (self, 0);
#line 111 "worm.vala"
	self->change = 0;
#line 112 "worm.vala"
	_tmp0_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, (GDestroyNotify) position_free, NULL, NULL, NULL);
#line 112 "worm.vala"
	_tmp1_ = _tmp0_;
#line 112 "worm.vala"
	worm_set_list (self, _tmp1_);
#line 112 "worm.vala"
	_g_object_unref0 (_tmp1_);
#line 113 "worm.vala"
	_tmp2_ = gee_array_queue_new (TYPE_WORM_DIRECTION, NULL, NULL, NULL, NULL, NULL);
#line 113 "worm.vala"
	_g_object_unref0 (self->priv->key_queue);
#line 113 "worm.vala"
	self->priv->key_queue = _tmp2_;
#line 106 "worm.vala"
	return self;
#line 447 "worm.c"
}

Worm*
worm_new (gint id)
{
#line 106 "worm.vala"
	return worm_construct (TYPE_WORM, id);
#line 455 "worm.c"
}

void
worm_set_start (Worm* self,
                gint xhead,
                gint yhead,
                WormDirection direction)
{
	GeeLinkedList* _tmp0_;
	Position _tmp1_ = {0};
	GeeLinkedList* _tmp2_;
	Position _tmp3_;
	WormDirection _tmp4_;
	GeeArrayQueue* _tmp5_;
#line 116 "worm.vala"
	g_return_if_fail (self != NULL);
#line 118 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 118 "worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 120 "worm.vala"
	memset (&_tmp1_, 0, sizeof (Position));
#line 120 "worm.vala"
	_tmp1_.x = xhead;
#line 120 "worm.vala"
	_tmp1_.y = yhead;
#line 120 "worm.vala"
	worm_set_starting_position (self, &_tmp1_);
#line 125 "worm.vala"
	_tmp2_ = self->priv->_list;
#line 125 "worm.vala"
	_tmp3_ = self->priv->_starting_position;
#line 125 "worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, &_tmp3_);
#line 127 "worm.vala"
	self->starting_direction = direction;
#line 128 "worm.vala"
	_tmp4_ = self->starting_direction;
#line 128 "worm.vala"
	self->direction = _tmp4_;
#line 129 "worm.vala"
	self->change = 0;
#line 130 "worm.vala"
	_tmp5_ = self->priv->key_queue;
#line 130 "worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
#line 502 "worm.c"
}

void
worm_move (Worm* self,
           gint* board,
           gint board_length1,
           gint board_length2)
{
	Position position = {0};
	Position _tmp0_ = {0};
	Position _tmp1_;
	WormDirection _tmp2_;
	GeeLinkedList* _tmp23_;
	Position _tmp24_;
	Position _tmp25_ = {0};
	Position _tmp26_;
	Position _tmp27_ = {0};
	Position _tmp28_;
	gint _tmp29_;
	Position _tmp40_ = {0};
	Position _tmp41_;
	Position _tmp42_ = {0};
	Position _tmp43_;
	gint _tmp44_;
	gboolean _tmp45_;
	GeeArrayQueue* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
#line 133 "worm.vala"
	g_return_if_fail (self != NULL);
#line 135 "worm.vala"
	if (self->is_human) {
#line 136 "worm.vala"
		self->keypress = FALSE;
#line 537 "worm.c"
	}
#line 138 "worm.vala"
	worm_get_head (self, &_tmp0_);
#line 138 "worm.vala"
	_tmp1_ = _tmp0_;
#line 138 "worm.vala"
	position = _tmp1_;
#line 139 "worm.vala"
	_tmp2_ = self->direction;
#line 139 "worm.vala"
	switch (_tmp2_) {
#line 139 "worm.vala"
		case WORM_DIRECTION_UP:
#line 551 "worm.c"
		{
			Position _tmp3_ = {0};
			Position _tmp4_;
			Position _tmp5_ = {0};
			Position _tmp6_;
			Position _tmp7_;
#line 142 "worm.vala"
			worm_get_head (self, &_tmp3_);
#line 142 "worm.vala"
			_tmp4_ = _tmp3_;
#line 142 "worm.vala"
			worm_get_head (self, &_tmp5_);
#line 142 "worm.vala"
			_tmp6_ = _tmp5_;
#line 142 "worm.vala"
			_tmp6_.y = _tmp6_.y - 1;
#line 142 "worm.vala"
			position.y = _tmp6_.y;
#line 143 "worm.vala"
			_tmp7_ = position;
#line 143 "worm.vala"
			if (_tmp7_.y < 0) {
#line 144 "worm.vala"
				position.y = NIBBLES_GAME_HEIGHT - 1;
#line 576 "worm.c"
			}
#line 145 "worm.vala"
			break;
#line 580 "worm.c"
		}
#line 139 "worm.vala"
		case WORM_DIRECTION_DOWN:
#line 584 "worm.c"
		{
			Position _tmp8_ = {0};
			Position _tmp9_;
			Position _tmp10_ = {0};
			Position _tmp11_;
			Position _tmp12_;
#line 147 "worm.vala"
			worm_get_head (self, &_tmp8_);
#line 147 "worm.vala"
			_tmp9_ = _tmp8_;
#line 147 "worm.vala"
			worm_get_head (self, &_tmp10_);
#line 147 "worm.vala"
			_tmp11_ = _tmp10_;
#line 147 "worm.vala"
			_tmp11_.y = _tmp11_.y + 1;
#line 147 "worm.vala"
			position.y = _tmp11_.y;
#line 148 "worm.vala"
			_tmp12_ = position;
#line 148 "worm.vala"
			if (_tmp12_.y >= NIBBLES_GAME_HEIGHT) {
#line 149 "worm.vala"
				position.y = 0;
#line 609 "worm.c"
			}
#line 150 "worm.vala"
			break;
#line 613 "worm.c"
		}
#line 139 "worm.vala"
		case WORM_DIRECTION_LEFT:
#line 617 "worm.c"
		{
			Position _tmp13_ = {0};
			Position _tmp14_;
			Position _tmp15_ = {0};
			Position _tmp16_;
			Position _tmp17_;
#line 152 "worm.vala"
			worm_get_head (self, &_tmp13_);
#line 152 "worm.vala"
			_tmp14_ = _tmp13_;
#line 152 "worm.vala"
			worm_get_head (self, &_tmp15_);
#line 152 "worm.vala"
			_tmp16_ = _tmp15_;
#line 152 "worm.vala"
			_tmp16_.x = _tmp16_.x - 1;
#line 152 "worm.vala"
			position.x = _tmp16_.x;
#line 153 "worm.vala"
			_tmp17_ = position;
#line 153 "worm.vala"
			if (_tmp17_.x < 0) {
#line 154 "worm.vala"
				position.x = NIBBLES_GAME_WIDTH - 1;
#line 642 "worm.c"
			}
#line 155 "worm.vala"
			break;
#line 646 "worm.c"
		}
#line 139 "worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 650 "worm.c"
		{
			Position _tmp18_ = {0};
			Position _tmp19_;
			Position _tmp20_ = {0};
			Position _tmp21_;
			Position _tmp22_;
#line 157 "worm.vala"
			worm_get_head (self, &_tmp18_);
#line 157 "worm.vala"
			_tmp19_ = _tmp18_;
#line 157 "worm.vala"
			worm_get_head (self, &_tmp20_);
#line 157 "worm.vala"
			_tmp21_ = _tmp20_;
#line 157 "worm.vala"
			_tmp21_.x = _tmp21_.x + 1;
#line 157 "worm.vala"
			position.x = _tmp21_.x;
#line 158 "worm.vala"
			_tmp22_ = position;
#line 158 "worm.vala"
			if (_tmp22_.x >= NIBBLES_GAME_WIDTH) {
#line 159 "worm.vala"
				position.x = 0;
#line 675 "worm.c"
			}
#line 160 "worm.vala"
			break;
#line 679 "worm.c"
		}
		default:
		{
#line 162 "worm.vala"
			break;
#line 685 "worm.c"
		}
	}
#line 166 "worm.vala"
	_tmp23_ = self->priv->_list;
#line 166 "worm.vala"
	_tmp24_ = position;
#line 166 "worm.vala"
	gee_deque_offer_head ((GeeDeque*) _tmp23_, &_tmp24_);
#line 168 "worm.vala"
	worm_get_head (self, &_tmp25_);
#line 168 "worm.vala"
	_tmp26_ = _tmp25_;
#line 168 "worm.vala"
	worm_get_head (self, &_tmp27_);
#line 168 "worm.vala"
	_tmp28_ = _tmp27_;
#line 168 "worm.vala"
	_tmp29_ = board[(_tmp26_.x * board_length2) + _tmp28_.y];
#line 168 "worm.vala"
	if (_tmp29_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
#line 169 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_WARP_FOUND_SIGNAL], 0);
#line 708 "worm.c"
	}
#line 171 "worm.vala"
	if (self->change > 0) {
#line 712 "worm.c"
		gint _tmp30_;
#line 173 "worm.vala"
		_tmp30_ = self->change;
#line 173 "worm.vala"
		self->change = _tmp30_ - 1;
#line 174 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_ADDED_SIGNAL], 0);
#line 720 "worm.c"
	} else {
		GeeLinkedList* _tmp31_;
		gpointer _tmp32_;
		Position* _tmp33_;
		GeeLinkedList* _tmp34_;
		gpointer _tmp35_;
		Position* _tmp36_;
		GeeLinkedList* _tmp37_;
		gpointer _tmp38_;
		Position* _tmp39_;
#line 178 "worm.vala"
		_tmp31_ = self->priv->_list;
#line 178 "worm.vala"
		_tmp32_ = gee_linked_list_last (_tmp31_);
#line 178 "worm.vala"
		_tmp33_ = (Position*) _tmp32_;
#line 178 "worm.vala"
		_tmp34_ = self->priv->_list;
#line 178 "worm.vala"
		_tmp35_ = gee_linked_list_last (_tmp34_);
#line 178 "worm.vala"
		_tmp36_ = (Position*) _tmp35_;
#line 178 "worm.vala"
		board[((*_tmp33_).x * board_length2) + (*_tmp36_).y] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 178 "worm.vala"
		_position_free0 (_tmp36_);
#line 178 "worm.vala"
		_position_free0 (_tmp33_);
#line 179 "worm.vala"
		_tmp37_ = self->priv->_list;
#line 179 "worm.vala"
		_tmp38_ = gee_deque_poll_tail ((GeeDeque*) _tmp37_);
#line 179 "worm.vala"
		_tmp39_ = (Position*) _tmp38_;
#line 179 "worm.vala"
		_position_free0 (_tmp39_);
#line 180 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_MOVED_SIGNAL], 0);
#line 759 "worm.c"
	}
#line 184 "worm.vala"
	worm_get_head (self, &_tmp40_);
#line 184 "worm.vala"
	_tmp41_ = _tmp40_;
#line 184 "worm.vala"
	worm_get_head (self, &_tmp42_);
#line 184 "worm.vala"
	_tmp43_ = _tmp42_;
#line 184 "worm.vala"
	_tmp44_ = board[(_tmp41_.x * board_length2) + _tmp43_.y];
#line 184 "worm.vala"
	if (_tmp44_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 185 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_BONUS_FOUND_SIGNAL], 0);
#line 775 "worm.c"
	}
#line 188 "worm.vala"
	_tmp45_ = self->priv->_is_materialized;
#line 188 "worm.vala"
	if (_tmp45_) {
#line 781 "worm.c"
		Position _tmp46_ = {0};
		Position _tmp47_;
		Position _tmp48_ = {0};
		Position _tmp49_;
		gint _tmp50_;
#line 189 "worm.vala"
		worm_get_head (self, &_tmp46_);
#line 189 "worm.vala"
		_tmp47_ = _tmp46_;
#line 189 "worm.vala"
		worm_get_head (self, &_tmp48_);
#line 189 "worm.vala"
		_tmp49_ = _tmp48_;
#line 189 "worm.vala"
		_tmp50_ = self->priv->_id;
#line 189 "worm.vala"
		board[(_tmp47_.x * board_length2) + _tmp49_.y] = NIBBLES_GAME_WORMCHAR + _tmp50_;
#line 799 "worm.c"
	} else {
#line 191 "worm.vala"
		self->priv->rounds_dematerialized = self->priv->rounds_dematerialized - 1;
#line 803 "worm.c"
	}
#line 193 "worm.vala"
	_tmp51_ = self->priv->key_queue;
#line 193 "worm.vala"
	_tmp52_ = gee_array_queue_get_is_empty (_tmp51_);
#line 193 "worm.vala"
	_tmp53_ = _tmp52_;
#line 193 "worm.vala"
	if (!_tmp53_) {
#line 194 "worm.vala"
		worm_dequeue_keypress (self);
#line 815 "worm.c"
	}
#line 196 "worm.vala"
	if (self->priv->rounds_dematerialized == 1) {
#line 197 "worm.vala"
		worm_materialize (self, board, (gint) board_length1, (gint) board_length2);
#line 821 "worm.c"
	}
}

void
worm_reduce_tail (Worm* self,
                  gint* board,
                  gint board_length1,
                  gint board_length2,
                  gint erase_size)
{
#line 200 "worm.vala"
	g_return_if_fail (self != NULL);
#line 202 "worm.vala"
	if (erase_size > 0) {
#line 836 "worm.c"
		{
			gint i = 0;
#line 204 "worm.vala"
			i = 0;
#line 841 "worm.c"
			{
				gboolean _tmp0_ = FALSE;
#line 204 "worm.vala"
				_tmp0_ = TRUE;
#line 204 "worm.vala"
				while (TRUE) {
#line 848 "worm.c"
					GeeLinkedList* _tmp2_;
					gpointer _tmp3_;
					Position* _tmp4_;
					GeeLinkedList* _tmp5_;
					gpointer _tmp6_;
					Position* _tmp7_;
					GeeLinkedList* _tmp8_;
					gpointer _tmp9_;
					Position* _tmp10_;
#line 204 "worm.vala"
					if (!_tmp0_) {
#line 860 "worm.c"
						gint _tmp1_;
#line 204 "worm.vala"
						_tmp1_ = i;
#line 204 "worm.vala"
						i = _tmp1_ + 1;
#line 866 "worm.c"
					}
#line 204 "worm.vala"
					_tmp0_ = FALSE;
#line 204 "worm.vala"
					if (!(i < erase_size)) {
#line 204 "worm.vala"
						break;
#line 874 "worm.c"
					}
#line 206 "worm.vala"
					_tmp2_ = self->priv->_list;
#line 206 "worm.vala"
					_tmp3_ = gee_linked_list_last (_tmp2_);
#line 206 "worm.vala"
					_tmp4_ = (Position*) _tmp3_;
#line 206 "worm.vala"
					_tmp5_ = self->priv->_list;
#line 206 "worm.vala"
					_tmp6_ = gee_linked_list_last (_tmp5_);
#line 206 "worm.vala"
					_tmp7_ = (Position*) _tmp6_;
#line 206 "worm.vala"
					board[((*_tmp4_).x * board_length2) + (*_tmp7_).y] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 206 "worm.vala"
					_position_free0 (_tmp7_);
#line 206 "worm.vala"
					_position_free0 (_tmp4_);
#line 207 "worm.vala"
					_tmp8_ = self->priv->_list;
#line 207 "worm.vala"
					_tmp9_ = gee_deque_poll_tail ((GeeDeque*) _tmp8_);
#line 207 "worm.vala"
					_tmp10_ = (Position*) _tmp9_;
#line 207 "worm.vala"
					_position_free0 (_tmp10_);
#line 902 "worm.c"
				}
			}
		}
#line 209 "worm.vala"
		g_signal_emit (self, worm_signals[WORM_TAIL_REDUCED_SIGNAL], 0, erase_size);
#line 908 "worm.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 216 "worm.vala"
	return self ? g_object_ref (self) : NULL;
#line 917 "worm.c"
}

void
worm_reverse (Worm* self,
              gint* board,
              gint board_length1,
              gint board_length2)
{
	GeeLinkedList* reversed_list = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp10_;
	GeeLinkedList* _tmp11_;
	gpointer _tmp12_;
	Position* _tmp13_;
	GeeLinkedList* _tmp14_;
	gpointer _tmp15_;
	Position* _tmp16_;
	gboolean _tmp17_;
#line 213 "worm.vala"
	g_return_if_fail (self != NULL);
#line 215 "worm.vala"
	_tmp0_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, (GDestroyNotify) position_free, NULL, NULL, NULL);
#line 215 "worm.vala"
	reversed_list = _tmp0_;
#line 942 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index = 0;
#line 216 "worm.vala"
		_tmp1_ = self->priv->_list;
#line 216 "worm.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 216 "worm.vala"
		_pos_list = _tmp2_;
#line 216 "worm.vala"
		_tmp3_ = _pos_list;
#line 216 "worm.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 216 "worm.vala"
		_tmp5_ = _tmp4_;
#line 216 "worm.vala"
		_pos_size = _tmp5_;
#line 216 "worm.vala"
		_pos_index = -1;
#line 216 "worm.vala"
		while (TRUE) {
#line 970 "worm.c"
			Position* pos = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			GeeLinkedList* _tmp8_;
			Position* _tmp9_;
#line 216 "worm.vala"
			_pos_index = _pos_index + 1;
#line 216 "worm.vala"
			if (!(_pos_index < _pos_size)) {
#line 216 "worm.vala"
				break;
#line 982 "worm.c"
			}
#line 216 "worm.vala"
			_tmp6_ = _pos_list;
#line 216 "worm.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _pos_index);
#line 216 "worm.vala"
			pos = (Position*) _tmp7_;
#line 217 "worm.vala"
			_tmp8_ = reversed_list;
#line 217 "worm.vala"
			_tmp9_ = pos;
#line 217 "worm.vala"
			gee_deque_offer_head ((GeeDeque*) _tmp8_, _tmp9_);
#line 216 "worm.vala"
			_position_free0 (pos);
#line 998 "worm.c"
		}
#line 216 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1002 "worm.c"
	}
#line 219 "worm.vala"
	g_signal_emit (self, worm_signals[WORM_REVERSED_SIGNAL], 0);
#line 220 "worm.vala"
	_tmp10_ = reversed_list;
#line 220 "worm.vala"
	worm_set_list (self, _tmp10_);
#line 223 "worm.vala"
	_tmp11_ = self->priv->_list;
#line 223 "worm.vala"
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, 0);
#line 223 "worm.vala"
	_tmp13_ = (Position*) _tmp12_;
#line 223 "worm.vala"
	_tmp14_ = self->priv->_list;
#line 223 "worm.vala"
	_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, 1);
#line 223 "worm.vala"
	_tmp16_ = (Position*) _tmp15_;
#line 223 "worm.vala"
	_tmp17_ = (*_tmp13_).y == (*_tmp16_).y;
#line 223 "worm.vala"
	_position_free0 (_tmp16_);
#line 223 "worm.vala"
	_position_free0 (_tmp13_);
#line 223 "worm.vala"
	if (_tmp17_) {
#line 1030 "worm.c"
		WormDirection _tmp18_ = 0;
		GeeLinkedList* _tmp19_;
		gpointer _tmp20_;
		Position* _tmp21_;
		GeeLinkedList* _tmp22_;
		gpointer _tmp23_;
		Position* _tmp24_;
		gboolean _tmp25_;
#line 224 "worm.vala"
		_tmp19_ = self->priv->_list;
#line 224 "worm.vala"
		_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 0);
#line 224 "worm.vala"
		_tmp21_ = (Position*) _tmp20_;
#line 224 "worm.vala"
		_tmp22_ = self->priv->_list;
#line 224 "worm.vala"
		_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, 1);
#line 224 "worm.vala"
		_tmp24_ = (Position*) _tmp23_;
#line 224 "worm.vala"
		_tmp25_ = (*_tmp21_).x > (*_tmp24_).x;
#line 224 "worm.vala"
		_position_free0 (_tmp24_);
#line 224 "worm.vala"
		_position_free0 (_tmp21_);
#line 224 "worm.vala"
		if (_tmp25_) {
#line 224 "worm.vala"
			_tmp18_ = WORM_DIRECTION_RIGHT;
#line 1061 "worm.c"
		} else {
#line 224 "worm.vala"
			_tmp18_ = WORM_DIRECTION_LEFT;
#line 1065 "worm.c"
		}
#line 224 "worm.vala"
		self->direction = _tmp18_;
#line 1069 "worm.c"
	} else {
		WormDirection _tmp26_ = 0;
		GeeLinkedList* _tmp27_;
		gpointer _tmp28_;
		Position* _tmp29_;
		GeeLinkedList* _tmp30_;
		gpointer _tmp31_;
		Position* _tmp32_;
		gboolean _tmp33_;
#line 226 "worm.vala"
		_tmp27_ = self->priv->_list;
#line 226 "worm.vala"
		_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, 0);
#line 226 "worm.vala"
		_tmp29_ = (Position*) _tmp28_;
#line 226 "worm.vala"
		_tmp30_ = self->priv->_list;
#line 226 "worm.vala"
		_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, 1);
#line 226 "worm.vala"
		_tmp32_ = (Position*) _tmp31_;
#line 226 "worm.vala"
		_tmp33_ = (*_tmp29_).y > (*_tmp32_).y;
#line 226 "worm.vala"
		_position_free0 (_tmp32_);
#line 226 "worm.vala"
		_position_free0 (_tmp29_);
#line 226 "worm.vala"
		if (_tmp33_) {
#line 226 "worm.vala"
			_tmp26_ = WORM_DIRECTION_DOWN;
#line 1101 "worm.c"
		} else {
#line 226 "worm.vala"
			_tmp26_ = WORM_DIRECTION_UP;
#line 1105 "worm.c"
		}
#line 226 "worm.vala"
		self->direction = _tmp26_;
#line 1109 "worm.c"
	}
#line 213 "worm.vala"
	_g_object_unref0 (reversed_list);
#line 1113 "worm.c"
}

void
worm_warp (Worm* self,
           Warp* warp)
{
	Position _tmp0_ = {0};
#line 229 "worm.vala"
	g_return_if_fail (self != NULL);
#line 229 "worm.vala"
	g_return_if_fail (warp != NULL);
#line 231 "worm.vala"
	memset (&_tmp0_, 0, sizeof (Position));
#line 231 "worm.vala"
	_tmp0_.x = warp->wx;
#line 231 "worm.vala"
	_tmp0_.y = warp->wy;
#line 231 "worm.vala"
	worm_set_head (self, &_tmp0_);
#line 1133 "worm.c"
}

gboolean
worm_can_move_to (Worm* self,
                  gint* board,
                  gint board_length1,
                  gint board_length2,
                  gint numworms)
{
	gboolean result = FALSE;
	Position position = {0};
	Position _tmp0_ = {0};
	gint next_position = 0;
	Position _tmp1_;
	Position _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
#line 234 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 236 "worm.vala"
	worm_position_move (self, &_tmp0_);
#line 236 "worm.vala"
	position = _tmp0_;
#line 237 "worm.vala"
	_tmp1_ = position;
#line 237 "worm.vala"
	_tmp2_ = position;
#line 237 "worm.vala"
	_tmp3_ = board[(_tmp1_.x * board_length2) + _tmp2_.y];
#line 237 "worm.vala"
	next_position = _tmp3_;
#line 239 "worm.vala"
	if (next_position > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 240 "worm.vala"
		_tmp4_ = next_position < ((gint) NIBBLES_GAME_WORMCHAR);
#line 1170 "worm.c"
	} else {
#line 239 "worm.vala"
		_tmp4_ = FALSE;
#line 1174 "worm.c"
	}
#line 239 "worm.vala"
	if (_tmp4_) {
#line 241 "worm.vala"
		result = FALSE;
#line 241 "worm.vala"
		return result;
#line 1182 "worm.c"
	}
#line 243 "worm.vala"
	if (next_position >= ((gint) NIBBLES_GAME_WORMCHAR)) {
#line 244 "worm.vala"
		_tmp5_ = next_position < (NIBBLES_GAME_WORMCHAR + numworms);
#line 1188 "worm.c"
	} else {
#line 243 "worm.vala"
		_tmp5_ = FALSE;
#line 1192 "worm.c"
	}
#line 243 "worm.vala"
	if (_tmp5_) {
#line 1196 "worm.c"
		gboolean _tmp6_;
#line 245 "worm.vala"
		_tmp6_ = self->priv->_is_materialized;
#line 245 "worm.vala"
		result = !_tmp6_;
#line 245 "worm.vala"
		return result;
#line 1204 "worm.c"
	}
#line 247 "worm.vala"
	result = TRUE;
#line 247 "worm.vala"
	return result;
#line 1210 "worm.c"
}

static gboolean
_position_equal (const Position * s1,
                 const Position * s2)
{
#line 258 "worm.vala"
	if (s1 == s2) {
#line 258 "worm.vala"
		return TRUE;
#line 1221 "worm.c"
	}
#line 258 "worm.vala"
	if (s1 == NULL) {
#line 258 "worm.vala"
		return FALSE;
#line 1227 "worm.c"
	}
#line 258 "worm.vala"
	if (s2 == NULL) {
#line 258 "worm.vala"
		return FALSE;
#line 1233 "worm.c"
	}
#line 258 "worm.vala"
	if (s1->x != s2->x) {
#line 258 "worm.vala"
		return FALSE;
#line 1239 "worm.c"
	}
#line 258 "worm.vala"
	if (s1->y != s2->y) {
#line 258 "worm.vala"
		return FALSE;
#line 1245 "worm.c"
	}
#line 258 "worm.vala"
	return TRUE;
#line 1249 "worm.c"
}

gboolean
worm_will_collide_with_head (Worm* self,
                             Worm* other_worm)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	Position worm_pos = {0};
	Position _tmp3_ = {0};
	Position other_worm_pos = {0};
	Position _tmp4_ = {0};
	Position _tmp5_;
	Position _tmp6_;
#line 250 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 250 "worm.vala"
	g_return_val_if_fail (other_worm != NULL, FALSE);
#line 252 "worm.vala"
	_tmp1_ = self->priv->_is_materialized;
#line 252 "worm.vala"
	if (!_tmp1_) {
#line 252 "worm.vala"
		_tmp0_ = TRUE;
#line 1275 "worm.c"
	} else {
		gboolean _tmp2_;
#line 252 "worm.vala"
		_tmp2_ = other_worm->priv->_is_materialized;
#line 252 "worm.vala"
		_tmp0_ = !_tmp2_;
#line 1282 "worm.c"
	}
#line 252 "worm.vala"
	if (_tmp0_) {
#line 253 "worm.vala"
		result = FALSE;
#line 253 "worm.vala"
		return result;
#line 1290 "worm.c"
	}
#line 255 "worm.vala"
	worm_position_move (self, &_tmp3_);
#line 255 "worm.vala"
	worm_pos = _tmp3_;
#line 256 "worm.vala"
	worm_position_move (other_worm, &_tmp4_);
#line 256 "worm.vala"
	other_worm_pos = _tmp4_;
#line 258 "worm.vala"
	_tmp5_ = worm_pos;
#line 258 "worm.vala"
	_tmp6_ = other_worm_pos;
#line 258 "worm.vala"
	if (_position_equal (&_tmp5_, &_tmp6_) == TRUE) {
#line 259 "worm.vala"
		result = TRUE;
#line 259 "worm.vala"
		return result;
#line 1310 "worm.c"
	}
#line 261 "worm.vala"
	result = FALSE;
#line 261 "worm.vala"
	return result;
#line 1316 "worm.c"
}

void
worm_spawn (Worm* self,
            gint* board,
            gint board_length1,
            gint board_length2)
{
#line 264 "worm.vala"
	g_return_if_fail (self != NULL);
#line 266 "worm.vala"
	self->change = WORM_STARTING_LENGTH - 1;
#line 1329 "worm.c"
	{
		gint i = 0;
#line 267 "worm.vala"
		i = 0;
#line 1334 "worm.c"
		{
			gboolean _tmp0_ = FALSE;
#line 267 "worm.vala"
			_tmp0_ = TRUE;
#line 267 "worm.vala"
			while (TRUE) {
#line 267 "worm.vala"
				if (!_tmp0_) {
#line 1343 "worm.c"
					gint _tmp1_;
#line 267 "worm.vala"
					_tmp1_ = i;
#line 267 "worm.vala"
					i = _tmp1_ + 1;
#line 1349 "worm.c"
				}
#line 267 "worm.vala"
				_tmp0_ = FALSE;
#line 267 "worm.vala"
				if (!(i < WORM_STARTING_LENGTH)) {
#line 267 "worm.vala"
					break;
#line 1357 "worm.c"
				}
#line 268 "worm.vala"
				worm_move (self, board, (gint) board_length1, (gint) board_length2);
#line 1361 "worm.c"
			}
		}
	}
}

static void
worm_materialize (Worm* self,
                  gint* board,
                  gint board_length1,
                  gint board_length2)
{
#line 271 "worm.vala"
	g_return_if_fail (self != NULL);
#line 1375 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pos_index = 0;
#line 273 "worm.vala"
		_tmp0_ = self->priv->_list;
#line 273 "worm.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 273 "worm.vala"
		_pos_list = _tmp1_;
#line 273 "worm.vala"
		_tmp2_ = _pos_list;
#line 273 "worm.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 273 "worm.vala"
		_tmp4_ = _tmp3_;
#line 273 "worm.vala"
		_pos_size = _tmp4_;
#line 273 "worm.vala"
		_pos_index = -1;
#line 273 "worm.vala"
		while (TRUE) {
#line 1403 "worm.c"
			Position* pos = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			Position* _tmp7_;
			Position* _tmp8_;
			gint _tmp9_;
#line 273 "worm.vala"
			_pos_index = _pos_index + 1;
#line 273 "worm.vala"
			if (!(_pos_index < _pos_size)) {
#line 273 "worm.vala"
				break;
#line 1416 "worm.c"
			}
#line 273 "worm.vala"
			_tmp5_ = _pos_list;
#line 273 "worm.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _pos_index);
#line 273 "worm.vala"
			pos = (Position*) _tmp6_;
#line 275 "worm.vala"
			_tmp7_ = pos;
#line 275 "worm.vala"
			_tmp8_ = pos;
#line 275 "worm.vala"
			_tmp9_ = board[((*_tmp7_).x * board_length2) + (*_tmp8_).y];
#line 275 "worm.vala"
			if (_tmp9_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 277 "worm.vala"
				self->priv->rounds_dematerialized = self->priv->rounds_dematerialized + 1;
#line 278 "worm.vala"
				_position_free0 (pos);
#line 278 "worm.vala"
				_g_object_unref0 (_pos_list);
#line 278 "worm.vala"
				return;
#line 1440 "worm.c"
			}
#line 273 "worm.vala"
			_position_free0 (pos);
#line 1444 "worm.c"
		}
#line 273 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1448 "worm.c"
	}
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp10_;
		GeeLinkedList* _tmp11_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _pos_index = 0;
#line 281 "worm.vala"
		_tmp10_ = self->priv->_list;
#line 281 "worm.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 281 "worm.vala"
		_pos_list = _tmp11_;
#line 281 "worm.vala"
		_tmp12_ = _pos_list;
#line 281 "worm.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
#line 281 "worm.vala"
		_tmp14_ = _tmp13_;
#line 281 "worm.vala"
		_pos_size = _tmp14_;
#line 281 "worm.vala"
		_pos_index = -1;
#line 281 "worm.vala"
		while (TRUE) {
#line 1477 "worm.c"
			Position* pos = NULL;
			GeeLinkedList* _tmp15_;
			gpointer _tmp16_;
			Position* _tmp17_;
			Position* _tmp18_;
			gint _tmp19_;
#line 281 "worm.vala"
			_pos_index = _pos_index + 1;
#line 281 "worm.vala"
			if (!(_pos_index < _pos_size)) {
#line 281 "worm.vala"
				break;
#line 1490 "worm.c"
			}
#line 281 "worm.vala"
			_tmp15_ = _pos_list;
#line 281 "worm.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _pos_index);
#line 281 "worm.vala"
			pos = (Position*) _tmp16_;
#line 282 "worm.vala"
			_tmp17_ = pos;
#line 282 "worm.vala"
			_tmp18_ = pos;
#line 282 "worm.vala"
			_tmp19_ = self->priv->_id;
#line 282 "worm.vala"
			board[((*_tmp17_).x * board_length2) + (*_tmp18_).y] = NIBBLES_GAME_WORMCHAR + _tmp19_;
#line 281 "worm.vala"
			_position_free0 (pos);
#line 1508 "worm.c"
		}
#line 281 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1512 "worm.c"
	}
#line 283 "worm.vala"
	worm_set_is_materialized (self, TRUE);
#line 284 "worm.vala"
	self->priv->rounds_dematerialized = 0;
#line 1518 "worm.c"
}

void
worm_dematerialize (Worm* self,
                    gint* board,
                    gint board_length1,
                    gint board_length2,
                    gint rounds)
{
#line 287 "worm.vala"
	g_return_if_fail (self != NULL);
#line 289 "worm.vala"
	self->priv->rounds_dematerialized = rounds;
#line 290 "worm.vala"
	worm_set_is_materialized (self, FALSE);
#line 1534 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pos_index = 0;
#line 291 "worm.vala"
		_tmp0_ = self->priv->_list;
#line 291 "worm.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 291 "worm.vala"
		_pos_list = _tmp1_;
#line 291 "worm.vala"
		_tmp2_ = _pos_list;
#line 291 "worm.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 291 "worm.vala"
		_tmp4_ = _tmp3_;
#line 291 "worm.vala"
		_pos_size = _tmp4_;
#line 291 "worm.vala"
		_pos_index = -1;
#line 291 "worm.vala"
		while (TRUE) {
#line 1562 "worm.c"
			Position* pos = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			Position* _tmp7_;
			Position* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
#line 291 "worm.vala"
			_pos_index = _pos_index + 1;
#line 291 "worm.vala"
			if (!(_pos_index < _pos_size)) {
#line 291 "worm.vala"
				break;
#line 1576 "worm.c"
			}
#line 291 "worm.vala"
			_tmp5_ = _pos_list;
#line 291 "worm.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _pos_index);
#line 291 "worm.vala"
			pos = (Position*) _tmp6_;
#line 293 "worm.vala"
			_tmp7_ = pos;
#line 293 "worm.vala"
			_tmp8_ = pos;
#line 293 "worm.vala"
			_tmp9_ = board[((*_tmp7_).x * board_length2) + (*_tmp8_).y];
#line 293 "worm.vala"
			_tmp10_ = self->priv->_id;
#line 293 "worm.vala"
			if (_tmp9_ == (NIBBLES_GAME_WORMCHAR + _tmp10_)) {
#line 1594 "worm.c"
				Position* _tmp11_;
				Position* _tmp12_;
#line 294 "worm.vala"
				_tmp11_ = pos;
#line 294 "worm.vala"
				_tmp12_ = pos;
#line 294 "worm.vala"
				board[((*_tmp11_).x * board_length2) + (*_tmp12_).y] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 1603 "worm.c"
			}
#line 291 "worm.vala"
			_position_free0 (pos);
#line 1607 "worm.c"
		}
#line 291 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1611 "worm.c"
	}
}

void
worm_add_life (Worm* self)
{
	gint _tmp0_;
	gint _tmp1_;
#line 298 "worm.vala"
	g_return_if_fail (self != NULL);
#line 300 "worm.vala"
	_tmp0_ = self->priv->_lives;
#line 300 "worm.vala"
	if (_tmp0_ > WORM_MAX_LIVES) {
#line 301 "worm.vala"
		return;
#line 1628 "worm.c"
	}
#line 303 "worm.vala"
	_tmp1_ = self->priv->_lives;
#line 303 "worm.vala"
	worm_set_lives (self, _tmp1_ + 1);
#line 1634 "worm.c"
}

static void
worm_lose_life (Worm* self)
{
	gint _tmp0_;
#line 306 "worm.vala"
	g_return_if_fail (self != NULL);
#line 308 "worm.vala"
	_tmp0_ = self->priv->_lives;
#line 308 "worm.vala"
	worm_set_lives (self, _tmp0_ - 1);
#line 1647 "worm.c"
}

void
worm_reset (Worm* self,
            gint* board,
            gint board_length1,
            gint board_length2)
{
	GeeArrayQueue* _tmp0_;
	GeeLinkedList* _tmp10_;
	GeeLinkedList* _tmp11_;
	Position _tmp12_;
	WormDirection _tmp13_;
#line 311 "worm.vala"
	g_return_if_fail (self != NULL);
#line 313 "worm.vala"
	self->is_stopped = TRUE;
#line 314 "worm.vala"
	worm_set_is_materialized (self, FALSE);
#line 315 "worm.vala"
	self->priv->rounds_dematerialized = 0;
#line 317 "worm.vala"
	_tmp0_ = self->priv->key_queue;
#line 317 "worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 319 "worm.vala"
	worm_lose_life (self);
#line 321 "worm.vala"
	g_signal_emit (self, worm_signals[WORM_DIED_SIGNAL], 0);
#line 1677 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pos_index = 0;
#line 322 "worm.vala"
		_tmp1_ = self->priv->_list;
#line 322 "worm.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 322 "worm.vala"
		_pos_list = _tmp2_;
#line 322 "worm.vala"
		_tmp3_ = _pos_list;
#line 322 "worm.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 322 "worm.vala"
		_tmp5_ = _tmp4_;
#line 322 "worm.vala"
		_pos_size = _tmp5_;
#line 322 "worm.vala"
		_pos_index = -1;
#line 322 "worm.vala"
		while (TRUE) {
#line 1705 "worm.c"
			Position* pos = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Position* _tmp8_;
			Position* _tmp9_;
#line 322 "worm.vala"
			_pos_index = _pos_index + 1;
#line 322 "worm.vala"
			if (!(_pos_index < _pos_size)) {
#line 322 "worm.vala"
				break;
#line 1717 "worm.c"
			}
#line 322 "worm.vala"
			_tmp6_ = _pos_list;
#line 322 "worm.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _pos_index);
#line 322 "worm.vala"
			pos = (Position*) _tmp7_;
#line 323 "worm.vala"
			_tmp8_ = pos;
#line 323 "worm.vala"
			_tmp9_ = pos;
#line 323 "worm.vala"
			board[((*_tmp8_).x * board_length2) + (*_tmp9_).y] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 322 "worm.vala"
			_position_free0 (pos);
#line 1733 "worm.c"
		}
#line 322 "worm.vala"
		_g_object_unref0 (_pos_list);
#line 1737 "worm.c"
	}
#line 325 "worm.vala"
	_tmp10_ = self->priv->_list;
#line 325 "worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
#line 326 "worm.vala"
	_tmp11_ = self->priv->_list;
#line 326 "worm.vala"
	_tmp12_ = self->priv->_starting_position;
#line 326 "worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, &_tmp12_);
#line 327 "worm.vala"
	g_signal_emit (self, worm_signals[WORM_ADDED_SIGNAL], 0);
#line 329 "worm.vala"
	_tmp13_ = self->starting_direction;
#line 329 "worm.vala"
	self->direction = _tmp13_;
#line 330 "worm.vala"
	self->change = 0;
#line 331 "worm.vala"
	worm_spawn (self, board, (gint) board_length1, (gint) board_length2);
#line 333 "worm.vala"
	g_signal_emit (self, worm_signals[WORM_FINISH_ADDED_SIGNAL], 0);
#line 1761 "worm.c"
}

static void
worm_position_move (Worm* self,
                    Position* result)
{
	Position position = {0};
	Position _tmp0_ = {0};
	Position _tmp1_;
	WormDirection _tmp2_;
#line 336 "worm.vala"
	g_return_if_fail (self != NULL);
#line 338 "worm.vala"
	worm_get_head (self, &_tmp0_);
#line 338 "worm.vala"
	_tmp1_ = _tmp0_;
#line 338 "worm.vala"
	position = _tmp1_;
#line 340 "worm.vala"
	_tmp2_ = self->direction;
#line 340 "worm.vala"
	switch (_tmp2_) {
#line 340 "worm.vala"
		case WORM_DIRECTION_UP:
#line 1786 "worm.c"
		{
			Position _tmp3_ = {0};
			Position _tmp4_;
			Position _tmp5_ = {0};
			Position _tmp6_;
			Position _tmp7_;
#line 343 "worm.vala"
			worm_get_head (self, &_tmp3_);
#line 343 "worm.vala"
			_tmp4_ = _tmp3_;
#line 343 "worm.vala"
			worm_get_head (self, &_tmp5_);
#line 343 "worm.vala"
			_tmp6_ = _tmp5_;
#line 343 "worm.vala"
			_tmp6_.y = _tmp6_.y - 1;
#line 343 "worm.vala"
			position.y = _tmp6_.y;
#line 344 "worm.vala"
			_tmp7_ = position;
#line 344 "worm.vala"
			if (_tmp7_.y < 0) {
#line 345 "worm.vala"
				position.y = NIBBLES_GAME_HEIGHT - 1;
#line 1811 "worm.c"
			}
#line 346 "worm.vala"
			break;
#line 1815 "worm.c"
		}
#line 340 "worm.vala"
		case WORM_DIRECTION_DOWN:
#line 1819 "worm.c"
		{
			Position _tmp8_ = {0};
			Position _tmp9_;
			Position _tmp10_ = {0};
			Position _tmp11_;
			Position _tmp12_;
#line 348 "worm.vala"
			worm_get_head (self, &_tmp8_);
#line 348 "worm.vala"
			_tmp9_ = _tmp8_;
#line 348 "worm.vala"
			worm_get_head (self, &_tmp10_);
#line 348 "worm.vala"
			_tmp11_ = _tmp10_;
#line 348 "worm.vala"
			_tmp11_.y = _tmp11_.y + 1;
#line 348 "worm.vala"
			position.y = _tmp11_.y;
#line 349 "worm.vala"
			_tmp12_ = position;
#line 349 "worm.vala"
			if (_tmp12_.y >= NIBBLES_GAME_HEIGHT) {
#line 350 "worm.vala"
				position.y = 0;
#line 1844 "worm.c"
			}
#line 351 "worm.vala"
			break;
#line 1848 "worm.c"
		}
#line 340 "worm.vala"
		case WORM_DIRECTION_LEFT:
#line 1852 "worm.c"
		{
			Position _tmp13_ = {0};
			Position _tmp14_;
			Position _tmp15_ = {0};
			Position _tmp16_;
			Position _tmp17_;
#line 353 "worm.vala"
			worm_get_head (self, &_tmp13_);
#line 353 "worm.vala"
			_tmp14_ = _tmp13_;
#line 353 "worm.vala"
			worm_get_head (self, &_tmp15_);
#line 353 "worm.vala"
			_tmp16_ = _tmp15_;
#line 353 "worm.vala"
			_tmp16_.x = _tmp16_.x - 1;
#line 353 "worm.vala"
			position.x = _tmp16_.x;
#line 354 "worm.vala"
			_tmp17_ = position;
#line 354 "worm.vala"
			if (_tmp17_.x < 0) {
#line 355 "worm.vala"
				position.x = NIBBLES_GAME_WIDTH - 1;
#line 1877 "worm.c"
			}
#line 356 "worm.vala"
			break;
#line 1881 "worm.c"
		}
#line 340 "worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 1885 "worm.c"
		{
			Position _tmp18_ = {0};
			Position _tmp19_;
			Position _tmp20_ = {0};
			Position _tmp21_;
			Position _tmp22_;
#line 358 "worm.vala"
			worm_get_head (self, &_tmp18_);
#line 358 "worm.vala"
			_tmp19_ = _tmp18_;
#line 358 "worm.vala"
			worm_get_head (self, &_tmp20_);
#line 358 "worm.vala"
			_tmp21_ = _tmp20_;
#line 358 "worm.vala"
			_tmp21_.x = _tmp21_.x + 1;
#line 358 "worm.vala"
			position.x = _tmp21_.x;
#line 359 "worm.vala"
			_tmp22_ = position;
#line 359 "worm.vala"
			if (_tmp22_.x >= NIBBLES_GAME_WIDTH) {
#line 360 "worm.vala"
				position.x = 0;
#line 1910 "worm.c"
			}
#line 361 "worm.vala"
			break;
#line 1914 "worm.c"
		}
		default:
		{
#line 363 "worm.vala"
			break;
#line 1920 "worm.c"
		}
	}
#line 366 "worm.vala"
	*result = position;
#line 366 "worm.vala"
	return;
#line 1927 "worm.c"
}

static void
worm_direction_set (Worm* self,
                    WormDirection dir)
{
#line 369 "worm.vala"
	g_return_if_fail (self != NULL);
#line 371 "worm.vala"
	if (!self->is_human) {
#line 372 "worm.vala"
		return;
#line 1940 "worm.c"
	}
#line 374 "worm.vala"
	if (dir > 4) {
#line 375 "worm.vala"
		dir = (WormDirection) 1;
#line 1946 "worm.c"
	}
#line 376 "worm.vala"
	if (dir < 1) {
#line 377 "worm.vala"
		dir = (WormDirection) 4;
#line 1952 "worm.c"
	}
#line 379 "worm.vala"
	if (self->keypress) {
#line 381 "worm.vala"
		worm_queue_keypress (self, dir);
#line 382 "worm.vala"
		return;
#line 1960 "worm.c"
	}
#line 385 "worm.vala"
	self->direction = (WormDirection) dir;
#line 386 "worm.vala"
	self->keypress = TRUE;
#line 1966 "worm.c"
}

static guint
worm_upper_key (Worm* self,
                guint keyval)
{
	guint result = 0U;
#line 392 "worm.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 394 "worm.vala"
	if (keyval > ((guint) 255)) {
#line 395 "worm.vala"
		result = keyval;
#line 395 "worm.vala"
		return result;
#line 1982 "worm.c"
	}
#line 396 "worm.vala"
	result = (guint) g_ascii_toupper ((gchar) keyval);
#line 396 "worm.vala"
	return result;
#line 1988 "worm.c"
}

void
worm_handle_direction (Worm* self,
                       WormDirection dir)
{
#line 399 "worm.vala"
	g_return_if_fail (self != NULL);
#line 401 "worm.vala"
	worm_direction_set (self, dir);
#line 1999 "worm.c"
}

gboolean
worm_handle_keypress (Worm* self,
                      guint keyval,
                      GeeHashMap* worm_props)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	WormProperties properties = {0};
	guint propsUp = 0U;
	guint propsDown = 0U;
	guint propsLeft = 0U;
	guint propsRight = 0U;
	guint keyvalUpper = 0U;
	gpointer _tmp2_;
	WormProperties* _tmp3_;
	WormProperties _tmp4_;
	WormProperties _tmp5_;
	WormProperties _tmp6_;
	WormProperties _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp14_ = FALSE;
#line 404 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 404 "worm.vala"
	g_return_val_if_fail (worm_props != NULL, FALSE);
#line 406 "worm.vala"
	_tmp1_ = self->priv->_lives;
#line 406 "worm.vala"
	if (_tmp1_ <= 0) {
#line 406 "worm.vala"
		_tmp0_ = TRUE;
#line 2036 "worm.c"
	} else {
#line 406 "worm.vala"
		_tmp0_ = self->is_stopped;
#line 2040 "worm.c"
	}
#line 406 "worm.vala"
	if (_tmp0_) {
#line 407 "worm.vala"
		result = FALSE;
#line 407 "worm.vala"
		return result;
#line 2048 "worm.c"
	}
#line 412 "worm.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) worm_props, self);
#line 412 "worm.vala"
	_tmp3_ = (WormProperties*) _tmp2_;
#line 412 "worm.vala"
	properties = *_tmp3_;
#line 412 "worm.vala"
	_worm_properties_free0 (_tmp3_);
#line 413 "worm.vala"
	_tmp4_ = properties;
#line 413 "worm.vala"
	propsUp = worm_upper_key (self, _tmp4_.up);
#line 414 "worm.vala"
	_tmp5_ = properties;
#line 414 "worm.vala"
	propsLeft = worm_upper_key (self, _tmp5_.left);
#line 415 "worm.vala"
	_tmp6_ = properties;
#line 415 "worm.vala"
	propsDown = worm_upper_key (self, _tmp6_.down);
#line 416 "worm.vala"
	_tmp7_ = properties;
#line 416 "worm.vala"
	propsRight = worm_upper_key (self, _tmp7_.right);
#line 417 "worm.vala"
	keyvalUpper = worm_upper_key (self, keyval);
#line 419 "worm.vala"
	if (keyvalUpper == propsUp) {
#line 2078 "worm.c"
		WormDirection _tmp9_;
#line 419 "worm.vala"
		_tmp9_ = self->direction;
#line 419 "worm.vala"
		_tmp8_ = _tmp9_ != WORM_DIRECTION_DOWN;
#line 2084 "worm.c"
	} else {
#line 419 "worm.vala"
		_tmp8_ = FALSE;
#line 2088 "worm.c"
	}
#line 419 "worm.vala"
	if (_tmp8_) {
#line 421 "worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_UP);
#line 422 "worm.vala"
		result = TRUE;
#line 422 "worm.vala"
		return result;
#line 2098 "worm.c"
	}
#line 424 "worm.vala"
	if (keyvalUpper == propsDown) {
#line 2102 "worm.c"
		WormDirection _tmp11_;
#line 424 "worm.vala"
		_tmp11_ = self->direction;
#line 424 "worm.vala"
		_tmp10_ = _tmp11_ != WORM_DIRECTION_UP;
#line 2108 "worm.c"
	} else {
#line 424 "worm.vala"
		_tmp10_ = FALSE;
#line 2112 "worm.c"
	}
#line 424 "worm.vala"
	if (_tmp10_) {
#line 426 "worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_DOWN);
#line 427 "worm.vala"
		result = TRUE;
#line 427 "worm.vala"
		return result;
#line 2122 "worm.c"
	}
#line 429 "worm.vala"
	if (keyvalUpper == propsRight) {
#line 2126 "worm.c"
		WormDirection _tmp13_;
#line 429 "worm.vala"
		_tmp13_ = self->direction;
#line 429 "worm.vala"
		_tmp12_ = _tmp13_ != WORM_DIRECTION_LEFT;
#line 2132 "worm.c"
	} else {
#line 429 "worm.vala"
		_tmp12_ = FALSE;
#line 2136 "worm.c"
	}
#line 429 "worm.vala"
	if (_tmp12_) {
#line 431 "worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_RIGHT);
#line 432 "worm.vala"
		result = TRUE;
#line 432 "worm.vala"
		return result;
#line 2146 "worm.c"
	}
#line 434 "worm.vala"
	if (keyvalUpper == propsLeft) {
#line 2150 "worm.c"
		WormDirection _tmp15_;
#line 434 "worm.vala"
		_tmp15_ = self->direction;
#line 434 "worm.vala"
		_tmp14_ = _tmp15_ != WORM_DIRECTION_RIGHT;
#line 2156 "worm.c"
	} else {
#line 434 "worm.vala"
		_tmp14_ = FALSE;
#line 2160 "worm.c"
	}
#line 434 "worm.vala"
	if (_tmp14_) {
#line 436 "worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_LEFT);
#line 437 "worm.vala"
		result = TRUE;
#line 437 "worm.vala"
		return result;
#line 2170 "worm.c"
	}
#line 440 "worm.vala"
	result = FALSE;
#line 440 "worm.vala"
	return result;
#line 2176 "worm.c"
}

void
worm_queue_keypress (Worm* self,
                     WormDirection dir)
{
	gboolean _tmp0_ = FALSE;
	GeeArrayQueue* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeArrayQueue* _tmp6_;
#line 443 "worm.vala"
	g_return_if_fail (self != NULL);
#line 448 "worm.vala"
	_tmp1_ = self->priv->key_queue;
#line 448 "worm.vala"
	_tmp2_ = gee_array_queue_get_is_empty (_tmp1_);
#line 448 "worm.vala"
	_tmp3_ = _tmp2_;
#line 448 "worm.vala"
	if (!_tmp3_) {
#line 2198 "worm.c"
		GeeArrayQueue* _tmp4_;
		gpointer _tmp5_;
#line 448 "worm.vala"
		_tmp4_ = self->priv->key_queue;
#line 448 "worm.vala"
		_tmp5_ = gee_abstract_queue_peek ((GeeAbstractQueue*) _tmp4_);
#line 448 "worm.vala"
		_tmp0_ = dir == ((WormDirection) ((gintptr) _tmp5_));
#line 2207 "worm.c"
	} else {
#line 448 "worm.vala"
		_tmp0_ = FALSE;
#line 2211 "worm.c"
	}
#line 448 "worm.vala"
	if (_tmp0_) {
#line 449 "worm.vala"
		return;
#line 2217 "worm.c"
	}
#line 451 "worm.vala"
	_tmp6_ = self->priv->key_queue;
#line 451 "worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) dir));
#line 2223 "worm.c"
}

void
worm_dequeue_keypress (Worm* self)
{
	GeeArrayQueue* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayQueue* _tmp3_;
	gpointer _tmp4_;
#line 454 "worm.vala"
	g_return_if_fail (self != NULL);
#line 454 "worm.vala"
	_tmp0_ = self->priv->key_queue;
#line 454 "worm.vala"
	_tmp1_ = gee_array_queue_get_is_empty (_tmp0_);
#line 454 "worm.vala"
	_tmp2_ = _tmp1_;
#line 454 "worm.vala"
	_vala_return_if_fail (!_tmp2_, "!key_queue.is_empty");
#line 457 "worm.vala"
	_tmp3_ = self->priv->key_queue;
#line 457 "worm.vala"
	_tmp4_ = gee_abstract_queue_poll ((GeeAbstractQueue*) _tmp3_);
#line 457 "worm.vala"
	worm_direction_set (self, (WormDirection) ((gintptr) _tmp4_));
#line 2250 "worm.c"
}

static gint
worm_ai_deadend (gint* board,
                 gint board_length1,
                 gint board_length2,
                 gint numworms,
                 gint x,
                 gint y,
                 gint length_left)
{
	gint result = 0;
	gint cdir = 0;
	gint cx = 0;
	gint cy = 0;
#line 484 "worm.vala"
	if (x >= NIBBLES_GAME_WIDTH) {
#line 485 "worm.vala"
		x = 0;
#line 2270 "worm.c"
	}
#line 486 "worm.vala"
	if (x < 0) {
#line 487 "worm.vala"
		x = NIBBLES_GAME_WIDTH - 1;
#line 2276 "worm.c"
	}
#line 488 "worm.vala"
	if (y >= NIBBLES_GAME_HEIGHT) {
#line 489 "worm.vala"
		y = 0;
#line 2282 "worm.c"
	}
#line 490 "worm.vala"
	if (y < 0) {
#line 491 "worm.vala"
		y = NIBBLES_GAME_HEIGHT - 1;
#line 2288 "worm.c"
	}
#line 493 "worm.vala"
	if (length_left <= 0) {
#line 494 "worm.vala"
		result = 0;
#line 494 "worm.vala"
		return result;
#line 2296 "worm.c"
	}
#line 496 "worm.vala"
	cdir = 5;
#line 497 "worm.vala"
	while (TRUE) {
#line 2302 "worm.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
#line 497 "worm.vala"
		cdir = cdir - 1;
#line 497 "worm.vala"
		if (!(cdir > 0)) {
#line 497 "worm.vala"
			break;
#line 2312 "worm.c"
		}
#line 499 "worm.vala"
		cx = x;
#line 500 "worm.vala"
		cy = y;
#line 501 "worm.vala"
		switch (cdir) {
#line 501 "worm.vala"
			case WORM_DIRECTION_UP:
#line 2322 "worm.c"
			{
#line 504 "worm.vala"
				cy = cy - 1;
#line 505 "worm.vala"
				break;
#line 2328 "worm.c"
			}
#line 501 "worm.vala"
			case WORM_DIRECTION_DOWN:
#line 2332 "worm.c"
			{
#line 507 "worm.vala"
				cy = cy + 1;
#line 508 "worm.vala"
				break;
#line 2338 "worm.c"
			}
#line 501 "worm.vala"
			case WORM_DIRECTION_LEFT:
#line 2342 "worm.c"
			{
#line 510 "worm.vala"
				cx = cx - 1;
#line 511 "worm.vala"
				break;
#line 2348 "worm.c"
			}
#line 501 "worm.vala"
			case WORM_DIRECTION_RIGHT:
#line 2352 "worm.c"
			{
#line 513 "worm.vala"
				cx = cx + 1;
#line 514 "worm.vala"
				break;
#line 2358 "worm.c"
			}
			default:
#line 501 "worm.vala"
			break;
#line 2363 "worm.c"
		}
#line 517 "worm.vala"
		if (cx >= NIBBLES_GAME_WIDTH) {
#line 518 "worm.vala"
			cx = 0;
#line 2369 "worm.c"
		}
#line 519 "worm.vala"
		if (cx < 0) {
#line 520 "worm.vala"
			cx = NIBBLES_GAME_WIDTH - 1;
#line 2375 "worm.c"
		}
#line 521 "worm.vala"
		if (cy >= NIBBLES_GAME_HEIGHT) {
#line 522 "worm.vala"
			cy = 0;
#line 2381 "worm.c"
		}
#line 523 "worm.vala"
		if (cy < 0) {
#line 524 "worm.vala"
			cy = NIBBLES_GAME_HEIGHT - 1;
#line 2387 "worm.c"
		}
#line 526 "worm.vala"
		_tmp2_ = board[(cx * board_length2) + cy];
#line 526 "worm.vala"
		if (_tmp2_ <= ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 526 "worm.vala"
			_tmp1_ = TRUE;
#line 2395 "worm.c"
		} else {
			gint _tmp3_;
#line 527 "worm.vala"
			_tmp3_ = board[(x * board_length2) + y];
#line 527 "worm.vala"
			_tmp1_ = _tmp3_ >= ('z' + numworms);
#line 2402 "worm.c"
		}
#line 526 "worm.vala"
		if (_tmp1_) {
#line 2406 "worm.c"
			guint* _tmp4_;
			gint _tmp4__length1;
			gint _tmp4__length2;
			guint _tmp5_;
#line 528 "worm.vala"
			_tmp4_ = worm_deadend_board;
#line 528 "worm.vala"
			_tmp4__length1 = worm_deadend_board_length1;
#line 528 "worm.vala"
			_tmp4__length2 = worm_deadend_board_length2;
#line 528 "worm.vala"
			_tmp5_ = _tmp4_[(cx * _tmp4__length2) + cy];
#line 528 "worm.vala"
			_tmp0_ = _tmp5_ != worm_deadend_runnumber;
#line 2421 "worm.c"
		} else {
#line 526 "worm.vala"
			_tmp0_ = FALSE;
#line 2425 "worm.c"
		}
#line 526 "worm.vala"
		if (_tmp0_) {
#line 2429 "worm.c"
			guint* _tmp6_;
			gint _tmp6__length1;
			gint _tmp6__length2;
#line 530 "worm.vala"
			_tmp6_ = worm_deadend_board;
#line 530 "worm.vala"
			_tmp6__length1 = worm_deadend_board_length1;
#line 530 "worm.vala"
			_tmp6__length2 = worm_deadend_board_length2;
#line 530 "worm.vala"
			_tmp6_[(cx * _tmp6__length2) + cy] = worm_deadend_runnumber;
#line 531 "worm.vala"
			length_left = worm_ai_deadend (board, (gint) board_length1, (gint) board_length2, numworms, cx, cy, length_left - 1);
#line 532 "worm.vala"
			if (length_left <= 0) {
#line 533 "worm.vala"
				result = 0;
#line 533 "worm.vala"
				return result;
#line 2449 "worm.c"
			}
		}
	}
#line 537 "worm.vala"
	result = length_left;
#line 537 "worm.vala"
	return result;
#line 2457 "worm.c"
}

static gint
worm_ai_deadend_after (gint* board,
                       gint board_length1,
                       gint board_length2,
                       GeeLinkedList* worms,
                       gint numworms,
                       gint x,
                       gint y,
                       gint dir,
                       gint length)
{
	gint result = 0;
	gint cx = 0;
	gint cy = 0;
	gint cl = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	guint* _tmp17_;
	gint _tmp17__length1;
	gint _tmp17__length2;
	guint* _tmp18_;
	gint _tmp18__length1;
	gint _tmp18__length2;
#line 549 "worm.vala"
	g_return_val_if_fail (worms != NULL, 0);
#line 553 "worm.vala"
	if (x < 0) {
#line 553 "worm.vala"
		_tmp2_ = TRUE;
#line 2491 "worm.c"
	} else {
#line 553 "worm.vala"
		_tmp2_ = x >= NIBBLES_GAME_WIDTH;
#line 2495 "worm.c"
	}
#line 553 "worm.vala"
	if (_tmp2_) {
#line 553 "worm.vala"
		_tmp1_ = TRUE;
#line 2501 "worm.c"
	} else {
#line 553 "worm.vala"
		_tmp1_ = y < 0;
#line 2505 "worm.c"
	}
#line 553 "worm.vala"
	if (_tmp1_) {
#line 553 "worm.vala"
		_tmp0_ = TRUE;
#line 2511 "worm.c"
	} else {
#line 553 "worm.vala"
		_tmp0_ = y >= NIBBLES_GAME_HEIGHT;
#line 2515 "worm.c"
	}
#line 553 "worm.vala"
	if (_tmp0_) {
#line 554 "worm.vala"
		result = 0;
#line 554 "worm.vala"
		return result;
#line 2523 "worm.c"
	}
#line 556 "worm.vala"
	worm_deadend_runnumber = worm_deadend_runnumber + 1;
#line 558 "worm.vala"
	if (dir > 4) {
#line 559 "worm.vala"
		dir = 1;
#line 2531 "worm.c"
	}
#line 560 "worm.vala"
	if (dir < 1) {
#line 561 "worm.vala"
		dir = 4;
#line 2537 "worm.c"
	}
#line 563 "worm.vala"
	i = numworms;
#line 564 "worm.vala"
	while (TRUE) {
#line 2543 "worm.c"
		gint _tmp3_;
		gpointer _tmp4_;
		Worm* _tmp5_;
		Position _tmp6_ = {0};
		Position _tmp7_;
		gpointer _tmp8_;
		Worm* _tmp9_;
		Position _tmp10_ = {0};
		Position _tmp11_;
		gboolean _tmp12_ = FALSE;
#line 564 "worm.vala"
		_tmp3_ = i;
#line 564 "worm.vala"
		i = _tmp3_ - 1;
#line 564 "worm.vala"
		if (!(_tmp3_ > 0)) {
#line 564 "worm.vala"
			break;
#line 2562 "worm.c"
		}
#line 566 "worm.vala"
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) worms, i);
#line 566 "worm.vala"
		_tmp5_ = (Worm*) _tmp4_;
#line 566 "worm.vala"
		worm_get_head (_tmp5_, &_tmp6_);
#line 566 "worm.vala"
		_tmp7_ = _tmp6_;
#line 566 "worm.vala"
		cx = _tmp7_.x;
#line 566 "worm.vala"
		_g_object_unref0 (_tmp5_);
#line 567 "worm.vala"
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) worms, i);
#line 567 "worm.vala"
		_tmp9_ = (Worm*) _tmp8_;
#line 567 "worm.vala"
		worm_get_head (_tmp9_, &_tmp10_);
#line 567 "worm.vala"
		_tmp11_ = _tmp10_;
#line 567 "worm.vala"
		cy = _tmp11_.y;
#line 567 "worm.vala"
		_g_object_unref0 (_tmp9_);
#line 568 "worm.vala"
		if (cx != x) {
#line 568 "worm.vala"
			_tmp12_ = TRUE;
#line 2592 "worm.c"
		} else {
#line 568 "worm.vala"
			_tmp12_ = cy != y;
#line 2596 "worm.c"
		}
#line 568 "worm.vala"
		if (_tmp12_) {
#line 569 "worm.vala"
			if (cx > 0) {
#line 2602 "worm.c"
				guint* _tmp13_;
				gint _tmp13__length1;
				gint _tmp13__length2;
#line 570 "worm.vala"
				_tmp13_ = worm_deadend_board;
#line 570 "worm.vala"
				_tmp13__length1 = worm_deadend_board_length1;
#line 570 "worm.vala"
				_tmp13__length2 = worm_deadend_board_length2;
#line 570 "worm.vala"
				_tmp13_[((cx - 1) * _tmp13__length2) + cy] = worm_deadend_runnumber;
#line 2614 "worm.c"
			}
#line 571 "worm.vala"
			if (cy > 0) {
#line 2618 "worm.c"
				guint* _tmp14_;
				gint _tmp14__length1;
				gint _tmp14__length2;
#line 572 "worm.vala"
				_tmp14_ = worm_deadend_board;
#line 572 "worm.vala"
				_tmp14__length1 = worm_deadend_board_length1;
#line 572 "worm.vala"
				_tmp14__length2 = worm_deadend_board_length2;
#line 572 "worm.vala"
				_tmp14_[(cx * _tmp14__length2) + (cy - 1)] = worm_deadend_runnumber;
#line 2630 "worm.c"
			}
#line 573 "worm.vala"
			if (cx < (NIBBLES_GAME_WIDTH - 1)) {
#line 2634 "worm.c"
				guint* _tmp15_;
				gint _tmp15__length1;
				gint _tmp15__length2;
#line 574 "worm.vala"
				_tmp15_ = worm_deadend_board;
#line 574 "worm.vala"
				_tmp15__length1 = worm_deadend_board_length1;
#line 574 "worm.vala"
				_tmp15__length2 = worm_deadend_board_length2;
#line 574 "worm.vala"
				_tmp15_[((cx + 1) * _tmp15__length2) + cy] = worm_deadend_runnumber;
#line 2646 "worm.c"
			}
#line 575 "worm.vala"
			if (cy < (NIBBLES_GAME_HEIGHT - 1)) {
#line 2650 "worm.c"
				guint* _tmp16_;
				gint _tmp16__length1;
				gint _tmp16__length2;
#line 576 "worm.vala"
				_tmp16_ = worm_deadend_board;
#line 576 "worm.vala"
				_tmp16__length1 = worm_deadend_board_length1;
#line 576 "worm.vala"
				_tmp16__length2 = worm_deadend_board_length2;
#line 576 "worm.vala"
				_tmp16_[(cx * _tmp16__length2) + (cy + 1)] = worm_deadend_runnumber;
#line 2662 "worm.c"
			}
		}
	}
#line 580 "worm.vala"
	cx = x;
#line 581 "worm.vala"
	cy = y;
#line 582 "worm.vala"
	switch (dir) {
#line 582 "worm.vala"
		case WORM_DIRECTION_UP:
#line 2674 "worm.c"
		{
#line 585 "worm.vala"
			cy = cy - 1;
#line 586 "worm.vala"
			break;
#line 2680 "worm.c"
		}
#line 582 "worm.vala"
		case WORM_DIRECTION_DOWN:
#line 2684 "worm.c"
		{
#line 588 "worm.vala"
			cy = cy + 1;
#line 589 "worm.vala"
			break;
#line 2690 "worm.c"
		}
#line 582 "worm.vala"
		case WORM_DIRECTION_LEFT:
#line 2694 "worm.c"
		{
#line 591 "worm.vala"
			cx = cx - 1;
#line 592 "worm.vala"
			break;
#line 2700 "worm.c"
		}
#line 582 "worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 2704 "worm.c"
		{
#line 594 "worm.vala"
			cx = cx + 1;
#line 595 "worm.vala"
			break;
#line 2710 "worm.c"
		}
		default:
#line 582 "worm.vala"
		break;
#line 2715 "worm.c"
	}
#line 598 "worm.vala"
	if (cx >= NIBBLES_GAME_WIDTH) {
#line 599 "worm.vala"
		cx = 0;
#line 2721 "worm.c"
	}
#line 600 "worm.vala"
	if (cx < 0) {
#line 601 "worm.vala"
		cx = NIBBLES_GAME_WIDTH - 1;
#line 2727 "worm.c"
	}
#line 602 "worm.vala"
	if (cy >= NIBBLES_GAME_HEIGHT) {
#line 603 "worm.vala"
		cy = 0;
#line 2733 "worm.c"
	}
#line 604 "worm.vala"
	if (cy < 0) {
#line 605 "worm.vala"
		cy = NIBBLES_GAME_HEIGHT - 1;
#line 2739 "worm.c"
	}
#line 607 "worm.vala"
	_tmp17_ = worm_deadend_board;
#line 607 "worm.vala"
	_tmp17__length1 = worm_deadend_board_length1;
#line 607 "worm.vala"
	_tmp17__length2 = worm_deadend_board_length2;
#line 607 "worm.vala"
	_tmp17_[(x * _tmp17__length2) + y] = worm_deadend_runnumber;
#line 608 "worm.vala"
	_tmp18_ = worm_deadend_board;
#line 608 "worm.vala"
	_tmp18__length1 = worm_deadend_board_length1;
#line 608 "worm.vala"
	_tmp18__length2 = worm_deadend_board_length2;
#line 608 "worm.vala"
	_tmp18_[(cx * _tmp18__length2) + cy] = worm_deadend_runnumber;
#line 610 "worm.vala"
	cl = (length * length) / 16;
#line 611 "worm.vala"
	if (cl < NIBBLES_GAME_WIDTH) {
#line 612 "worm.vala"
		cl = NIBBLES_GAME_WIDTH;
#line 2763 "worm.c"
	}
#line 613 "worm.vala"
	result = worm_ai_deadend (board, (gint) board_length1, (gint) board_length2, numworms, cx, cy, cl);
#line 613 "worm.vala"
	return result;
#line 2769 "worm.c"
}

static gboolean
worm_ai_too_close (Worm* self,
                   GeeLinkedList* worms,
                   gint numworms)
{
	gboolean result = FALSE;
	gint i = 0;
	gint dx = 0;
	gint dy = 0;
#line 620 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 620 "worm.vala"
	g_return_val_if_fail (worms != NULL, FALSE);
#line 622 "worm.vala"
	i = numworms;
#line 625 "worm.vala"
	while (TRUE) {
#line 2789 "worm.c"
		gint _tmp0_;
		Position _tmp1_ = {0};
		Position _tmp2_;
		gpointer _tmp3_;
		Worm* _tmp4_;
		Position _tmp5_ = {0};
		Position _tmp6_;
		Position _tmp7_ = {0};
		Position _tmp8_;
		gpointer _tmp9_;
		Worm* _tmp10_;
		Position _tmp11_ = {0};
		Position _tmp12_;
		WormDirection _tmp13_;
#line 625 "worm.vala"
		_tmp0_ = i;
#line 625 "worm.vala"
		i = _tmp0_ - 1;
#line 625 "worm.vala"
		if (!(_tmp0_ > 0)) {
#line 625 "worm.vala"
			break;
#line 2812 "worm.c"
		}
#line 627 "worm.vala"
		worm_get_head (self, &_tmp1_);
#line 627 "worm.vala"
		_tmp2_ = _tmp1_;
#line 627 "worm.vala"
		_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) worms, i);
#line 627 "worm.vala"
		_tmp4_ = (Worm*) _tmp3_;
#line 627 "worm.vala"
		worm_get_head (_tmp4_, &_tmp5_);
#line 627 "worm.vala"
		_tmp6_ = _tmp5_;
#line 627 "worm.vala"
		dx = _tmp2_.x - _tmp6_.x;
#line 627 "worm.vala"
		_g_object_unref0 (_tmp4_);
#line 628 "worm.vala"
		worm_get_head (self, &_tmp7_);
#line 628 "worm.vala"
		_tmp8_ = _tmp7_;
#line 628 "worm.vala"
		_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) worms, i);
#line 628 "worm.vala"
		_tmp10_ = (Worm*) _tmp9_;
#line 628 "worm.vala"
		worm_get_head (_tmp10_, &_tmp11_);
#line 628 "worm.vala"
		_tmp12_ = _tmp11_;
#line 628 "worm.vala"
		dy = _tmp8_.y - _tmp12_.y;
#line 628 "worm.vala"
		_g_object_unref0 (_tmp10_);
#line 629 "worm.vala"
		_tmp13_ = self->direction;
#line 629 "worm.vala"
		switch (_tmp13_) {
#line 629 "worm.vala"
			case WORM_DIRECTION_UP:
#line 2852 "worm.c"
			{
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
#line 632 "worm.vala"
				if (dy > 0) {
#line 632 "worm.vala"
					_tmp16_ = dy <= 3;
#line 2861 "worm.c"
				} else {
#line 632 "worm.vala"
					_tmp16_ = FALSE;
#line 2865 "worm.c"
				}
#line 632 "worm.vala"
				if (_tmp16_) {
#line 632 "worm.vala"
					_tmp15_ = dx >= -1;
#line 2871 "worm.c"
				} else {
#line 632 "worm.vala"
					_tmp15_ = FALSE;
#line 2875 "worm.c"
				}
#line 632 "worm.vala"
				if (_tmp15_) {
#line 632 "worm.vala"
					_tmp14_ = dx <= 1;
#line 2881 "worm.c"
				} else {
#line 632 "worm.vala"
					_tmp14_ = FALSE;
#line 2885 "worm.c"
				}
#line 632 "worm.vala"
				if (_tmp14_) {
#line 633 "worm.vala"
					result = TRUE;
#line 633 "worm.vala"
					return result;
#line 2893 "worm.c"
				}
#line 634 "worm.vala"
				break;
#line 2897 "worm.c"
			}
#line 629 "worm.vala"
			case WORM_DIRECTION_DOWN:
#line 2901 "worm.c"
			{
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
#line 636 "worm.vala"
				if (dy < 0) {
#line 636 "worm.vala"
					_tmp19_ = dy >= -3;
#line 2910 "worm.c"
				} else {
#line 636 "worm.vala"
					_tmp19_ = FALSE;
#line 2914 "worm.c"
				}
#line 636 "worm.vala"
				if (_tmp19_) {
#line 636 "worm.vala"
					_tmp18_ = dx >= -1;
#line 2920 "worm.c"
				} else {
#line 636 "worm.vala"
					_tmp18_ = FALSE;
#line 2924 "worm.c"
				}
#line 636 "worm.vala"
				if (_tmp18_) {
#line 636 "worm.vala"
					_tmp17_ = dx <= 1;
#line 2930 "worm.c"
				} else {
#line 636 "worm.vala"
					_tmp17_ = FALSE;
#line 2934 "worm.c"
				}
#line 636 "worm.vala"
				if (_tmp17_) {
#line 637 "worm.vala"
					result = TRUE;
#line 637 "worm.vala"
					return result;
#line 2942 "worm.c"
				}
#line 638 "worm.vala"
				break;
#line 2946 "worm.c"
			}
#line 629 "worm.vala"
			case WORM_DIRECTION_LEFT:
#line 2950 "worm.c"
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
#line 640 "worm.vala"
				if (dx > 0) {
#line 640 "worm.vala"
					_tmp22_ = dx <= 3;
#line 2959 "worm.c"
				} else {
#line 640 "worm.vala"
					_tmp22_ = FALSE;
#line 2963 "worm.c"
				}
#line 640 "worm.vala"
				if (_tmp22_) {
#line 640 "worm.vala"
					_tmp21_ = dy >= -1;
#line 2969 "worm.c"
				} else {
#line 640 "worm.vala"
					_tmp21_ = FALSE;
#line 2973 "worm.c"
				}
#line 640 "worm.vala"
				if (_tmp21_) {
#line 640 "worm.vala"
					_tmp20_ = dy <= 1;
#line 2979 "worm.c"
				} else {
#line 640 "worm.vala"
					_tmp20_ = FALSE;
#line 2983 "worm.c"
				}
#line 640 "worm.vala"
				if (_tmp20_) {
#line 641 "worm.vala"
					result = TRUE;
#line 641 "worm.vala"
					return result;
#line 2991 "worm.c"
				}
#line 642 "worm.vala"
				break;
#line 2995 "worm.c"
			}
#line 629 "worm.vala"
			case WORM_DIRECTION_RIGHT:
#line 2999 "worm.c"
			{
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
#line 644 "worm.vala"
				if (dx < 0) {
#line 644 "worm.vala"
					_tmp25_ = dx >= -3;
#line 3008 "worm.c"
				} else {
#line 644 "worm.vala"
					_tmp25_ = FALSE;
#line 3012 "worm.c"
				}
#line 644 "worm.vala"
				if (_tmp25_) {
#line 644 "worm.vala"
					_tmp24_ = dy >= -1;
#line 3018 "worm.c"
				} else {
#line 644 "worm.vala"
					_tmp24_ = FALSE;
#line 3022 "worm.c"
				}
#line 644 "worm.vala"
				if (_tmp24_) {
#line 644 "worm.vala"
					_tmp23_ = dy <= 1;
#line 3028 "worm.c"
				} else {
#line 644 "worm.vala"
					_tmp23_ = FALSE;
#line 3032 "worm.c"
				}
#line 644 "worm.vala"
				if (_tmp23_) {
#line 645 "worm.vala"
					result = TRUE;
#line 645 "worm.vala"
					return result;
#line 3040 "worm.c"
				}
#line 646 "worm.vala"
				break;
#line 3044 "worm.c"
			}
			default:
#line 629 "worm.vala"
			break;
#line 3049 "worm.c"
		}
	}
#line 650 "worm.vala"
	result = FALSE;
#line 650 "worm.vala"
	return result;
#line 3056 "worm.c"
}

static gboolean
worm_ai_wander (gint* board,
                gint board_length1,
                gint board_length2,
                gint numworms,
                gint x,
                gint y,
                gint dir,
                gint ox,
                gint oy)
{
	gboolean result = FALSE;
	gint _tmp0_;
#line 655 "worm.vala"
	if (dir > 4) {
#line 656 "worm.vala"
		dir = 1;
#line 3076 "worm.c"
	}
#line 657 "worm.vala"
	if (dir < 1) {
#line 658 "worm.vala"
		dir = 4;
#line 3082 "worm.c"
	}
#line 660 "worm.vala"
	switch (dir) {
#line 660 "worm.vala"
		case WORM_DIRECTION_UP:
#line 3088 "worm.c"
		{
#line 663 "worm.vala"
			y = y - 1;
#line 664 "worm.vala"
			break;
#line 3094 "worm.c"
		}
#line 660 "worm.vala"
		case WORM_DIRECTION_DOWN:
#line 3098 "worm.c"
		{
#line 666 "worm.vala"
			y = y + 1;
#line 667 "worm.vala"
			break;
#line 3104 "worm.c"
		}
#line 660 "worm.vala"
		case WORM_DIRECTION_LEFT:
#line 3108 "worm.c"
		{
#line 669 "worm.vala"
			x = x - 1;
#line 670 "worm.vala"
			break;
#line 3114 "worm.c"
		}
#line 660 "worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 3118 "worm.c"
		{
#line 672 "worm.vala"
			x = x + 1;
#line 673 "worm.vala"
			break;
#line 3124 "worm.c"
		}
		default:
#line 660 "worm.vala"
		break;
#line 3129 "worm.c"
	}
#line 676 "worm.vala"
	if (x >= NIBBLES_GAME_WIDTH) {
#line 677 "worm.vala"
		x = 0;
#line 3135 "worm.c"
	}
#line 678 "worm.vala"
	if (x < 0) {
#line 679 "worm.vala"
		x = NIBBLES_GAME_WIDTH - 1;
#line 3141 "worm.c"
	}
#line 680 "worm.vala"
	if (y >= NIBBLES_GAME_HEIGHT) {
#line 681 "worm.vala"
		y = 0;
#line 3147 "worm.c"
	}
#line 682 "worm.vala"
	if (y < 0) {
#line 683 "worm.vala"
		y = NIBBLES_GAME_HEIGHT - 1;
#line 3153 "worm.c"
	}
#line 685 "worm.vala"
	_tmp0_ = board[(x * board_length2) + y];
#line 685 "worm.vala"
	switch (_tmp0_ - 'A') {
#line 685 "worm.vala"
		case BONUS_TYPE_REGULAR:
#line 3161 "worm.c"
		{
#line 688 "worm.vala"
			result = TRUE;
#line 688 "worm.vala"
			return result;
#line 3167 "worm.c"
		}
#line 685 "worm.vala"
		case BONUS_TYPE_DOUBLE:
#line 3171 "worm.c"
		{
#line 690 "worm.vala"
			result = TRUE;
#line 690 "worm.vala"
			return result;
#line 3177 "worm.c"
		}
#line 685 "worm.vala"
		case BONUS_TYPE_LIFE:
#line 3181 "worm.c"
		{
#line 692 "worm.vala"
			result = TRUE;
#line 692 "worm.vala"
			return result;
#line 3187 "worm.c"
		}
#line 685 "worm.vala"
		case BONUS_TYPE_REVERSE:
#line 3191 "worm.c"
		{
#line 694 "worm.vala"
			result = TRUE;
#line 694 "worm.vala"
			return result;
#line 3197 "worm.c"
		}
#line 685 "worm.vala"
		case BONUS_TYPE_HALF:
#line 3201 "worm.c"
		{
#line 696 "worm.vala"
			result = FALSE;
#line 696 "worm.vala"
			return result;
#line 3207 "worm.c"
		}
		default:
		{
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
#line 698 "worm.vala"
			_tmp2_ = board[(x * board_length2) + y];
#line 698 "worm.vala"
			if (_tmp2_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 3217 "worm.c"
				gint _tmp3_;
#line 699 "worm.vala"
				_tmp3_ = board[(x * board_length2) + y];
#line 699 "worm.vala"
				_tmp1_ = _tmp3_ < ('z' + numworms);
#line 3223 "worm.c"
			} else {
#line 698 "worm.vala"
				_tmp1_ = FALSE;
#line 3227 "worm.c"
			}
#line 698 "worm.vala"
			if (_tmp1_) {
#line 701 "worm.vala"
				result = FALSE;
#line 701 "worm.vala"
				return result;
#line 3235 "worm.c"
			} else {
				gboolean _tmp4_ = FALSE;
#line 705 "worm.vala"
				if (ox == x) {
#line 705 "worm.vala"
					_tmp4_ = oy == y;
#line 3242 "worm.c"
				} else {
#line 705 "worm.vala"
					_tmp4_ = FALSE;
#line 3246 "worm.c"
				}
#line 705 "worm.vala"
				if (_tmp4_) {
#line 706 "worm.vala"
					result = FALSE;
#line 706 "worm.vala"
					return result;
#line 3254 "worm.c"
				}
#line 708 "worm.vala"
				result = worm_ai_wander (board, (gint) board_length1, (gint) board_length2, numworms, x, y, dir, ox, oy);
#line 708 "worm.vala"
				return result;
#line 3260 "worm.c"
			}
		}
	}
}

void
worm_ai_move (Worm* self,
              gint* board,
              gint board_length1,
              gint board_length2,
              gint numworms,
              GeeLinkedList* worms)
{
	WormDirection opposite = 0;
	WormDirection _tmp0_;
	gboolean front = FALSE;
	Position _tmp1_ = {0};
	Position _tmp2_;
	Position _tmp3_ = {0};
	Position _tmp4_;
	WormDirection _tmp5_;
	Position _tmp6_ = {0};
	Position _tmp7_;
	Position _tmp8_ = {0};
	Position _tmp9_;
	gboolean left = FALSE;
	Position _tmp10_ = {0};
	Position _tmp11_;
	Position _tmp12_ = {0};
	Position _tmp13_;
	WormDirection _tmp14_;
	Position _tmp15_ = {0};
	Position _tmp16_;
	Position _tmp17_ = {0};
	Position _tmp18_;
	gboolean right = FALSE;
	Position _tmp19_ = {0};
	Position _tmp20_;
	Position _tmp21_ = {0};
	Position _tmp22_;
	WormDirection _tmp23_;
	Position _tmp24_ = {0};
	Position _tmp25_;
	Position _tmp26_ = {0};
	Position _tmp27_;
	gint dir = 0;
	WormDirection old_dir = 0;
	WormDirection _tmp33_;
	gint best_yet = 0;
	gint best_dir = 0;
	gint this_len = 0;
#line 714 "worm.vala"
	g_return_if_fail (self != NULL);
#line 714 "worm.vala"
	g_return_if_fail (worms != NULL);
#line 716 "worm.vala"
	_tmp0_ = self->direction;
#line 716 "worm.vala"
	opposite = ((_tmp0_ + 1) % 4) + 1;
#line 718 "worm.vala"
	worm_get_head (self, &_tmp1_);
#line 718 "worm.vala"
	_tmp2_ = _tmp1_;
#line 718 "worm.vala"
	worm_get_head (self, &_tmp3_);
#line 718 "worm.vala"
	_tmp4_ = _tmp3_;
#line 718 "worm.vala"
	_tmp5_ = self->direction;
#line 718 "worm.vala"
	worm_get_head (self, &_tmp6_);
#line 718 "worm.vala"
	_tmp7_ = _tmp6_;
#line 718 "worm.vala"
	worm_get_head (self, &_tmp8_);
#line 718 "worm.vala"
	_tmp9_ = _tmp8_;
#line 718 "worm.vala"
	front = worm_ai_wander (board, (gint) board_length1, (gint) board_length2, numworms, _tmp2_.x, _tmp4_.y, (gint) _tmp5_, _tmp7_.x, _tmp9_.y);
#line 719 "worm.vala"
	worm_get_head (self, &_tmp10_);
#line 719 "worm.vala"
	_tmp11_ = _tmp10_;
#line 719 "worm.vala"
	worm_get_head (self, &_tmp12_);
#line 719 "worm.vala"
	_tmp13_ = _tmp12_;
#line 719 "worm.vala"
	_tmp14_ = self->direction;
#line 719 "worm.vala"
	worm_get_head (self, &_tmp15_);
#line 719 "worm.vala"
	_tmp16_ = _tmp15_;
#line 719 "worm.vala"
	worm_get_head (self, &_tmp17_);
#line 719 "worm.vala"
	_tmp18_ = _tmp17_;
#line 719 "worm.vala"
	left = worm_ai_wander (board, (gint) board_length1, (gint) board_length2, numworms, _tmp11_.x, _tmp13_.y, (gint) (_tmp14_ - 1), _tmp16_.x, _tmp18_.y);
#line 720 "worm.vala"
	worm_get_head (self, &_tmp19_);
#line 720 "worm.vala"
	_tmp20_ = _tmp19_;
#line 720 "worm.vala"
	worm_get_head (self, &_tmp21_);
#line 720 "worm.vala"
	_tmp22_ = _tmp21_;
#line 720 "worm.vala"
	_tmp23_ = self->direction;
#line 720 "worm.vala"
	worm_get_head (self, &_tmp24_);
#line 720 "worm.vala"
	_tmp25_ = _tmp24_;
#line 720 "worm.vala"
	worm_get_head (self, &_tmp26_);
#line 720 "worm.vala"
	_tmp27_ = _tmp26_;
#line 720 "worm.vala"
	right = worm_ai_wander (board, (gint) board_length1, (gint) board_length2, numworms, _tmp20_.x, _tmp22_.y, (gint) (_tmp23_ + 1), _tmp25_.x, _tmp27_.y);
#line 723 "worm.vala"
	if (!front) {
#line 725 "worm.vala"
		if (left) {
#line 3384 "worm.c"
			WormDirection _tmp28_;
#line 728 "worm.vala"
			_tmp28_ = self->direction;
#line 728 "worm.vala"
			dir = (gint) (_tmp28_ - 1);
#line 729 "worm.vala"
			if (dir < 1) {
#line 730 "worm.vala"
				dir = 4;
#line 3394 "worm.c"
			}
#line 732 "worm.vala"
			self->direction = (WormDirection) dir;
#line 3398 "worm.c"
		} else {
#line 734 "worm.vala"
			if (right) {
#line 3402 "worm.c"
				WormDirection _tmp29_;
#line 737 "worm.vala"
				_tmp29_ = self->direction;
#line 737 "worm.vala"
				dir = (gint) (_tmp29_ + 1);
#line 738 "worm.vala"
				if (dir > 4) {
#line 739 "worm.vala"
					dir = 1;
#line 3412 "worm.c"
				}
#line 741 "worm.vala"
				self->direction = (WormDirection) dir;
#line 3416 "worm.c"
			} else {
#line 746 "worm.vala"
				if (g_random_int_range ((gint32) 0, (gint32) 30) == ((gint32) 1)) {
#line 3420 "worm.c"
					gint _tmp30_ = 0;
					WormDirection _tmp31_;
					WormDirection _tmp32_;
#line 748 "worm.vala"
					if (g_random_boolean ()) {
#line 748 "worm.vala"
						_tmp30_ = 1;
#line 3428 "worm.c"
					} else {
#line 748 "worm.vala"
						_tmp30_ = -1;
#line 3432 "worm.c"
					}
#line 748 "worm.vala"
					_tmp31_ = self->direction;
#line 748 "worm.vala"
					dir = (gint) (_tmp31_ + _tmp30_);
#line 749 "worm.vala"
					_tmp32_ = opposite;
#line 749 "worm.vala"
					if (dir != ((gint) _tmp32_)) {
#line 751 "worm.vala"
						if (dir > 4) {
#line 752 "worm.vala"
							dir = 1;
#line 3446 "worm.c"
						}
#line 753 "worm.vala"
						if (dir < 1) {
#line 754 "worm.vala"
							dir = 4;
#line 3452 "worm.c"
						}
#line 756 "worm.vala"
						self->direction = (WormDirection) dir;
#line 3456 "worm.c"
					}
				}
			}
		}
	}
#line 773 "worm.vala"
	_tmp33_ = self->direction;
#line 773 "worm.vala"
	old_dir = _tmp33_;
#line 774 "worm.vala"
	best_yet = NIBBLES_GAME_CAPACITY * 2;
#line 775 "worm.vala"
	best_dir = -1;
#line 3470 "worm.c"
	{
		gboolean _tmp34_ = FALSE;
#line 778 "worm.vala"
		dir = 1;
#line 778 "worm.vala"
		_tmp34_ = TRUE;
#line 778 "worm.vala"
		while (TRUE) {
#line 3479 "worm.c"
			WormDirection _tmp36_;
			Position _tmp37_ = {0};
			Position _tmp38_;
			Position _tmp39_ = {0};
			Position _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gboolean _tmp43_ = FALSE;
			WormDirection _tmp44_;
#line 778 "worm.vala"
			if (!_tmp34_) {
#line 3491 "worm.c"
				gint _tmp35_;
#line 778 "worm.vala"
				_tmp35_ = dir;
#line 778 "worm.vala"
				dir = _tmp35_ + 1;
#line 3497 "worm.c"
			}
#line 778 "worm.vala"
			_tmp34_ = FALSE;
#line 778 "worm.vala"
			if (!(dir <= 4)) {
#line 778 "worm.vala"
				break;
#line 3505 "worm.c"
			}
#line 780 "worm.vala"
			self->direction = (WormDirection) dir;
#line 782 "worm.vala"
			_tmp36_ = opposite;
#line 782 "worm.vala"
			if (dir == ((gint) _tmp36_)) {
#line 783 "worm.vala"
				continue;
#line 3515 "worm.c"
			}
#line 784 "worm.vala"
			this_len = 0;
#line 786 "worm.vala"
			if (!worm_can_move_to (self, board, (gint) board_length1, (gint) board_length2, numworms)) {
#line 787 "worm.vala"
				this_len = this_len + NIBBLES_GAME_CAPACITY;
#line 3523 "worm.c"
			}
#line 789 "worm.vala"
			if (worm_ai_too_close (self, worms, numworms)) {
#line 790 "worm.vala"
				this_len = this_len + 4;
#line 3529 "worm.c"
			}
#line 792 "worm.vala"
			worm_get_head (self, &_tmp37_);
#line 792 "worm.vala"
			_tmp38_ = _tmp37_;
#line 792 "worm.vala"
			worm_get_head (self, &_tmp39_);
#line 792 "worm.vala"
			_tmp40_ = _tmp39_;
#line 792 "worm.vala"
			_tmp41_ = worm_get_length (self);
#line 792 "worm.vala"
			_tmp42_ = _tmp41_;
#line 792 "worm.vala"
			this_len = this_len + worm_ai_deadend_after (board, (gint) board_length1, (gint) board_length2, worms, numworms, _tmp38_.x, _tmp40_.y, dir, _tmp42_ + self->change);
#line 794 "worm.vala"
			_tmp44_ = old_dir;
#line 794 "worm.vala"
			if (dir == ((gint) _tmp44_)) {
#line 794 "worm.vala"
				_tmp43_ = this_len <= 0;
#line 3551 "worm.c"
			} else {
#line 794 "worm.vala"
				_tmp43_ = FALSE;
#line 3555 "worm.c"
			}
#line 794 "worm.vala"
			if (_tmp43_) {
#line 795 "worm.vala"
				this_len = this_len - 100;
#line 3561 "worm.c"
			}
#line 802 "worm.vala"
			if (this_len <= 0) {
#line 803 "worm.vala"
				this_len = this_len - g_random_int_range ((gint32) 0, (gint32) 100);
#line 3567 "worm.c"
			}
#line 804 "worm.vala"
			if (this_len < best_yet) {
#line 806 "worm.vala"
				best_yet = this_len;
#line 807 "worm.vala"
				best_dir = dir;
#line 3575 "worm.c"
			}
		}
	}
#line 811 "worm.vala"
	self->direction = (WormDirection) best_dir;
#line 3581 "worm.c"
	{
		gboolean _tmp45_ = FALSE;
#line 816 "worm.vala"
		dir = 1;
#line 816 "worm.vala"
		_tmp45_ = TRUE;
#line 816 "worm.vala"
		while (TRUE) {
#line 3590 "worm.c"
			WormDirection _tmp47_;
#line 816 "worm.vala"
			if (!_tmp45_) {
#line 3594 "worm.c"
				gint _tmp46_;
#line 816 "worm.vala"
				_tmp46_ = dir;
#line 816 "worm.vala"
				dir = _tmp46_ + 1;
#line 3600 "worm.c"
			}
#line 816 "worm.vala"
			_tmp45_ = FALSE;
#line 816 "worm.vala"
			if (!(dir <= 4)) {
#line 816 "worm.vala"
				break;
#line 3608 "worm.c"
			}
#line 818 "worm.vala"
			_tmp47_ = opposite;
#line 818 "worm.vala"
			if (dir == ((gint) _tmp47_)) {
#line 819 "worm.vala"
				continue;
#line 3616 "worm.c"
			}
#line 821 "worm.vala"
			if (!worm_can_move_to (self, board, (gint) board_length1, (gint) board_length2, numworms)) {
#line 822 "worm.vala"
				self->direction = (WormDirection) dir;
#line 3622 "worm.c"
			} else {
#line 824 "worm.vala"
				continue;
#line 3626 "worm.c"
			}
		}
	}
}

void
worm_get_starting_position (Worm* self,
                            Position * result)
{
	Position _tmp0_;
#line 54 "worm.vala"
	g_return_if_fail (self != NULL);
#line 54 "worm.vala"
	_tmp0_ = self->priv->_starting_position;
#line 54 "worm.vala"
	*result = _tmp0_;
#line 54 "worm.vala"
	return;
#line 3645 "worm.c"
}

static void
worm_set_starting_position (Worm* self,
                            Position * value)
{
	Position old_value;
#line 54 "worm.vala"
	g_return_if_fail (self != NULL);
#line 54 "worm.vala"
	if (_position_equal (value, (worm_get_starting_position (self, &old_value), &old_value)) != TRUE) {
#line 3657 "worm.c"
		Position _tmp0_;
#line 54 "worm.vala"
		_tmp0_ = *value;
#line 54 "worm.vala"
		self->priv->_starting_position = _tmp0_;
#line 54 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_STARTING_POSITION_PROPERTY]);
#line 3665 "worm.c"
	}
}

gint
worm_get_id (Worm* self)
{
	gint result;
#line 56 "worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "worm.vala"
	result = self->priv->_id;
#line 56 "worm.vala"
	return result;
#line 3679 "worm.c"
}

static void
worm_set_id (Worm* self,
             gint value)
{
#line 56 "worm.vala"
	g_return_if_fail (self != NULL);
#line 56 "worm.vala"
	if (worm_get_id (self) != value) {
#line 56 "worm.vala"
		self->priv->_id = value;
#line 56 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_ID_PROPERTY]);
#line 3694 "worm.c"
	}
}

gboolean
worm_get_is_materialized (Worm* self)
{
	gboolean result;
#line 61 "worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "worm.vala"
	result = self->priv->_is_materialized;
#line 61 "worm.vala"
	return result;
#line 3708 "worm.c"
}

static void
worm_set_is_materialized (Worm* self,
                          gboolean value)
{
#line 61 "worm.vala"
	g_return_if_fail (self != NULL);
#line 61 "worm.vala"
	if (worm_get_is_materialized (self) != value) {
#line 61 "worm.vala"
		self->priv->_is_materialized = value;
#line 61 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_IS_MATERIALIZED_PROPERTY]);
#line 3723 "worm.c"
	}
}

gint
worm_get_lives (Worm* self)
{
	gint result;
#line 64 "worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "worm.vala"
	result = self->priv->_lives;
#line 64 "worm.vala"
	return result;
#line 3737 "worm.c"
}

void
worm_set_lives (Worm* self,
                gint value)
{
#line 64 "worm.vala"
	g_return_if_fail (self != NULL);
#line 64 "worm.vala"
	if (worm_get_lives (self) != value) {
#line 64 "worm.vala"
		self->priv->_lives = value;
#line 64 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LIVES_PROPERTY]);
#line 3752 "worm.c"
	}
}

gint
worm_get_score (Worm* self)
{
	gint result;
#line 66 "worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "worm.vala"
	result = self->priv->_score;
#line 66 "worm.vala"
	return result;
#line 3766 "worm.c"
}

void
worm_set_score (Worm* self,
                gint value)
{
#line 66 "worm.vala"
	g_return_if_fail (self != NULL);
#line 66 "worm.vala"
	if (worm_get_score (self) != value) {
#line 66 "worm.vala"
		self->priv->_score = value;
#line 66 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_SCORE_PROPERTY]);
#line 3781 "worm.c"
	}
}

gint
worm_get_length (Worm* self)
{
	gint result;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 70 "worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 70 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 70 "worm.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
#line 70 "worm.vala"
	_tmp2_ = _tmp1_;
#line 70 "worm.vala"
	result = _tmp2_;
#line 70 "worm.vala"
	return result;
#line 3804 "worm.c"
}

void
worm_set_length (Worm* self,
                 gint value)
{
#line 71 "worm.vala"
	g_return_if_fail (self != NULL);
#line 71 "worm.vala"
	g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LENGTH_PROPERTY]);
#line 3815 "worm.c"
}

void
worm_get_head (Worm* self,
               Position * result)
{
	Position head = {0};
	GeeLinkedList* _tmp0_;
	gpointer _tmp1_;
	Position* _tmp2_;
	Position _tmp3_;
	Position _tmp4_;
#line 76 "worm.vala"
	g_return_if_fail (self != NULL);
#line 78 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 78 "worm.vala"
	_tmp1_ = gee_linked_list_first (_tmp0_);
#line 78 "worm.vala"
	_tmp2_ = (Position*) _tmp1_;
#line 78 "worm.vala"
	_tmp3_ = *_tmp2_;
#line 78 "worm.vala"
	_position_free0 (_tmp2_);
#line 78 "worm.vala"
	head = _tmp3_;
#line 79 "worm.vala"
	_tmp4_ = head;
#line 79 "worm.vala"
	*result = _tmp4_;
#line 79 "worm.vala"
	return;
#line 3848 "worm.c"
}

static void
worm_set_head (Worm* self,
               Position * value)
{
	GeeLinkedList* _tmp0_;
	Position _tmp1_;
#line 81 "worm.vala"
	g_return_if_fail (self != NULL);
#line 83 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 83 "worm.vala"
	_tmp1_ = *value;
#line 83 "worm.vala"
	gee_abstract_list_set ((GeeAbstractList*) _tmp0_, 0, &_tmp1_);
#line 81 "worm.vala"
	g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_HEAD_PROPERTY]);
#line 3867 "worm.c"
}

GeeLinkedList*
worm_get_list (Worm* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
#line 93 "worm.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "worm.vala"
	_tmp0_ = self->priv->_list;
#line 93 "worm.vala"
	result = _tmp0_;
#line 93 "worm.vala"
	return result;
#line 3883 "worm.c"
}

static void
worm_set_list (Worm* self,
               GeeLinkedList* value)
{
#line 93 "worm.vala"
	g_return_if_fail (self != NULL);
#line 93 "worm.vala"
	if (worm_get_list (self) != value) {
#line 3894 "worm.c"
		GeeLinkedList* _tmp0_;
#line 93 "worm.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 93 "worm.vala"
		_g_object_unref0 (self->priv->_list);
#line 93 "worm.vala"
		self->priv->_list = _tmp0_;
#line 93 "worm.vala"
		g_object_notify_by_pspec ((GObject *) self, worm_properties[WORM_LIST_PROPERTY]);
#line 3904 "worm.c"
	}
}

static void
worm_class_init (WormClass * klass,
                 gpointer klass_data)
{
	guint* _tmp0_;
#line 46 "worm.vala"
	worm_parent_class = g_type_class_peek_parent (klass);
#line 46 "worm.vala"
	g_type_class_adjust_private_offset (klass, &Worm_private_offset);
#line 46 "worm.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_worm_get_property;
#line 46 "worm.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_worm_set_property;
#line 46 "worm.vala"
	G_OBJECT_CLASS (klass)->finalize = worm_finalize;
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_STARTING_POSITION_PROPERTY, worm_properties[WORM_STARTING_POSITION_PROPERTY] = g_param_spec_boxed ("starting-position", "starting-position", "starting-position", TYPE_POSITION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_ID_PROPERTY, worm_properties[WORM_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_IS_MATERIALIZED_PROPERTY, worm_properties[WORM_IS_MATERIALIZED_PROPERTY] = g_param_spec_boolean ("is-materialized", "is-materialized", "is-materialized", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIVES_PROPERTY, worm_properties[WORM_LIVES_PROPERTY] = g_param_spec_int ("lives", "lives", "lives", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_SCORE_PROPERTY, worm_properties[WORM_SCORE_PROPERTY] = g_param_spec_int ("score", "score", "score", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LENGTH_PROPERTY, worm_properties[WORM_LENGTH_PROPERTY] = g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_HEAD_PROPERTY, worm_properties[WORM_HEAD_PROPERTY] = g_param_spec_boxed ("head", "head", "head", TYPE_POSITION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIST_PROPERTY, worm_properties[WORM_LIST_PROPERTY] = g_param_spec_object ("list", "list", "list", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 46 "worm.vala"
	worm_signals[WORM_ADDED_SIGNAL] = g_signal_new ("added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_FINISH_ADDED_SIGNAL] = g_signal_new ("finish-added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_RESCALED_SIGNAL] = g_signal_new ("rescaled", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 46 "worm.vala"
	worm_signals[WORM_DIED_SIGNAL] = g_signal_new ("died", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_TAIL_REDUCED_SIGNAL] = g_signal_new ("tail-reduced", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 46 "worm.vala"
	worm_signals[WORM_REVERSED_SIGNAL] = g_signal_new ("reversed", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_BONUS_FOUND_SIGNAL] = g_signal_new ("bonus-found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "worm.vala"
	worm_signals[WORM_WARP_FOUND_SIGNAL] = g_signal_new ("warp-found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 477 "worm.vala"
	_tmp0_ = g_new0 (guint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
#line 477 "worm.vala"
	worm_deadend_board = _tmp0_;
#line 477 "worm.vala"
	worm_deadend_board_length1 = NIBBLES_GAME_WIDTH;
#line 477 "worm.vala"
	worm_deadend_board_length2 = NIBBLES_GAME_HEIGHT;
#line 3965 "worm.c"
}

static void
worm_instance_init (Worm * self,
                    gpointer klass)
{
#line 46 "worm.vala"
	self->priv = worm_get_instance_private (self);
#line 59 "worm.vala"
	self->keypress = FALSE;
#line 60 "worm.vala"
	self->is_stopped = FALSE;
#line 61 "worm.vala"
	self->priv->_is_materialized = TRUE;
#line 3980 "worm.c"
}

static void
worm_finalize (GObject * obj)
{
	Worm * self;
#line 46 "worm.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORM, Worm);
#line 91 "worm.vala"
	_g_object_unref0 (self->priv->key_queue);
#line 93 "worm.vala"
	_g_object_unref0 (self->priv->_list);
#line 46 "worm.vala"
	G_OBJECT_CLASS (worm_parent_class)->finalize (obj);
#line 3995 "worm.c"
}

GType
worm_get_type (void)
{
	static volatile gsize worm_type_id__volatile = 0;
	if (g_once_init_enter (&worm_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Worm), 0, (GInstanceInitFunc) worm_instance_init, NULL };
		GType worm_type_id;
		worm_type_id = g_type_register_static (G_TYPE_OBJECT, "Worm", &g_define_type_info, 0);
		Worm_private_offset = g_type_add_instance_private (worm_type_id, sizeof (WormPrivate));
		g_once_init_leave (&worm_type_id__volatile, worm_type_id);
	}
	return worm_type_id__volatile;
}

static void
_vala_worm_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
#line 46 "worm.vala"
	switch (property_id) {
#line 46 "worm.vala"
		case WORM_STARTING_POSITION_PROPERTY:
#line 4024 "worm.c"
		{
			Position boxed;
#line 46 "worm.vala"
			worm_get_starting_position (self, &boxed);
#line 46 "worm.vala"
			g_value_set_boxed (value, &boxed);
#line 4031 "worm.c"
		}
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_ID_PROPERTY:
#line 46 "worm.vala"
		g_value_set_int (value, worm_get_id (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_IS_MATERIALIZED_PROPERTY:
#line 46 "worm.vala"
		g_value_set_boolean (value, worm_get_is_materialized (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LIVES_PROPERTY:
#line 46 "worm.vala"
		g_value_set_int (value, worm_get_lives (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_SCORE_PROPERTY:
#line 46 "worm.vala"
		g_value_set_int (value, worm_get_score (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LENGTH_PROPERTY:
#line 46 "worm.vala"
		g_value_set_int (value, worm_get_length (self));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_HEAD_PROPERTY:
#line 4067 "worm.c"
		{
			Position boxed;
#line 46 "worm.vala"
			worm_get_head (self, &boxed);
#line 46 "worm.vala"
			g_value_set_boxed (value, &boxed);
#line 4074 "worm.c"
		}
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LIST_PROPERTY:
#line 46 "worm.vala"
		g_value_set_object (value, worm_get_list (self));
#line 46 "worm.vala"
		break;
#line 4084 "worm.c"
		default:
#line 46 "worm.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 46 "worm.vala"
		break;
#line 4090 "worm.c"
	}
}

static void
_vala_worm_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
#line 46 "worm.vala"
	switch (property_id) {
#line 46 "worm.vala"
		case WORM_STARTING_POSITION_PROPERTY:
#line 46 "worm.vala"
		worm_set_starting_position (self, g_value_get_boxed (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_ID_PROPERTY:
#line 46 "worm.vala"
		worm_set_id (self, g_value_get_int (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_IS_MATERIALIZED_PROPERTY:
#line 46 "worm.vala"
		worm_set_is_materialized (self, g_value_get_boolean (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LIVES_PROPERTY:
#line 46 "worm.vala"
		worm_set_lives (self, g_value_get_int (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_SCORE_PROPERTY:
#line 46 "worm.vala"
		worm_set_score (self, g_value_get_int (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LENGTH_PROPERTY:
#line 46 "worm.vala"
		worm_set_length (self, g_value_get_int (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_HEAD_PROPERTY:
#line 46 "worm.vala"
		worm_set_head (self, g_value_get_boxed (value));
#line 46 "worm.vala"
		break;
#line 46 "worm.vala"
		case WORM_LIST_PROPERTY:
#line 46 "worm.vala"
		worm_set_list (self, g_value_get_object (value));
#line 46 "worm.vala"
		break;
#line 4152 "worm.c"
		default:
#line 46 "worm.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 46 "worm.vala"
		break;
#line 4158 "worm.c"
	}
}

