/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- *//* 
 * Copyright (C) 1998-2000 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Eskil Heyn Olsen
 *          Vadim Strizhevsky
 */

/* $Id: file_conduit.c,v 1.19 2001/06/19 02:06:22 eskil Exp $ */

#include <glib.h>
#include <gnome.h>

#include <pi-source.h>
#include <pi-socket.h>
#include <pi-file.h>
#include <pi-dlp.h>
#include <pi-version.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <utime.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>

#include <gpilotd/gnome-pilot-conduit-file.h>

/* pilot stuff begin */
#include <stdio.h>
#include <time.h>
#ifdef __EMX__
#include <sys/types.h>
#endif
#include <sys/stat.h>
#include <signal.h>
#include <utime.h>
#include "pi-source.h"
#include "pi-socket.h"
#include "pi-file.h"
#include "pi-dlp.h"
#define pi_mktag(c1,c2,c3,c4) (((c1)<<24)|((c2)<<16)|((c3)<<8)|(c4))
#define MAXDBS 256
/* pilot stuff end */

GnomePilotConduit *conduit_get_gpilot_conduit (guint32 pilotId);
void conduit_destroy_gpilot_conduit (GnomePilotConduit *conduit);

typedef struct file_db {
        gchar name[256];
        gchar dbname[256];
        gint flags;
        gulong creator;
        gulong type;
        gint maxblock;
} file_db;

static gint
gnome_real_pilot_conduit_file_install_db (GnomePilotConduitFile *file_conduit,
					  int psock,
					  gchar *src_file)
{
	GnomePilotDBInfo info;
	struct pi_file *file;
#ifdef DEBUG
	g_print ("in gnome_real_pilot_conduit_file_install_db\nsrc_file is %s\n", src_file);
#endif
	
	if ( dlp_OpenConduit(psock) < 0) {
#ifdef DEBUG
		fprintf(stderr, "file_conduit: Exiting on cancel, stopped before installing '%s'.\n", src_file);
#endif
		return -1;
	}

	file = pi_file_open(src_file);
	if (file == NULL) {
#ifdef DEBUG
		fprintf(stderr,"file_conduit: Unable to open '%s'!\n", src_file);
#endif
		return -1;
	}

#ifdef DEBUG
	fprintf(stderr,"file_conduit: Installing %s... ", src_file);
	fflush(stdout);
#endif
	pi_file_get_info (file, (PI_DBINFO (&info)));
	g_message(_("Installing %s from %s..."),PI_DBINFO (&info)->name, src_file);
	gnome_pilot_conduit_send_message(GNOME_PILOT_CONDUIT(file_conduit),
					 _("Installing %s..."),
					 PI_DBINFO (&info)->name);
	if (pi_file_install (file, psock, 0) < 0) {
#ifdef DEBUG
		fprintf(stderr,"failed.\n");
#endif
		gnome_pilot_conduit_send_error(GNOME_PILOT_CONDUIT(file_conduit),
					       _("Installing %s failed"),
					       PI_DBINFO (&info)->name);
		pi_file_close (file);
		return -1;
	} else {
#ifdef DEBUG
		fprintf(stderr,"OK\n");
#endif
		pi_file_close (file);
		unlink (src_file);
		return 0;
	}
};

GnomePilotConduit *
conduit_load_gpilot_conduit (GPilotPilot *pilot)
{
	GnomePilotConduit *retval;

	retval = GNOME_PILOT_CONDUIT (gnome_pilot_conduit_file_new (pilot));
	g_assert (retval != NULL);

	gtk_signal_connect (GTK_OBJECT (retval), 
			    GNOME_PILOT_CONDUIT_FILE_SIGNAL_INSTALL_DB (gnome_real_pilot_conduit_file_install_db), 
			    NULL);       

	return retval;
}

void
conduit_destroy_gpilot_conduit (GnomePilotConduit *conduit)
{
	gtk_object_destroy (GTK_OBJECT (conduit));
}
