#include <gtk/gtk.h>
#include <stdio.h>
#include "gnome-print.h"
#include "gnome-print-ps.h"

static void gnome_print_context_class_init (GnomePrintContextClass *klass);

static void
gnome_print_context_init (GnomePrintContext *pc);

static void
gnome_print_context_finalize (GtkObject *object);

static GtkObjectClass *parent_class = NULL;

GtkType
gnome_print_context_get_type (void)
{
  static GtkType pc_type = 0;

  if (!pc_type)
    {
      GtkTypeInfo pc_info =
      {
	"GnomePrintContext",
	sizeof (GnomePrintContext),
	sizeof (GnomePrintContextClass),
	(GtkClassInitFunc) gnome_print_context_class_init,
	(GtkObjectInitFunc) gnome_print_context_init,
	/* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      pc_type = gtk_type_unique (gtk_object_get_type (), &pc_info);
    }

  return pc_type;
}

static void
gnome_print_context_class_init (GnomePrintContextClass *class)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass*) class;

  parent_class = gtk_type_class (gtk_object_get_type ());

  object_class->finalize = gnome_print_context_finalize;

/* initialization code, autogenned */
  class->newpath = NULL;
  class->moveto = NULL;
  class->lineto = NULL;
  class->curveto = NULL;
  class->closepath = NULL;
  class->setrgbcolor = NULL;
  class->fill = NULL;
  class->eofill = NULL;
  class->setlinewidth = NULL;
  class->setmiterlimit = NULL;
  class->setlinejoin = NULL;
  class->setlinecap = NULL;
  class->setdash = NULL;
  class->strokepath = NULL;
  class->stroke = NULL;
  class->setfont = NULL;
  class->show = NULL;
  class->concat = NULL;
  class->setmatrix = NULL;
  class->gsave = NULL;
  class->grestore = NULL;
  class->clip = NULL;
  class->eoclip = NULL;
  class->grayimage = NULL;
  class->rgbimage = NULL;
  class->showpage = NULL;
}

static void
gnome_print_context_init (GnomePrintContext *pc)
{
  pc->f = NULL;
}

/* This dispatch is by cases rather than being object oriented. It may
   be desirable to make it more OO. Basically, the way that would be
   done would be to have a gnome_printer_make_new_context () method
   on GnomePrinter objects.

   However, this will do for now, and saves making extra classes.
*/
GnomePrintContext *
gnome_print_context_new (GnomePrinter *printer)
{
  switch (printer->printer_type)
    {
    case GNOME_PRINTER_TYPE_GENERIC_PS:
      return GNOME_PRINT_CONTEXT(gnome_print_ps_new (printer));
    }
  return NULL;
}


static void
gnome_print_context_finalize (GtkObject *object)
{
  GnomePrintContext *pc;

  g_return_if_fail (object != NULL);
  g_return_if_fail (GNOME_IS_PRINT_CONTEXT (object));

  pc = GNOME_PRINT_CONTEXT (object);

  (* GTK_OBJECT_CLASS (parent_class)->finalize) (object);
}

/* methods */

#define PRINT_CLASS(pc) GNOME_PRINT_CONTEXT_CLASS(GTK_OBJECT(pc)->klass)

/* The implementations of the virtual paint methods, autogenned */
int
gnome_print_newpath          (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->newpath (pc);
}

int
gnome_print_moveto           (GnomePrintContext *pc, double x, double y)
{
  return PRINT_CLASS(pc)->moveto (pc, x, y);
}

int
gnome_print_lineto           (GnomePrintContext *pc, double x, double y)
{
  return PRINT_CLASS(pc)->lineto (pc, x, y);
}

int
gnome_print_curveto          (GnomePrintContext *pc, double x1, double y1, double x2, double y2, double x3, double y3)
{
  return PRINT_CLASS(pc)->curveto (pc, x1, y1, x2, y2, x3, y3);
}

int
gnome_print_closepath        (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->closepath (pc);
}

int
gnome_print_setrgbcolor      (GnomePrintContext *pc, double r, double g, double b)
{
  return PRINT_CLASS(pc)->setrgbcolor (pc, r, g, b);
}

int
gnome_print_fill             (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->fill (pc);
}

int
gnome_print_eofill           (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->eofill (pc);
}

int
gnome_print_setlinewidth     (GnomePrintContext *pc, double width)
{
  return PRINT_CLASS(pc)->setlinewidth (pc, width);
}

int
gnome_print_setmiterlimit    (GnomePrintContext *pc, double limit)
{
  return PRINT_CLASS(pc)->setmiterlimit (pc, limit);
}

int
gnome_print_setlinejoin      (GnomePrintContext *pc, int jointype)
{
  return PRINT_CLASS(pc)->setlinejoin (pc, jointype);
}

int
gnome_print_setlinecap       (GnomePrintContext *pc, int captype)
{
  return PRINT_CLASS(pc)->setlinecap (pc, captype);
}

int
gnome_print_setdash          (GnomePrintContext *pc, int n_values, double *values, double offset)
{
  return PRINT_CLASS(pc)->setdash (pc, n_values, values, offset);
}

int
gnome_print_strokepath       (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->strokepath (pc);
}

int
gnome_print_stroke           (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->stroke (pc);
}

int
gnome_print_setfont          (GnomePrintContext *pc, GnomeFont *font)
{
  return PRINT_CLASS(pc)->setfont (pc, font);
}

int
gnome_print_show             (GnomePrintContext *pc, char *text)
{
  return PRINT_CLASS(pc)->show (pc, text);
}

int
gnome_print_concat           (GnomePrintContext *pc, double matrix[6])
{
  return PRINT_CLASS(pc)->concat (pc, matrix);
}

int
gnome_print_setmatrix        (GnomePrintContext *pc, double matrix[6])
{
  return PRINT_CLASS(pc)->setmatrix (pc, matrix);
}

int
gnome_print_gsave            (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->gsave (pc);
}

int
gnome_print_grestore         (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->grestore (pc);
}

int
gnome_print_clip             (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->clip (pc);
}

int
gnome_print_eoclip           (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->eoclip (pc);
}

int
gnome_print_grayimage        (GnomePrintContext *pc, char *data, int width, int height, int rowstride)
{
  return PRINT_CLASS(pc)->grayimage (pc, data, width, height, rowstride);
}

int
gnome_print_rgbimage         (GnomePrintContext *pc, char *data, int width, int height, int rowstride)
{
  return PRINT_CLASS(pc)->rgbimage (pc, data, width, height, rowstride);
}

int
gnome_print_textline	     (GnomePrintContext *pc, GnomeTextLine *line)
{
  return PRINT_CLASS(pc)->textline (pc, line);
}

int
gnome_print_showpage         (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->showpage (pc);
}


int
gnome_print_context_close (GnomePrintContext *pc)
{
  return PRINT_CLASS(pc)->close (pc);
}

/* These functions are wrapper functions around capabilities that may
   or may not be deconvolved in back ends. */

int
gnome_print_scale (GnomePrintContext *pc, double sx, double sy)
{
  double dst[6];

  art_affine_scale (&dst, sx, sy);
  return gnome_print_concat (pc, dst);
}

int
gnome_print_rotate (GnomePrintContext *pc, double theta)
{
  double dst[6];

  art_affine_rotate (&dst, theta);
  return gnome_print_concat (pc, dst);
}

int
gnome_print_translate (GnomePrintContext *pc, double x, double y)
{
  double dst[6];

  art_affine_translate (&dst, x, y);
  return gnome_print_concat (pc, dst);
}

/* These functions provide a common interface for writing bytes to the
   printer. */

/* Return 0 on success */
int
gnome_print_context_open_file (GnomePrintContext *pc, const char *filename)
{
  g_return_val_if_fail (pc != NULL, -1);
  g_return_val_if_fail (GNOME_IS_PRINT_CONTEXT (pc), -1);

  if (filename[0] == '|')
    {
      pc->f = popen (filename + 1, "w");
      pc->is_pipe = TRUE;
    }
  else
    {
      pc->f = fopen (filename, "w");
      pc->is_pipe = FALSE;
    }
  return pc->f != NULL;
}

/* Return number of bytes written */
int
gnome_print_context_write_file (GnomePrintContext *pc, char *buf, size_t size)
{
  g_return_val_if_fail (pc != NULL, 0);
  g_return_val_if_fail (GNOME_IS_PRINT_CONTEXT (pc), 0);
  g_return_val_if_fail (pc->f != NULL, 0);

  return fwrite (buf, sizeof(char), size, pc->f);
}

/* Return number of bytes written, or -1 if error */
int
gnome_print_context_fprintf (GnomePrintContext *pc, const char *fmt, ...)
{
  va_list ap;
  int n_bytes;

  g_return_val_if_fail (pc != NULL, -1);
  g_return_val_if_fail (GNOME_IS_PRINT_CONTEXT (pc), -1);
  g_return_val_if_fail (pc->f != NULL, -1);

  va_start (ap, fmt);
  n_bytes = vfprintf (pc->f, fmt, ap);
  va_end (ap);
  return n_bytes;
}

/* Return 0 on success */
int
gnome_print_context_close_file (GnomePrintContext *pc)
{
  g_return_val_if_fail (pc != NULL, -1);
  g_return_val_if_fail (GNOME_IS_PRINT_CONTEXT (pc), -1);

  if (pc->f != NULL)
    {
      if (pc->is_pipe)
	return fclose (pc->f);
      else
	return pclose (pc->f);
    }
  else
    return 0;
}
