#ifndef __GNOME_FONT_H__
#define __GNOME_FONT_H__


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#include <gnome.h>


#define GNOME_TYPE_FONT		 (gnome_font_get_type ())
#define GNOME_FONT(obj)		 (GTK_CHECK_CAST ((obj), GNOME_TYPE_FONT, GnomeFont))
#define GNOME_FONT_CLASS(klass)	 (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_FONT, GnomeFontClass))
#define GNOME_IS_FONT(obj)	 (GTK_CHECK_TYPE ((obj), GNOME_TYPE_FONT))
#define GNOME_IS_FONT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_FONT))


/* We are going to do a renaming of GnomeFontMap to GnomeFontUnsized,
   and export a bunch of operations on GnomeFontUnsized to the outside
   world. */

typedef struct _GnomeFont            GnomeFont;
typedef struct _GnomeFontClass       GnomeFontClass;
typedef struct _GnomeFontMap         GnomeFontUnsized;
typedef struct _GnomeFontMap         GnomeFontMap;
typedef struct _GnomeFontGlyphAlias  GnomeFontGlyphAlias;
typedef struct _GnomeFontKernPair    GnomeFontKernPair;
typedef struct _GnomeFontLigList     GnomeFontLigList;

struct _GnomeFont
{
  GtkObject object;

  int num;
  double size;
  GnomeFontMap *fontmap_entry;
  double scale;
};

struct _GnomeFontClass
{
  GtkObjectClass parent_class;

  int n_fonts;
  GnomeFontMap *fontmap;

  int n_glyph_alias;
  GnomeFontGlyphAlias *glyph_alias;
};

/* These numbers are very loosely adapted from the Univers numbering
   convention. I've had to insert some to accomodate all the
   distinctions in the Adobe font catalog. Also, I've offset the
   numbering so that the default is 0. */
typedef enum {
  GNOME_FONT_LIGHTEST = -3,
  GNOME_FONT_EXTRA_LIGHT = -3,
  GNOME_FONT_THIN = -2,
  GNOME_FONT_LIGHT = -1,
  GNOME_FONT_BOOK = 0, /* also known as "regular" or "roman" */
  /* gap here so that if book is missing, light wins over medium */
  GNOME_FONT_MEDIUM = 2,
  GNOME_FONT_SEMI = 3, /* also known as "demi" */
  GNOME_FONT_BOLD = 4,
  /* gap here so that if bold is missing, semi wins over heavy */
  GNOME_FONT_HEAVY = 6,
  GNOME_FONT_EXTRABOLD = 7,
  GNOME_FONT_BLACK = 8,
  GNOME_FONT_EXTRABLACK = 9, /* also known as "ultra" */
  GNOME_FONT_HEAVIEST = 9
} GnomeFontWeight;

#define GNOME_FONT_NUM_WEIGHTS (GNOME_FONT_HEAVIEST + 1 - GNOME_FONT_LIGHTEST)

struct _GnomeFontMap
{
  char *font_name;
  char *afm_fn;
  char *pfb_fn;
  char *fullname;
  char *familyname;
  char *weight;
  GnomeFontMap *subst_glyph;

  /* Font metric info follows */
  GnomeFontWeight weight_code;
  gboolean italic;
  /* above is font metric info stored in the fontmap, below is font metric
     info parsed from the afm file. */
  int  *widths;
  GnomeFontKernPair *kerns;
  int num_kerns;
  GnomeFontLigList **ligs; /* one liglist for each glyph */

  int first_cov_page;
  int num_cov_pages;
  int **cov_pages; /* each page is an array of 256 ints */
};

struct _GnomeFontKernPair
{
  int glyph1;
  int glyph2;
  int x_amt;
};

struct _GnomeFontLigList {
  GnomeFontLigList *next;
  int succ, lig;
};

struct _GnomeFontGlyphAlias
{
  char *font_name;
  char *subst_font_name;
};

GtkType gnome_font_get_type (void);

GnomeFont *gnome_font_new (const char *name, double size);

GnomeFont *gnome_font_new_closest (const char *family_name,
				   GnomeFontWeight weight,
				   gboolean italic,
				   double size);

/* Find the closest weight matching the family name, weight, and italic
   specs. Return the unsized font. */
GnomeFontUnsized *
gnome_font_unsized_closest (const char *family_name,
			    GnomeFontWeight weight,
			    gboolean italic);

/* return a pointer to the (PostScript) name of the font */
char *
gnome_font_unsized_get_name (GnomeFontUnsized *font);

/* return a pointer to the (PostScript) name of the font */
char *
gnome_font_unsized_get_glyph_name (GnomeFontUnsized *font);

char *
gnome_font_get_name (GnomeFont *font);

char *
gnome_font_get_glyph_name (GnomeFont *font);

char *
gnome_font_unsized_get_pfa (GnomeFontUnsized *font);

char *
gnome_font_get_pfa (GnomeFont *font);

/* this routine is fast; go ahead and use it */
double
gnome_font_get_width (GnomeFont *font, int ch);

/* Returns the glyph width in 0.001 unit */
int
gnome_font_unsized_get_width (GnomeFontUnsized *font, int ch);

/* this routine is fast; go ahead and use it */
double
gnome_font_get_width_string (GnomeFont *font, const char *s);

/* Return the amount of kerning for the two glyphs. */
double
gnome_font_kern (GnomeFont *font, int glyph1, int glyph2);

/* Return the amount of kerning for the two glyphs. */
int
gnome_font_unsized_kern (GnomeFontUnsized *font, int glyph1, int glyph2);

/* Get the glyph number corresponding to a given unicode, or -1 if it
   is not mapped. */
int
gnome_font_get_glyph (GnomeFont *font, int unicode);

/* Get the glyph number corresponding to a given unicode, or -1 if it
   is not mapped. */
int
gnome_font_unsized_get_glyph (GnomeFontUnsized *font, int unicode);

/* Return a list of fonts, as a g_list of strings */
GList *
gnome_font_list (GnomeFontClass *klass);

void
gnome_font_list_free (GList *fontlist);

/* Return a list of font families, as a g_list of newly allocated strings */
GList *
gnome_font_family_list (GnomeFontClass *klass);

void
gnome_font_family_list_free (GList *fontlist);


typedef struct
{
  GnomeFontUnsized *unsized_font; /* font before scaling */
  GnomeFont *gnome_font; /* scaled font */
  double scale; /* scaling factor requested by a view */

  char *x_font_name; /* x name that got us gdk_font */
  GdkFont *gdk_font; /* used for drawing */
} GnomeDisplayFont;

GnomeDisplayFont *gnome_font_get_display_font( GnomeFont *font );

char *gnome_font_weight_to_string (GnomeFontWeight gfw);
GnomeFontWeight string_to_gnome_font_weight (char *weight);
GnomeDisplayFont *gnome_get_display_font (char *family,
					  GnomeFontWeight weight,
					  gboolean italic,
					  double points,
					  double scale);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_FONT_H__ */
