#ifndef __GNOME_PRINTER_DIALOG_H__
#define __GNOME_PRINTER_DIALOG_H__

#include "gnome-printer-profile.h"

BEGIN_GNOME_DECLS

#define GNOME_TYPE_PRINTER_WIDGET	     (gnome_printer_widget_get_type ())
#define GNOME_PRINTER_WIDGET(obj)	     (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINTER_WIDGET, GnomePrinterWidget))
#define GNOME_PRINTER_WIDGET_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINTER_WIDGET, GnomePrinterWidgetClass))
#define GNOME_IS_PRINTER_WIDGET(obj)	     (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINTER_WIDGET))
#define GNOME_IS_PRINTER_WIDGET_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINTER_WIDGET))

typedef struct {
	GtkFrame frame;
	
	GnomePrinterProfileList *profiles;
	GnomePrinterProfile *profile;

	GtkWidget *label_state;
	GtkWidget *label_type;
	GtkWidget *label_location;
	GtkWidget *label_comment;
	
	GtkWidget *r1;
	GtkWidget *r2;
	GtkWidget *entry_command;
	GtkWidget *entry_filename;
} GnomePrinterWidget;

typedef struct {
	GtkFrameClass parent_class;
} GnomePrinterWidgetClass;

GtkType       gnome_printer_widget_get_type    (void);
GtkWidget    *gnome_printer_widget_new         (void);
GnomePrinter *gnome_printer_widget_get_printer (GnomePrinterWidget *widget);

#define GNOME_TYPE_PRINTER_DIALOG	     (gnome_printer_dialog_get_type ())
#define GNOME_PRINTER_DIALOG(obj)	     (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINTER_DIALOG, GnomePrinterDialog))
#define GNOME_PRINTER_DIALOG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINTER_DIALOG, GnomePrinterDialogClass))
#define GNOME_IS_PRINTER_DIALOG(obj)	     (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINTER_DIALOG))
#define GNOME_IS_PRINTER_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINTER_DIALOG))

typedef struct {
	GnomeDialog dialog;
	GnomePrinterWidget *gnome_printer_widget;
} GnomePrinterDialog;

typedef struct {
	GnomeDialogClass parent_class;
} GnomePrinterDialogClass;


GtkType       gnome_printer_dialog_get_type    (void);
GnomePrinter *gnome_printer_dialog_new_modal   (void);
GtkWidget    *gnome_printer_dialog_new         (void);
GnomePrinter *gnome_printer_dialog_get_printer (GnomePrinterDialog *dialog);

END_GNOME_DECLS

#endif /* __GNOME_PRINTER_DIALOG_H__ */
