#ifndef __GNOME_PRINT_PIXBUF_H__
#define __GNOME_PRINT_PIXBUF_H__

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-paper.h>
#include <libgnomeui/gnome-canvas.h>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-rgbp.h>

BEGIN_GNOME_DECLS

/*
 * GnomePrintPixbuf printer context.
 */
#define GNOME_TYPE_PRINT_PIXBUF	      (gnome_print_pixbuf_get_type ())
#define GNOME_PRINT_PIXBUF(obj)	      (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINT_PIXBUF, GnomePrintPixbuf))
#define GNOME_PRINT_PIXBUF_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINT_PIXBUF, GnomePrintPixbufClass))
#define GNOME_IS_PRINT_PIXBUF(obj)	 (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINT_PIXBUF))
#define GNOME_IS_PRINT_PIXBUF_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINT_PIXBUF))

typedef struct _GnomePrintPixbuf        GnomePrintPixbuf;
typedef struct _GnomePrintPixbufPrivate GnomePrintPixbufPrivate;
typedef struct _GnomePrintPixbufClass   GnomePrintPixbufClass;

struct _GnomePrintPixbuf {
	GnomePrintRGBP rgbp;

	GnomePrintPixbufPrivate *priv;
};

struct _GnomePrintPixbufClass {
	GnomePrintRGBPClass parent_class;
};

GtkType            gnome_print_pixbuf_get_type  (void);
GnomePrintContext *gnome_print_pixbuf_new       (GnomePrinter *printer,
						 const char *paper_size,
						 int dpi);
GnomePrintPixbuf  *gnome_print_pixbuf_construct (GnomePrintPixbuf *pixbuf,
						 GnomePrinter *printer,
						 const GnomePaper *paper_info,
						 int dpi);

#endif /* __GNOME_PRINT_PIXBUF_H__ */

