/* -*- Mode: C; c-basic-offset: 4 -*- */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* include this first, before NO_IMPORT_PYGOBJECT is defined */
#include <pygobject.h>

void pygconf_register_classes (PyObject *d);

extern PyMethodDef pygconf_functions[];

DL_EXPORT(void)
initgconf (void)
{
	PyObject *m, *d;

	init_pygobject ();

	m = Py_InitModule ("gconf", pygconf_functions);
	d = PyModule_GetDict (m);

	pygconf_register_classes (d);
	pygconf_add_constants (m, "GCONF_");
	
	if (PyErr_Occurred ()) {
		Py_FatalError ("can't initialise module gconf");
	}
}
