/* GnomeScan - Gnome Scanning Infrastructure
 *
 * gnomescanutils.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanutils
 * @title: Miscellaneous
 * @short_description: Convenient functions
 *
 * This part of Gnome Scan implement function that fill a lake in glib
 * or implement special function for scanning such as unit conversion.
 */

#ifndef GNOME_SCAN_UTILS_H
#define	GNOME_SCAN_UTILS_H

#include <glib-object.h>

G_BEGIN_DECLS

/**
 * GSEFunc:
 * @value:	A GEnum value.
 * @data: 	A user data.
 *
 * Function prototype for gs_enum_foreach() loop.
 */
typedef	void	(*GSEFunc)			(gint value,
						 gpointer data);

gint	gs_strcmp			(const gchar *v1,
					 const gchar *v2);

gdouble	gnome_scan_mm_from_pixel	(gint pixel,
					 gdouble resolution);

gint	gnome_scan_pixel_from_mm	(gdouble mm,
					 gdouble resolution);

GValue*	gs_value_new_boolean		(gboolean boolean);

GValue*	gs_value_new_int		(gint integer);

GValue* gs_value_new_string		(const gchar* string);

GValue* gs_value_new_double		(gdouble real);

GValue* gs_value_new_enum		(GType type,
					 gint v_enum);

gchar*	gs_enum_get_nick		(GType type,
					 gint value);

gchar*	gs_enum_get_name		(GType type,
					 gint value);

void	gs_enum_foreach			(GType type,
					 GSEFunc func,
					 gpointer data);
G_END_DECLS

#endif
