/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescandialog.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescandialog
 * @short_description: A scan configuration UI container
 *
 * The #GnomeScanDialog widget allow the application to compose a scan
 * configuration UI. This way, each application has the power to
 * choose what they want the user to configure and what they don't
 * want to. This is a key feature since scanner has a lot of use from
 * simple picture scan to OCR.
 *
 * Application first instanciate the #GnomeScanContext. Preconfigure
 * it as wanted. Then build the scan configuration UI passing the
 * #GnomeScanContext to each GnomeScan widget. Then pass the UI to a
 * #GnomeScanDialog and run the #GnomeScanDialog using
 * gnome_scan_dialog_run(). When user has finished to configure the
 * scan, he just validate the scan configuration and then, the
 * acquisition start. See #GnomeScanAcquisitionDialog for further
 * information on the second step.
 */

#ifndef GNOME_SCAN_DIALOG_H
#define GNOME_SCAN_DIALOG_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnomescan.h>
#include "gnomescanacquisitiondialog.h"

#define	GNOME_TYPE_SCAN_DIALOG			(gnome_scan_dialog_get_type ())
#define GNOME_SCAN_DIALOG(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_DIALOG, GnomeScanDialog))
#define GNOME_SCAN_DIALOG_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_DIALOG, GnomeScanDialogClass))
#define GNOME_IS_SCAN_DIALOG(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_DIALOG))
#define GNOME_IS_SCAN_DIALOG_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_DIALOG))
#define GNOME_SCAN_DIALOG_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_DIALOG, GnomeScanDialogClass))

typedef struct _GnomeScanDialog			GnomeScanDialog;
typedef struct _GnomeScanDialogClass		GnomeScanDialogClass;

struct _GnomeScanDialog {
  /*< private >*/
  GtkWindow			parent;

  /* Add ui, probedialog, aboutdialog and acquisitiondialog widget
     here. */
  /*< public >*/
  GnomeScanContext*		context;
};

struct _GnomeScanDialogClass {
  GtkWindowClass		parent;

  /* SIGNALS */
};

enum {
  GNOME_SCAN_DIALOG_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scan_dialog_get_type			(void);

/* Methods */

GtkWidget*		gnome_scan_dialog_new 				(GnomeScanContext *context,
									 GtkWindow *parent,
									 GtkWidget *ui);

GtkWidget*		gnome_scan_dialog_add_secondary_button		(GnomeScanDialog *dialog,
									 const gchar* stock_id);

void			gnome_scan_dialog_run				(GnomeScanDialog *dialog);

#endif
