/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_DIALOG_H__
#define __GNOME_SCAN_DIALOG_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnome-scan-job.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_DIALOG (gnome_scan_dialog_get_type ())
#define GNOME_SCAN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialog))
#define GNOME_SCAN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialogClass))
#define GNOME_SCAN_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_DIALOG))
#define GNOME_SCAN_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_DIALOG))
#define GNOME_SCAN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_DIALOG, GnomeScanDialogClass))

typedef struct _GnomeScanDialog GnomeScanDialog;
typedef struct _GnomeScanDialogClass GnomeScanDialogClass;
typedef struct _GnomeScanDialogPrivate GnomeScanDialogPrivate;

struct _GnomeScanDialog {
	GtkWindow parent_instance;
	GnomeScanDialogPrivate * priv;
};

struct _GnomeScanDialogClass {
	GtkWindowClass parent_class;
};


GnomeScanDialog* gnome_scan_dialog_construct (GType object_type, GtkWindow* parent, GnomeScanJob* job);
GnomeScanDialog* gnome_scan_dialog_new (GtkWindow* parent, GnomeScanJob* job);
void gnome_scan_dialog_run (GnomeScanDialog* self);
GnomeScanJob* gnome_scan_dialog_get_job (GnomeScanDialog* self);
void gnome_scan_dialog_set_job (GnomeScanDialog* self, GnomeScanJob* value);
GType gnome_scan_dialog_get_type (void);


G_END_DECLS

#endif
