/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-init.h>
#include <config.h>
#include <gegl.h>
#include <gnome-scan-option-manager.h>
#include <gnome-scan-option.h>
#include <gnome-scan-checkbox-widget.h>
#include <gnome-scan-scale-widget.h>
#include <gnome-scan-entry-widget.h>
#include <gnome-scan-combo-box-widget.h>
#include <gnome-scan-page-orientation-widget.h>




GnomeScanModuleManager* gnome_scan_module_manager = NULL;



void gnome_scan_init (int* argv_length1, char*** argv) {
	char* module_path;
	GnomeScanOptionManager* _tmp0;
	char* _tmp1;
	GnomeScanModuleManager* _tmp2;
	g_debug ("gnome-scan-init.vala:33: Initializing GNOME Scan %s for %s", PACKAGE_VERSION, g_get_prgname ());
	module_path = NULL;
	/* TODO: i18n
	 TODO: install stock items*/
	_tmp0 = NULL;
	gnome_scan_option_manager = (_tmp0 = gnome_scan_option_manager_new (), (gnome_scan_option_manager == NULL) ? NULL : (gnome_scan_option_manager = (g_object_unref (gnome_scan_option_manager), NULL)), _tmp0);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_BOOL, GNOME_SCAN_TYPE_CHECKBOX_WIDGET);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_INT, GNOME_SCAN_TYPE_SCALE_WIDGET);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_DOUBLE, GNOME_SCAN_TYPE_SCALE_WIDGET);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_STRING, GNOME_SCAN_TYPE_ENTRY_WIDGET);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, GNOME_SCAN_TYPE_OPTION_ENUM, GNOME_SCAN_TYPE_COMBO_BOX_WIDGET);
	gnome_scan_option_manager_register_rule_by_name (gnome_scan_option_manager, "page-orientation", GNOME_SCAN_TYPE_PAGE_ORIENTATION_WIDGET);
	_tmp1 = NULL;
	module_path = (_tmp1 = g_strjoin (G_SEARCHPATH_SEPARATOR_S, MODULE_DIR, "modules/gsfile", "modules/gsane", "../modules/gsfile", "../modules/gsane", NULL), module_path = (g_free (module_path), NULL), _tmp1);
	_tmp2 = NULL;
	gnome_scan_module_manager = (_tmp2 = gnome_scan_module_manager_new (module_path), (gnome_scan_module_manager == NULL) ? NULL : (gnome_scan_module_manager = (g_object_unref (gnome_scan_module_manager), NULL)), _tmp2);
	gnome_scan_module_manager_query_modules (gnome_scan_module_manager);
	/* init Gegl after query_module so that modules can provide
	 gegl operation.*/
	gegl_init (&(*argv_length1), &(*argv));
	module_path = (g_free (module_path), NULL);
}


void gnome_scan_exit (void) {
	GnomeScanModuleManager* _tmp0;
	GnomeScanOptionManager* _tmp1;
	_tmp0 = NULL;
	gnome_scan_module_manager = (_tmp0 = NULL, (gnome_scan_module_manager == NULL) ? NULL : (gnome_scan_module_manager = (g_object_unref (gnome_scan_module_manager), NULL)), _tmp0);
	_tmp1 = NULL;
	gnome_scan_option_manager = (_tmp1 = NULL, (gnome_scan_option_manager == NULL) ? NULL : (gnome_scan_option_manager = (g_object_unref (gnome_scan_option_manager), NULL)), _tmp1);
	gegl_exit ();
}




