/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_MODULE_MANAGER_H__
#define __GNOME_SCAN_MODULE_MANAGER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_MODULE_MANAGER (gnome_scan_module_manager_get_type ())
#define GNOME_SCAN_MODULE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManager))
#define GNOME_SCAN_MODULE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerClass))
#define GNOME_SCAN_IS_MODULE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER))
#define GNOME_SCAN_IS_MODULE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_MODULE_MANAGER))
#define GNOME_SCAN_MODULE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_MODULE_MANAGER, GnomeScanModuleManagerClass))

typedef struct _GnomeScanModuleManager GnomeScanModuleManager;
typedef struct _GnomeScanModuleManagerClass GnomeScanModuleManagerClass;
typedef struct _GnomeScanModuleManagerPrivate GnomeScanModuleManagerPrivate;

/**
 * SECTION: gnome-scan-module-manager
 * @short_description: Finding installed modules
 *
 * The #GnomeScanModuleManager search in a list of path shared object,
 * and instanciate a #GnomeScanModule for each shared object. Upon
 * initialization, the #GnomeScanModule will register new GTypes. This
 * implementation is meant to be portable, but never tested on other
 * plateform that GNU/Linux.
 **/
struct _GnomeScanModuleManager {
	GObject parent_instance;
	GnomeScanModuleManagerPrivate * priv;
};

struct _GnomeScanModuleManagerClass {
	GObjectClass parent_class;
};


GnomeScanModuleManager* gnome_scan_module_manager_construct (GType object_type, const char* path);
GnomeScanModuleManager* gnome_scan_module_manager_new (const char* path);
void gnome_scan_module_manager_query_modules (GnomeScanModuleManager* self);
void gnome_scan_module_manager_unload_modules (GnomeScanModuleManager* self);
const char* gnome_scan_module_manager_get_path (GnomeScanModuleManager* self);
void gnome_scan_module_manager_set_path (GnomeScanModuleManager* self, const char* value);
GType gnome_scan_module_manager_get_type (void);


G_END_DECLS

#endif
