/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-module.h>
#include <gmodule.h>




struct _GnomeScanModulePrivate {
	char* _filename;
	GModule* library;
	GnomeScanModuleInitFunc init;
	gpointer init_target;
	GnomeScanModuleFinalizeFunc finalize;
	gpointer finalize_target;
};

#define GNOME_SCAN_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_MODULE, GnomeScanModulePrivate))
enum  {
	GNOME_SCAN_MODULE_DUMMY_PROPERTY,
	GNOME_SCAN_MODULE_FILENAME
};
static gboolean gnome_scan_module_real_load (GTypeModule* base);
static void gnome_scan_module_real_unload (GTypeModule* base);
static gpointer gnome_scan_module_parent_class = NULL;
static void gnome_scan_module_finalize (GObject* obj);



static gboolean gnome_scan_module_real_load (GTypeModule* base) {
	GnomeScanModule * self;
	GModule* _tmp0;
	void* init_function;
	void* finalize_function;
	gboolean _tmp2;
	GnomeScanModuleInitFunc _tmp4;
	GnomeScanModuleFinalizeFunc _tmp5;
	self = (GnomeScanModule*) base;
	_tmp0 = NULL;
	self->priv->library = (_tmp0 = g_module_open (self->priv->_filename, G_MODULE_BIND_MASK), (self->priv->library == NULL) ? NULL : (self->priv->library = (g_module_close (self->priv->library), NULL)), _tmp0);
	if (self->priv->library == NULL) {
		g_warning ("gnome-scan-module.vala:48: %s", g_module_error ());
		return FALSE;
	}
	init_function = NULL;
	finalize_function = NULL;
	_tmp2 = FALSE;
	if (!g_module_symbol (self->priv->library, "gnome_scan_module_init", &init_function)) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = !g_module_symbol (self->priv->library, "gnome_scan_module_finalize", &finalize_function);
	}
	if (_tmp2) {
		g_warning ("gnome-scan-module.vala:58: %s does not contain a valid %s", self->priv->_filename, (g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self))));
		return FALSE;
	}
	self->priv->init = (_tmp4 = (GnomeScanModuleInitFunc) init_function, self->priv->init_target = NULL, _tmp4);
	self->priv->finalize = (_tmp5 = (GnomeScanModuleFinalizeFunc) finalize_function, self->priv->finalize_target = NULL, _tmp5);
	self->priv->init (self, self->priv->init_target);
	return TRUE;
}


static void gnome_scan_module_real_unload (GTypeModule* base) {
	GnomeScanModule * self;
	self = (GnomeScanModule*) base;
	self->priv->finalize (self->priv->finalize_target);
}


/**
 * gnome_scan_module_new:
 * @filename: The path to shared object
 * 
 * Open and initialize a new module. This function should be used only
 * by #GnomeScanModuleManager.
 * 
 * Returns: a new #GnomeScanModule
 **/
GnomeScanModule* gnome_scan_module_construct (GType object_type, const char* filename) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanModule * self;
	g_return_val_if_fail (filename != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "filename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, filename);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanModule* gnome_scan_module_new (const char* filename) {
	return gnome_scan_module_construct (GNOME_SCAN_TYPE_MODULE, filename);
}


const char* gnome_scan_module_get_filename (GnomeScanModule* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_filename;
}


void gnome_scan_module_set_filename (GnomeScanModule* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_filename = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_filename = (g_free (self->priv->_filename), NULL), _tmp2);
	g_object_notify ((GObject *) self, "filename");
}


static void gnome_scan_module_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanModule * self;
	gpointer boxed;
	self = GNOME_SCAN_MODULE (object);
	switch (property_id) {
		case GNOME_SCAN_MODULE_FILENAME:
		g_value_set_string (value, gnome_scan_module_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_module_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanModule * self;
	self = GNOME_SCAN_MODULE (object);
	switch (property_id) {
		case GNOME_SCAN_MODULE_FILENAME:
		gnome_scan_module_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_module_class_init (GnomeScanModuleClass * klass) {
	gnome_scan_module_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanModulePrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_module_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_module_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_module_finalize;
	G_TYPE_MODULE_CLASS (klass)->load = gnome_scan_module_real_load;
	G_TYPE_MODULE_CLASS (klass)->unload = gnome_scan_module_real_unload;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_MODULE_FILENAME, g_param_spec_string ("filename", "Filename", "Library filename for use with GModule", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void gnome_scan_module_instance_init (GnomeScanModule * self) {
	self->priv = GNOME_SCAN_MODULE_GET_PRIVATE (self);
}


static void gnome_scan_module_finalize (GObject* obj) {
	GnomeScanModule * self;
	self = GNOME_SCAN_MODULE (obj);
	self->priv->_filename = (g_free (self->priv->_filename), NULL);
	(self->priv->library == NULL) ? NULL : (self->priv->library = (g_module_close (self->priv->library), NULL));
	G_OBJECT_CLASS (gnome_scan_module_parent_class)->finalize (obj);
}


GType gnome_scan_module_get_type (void) {
	static GType gnome_scan_module_type_id = 0;
	if (gnome_scan_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanModule), 0, (GInstanceInitFunc) gnome_scan_module_instance_init, NULL };
		gnome_scan_module_type_id = g_type_register_static (G_TYPE_TYPE_MODULE, "GnomeScanModule", &g_define_type_info, 0);
	}
	return gnome_scan_module_type_id;
}




