/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_NODE_H__
#define __GNOME_SCAN_NODE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gegl.h>
#include <gnome-scan-common.h>
#include <gnome-scan-option.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_NODE (gnome_scan_node_get_type ())
#define GNOME_SCAN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNode))
#define GNOME_SCAN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))
#define GNOME_SCAN_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))

typedef struct _GnomeScanNode GnomeScanNode;
typedef struct _GnomeScanNodeClass GnomeScanNodeClass;
typedef struct _GnomeScanNodePrivate GnomeScanNodePrivate;

struct _GnomeScanNode {
	GObject parent_instance;
	GnomeScanNodePrivate * priv;
};

struct _GnomeScanNodeClass {
	GObjectClass parent_class;
	void (*start_scan) (GnomeScanNode* self);
	gboolean (*start_image) (GnomeScanNode* self);
	void (*end_image) (GnomeScanNode* self);
	void (*end_scan) (GnomeScanNode* self);
};


void gnome_scan_node_start_scan (GnomeScanNode* self);
gboolean gnome_scan_node_start_image (GnomeScanNode* self);
void gnome_scan_node_end_image (GnomeScanNode* self);
void gnome_scan_node_end_scan (GnomeScanNode* self);
void gnome_scan_node_update_status (GnomeScanNode* self, GnomeScanStatus status, const char* message);
void gnome_scan_node_install_option (GnomeScanNode* self, GnomeScanOption* option);
void gnome_scan_node_append_node (GnomeScanNode* self, GeglNode* node);
void gnome_scan_node_remove_node (GnomeScanNode* self, GeglNode* node);
GnomeScanStatus gnome_scan_node_get_status (GnomeScanNode* self);
void gnome_scan_node_set_status (GnomeScanNode* self, GnomeScanStatus value);
const char* gnome_scan_node_get_message (GnomeScanNode* self);
void gnome_scan_node_set_message (GnomeScanNode* self, const char* value);
GSList* gnome_scan_node_get_options (GnomeScanNode* self);
GSList* gnome_scan_node_get_nodes (GnomeScanNode* self);
GType gnome_scan_node_get_type (void);


G_END_DECLS

#endif
