/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-option-box.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gnome-scan-option-manager.h>
#include <gnome-scan-option-widget.h>




struct _GnomeScanOptionBoxPrivate {
	char* _label;
	gboolean _expand;
	GtkTable* table;
	gint child_count;
	gint child_visible_count;
	gint child_expanding_count;
	GHashTable* children;
	GHashTable* labels;
};

#define GNOME_SCAN_OPTION_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBoxPrivate))
enum  {
	GNOME_SCAN_OPTION_BOX_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_BOX_LABEL,
	GNOME_SCAN_OPTION_BOX_EXPAND
};
static void _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_hide (GnomeScanOptionWidget* _sender, gpointer self);
static void _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_show (GnomeScanOptionWidget* _sender, gpointer self);
static void gnome_scan_option_box_on_option_widget_visibility_changed (GnomeScanOptionBox* self, GnomeScanOptionWidget* widget);
static GObject * gnome_scan_option_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_option_box_parent_class = NULL;
static void gnome_scan_option_box_finalize (GObject* obj);



GnomeScanOptionBox* gnome_scan_option_box_construct (GType object_type, const char* label) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionBox * self;
	g_return_val_if_fail (label != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "label";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, label);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionBox* gnome_scan_option_box_new (const char* label) {
	return gnome_scan_option_box_construct (GNOME_SCAN_TYPE_OPTION_BOX, label);
}


static void _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_hide (GnomeScanOptionWidget* _sender, gpointer self) {
	gnome_scan_option_box_on_option_widget_visibility_changed (self, _sender);
}


static void _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_show (GnomeScanOptionWidget* _sender, gpointer self) {
	gnome_scan_option_box_on_option_widget_visibility_changed (self, _sender);
}


void gnome_scan_option_box_pack_option (GnomeScanOptionBox* self, GnomeScanOption* option) {
	GType wtype;
	GnomeScanOptionWidget* widget;
	GtkAttachOptions opts;
	GnomeScanOptionWidget* _tmp5;
	GnomeScanOption* _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	wtype = gnome_scan_option_manager_get_widget_type_for (gnome_scan_option_manager, option);
	if (!g_type_is_a (wtype, GTK_TYPE_WIDGET)) {
		g_warning ("gnome-scan-option-box.vala:63: No widget for option %s", gnome_scan_option_get_name (option));
		return;
	}
	widget = GNOME_SCAN_OPTION_WIDGET (g_object_ref_sink (gtk_widget_new (wtype, "option", option, NULL)));
	g_signal_connect_object ((GtkWidget*) widget, "hide", (GCallback) _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_hide, self, 0);
	g_signal_connect_object ((GtkWidget*) widget, "show", (GCallback) _gnome_scan_option_box_on_option_widget_visibility_changed_gtk_widget_show, self, 0);
	self->priv->child_count++;
	/* compute attach option*/
	opts = GTK_FILL;
	if (gnome_scan_option_widget_get_expand (widget)) {
		opts = opts | (GTK_EXPAND);
	}
	/* insert directly the widget, spanning two columns*/
	if (gnome_scan_option_widget_get_no_label (widget)) {
		gtk_table_attach (self->priv->table, (GtkWidget*) widget, (guint) 0, (guint) 2, (guint) (self->priv->child_count - 1), (guint) self->priv->child_count, opts, opts, (guint) 0, (guint) 0);
	} else {
		char* _tmp0;
		GtkLabel* _tmp1;
		GtkLabel* label;
		GtkLabel* _tmp3;
		GnomeScanOptionWidget* _tmp2;
		/* translator: %s is the name of an option and is
		 prepended before the option widget. Accord ":" to
		 locale typographic rules.*/
		_tmp0 = NULL;
		_tmp1 = NULL;
		label = (_tmp1 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp0 = g_strdup_printf (_ ("%s:"), gnome_scan_option_get_title (option)))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
		gtk_widget_set_tooltip_text ((GtkWidget*) label, gnome_scan_option_get_desc (option));
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_widget_set_no_show_all ((GtkWidget*) label, gtk_widget_get_no_show_all ((GtkWidget*) widget));
		_tmp3 = NULL;
		_tmp2 = NULL;
		g_hash_table_insert (self->priv->labels, (_tmp2 = widget, (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (_tmp3 = label, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3)));
		gtk_table_attach (self->priv->table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) (self->priv->child_count - 1), (guint) self->priv->child_count, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		gtk_table_attach (self->priv->table, (GtkWidget*) widget, (guint) 1, (guint) 2, (guint) (self->priv->child_count - 1), (guint) self->priv->child_count, GTK_FILL | GTK_EXPAND, opts, (guint) 0, (guint) 0);
		(label == NULL) ? NULL : (label = (g_object_unref (label), NULL));
	}
	_tmp5 = NULL;
	_tmp4 = NULL;
	g_hash_table_insert (self->priv->children, (_tmp4 = option, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)), (_tmp5 = widget, (_tmp5 == NULL) ? NULL : g_object_ref (_tmp5)));
	/* consider option visible to hide it after attach*/
	if (!gnome_scan_option_get_active (option)) {
		self->priv->child_visible_count++;
	}
	gnome_scan_option_box_on_option_widget_visibility_changed (self, widget);
	(widget == NULL) ? NULL : (widget = (g_object_unref (widget), NULL));
}


/* return whether the box is empty*/
gboolean gnome_scan_option_box_unpack_option (GnomeScanOptionBox* self, GnomeScanOption* option) {
	GnomeScanOptionWidget* widget;
	GtkLabel* label;
	GList* _tmp1;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (option != NULL, FALSE);
	widget = (GnomeScanOptionWidget*) g_hash_table_lookup (self->priv->children, option);
	if (widget == NULL) {
		return FALSE;
	}
	/* hide widget*/
	gtk_widget_set_no_show_all ((GtkWidget*) widget, TRUE);
	gtk_widget_hide ((GtkWidget*) widget);
	/* destroy label*/
	label = (GtkLabel*) g_hash_table_lookup (self->priv->labels, widget);
	if (label != NULL) {
		gtk_container_remove ((GtkContainer*) self->priv->table, (GtkWidget*) label);
		g_hash_table_remove (self->priv->labels, widget);
	}
	/* destroy widget*/
	gtk_container_remove ((GtkContainer*) self->priv->table, (GtkWidget*) widget);
	g_hash_table_remove (self->priv->children, option);
	_tmp1 = NULL;
	return (_tmp2 = g_list_length (_tmp1 = gtk_container_get_children ((GtkContainer*) self->priv->table)) == 0, (_tmp1 == NULL) ? NULL : (_tmp1 = (g_list_free (_tmp1), NULL)), _tmp2);
}


static void gnome_scan_option_box_on_option_widget_visibility_changed (GnomeScanOptionBox* self, GnomeScanOptionWidget* widget) {
	GtkLabel* _tmp0;
	GtkLabel* label;
	gint _tmp5;
	gboolean _tmp6;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	/* ignore no_show_all widget.*/
	if (gtk_widget_get_no_show_all ((GtkWidget*) widget)) {
		return;
	}
	_tmp0 = NULL;
	label = (_tmp0 = (GtkLabel*) g_hash_table_lookup (self->priv->labels, widget), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	if (label != NULL) {
		gboolean _tmp1;
		gtk_widget_set_no_show_all ((GtkWidget*) label, gtk_widget_get_no_show_all ((GtkWidget*) widget));
		if ((g_object_get ((GtkWidget*) widget, "visible", &_tmp1, NULL), _tmp1)) {
			gtk_widget_show ((GtkWidget*) label);
		} else {
			gtk_widget_hide ((GtkWidget*) label);
		}
	}
	if (gnome_scan_option_widget_get_expand (widget)) {
		gint _tmp2;
		gboolean _tmp3;
		GtkContainer* _tmp4;
		GtkContainer* parent;
		_tmp2 = 0;
		if ((g_object_get ((GtkWidget*) widget, "visible", &_tmp3, NULL), _tmp3)) {
			_tmp2 = +1;
		} else {
			_tmp2 = -1;
		}
		self->priv->child_expanding_count = self->priv->child_expanding_count + (_tmp2);
		_tmp4 = NULL;
		parent = (_tmp4 = GTK_CONTAINER (gtk_widget_get_parent ((GtkWidget*) self)), (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4));
		gnome_scan_option_box_set_expand (self, self->priv->child_expanding_count > 0);
		gtk_container_child_set (parent, (GtkWidget*) self, "expand", self->priv->_expand, NULL);
		(parent == NULL) ? NULL : (parent = (g_object_unref (parent), NULL));
	}
	_tmp5 = 0;
	if ((g_object_get ((GtkWidget*) widget, "visible", &_tmp6, NULL), _tmp6)) {
		_tmp5 = +1;
	} else {
		_tmp5 = -1;
	}
	self->priv->child_visible_count = self->priv->child_visible_count + (_tmp5);
	if (self->priv->child_visible_count == 0) {
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_set_no_show_all ((GtkWidget*) self, FALSE);
		gtk_widget_show_all ((GtkWidget*) self);
	}
	(label == NULL) ? NULL : (label = (g_object_unref (label), NULL));
}


const char* gnome_scan_option_box_get_label (GnomeScanOptionBox* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_label;
}


void gnome_scan_option_box_set_label (GnomeScanOptionBox* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_label = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_label = (g_free (self->priv->_label), NULL), _tmp2);
	g_object_notify ((GObject *) self, "label");
}


gboolean gnome_scan_option_box_get_expand (GnomeScanOptionBox* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_expand;
}


void gnome_scan_option_box_set_expand (GnomeScanOptionBox* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_expand = value;
	g_object_notify ((GObject *) self, "expand");
}


static GObject * gnome_scan_option_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionBoxClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionBox * self;
	klass = GNOME_SCAN_OPTION_BOX_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_BOX));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_BOX (obj);
	{
		GtkLabel* label;
		char* _tmp0;
		GtkAlignment* alignment;
		GtkTable* _tmp1;
		GHashTable* _tmp2;
		GHashTable* _tmp3;
		gtk_box_set_spacing ((GtkBox*) self, 6);
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		label = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL));
		_tmp0 = NULL;
		gtk_label_set_markup (label, _tmp0 = g_strdup_printf ("<b>%s</b>", self->priv->_label));
		_tmp0 = (g_free (_tmp0), NULL);
		gtk_misc_set_alignment ((GtkMisc*) label, (float) 0, (float) 0.5);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
		alignment = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0, (float) 0, (float) 1, (float) 1));
		gtk_alignment_set_padding (alignment, (guint) 0, (guint) 0, (guint) 24, (guint) 0);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) alignment, TRUE, TRUE, (guint) 0);
		_tmp1 = NULL;
		self->priv->table = (_tmp1 = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 0, (guint) 2, FALSE)), (self->priv->table == NULL) ? NULL : (self->priv->table = (g_object_unref (self->priv->table), NULL)), _tmp1);
		gtk_container_add ((GtkContainer*) alignment, (GtkWidget*) self->priv->table);
		_tmp2 = NULL;
		self->priv->children = (_tmp2 = g_hash_table_new (g_direct_hash, g_direct_equal), (self->priv->children == NULL) ? NULL : (self->priv->children = (g_hash_table_unref (self->priv->children), NULL)), _tmp2);
		_tmp3 = NULL;
		self->priv->labels = (_tmp3 = g_hash_table_new (g_direct_hash, g_direct_equal), (self->priv->labels == NULL) ? NULL : (self->priv->labels = (g_hash_table_unref (self->priv->labels), NULL)), _tmp3);
		(label == NULL) ? NULL : (label = (g_object_unref (label), NULL));
		(alignment == NULL) ? NULL : (alignment = (g_object_unref (alignment), NULL));
	}
	return obj;
}


static void gnome_scan_option_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBox * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_BOX (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOX_LABEL:
		g_value_set_string (value, gnome_scan_option_box_get_label (self));
		break;
		case GNOME_SCAN_OPTION_BOX_EXPAND:
		g_value_set_boolean (value, gnome_scan_option_box_get_expand (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionBox * self;
	self = GNOME_SCAN_OPTION_BOX (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_BOX_LABEL:
		gnome_scan_option_box_set_label (self, g_value_get_string (value));
		break;
		case GNOME_SCAN_OPTION_BOX_EXPAND:
		gnome_scan_option_box_set_expand (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_box_class_init (GnomeScanOptionBoxClass * klass) {
	gnome_scan_option_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_BOX_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_BOX_EXPAND, g_param_spec_boolean ("expand", "expand", "expand", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_box_instance_init (GnomeScanOptionBox * self) {
	self->priv = GNOME_SCAN_OPTION_BOX_GET_PRIVATE (self);
	self->priv->_expand = FALSE;
	self->priv->child_count = 0;
	self->priv->child_visible_count = 0;
	self->priv->child_expanding_count = 0;
}


static void gnome_scan_option_box_finalize (GObject* obj) {
	GnomeScanOptionBox * self;
	self = GNOME_SCAN_OPTION_BOX (obj);
	self->priv->_label = (g_free (self->priv->_label), NULL);
	(self->priv->table == NULL) ? NULL : (self->priv->table = (g_object_unref (self->priv->table), NULL));
	(self->priv->children == NULL) ? NULL : (self->priv->children = (g_hash_table_unref (self->priv->children), NULL));
	(self->priv->labels == NULL) ? NULL : (self->priv->labels = (g_hash_table_unref (self->priv->labels), NULL));
	G_OBJECT_CLASS (gnome_scan_option_box_parent_class)->finalize (obj);
}


GType gnome_scan_option_box_get_type (void) {
	static GType gnome_scan_option_box_type_id = 0;
	if (gnome_scan_option_box_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionBox), 0, (GInstanceInitFunc) gnome_scan_option_box_instance_init, NULL };
		gnome_scan_option_box_type_id = g_type_register_static (GTK_TYPE_VBOX, "GnomeScanOptionBox", &g_define_type_info, 0);
	}
	return gnome_scan_option_box_type_id;
}




