/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_OPTION_MANAGER_H__
#define __GNOME_SCAN_OPTION_MANAGER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-scan-option.h>
#include <gnome-scan-common.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_OPTION_MANAGER (gnome_scan_option_manager_get_type ())
#define GNOME_SCAN_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManager))
#define GNOME_SCAN_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))
#define GNOME_SCAN_IS_OPTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_IS_OPTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_MANAGER))
#define GNOME_SCAN_OPTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_MANAGER, GnomeScanOptionManagerClass))

typedef struct _GnomeScanOptionManager GnomeScanOptionManager;
typedef struct _GnomeScanOptionManagerClass GnomeScanOptionManagerClass;
typedef struct _GnomeScanOptionManagerPrivate GnomeScanOptionManagerPrivate;

struct _GnomeScanOptionManager {
	GObject parent_instance;
	GnomeScanOptionManagerPrivate * priv;
};

struct _GnomeScanOptionManagerClass {
	GObjectClass parent_class;
};


extern GnomeScanOptionManager* gnome_scan_option_manager;
void gnome_scan_option_manager_register_option (GnomeScanOptionManager* self, GnomeScanOption* option);
void gnome_scan_option_manager_register_rule_by_name (GnomeScanOptionManager* self, const char* option_name, GType handler_type);
void gnome_scan_option_manager_register_rule_by_type (GnomeScanOptionManager* self, GType option_type, GType handler_type);
GType gnome_scan_option_manager_get_widget_type_for (GnomeScanOptionManager* self, GnomeScanOption* option);
void gnome_scan_option_manager_register_default_value (GnomeScanOptionManager* self, const char* option_name, const GValue* value);
void gnome_scan_option_manager_register_constraint_range (GnomeScanOptionManager* self, const char* option_name, const GnomeScanRange* range);
void gnome_scan_option_manager_register_constraint_enum (GnomeScanOptionManager* self, const char* option_name, GSList* values);
GnomeScanOptionManager* gnome_scan_option_manager_construct (GType object_type);
GnomeScanOptionManager* gnome_scan_option_manager_new (void);
GType gnome_scan_option_manager_get_type (void);


G_END_DECLS

#endif
