/*
 * Generated by gdbus-codegen 2.39.2. DO NOT EDIT.
 *
 * The license of this code is the same as for the source it was derived from.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "geoclue.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  gboolean use_gvariant;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.GeoClue2.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GeoclueManager
 * @title: GeoclueManager
 * @short_description: Generated C code for the org.freedesktop.GeoClue2.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.GeoClue2.Manager ---- */

static const _ExtendedGDBusArgInfo _geoclue_manager_method_info_get_client_OUT_ARG_client =
{
  {
    -1,
    (gchar *) "client",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _geoclue_manager_method_info_get_client_OUT_ARG_pointers[] =
{
  &_geoclue_manager_method_info_get_client_OUT_ARG_client,
  NULL
};

static const _ExtendedGDBusMethodInfo _geoclue_manager_method_info_get_client =
{
  {
    -1,
    (gchar *) "GetClient",
    NULL,
    (GDBusArgInfo **) &_geoclue_manager_method_info_get_client_OUT_ARG_pointers,
    NULL
  },
  "handle-get-client",
  FALSE
};

static const _ExtendedGDBusMethodInfo _geoclue_manager_method_info_add_agent =
{
  {
    -1,
    (gchar *) "AddAgent",
    NULL,
    NULL,
    NULL
  },
  "handle-add-agent",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _geoclue_manager_method_info_pointers[] =
{
  &_geoclue_manager_method_info_get_client,
  &_geoclue_manager_method_info_add_agent,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _geoclue_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.GeoClue2.Manager",
    (GDBusMethodInfo **) &_geoclue_manager_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "manager",
};


/**
 * geoclue_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
geoclue_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_geoclue_manager_interface_info.parent_struct;
}

/**
 * geoclue_manager_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GeoclueManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
geoclue_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * GeoclueManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
 */

/**
 * GeoclueManagerIface:
 * @parent_iface: The parent interface.
 * @handle_add_agent: Handler for the #GeoclueManager::handle-add-agent signal.
 * @handle_get_client: Handler for the #GeoclueManager::handle-get-client signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
 */

typedef GeoclueManagerIface GeoclueManagerInterface;
G_DEFINE_INTERFACE (GeoclueManager, geoclue_manager, G_TYPE_OBJECT);

static void
geoclue_manager_default_init (GeoclueManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GeoclueManager::handle-get-client:
   * @object: A #GeoclueManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call geoclue_manager_complete_get_client() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-client",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GeoclueManagerIface, handle_get_client),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GeoclueManager::handle-add-agent:
   * @object: A #GeoclueManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call geoclue_manager_complete_add_agent() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-agent",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GeoclueManagerIface, handle_add_agent),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * geoclue_manager_call_get_client:
 * @proxy: A #GeoclueManagerProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_manager_call_get_client_finish() to get the result of the operation.
 *
 * See geoclue_manager_call_get_client_sync() for the synchronous, blocking version of this method.
 */
void
geoclue_manager_call_get_client (
    GeoclueManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetClient",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * geoclue_manager_call_get_client_finish:
 * @proxy: A #GeoclueManagerProxy.
 * @out_client: (out): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_manager_call_get_client().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with geoclue_manager_call_get_client().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
geoclue_manager_call_get_client_finish (
    GeoclueManager *proxy,
    gchar **out_client,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * geoclue_manager_call_get_client_sync:
 * @proxy: A #GeoclueManagerProxy.
 * @out_client: (out): Return location for return parameter or %NULL to ignore.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See geoclue_manager_call_get_client() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
geoclue_manager_call_get_client_sync (
    GeoclueManager *proxy,
    gchar **out_client,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetClient",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * geoclue_manager_call_add_agent:
 * @proxy: A #GeoclueManagerProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_manager_call_add_agent_finish() to get the result of the operation.
 *
 * See geoclue_manager_call_add_agent_sync() for the synchronous, blocking version of this method.
 */
void
geoclue_manager_call_add_agent (
    GeoclueManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddAgent",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * geoclue_manager_call_add_agent_finish:
 * @proxy: A #GeoclueManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_manager_call_add_agent().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with geoclue_manager_call_add_agent().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
geoclue_manager_call_add_agent_finish (
    GeoclueManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * geoclue_manager_call_add_agent_sync:
 * @proxy: A #GeoclueManagerProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See geoclue_manager_call_add_agent() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
geoclue_manager_call_add_agent_sync (
    GeoclueManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddAgent",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * geoclue_manager_complete_get_client:
 * @object: A #GeoclueManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @client: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.GetClient">GetClient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
geoclue_manager_complete_get_client (
    GeoclueManager *object,
    GDBusMethodInvocation *invocation,
    const gchar *client)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   client));
}

/**
 * geoclue_manager_complete_add_agent:
 * @object: A #GeoclueManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Manager.AddAgent">AddAgent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
geoclue_manager_complete_add_agent (
    GeoclueManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GeoclueManagerProxy:
 *
 * The #GeoclueManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GeoclueManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GeoclueManagerProxy.
 */

struct _GeoclueManagerProxyPrivate
{
  GData *qdata;
};

static void geoclue_manager_proxy_iface_init (GeoclueManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GeoclueManagerProxy, geoclue_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GeoclueManagerProxy)
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_MANAGER, geoclue_manager_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (GeoclueManagerProxy, geoclue_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_MANAGER, geoclue_manager_proxy_iface_init));

#endif
static void
geoclue_manager_proxy_finalize (GObject *object)
{
  GeoclueManagerProxy *proxy = GEOCLUE_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (geoclue_manager_proxy_parent_class)->finalize (object);
}

static void
geoclue_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
geoclue_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
geoclue_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_geoclue_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GEOCLUE_TYPE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GEOCLUE_TYPE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
geoclue_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GeoclueManagerProxy *proxy = GEOCLUE_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
geoclue_manager_proxy_init (GeoclueManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = geoclue_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GEOCLUE_TYPE_MANAGER_PROXY, GeoclueManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), geoclue_manager_interface_info ());
}

static void
geoclue_manager_proxy_class_init (GeoclueManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = geoclue_manager_proxy_finalize;
  gobject_class->get_property = geoclue_manager_proxy_get_property;
  gobject_class->set_property = geoclue_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = geoclue_manager_proxy_g_signal;
  proxy_class->g_properties_changed = geoclue_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GeoclueManagerProxyPrivate));
#endif
}

static void
geoclue_manager_proxy_iface_init (GeoclueManagerIface *iface)
{
}

/**
 * geoclue_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_manager_proxy_new_finish() to get the result of the operation.
 *
 * See geoclue_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
geoclue_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GEOCLUE_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
}

/**
 * geoclue_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with geoclue_manager_proxy_new().
 *
 * Returns: (transfer full) (type GeoclueManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueManager *
geoclue_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GEOCLUE_MANAGER (ret);
  else
    return NULL;
}

/**
 * geoclue_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See geoclue_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GeoclueManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueManager *
geoclue_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GEOCLUE_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
  if (ret != NULL)
    return GEOCLUE_MANAGER (ret);
  else
    return NULL;
}


/**
 * geoclue_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like geoclue_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See geoclue_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
geoclue_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GEOCLUE_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
}

/**
 * geoclue_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with geoclue_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GeoclueManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueManager *
geoclue_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GEOCLUE_MANAGER (ret);
  else
    return NULL;
}

/**
 * geoclue_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like geoclue_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See geoclue_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GeoclueManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueManager *
geoclue_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GEOCLUE_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Manager", NULL);
  if (ret != NULL)
    return GEOCLUE_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GeoclueManagerSkeleton:
 *
 * The #GeoclueManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GeoclueManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GeoclueManagerSkeleton.
 */

struct _GeoclueManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_geoclue_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GeoclueManagerSkeleton *skeleton = GEOCLUE_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GEOCLUE_TYPE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GEOCLUE_TYPE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_geoclue_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GeoclueManagerSkeleton *skeleton = GEOCLUE_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_geoclue_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GeoclueManagerSkeleton *skeleton = GEOCLUE_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _geoclue_manager_skeleton_vtable =
{
  _geoclue_manager_skeleton_handle_method_call,
  _geoclue_manager_skeleton_handle_get_property,
  _geoclue_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
geoclue_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return geoclue_manager_interface_info ();
}

static GDBusInterfaceVTable *
geoclue_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_geoclue_manager_skeleton_vtable;
}

static GVariant *
geoclue_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GeoclueManagerSkeleton *skeleton = GEOCLUE_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_geoclue_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _geoclue_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _geoclue_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _geoclue_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.GeoClue2.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
geoclue_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void geoclue_manager_skeleton_iface_init (GeoclueManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GeoclueManagerSkeleton, geoclue_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GeoclueManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_MANAGER, geoclue_manager_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (GeoclueManagerSkeleton, geoclue_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_MANAGER, geoclue_manager_skeleton_iface_init));

#endif
static void
geoclue_manager_skeleton_finalize (GObject *object)
{
  GeoclueManagerSkeleton *skeleton = GEOCLUE_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (geoclue_manager_skeleton_parent_class)->finalize (object);
}

static void
geoclue_manager_skeleton_init (GeoclueManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = geoclue_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GEOCLUE_TYPE_MANAGER_SKELETON, GeoclueManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
geoclue_manager_skeleton_class_init (GeoclueManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = geoclue_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = geoclue_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = geoclue_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = geoclue_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = geoclue_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GeoclueManagerSkeletonPrivate));
#endif
}

static void
geoclue_manager_skeleton_iface_init (GeoclueManagerIface *iface)
{
}

/**
 * geoclue_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Manager.top_of_page">org.freedesktop.GeoClue2.Manager</link>.
 *
 * Returns: (transfer full) (type GeoclueManagerSkeleton): The skeleton object.
 */
GeoclueManager *
geoclue_manager_skeleton_new (void)
{
  return GEOCLUE_MANAGER (g_object_new (GEOCLUE_TYPE_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.GeoClue2.Client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GeoclueClient
 * @title: GeoclueClient
 * @short_description: Generated C code for the org.freedesktop.GeoClue2.Client D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.GeoClue2.Client ---- */

static const _ExtendedGDBusMethodInfo _geoclue_client_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _geoclue_client_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _geoclue_client_method_info_pointers[] =
{
  &_geoclue_client_method_info_start,
  &_geoclue_client_method_info_stop,
  NULL
};

static const _ExtendedGDBusArgInfo _geoclue_client_signal_info_location_updated_ARG_old =
{
  {
    -1,
    (gchar *) "old",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _geoclue_client_signal_info_location_updated_ARG_new =
{
  {
    -1,
    (gchar *) "new",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _geoclue_client_signal_info_location_updated_ARG_pointers[] =
{
  &_geoclue_client_signal_info_location_updated_ARG_old,
  &_geoclue_client_signal_info_location_updated_ARG_new,
  NULL
};

static const _ExtendedGDBusSignalInfo _geoclue_client_signal_info_location_updated =
{
  {
    -1,
    (gchar *) "LocationUpdated",
    (GDBusArgInfo **) &_geoclue_client_signal_info_location_updated_ARG_pointers,
    NULL
  },
  "location-updated"
};

static const _ExtendedGDBusSignalInfo * const _geoclue_client_signal_info_pointers[] =
{
  &_geoclue_client_signal_info_location_updated,
  NULL
};

static const _ExtendedGDBusPropertyInfo _geoclue_client_property_info_location =
{
  {
    -1,
    (gchar *) "Location",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "location",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _geoclue_client_property_info_distance_threshold =
{
  {
    -1,
    (gchar *) "DistanceThreshold",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "distance-threshold",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _geoclue_client_property_info_title =
{
  {
    -1,
    (gchar *) "Title",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "title",
  FALSE
};

static const _ExtendedGDBusPropertyInfo * const _geoclue_client_property_info_pointers[] =
{
  &_geoclue_client_property_info_location,
  &_geoclue_client_property_info_distance_threshold,
  &_geoclue_client_property_info_title,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _geoclue_client_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.GeoClue2.Client",
    (GDBusMethodInfo **) &_geoclue_client_method_info_pointers,
    (GDBusSignalInfo **) &_geoclue_client_signal_info_pointers,
    (GDBusPropertyInfo **) &_geoclue_client_property_info_pointers,
    NULL
  },
  "client",
};


/**
 * geoclue_client_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
geoclue_client_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_geoclue_client_interface_info.parent_struct;
}

/**
 * geoclue_client_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GeoclueClient interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
geoclue_client_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "location");
  g_object_class_override_property (klass, property_id_begin++, "distance-threshold");
  g_object_class_override_property (klass, property_id_begin++, "title");
  return property_id_begin - 1;
}



/**
 * GeoclueClient:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>.
 */

/**
 * GeoclueClientIface:
 * @parent_iface: The parent interface.
 * @handle_start: Handler for the #GeoclueClient::handle-start signal.
 * @handle_stop: Handler for the #GeoclueClient::handle-stop signal.
 * @get_distance_threshold: Getter for the #GeoclueClient:distance-threshold property.
 * @get_location: Getter for the #GeoclueClient:location property.
 * @get_title: Getter for the #GeoclueClient:title property.
 * @location_updated: Handler for the #GeoclueClient::location-updated signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>.
 */

typedef GeoclueClientIface GeoclueClientInterface;
G_DEFINE_INTERFACE (GeoclueClient, geoclue_client, G_TYPE_OBJECT);

static void
geoclue_client_default_init (GeoclueClientIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GeoclueClient::handle-start:
   * @object: A #GeoclueClient.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call geoclue_client_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GeoclueClientIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GeoclueClient::handle-stop:
   * @object: A #GeoclueClient.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call geoclue_client_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GeoclueClientIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GeoclueClient::location-updated:
   * @object: A #GeoclueClient.
   * @arg_old: Argument.
   * @arg_new: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-GeoClue2-Client.LocationUpdated">"LocationUpdated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("location-updated",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GeoclueClientIface, location_updated),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * GeoclueClient:location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("location", "Location", "Location", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GeoclueClient:distance-threshold:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("distance-threshold", "DistanceThreshold", "DistanceThreshold", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GeoclueClient:title:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Title">"Title"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("title", "Title", "Title", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * geoclue_client_get_location: (skip)
 * @object: A #GeoclueClient.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use geoclue_client_dup_location() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
geoclue_client_get_location (GeoclueClient *object)
{
  return GEOCLUE_CLIENT_GET_IFACE (object)->get_location (object);
}

/**
 * geoclue_client_dup_location: (skip)
 * @object: A #GeoclueClient.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
geoclue_client_dup_location (GeoclueClient *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "location", &value, NULL);
  return value;
}

/**
 * geoclue_client_set_location: (skip)
 * @object: A #GeoclueClient.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Location">"Location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
geoclue_client_set_location (GeoclueClient *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "location", value, NULL);
}

/**
 * geoclue_client_get_distance_threshold: (skip)
 * @object: A #GeoclueClient.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
geoclue_client_get_distance_threshold (GeoclueClient *object)
{
  return GEOCLUE_CLIENT_GET_IFACE (object)->get_distance_threshold (object);
}

/**
 * geoclue_client_set_distance_threshold: (skip)
 * @object: A #GeoclueClient.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.DistanceThreshold">"DistanceThreshold"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
geoclue_client_set_distance_threshold (GeoclueClient *object, guint value)
{
  g_object_set (G_OBJECT (object), "distance-threshold", value, NULL);
}

/**
 * geoclue_client_get_title: (skip)
 * @object: A #GeoclueClient.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Title">"Title"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use geoclue_client_dup_title() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
geoclue_client_get_title (GeoclueClient *object)
{
  return GEOCLUE_CLIENT_GET_IFACE (object)->get_title (object);
}

/**
 * geoclue_client_dup_title: (skip)
 * @object: A #GeoclueClient.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Title">"Title"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
geoclue_client_dup_title (GeoclueClient *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "title", &value, NULL);
  return value;
}

/**
 * geoclue_client_set_title: (skip)
 * @object: A #GeoclueClient.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Client.Title">"Title"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
geoclue_client_set_title (GeoclueClient *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "title", value, NULL);
}

/**
 * geoclue_client_emit_location_updated:
 * @object: A #GeoclueClient.
 * @arg_old: Argument to pass with the signal.
 * @arg_new: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-GeoClue2-Client.LocationUpdated">"LocationUpdated"</link> D-Bus signal.
 */
void
geoclue_client_emit_location_updated (
    GeoclueClient *object,
    const gchar *arg_old,
    const gchar *arg_new)
{
  g_signal_emit_by_name (object, "location-updated", arg_old, arg_new);
}

/**
 * geoclue_client_call_start:
 * @proxy: A #GeoclueClientProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_client_call_start_finish() to get the result of the operation.
 *
 * See geoclue_client_call_start_sync() for the synchronous, blocking version of this method.
 */
void
geoclue_client_call_start (
    GeoclueClient *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * geoclue_client_call_start_finish:
 * @proxy: A #GeoclueClientProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_client_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with geoclue_client_call_start().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
geoclue_client_call_start_finish (
    GeoclueClient *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * geoclue_client_call_start_sync:
 * @proxy: A #GeoclueClientProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See geoclue_client_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
geoclue_client_call_start_sync (
    GeoclueClient *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * geoclue_client_call_stop:
 * @proxy: A #GeoclueClientProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_client_call_stop_finish() to get the result of the operation.
 *
 * See geoclue_client_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
geoclue_client_call_stop (
    GeoclueClient *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * geoclue_client_call_stop_finish:
 * @proxy: A #GeoclueClientProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_client_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with geoclue_client_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
geoclue_client_call_stop_finish (
    GeoclueClient *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * geoclue_client_call_stop_sync:
 * @proxy: A #GeoclueClientProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See geoclue_client_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
geoclue_client_call_stop_sync (
    GeoclueClient *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * geoclue_client_complete_start:
 * @object: A #GeoclueClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
geoclue_client_complete_start (
    GeoclueClient *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * geoclue_client_complete_stop:
 * @object: A #GeoclueClient.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-GeoClue2-Client.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
geoclue_client_complete_stop (
    GeoclueClient *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GeoclueClientProxy:
 *
 * The #GeoclueClientProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GeoclueClientProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GeoclueClientProxy.
 */

struct _GeoclueClientProxyPrivate
{
  GData *qdata;
};

static void geoclue_client_proxy_iface_init (GeoclueClientIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GeoclueClientProxy, geoclue_client_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GeoclueClientProxy)
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_CLIENT, geoclue_client_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (GeoclueClientProxy, geoclue_client_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_CLIENT, geoclue_client_proxy_iface_init));

#endif
static void
geoclue_client_proxy_finalize (GObject *object)
{
  GeoclueClientProxy *proxy = GEOCLUE_CLIENT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (geoclue_client_proxy_parent_class)->finalize (object);
}

static void
geoclue_client_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = _geoclue_client_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
geoclue_client_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  error = NULL;
  if (!g_dbus_proxy_call_finish (proxy, res, &error))
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.GeoClue2.Client: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
}

static void
geoclue_client_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = _geoclue_client_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.GeoClue2.Client", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) geoclue_client_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
geoclue_client_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_geoclue_client_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GEOCLUE_TYPE_CLIENT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GEOCLUE_TYPE_CLIENT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
geoclue_client_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GeoclueClientProxy *proxy = GEOCLUE_CLIENT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_client_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_client_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
geoclue_client_proxy_get_location (GeoclueClient *object)
{
  GeoclueClientProxy *proxy = GEOCLUE_CLIENT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Location");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
geoclue_client_proxy_get_distance_threshold (GeoclueClient *object)
{
  GeoclueClientProxy *proxy = GEOCLUE_CLIENT_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DistanceThreshold");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
geoclue_client_proxy_get_title (GeoclueClient *object)
{
  GeoclueClientProxy *proxy = GEOCLUE_CLIENT_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Title");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
geoclue_client_proxy_init (GeoclueClientProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = geoclue_client_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GEOCLUE_TYPE_CLIENT_PROXY, GeoclueClientProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), geoclue_client_interface_info ());
}

static void
geoclue_client_proxy_class_init (GeoclueClientProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = geoclue_client_proxy_finalize;
  gobject_class->get_property = geoclue_client_proxy_get_property;
  gobject_class->set_property = geoclue_client_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = geoclue_client_proxy_g_signal;
  proxy_class->g_properties_changed = geoclue_client_proxy_g_properties_changed;

  geoclue_client_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GeoclueClientProxyPrivate));
#endif
}

static void
geoclue_client_proxy_iface_init (GeoclueClientIface *iface)
{
  iface->get_location = geoclue_client_proxy_get_location;
  iface->get_distance_threshold = geoclue_client_proxy_get_distance_threshold;
  iface->get_title = geoclue_client_proxy_get_title;
}

/**
 * geoclue_client_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_client_proxy_new_finish() to get the result of the operation.
 *
 * See geoclue_client_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
geoclue_client_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GEOCLUE_TYPE_CLIENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Client", NULL);
}

/**
 * geoclue_client_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_client_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with geoclue_client_proxy_new().
 *
 * Returns: (transfer full) (type GeoclueClientProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueClient *
geoclue_client_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GEOCLUE_CLIENT (ret);
  else
    return NULL;
}

/**
 * geoclue_client_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See geoclue_client_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GeoclueClientProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueClient *
geoclue_client_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GEOCLUE_TYPE_CLIENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Client", NULL);
  if (ret != NULL)
    return GEOCLUE_CLIENT (ret);
  else
    return NULL;
}


/**
 * geoclue_client_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like geoclue_client_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_client_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See geoclue_client_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
geoclue_client_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GEOCLUE_TYPE_CLIENT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Client", NULL);
}

/**
 * geoclue_client_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_client_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with geoclue_client_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GeoclueClientProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueClient *
geoclue_client_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GEOCLUE_CLIENT (ret);
  else
    return NULL;
}

/**
 * geoclue_client_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like geoclue_client_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See geoclue_client_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GeoclueClientProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueClient *
geoclue_client_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GEOCLUE_TYPE_CLIENT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Client", NULL);
  if (ret != NULL)
    return GEOCLUE_CLIENT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GeoclueClientSkeleton:
 *
 * The #GeoclueClientSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GeoclueClientSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GeoclueClientSkeleton.
 */

struct _GeoclueClientSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_geoclue_client_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GEOCLUE_TYPE_CLIENT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GEOCLUE_TYPE_CLIENT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_geoclue_client_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_client_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_geoclue_client_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_client_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _geoclue_client_skeleton_vtable =
{
  _geoclue_client_skeleton_handle_method_call,
  _geoclue_client_skeleton_handle_get_property,
  _geoclue_client_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
geoclue_client_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return geoclue_client_interface_info ();
}

static GDBusInterfaceVTable *
geoclue_client_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_geoclue_client_skeleton_vtable;
}

static GVariant *
geoclue_client_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_geoclue_client_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _geoclue_client_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _geoclue_client_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _geoclue_client_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.GeoClue2.Client", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _geoclue_client_emit_changed (gpointer user_data);

static void
geoclue_client_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _geoclue_client_emit_changed (skeleton);
}

static void
_geoclue_client_on_signal_location_updated (
    GeoclueClient *object,
    const gchar *arg_old,
    const gchar *arg_new)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(oo)",
                   arg_old,
                   arg_new));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.GeoClue2.Client", "LocationUpdated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void geoclue_client_skeleton_iface_init (GeoclueClientIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GeoclueClientSkeleton, geoclue_client_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GeoclueClientSkeleton)
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_CLIENT, geoclue_client_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (GeoclueClientSkeleton, geoclue_client_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_CLIENT, geoclue_client_skeleton_iface_init));

#endif
static void
geoclue_client_skeleton_finalize (GObject *object)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (geoclue_client_skeleton_parent_class)->finalize (object);
}

static void
geoclue_client_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_geoclue_client_emit_changed (gpointer user_data)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.GeoClue2.Client",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_geoclue_client_schedule_emit_changed (GeoclueClientSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
geoclue_client_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _geoclue_client_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
geoclue_client_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _geoclue_client_schedule_emit_changed (skeleton, _geoclue_client_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
geoclue_client_skeleton_init (GeoclueClientSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = geoclue_client_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GEOCLUE_TYPE_CLIENT_SKELETON, GeoclueClientSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
}

static const gchar *
geoclue_client_skeleton_get_location (GeoclueClient *object)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
geoclue_client_skeleton_get_distance_threshold (GeoclueClient *object)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
geoclue_client_skeleton_get_title (GeoclueClient *object)
{
  GeoclueClientSkeleton *skeleton = GEOCLUE_CLIENT_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
geoclue_client_skeleton_class_init (GeoclueClientSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = geoclue_client_skeleton_finalize;
  gobject_class->get_property = geoclue_client_skeleton_get_property;
  gobject_class->set_property = geoclue_client_skeleton_set_property;
  gobject_class->notify       = geoclue_client_skeleton_notify;


  geoclue_client_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = geoclue_client_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = geoclue_client_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = geoclue_client_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = geoclue_client_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GeoclueClientSkeletonPrivate));
#endif
}

static void
geoclue_client_skeleton_iface_init (GeoclueClientIface *iface)
{
  iface->location_updated = _geoclue_client_on_signal_location_updated;
  iface->get_location = geoclue_client_skeleton_get_location;
  iface->get_distance_threshold = geoclue_client_skeleton_get_distance_threshold;
  iface->get_title = geoclue_client_skeleton_get_title;
}

/**
 * geoclue_client_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Client.top_of_page">org.freedesktop.GeoClue2.Client</link>.
 *
 * Returns: (transfer full) (type GeoclueClientSkeleton): The skeleton object.
 */
GeoclueClient *
geoclue_client_skeleton_new (void)
{
  return GEOCLUE_CLIENT (g_object_new (GEOCLUE_TYPE_CLIENT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.GeoClue2.Location
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GeoclueLocation
 * @title: GeoclueLocation
 * @short_description: Generated C code for the org.freedesktop.GeoClue2.Location D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.GeoClue2.Location ---- */

static const _ExtendedGDBusPropertyInfo _geoclue_location_property_info_latitude =
{
  {
    -1,
    (gchar *) "Latitude",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "latitude",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _geoclue_location_property_info_longitude =
{
  {
    -1,
    (gchar *) "Longitude",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "longitude",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _geoclue_location_property_info_accuracy =
{
  {
    -1,
    (gchar *) "Accuracy",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "accuracy",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _geoclue_location_property_info_description =
{
  {
    -1,
    (gchar *) "Description",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "description",
  FALSE
};

static const _ExtendedGDBusPropertyInfo * const _geoclue_location_property_info_pointers[] =
{
  &_geoclue_location_property_info_latitude,
  &_geoclue_location_property_info_longitude,
  &_geoclue_location_property_info_accuracy,
  &_geoclue_location_property_info_description,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _geoclue_location_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.GeoClue2.Location",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_geoclue_location_property_info_pointers,
    NULL
  },
  "location",
};


/**
 * geoclue_location_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
geoclue_location_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_geoclue_location_interface_info.parent_struct;
}

/**
 * geoclue_location_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GeoclueLocation interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
geoclue_location_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "latitude");
  g_object_class_override_property (klass, property_id_begin++, "longitude");
  g_object_class_override_property (klass, property_id_begin++, "accuracy");
  g_object_class_override_property (klass, property_id_begin++, "description");
  return property_id_begin - 1;
}



/**
 * GeoclueLocation:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>.
 */

/**
 * GeoclueLocationIface:
 * @parent_iface: The parent interface.
 * @get_accuracy: Getter for the #GeoclueLocation:accuracy property.
 * @get_description: Getter for the #GeoclueLocation:description property.
 * @get_latitude: Getter for the #GeoclueLocation:latitude property.
 * @get_longitude: Getter for the #GeoclueLocation:longitude property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>.
 */

typedef GeoclueLocationIface GeoclueLocationInterface;
G_DEFINE_INTERFACE (GeoclueLocation, geoclue_location, G_TYPE_OBJECT);

static void
geoclue_location_default_init (GeoclueLocationIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * GeoclueLocation:latitude:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("latitude", "Latitude", "Latitude", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GeoclueLocation:longitude:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("longitude", "Longitude", "Longitude", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GeoclueLocation:accuracy:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("accuracy", "Accuracy", "Accuracy", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GeoclueLocation:description:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("description", "Description", "Description", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * geoclue_location_get_latitude: (skip)
 * @object: A #GeoclueLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
geoclue_location_get_latitude (GeoclueLocation *object)
{
  return GEOCLUE_LOCATION_GET_IFACE (object)->get_latitude (object);
}

/**
 * geoclue_location_set_latitude: (skip)
 * @object: A #GeoclueLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Latitude">"Latitude"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
geoclue_location_set_latitude (GeoclueLocation *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "latitude", value, NULL);
}

/**
 * geoclue_location_get_longitude: (skip)
 * @object: A #GeoclueLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
geoclue_location_get_longitude (GeoclueLocation *object)
{
  return GEOCLUE_LOCATION_GET_IFACE (object)->get_longitude (object);
}

/**
 * geoclue_location_set_longitude: (skip)
 * @object: A #GeoclueLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Longitude">"Longitude"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
geoclue_location_set_longitude (GeoclueLocation *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "longitude", value, NULL);
}

/**
 * geoclue_location_get_accuracy: (skip)
 * @object: A #GeoclueLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
geoclue_location_get_accuracy (GeoclueLocation *object)
{
  return GEOCLUE_LOCATION_GET_IFACE (object)->get_accuracy (object);
}

/**
 * geoclue_location_set_accuracy: (skip)
 * @object: A #GeoclueLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Accuracy">"Accuracy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
geoclue_location_set_accuracy (GeoclueLocation *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "accuracy", value, NULL);
}

/**
 * geoclue_location_get_description: (skip)
 * @object: A #GeoclueLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use geoclue_location_dup_description() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
geoclue_location_get_description (GeoclueLocation *object)
{
  return GEOCLUE_LOCATION_GET_IFACE (object)->get_description (object);
}

/**
 * geoclue_location_dup_description: (skip)
 * @object: A #GeoclueLocation.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
geoclue_location_dup_description (GeoclueLocation *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "description", &value, NULL);
  return value;
}

/**
 * geoclue_location_set_description: (skip)
 * @object: A #GeoclueLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-GeoClue2-Location.Description">"Description"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
geoclue_location_set_description (GeoclueLocation *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "description", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * GeoclueLocationProxy:
 *
 * The #GeoclueLocationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GeoclueLocationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GeoclueLocationProxy.
 */

struct _GeoclueLocationProxyPrivate
{
  GData *qdata;
};

static void geoclue_location_proxy_iface_init (GeoclueLocationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GeoclueLocationProxy, geoclue_location_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GeoclueLocationProxy)
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_LOCATION, geoclue_location_proxy_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (GeoclueLocationProxy, geoclue_location_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_LOCATION, geoclue_location_proxy_iface_init));

#endif
static void
geoclue_location_proxy_finalize (GObject *object)
{
  GeoclueLocationProxy *proxy = GEOCLUE_LOCATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (geoclue_location_proxy_parent_class)->finalize (object);
}

static void
geoclue_location_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = _geoclue_location_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
geoclue_location_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  error = NULL;
  if (!g_dbus_proxy_call_finish (proxy, res, &error))
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.GeoClue2.Location: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
}

static void
geoclue_location_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = _geoclue_location_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.GeoClue2.Location", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) geoclue_location_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
geoclue_location_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_geoclue_location_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GEOCLUE_TYPE_LOCATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GEOCLUE_TYPE_LOCATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
geoclue_location_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GeoclueLocationProxy *proxy = GEOCLUE_LOCATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_location_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_location_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gdouble 
geoclue_location_proxy_get_latitude (GeoclueLocation *object)
{
  GeoclueLocationProxy *proxy = GEOCLUE_LOCATION_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Latitude");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
geoclue_location_proxy_get_longitude (GeoclueLocation *object)
{
  GeoclueLocationProxy *proxy = GEOCLUE_LOCATION_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Longitude");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
geoclue_location_proxy_get_accuracy (GeoclueLocation *object)
{
  GeoclueLocationProxy *proxy = GEOCLUE_LOCATION_PROXY (object);
  GVariant *variant;
  gdouble value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Accuracy");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
geoclue_location_proxy_get_description (GeoclueLocation *object)
{
  GeoclueLocationProxy *proxy = GEOCLUE_LOCATION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Description");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
geoclue_location_proxy_init (GeoclueLocationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = geoclue_location_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GEOCLUE_TYPE_LOCATION_PROXY, GeoclueLocationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), geoclue_location_interface_info ());
}

static void
geoclue_location_proxy_class_init (GeoclueLocationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = geoclue_location_proxy_finalize;
  gobject_class->get_property = geoclue_location_proxy_get_property;
  gobject_class->set_property = geoclue_location_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = geoclue_location_proxy_g_signal;
  proxy_class->g_properties_changed = geoclue_location_proxy_g_properties_changed;

  geoclue_location_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GeoclueLocationProxyPrivate));
#endif
}

static void
geoclue_location_proxy_iface_init (GeoclueLocationIface *iface)
{
  iface->get_latitude = geoclue_location_proxy_get_latitude;
  iface->get_longitude = geoclue_location_proxy_get_longitude;
  iface->get_accuracy = geoclue_location_proxy_get_accuracy;
  iface->get_description = geoclue_location_proxy_get_description;
}

/**
 * geoclue_location_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_location_proxy_new_finish() to get the result of the operation.
 *
 * See geoclue_location_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
geoclue_location_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GEOCLUE_TYPE_LOCATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Location", NULL);
}

/**
 * geoclue_location_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_location_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with geoclue_location_proxy_new().
 *
 * Returns: (transfer full) (type GeoclueLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueLocation *
geoclue_location_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GEOCLUE_LOCATION (ret);
  else
    return NULL;
}

/**
 * geoclue_location_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See geoclue_location_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GeoclueLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueLocation *
geoclue_location_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GEOCLUE_TYPE_LOCATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Location", NULL);
  if (ret != NULL)
    return GEOCLUE_LOCATION (ret);
  else
    return NULL;
}


/**
 * geoclue_location_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like geoclue_location_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call geoclue_location_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See geoclue_location_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
geoclue_location_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GEOCLUE_TYPE_LOCATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Location", NULL);
}

/**
 * geoclue_location_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to geoclue_location_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with geoclue_location_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GeoclueLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueLocation *
geoclue_location_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GEOCLUE_LOCATION (ret);
  else
    return NULL;
}

/**
 * geoclue_location_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like geoclue_location_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See geoclue_location_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GeoclueLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
GeoclueLocation *
geoclue_location_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GEOCLUE_TYPE_LOCATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.GeoClue2.Location", NULL);
  if (ret != NULL)
    return GEOCLUE_LOCATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GeoclueLocationSkeleton:
 *
 * The #GeoclueLocationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GeoclueLocationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GeoclueLocationSkeleton.
 */

struct _GeoclueLocationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_geoclue_location_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GEOCLUE_TYPE_LOCATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GEOCLUE_TYPE_LOCATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_geoclue_location_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_location_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_geoclue_location_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_geoclue_location_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _geoclue_location_skeleton_vtable =
{
  _geoclue_location_skeleton_handle_method_call,
  _geoclue_location_skeleton_handle_get_property,
  _geoclue_location_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
geoclue_location_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return geoclue_location_interface_info ();
}

static GDBusInterfaceVTable *
geoclue_location_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_geoclue_location_skeleton_vtable;
}

static GVariant *
geoclue_location_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_geoclue_location_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _geoclue_location_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _geoclue_location_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _geoclue_location_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.GeoClue2.Location", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _geoclue_location_emit_changed (gpointer user_data);

static void
geoclue_location_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _geoclue_location_emit_changed (skeleton);
}

static void geoclue_location_skeleton_iface_init (GeoclueLocationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GeoclueLocationSkeleton, geoclue_location_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GeoclueLocationSkeleton)
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_LOCATION, geoclue_location_skeleton_iface_init));

#else
G_DEFINE_TYPE_WITH_CODE (GeoclueLocationSkeleton, geoclue_location_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GEOCLUE_TYPE_LOCATION, geoclue_location_skeleton_iface_init));

#endif
static void
geoclue_location_skeleton_finalize (GObject *object)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (geoclue_location_skeleton_parent_class)->finalize (object);
}

static void
geoclue_location_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_geoclue_location_emit_changed (gpointer user_data)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.GeoClue2.Location",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_geoclue_location_schedule_emit_changed (GeoclueLocationSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
geoclue_location_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _geoclue_location_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
geoclue_location_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _geoclue_location_schedule_emit_changed (skeleton, _geoclue_location_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
geoclue_location_skeleton_init (GeoclueLocationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = geoclue_location_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GEOCLUE_TYPE_LOCATION_SKELETON, GeoclueLocationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
}

static gdouble 
geoclue_location_skeleton_get_latitude (GeoclueLocation *object)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
geoclue_location_skeleton_get_longitude (GeoclueLocation *object)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
geoclue_location_skeleton_get_accuracy (GeoclueLocation *object)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_double (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
geoclue_location_skeleton_get_description (GeoclueLocation *object)
{
  GeoclueLocationSkeleton *skeleton = GEOCLUE_LOCATION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
geoclue_location_skeleton_class_init (GeoclueLocationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = geoclue_location_skeleton_finalize;
  gobject_class->get_property = geoclue_location_skeleton_get_property;
  gobject_class->set_property = geoclue_location_skeleton_set_property;
  gobject_class->notify       = geoclue_location_skeleton_notify;


  geoclue_location_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = geoclue_location_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = geoclue_location_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = geoclue_location_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = geoclue_location_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GeoclueLocationSkeletonPrivate));
#endif
}

static void
geoclue_location_skeleton_iface_init (GeoclueLocationIface *iface)
{
  iface->get_latitude = geoclue_location_skeleton_get_latitude;
  iface->get_longitude = geoclue_location_skeleton_get_longitude;
  iface->get_accuracy = geoclue_location_skeleton_get_accuracy;
  iface->get_description = geoclue_location_skeleton_get_description;
}

/**
 * geoclue_location_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-GeoClue2-Location.top_of_page">org.freedesktop.GeoClue2.Location</link>.
 *
 * Returns: (transfer full) (type GeoclueLocationSkeleton): The skeleton object.
 */
GeoclueLocation *
geoclue_location_skeleton_new (void)
{
  return GEOCLUE_LOCATION (g_object_new (GEOCLUE_TYPE_LOCATION_SKELETON, NULL));
}

