/*
 * Copyright © 2018 Christian Persch
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "config.h"

#include <glib/gi18n.h>

#include "terminal-headerbar.h"
#include "terminal-libgsystem.h"

typedef struct _TerminalHeaderbarPrivate TerminalHeaderbarPrivate;

struct _TerminalHeaderbar
{
  GtkHeaderBar parent_instance;
};

struct _TerminalHeaderbarClass
{
  GtkHeaderBarClass parent_class;
};

struct _TerminalHeaderbarPrivate
{
  gpointer dummy;
};

enum {
  PROP_0,
  LAST_PROP
};

enum {
  LAST_SIGNAL
};

/* static guint signals[LAST_SIGNAL]; */
/* static GParamSpec *pspecs[LAST_PROP]; */

G_DEFINE_TYPE_WITH_PRIVATE (TerminalHeaderbar, terminal_headerbar, GTK_TYPE_HEADER_BAR)

#define PRIV(obj) ((TerminalHeaderbarPrivate *) terminal_headerbar_get_instance_private ((TerminalHeaderbar *)(obj)))

/* Class implementation */

static void
terminal_headerbar_init (TerminalHeaderbar *headerbar)
{
  //  TerminalHeaderbarPrivate *priv = PRIV (headerbar);
  GtkWidget *widget = GTK_WIDGET (headerbar);

  gtk_widget_init_template (widget);
}

static void
terminal_headerbar_finalize (GObject *object)
{
#if 0
  TerminalHeaderbar *headerbar = TERMINAL_HEADERBAR (object);
  TerminalHeaderbarPrivate *priv = PRIV (headerbar);
#endif

  G_OBJECT_CLASS (terminal_headerbar_parent_class)->finalize (object);
}

static void
terminal_headerbar_get_property (GObject *object,
                                 guint prop_id,
                                 GValue *value,
                                 GParamSpec *pspec)
{
  //  TerminalHeaderbar *headerbar = TERMINAL_HEADERBAR (object);

  switch (prop_id) {
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    break;
  }
}

static void
terminal_headerbar_set_property (GObject *object,
                                 guint prop_id,
                                 const GValue *value,
                                 GParamSpec *pspec)
{
  switch (prop_id) {
  default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  }
}

static void
terminal_headerbar_class_init (TerminalHeaderbarClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);
  GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

  gobject_class->finalize = terminal_headerbar_finalize;
  gobject_class->get_property = terminal_headerbar_get_property;
  gobject_class->set_property = terminal_headerbar_set_property;

  /* g_object_class_install_properties (gobject_class, G_N_ELEMENTS (pspecs), pspecs); */

  gtk_widget_class_set_template_from_resource (widget_class, "/org/gnome/terminal/ui/headerbar.ui");
}

/* public API */

/**
 * terminal_headerbar_new:
 *
 * Returns: a new #TerminalHeaderbar
 */
GtkWidget *
terminal_headerbar_new (void)
{
  return g_object_new (TERMINAL_TYPE_HEADERBAR,
                       NULL);
}
