/* $Id: main.c,v 1.27 2002/02/02 21:32:31 kevinv Exp $ */

/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  Main program function
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <gnome.h>
#include <libgnomeui/gnome-window-icon.h>

#include "dict.h"
#include "gdict-pref.h"
#include "gdict-applet.h"
#include "gdict-app.h"


static gint save_yourself_cb (GnomeClient       *client,
                              gint               phase,
                              GnomeRestartStyle  save_style,
                              gint               shutdown,
                              GnomeInteractStyle interact_style,
                              gint               fast,
                              gpointer           client_data)
{
    gchar *argv[] = {NULL, NULL, NULL, NULL, NULL};
    gchar *word;
    gint argc = 1;

    argv[0] = (gchar *)client_data;

    if ((word = gdict_defbox_get_word(defbox)) != NULL)
        argv[argc++] = word;

    gnome_client_set_restart_command(client, argc, argv);
    gnome_client_set_clone_command(client, 0, NULL);

    return TRUE;
}

int main (int argc, char *argv[])
{
    gint i;
    GDictApplet * applet = NULL;
    GnomeClient *client;

    

    static struct poptOption args[] = {
        {"noapplet", 'a', POPT_ARG_NONE, 0, 0, "Startup without applet support", NULL},
        {NULL, 0, 0, NULL, 0, NULL, NULL}
    };

    bindtextdomain(GETTEXT_PACKAGE, GNOMELOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    gnome_init_with_popt_table ("gdict", VERSION, argc, argv,
                                    args, 0, NULL);

    if ((client = gnome_master_client()) != NULL)
            gtk_signal_connect (GTK_OBJECT(client), "save_yourself",
                                GTK_SIGNAL_FUNC(save_yourself_cb),
				(gpointer) argv[0]);
    
    
    gnome_window_icon_set_default_from_file (GNOME_ICONDIR"/gdict.png");
    gdict_app_create (FALSE);
    gdict_pref_load ();

    gdict_init_context ();
    defbox->context = context;

    for (i = 1;  i < argc;  i++)
            if (argv[i][0] != '-') {
                gdict_defbox_lookup(defbox, argv[i]);
                break;
            }

    gtk_widget_show(gdict_app);
    gtk_main();
    
    dict_context_destroy (context); /* FIXME */

    return 0;
}

