/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Copyright (C) 2004 Vincent Noel <vnoel@cox.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glib.h>
#include "gdict-web-search.h"
#include "gdict-app.h"

static GDictWebSearchSite default_sites[] = {
	{"Cambridge Dictionary", "http://dictionary.cambridge.org/results.asp?searchword=%s", TRUE},
	{"The Free Dictionary", "http://www.thefreedictionary.com/%s", FALSE},
	{"Google define", "http://www.google.com/search?q=define:%s", FALSE},
	{"Dutch translation", "http://online.babylon.com/combo/index.html?lang=4&word=%s", FALSE},
	{"English translation", "http://online.babylon.com/combo/index.html?lang=0&word=%s", FALSE},
	{"French translation", "http://online.babylon.com/combo/index.html?lang=1&word=%s", FALSE},
	{"German translation", "http://online.babylon.com/combo/index.html?lang=6&word=%s", FALSE},
	{"Greek translation", "http://online.babylon.com/combo/index.html?lang=11&word=%s", FALSE},
	{"Italian translation", "http://online.babylon.com/combo/index.html?lang=2&word=%s", FALSE},
	{"Spanish translation", "http://online.babylon.com/combo/index.html?lang=3&word=%s", FALSE},
	{"Swedish translation", "http://online.babylon.com/combo/index.html?lang=48&word=%s", FALSE},
	{"Turkish translation", "http://online.babylon.com/combo/index.html?lang=13&word=%s", FALSE}
};

GDictWebSearchSite *
gdict_web_search_new (gchar *name, gchar *url, gboolean enabled)
{
	GDictWebSearchSite *site;
	site = g_new0 (GDictWebSearchSite, 1);
	site->name = g_strdup_printf("%s", name);
	site->url = g_strdup_printf("%s", url);
	site->enabled = enabled;
	return site;
}

void
gdict_web_search_remove (GDictWindow *gdict, GDictWebSearchSite *site)
{
	g_free (site->name);
	g_free (site->url);
	gdict->web_search_sites = g_slist_remove (gdict->web_search_sites, site);
	g_free (site);
}

void
gdict_web_search_remove_all (GDictWindow *gdict)
{
	GSList *site_list;
	GDictWebSearchSite *site;
	
	for (site_list = gdict->web_search_sites;
	     site_list;
	     site_list = g_slist_next (site_list)) {
		site = site_list->data;
		g_free (site->name);
		g_free (site->url);
	}
	g_slist_free (gdict->web_search_sites);
}

GSList *
gdict_web_search_default_sites (void)
{
	GSList *sites = NULL;
	int i;
	GDictWebSearchSite *site;
	
	for (i=0; i<G_N_ELEMENTS (default_sites); i++) {
		site = gdict_web_search_new (default_sites[i].name, default_sites[i].url,
					     default_sites[i].enabled);
		sites = g_slist_prepend (sites, site);
	}
	return sites;
}
