#ifndef __GDICT_PREF_DIALOG_H_
#define __GDICT_PREF_DIALOG_H_

/* $Id: gdict-pref-dialog.h,v 1.10 2004/12/17 16:34:51 vnoel Exp $ */

/*
 *  Mike Hughes <mfh@psilord.com>
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Bradford Hovinen <hovinen@udel.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict preferences window
 *
 */

#include <gtk/gtk.h>
	
#include "dict.h"
#include "gdict-app.h"
#include "gdict-pref.h"
	
#define GDICT_TYPE_PREF_DIALOG            (gdict_pref_dialog_get_type ())
#define GDICT_PREF_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDICT_TYPE_PREF_DIALOG, GDictPrefDialog))
#define GDICT_PREF_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GDICT_TYPE_PREF_DIALOG, GDictPrefDialogClass))
#define GDICT_IS_PREF_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDICT_TYPE_PREF_DIALOG))
#define GDICT_IS_PREF_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDICT_TYPE_PREF_DIALOG))
#define GDICT_PREF_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GDICT_TYPE_PREF_DIALOG, GDictPrefDialogClass))
	
typedef struct _GDictPrefDialog        GDictPrefDialog;
typedef struct _GDictPrefDialogClass   GDictPrefDialogClass;
	
struct _GDictPrefDialog {
    GtkDialog       dialog;

    GtkTable         *table;
    GtkEntry         *server_entry;
    GtkWidget        *server_label;
    GtkWidget        *server_button;
    GtkEntry         *port_entry;
    GtkWidget        *port_label;
    GtkWidget        *port_button;
    GtkWidget        *db_label;
    GtkOptionMenu    *db_sel;
    GtkMenu          *db_list;
    GtkOptionMenu    *strat_sel;
    GtkMenu          *strat_list;
    GtkWidget        *strat_label;	
    GtkWidget        *view;
    GtkWidget        *remove_button;

    dict_context_t   *context;
    dict_command_t   *get_db_cmd;
    dict_command_t   *get_strat_cmd;
    
    gchar            *database;
    guint             database_idx;
    gchar            *dfl_strat;
    guint             dfl_strat_idx;

    GDictPref *pref;
    GDictWindow *gdict;
};

struct _GDictPrefDialogClass {
	GtkDialogClass parent_class;
	void (*socket_error)  (GDictPrefDialog *, gchar *);
};

GType      gdict_pref_dialog_get_type   (void);
	
GtkWidget *gdict_pref_dialog_new        (GDictWindow *gdict, GDictPref *pref);
void       gdict_pref_dialog_destroy          (GDictPrefDialog *dialog);

#endif /* __GDICT_PREF_DIALOG_H_ */
