/***************************************
 Functions to operate the panel applet
 (c) 1999 Jeremy Wise
 GnomeICU
****************************************/

/*** GnomeICU header files ***/
#include "common.h"
#include "autohide.h"
#include "applet.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "gtkconf.h"
#include "icons.h"
#include "util.h"

#ifdef BUILD_APPLET

#include <gdk_imlib.h>
#include <libgnorba/gnorba.h>
#include <applet-widget.h>

GtkWidget *frame;
GtkWidget *frame_outline;
GtkWidget *mess_label = NULL;
GtkWidget *mess_pm = NULL;
GtkWidget *applet;

/*** Local function declarations ***/
static gint applet_save_state_cb( GtkWidget *w, const char *privcfgpath, const char *globcfgpath, gpointer data );
static void applet_clicked_cb( GtkWidget *widget, GdkEventButton *ev, gpointer data );
static void applet_exposed_cb( GtkWidget *widget, gpointer data );
static void applet_change_orient_cb( GtkWidget *w, PanelOrientType o, gpointer data );

static GtkWidget *applet_construct( void );
static void init_applet_signals( GtkWidget *window );
static void update_orient( PanelOrientType orient, int size );

#ifdef HAVE_PANEL_PIXEL_SIZE
static void applet_change_size_cb( GtkWidget *w, int size, gpointer data );
#endif

#endif /* BUILD_APPLET */

/*** Global functions ***/
void applet_create( void )
{
#ifdef BUILD_APPLET
	GtkWidget *widget;
	CORBA_Object panel;

#ifdef TRACE_FUNCTION
	g_print( "applet_create\n" );
#endif

	panel = goad_server_activate_with_repo_id (NULL, "IDL:GNOME/Panel:1.0", GOAD_ACTIVATE_EXISTING_ONLY, NULL);

	if (panel == CORBA_OBJECT_NIL) {
		g_warning ("Panel is not running");
		toggles->applet = FALSE;
		return;
	}
	
	applet = applet_widget_new( PACKAGE );
	if ( applet == NULL ) {
		toggles->applet = FALSE;
		return;
	}	

	init_applet_signals( applet );
	gtk_widget_realize( applet );
	icons_init ();
	widget = applet_construct();

/*	g_free(style);*/

#ifdef HAVE_PANEL_PIXEL_SIZE
	update_orient( applet_widget_get_panel_orient( APPLET_WIDGET( applet ) ),
	               applet_widget_get_panel_pixel_size( APPLET_WIDGET( applet ) ) );
#else
	update_orient( applet_widget_get_panel_orient( APPLET_WIDGET( applet ) ),
	               48 );
#endif

	gtk_widget_show( widget );

	applet_widget_add( APPLET_WIDGET( applet ), widget );

	gtk_widget_show( applet );

	gtk_signal_connect( GTK_OBJECT(applet), "save_session",
	                    GTK_SIGNAL_FUNC(applet_save_state_cb),
	                    NULL);

	gtk_signal_connect( GTK_OBJECT( applet ), "delete_event",
	                    GTK_SIGNAL_FUNC( icq_quit ),
	                    NULL );
#endif /* BUILD_APPLET */
}

void applet_update( DWORD status, gboolean flash )
{
#ifdef BUILD_APPLET
	GdkPixmap *status_pix;
	GdkBitmap *status_bit;
	gchar *message_count = NULL;
	int num_messages = 0;
	gint type = 0;
	gint online = 0;

	GSList *contact;

	gchar *nextmsg = NULL;

	GString *names_str = NULL;

	static gchar *old_tooltip = NULL;

#ifdef TRACE_FUNCTION
	g_print( "applet_update\n" );
#endif

	if( toggles->applet == FALSE )
		return;

	/* Our status */
	status_pix = get_pixmap_for_status( status );
	status_bit = get_bitmap_for_status( status );

	contact = Contacts;

	while( contact != NULL )
	{
		guchar len = g_slist_length( kontakt->stored_messages );
		if( len ) {
			if( nextmsg == NULL ) {
				nextmsg = g_strdup_printf( _("Next message from %s"), kontakt->nick );
				type = ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type;
			}
			num_messages += len;
		}
		contact = contact->next;
	}

	/* adding code to display contacts in a tooltip, dwb 11-3-1999
	   severely modified by Jeremy Wise, 11-10-1999 */
	/* Modified even more, by NH, to show status of contact  - NH*/

	contact = Contacts;

	names_str = g_string_new( "" );
		
	while( contact != NULL )
	{
		if( kontakt->status != STATUS_OFFLINE &&
		    kontakt->ignore_list != TRUE )
		{
			/* Append contact to tooltip */
			g_string_sprintfa( names_str, "%s (%s)\n",
					   kontakt->nick,
					   get_status_str( kontakt->status ) );

			/* Count online users */
			online++;
		}
		contact = contact->next;
	}

	if( num_messages )
	{
		if( flash )
			gtk_pixmap_set( GTK_PIXMAP( mess_pm ),
			                get_pixmap_for_message( type ),
			                get_bitmap_for_message( type ) );
		else
			gtk_pixmap_set( GTK_PIXMAP( mess_pm ),
			                icon_blank_pixmap,
		       	                icon_blank_bitmap );

		message_count = g_strdup_printf( "%d", num_messages );
	}
	else
	{
		/* Normal view: user status and number of online users */
		gtk_pixmap_set( GTK_PIXMAP( mess_pm ), status_pix,
		                status_bit );
		message_count = g_strdup_printf( "%d", online );
	}

	gtk_label_set( GTK_LABEL( mess_label ), message_count );
	g_free( message_count );

	if (toggles->show_applet_border)
	{
		gtk_frame_set_shadow_type( GTK_FRAME( frame_outline ), GTK_SHADOW_ETCHED_IN );
	}
	else
	{
		gtk_frame_set_shadow_type( GTK_FRAME( frame_outline ), GTK_SHADOW_NONE );
	}

        if( toggles->hidetooltip == TRUE ) 
        {
                applet_widget_set_tooltip( APPLET_WIDGET( applet ), NULL);
        }
        else
        {
		gchar *tooltips_str;

		if( nextmsg == NULL )
		{
			if( online == 0 )
				tooltips_str = g_strdup_printf( _("%u: 0 Users Online"), our_info->uin );
			else if( online == 1 )
				tooltips_str = g_strdup_printf( _("%u: 1 User Online\n%s"), our_info->uin, names_str->str );
			else
				tooltips_str = g_strdup_printf( _("%u: %u Users Online\n%s"), our_info->uin, online, names_str->str );
		}
		else {
			if( online == 0 )
				tooltips_str = g_strdup_printf( _("%u: 0 Users Online\n%s"), our_info->uin, nextmsg );
			else if( online == 1 )
				tooltips_str = g_strdup_printf( _("%u: 1 User Online\n%s"), our_info->uin, nextmsg );
			else
				tooltips_str = g_strdup_printf( _("%u: %u Users Online\n%s"), our_info->uin, online, nextmsg );
		}

		if( old_tooltip == NULL || strcmp( tooltips_str, old_tooltip ) )
	                applet_widget_set_tooltip( APPLET_WIDGET( applet ), tooltips_str );
		g_free( old_tooltip );
		old_tooltip = g_strdup( tooltips_str );

		g_free( tooltips_str );
        }

	g_string_free( names_str, TRUE );
	g_free( nextmsg );
#endif /* BUILD_APPLET */
}

#ifdef BUILD_APPLET

void applet_clicked_cb( GtkWidget *widget, GdkEventButton *ev, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "applet_clicked_cb\n" );
#endif

	if( ev == NULL )
		return;

	if( ev->button != 1 || ev->type != GDK_BUTTON_PRESS )
		return;

	contact = Contacts;

	while( contact != NULL && g_slist_length( kontakt->stored_messages ) == 0 )
		contact = contact->next;

	if( contact == NULL )
		applet_hide_main( widget, NULL );
	else
		show_contact_message( contact );
}

#endif /* BUILD_APPLET */

gboolean applet_hide_main( GtkWidget *widget, gpointer data )
{
#ifdef BUILD_APPLET

#ifdef TRACE_FUNCTION
	g_print( "applet_hide_main\n" );
#endif

	if( !toggles->applet )
		return TRUE;
        
	if( !GTK_WIDGET_VISIBLE( app ) )
	{
		gtk_widget_show( app );
	}
	else
	{
#if 0
            if( (gnome_win_hints_get_workspace( app ) != gnome_win_hints_get_current_workspace()) && (GPOINTER_TO_INT(data) == 0))
            {
                gtk_widget_hide( app );
                gdk_window_withdraw( GTK_WIDGET( app )->window );
                gtk_widget_show( app );
            }
            else
#endif
            {
                gtk_widget_hide( app );
                gdk_window_withdraw( GTK_WIDGET( app )->window );
                if( autohide_timeout_tag )
                {
                    gtk_timeout_remove( autohide_timeout_tag );
                    /* so we know it's not running anymore */
                    autohide_timeout_tag = 0;
                }
            }
	}

#endif /* BUILD_APPLET */

	return TRUE; /* don't emit "destroy" signal */
}

#ifdef BUILD_APPLET

/*** Local functions ***/
gint applet_save_state_cb( GtkWidget *w, const char *privcfgpath, const char *globcfgpath, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_save_state_cb\n" );
#endif

	Save_RC();

	gnome_config_sync();
	gnome_config_drop_all();

	return FALSE;
}

void applet_exposed_cb( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_exposed_cb(%d)\n", Current_Status );
#endif

	applet_update( Current_Status, FALSE );
}

GtkWidget *applet_construct( void )
{
	GtkWidget *eventbox;

#ifdef TRACE_FUNCTION
	g_print( "applet_construct\n" );
#endif

	if( mess_label == NULL )
		mess_label = gtk_label_new( "0" );

	if( mess_pm == NULL )
		mess_pm = gtk_pixmap_new( icon_blank_pixmap, icon_blank_bitmap );

	gtk_widget_push_visual (gdk_imlib_get_visual ());
	gtk_widget_push_colormap (gdk_imlib_get_colormap ());

	eventbox = gtk_event_box_new();
	frame_outline = gtk_frame_new( NULL );

	gtk_container_add( GTK_CONTAINER( eventbox ), frame_outline );
	
	frame = gtk_fixed_new();

	gtk_container_add( GTK_CONTAINER( frame_outline ), frame );
	gtk_widget_set_usize( frame_outline, 20, 48 );
	gtk_widget_show( frame_outline );

	gtk_widget_show( frame );

	gtk_fixed_put( GTK_FIXED( frame ), mess_pm, 2, 3 );
	gtk_widget_show( mess_pm );

	gtk_misc_set_alignment( GTK_MISC( mess_label ), 0.5, 0.5 );
	gtk_fixed_put( GTK_FIXED( frame ), mess_label, 2, 30 );
	gtk_widget_show( mess_label );

	gtk_widget_pop_colormap ();
	gtk_widget_pop_visual ();
        return eventbox;
}

void init_applet_signals( GtkWidget *window )
{
	gtk_widget_set_events( window, gtk_widget_get_events( window ) |
	                       GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );

	gtk_signal_connect( GTK_OBJECT( window ), "expose_event",
	                    GTK_SIGNAL_FUNC( applet_exposed_cb ), NULL );
	gtk_signal_connect( GTK_OBJECT( window ), "button_press_event",
	                    GTK_SIGNAL_FUNC( applet_clicked_cb ), NULL );
	gtk_signal_connect( GTK_OBJECT( window ), "change_orient",
	                    GTK_SIGNAL_FUNC( applet_change_orient_cb ), NULL );
#ifdef HAVE_PANEL_PIXEL_SIZE
	gtk_signal_connect( GTK_OBJECT( window ), "change_pixel_size",
			    GTK_SIGNAL_FUNC( applet_change_size_cb ), NULL );
#endif

        applet_widget_register_stock_callback_dir( APPLET_WIDGET( applet ),
                                                   "set_status",
                                                   GNOME_STOCK_MENU_REFRESH,
                                                   _("Change Status") );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                 "set_status/set_online",
	                                _("Online"),
	                                (AppletCallbackFunc)icq_set_status_online,
	                                MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                 "set_status/set_away",
	                                 _("Away"),
	                                 (AppletCallbackFunc)icq_set_status_away,
	                                 MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                 "set_status/set_na",
	                                 _("Not Available"),
	                                 (AppletCallbackFunc)icq_set_status_na,
	                                 MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                 "set_status/set_ffc",
	                                 _("Free For Chat"),
	                                 (AppletCallbackFunc)icq_set_status_ffc,
	                                 MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                 "set_status/set_occ",
	                                 _("Occupied"),
	                                 (AppletCallbackFunc)icq_set_status_occ,
	                                 MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                 "set_status/set_dnd",
	                                 _("Do Not Disturb"),
	                                 (AppletCallbackFunc)icq_set_status_dnd,
	                                 MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                 "set_status/set_inv",
	                                 _("Invisible"),
	                                 (AppletCallbackFunc)icq_set_status_invisible,
	                                 MainData );
	applet_widget_register_callback( APPLET_WIDGET( applet ),
	                                 "set_status/set_offline",
	                                 _("Offline"),
	                                 (AppletCallbackFunc)icq_set_status_offline,
	                                 MainData );
        
	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "hide_show",
	                                       GNOME_STOCK_MENU_CONVERT,
	                                       _("Hide/Show Main Window"),
	                                       (AppletCallbackFunc)applet_hide_main,
	                                       MainData );
	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "options",
	                                       GNOME_STOCK_MENU_PROP,
	                                       _("Preferences..."),
	                                       (AppletCallbackFunc)configure_window,
	                                       MainData );
	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "about",
	                                       GNOME_STOCK_MENU_ABOUT,
	                                       _("About..."),
	                                       (AppletCallbackFunc)about,
	                                       NULL );
}

static void
update_orient (PanelOrientType orient, int size)
{
	gint x, y, size_minus;

#ifdef TRACE_FUNCTION
        g_print( "update_orient orient: %d size: %d\n", orient, size );
#endif

        if (size < 36)
            size_minus = 0;
        else
            size_minus = 4;
        
	if( orient == ORIENT_UP || orient == ORIENT_DOWN )
	{
		if( size < 48 )
		{
			x = 48;
			y = size - size_minus;
		}
		else
		{
			x = 24;
			y = size - size_minus;
		}
	}
	else
	{
		if( size < 48 )
		{
			x = size;
			y = 48;
		}
		else
		{
			x = size;
			y = 24;
		}
	}

	gtk_widget_set_usize( frame, x - size_minus, y - size_minus );
	gtk_widget_set_usize( frame_outline, x, y );
	if( x > y )
		gtk_fixed_move( GTK_FIXED( frame ), mess_label, 30, 2 );
	else
		gtk_fixed_move( GTK_FIXED( frame ), mess_label, 6, 22 );
}

static void applet_change_orient_cb( GtkWidget *w, PanelOrientType o, gpointer data )
{
	int size = 48;
#ifdef HAVE_PANEL_PIXEL_SIZE
	size = applet_widget_get_panel_pixel_size( APPLET_WIDGET( w ) );
#endif
	update_orient( o, size );
}

#ifdef HAVE_PANEL_PIXEL_SIZE
static void applet_change_size_cb( GtkWidget *w, int size, gpointer data )
{
	update_orient( applet_widget_get_panel_orient( APPLET_WIDGET( w )), size );
}
#endif

#endif /* BUILD_APPLET */

void applet_remove( void )
{
#ifdef BUILD_APPLET
	applet_widget_remove( APPLET_WIDGET( applet ));
#endif
}

