/*******************************
 Change personal information
 (c) 1999 Jeremy Wise
 GnomeICU
********************************/

#include "common.h"
#include "changeinfo.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "util.h"
#include "v7send.h"

/*** Toplevel header files ***/

/*** Local function declarations ***/
void homeinfo_change( GtkWidget *widget, gpointer pointer );
void workinfo_change( GtkWidget *widget, gpointer pointer );
void moreinfo_change( GtkWidget *widget, gpointer pointer );
void about_change( GtkWidget *widget, gpointer pointer );
void emails_change( GtkWidget *widget, gpointer pointer );
static void homeinfo_save(void);
static void workinfo_save(void);
static void moreinfo_save(void);
static void about_save(void);

void on_reload_button_clicked ( GtkWidget *widget, gpointer pointer );
void on_save_button_clicked ( GtkWidget *widget, gpointer pointer );
void on_cancel_button_clicked ( GtkWidget *widget, gpointer pointer );

static gboolean homeinfo_changed, workinfo_changed, moreinfo_changed,
  about_changed, emails_changed;
static GladeXML *our_info_xml = NULL;


/*** Global functions ***/
void change_info_window( GtkWidget *widget, gpointer data )
{

#ifdef TRACE_FUNCTION
  g_print( "change_info_window\n" );
#endif

  if (!our_info_xml) {
    our_info_xml = glade_xml_new (GNOMEICU_GLADEDIR "user_info.glade", "our_info_dialog");
    gtk_combo_set_popdown_strings( GTK_COMBO( glade_xml_get_widget (our_info_xml, "work_country_combo" ) ), get_country_codes() );
    gtk_combo_set_popdown_strings( GTK_COMBO( glade_xml_get_widget (our_info_xml, "country_combo" ) ), get_country_codes() );
    gtk_combo_set_popdown_strings( GTK_COMBO( glade_xml_get_widget (our_info_xml, "timezone_combo" ) ), get_time_zones() );

    glade_xml_signal_autoconnect (our_info_xml);
  }
  
  homeinfo_changed = FALSE;
  workinfo_changed = FALSE;
  moreinfo_changed = FALSE;
  about_changed    = FALSE;
  emails_changed   = FALSE;
  
  update_our_info();

  gtk_widget_show_all (glade_xml_get_widget (our_info_xml, "our_info_dialog"));
}

void homeinfo_change( GtkWidget *widget, gpointer pointer )
{
#ifdef TRACE_FUNCTION
  g_print( "homeinfo_change\n" );
#endif

  homeinfo_changed = TRUE;
}

void workinfo_change( GtkWidget *widget, gpointer pointer )
{
#ifdef TRACE_FUNCTION
  g_print( "workinfo_change\n" );
#endif

  workinfo_changed = TRUE;
}

void moreinfo_change( GtkWidget *widget, gpointer pointer )
{
#ifdef TRACE_FUNCTION
  g_print( "moreinfo_change\n" );
#endif

  moreinfo_changed = TRUE;
}

void about_change( GtkWidget *widget, gpointer pointer )
{
#ifdef TRACE_FUNCTION
  g_print( "about_change\n" );
#endif

  about_changed = TRUE;
}

void emails_change( GtkWidget *widget, gpointer pointer )
{
#ifdef TRACE_FUNCTION
  g_print( "emails_change\n" );
#endif

  emails_changed = TRUE;  
}

void on_reload_button_clicked ( GtkWidget *widget, gpointer pointer )
{
    v7_request_our_info();
}

void on_save_button_clicked ( GtkWidget *widget, gpointer pointer )
{

#ifdef TRACE_FUNCTION
  g_print( "on_save_button_clicked\n" );
#endif

  if (homeinfo_changed) {
    homeinfo_save();
    homeinfo_changed = FALSE;
  }

  if (workinfo_changed) {
    workinfo_save();
    workinfo_changed = FALSE;
  }
  
  if (moreinfo_changed) {
    moreinfo_save();
    moreinfo_changed = FALSE;
  }

  if (about_changed) {
    about_save();
    about_changed = FALSE;
  }
  
  gtk_widget_destroy (glade_xml_get_widget (our_info_xml, "our_info_dialog"));
  our_info_xml = NULL;
      
}

void on_cancel_button_clicked ( GtkWidget *widget, gpointer pointer )
{

#ifdef TRACE_FUNCTION
  g_print( "on_cancel_button_clicked\n" );
#endif

  gtk_widget_destroy (glade_xml_get_widget (our_info_xml, "our_info_dialog"));
  our_info_xml = NULL;
}

static void homeinfo_save()
{

#ifdef TRACE_FUNCTION
  g_print( "homeinfo_save\n" );
#endif

  g_free( our_info->nick );
  our_info->nick = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "nick_entry") )));
  
  g_free( our_info->first );
  our_info->first = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "fname_entry" ))));
  
  g_free( our_info->last );
  our_info->last = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "lname_entry" ))));

  g_free( our_info->email );
  our_info->email = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "email_entry" ) ) ) );
  
  our_info->hide_email = gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( glade_xml_get_widget (our_info_xml, "hide_email_checkbutton" )));
  
  g_free( our_info->phone );
  our_info->phone = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "phone_entry" ) ) ) );
  
  g_free( our_info->fax );
  our_info->fax = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "fax_entry" ) ) ) );
  
  g_free( our_info->cellular );
  our_info->cellular = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "cellular_entry" ) ) ) );
  
  g_free( our_info->street );
  our_info->street = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "street_entry" ) ) ) );
  
  g_free( our_info->city );
  our_info->city = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "city_entry" ) ) ) );

  g_free( our_info->state );
  our_info->state = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "state_entry" ) ) ) );

  g_free(our_info->zip);
  our_info->zip = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "zip_entry" ) ) ) );

  our_info->country = Get_Country_Code( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "country_combo_entry"  ) ) ) );

  our_info->c_status = Get_Time_Zone( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "timezone_combo_entry"  ) ) ) );

  v7_modify_main_home_info (our_info->nick, our_info->first,
                            our_info->last, our_info->email,
                            our_info->city, our_info->state,
                            our_info->phone, our_info->fax,
                            our_info->street, our_info->cellular,
                            our_info->zip, our_info->country,
                            our_info->c_status, our_info->hide_email);
  homeinfo_changed = FALSE;;
  save_user_info ();
  
}

static void workinfo_save()
{

#ifdef TRACE_FUNCTION
  g_print( "workinfo_save\n" );
#endif

  g_free(our_info->job_pos);
  our_info->job_pos = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_position_entry" ) ) ) );

  g_free(our_info->department);
  our_info->department = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_department_entry" ) ) ) );

  g_free(our_info->company_name);
  our_info->company_name = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_company_entry" ) ) ) );

  g_free(our_info->work_address);
  our_info->work_address = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_street_entry" ) ) ) );

  g_free(our_info->work_city);
  our_info->work_city = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_city_entry" ) ) ) );

  g_free(our_info->work_state);
  our_info->work_state = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_state_entry" ) ) ) );

  g_free(our_info->work_zip);
  our_info->work_zip = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_zip_entry" ) ) ) );
  
  g_free(our_info->work_homepage);
  our_info->work_homepage = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_homepage_entry" ) ) ) );
  
  our_info->work_country = Get_Country_Code( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "work_country_combo_entry" ) ) ) );

  v7_modify_work_info (our_info->work_city, our_info->work_state,
                       our_info->work_address, our_info->work_zip,
                       our_info->company_name, our_info->department,
                       our_info->job_pos, our_info->work_homepage,
                       our_info->work_country);

  workinfo_changed = FALSE;

  save_user_info ();
}

static void moreinfo_save()
{
  time_t birthday_t;
  struct tm birthday_tm;

#ifdef TRACE_FUNCTION
  g_print( "moreinfo_save\n" );
#endif

  our_info->age = atoi( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "age_entry" ) ) ) );
  
  birthday_t = gnome_date_edit_get_date(GNOME_DATE_EDIT(glade_xml_get_widget (our_info_xml, "birthday_dateedit")));
  birthday_tm = *localtime(&birthday_t);
  our_info->birth_month = birthday_tm.tm_mon;
  our_info->birth_day = birthday_tm.tm_mday;
  our_info->birth_year = birthday_tm.tm_year;

  if( !strcmp( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "sex_combo_entry"))), _("Male")))
    our_info->sex = MALE;
  else if( !strcmp( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "sex_combo_entry"))), _("Female")))
    our_info->sex = FEMALE;
  else
    our_info->sex = NOT_SPECIFIED;
  
  g_free( our_info->homepage );
  our_info->homepage = g_strdup( gtk_entry_get_text( GTK_ENTRY( glade_xml_get_widget (our_info_xml, "homepage_entry" ) ) ) );


  v7_modify_more_info (our_info->age, our_info->sex, our_info->homepage,
                       our_info->birth_year, our_info->birth_month,
                       our_info->birth_day, 0, 0, 0);

  moreinfo_changed = FALSE;
  
  save_user_info ();
}

static void about_save()
{

#ifdef TRACE_FUNCTION
  g_print( "about_save\n" );
#endif

  g_free( our_info->about );
  our_info->about = gtk_editable_get_chars( GTK_EDITABLE( glade_xml_get_widget (our_info_xml, "about_text" )), 0, -1 );
  
  v7_modify_about (our_info->about);

  about_changed = FALSE;
  
  save_user_info ();
}


void update_our_info ()
{
  gchar *string = NULL;
  struct tm birthday_tm;

#ifdef TRACE_FUNCTION
  g_print( "update_our_info\n" );
#endif

  if (our_info_xml == NULL)
    return;

  if( our_info->nick != NULL ) {
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "nick_entry")), our_info->nick);
  }

  if( our_info->first != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "fname_entry")), our_info->first);

  if( our_info->last != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "lname_entry")), our_info->last);

  if( our_info->sex == MALE )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "sex_combo_entry")), _("Male"));
  else if( our_info->sex == FEMALE )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "sex_combo_entry")), _("Female"));
  else
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "sex_combo_entry")), _("Unknown"));

  gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "age_entry")),
                      (string = our_info->age
                       ? g_strdup_printf( "%d", our_info->age % 1000 )
                       : g_strdup( _("Unknown") )));
  g_free( string );

  string = g_strdup_printf ("%d", our_info->uin);
  gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "uin_entry")), string);
  g_free (string);

  string = g_strdup_printf ("%d", our_port);
 if( our_info->port != NULL )
   gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "port_entry")), our_info->port);
 g_free (string);

  if( our_info->status != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "status_entry")), our_info->status);

  if( our_info->email != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "email_entry")), our_info->email);

  if( our_info->phone != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "phone_entry")), our_info->phone);

  if( our_info->fax != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "fax_entry")), our_info->fax);

  if( our_info->homepage != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "homepage_entry")), our_info->homepage);

  if( our_info->about != NULL )
    {
      gtk_text_freeze( GTK_TEXT( glade_xml_get_widget (our_info_xml, "about_text") ) );
      gtk_editable_delete_text (GTK_EDITABLE (glade_xml_get_widget (our_info_xml, "about_text")), 0, -1);
      gtk_text_insert( GTK_TEXT( glade_xml_get_widget (our_info_xml, "about_text") ), NULL, NULL, NULL,
                       our_info->about, -1 );
      gtk_text_thaw( GTK_TEXT( glade_xml_get_widget (our_info_xml, "about_text") ) );
    }

  if( our_info->job_pos != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_position_entry")), our_info->job_pos);

  if( our_info->department != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_department_entry")), our_info->department);

  if( our_info->company_name != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_company_entry")), our_info->company_name);

  if( our_info->work_address != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_street_entry")), our_info->work_address);

  if( our_info->work_city != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_city_entry")), our_info->work_city);

  if( our_info->work_state != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_state_entry")), our_info->work_state);

  if( our_info->work_homepage != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_homepage_entry")), our_info->work_homepage);

  if( our_info->work_zip != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_zip_entry")), our_info->work_zip);
	
  if( our_info->work_country != 0 )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "work_country_combo_entry")), Get_Country_Name (our_info->work_country));
	
  if( our_info->street != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "street_entry")), our_info->street);

  if( our_info->city != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "city_entry")), our_info->city);

  if( our_info->state != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "state_entry")), our_info->state);

  if( our_info->zip != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "zip_entry")), our_info->zip);

  if( our_info->country != 0 )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "country_combo_entry")), Get_Country_Name (our_info->country));

  if( our_info->country != 0 )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "timezone_combo_entry")), Get_Time_Zone_String (our_info->timezone));

  if( our_info->cellular != NULL )
    gtk_entry_set_text (GTK_ENTRY (glade_xml_get_widget (our_info_xml, "cellular_entry")), our_info->cellular);

  if (our_info->birth_year != 0 && 
      our_info->birth_month != 0 && 
      our_info->birth_day != 0)
    {

      memset(&birthday_tm, 0 ,sizeof(struct tm));
      birthday_tm.tm_mday = our_info->birth_day;
      birthday_tm.tm_mon = our_info->birth_month;
      birthday_tm.tm_year = our_info->birth_year;

      gnome_date_edit_set_time(GNOME_DATE_EDIT(glade_xml_get_widget (our_info_xml, "birthday_dateedit")), mktime(&birthday_tm));


    }

  homeinfo_changed = FALSE;
  workinfo_changed = FALSE;
  moreinfo_changed = FALSE;
  about_changed    = FALSE;
  emails_changed   = FALSE;
  
}
