/************************************
 Contact detaching functions
 (c) 2002 Jeremy Wise
 GnomeICU
*************************************/

#include "common.h"
#include "detach.h"
#include "dragdrop.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "icons.h"
#include "msg.h"
#include "response.h"
#include "user_popup.h"
#include "util.h"

static gboolean
detach_window_click( GtkWidget *widget, GdkEventButton *event, CONTACT_PTR contact )
{
	GSList *contact_list = NULL;

	if( event == NULL )
	       return FALSE;

#ifdef TRACE_FUNCTION
	g_print( "detach_window_click\n" );
#endif

	if( event->type == GDK_KEY_PRESS )
	{
 		if( ((GdkEventKey*)event)->keyval != GDK_Return && ((GdkEventKey*)event)->keyval != ' ' )
			return FALSE;
	}
	else if( ( event->type == GDK_2BUTTON_PRESS && event->button != 1 ) ||
		 ( event->type == GDK_BUTTON_PRESS && event->button != 3 ) )
			return FALSE;

	/* Forge the current listbox according to user status */
	select_clist_row_from_contact( contact );

	if( ( event->type == GDK_BUTTON_PRESS && event->button == 3 ) ||
	    ( event->type == GDK_KEY_PRESS && ((GdkEventKey*)event)->keyval == ' ' ) )
	{
		GtkWidget *personal_menu;
		GdkEventButton *bevent = (GdkEventButton *) event;

		personal_menu = user_popup (contact);
		gtk_menu_popup( GTK_MENU( personal_menu ), NULL, NULL, NULL,
				NULL, bevent->button, bevent->time );
		return TRUE;
	}

	contact_list = g_slist_append( contact_list, contact );

	if( g_slist_length( contact->stored_messages ) )
		show_contact_message( contact_list );
	else
		open_message_dlg_with_message (contact->uin, NULL);

	g_slist_free (contact_list);
	
	return TRUE;
}

static gboolean
detach_window_delete( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	gtk_widget_hide( widget );
	return TRUE;
}

void detach_contact_hide( GtkWidget *widget, gpointer data )
{
    CONTACT_PTR contact = (CONTACT_PTR)data;

    if( !GTK_WIDGET_VISIBLE( contact->detached_window ) )
    {
        gtk_widget_show( GTK_WIDGET( contact->detached_window ) );
    }
    else
    {
        gtk_widget_hide( GTK_WIDGET( contact->detached_window ) );
    }
}

void detach_contact( GtkWidget *widget, gpointer data )
{
    // GSList *contact_list = get_contact_from_clist();
    CONTACT_PTR contact = (CONTACT_PTR)data;
    GnomeWinState state;
    GnomeWinHints hints;
    GtkWidget *window, *label, *hbox, *gtk_pixmap, *eventbox;
    gchar *title;

    if( GTK_IS_WIDGET( contact->detached_window ) ) return;

    window = gtk_window_new( GTK_WINDOW_DIALOG );
    gtk_window_set_wmclass( GTK_WINDOW( window ),
                            "Contact_Shortcut", "GnomeICU" );
    title = g_strdup_printf( _("%s status"), contact->nick );
    gtk_window_set_title( GTK_WINDOW( window ), title );
    g_free( title );
    contact->detached_window = window;

    eventbox = gtk_event_box_new();

    gtk_signal_connect( GTK_OBJECT( window ), "delete-event",
                        GTK_SIGNAL_FUNC( detach_window_delete ), NULL );
    gtk_signal_connect( GTK_OBJECT( eventbox ), "key-press-event",
                        GTK_SIGNAL_FUNC( detach_window_click ), contact );
    gtk_signal_connect( GTK_OBJECT( eventbox ), "button-press-event",
                        GTK_SIGNAL_FUNC( detach_window_click ), contact );
    gtk_container_add( GTK_CONTAINER( window ), eventbox );
    init_contact_list_drag_drop( eventbox );

    hbox = gtk_hbox_new( FALSE, 0 );
    gtk_pixmap = gtk_pixmap_new( icon_blank_pixmap, icon_blank_bitmap );
    gtk_box_pack_start( GTK_BOX( hbox ), gtk_pixmap, FALSE, FALSE, 0 );
    gtk_widget_show( gtk_pixmap );
    label = gtk_label_new( contact->nick );
    gtk_box_pack_end( GTK_BOX( hbox ), label, FALSE, FALSE, 0 );
    gtk_misc_set_padding( GTK_MISC( label ), 3, 0 );
    gtk_container_add( GTK_CONTAINER( eventbox ), hbox );

    gtk_object_set_data( GTK_OBJECT( window ), "pixmap", gtk_pixmap );

    gtk_widget_show_all( GTK_WIDGET( window ) );

    gnome_win_hints_set_layer( GTK_WIDGET( window ),
                               WIN_LAYER_ABOVE_DOCK );

    state = gnome_win_hints_get_state( GTK_WIDGET( window ) );
    state = state | WIN_STATE_STICKY;
    gnome_win_hints_set_state( GTK_WIDGET( window ), state );

    hints = gnome_win_hints_get_hints( GTK_WIDGET( window ) );
    hints = hints | WIN_HINTS_SKIP_TASKBAR | WIN_HINTS_SKIP_WINLIST;
    gnome_win_hints_set_hints( GTK_WIDGET( window ), hints );

    Shortcut_Update( contact );
}
