/**************************
 Main source file
 (c) 1999 Jeremy Wise
 GnomeICU
***************************/

#include "common.h"

#include "autohide.h"
#include "applet.h"
#include "dragdrop.h"
#include "flash.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "groups.h"
#include "gtkfunc.h"
#include "gtkconf.h"
#include "gtkspell.h"
#include "icons.h"
#include "showlist.h"
#include "tcp.h"
#include "userserver.h"
#include "util.h"
#include "v7login.h"
#include "v7newuser.h"
#include "v7send.h"

DWORD our_ip = 0x7f000001; /* localhost for some reason */
DWORD our_port = 0; /* the port to make tcp connections on */
DWORD our_sok; /* The TCP socket */
GSList *Contacts = NULL;
DWORD Current_Status=STATUS_OFFLINE;
gchar *passwd = NULL;
gchar *server = NULL;
DWORD remote_port;
gboolean Done_Login=FALSE;
gchar *Away_Message = NULL;
gboolean search_in_progress = FALSE;

BYTE chat_fg_red = 0, chat_fg_green = 0, chat_fg_blue = 0;
BYTE chat_bg_red = 255, chat_bg_green = 255, chat_bg_blue = 255;

GtkWidget *status_button = NULL;
GtkWidget *status_im = NULL;

gchar *configfilename = NULL;

USER_INFO_PTR our_info;

_toggles *toggles;
_programs *programs;

gboolean is_new_user = FALSE;

gint udp_gdk_input = 0;
gint tcp_gdk_input = 0;

gint WindowWidth = 160, WindowHeight = 310;
gint WindowX = 50, WindowY = 50;

_MainData *MainData;

GdkFont *ChatFont;
gchar *ChatFontString = NULL;

GtkWidget *app;

static char *cfnp, *cfnp1;

gboolean enable_online_events = FALSE;

GtkWidget *eyes_animated;
GtkWidget *eyes_still;

static char *ispell_cmd[] = { "ispell", "-a", NULL };

/* server side contacts list, read from pref */
gboolean srvlist_exist = FALSE;
guint32 list_time_stamp;
guint16 record_cnt;
guint16 status_uid;
gboolean sane_cl = FALSE;
GSList *Groups = NULL;

GnomeHelpMenuEntry help_ref = { "gnomeicu", "index.html" };

void source_drag_data_get (GtkWidget *widget, GdkDragContext *context,
                           GtkSelectionData *selection_data, guint info,
                           guint time, gpointer data);
void change_userwin (GtkWidget *widget, GtkNotebookPage *page, int num,
                     gpointer data );
void window_save_size (GtkWidget *widget, GdkEventConfigure *event,
                       gpointer user_data);
                                                                                        
                                                                                        
/*** Local function declarations ***/
static void broken_pipe (int);
static void child_died (int);

static void app_init (void);
static void userwin_online_settings (void);
static void userwin_offline_settings (void);
static void userwin_notinlist_settings (void);
gint strcoll_compare (GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2);



/*** Global functions ***/
void create_tcp_line( void )
{
	gint cx;
	struct sockaddr_in addr;
	gint temp_sok;
	gint l = 1;
	gboolean have_tcp_port = FALSE;

	if( our_sok )
		close( our_sok );

	for( cx = min_tcp_port; cx <= max_tcp_port; cx ++ )
	{
		addr.sin_addr.s_addr = g_htonl( INADDR_ANY );
		addr.sin_family = AF_INET;
		addr.sin_port = g_htons( cx );

		temp_sok = socket( AF_INET, SOCK_STREAM, 0 );
		setsockopt( temp_sok, SOL_SOCKET, SO_REUSEADDR, &l, 4 );

		our_sok = bind( temp_sok, (struct sockaddr *)&addr, sizeof( addr ) );
		if( our_sok != -1 )
			have_tcp_port = TRUE;
		else
			continue;

		our_sok = temp_sok;
		our_port = cx;

		if( -1 == listen( our_sok, 10 ) )
		  g_error( _("Cannot listen to socket, port %u\n"), our_port );

		l = sizeof( addr );

		gdk_input_remove( tcp_gdk_input );

		tcp_gdk_input = gdk_input_add( our_sok, GDK_INPUT_READ, (GdkInputFunction) TCPAcceptIncoming, NULL );

		g_free( our_info->ip );

		/* FIXME: this should be freed sometime */
		our_info->ip = g_strdup_printf( "%u.%u.%u.%u",
		         (BYTE) (our_ip >> 24),
		         (BYTE) (our_ip >> 16),
		         (BYTE) (our_ip >> 8),
		         (BYTE) (our_ip) );

		g_free( our_info->port );

		our_info->port = g_strdup_printf( "%u", our_port );
		break;
	}

	if( have_tcp_port == FALSE )
		g_error( g_strdup_printf( "No TCP port available between %d and %d.\n",
		                          min_tcp_port, max_tcp_port ) );
}

void ready_set( void )
{
	gchar *sts;
	GtkWidget *label;
	GtkWidget *pixmap;

#ifdef TRACE_FUNCTION
	g_print( "ready_set(%08x)\n", Current_Status );
#endif

	if( status_im != NULL )
		gtk_container_remove( GTK_CONTAINER( status_button ), status_im );

	status_im = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (status_im);

	pixmap = gtk_pixmap_new( get_pixmap_for_status( Current_Status ),
				 get_bitmap_for_status( Current_Status ) );
	gtk_widget_show (pixmap);
	gtk_box_pack_start (GTK_BOX (status_im), pixmap, FALSE, FALSE, 0);

	sts = g_strconcat( "  ", get_status_str( Current_Status ), NULL );
	/* If not connected, now it prints "Unknown", but should be */
	/*	sts = _("Not Connected");	*/

	label = gtk_label_new ( sts );
	g_free( sts );
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (status_im), label, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);

	gtk_container_add( GTK_CONTAINER( status_button ), status_im );
	gtk_widget_show( status_im );

	gtk_pixmap_set( GTK_PIXMAP( eyes_still ),
                        still_eyes_pixmap, still_eyes_bitmap );

	if( toggles->applet )
		applet_update( Current_Status, FALSE );
}

void create_animator (void)
{
    GtkWidget *hbox;
    gchar *str;

    hbox = glade_xml_get_widget (MainData->xml, "status_hbox");
    
    if( GTK_IS_WIDGET( eyes_animated ) )
    {
        gtk_widget_destroy( eyes_animated );
    }

    eyes_animated = gnome_animator_new_with_size( 29, 14 );
    gtk_box_pack_end( GTK_BOX( hbox ), eyes_animated, FALSE, FALSE, 0 );

    str = make_icon_path( "gnomeicu-animation.png" );
    gnome_animator_append_frames_from_file( GNOME_ANIMATOR( eyes_animated ),
                                            str, 0, 0, 100, 29 );
    g_free( str );
}

void window_save_size( GtkWidget *widget, GdkEventConfigure *event, gpointer data )
{
	WindowHeight = event->height;
	WindowWidth = event->width;

	WindowX = event->x;
	WindowY = event->y;
}

void init( void )
{
	static int flash_timeout_id = 0;
#ifdef TRACE_FUNCTION
	g_print( "init\n" );
#endif
	Done_Login = TRUE;

	if (!flash_timeout_id)
		flash_timeout_id = gtk_timeout_add( 500, (GtkFunction) flash_messages, NULL );
}

/*** Local functions ***/

/* Broken pipe catching function */
void broken_pipe (int sig_num)
{
  fprintf(stderr, _("gnomeicu: broken pipe (saving configuration)"));
  icq_quit (NULL, NULL);
}

/* Terminates defunct child processes */
void child_died (int sig_num)
{
  waitpid (-1, NULL, WNOHANG | WUNTRACED);
}

void userwin_online_settings (void)
{
	MainData->lb_userwin_online = glade_xml_get_widget (MainData->xml, "online_clist");
	gtk_clist_set_row_height( GTK_CLIST( MainData->lb_userwin_online ), 20 );
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_online), 0, 16);
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_online), 1, 10);

	MainData->head_online = glade_xml_get_widget (MainData->xml, "online_label");

	init_contact_list_drag_drop( MainData->lb_userwin_online );
	
	MainData->lb_userwin = MainData->lb_userwin_online;

	/* Sorting of userwin_online */
	gtk_clist_set_sort_column (GTK_CLIST (MainData->lb_userwin_online), 1);
        gtk_clist_set_compare_func(GTK_CLIST (MainData->lb_userwin_online),
                                       (GtkCListCompareFunc) strcoll_compare);
	/* FIXME: this method of sorting breaks everything
	 * (mostly kontakt->lb_index). Sorting should be done in
	 * Contacts/showlist.c::OnlineList level. Or connect to some signal
	 * here? */
	if (toggles->sort_contacts)
		gtk_clist_set_auto_sort (GTK_CLIST (MainData->lb_userwin_online), TRUE);
}

void userwin_offline_settings (void)
{
	MainData->lb_userwin_offline = glade_xml_get_widget (MainData->xml, "offline_clist");

	gtk_clist_set_row_height( GTK_CLIST( MainData->lb_userwin_offline ), 20 );
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_offline), 0, 16);
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_offline), 1, 10);

	MainData->head_offline = glade_xml_get_widget (MainData->xml, "offline_label");

	init_contact_list_drag_drop( MainData->lb_userwin_offline );
}

void userwin_notinlist_settings (void)
{
	MainData->not_contents = glade_xml_get_widget (MainData->xml, "not_contents");
	
	MainData->lb_userwin_notinlist = glade_xml_get_widget (MainData->xml, "notinlist_clist");

	gtk_clist_set_row_height( GTK_CLIST( MainData->lb_userwin_notinlist ), 20 );
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_notinlist), 0, 16);
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_notinlist), 1, 10);

	init_contact_list_drag_drop( MainData->lb_userwin_notinlist );

	MainData->head_notinlist = glade_xml_get_widget (MainData->xml, "notinlist_label");

	gtk_widget_hide (MainData->not_contents);
}

void app_init (void)
{
	GtkWidget *hbox;

	glade_gnome_init ();
	
	MainData->xml = glade_xml_new (GNOMEICU_GLADEDIR "main.glade", "app");
	if (!MainData->xml) {
		g_error ("Unable to load the interface: %s!", GNOMEICU_GLADEDIR "main.glade");
	}
	
	app = glade_xml_get_widget (MainData->xml, "app");
	gtk_window_set_default_size (GTK_WINDOW (app), WindowWidth, WindowHeight );
        /*	gtk_widget_set_uposition (app, WindowX, WindowY); */
        /*	gnome_app_create_menus (GNOME_APP (app), mainmenu); done by glade */

	MainData->window = app;
	MainData->notebook = glade_xml_get_widget (MainData->xml, "notebook");

	userwin_online_settings ();
	userwin_offline_settings ();
	userwin_notinlist_settings (); 

	if( toggles->applet == FALSE )
	{
		gtk_signal_connect( GTK_OBJECT( app ), "delete_event",
		                    GTK_SIGNAL_FUNC( icq_quit ), NULL );
		icons_init();
	}
	else
		gtk_signal_connect( GTK_OBJECT( app ), "delete_event",
		                    GTK_SIGNAL_FUNC( applet_hide_main ), 0 );

	if (toggles->autohide) {
		gtk_signal_connect( GTK_OBJECT (app), "focus_in_event",
				    GTK_SIGNAL_FUNC (stop_autohide_timeout_cb), NULL );

		gtk_signal_connect( GTK_OBJECT (app), "focus_out_event",
				    GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL );

		gtk_signal_connect( GTK_OBJECT (app), "expose_event",
				    GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL );

		autohide_cbs_are_connected = TRUE;
	}

	hbox = glade_xml_get_widget (MainData->xml, "status_hbox");

	status_button = gtk_button_new ();
	GTK_WIDGET_UNSET_FLAGS (status_button, GTK_CAN_FOCUS);
	gtk_button_set_relief (GTK_BUTTON (status_button), GTK_RELIEF_NONE);
	gtk_widget_show (status_button);
	gtk_box_pack_start (GTK_BOX (hbox), status_button, FALSE, TRUE, 0);

	gtk_signal_connect (GTK_OBJECT (status_button), "button_press_event",
	                    GTK_SIGNAL_FUNC (popup_status_menu), NULL );

	eyes_still = gtk_pixmap_new (still_eyes_pixmap, still_eyes_bitmap);
	gtk_widget_show (eyes_still);
	gtk_box_pack_end (GTK_BOX (hbox), eyes_still, FALSE, FALSE, 0);

	create_animator ();

        /* connect help here because libglade cant do it properly */
        gtk_signal_connect( GTK_OBJECT ( glade_xml_get_widget (MainData->xml,
                                                               "manual1")),
                            "activate",
                            GTK_SIGNAL_FUNC (gnome_help_display), &help_ref );
	
	glade_xml_signal_autoconnect (MainData->xml);

	init_colors();
	ready_set();
}

/*** MAIN function ***/
int main( int argc, char *argv[] )
{
	int cx;
	int l = 1;
	int temp_sok;
	struct sockaddr_in addr;

	GnomeClient *client;

	static struct poptOption arguments[] =
	{
		{"uin", 'u', POPT_ARG_STRING, &cfnp, 0, N_("Use the defined UIN"), N_("UIN")},
#ifdef BUILD_APPLET
		{"noapplet", 'a', POPT_ARG_NONE, 0, 0, N_("Startup without applet support"), NULL},
#else
		{"noapplet", 'a', POPT_ARG_NONE, 0, 0, N_("Compatibility with applet version (ignored)"), NULL},
                
#endif
		{"ipaddr", 'i', POPT_ARG_STRING, &cfnp1, 0, N_("Set IP address to send to ICQ"), N_("IP")},
		{NULL, 0, 0, NULL, 0, NULL, NULL}
	};

	GSList *contact;

	gboolean have_tcp_port = FALSE;

	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);

#ifdef HAVE_SOCKS5
	SOCKSinit(argv[0]);
#endif

	srand( time( NULL ) );

	our_info = g_new0( USER_INFO_STRUCT, 1 );
	our_info->country = 1; /* USA */

	toggles = g_new0( _toggles, 1 );
	programs = g_new0( _programs, 1 );
	MainData = g_new0 (_MainData, 1);

	configfilename = g_strdup( "/GnomeICU/" );

#ifdef BUILD_APPLET
	toggles->applet = TRUE;
#else
	toggles->applet = FALSE;
#endif

	/* We do this here now so we can call our init() function */
	/* right off the bat.  Otherwise we run into many issues  */
	for (cx = 0; cx < argc; cx++) {
		if (!strcmp (argv[cx], "-u") && argc > cx + 1) {
			g_free (configfilename);
			configfilename = g_strdup_printf ("/GnomeICU_%s/", argv[++cx]); /* RW: up the counter so we don't trip over it ourselves */
		}
#ifdef BUILD_APPLET
		if (!strcmp (argv[cx], "-a") || !strcmp (argv[cx], "--noapplet"))
			toggles->applet = FALSE;
		else
#endif
		/* RW: Set our_ip so that file transfers will work */
		if ((!strcmp (argv[cx], "-i") || !strcmp (argv[cx], "--ipaddr")) && argc > cx + 1) {
			int a,b,c,d;
			sscanf(argv[++cx],"%d.%d.%d.%d",&a,&b,&c,&d);
			our_ip = ((DWORD)(a)<<24) |
				 ((DWORD)(b)<<16) |
				 ((DWORD)(c)<<8) |
				 (DWORD)(d);
		}
	}

	Current_Status = STATUS_OFFLINE;

#ifdef BUILD_APPLET
	if (toggles->applet == TRUE) {
		applet_widget_init( PACKAGE, VERSION, argc, argv,
				    arguments, 0, NULL );
		Get_Unix_Config_Info();
		applet_create();
	} else
#endif
	{
		gnome_init_with_popt_table (PACKAGE, VERSION, argc, argv,
		                            arguments, 0, NULL);
		Get_Unix_Config_Info();
	}

	gnome_config_push_prefix( configfilename );

	if( toggles->check_spell )
		if (gtkspell_start(NULL, ispell_cmd) < 0)
			fprintf(stderr, "Unable to start ispell; spellchecking disabled.\n");

	/* These SIGPIPEs are irritating, catch them */
	signal(SIGPIPE, broken_pipe);
	/* Terminate defunct children */
	signal(SIGCHLD, child_died);

	if ( toggles->applet == FALSE )
	{
		client = gnome_master_client();
		gtk_signal_connect( GTK_OBJECT( client ), "die",
		                    GTK_SIGNAL_FUNC( icq_quit ),
		                    NULL );

		gtk_signal_connect( GTK_OBJECT ( client ), "save_yourself",
		                    GTK_SIGNAL_FUNC(app_save_state_cb),
		                    (gpointer)argv[0]);
	}

	/* These two lines are needed for imlib to work properly */
	gtk_widget_push_visual(gdk_imlib_get_visual());
	gtk_widget_push_colormap(gdk_imlib_get_colormap());

#ifdef GNOME_ICON
	gnome_window_icon_set_default_from_file( GNOMEICU_DATADIR "/pixmaps/gnome-gnomeicu.xpm" );
#endif

	app_init ();

	/* FIXME: is this assignment needed? it is done several times in other
	 * places */
	contact = Contacts;

	while( contact != NULL )
	{
		kontakt->icon_p = icon_offline_pixmap;
		kontakt->icon_b = icon_offline_bitmap;
		contact = contact->next;
	}

	Show_Quick_Status();

	if( toggles->applet == FALSE || toggles->show_window)
		gtk_widget_show(app);

	while( gtk_events_pending() )
		gtk_main_iteration();


	/*

	Direct connection disabled because it is broken

	for( cx = min_tcp_port; cx <= max_tcp_port; cx ++ )
	{
		addr.sin_addr.s_addr = g_htonl( INADDR_ANY );
		addr.sin_family = AF_INET;
		addr.sin_port = g_htons( cx );

		temp_sok = socket( AF_INET, SOCK_STREAM, 0 );
		setsockopt( temp_sok, SOL_SOCKET, SO_REUSEADDR, &l, 4 );

		our_sok = bind( temp_sok, (struct sockaddr *)&addr, sizeof( addr ) );
		if( our_sok != -1 )
			have_tcp_port = TRUE;
		else
			continue;

		our_sok = temp_sok;
		our_port = cx;

		if( -1 == listen( our_sok, 10 ) )
		  g_error( _("Cannot listen to socket, port %u\n"), our_port );

		l = sizeof( addr );

		tcp_gdk_input = gdk_input_add( our_sok, GDK_INPUT_READ, (GdkInputFunction) TCPAcceptIncoming, NULL );

		our_info->ip = g_strdup_printf( "%u.%u.%u.%u",
		         (BYTE) (our_ip >> 24),
		         (BYTE) (our_ip >> 16),
		         (BYTE) (our_ip >> 8),
		         (BYTE) (our_ip) );

		our_info->port = g_strdup_printf( "%u", our_port );
		break;
	}

	if( have_tcp_port == FALSE )
		g_error( g_strdup_printf( "No TCP port available between %d and %d.\n",
		                          min_tcp_port, max_tcp_port ) );

	*/

        if ( is_new_user)
          v7_new_user(passwd);
        else
          if ( toggles->connect_startup )
            v7_new_login_session();  

	/* bootup unix socket */
	userserver_init();
        gnome_win_hints_init();

#ifdef BUILD_APPLET
	if( toggles->applet )
	{
		applet_update( STATUS_OFFLINE, FALSE );
		applet_widget_gtk_main();
	}
	else
#endif
		gtk_main();

	/* shutdown unix socket */
	userserver_kill();


        v7_quit();
	return 0;
}

void
source_drag_data_get  (GtkWidget	*widget, GdkDragContext *context,
                       GtkSelectionData *selection_data, guint info,
                       guint time, gpointer data)
{
	gchar *str;
	GSList *contact;

	contact = get_contact_from_clist();
	if( contact == NULL )
		return;

	str = g_strdup_printf( "%d\n%s", kontakt->uin,
	                       kontakt->nick );
	gtk_selection_data_set( selection_data,
	                        selection_data->target,
	                        8, str, strlen( str ) );
	g_free( str );
}

void change_userwin( GtkWidget *widget, GtkNotebookPage *page, int num,
                     gpointer data )
{
	if( num == 0 )
		MainData->lb_userwin = MainData->lb_userwin_online;
	else if( num == 1 )
		MainData->lb_userwin = MainData->lb_userwin_offline;
	else if( num == 2 )
		MainData->lb_userwin = MainData->lb_userwin_notinlist;
}

void about( GtkWidget *widget, gpointer data )
{
	GtkWidget *about;
	const gchar *authors[] =
	{
		"Jeremy Wise <jwise@pathwaynet.com> (jwise)",
		"Olivier Crete <tester@videotron.ca> (Tester)",
		"Patrick Sung <phsung@ualberta.ca> (Panda Monster)",
		"David Tabachnikov <captain@bezeqint.net> (nethunter)",
		"Gediminas Paulauskas <menesis@delfi.lt> (menesis)",
		NULL
	};

	about = gnome_about_new( "GnomeICU", VERSION,
				/* Translators: Please change the (C) to a real
                         	 * copyright character if your character set
				 * allows it (Hint: iso-8859-1 is one of the
				 * character sets that has this symbol). */
	                         _("(C) 1999-2001 Jeremy Wise"),
	                         authors,
	                         _("GnomeICU is a small, fast and functional "
	                         "clone of Mirabilis' ICQ program, specifically "
	                         "designed for Linux and X."),
	                         NULL );

	gtk_widget_show( about );

	return;
}
void go_url_home (void)
{
	gnome_url_show ("http://gnomeicu.sourceforge.net/index.php");
}

void go_url_updates (void)
{
	gnome_url_show ("http://gnomeicu.sourceforge.net/updates.php");
}

gint strcoll_compare (GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2)
{
  const GtkCListRow *row1 = (const GtkCListRow *) ptr1;
  const GtkCListRow *row2 = (const GtkCListRow *) ptr2;
  gchar *text1;
  gchar *text2;
  
  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;

  return strcoll(text1, text2);

}

void icq_quit( GtkWidget *widget, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "icq_quit\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( kontakt->sok > 0 )
			close( kontakt->sok );
/*		if( kontakt->chat_sok > 0 )
			close( kontakt->chat_sok );
   HERE.. QUIT CLOSE	        */
		contact = contact->next;
	}

	if( MainData->window != NULL && GTK_WIDGET_VISIBLE( MainData->window ) ) {
		gdk_window_get_size( GTK_WIDGET( MainData->window )->window,
		                     &WindowWidth,
		                     &WindowHeight );
/*		gdk_window_get_position (GTK_WIDGET (MainData->window)->window,
		                     &WindowX,
	                             &WindowY);*/
	}
	gtk_object_unref (GTK_OBJECT(MainData->xml));
        gtkspell_stop();

	Save_RC();
#ifdef HAVE_ICUDB
	icudb_close_all();
#endif

#ifdef BUILD_APPLET
	if( toggles->applet ) {
		applet_remove();
		applet_widget_gtk_main_quit();
	}
	else
#endif
		gtk_main_quit();
}
